/*
 * Apache Iceberg REST Catalog API
 *
 * Defines the specification for the first version of the REST Catalog API. Implementations should ideally support both Iceberg table specs v1 and v2, with priority given to v2.
 *
 * The version of the OpenAPI document: 0.0.1
 *
 * Generated by: https://openapi-generator.tech
 */

use serde::{Deserialize, Serialize};

use crate::models;

#[derive(Clone, Default, Debug, PartialEq, Serialize, Deserialize)]
pub struct PartitionField {
    #[serde(rename = "field-id", skip_serializing_if = "Option::is_none")]
    pub field_id: Option<i32>,
    #[serde(rename = "source-id")]
    pub source_id: i32,
    #[serde(rename = "name")]
    pub name: String,
    #[serde(rename = "transform")]
    pub transform: String,
}

impl PartitionField {
    pub fn new(source_id: i32, name: String, transform: String) -> PartitionField {
        PartitionField {
            field_id: None,
            source_id,
            name,
            transform,
        }
    }
}
