/*
 * Apache Iceberg REST Catalog API
 *
 * Defines the specification for the first version of the REST Catalog API. Implementations should ideally support both Iceberg table specs v1 and v2, with priority given to v2.
 *
 * The version of the OpenAPI document: 0.0.1
 *
 * Generated by: https://openapi-generator.tech
 */

use serde::{Deserialize, Serialize};

use crate::models;

#[derive(Clone, Default, Debug, PartialEq, Serialize, Deserialize)]
pub struct PlanTableScanRequest {
    /// Identifier for the snapshot to scan in a point-in-time scan
    #[serde(rename = "snapshot-id", skip_serializing_if = "Option::is_none")]
    pub snapshot_id: Option<i64>,
    /// List of selected schema fields
    #[serde(rename = "select", skip_serializing_if = "Option::is_none")]
    pub select: Option<Vec<String>>,
    /// Expression used to filter the table data
    #[serde(rename = "filter", skip_serializing_if = "Option::is_none")]
    pub filter: Option<Box<models::Expression>>,
    /// Enables case sensitive field matching for filter and select
    #[serde(rename = "case-sensitive", skip_serializing_if = "Option::is_none")]
    pub case_sensitive: Option<bool>,
    /// Whether to use the schema at the time the snapshot was written. When time travelling, the snapshot schema should be used (true). When scanning a branch, the table schema should be used (false).
    #[serde(
        rename = "use-snapshot-schema",
        skip_serializing_if = "Option::is_none"
    )]
    pub use_snapshot_schema: Option<bool>,
    /// Starting snapshot ID for an incremental scan (exclusive)
    #[serde(rename = "start-snapshot-id", skip_serializing_if = "Option::is_none")]
    pub start_snapshot_id: Option<i64>,
    /// Ending snapshot ID for an incremental scan (inclusive). Required when start-snapshot-id is specified.
    #[serde(rename = "end-snapshot-id", skip_serializing_if = "Option::is_none")]
    pub end_snapshot_id: Option<i64>,
    /// List of fields for which the service should send column stats.
    #[serde(rename = "stats-fields", skip_serializing_if = "Option::is_none")]
    pub stats_fields: Option<Vec<String>>,
}

impl PlanTableScanRequest {
    pub fn new() -> PlanTableScanRequest {
        PlanTableScanRequest {
            snapshot_id: None,
            select: None,
            filter: None,
            case_sensitive: None,
            use_snapshot_schema: None,
            start_snapshot_id: None,
            end_snapshot_id: None,
            stats_fields: None,
        }
    }
}
