/*
 * Apache Iceberg REST Catalog API
 *
 * Defines the specification for the first version of the REST Catalog API. Implementations should ideally support both Iceberg table specs v1 and v2, with priority given to v2.
 *
 * The version of the OpenAPI document: 0.0.1
 *
 * Generated by: https://openapi-generator.tech
 */

use serde::{Deserialize, Serialize};

use crate::models;

/// PlanTableScanResult : Result of server-side scan planning for planTableScan
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
#[serde(tag = "status")]
pub enum PlanTableScanResult {
    #[serde(rename = "completed")]
    Completed(Box<models::CompletedPlanningWithIdResult>),
    #[serde(rename = "failed")]
    Failed(Box<models::FailedPlanningResult>),
    #[serde(rename = "submitted")]
    Submitted(Box<models::AsyncPlanningResult>),
    #[serde(rename = "cancelled")]
    Cancelled(Box<models::EmptyPlanningResult>),
}

impl Default for PlanTableScanResult {
    fn default() -> Self {
        Self::Completed(Default::default())
    }
}
