/*
 * Apache Iceberg REST Catalog API
 *
 * Defines the specification for the first version of the REST Catalog API. Implementations should ideally support both Iceberg table specs v1 and v2, with priority given to v2.
 *
 * The version of the OpenAPI document: 0.0.1
 *
 * Generated by: https://openapi-generator.tech
 */

use serde::{Deserialize, Serialize};

use crate::models;

#[derive(Clone, Default, Debug, PartialEq, Serialize, Deserialize)]
pub struct RegisterTableRequest {
    #[serde(rename = "name")]
    pub name: String,
    #[serde(rename = "metadata-location")]
    pub metadata_location: String,
    /// Whether to overwrite table metadata if the table already exists
    #[serde(rename = "overwrite", skip_serializing_if = "Option::is_none")]
    pub overwrite: Option<bool>,
}

impl RegisterTableRequest {
    pub fn new(name: String, metadata_location: String) -> RegisterTableRequest {
        RegisterTableRequest {
            name,
            metadata_location,
            overwrite: None,
        }
    }
}
