/*
 * Apache Iceberg REST Catalog API
 *
 * Defines the specification for the first version of the REST Catalog API. Implementations should ideally support both Iceberg table specs v1 and v2, with priority given to v2.
 *
 * The version of the OpenAPI document: 0.0.1
 *
 * Generated by: https://openapi-generator.tech
 */

use serde::{Deserialize, Serialize};

use crate::models;

#[derive(Clone, Default, Debug, PartialEq, Serialize, Deserialize)]
pub struct ReportMetricsRequest {
    #[serde(rename = "report-type")]
    pub report_type: String,
    #[serde(rename = "table-name")]
    pub table_name: String,
    #[serde(rename = "snapshot-id")]
    pub snapshot_id: i64,
    #[serde(rename = "filter")]
    pub filter: Box<models::Expression>,
    #[serde(rename = "schema-id")]
    pub schema_id: i32,
    #[serde(rename = "projected-field-ids")]
    pub projected_field_ids: Vec<i32>,
    #[serde(rename = "projected-field-names")]
    pub projected_field_names: Vec<String>,
    #[serde(rename = "metrics")]
    pub metrics: std::collections::HashMap<String, models::MetricResult>,
    #[serde(rename = "metadata", skip_serializing_if = "Option::is_none")]
    pub metadata: Option<std::collections::HashMap<String, String>>,
    #[serde(rename = "sequence-number")]
    pub sequence_number: i64,
    #[serde(rename = "operation")]
    pub operation: String,
}

impl ReportMetricsRequest {
    pub fn new(
        report_type: String,
        table_name: String,
        snapshot_id: i64,
        filter: models::Expression,
        schema_id: i32,
        projected_field_ids: Vec<i32>,
        projected_field_names: Vec<String>,
        metrics: std::collections::HashMap<String, models::MetricResult>,
        sequence_number: i64,
        operation: String,
    ) -> ReportMetricsRequest {
        ReportMetricsRequest {
            report_type,
            table_name,
            snapshot_id,
            filter: Box::new(filter),
            schema_id,
            projected_field_ids,
            projected_field_names,
            metrics,
            metadata: None,
            sequence_number,
            operation,
        }
    }
}
