/*
 * Apache Iceberg REST Catalog API
 *
 * Defines the specification for the first version of the REST Catalog API. Implementations should ideally support both Iceberg table specs v1 and v2, with priority given to v2.
 *
 * The version of the OpenAPI document: 0.0.1
 *
 * Generated by: https://openapi-generator.tech
 */

use serde::{Deserialize, Serialize};

use crate::models;

/// ScanTasks : Scan and planning tasks for server-side scan planning  - `plan-tasks` contains opaque units of planning work - `file-scan-tasks` contains a partial or complete list of table scan tasks - `delete-files` contains delete files referenced by file scan tasks  Each plan task must be passed to the fetchScanTasks endpoint to fetch the file scan tasks for the plan task.  The list of delete files must contain all delete files referenced by the file scan tasks.
#[derive(Clone, Default, Debug, PartialEq, Serialize, Deserialize)]
pub struct ScanTasks {
    /// Delete files referenced by file scan tasks
    #[serde(rename = "delete-files", skip_serializing_if = "Option::is_none")]
    pub delete_files: Option<Vec<models::DeleteFile>>,
    #[serde(rename = "file-scan-tasks", skip_serializing_if = "Option::is_none")]
    pub file_scan_tasks: Option<Vec<models::FileScanTask>>,
    #[serde(rename = "plan-tasks", skip_serializing_if = "Option::is_none")]
    pub plan_tasks: Option<Vec<String>>,
}

impl ScanTasks {
    /// Scan and planning tasks for server-side scan planning  - `plan-tasks` contains opaque units of planning work - `file-scan-tasks` contains a partial or complete list of table scan tasks - `delete-files` contains delete files referenced by file scan tasks  Each plan task must be passed to the fetchScanTasks endpoint to fetch the file scan tasks for the plan task.  The list of delete files must contain all delete files referenced by the file scan tasks.
    pub fn new() -> ScanTasks {
        ScanTasks {
            delete_files: None,
            file_scan_tasks: None,
            plan_tasks: None,
        }
    }
}
