/*
 * Apache Iceberg REST Catalog API
 *
 * Defines the specification for the first version of the REST Catalog API. Implementations should ideally support both Iceberg table specs v1 and v2, with priority given to v2.
 *
 * The version of the OpenAPI document: 0.0.1
 *
 * Generated by: https://openapi-generator.tech
 */

use sail_iceberg::NestedFieldRef;
use serde::{Deserialize, Serialize};

use crate::models;

/// Ref: https://iceberg.apache.org/javadoc/latest/org/apache/iceberg/Schema.html
#[derive(Clone, Default, Debug, PartialEq, Serialize, Deserialize)]
pub struct Schema {
    #[serde(rename = "type")]
    pub r#type: Type,
    #[serde(rename = "fields")]
    pub fields: Vec<NestedFieldRef>,
    #[serde(rename = "schema-id", skip_serializing_if = "Option::is_none")]
    pub schema_id: Option<i32>,
    // Identifier is a concept similar to primary key in a relational database system.
    // It consists of a unique set of primitive fields in the schema.
    // An identifier field must be at root, or nested in a chain of structs (no maps or lists).
    // A row should be unique in a table based on the values of the identifier fields.
    // Optional, float and double columns cannot be used as identifier fields.
    // However, Iceberg identifier differs from primary key in the following ways:
    //   - Iceberg does not enforce the uniqueness of a row based on this identifier information.
    //     It is used for operations like upsert to define the default upsert key.
    //   - A nested field in a struct can be used as an identifier.
    //     For example, if there is a "last_name" field inside a "user" struct in a schema,
    //     field "user.last_name" can be set as a part of the identifier field.
    #[serde(
        rename = "identifier-field-ids",
        skip_serializing_if = "Option::is_none"
    )]
    pub identifier_field_ids: Option<Vec<i32>>,
}

impl Schema {
    pub fn new(r#type: Type, fields: Vec<NestedFieldRef>) -> Schema {
        Schema {
            r#type,
            fields,
            schema_id: None,
            identifier_field_ids: None,
        }
    }
}
///
#[derive(Clone, Copy, Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Serialize, Deserialize)]
pub enum Type {
    #[serde(rename = "struct")]
    Struct,
}

impl Default for Type {
    fn default() -> Type {
        Self::Struct
    }
}
