/*
 * Apache Iceberg REST Catalog API
 *
 * Defines the specification for the first version of the REST Catalog API. Implementations should ideally support both Iceberg table specs v1 and v2, with priority given to v2.
 *
 * The version of the OpenAPI document: 0.0.1
 *
 * Generated by: https://openapi-generator.tech
 */

use serde::{Deserialize, Serialize};

use crate::models;

#[derive(Clone, Default, Debug, PartialEq, Serialize, Deserialize)]
pub struct SetSnapshotRefUpdate {
    #[serde(rename = "action", skip_serializing_if = "Option::is_none")]
    pub action: Option<String>,
    #[serde(rename = "ref-name")]
    pub ref_name: String,
    #[serde(rename = "type")]
    pub r#type: Type,
    #[serde(rename = "snapshot-id")]
    pub snapshot_id: i64,
    #[serde(rename = "max-ref-age-ms", skip_serializing_if = "Option::is_none")]
    pub max_ref_age_ms: Option<i64>,
    #[serde(
        rename = "max-snapshot-age-ms",
        skip_serializing_if = "Option::is_none"
    )]
    pub max_snapshot_age_ms: Option<i64>,
    #[serde(
        rename = "min-snapshots-to-keep",
        skip_serializing_if = "Option::is_none"
    )]
    pub min_snapshots_to_keep: Option<i32>,
}

impl SetSnapshotRefUpdate {
    pub fn new(ref_name: String, r#type: Type, snapshot_id: i64) -> SetSnapshotRefUpdate {
        SetSnapshotRefUpdate {
            action: None,
            ref_name,
            r#type,
            snapshot_id,
            max_ref_age_ms: None,
            max_snapshot_age_ms: None,
            min_snapshots_to_keep: None,
        }
    }
}
///
#[derive(Clone, Copy, Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Serialize, Deserialize)]
pub enum Type {
    #[serde(rename = "tag")]
    Tag,
    #[serde(rename = "branch")]
    Branch,
}

impl Default for Type {
    fn default() -> Type {
        Self::Tag
    }
}
