/*
 * Apache Iceberg REST Catalog API
 *
 * Defines the specification for the first version of the REST Catalog API. Implementations should ideally support both Iceberg table specs v1 and v2, with priority given to v2.
 *
 * The version of the OpenAPI document: 0.0.1
 *
 * Generated by: https://openapi-generator.tech
 */

use serde::{Deserialize, Serialize};

use crate::models;

#[derive(Clone, Default, Debug, PartialEq, Serialize, Deserialize)]
pub struct SetStatisticsUpdate {
    #[serde(rename = "action", skip_serializing_if = "Option::is_none")]
    pub action: Option<String>,
    /// This optional field is **DEPRECATED for REMOVAL** since it contains redundant information. Clients should use the `statistics.snapshot-id` field instead.
    #[serde(rename = "snapshot-id", skip_serializing_if = "Option::is_none")]
    pub snapshot_id: Option<i64>,
    #[serde(rename = "statistics")]
    pub statistics: Box<models::StatisticsFile>,
}

impl SetStatisticsUpdate {
    pub fn new(statistics: models::StatisticsFile) -> SetStatisticsUpdate {
        SetStatisticsUpdate {
            action: None,
            snapshot_id: None,
            statistics: Box::new(statistics),
        }
    }
}
