/*
 * Apache Iceberg REST Catalog API
 *
 * Defines the specification for the first version of the REST Catalog API. Implementations should ideally support both Iceberg table specs v1 and v2, with priority given to v2.
 *
 * The version of the OpenAPI document: 0.0.1
 *
 * Generated by: https://openapi-generator.tech
 */

use serde::{Deserialize, Serialize};

use crate::models;

#[derive(Clone, Default, Debug, PartialEq, Serialize, Deserialize)]
pub struct Snapshot {
    #[serde(rename = "snapshot-id")]
    pub snapshot_id: i64,
    #[serde(rename = "parent-snapshot-id", skip_serializing_if = "Option::is_none")]
    pub parent_snapshot_id: Option<i64>,
    #[serde(rename = "sequence-number", skip_serializing_if = "Option::is_none")]
    pub sequence_number: Option<i64>,
    #[serde(rename = "timestamp-ms")]
    pub timestamp_ms: i64,
    /// Location of the snapshot's manifest list file
    #[serde(rename = "manifest-list")]
    pub manifest_list: String,
    /// The first _row_id assigned to the first row in the first data file in the first manifest
    #[serde(rename = "first-row-id", skip_serializing_if = "Option::is_none")]
    pub first_row_id: Option<i64>,
    /// The upper bound of the number of rows with assigned row IDs
    #[serde(rename = "added-rows", skip_serializing_if = "Option::is_none")]
    pub added_rows: Option<i64>,
    #[serde(rename = "summary")]
    pub summary: models::SnapshotSummary,
    #[serde(rename = "schema-id", skip_serializing_if = "Option::is_none")]
    pub schema_id: Option<i32>,
}

impl Snapshot {
    pub fn new(
        snapshot_id: i64,
        timestamp_ms: i64,
        manifest_list: String,
        summary: models::SnapshotSummary,
    ) -> Snapshot {
        Snapshot {
            snapshot_id,
            parent_snapshot_id: None,
            sequence_number: None,
            timestamp_ms,
            manifest_list,
            first_row_id: None,
            added_rows: None,
            summary,
            schema_id: None,
        }
    }
}
