/*
 * Apache Iceberg REST Catalog API
 *
 * Defines the specification for the first version of the REST Catalog API. Implementations should ideally support both Iceberg table specs v1 and v2, with priority given to v2.
 *
 * The version of the OpenAPI document: 0.0.1
 *
 * Generated by: https://openapi-generator.tech
 */

use serde::{Deserialize, Serialize};

use crate::models;

#[derive(Clone, Default, Debug, PartialEq, Serialize, Deserialize)]
pub struct SnapshotSummary {
    #[serde(rename = "operation")]
    pub operation: Operation,
}

impl SnapshotSummary {
    pub fn new(operation: Operation) -> SnapshotSummary {
        SnapshotSummary { operation }
    }
}
///
#[derive(Clone, Copy, Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Serialize, Deserialize)]
pub enum Operation {
    #[serde(rename = "append")]
    Append,
    #[serde(rename = "replace")]
    Replace,
    #[serde(rename = "overwrite")]
    Overwrite,
    #[serde(rename = "delete")]
    Delete,
}

impl Default for Operation {
    fn default() -> Operation {
        Self::Append
    }
}
