/*
 * Apache Iceberg REST Catalog API
 *
 * Defines the specification for the first version of the REST Catalog API. Implementations should ideally support both Iceberg table specs v1 and v2, with priority given to v2.
 *
 * The version of the OpenAPI document: 0.0.1
 *
 * Generated by: https://openapi-generator.tech
 */

use serde::{Deserialize, Serialize};

use crate::models;

#[derive(Clone, Default, Debug, PartialEq, Serialize, Deserialize)]
pub struct SortField {
    #[serde(rename = "source-id")]
    pub source_id: i32,
    #[serde(rename = "transform")]
    pub transform: String,
    #[serde(rename = "direction")]
    pub direction: models::SortDirection,
    #[serde(rename = "null-order")]
    pub null_order: models::NullOrder,
}

impl SortField {
    pub fn new(
        source_id: i32,
        transform: String,
        direction: models::SortDirection,
        null_order: models::NullOrder,
    ) -> SortField {
        SortField {
            source_id,
            transform,
            direction,
            null_order,
        }
    }
}
