/*
 * Apache Iceberg REST Catalog API
 *
 * Defines the specification for the first version of the REST Catalog API. Implementations should ideally support both Iceberg table specs v1 and v2, with priority given to v2.
 *
 * The version of the OpenAPI document: 0.0.1
 *
 * Generated by: https://openapi-generator.tech
 */

use serde::{Deserialize, Serialize};

use crate::models;

#[derive(Clone, Default, Debug, PartialEq, Serialize, Deserialize)]
pub struct TableMetadata {
    #[serde(rename = "format-version")]
    pub format_version: i32,
    #[serde(rename = "table-uuid")]
    pub table_uuid: String,
    #[serde(rename = "location", skip_serializing_if = "Option::is_none")]
    pub location: Option<String>,
    #[serde(rename = "last-updated-ms", skip_serializing_if = "Option::is_none")]
    pub last_updated_ms: Option<i64>,
    /// A long higher than all assigned row IDs; the next snapshot's first-row-id.
    #[serde(rename = "next-row-id", skip_serializing_if = "Option::is_none")]
    pub next_row_id: Option<i64>,
    #[serde(rename = "properties", skip_serializing_if = "Option::is_none")]
    pub properties: Option<std::collections::HashMap<String, String>>,
    #[serde(rename = "schemas", skip_serializing_if = "Option::is_none")]
    pub schemas: Option<Vec<models::Schema>>,
    #[serde(rename = "current-schema-id", skip_serializing_if = "Option::is_none")]
    pub current_schema_id: Option<i32>,
    #[serde(rename = "last-column-id", skip_serializing_if = "Option::is_none")]
    pub last_column_id: Option<i32>,
    #[serde(rename = "partition-specs", skip_serializing_if = "Option::is_none")]
    pub partition_specs: Option<Vec<models::PartitionSpec>>,
    #[serde(rename = "default-spec-id", skip_serializing_if = "Option::is_none")]
    pub default_spec_id: Option<i32>,
    #[serde(rename = "last-partition-id", skip_serializing_if = "Option::is_none")]
    pub last_partition_id: Option<i32>,
    #[serde(rename = "sort-orders", skip_serializing_if = "Option::is_none")]
    pub sort_orders: Option<Vec<models::SortOrder>>,
    #[serde(
        rename = "default-sort-order-id",
        skip_serializing_if = "Option::is_none"
    )]
    pub default_sort_order_id: Option<i32>,
    #[serde(rename = "encryption-keys", skip_serializing_if = "Option::is_none")]
    pub encryption_keys: Option<Vec<models::EncryptedKey>>,
    #[serde(rename = "snapshots", skip_serializing_if = "Option::is_none")]
    pub snapshots: Option<Vec<models::Snapshot>>,
    #[serde(rename = "refs", skip_serializing_if = "Option::is_none")]
    pub refs: Option<std::collections::HashMap<String, models::SnapshotReference>>,
    #[serde(
        rename = "current-snapshot-id",
        skip_serializing_if = "Option::is_none"
    )]
    pub current_snapshot_id: Option<i64>,
    #[serde(
        rename = "last-sequence-number",
        skip_serializing_if = "Option::is_none"
    )]
    pub last_sequence_number: Option<i64>,
    #[serde(rename = "snapshot-log", skip_serializing_if = "Option::is_none")]
    pub snapshot_log: Option<Vec<models::SnapshotLogInner>>,
    #[serde(rename = "metadata-log", skip_serializing_if = "Option::is_none")]
    pub metadata_log: Option<Vec<models::MetadataLogInner>>,
    #[serde(rename = "statistics", skip_serializing_if = "Option::is_none")]
    pub statistics: Option<Vec<models::StatisticsFile>>,
    #[serde(
        rename = "partition-statistics",
        skip_serializing_if = "Option::is_none"
    )]
    pub partition_statistics: Option<Vec<models::PartitionStatisticsFile>>,
}

impl TableMetadata {
    pub fn new(format_version: i32, table_uuid: String) -> TableMetadata {
        TableMetadata {
            format_version,
            table_uuid,
            location: None,
            last_updated_ms: None,
            next_row_id: None,
            properties: None,
            schemas: None,
            current_schema_id: None,
            last_column_id: None,
            partition_specs: None,
            default_spec_id: None,
            last_partition_id: None,
            sort_orders: None,
            default_sort_order_id: None,
            encryption_keys: None,
            snapshots: None,
            refs: None,
            current_snapshot_id: None,
            last_sequence_number: None,
            snapshot_log: None,
            metadata_log: None,
            statistics: None,
            partition_statistics: None,
        }
    }
}
