/*
 * Apache Iceberg REST Catalog API
 *
 * Defines the specification for the first version of the REST Catalog API. Implementations should ideally support both Iceberg table specs v1 and v2, with priority given to v2.
 *
 * The version of the OpenAPI document: 0.0.1
 *
 * Generated by: https://openapi-generator.tech
 */

use serde::{Deserialize, Serialize};

use crate::models;

#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
#[serde(tag = "type")]
pub enum TableRequirement {
    #[serde(rename = "assert-create")]
    AssertCreate {},
    #[serde(rename = "assert-current-schema-id")]
    AssertCurrentSchemaId {},
    #[serde(rename = "assert-default-sort-order-id")]
    AssertDefaultSortOrderId {},
    #[serde(rename = "assert-default-spec-id")]
    AssertDefaultSpecId {},
    #[serde(rename = "assert-last-assigned-field-id")]
    AssertLastAssignedFieldId {},
    #[serde(rename = "assert-last-assigned-partition-id")]
    AssertLastAssignedPartitionId {},
    #[serde(rename = "assert-ref-snapshot-id")]
    AssertRefSnapshotId {},
    #[serde(rename = "assert-table-uuid")]
    AssertTableUuid {},
}

impl Default for TableRequirement {
    fn default() -> Self {
        Self::AssertCreate {}
    }
}
