/*
 * Apache Iceberg REST Catalog API
 *
 * Defines the specification for the first version of the REST Catalog API. Implementations should ideally support both Iceberg table specs v1 and v2, with priority given to v2.
 *
 * The version of the OpenAPI document: 0.0.1
 *
 * Generated by: https://openapi-generator.tech
 */

use serde::{Deserialize, Serialize};

use crate::models;

/// TokenType : Token type identifier, from RFC 8693 Section 3  See https://datatracker.ietf.org/doc/html/rfc8693#section-3
/// Token type identifier, from RFC 8693 Section 3  See https://datatracker.ietf.org/doc/html/rfc8693#section-3
#[derive(Clone, Copy, Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Serialize, Deserialize)]
pub enum TokenType {
    #[serde(rename = "urn:ietf:params:oauth:token-type:access_token")]
    UrnColonIetfColonParamsColonOauthColonTokenTypeColonAccessToken,
    #[serde(rename = "urn:ietf:params:oauth:token-type:refresh_token")]
    UrnColonIetfColonParamsColonOauthColonTokenTypeColonRefreshToken,
    #[serde(rename = "urn:ietf:params:oauth:token-type:id_token")]
    UrnColonIetfColonParamsColonOauthColonTokenTypeColonIdToken,
    #[serde(rename = "urn:ietf:params:oauth:token-type:saml1")]
    UrnColonIetfColonParamsColonOauthColonTokenTypeColonSaml1,
    #[serde(rename = "urn:ietf:params:oauth:token-type:saml2")]
    UrnColonIetfColonParamsColonOauthColonTokenTypeColonSaml2,
    #[serde(rename = "urn:ietf:params:oauth:token-type:jwt")]
    UrnColonIetfColonParamsColonOauthColonTokenTypeColonJwt,
}

impl std::fmt::Display for TokenType {
    fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
        match self {
            Self::UrnColonIetfColonParamsColonOauthColonTokenTypeColonAccessToken => {
                write!(f, "urn:ietf:params:oauth:token-type:access_token")
            }
            Self::UrnColonIetfColonParamsColonOauthColonTokenTypeColonRefreshToken => {
                write!(f, "urn:ietf:params:oauth:token-type:refresh_token")
            }
            Self::UrnColonIetfColonParamsColonOauthColonTokenTypeColonIdToken => {
                write!(f, "urn:ietf:params:oauth:token-type:id_token")
            }
            Self::UrnColonIetfColonParamsColonOauthColonTokenTypeColonSaml1 => {
                write!(f, "urn:ietf:params:oauth:token-type:saml1")
            }
            Self::UrnColonIetfColonParamsColonOauthColonTokenTypeColonSaml2 => {
                write!(f, "urn:ietf:params:oauth:token-type:saml2")
            }
            Self::UrnColonIetfColonParamsColonOauthColonTokenTypeColonJwt => {
                write!(f, "urn:ietf:params:oauth:token-type:jwt")
            }
        }
    }
}

impl Default for TokenType {
    fn default() -> TokenType {
        Self::UrnColonIetfColonParamsColonOauthColonTokenTypeColonAccessToken
    }
}
