/*
 * Apache Iceberg REST Catalog API
 *
 * Defines the specification for the first version of the REST Catalog API. Implementations should ideally support both Iceberg table specs v1 and v2, with priority given to v2.
 *
 * The version of the OpenAPI document: 0.0.1
 *
 * Generated by: https://openapi-generator.tech
 */

use serde::{Deserialize, Serialize};

use crate::models;

#[derive(Clone, Default, Debug, PartialEq, Serialize, Deserialize)]
pub struct UpdateNamespacePropertiesResponse {
    /// List of property keys that were added or updated
    #[serde(rename = "updated")]
    pub updated: Vec<String>,
    /// List of properties that were removed
    #[serde(rename = "removed")]
    pub removed: Vec<String>,
    /// List of properties requested for removal that were not found in the namespace's properties. Represents a partial success response. Server's do not need to implement this.
    #[serde(rename = "missing", skip_serializing_if = "Option::is_none")]
    pub missing: Option<Vec<String>>,
}

impl UpdateNamespacePropertiesResponse {
    pub fn new(updated: Vec<String>, removed: Vec<String>) -> UpdateNamespacePropertiesResponse {
        UpdateNamespacePropertiesResponse {
            updated,
            removed,
            missing: None,
        }
    }
}
