/*
 * Apache Iceberg REST Catalog API
 *
 * Defines the specification for the first version of the REST Catalog API. Implementations should ideally support both Iceberg table specs v1 and v2, with priority given to v2.
 *
 * The version of the OpenAPI document: 0.0.1
 *
 * Generated by: https://openapi-generator.tech
 */

use serde::{Deserialize, Serialize};

use crate::models;

#[derive(Clone, Default, Debug, PartialEq, Serialize, Deserialize)]
pub struct ViewMetadata {
    #[serde(rename = "view-uuid")]
    pub view_uuid: String,
    #[serde(rename = "format-version")]
    pub format_version: i32,
    #[serde(rename = "location")]
    pub location: String,
    #[serde(rename = "current-version-id")]
    pub current_version_id: i32,
    #[serde(rename = "versions")]
    pub versions: Vec<models::ViewVersion>,
    #[serde(rename = "version-log")]
    pub version_log: Vec<models::ViewHistoryEntry>,
    #[serde(rename = "schemas")]
    pub schemas: Vec<models::Schema>,
    #[serde(rename = "properties", skip_serializing_if = "Option::is_none")]
    pub properties: Option<std::collections::HashMap<String, String>>,
}

impl ViewMetadata {
    pub fn new(
        view_uuid: String,
        format_version: i32,
        location: String,
        current_version_id: i32,
        versions: Vec<models::ViewVersion>,
        version_log: Vec<models::ViewHistoryEntry>,
        schemas: Vec<models::Schema>,
    ) -> ViewMetadata {
        ViewMetadata {
            view_uuid,
            format_version,
            location,
            current_version_id,
            versions,
            version_log,
            schemas,
            properties: None,
        }
    }
}
