/*
 * Apache Iceberg REST Catalog API
 *
 * Defines the specification for the first version of the REST Catalog API. Implementations should ideally support both Iceberg table specs v1 and v2, with priority given to v2.
 *
 * The version of the OpenAPI document: 0.0.1
 *
 * Generated by: https://openapi-generator.tech
 */

use serde::{Deserialize, Serialize};

use crate::models;

#[derive(Clone, Default, Debug, PartialEq, Serialize, Deserialize)]
pub struct ViewVersion {
    #[serde(rename = "version-id")]
    pub version_id: i32,
    #[serde(rename = "timestamp-ms")]
    pub timestamp_ms: i64,
    /// Schema ID to set as current, or -1 to set last added schema
    #[serde(rename = "schema-id")]
    pub schema_id: i32,
    #[serde(rename = "summary")]
    pub summary: std::collections::HashMap<String, String>,
    #[serde(rename = "representations")]
    pub representations: Vec<models::SqlViewRepresentation>,
    #[serde(rename = "default-catalog", skip_serializing_if = "Option::is_none")]
    pub default_catalog: Option<String>,
    /// Reference to one or more levels of a namespace
    #[serde(rename = "default-namespace")]
    pub default_namespace: Vec<String>,
}

impl ViewVersion {
    pub fn new(
        version_id: i32,
        timestamp_ms: i64,
        schema_id: i32,
        summary: std::collections::HashMap<String, String>,
        representations: Vec<models::SqlViewRepresentation>,
        default_namespace: Vec<String>,
    ) -> ViewVersion {
        ViewVersion {
            version_id,
            timestamp_ms,
            schema_id,
            summary,
            representations,
            default_catalog: None,
            default_namespace,
        }
    }
}
