-- SQLBench-DS query 20 derived from TPC-DS query 20 under the terms of the TPC Fair Use Policy.
-- TPC-DS queries are Copyright 2021 Transaction Processing Performance Council.
-- This query was generated at scale factor 1.
select
  i_item_id,
  i_item_desc,
  i_category,
  i_class,
  i_current_price,
  sum(cs_ext_sales_price) as itemrevenue,
  sum(cs_ext_sales_price) * 100 / sum(sum(cs_ext_sales_price)) over (
    partition by
      i_class
  ) as revenueratio
from
  catalog_sales,
  item,
  date_dim
where
  cs_item_sk = i_item_sk
  and i_category in ('Children', 'Sports', 'Music')
  and cs_sold_date_sk = d_date_sk
  and d_date between cast('2002-04-01' as date) and (cast('2002-04-01' as date) + INTERVAL '30 DAYS')
group by
  i_item_id,
  i_item_desc,
  i_category,
  i_class,
  i_current_price
order by
  i_category,
  i_class,
  i_item_id,
  i_item_desc,
  revenueratio
LIMIT
  100;
