-- SQLBench-DS query 53 derived from TPC-DS query 53 under the terms of the TPC Fair Use Policy.
-- TPC-DS queries are Copyright 2021 Transaction Processing Performance Council.
-- This query was generated at scale factor 1.
select
  *
from
  (
    select
      i_manufact_id,
      sum(ss_sales_price) sum_sales,
      avg(sum(ss_sales_price)) over (
        partition by
          i_manufact_id
      ) avg_quarterly_sales
    from
      item,
      store_sales,
      date_dim,
      store
    where
      ss_item_sk = i_item_sk
      and ss_sold_date_sk = d_date_sk
      and ss_store_sk = s_store_sk
      and d_month_seq in (
        1197,
        1197 + 1,
        1197 + 2,
        1197 + 3,
        1197 + 4,
        1197 + 5,
        1197 + 6,
        1197 + 7,
        1197 + 8,
        1197 + 9,
        1197 + 10,
        1197 + 11
      )
      and (
        (
          i_category in ('Books', 'Children', 'Electronics')
          and i_class in ('personal', 'portable', 'reference', 'self-help')
          and i_brand in (
            'scholaramalgamalg #14',
            'scholaramalgamalg #7',
            'exportiunivamalg #9',
            'scholaramalgamalg #9'
          )
        )
        or (
          i_category in ('Women', 'Music', 'Men')
          and i_class in ('accessories', 'classical', 'fragrances', 'pants')
          and i_brand in (
            'amalgimporto #1',
            'edu packscholar #1',
            'exportiimporto #1',
            'importoamalg #1'
          )
        )
      )
    group by
      i_manufact_id,
      d_qoy
  ) tmp1
where
  case
    when avg_quarterly_sales > 0 then abs(sum_sales - avg_quarterly_sales) / avg_quarterly_sales
    else null
  end > 0.1
order by
  avg_quarterly_sales,
  sum_sales,
  i_manufact_id
LIMIT
  100;
