-- SQLBench-DS query 90 derived from TPC-DS query 90 under the terms of the TPC Fair Use Policy.
-- TPC-DS queries are Copyright 2021 Transaction Processing Performance Council.
-- This query was generated at scale factor 1.
select
  CASE WHEN pmc = 0 THEN null ELSE cast(amc as decimal(15, 4)) / cast(pmc as decimal(15, 4)) END am_pm_ratio
from
  (
    select
      count(*) amc
    from
      web_sales,
      household_demographics,
      time_dim,
      web_page
    where
      ws_sold_time_sk = time_dim.t_time_sk
      and ws_ship_hdemo_sk = household_demographics.hd_demo_sk
      and ws_web_page_sk = web_page.wp_web_page_sk
      and time_dim.t_hour between 9 and 9  + 1
      and household_demographics.hd_dep_count = 2
      and web_page.wp_char_count between 5000 and 5200
  ) at,
  (
    select
      count(*) pmc
    from
      web_sales,
      household_demographics,
      time_dim,
      web_page
    where
      ws_sold_time_sk = time_dim.t_time_sk
      and ws_ship_hdemo_sk = household_demographics.hd_demo_sk
      and ws_web_page_sk = web_page.wp_web_page_sk
      and time_dim.t_hour between 15 and 15  + 1
      and household_demographics.hd_dep_count = 2
      and web_page.wp_char_count between 5000 and 5200
  ) pt
order by
  am_pm_ratio
LIMIT
  100;
