-- SQLBench-DS query 95 derived from TPC-DS query 95 under the terms of the TPC Fair Use Policy.
-- TPC-DS queries are Copyright 2021 Transaction Processing Performance Council.
-- This query was generated at scale factor 1.
with
  ws_wh as (
    select
      ws1.ws_order_number,
      ws1.ws_warehouse_sk wh1,
      ws2.ws_warehouse_sk wh2
    from
      web_sales ws1,
      web_sales ws2
    where
      ws1.ws_order_number = ws2.ws_order_number
      and ws1.ws_warehouse_sk <> ws2.ws_warehouse_sk
  )
select
  count(distinct ws_order_number) as `order count`,
  sum(ws_ext_ship_cost) as `total shipping cost`,
  sum(ws_net_profit) as `total net profit`
from
  web_sales ws1,
  date_dim,
  customer_address,
  web_site
where
  d_date between '2002-5-01' and (cast('2002-5-01' as date) + INTERVAL '60 DAYS')
  and ws1.ws_ship_date_sk = d_date_sk
  and ws1.ws_ship_addr_sk = ca_address_sk
  and ca_state = 'MA'
  and ws1.ws_web_site_sk = web_site_sk
  and web_company_name = 'pri'
  and ws1.ws_order_number in (
    select
      ws_order_number
    from
      ws_wh
  )
  and ws1.ws_order_number in (
    select
      wr_order_number
    from
      web_returns,
      ws_wh
    where
      wr_order_number = ws_wh.ws_order_number
  )
order by
  count(distinct ws_order_number)
LIMIT
  100;
