# coding: utf-8
"""
Data source: Dutour Sikirić, Mathieu, Olaf Delgado-Friedrichs, and Michel Deza. “Space Fullerenes: a Computer Search for New Frank-Kasper Structures” Acta Crystallographica Section A Foundations of Crystallography 66.Pt 5 (2010): 602–615.

Cage composition:
 (12,14,15,16) = (20,10,4,6,)
"""
from genice2.cell import cellvectors
import genice2.lattices
desc = {"ref": {"SpaceFullerene": 'Sikiric 2010'},
        "usage": "No options available.",
        "brief": "A space fullerene."
        }


class Lattice(genice2.lattices.Lattice):
    def __init__(self):
        self.pairs = """
        121 96
        164 105
        8 223
        10 223
        115 94
        9 204
        24 156
        9 102
        202 58
        120 72
        211 94
        14 36
        136 67
        164 70
        212 16
        41 186
        50 132
        135 109
        137 109
        226 142
        198 185
        134 17
        2 104
        193 170
        127 3
        118 164
        7 17
        34 221
        84 28
        137 119
        104 88
        52 11
        20 59
        44 28
        65 12
        19 69
        125 224
        114 179
        71 51
        23 152
        225 153
        125 41
        152 73
        108 177
        15 65
        145 141
        78 149
        53 176
        38 190
        79 60
        98 159
        0 85
        136 201
        202 192
        175 74
        6 143
        171 84
        200 56
        48 145
        176 74
        82 193
        181 175
        22 167
        58 64
        29 167
        42 201
        226 32
        25 44
        46 68
        128 212
        40 67
        25 118
        17 160
        103 186
        214 130
        5 93
        206 43
        208 116
        200 66
        15 205
        20 156
        184 161
        54 211
        14 216
        181 162
        16 174
        118 57
        114 220
        20 172
        33 36
        126 172
        83 195
        30 144
        118 77
        180 214
        62 203
        171 205
        106 89
        101 156
        157 39
        133 56
        180 124
        192 175
        166 90
        88 161
        215 161
        30 151
        86 38
        10 33
        226 124
        217 128
        127 51
        111 185
        172 78
        204 11
        187 84
        136 221
        2 148
        154 97
        76 3
        137 170
        9 187
        131 177
        113 72
        50 60
        115 185
        1 184
        88 150
        165 208
        139 173
        21 85
        178 36
        52 70
        196 188
        186 153
        68 44
        197 133
        178 180
        224 93
        49 3
        58 176
        211 196
        209 74
        137 48
        62 179
        48 201
        150 129
        141 47
        112 49
        87 211
        101 177
        138 28
        6 125
        218 80
        12 213
        149 17
        31 59
        224 140
        207 163
        50 94
        197 66
        42 40
        139 64
        0 171
        121 105
        208 147
        82 39
        183 4
        80 219
        68 38
        15 191
        77 85
        154 59
        96 133
        142 190
        117 152
        25 195
        68 187
        37 65
        75 11
        141 225
        112 163
        120 110
        2 5
        80 92
        34 145
        124 86
        216 116
        87 101
        74 159
        126 217
        191 222
        111 145
        135 81
        189 217
        127 221
        196 26
        82 67
        56 11
        147 204
        188 7
        46 195
        197 36
        29 55
        225 55
        21 57
        83 134
        42 174
        46 116
        206 170
        123 93
        78 214
        147 134
        182 209
        183 209
        62 84
        106 88
        57 205
        144 54
        49 45
        99 143
        73 129
        22 19
        71 154
        139 45
        64 185
        69 153
        218 5
        72 222
        190 210
        198 97
        104 110
        126 130
        8 66
        14 214
        119 95
        50 146
        34 212
        127 97
        37 207
        0 179
        57 28
        81 95
        206 95
        209 109
        151 128
        31 198
        120 158
        144 42
        19 112
        115 4
        159 167
        21 113
        111 45
        173 176
        13 107
        122 41
        67 212
        166 151
        210 130
        103 100
        102 52
        55 91
        155 39
        155 40
        23 175
        138 178
        168 97
        222 122
        91 207
        33 96
        30 196
        208 7
        21 191
        117 194
        203 220
        206 202
        215 133
        177 38
        35 105
        54 71
        12 140
        184 89
        154 157
        108 155
        219 213
        220 215
        216 83
        14 165
        188 78
        111 51
        1 107
        1 121
        178 223
        225 45
        194 153
        192 182
        119 29
        10 1
        189 86
        72 220
        163 129
        79 174
        25 32
        91 186
        44 124
        47 69
        106 219
        193 16
        98 93
        35 77
        207 100
        37 114
        23 169
        69 3
        46 204
        218 152
        23 76
        4 60
        98 27
        76 168
        213 123
        199 142
        114 63
        20 54
        0 65
        64 168
        37 222
        71 115
        151 174
        9 32
        87 7
        122 158
        24 146
        173 92
        53 162
        102 171
        216 149
        113 138
        165 66
        183 170
        120 107
        131 132
        136 135
        99 159
        33 83
        205 70
        53 80
        200 147
        96 75
        125 27
        182 157
        199 180
        101 116
        192 168
        35 89
        104 73
        148 123
        112 55
        31 94
        29 143
        166 190
        172 26
        77 102
        164 75
        113 13
        63 100
        129 169
        181 218
        31 26
        131 79
        24 160
        191 224
        131 166
        15 123
        108 24
        4 157
        76 194
        8 199
        6 91
        226 90
        34 198
        156 149
        132 87
        195 75
        10 200
        63 107
        188 18
        47 221
        146 59
        35 227
        132 160
        187 142
        119 141
        18 210
        215 110
        61 27
        227 140
        150 100
        193 60
        121 110
        92 150
        30 210
        173 169
        61 95
        109 167
        202 162
        165 18
        73 158
        61 143
        146 39
        179 13
        99 213
        63 161
        89 52
        199 18
        138 203
        2 105
        140 85
        47 81
        197 203
        99 53
        49 169
        86 130
        148 70
        8 62
        13 223
        108 189
        5 227
        155 79
        162 61
        103 158
        139 194
        201 51
        126 144
        98 181
        90 160
        217 40
        219 227
        183 58
        48 16
        135 43
        184 56
        6 12
        128 26
        134 32
        19 41
        82 43
        189 90
        122 163
        22 81
        22 27
        106 148
        117 92
        182 43
        117 103
        """

        self.waters = """
        0.68444 0.36395 0.17121
        0.5 0.33572 0.60576
        0.19056 0.44521 0.79727
        0.18444 0.70591 0.48652
        0.875 0.84218 0.82287
        0.31556 0.48888 0.85841
        0.625 0.54194 0.17024
        0.68453 0.07727 0.67087
        0.68128 0.21939 0.36833
        0.68453 0.21923 0.96984
        0.5 0.26014 0.57466
        0.875 0.27286 0.79775
        0.68444 0.4854 0.10841
        0.5 0.3282 0.35421
        0.125 0.1437 0.51084
        0.0 0.42688 0.0939
        0.69047 0.87181 0.16987
        0.5 0.09038 0.76429
        0.75 0.10899 0.41774
        0.18444 0.62463 0.29901
        0.18453 0.97069 0.60846
        0.31556 0.36395 0.17121
        0.18128 0.64902 0.1708
        0.18444 0.63605 0.67121
        0.31547 0.99689 0.85846
        0.31547 0.21923 0.96984
        0.5 0.9616 0.45187
        0.30628 0.6028 0.08991
        0.125 0.25506 0.16753
        0.81872 0.64902 0.1708
        0.81547 0.00311 0.35846
        0.5 0.90433 0.57483
        0.5 0.18296 0.95401
        0.31872 0.23328 0.6223
        0.5 0.83439 0.37369
        0.5 0.3845 0.86218
        0.19372 0.20728 0.49273
        0.875 0.45067 0.29399
        0.0 0.09568 0.07483
        0.25 0.89101 0.91774
        0.18453 0.92273 0.17087
        0.30944 0.5548 0.29727
        0.0 0.90963 0.26429
        0.30628 0.79272 0.99273
        0.19047 0.19323 0.09027
        0.81556 0.70591 0.48652
        0.0 0.16561 0.87369
        0.375 0.72715 0.29775
        0.81547 0.8172 0.23383
        0.0 0.66731 0.48737
        0.625 0.92853 0.82443
        0.0 0.81704 0.45401
        0.80944 0.32411 0.87832
        0.69372 0.60845 0.87093
        0.0 0.94514 0.54634
        0.81556 0.62463 0.29901
        0.80628 0.28706 0.67039
        0.19056 0.31442 0.09324
        0.69372 0.73074 0.79016
        0.30953 0.91542 0.66784
        0.75 0.89101 0.91774
        0.5 0.63987 0.04184
        0.80628 0.26926 0.29016
        0.68128 0.41726 0.4802
        0.625 0.74494 0.66753
        0.80944 0.43782 0.17102
        0.80628 0.20728 0.49273
        0.30953 0.87181 0.16987
        0.0 0.1575 0.02855
        0.30944 0.6759 0.37832
        0.0 0.35746 0.92445
        0.0 0.86965 0.57647
        0.19372 0.39155 0.37093
        0.18444 0.5146 0.60841
        0.0 0.6718 0.85421
        0.125 0.27286 0.79775
        0.30944 0.68558 0.59324
        0.5 0.33269 0.98737
        0.375 0.06618 0.51389
        0.875 0.93383 0.01389
        0.625 0.54933 0.79399
        0.30628 0.71295 0.17039
        0.375 0.8563 0.01084
        0.31547 0.18281 0.73383
        0.875 0.25506 0.16753
        0.5 0.37698 0.11063
        0.19047 0.08458 0.16784
        0.80953 0.02355 0.73346
        0.875 0.45806 0.67024
        0.68444 0.37538 0.79901
        0.5 0.05487 0.04634
        0.69056 0.5548 0.29727
        0.69056 0.56219 0.67102
        0.19056 0.51094 0.98341
        0.69047 0.91542 0.66784
        0.5 0.70398 0.08831
        0.19372 0.28706 0.67039
        0.30953 0.80677 0.59027
        0.18128 0.58274 0.9802
        0.81872 0.58274 0.9802
        0.69056 0.48906 0.48341
        0.0 0.05086 0.79634
        0.68444 0.2941 0.98652
        0.5 0.52362 0.48544
        0.125 0.45806 0.67024
        0.31556 0.37538 0.79901
        0.80944 0.44521 0.79727
        0.5 0.38001 0.47902
        0.19047 0.99865 0.98346
        0.0 0.73987 0.07466
        0.19372 0.3972 0.58991
        0.81547 0.78077 0.46984
        0.0 0.6155 0.36218
        0.31872 0.33956 0.293
        0.80628 0.39155 0.37093
        0.81547 0.85414 0.66744
        0.0 0.11623 0.76444
        0.5 0.57312 0.5939
        0.31556 0.2941 0.98652
        0.69372 0.71295 0.17039
        0.31872 0.41726 0.4802
        0.31872 0.35098 0.6708
        0.18444 0.51112 0.35841
        0.0 0.47639 0.98544
        0.31547 0.14586 0.16744
        0.375 0.54194 0.17024
        0.18453 0.00311 0.35846
        0.18453 0.78077 0.46984
        0.5 0.94915 0.29634
        0.0 0.54933 0.56356
        0.125 0.07148 0.32443
        0.80953 0.99865 0.98346
        0.68453 0.99689 0.85846
        0.0 0.29602 0.58831
        0.5 0.15919 0.79772
        0.18128 0.76672 0.1223
        0.18453 0.8172 0.23383
        0.81872 0.76672 0.1223
        0.19372 0.26926 0.29016
        0.69056 0.68558 0.59324
        0.5 0.45067 0.06356
        0.625 0.72715 0.29775
        0.68453 0.14586 0.16744
        0.69372 0.6028 0.08991
        0.0 0.96135 0.39045
        0.69047 0.79289 0.34424
        0.375 0.92853 0.82443
        0.68453 0.18281 0.73383
        0.0 0.43253 0.87742
        0.31547 0.07727 0.67087
        0.81556 0.5146 0.60841
        0.69047 0.97645 0.23346
        0.30944 0.56219 0.67102
        0.5 0.64254 0.42445
        0.18453 0.85414 0.66744
        0.125 0.93383 0.01389
        0.19047 0.02355 0.73346
        0.125 0.84218 0.82287
        0.30944 0.48906 0.48341
        0.0 0.61999 0.97902
        0.5 0.03866 0.89045
        0.80628 0.3972 0.58991
        0.5 0.64378 0.91559
        0.0 0.54759 0.40628
        0.19056 0.32411 0.87832
        0.875 0.1437 0.51084
        0.68453 0.02931 0.10846
        0.0 0.66429 0.10576
        0.375 0.74494 0.66753
        0.0 0.62302 0.61063
        0.69372 0.79272 0.99273
        0.80944 0.31442 0.09324
        0.30953 0.00135 0.48346
        0.81556 0.63605 0.67121
        0.81547 0.92273 0.17087
        0.18128 0.66045 0.793
        0.81872 0.66045 0.793
        0.0 0.03841 0.95187
        0.31872 0.21939 0.36833
        0.68128 0.33956 0.293
        0.375 0.15782 0.32287
        0.30628 0.60845 0.87093
        0.18128 0.78061 0.86833
        0.81872 0.78061 0.86833
        0.68128 0.35098 0.6708
        0.69047 0.80677 0.59027
        0.5 0.56747 0.37742
        0.80953 0.19323 0.09027
        0.625 0.06618 0.51389
        0.31547 0.02931 0.10846
        0.80953 0.08458 0.16784
        0.19056 0.43782 0.17102
        0.30628 0.73074 0.79016
        0.625 0.8563 0.01084
        0.5 0.64645 0.5482
        0.19047 0.20712 0.84424
        0.69047 0.00135 0.48346
        0.0 0.24579 0.47577
        0.5 0.8425 0.52855
        0.625 0.15782 0.32287
        0.68128 0.23328 0.6223
        0.0 0.84081 0.29772
        0.5 0.716 0.86692
        0.0 0.284 0.36692
        0.80953 0.20712 0.84424
        0.0 0.35355 0.0482
        0.5 0.75421 0.97577
        0.81556 0.51112 0.35841
        0.80953 0.1282 0.66987
        0.0 0.74564 0.91583
        0.875 0.07148 0.32443
        0.81547 0.97069 0.60846
        0.5 0.88377 0.26444
        0.80944 0.51094 0.98341
        0.25 0.10899 0.41774
        0.0 0.36013 0.54184
        0.19047 0.1282 0.66987
        0.30953 0.97645 0.23346
        0.375 0.54933 0.79399
        0.68444 0.48888 0.85841
        0.0 0.35622 0.41559
        0.30953 0.79289 0.34424
        0.125 0.45067 0.29399
        0.5 0.25436 0.41583
        0.31556 0.4854 0.10841
        0.69056 0.6759 0.37832
        0.5 0.13035 0.07647
        0.5 0.45241 0.90628
        """

        self.coord = "relative"

        self.cages = """
        14 0.76188 -0.10572 1.42174
        12 0.23775 0.59482 0.48846
        14 0.0 -0.06133 0.79379
        12 0.22511 -0.30761 0.97562
        12 0.0 0.20018 0.6662
        12 0.73775 -0.59482 0.98846
        14 0.0 -0.15357 1.04345
        16 0.5 0.24864 0.16861
        14 0.26188 0.10572 0.92174
        12 0.5 -0.36868 1.23579
        14 0.5 0.06133 0.29379
        14 0.5 -0.05331 1.04809
        15 0.0 0.16775 0.28563
        12 0.5 -0.25081 1.48508
        12 0.5 -0.20018 1.1662
        14 0.0 0.05331 0.54809
        12 0.5 -0.35304 0.73079
        12 0.27489 0.30761 0.47562
        15 0.5 -0.16775 0.78563
        15 0.0 0.72825 0.30393
        16 0.0 -0.44893 0.79697
        14 0.73812 0.10572 1.92174
        15 0.5 -0.72825 0.80393
        16 0.5 0.44893 0.29697
        12 0.0 0.25081 0.98508
        16 0.0 -0.24864 0.66861
        14 0.23812 -0.10572 1.42174
        12 0.0 0.35304 0.23079
        16 0.5 -0.54411 0.66787
        12 0.72511 0.30761 1.47562
        12 0.0 0.00351 0.17021
        12 0.77489 -0.30761 0.97562
        12 0.76225 0.59482 1.48846
        12 0.5 -0.00351 0.67021
        12 0.26225 -0.59482 0.98846
        16 0.0 0.54411 0.16787
        12 0.5 -0.45661 0.98034
        12 0.0 0.45661 0.48034
        14 0.5 0.15357 0.54345
        12 0.0 0.36868 0.73579
        """

        self.bondlen = 3

        self.cell = """
        14.770542484182686 46.16215955263366 22.255287650210985
        """

        self.density = 0.4491080350385539

        self.cell = cellvectors(a=14.770542484182686,
                                b=46.16215955263366,
                                c=22.255287650210985)
