# coding: utf-8
"""
Data source: Dutour Sikirić, Mathieu, Olaf Delgado-Friedrichs, and Michel Deza. “Space Fullerenes: a Computer Search for New Frank-Kasper Structures” Acta Crystallographica Section A Foundations of Crystallography 66.Pt 5 (2010): 602–615.

Cage composition:
 (12,14,15,16) = (30,12,12,6,)
"""
from genice2.cell import cellvectors
import genice2.lattices
desc = {"ref": {"SpaceFullerene": 'Sikiric 2010'},
        "usage": "No options available.",
        "brief": "A space fullerene."
        }


class Lattice(genice2.lattices.Lattice):
    def __init__(self):
        self.pairs = """
        131 0
        157 235
        260 207
        329 148
        18 123
        254 229
        142 36
        230 134
        302 166
        279 233
        30 105
        129 61
        136 242
        72 245
        250 2
        226 184
        8 202
        218 45
        208 242
        85 158
        257 280
        266 288
        271 285
        259 228
        173 247
        294 149
        256 58
        90 126
        147 318
        262 47
        312 101
        265 317
        132 203
        125 53
        68 293
        22 36
        187 281
        200 212
        143 1
        148 59
        55 250
        35 21
        23 277
        175 266
        79 320
        93 100
        195 160
        303 56
        39 145
        222 20
        82 193
        65 31
        110 255
        338 300
        41 222
        241 314
        282 130
        215 276
        206 317
        40 114
        10 167
        122 127
        252 84
        253 84
        174 51
        133 89
        314 190
        284 78
        188 107
        170 11
        321 179
        198 43
        12 88
        259 143
        249 168
        265 115
        282 152
        16 315
        90 178
        45 150
        62 77
        321 248
        297 11
        39 73
        239 58
        61 236
        109 241
        155 174
        160 136
        77 171
        5 247
        23 273
        119 231
        185 2
        71 267
        262 59
        62 299
        228 322
        104 115
        173 190
        236 207
        279 260
        161 97
        88 283
        93 223
        122 338
        168 235
        120 41
        290 161
        320 78
        159 29
        169 2
        50 340
        142 283
        18 119
        19 121
        11 291
        20 207
        173 27
        239 166
        261 251
        0 56
        95 206
        22 76
        333 108
        262 50
        90 129
        51 9
        4 326
        116 145
        183 55
        207 201
        302 223
        255 17
        18 94
        158 298
        282 147
        217 230
        309 86
        28 185
        341 167
        23 75
        92 3
        7 203
        215 165
        261 277
        208 87
        153 302
        322 167
        140 99
        245 228
        189 59
        275 316
        310 7
        249 289
        217 258
        288 154
        259 55
        258 52
        241 35
        197 292
        112 57
        91 323
        292 278
        301 313
        49 202
        254 227
        198 128
        330 267
        194 213
        240 124
        85 111
        173 35
        118 332
        316 106
        264 34
        105 219
        63 16
        306 48
        95 180
        154 226
        304 205
        135 53
        321 120
        329 137
        5 82
        251 171
        113 164
        204 338
        294 273
        201 111
        151 100
        39 54
        307 15
        259 313
        209 271
        68 324
        160 291
        126 269
        167 89
        176 316
        197 166
        38 310
        52 81
        271 78
        63 123
        50 232
        182 240
        28 76
        169 283
        12 2
        234 315
        58 66
        41 158
        57 69
        18 332
        328 151
        216 130
        144 301
        295 107
        271 125
        337 327
        329 105
        97 286
        98 284
        176 328
        270 149
        263 221
        272 63
        299 241
        183 51
        118 15
        107 231
        65 106
        22 334
        17 324
        182 138
        264 141
        323 26
        86 100
        43 221
        14 189
        216 69
        157 31
        33 169
        254 201
        300 288
        293 171
        244 71
        269 94
        289 162
        263 203
        198 203
        61 158
        229 178
        299 293
        112 125
        308 82
        257 195
        138 3
        165 225
        44 316
        98 146
        220 9
        93 44
        191 140
        323 273
        152 232
        91 62
        246 324
        198 249
        260 321
        243 42
        148 307
        210 186
        4 32
        197 275
        60 245
        19 289
        209 46
        115 288
        114 285
        109 42
        141 227
        319 31
        102 26
        128 330
        205 233
        86 289
        181 88
        10 250
        296 48
        109 26
        279 281
        265 303
        204 99
        160 21
        216 125
        113 74
        155 210
        110 261
        195 305
        298 227
        183 335
        211 247
        264 37
        279 222
        222 141
        334 27
        13 37
        223 328
        326 292
        191 265
        275 4
        156 58
        126 236
        264 233
        243 170
        106 256
        120 199
        33 242
        196 322
        274 247
        306 178
        30 57
        84 146
        114 325
        319 165
        253 192
        177 139
        228 51
        144 89
        180 25
        77 124
        212 224
        248 233
        54 131
        187 41
        305 208
        303 54
        84 47
        92 34
        128 312
        116 97
        83 49
        328 256
        7 312
        318 278
        225 278
        19 244
        157 66
        22 169
        29 206
        309 121
        122 310
        92 199
        161 210
        192 340
        6 108
        8 327
        280 36
        295 332
        318 276
        102 182
        200 118
        69 146
        150 221
        47 224
        223 156
        65 162
        154 317
        20 269
        38 202
        92 248
        79 146
        138 75
        296 129
        164 280
        209 98
        262 137
        253 212
        286 184
        177 220
        246 314
        152 46
        225 268
        269 227
        10 143
        5 21
        211 334
        244 218
        296 85
        181 28
        14 234
        9 89
        166 44
        277 124
        260 13
        304 138
        19 101
        12 139
        218 151
        64 311
        180 72
        331 312
        57 232
        154 131
        153 276
        33 211
        59 258
        49 115
        290 117
        127 150
        191 286
        239 268
        29 145
        24 175
        187 179
        253 238
        215 325
        255 240
        6 99
        91 11
        286 336
        194 159
        140 49
        323 17
        202 263
        297 314
        200 148
        32 268
        119 64
        305 190
        176 153
        70 32
        188 96
        208 27
        234 258
        305 82
        275 276
        102 23
        53 326
        274 291
        306 16
        139 76
        104 108
        188 311
        327 101
        196 313
        121 337
        30 238
        180 0
        237 239
        270 281
        145 336
        252 320
        10 80
        95 161
        143 220
        184 0
        226 29
        70 53
        122 132
        73 226
        45 121
        274 164
        75 248
        270 240
        230 224
        80 185
        34 298
        159 25
        243 68
        183 177
        43 218
        164 136
        47 219
        112 320
        77 273
        147 285
        24 263
        213 155
        339 186
        103 21
        64 306
        317 97
        304 37
        274 308
        257 308
        199 163
        284 232
        172 185
        79 40
        95 60
        199 67
        277 205
        13 163
        326 165
        136 283
        81 272
        8 104
        134 105
        46 340
        195 142
        217 311
        168 330
        224 189
        329 192
        117 133
        67 298
        176 157
        229 94
        177 80
        66 267
        249 287
        319 153
        186 322
        1 341
        117 72
        40 214
        175 140
        162 71
        270 205
        231 63
        117 341
        73 266
        120 236
        163 201
        6 39
        43 86
        206 56
        113 88
        64 234
        118 315
        25 116
        303 204
        52 134
        96 15
        341 210
        331 221
        96 14
        212 81
        113 211
        128 244
        48 123
        325 268
        182 171
        282 78
        237 319
        126 67
        172 74
        332 311
        74 139
        13 3
        189 272
        225 156
        295 16
        144 250
        133 339
        295 229
        130 70
        37 179
        70 114
        297 42
        72 174
        60 186
        83 300
        287 101
        255 294
        44 66
        172 87
        24 333
        245 1
        131 116
        156 31
        256 71
        119 90
        93 65
        297 17
        38 337
        196 335
        135 215
        214 135
        308 170
        87 142
        336 56
        132 287
        181 334
        324 124
        8 132
        83 310
        219 340
        251 304
        38 331
        75 149
        237 106
        220 301
        296 94
        261 68
        14 231
        81 315
        190 291
        188 48
        85 20
        257 35
        134 307
        100 267
        219 69
        110 42
        335 339
        302 278
        4 237
        252 30
        290 184
        337 127
        147 135
        213 9
        333 327
        285 292
        252 137
        163 141
        238 50
        238 52
        111 178
        55 76
        99 336
        130 79
        281 3
        179 149
        172 33
        216 46
        246 193
        109 103
        152 214
        197 325
        213 1
        27 280
        290 159
        287 150
        339 174
        28 313
        45 168
        194 60
        192 98
        103 193
        91 103
        25 155
        12 301
        243 193
        62 246
        74 36
        108 266
        200 217
        107 129
        123 15
        318 32
        209 40
        191 73
        6 83
        54 300
        5 242
        181 87
        307 272
        111 67
        112 214
        294 251
        151 235
        254 61
        333 7
        24 127
        137 284
        196 80
        335 144
        235 162
        293 26
        309 330
        309 331
        204 104
        187 34
        96 230
        194 133
        110 102
        299 170
        175 338
        """

        self.waters = """
        0.66908 0.95954 0.25335
        0.0 0.0 0.31869
        0.66667 0.58334 0.39236
        0.70833 0.04167 0.62893
        0.20833 0.41667 0.97702
        0.87379 0.74759 0.47236
        0.24759 0.12379 0.1914
        0.41908 0.20954 0.14193
        0.99759 0.37379 0.1543
        0.41667 0.20833 0.33333
        0.875 0.75 0.35642
        0.33575 0.29287 0.51237
        0.41667 0.33333 0.39236
        0.54167 0.08333 0.64368
        0.45713 0.54287 0.78532
        0.08574 0.54287 0.78532
        0.54046 0.08092 0.76131
        0.20954 0.41908 0.54801
        0.95954 0.66908 0.74666
        0.20713 0.41425 0.09464
        0.91667 0.45833 0.68975
        0.66425 0.70713 0.48763
        0.66425 0.95713 0.41332
        0.70713 0.66425 0.58668
        0.62621 0.62379 0.1543
        0.41667 0.08334 0.2743
        0.58092 0.79046 0.54801
        0.79046 0.20954 0.45199
        0.91667 0.33333 0.39236
        0.29046 0.33092 0.25335
        0.79287 0.20713 0.86098
        0.79167 0.20833 0.02299
        0.375 0.375 0.96227
        0.87379 0.74759 0.42798
        0.0 0.0 0.65192
        0.66425 0.95713 0.48763
        0.45713 0.91425 0.42787
        0.33333 0.04167 0.62893
        0.20713 0.79287 0.13902
        0.41425 0.20713 0.21468
        0.37379 0.99759 0.92001
        0.20833 0.41667 0.66667
        0.0 0.0 0.53711
        0.79046 0.58092 0.09454
        0.20833 0.79167 0.02309
        0.58575 0.79287 0.09464
        0.33333 0.66667 0.89746
        0.37379 0.37621 0.8457
        0.95954 0.29046 0.74666
        0.04046 0.70954 0.17904
        0.58092 0.79046 0.85807
        0.54167 0.08333 0.33333
        0.70954 0.04046 0.82097
        0.0 0.25 0.94097
        0.54287 0.08575 0.21468
        0.66667 0.95834 0.37107
        0.87621 0.12379 0.23879
        0.87621 0.12379 0.88135
        0.41667 0.20833 0.02299
        0.70954 0.66908 0.82097
        0.04167 0.33333 0.2956
        0.33333 0.29167 0.7044
        0.66667 0.33333 0.5342
        0.66667 0.33333 0.76931
        0.75242 0.87621 0.76121
        0.0 0.375 0.03773
        0.375 0.0 0.03773
        0.75 0.875 0.68965
        0.20954 0.79046 0.54801
        0.12621 0.25241 0.88135
        0.25 0.25 0.94097
        0.25 0.25 0.05903
        0.66667 0.95833 0.2956
        0.54287 0.45713 0.21468
        0.29287 0.95713 0.41332
        0.58333 0.66667 0.60764
        0.66667 0.08334 0.39236
        0.66667 0.33333 0.56413
        0.79288 0.58575 0.90536
        0.41425 0.20713 0.90536
        0.04166 0.70833 0.37107
        0.54046 0.08092 0.80569
        0.04287 0.70713 0.48763
        0.29046 0.95954 0.17904
        0.41425 0.20713 0.86098
        0.95833 0.29167 0.7044
        0.99759 0.62379 0.07999
        0.08575 0.54287 0.42787
        0.29287 0.33575 0.41332
        0.54167 0.45833 0.33333
        0.58333 0.66667 0.7257
        0.54287 0.45713 0.52474
        0.75 0.875 0.64358
        0.0 0.625 0.03773
        0.08334 0.66667 0.7257
        0.91667 0.33333 0.2743
        0.20713 0.41425 0.78532
        0.04046 0.70954 0.25335
        0.12621 0.87379 0.88135
        0.0 0.0 0.20087
        0.0 0.75 0.05903
        0.12379 0.24759 0.11865
        0.74759 0.87379 0.57202
        0.70713 0.66425 0.51237
        0.04046 0.33092 0.17903
        0.00242 0.37621 0.8457
        0.20833 0.41667 0.02309
        0.33092 0.29046 0.74666
        0.29046 0.33092 0.17903
        0.74759 0.87379 0.52764
        0.0 0.0 0.56402
        0.70833 0.04166 0.7044
        0.79287 0.20713 0.90536
        0.25241 0.12621 0.42798
        0.25 0.0 0.94097
        0.08092 0.54046 0.19431
        0.29046 0.95954 0.25335
        0.66667 0.70833 0.2956
        0.20713 0.79287 0.78532
        0.70954 0.66908 0.74666
        0.45833 0.54167 0.66667
        0.33333 0.66667 0.10264
        0.62621 0.00241 0.1543
        0.91908 0.45954 0.76131
        0.91425 0.45713 0.57213
        0.00241 0.37621 0.92001
        0.70833 0.66667 0.7044
        0.58575 0.79287 0.13902
        0.41908 0.20954 0.09454
        0.33333 0.41667 0.7257
        0.3738 0.37621 0.92001
        0.45954 0.91908 0.23869
        0.79046 0.20954 0.14193
        0.45833 0.54167 0.31025
        0.95954 0.29046 0.82097
        0.75 0.0 0.94097
        0.54046 0.45954 0.45199
        0.79288 0.58575 0.86098
        0.58333 0.91667 0.60764
        0.41666 0.08333 0.39236
        0.87621 0.75241 0.1914
        0.20833 0.79167 0.66667
        0.33333 0.66667 0.43587
        0.0 0.0 0.34808
        0.45833 0.54167 0.35632
        0.24759 0.12379 0.23879
        0.24759 0.12379 0.88135
        0.75 0.75 0.94097
        0.95954 0.66908 0.82097
        0.33334 0.41667 0.60764
        0.75241 0.87621 0.11865
        0.75 0.75 0.05903
        0.58092 0.79046 0.90546
        0.75 0.875 0.0
        0.33333 0.66667 0.23069
        0.29167 0.95834 0.2956
        0.66667 0.33333 0.01465
        0.625 0.0 0.03773
        0.125 0.25 0.68965
        0.41667 0.33333 0.2743
        0.45713 0.54287 0.47526
        0.91667 0.58334 0.2743
        0.0 0.25 0.05903
        0.45833 0.91667 0.66667
        0.41908 0.20954 0.45199
        0.79167 0.20833 0.97691
        0.125 0.875 0.0
        0.79167 0.58333 0.33333
        0.62621 0.00241 0.07999
        0.66425 0.70713 0.41332
        0.33575 0.04287 0.51237
        0.54287 0.08575 0.57213
        0.04287 0.70713 0.41332
        0.87379 0.12621 0.47236
        0.45833 0.91667 0.31025
        0.66908 0.70954 0.17904
        0.58334 0.79167 0.02309
        0.29166 0.95833 0.37107
        0.58333 0.91666 0.7257
        0.33333 0.29167 0.62893
        0.66667 0.08333 0.2743
        0.04287 0.33575 0.41332
        0.70713 0.04287 0.58668
        0.45833 0.91667 0.35632
        0.66908 0.70954 0.25335
        0.91666 0.58333 0.39236
        0.08333 0.54167 0.31025
        0.125 0.25 0.64358
        0.12379 0.24758 0.76121
        0.54046 0.45954 0.80569
        0.04287 0.33575 0.48763
        0.79287 0.58575 0.21468
        0.20954 0.79046 0.85807
        0.95713 0.66425 0.51237
        0.29167 0.33333 0.2956
        0.33333 0.66667 0.4658
        0.08333 0.54167 0.35632
        0.20833 0.79167 0.97702
        0.66667 0.33333 0.10254
        0.58333 0.79167 0.66667
        0.12379 0.87621 0.8086
        0.54167 0.08333 0.68975
        0.99759 0.62379 0.1543
        0.66667 0.33333 0.13247
        0.87621 0.12379 0.1914
        0.08333 0.66667 0.60764
        0.04046 0.33092 0.25335
        0.66667 0.33333 0.68141
        0.91908 0.45954 0.45199
        0.20954 0.79046 0.90546
        0.04167 0.70834 0.2956
        0.0 0.0 0.43598
        0.33092 0.04046 0.82097
        0.25 0.125 0.31035
        0.62379 0.99759 0.92001
        0.625 0.0 0.96227
        0.20954 0.41908 0.90546
        0.0 0.0 0.79914
        0.6262 0.62379 0.07999
        0.20954 0.41908 0.85807
        0.25 0.125 0.35642
        0.87379 0.74759 0.11865
        0.08333 0.54167 0.66667
        0.79167 0.58333 0.02299
        0.33092 0.29046 0.82097
        0.66667 0.33333 0.98525
        0.45954 0.54046 0.23869
        0.125 0.875 0.68965
        0.79167 0.20833 0.33333
        0.33333 0.91667 0.7257
        0.12379 0.24759 0.8086
        0.54046 0.45954 0.76131
        0.74759 0.87379 0.88135
        0.95833 0.66667 0.62893
        0.58575 0.79287 0.78532
        0.75 0.0 0.05903
        0.54167 0.45833 0.68975
        0.125 0.25 0.0
        0.62379 0.99759 0.8457
        0.25 0.125 0.0
        0.95713 0.29287 0.58668
        0.70713 0.04287 0.51237
        0.79046 0.58092 0.45199
        0.12621 0.87379 0.52764
        0.3762 0.37379 0.07999
        0.875 0.125 0.31035
        0.91425 0.45713 0.52474
        0.0 0.0 0.46289
        0.70833 0.66667 0.62893
        0.79046 0.20954 0.09454
        0.66667 0.70834 0.37107
        0.33575 0.04287 0.58668
        0.66667 0.33333 0.87044
        0.37379 0.99759 0.8457
        0.33333 0.04167 0.7044
        0.12621 0.25241 0.57202
        0.375 0.375 0.03773
        0.45713 0.91425 0.47526
        0.75242 0.87621 0.8086
        0.875 0.125 0.35642
        0.66667 0.33333 0.65202
        0.12621 0.87379 0.57202
        0.62379 0.62621 0.8457
        0.79046 0.58092 0.14193
        0.125 0.875 0.64358
        0.91425 0.45713 0.21468
        0.45954 0.54046 0.19431
        0.25 0.0 0.05903
        0.41667 0.20833 0.97691
        0.95834 0.66667 0.7044
        0.08333 0.41667 0.60764
        0.00241 0.62621 0.92001
        0.66667 0.33333 0.79623
        0.54287 0.45713 0.57213
        0.25241 0.12621 0.47236
        0.33333 0.66667 0.98536
        0.58334 0.79167 0.97702
        0.95713 0.66425 0.58668
        0.79167 0.58333 0.97691
        0.91667 0.45833 0.64368
        0.54046 0.08092 0.45199
        0.95833 0.29167 0.62893
        0.6238 0.62621 0.92001
        0.45713 0.54287 0.42787
        0.87621 0.75241 0.88135
        0.0 0.75 0.94097
        0.87621 0.75241 0.23879
        0.87379 0.12621 0.11865
        0.33333 0.66667 0.20377
        0.99759 0.37379 0.07999
        0.66667 0.58333 0.2743
        0.29287 0.33575 0.48763
        0.0 0.625 0.96227
        0.45954 0.91908 0.54801
        0.33575 0.29287 0.58668
        0.33092 0.04046 0.74666
        0.08333 0.41667 0.7257
        0.12621 0.25241 0.52764
        0.0 0.0 0.68131
        0.54287 0.08575 0.52474
        0.45954 0.91908 0.19431
        0.29167 0.33333 0.37107
        0.875 0.75 0.0
        0.79287 0.20713 0.21468
        0.33333 0.91667 0.60764
        0.08575 0.54287 0.47526
        0.70954 0.04046 0.74666
        0.91908 0.45954 0.80569
        0.29287 0.95713 0.48763
        0.20713 0.79287 0.09464
        0.37621 0.00241 0.1543
        0.0 0.0 0.76921
        0.25241 0.12621 0.11865
        0.04167 0.33333 0.37107
        0.95713 0.29287 0.51237
        0.45713 0.91426 0.78532
        0.33333 0.66667 0.01475
        0.08092 0.54046 0.23869
        0.625 0.625 0.96227
        0.875 0.125 0.0
        0.66667 0.33333 0.89736
        0.54167 0.45833 0.64368
        0.91667 0.45833 0.33333
        0.45954 0.54046 0.54801
        0.08092 0.54046 0.54801
        0.375 0.0 0.96227
        0.0 0.375 0.96227
        0.20713 0.41425 0.13902
        0.625 0.625 0.03773
        0.00242 0.62621 0.8457
        0.37621 0.00241 0.07999
        0.12379 0.87621 0.11865
        0.12379 0.87621 0.76121
        0.37621 0.37379 0.1543
        0.87379 0.12621 0.42798
        0.33333 0.66667 0.34798
        0.0 0.0 0.23079
        0.33333 0.66667 0.12956
        0.66908 0.95954 0.17904
        0.33333 0.66667 0.31859
        0.33333 0.66667 0.86753
        0.875 0.75 0.31035
        """

        self.coord = "relative"

        self.cages = """
        15 0.9999966666666668 1.0000033333333334 -0.7252466666666667
        12 0.0 0.5 0.0
        12 -0.49517333333333335 -0.9903466666666667 -0.8828066666666667
        12 0.49517333333333335 0.9903466666666667 0.8828066666666667
        12 -0.32368 -0.16184 0.21614
        14 0.0 0.0 0.03336
        12 0.9903466666666667 0.49517333333333335 -0.8828066666666667
        12 0.5 0.0 0.0
        14 0.33333333333333337 0.6666666666666667 0.7000266666666667
        15 0.9999966666666668 2.0000033333333334 1.3923233333333334
        12 0.8285066666666667 1.1714933333333333 1.5494733333333335
        12 0.6570133333333333 0.8285066666666667 0.45052666666666663
        14 0.6666666666666667 1.3333333333333335 1.3666933333333335
        12 0.33333333333333337 1.1666666666666667 0.6666666666666667
        12 -0.33333333333333337 -1.1666666666666667 -0.6666666666666667
        12 1.1666666666666667 0.33333333333333337 -0.6666666666666667
        12 0.8285066666666667 1.6570133333333334 1.5494733333333335
        12 0.16184 -0.16184 0.21614
        14 0.33333333333333337 0.6666666666666667 0.6333066666666667
        12 0.33333333333333337 0.6666666666666667 1.1666666666666667
        16 0.33333333333333337 0.6666666666666667 0.8217066666666667
        12 0.0 0.0 0.5
        12 0.49517333333333335 0.5048266666666666 0.8828066666666667
        12 0.16666666666666669 -0.16666666666666669 -0.6666666666666667
        16 0.0 0.0 -0.15504
        15 1.3333366666666666 0.6666633333333333 -0.7256566666666667
        15 0.66667 0.33333 -0.05899
        14 0.6666666666666667 0.33333333333333337 -0.7000266666666667
        16 0.33333333333333337 0.6666666666666667 0.5116266666666667
        12 0.6666666666666667 0.33333333333333337 -1.1666666666666667
        15 1.3333366666666666 1.6666633333333334 1.3919133333333333
        15 0.33333 0.66667 0.05899
        15 0.6666633333333333 1.3333366666666666 0.7256566666666667
        15 0.66667 0.33333 0.05858
        15 0.6666633333333333 1.3333366666666666 0.6080866666666667
        12 0.16184 0.32368 0.21614
        14 0.33333333333333337 0.6666666666666667 0.7518566666666667
        12 0.34298666666666666 1.1714933333333333 1.5494733333333335
        12 0.17149333333333333 0.8285066666666667 0.45052666666666663
        12 -0.5 -0.5 0.0
        14 0.6666666666666667 1.3333333333333335 1.4185233333333334
        15 0.33333 0.66667 -0.05858
        12 -0.49517333333333335 0.49517333333333335 -0.8828066666666667
        15 1.0000033333333334 0.9999966666666668 0.7252466666666667
        12 0.17149333333333333 0.34298666666666666 0.45052666666666663
        14 0.0 0.0 -0.03336
        12 0.8333333333333333 0.6666666666666667 0.6666666666666667
        12 0.32368 0.16184 -0.21614
        16 0.0 0.0 0.15504
        15 1.0000033333333334 0.9999966666666668 0.6076766666666666
        14 0.0 0.0 0.08519
        12 0.009653333333333333 0.5048266666666666 0.8828066666666667
        14 0.33333333333333337 0.6666666666666667 0.5814766666666666
        14 0.6666666666666667 0.33333333333333337 -0.7518566666666667
        16 0.6666666666666667 1.3333333333333335 1.4883733333333333
        12 -0.16184 0.16184 -0.21614
        14 0.0 0.0 -0.08519
        12 -0.16184 -0.32368 -0.21614
        16 0.6666666666666667 0.33333333333333337 -0.8217066666666667
        12 -0.16666666666666669 0.16666666666666669 0.6666666666666667
        """

        self.bondlen = 3

        self.cell = """
        12.74789394370694 0.0 0.0
        -6.373946971853467 11.040000000000004 0.0
        6.734097471900442e-15 1.1663798964452692e-14 109.97615764135395
        """

        self.density = 0.6604680335016991

        self.cell = cellvectors(a=12.74789394370694,
                                b=12.747893943706941,
                                c=109.97615764135395,
                                C=119.99999999999999)
