# coding: utf-8
"""
Data source: Dutour Sikirić, Mathieu, Olaf Delgado-Friedrichs, and Michel Deza. “Space Fullerenes: a Computer Search for New Frank-Kasper Structures” Acta Crystallographica Section A Foundations of Crystallography 66.Pt 5 (2010): 602–615.

Cage composition:
 (12,14,15,16) = (20,8,8,4,)
"""
from genice2.cell import cellvectors
import genice2.lattices
desc = {"ref": {"SpaceFullerene": 'Sikiric 2010'},
        "usage": "No options available.",
        "brief": "A space fullerene."
        }


class Lattice(genice2.lattices.Lattice):
    def __init__(self):
        self.pairs = """
        121 56
        209 89
        227 41
        169 122
        27 220
        153 93
        11 60
        95 2
        42 186
        89 173
        81 45
        119 143
        124 128
        64 134
        49 202
        7 41
        225 217
        21 68
        189 197
        111 37
        220 66
        155 89
        138 144
        136 204
        80 14
        67 180
        51 30
        154 110
        147 224
        33 3
        91 151
        97 214
        135 184
        82 201
        140 195
        198 134
        34 40
        126 187
        7 104
        156 193
        113 103
        188 163
        5 58
        132 34
        113 83
        114 84
        26 222
        46 73
        120 195
        193 97
        11 42
        24 37
        72 138
        115 189
        136 192
        182 81
        80 224
        42 144
        102 204
        191 208
        12 168
        28 200
        182 170
        111 40
        52 175
        63 218
        28 44
        148 171
        153 168
        16 38
        205 116
        124 189
        182 143
        216 97
        7 203
        116 83
        119 86
        120 96
        145 74
        207 209
        93 223
        173 65
        76 196
        6 225
        166 74
        102 138
        17 79
        220 75
        136 99
        89 10
        62 32
        41 56
        13 57
        15 180
        107 158
        221 167
        33 47
        59 88
        117 92
        72 216
        130 109
        183 208
        149 170
        12 154
        192 125
        153 20
        24 202
        71 58
        100 186
        160 48
        43 3
        92 67
        32 133
        187 213
        35 57
        35 123
        107 215
        81 157
        192 138
        43 203
        215 169
        145 64
        199 211
        110 48
        31 83
        202 70
        13 183
        130 217
        98 157
        22 177
        194 186
        87 49
        26 118
        6 159
        139 59
        39 142
        47 227
        102 210
        132 77
        122 161
        152 128
        211 36
        111 158
        221 115
        118 18
        217 48
        126 0
        64 176
        108 214
        141 174
        108 16
        95 37
        5 66
        121 84
        25 162
        6 219
        32 162
        113 172
        47 164
        6 223
        104 38
        117 71
        29 194
        82 196
        12 224
        160 128
        0 197
        126 98
        98 189
        141 103
        14 168
        191 46
        149 36
        114 9
        179 62
        194 106
        114 211
        97 152
        216 54
        31 179
        226 201
        131 20
        130 20
        176 221
        35 19
        51 185
        170 50
        200 144
        182 56
        216 166
        63 58
        160 197
        198 163
        25 174
        105 23
        187 127
        149 45
        90 96
        18 55
        200 125
        113 180
        135 199
        18 77
        158 101
        104 84
        105 223
        22 152
        16 203
        85 82
        28 161
        9 143
        12 62
        102 54
        75 69
        190 134
        207 139
        64 188
        23 44
        141 218
        132 164
        188 30
        77 165
        148 1
        137 84
        146 124
        8 24
        171 151
        29 4
        57 133
        137 50
        30 167
        122 196
        108 94
        137 87
        52 123
        24 195
        76 212
        145 193
        164 104
        27 208
        136 51
        135 53
        114 170
        112 226
        140 178
        4 20
        87 175
        156 106
        106 144
        39 88
        8 85
        35 69
        227 96
        215 206
        50 59
        215 69
        194 204
        184 91
        41 3
        192 167
        90 56
        163 115
        218 172
        148 34
        118 198
        68 53
        7 77
        121 199
        200 185
        120 209
        63 62
        100 78
        176 166
        14 186
        156 188
        80 210
        18 91
        1 178
        78 168
        90 50
        124 213
        159 185
        147 177
        95 49
        71 210
        72 221
        226 44
        165 227
        146 157
        68 73
        36 142
        116 70
        155 19
        94 9
        140 158
        207 129
        25 66
        199 81
        101 173
        60 67
        197 167
        155 183
        31 66
        87 129
        150 45
        74 181
        65 174
        179 78
        23 125
        120 101
        31 133
        42 210
        10 70
        112 218
        119 61
        86 214
        219 75
        135 142
        160 177
        206 123
        33 38
        45 184
        8 46
        150 17
        96 2
        159 161
        117 100
        43 86
        107 191
        171 79
        205 49
        103 70
        26 115
        21 184
        99 159
        176 222
        60 100
        105 110
        54 181
        150 151
        52 53
        4 152
        121 129
        147 110
        153 225
        154 225
        39 40
        149 88
        73 123
        156 72
        146 127
        21 88
        51 106
        67 161
        53 129
        117 204
        21 178
        95 101
        105 76
        111 206
        140 46
        145 108
        68 139
        190 222
        137 2
        5 78
        130 128
        92 226
        209 202
        175 59
        90 207
        169 180
        0 109
        212 32
        13 162
        185 217
        34 55
        164 2
        65 83
        15 107
        0 131
        85 169
        25 63
        131 177
        29 181
        13 10
        3 143
        75 133
        29 193
        112 71
        22 80
        57 116
        154 212
        219 122
        1 91
        8 206
        213 109
        119 157
        125 48
        74 61
        174 10
        141 201
        58 224
        27 76
        147 93
        112 11
        26 151
        165 195
        219 212
        132 37
        85 103
        183 73
        22 54
        118 203
        55 79
        196 44
        38 9
        211 127
        126 61
        33 190
        16 134
        163 213
        223 220
        99 92
        171 190
        15 65
        15 201
        94 127
        208 69
        191 82
        178 40
        166 86
        98 150
        131 181
        43 222
        19 175
        142 55
        23 99
        205 173
        5 93
        4 14
        28 11
        148 47
        179 172
        155 139
        198 79
        60 172
        165 1
        94 61
        27 162
        19 205
        17 36
        109 30
        187 17
        146 214
        52 39
        """

        self.waters = """
        0.5 0.15567 0.77215
        0.69331 0.86637 0.45915
        0.375 0.5652 0.41215
        0.69331 0.56638 0.57386
        0.1875 0.38637 0.84965
        0.5 0.36613 0.02439
        0.31831 0.05807 0.0122
        0.0 0.63387 0.52439
        0.0 0.84433 0.27215
        0.375 0.4348 0.58785
        0.8125 0.43612 0.22715
        0.0 0.69851 0.00179
        0.0 0.30149 0.99821
        0.875 0.27536 0.21366
        0.125 0.4348 0.91215
        0.5 0.72452 0.17388
        0.18169 0.61388 0.62425
        0.375 0.06289 0.60206
        0.0 0.88387 0.52439
        0.375 0.27536 0.28634
        0.3125 0.25927 0.86244
        0.69331 0.05554 0.41193
        0.8125 0.38637 0.84965
        0.68169 0.94194 0.98781
        0.0 0.72452 0.32612
        0.68169 0.38612 0.12425
        0.81831 0.86697 0.63846
        0.68169 0.13303 0.13846
        0.0 0.82351 0.00179
        0.3125 0.49852 0.82544
        0.375 0.91236 0.79775
        0.31831 0.38612 0.12425
        0.0 0.2365 0.11305
        0.5 0.65118 0.56404
        0.30669 0.86637 0.45915
        0.25 0.18034 0.25
        0.30669 0.13363 0.54085
        0.1875 0.74073 0.36244
        0.30669 0.56638 0.57386
        0.30669 0.05554 0.41193
        0.375 0.93711 0.39794
        0.81831 0.56694 0.5122
        0.0 0.65118 0.93596
        0.81831 0.61388 0.62425
        0.80669 0.86637 0.04085
        0.69331 0.13363 0.54085
        0.8125 0.93358 0.28564
        0.5 0.69851 0.49821
        0.875 0.06289 0.89794
        0.1875 0.50149 0.32544
        0.5 0.34883 0.43596
        0.31831 0.86697 0.86154
        0.18169 0.13303 0.36154
        0.0 0.17842 0.39836
        0.6875 0.49852 0.82544
        0.18169 0.94194 0.5122
        0.81831 0.43307 0.48781
        0.125 0.27536 0.21366
        0.68169 0.43307 0.0122
        0.5 0.2365 0.38695
        0.19331 0.64944 0.03601
        0.5 0.3558 0.69083
        0.0 0.34883 0.06404
        0.80669 0.43363 0.07386
        0.375 0.72464 0.71366
        0.5 0.56722 0.19741
        0.5 0.33649 0.0968
        0.31831 0.75924 0.06287
        0.81831 0.13303 0.36154
        0.375 0.08764 0.20225
        0.0 0.53205 0.23926
        0.68169 0.56694 0.98781
        0.875 0.72464 0.78634
        0.875 0.08764 0.29775
        0.5 0.46795 0.73926
        0.31831 0.13303 0.13846
        0.80669 0.05554 0.08807
        0.0 0.76153 0.47551
        0.31831 0.43307 0.0122
        0.30669 0.94447 0.58807
        0.875 0.4348 0.91215
        0.81831 0.24076 0.56287
        0.8125 0.86054 0.16456
        0.3125 0.50149 0.17456
        0.18169 0.43307 0.48781
        0.0 0.79918 0.2002
        0.8125 0.49852 0.67456
        0.18169 0.38612 0.37575
        0.5 0.12881 0.4266
        0.6875 0.43612 0.27285
        0.69331 0.43363 0.42614
        0.81831 0.94194 0.5122
        0.5 0.76153 0.02449
        0.5 0.23847 0.97551
        0.3125 0.38637 0.65035
        0.3125 0.61363 0.34965
        0.625 0.5652 0.41215
        0.0 0.46795 0.76074
        0.6875 0.13946 0.66456
        0.5 0.88387 0.97561
        0.31831 0.56694 0.98781
        0.5 0.6442 0.30917
        0.68169 0.61388 0.87575
        0.0 0.6442 0.19083
        0.18169 0.56694 0.5122
        0.68169 0.05807 0.0122
        0.19331 0.74407 0.84875
        0.5 0.84433 0.22785
        0.1875 0.49852 0.67456
        0.3125 0.06643 0.78564
        0.80669 0.13363 0.95915
        0.3125 0.86054 0.33544
        0.80669 0.64944 0.03601
        0.1875 0.61363 0.15035
        0.30669 0.35056 0.53601
        0.875 0.91236 0.70225
        0.1875 0.43612 0.22715
        0.5 0.63387 0.97561
        0.0 0.82158 0.60164
        0.6875 0.38637 0.65035
        0.6875 0.61363 0.34965
        0.0 0.36613 0.47561
        0.125 0.93711 0.10206
        0.125 0.08764 0.29775
        0.0 0.15567 0.72785
        0.80669 0.94447 0.91193
        0.5 0.20082 0.7002
        0.1875 0.25927 0.63756
        0.0 0.20082 0.79981
        0.0 0.33649 0.4032
        0.1875 0.13946 0.83544
        0.5 0.27548 0.82612
        0.18169 0.75924 0.43713
        0.19331 0.25593 0.15125
        0.30669 0.74407 0.65125
        0.0 0.11613 0.47561
        0.5 0.82158 0.89836
        0.30669 0.43363 0.42614
        0.80669 0.74407 0.84875
        0.69331 0.25593 0.34875
        0.6875 0.86054 0.33544
        0.8125 0.61363 0.15035
        0.18169 0.05807 0.48781
        0.625 0.4348 0.58785
        0.0 0.7635 0.88695
        0.3125 0.56389 0.72715
        0.0 0.27548 0.67388
        0.68169 0.24076 0.93713
        0.5 0.82351 0.49821
        0.5 0.17649 0.50179
        0.625 0.06289 0.60206
        0.69331 0.94447 0.58807
        0.0 0.3558 0.80917
        0.31831 0.24076 0.93713
        0.0 0.17649 0.99821
        0.625 0.27536 0.28634
        0.125 0.72464 0.78634
        0.8125 0.25927 0.63756
        0.5 0.79918 0.29981
        0.31831 0.94194 0.98781
        0.8125 0.13946 0.83544
        0.19331 0.86637 0.04085
        0.80669 0.25593 0.15125
        0.125 0.91236 0.70225
        0.30669 0.64944 0.464
        0.81831 0.75924 0.43713
        0.6875 0.56389 0.72715
        0.625 0.91236 0.79775
        0.19331 0.35056 0.964
        0.1875 0.86054 0.16456
        0.5 0.30149 0.50179
        0.5 0.8712 0.57341
        0.125 0.5652 0.08785
        0.5 0.53205 0.26074
        0.6875 0.50149 0.17456
        0.30669 0.25593 0.34875
        0.625 0.72464 0.71366
        0.6875 0.25927 0.86244
        0.625 0.93711 0.39794
        0.19331 0.43363 0.07386
        0.3125 0.74073 0.13756
        0.5 0.43278 0.80259
        0.69331 0.35056 0.53601
        0.75 0.18034 0.25
        0.81831 0.05807 0.48781
        0.19331 0.94447 0.91193
        0.19331 0.56638 0.92614
        0.3125 0.13946 0.66456
        0.25 0.81966 0.75
        0.8125 0.06643 0.71436
        0.5 0.7635 0.61305
        0.6875 0.93358 0.21436
        0.68169 0.86697 0.86154
        0.1875 0.56389 0.77285
        0.31831 0.61388 0.87575
        0.8125 0.74073 0.36244
        0.875 0.93711 0.10206
        0.6875 0.06643 0.78564
        0.18169 0.86697 0.63846
        0.0 0.23847 0.52449
        0.0 0.8712 0.9266
        0.6875 0.74073 0.13756
        0.0 0.56722 0.30259
        0.0 0.66351 0.5968
        0.5 0.66351 0.9032
        0.3125 0.43612 0.27285
        0.1875 0.93358 0.28564
        0.81831 0.38612 0.37575
        0.625 0.08764 0.20225
        0.8125 0.50149 0.32544
        0.80669 0.56638 0.92614
        0.18169 0.24076 0.56287
        0.0 0.12881 0.07341
        0.1875 0.06643 0.71436
        0.0 0.43278 0.69741
        0.3125 0.93358 0.21436
        0.8125 0.56389 0.77285
        0.125 0.06289 0.89794
        0.875 0.5652 0.08785
        0.19331 0.05554 0.08807
        0.5 0.17842 0.10164
        0.75 0.81966 0.75
        0.69331 0.74407 0.65125
        0.5 0.11613 0.02439
        0.80669 0.35056 0.964
        0.19331 0.13363 0.95915
        0.68169 0.75924 0.06287
        0.69331 0.64944 0.464
        """

        self.coord = "relative"

        self.cages = """
        16 0.0 0.06082 0.60745
        16 0.5 0.93918 0.10745
        16 0.5 0.06082 0.89255
        16 0.0 0.93918 0.39255
        12 0.0 0.0 0.0
        12 0.5 0.0 0.5
        12 0.0 0.75857 0.10472
        12 0.5 0.24143 0.60472
        12 0.5 0.75857 0.39528
        12 0.0 0.24143 0.89528
        14 0.25 0.69372 0.25
        14 0.25 0.30628 0.75
        14 0.75 0.30628 0.75
        14 0.75 0.69372 0.25
        12 0.27324 0.23226 0.04878
        12 0.22676 0.76774 0.54878
        12 0.22676 0.23226 0.45122
        12 0.72676 0.76774 0.95122
        12 0.27324 0.76774 0.95122
        12 0.77324 0.23226 0.45122
        12 0.77324 0.76774 0.54878
        12 0.72676 0.23226 0.04878
        12 0.0 0.43078 0.15859
        12 0.5 0.56922 0.65859
        12 0.5 0.43078 0.34141
        12 0.0 0.56922 0.84141
        15 0.0 0.0507 0.19606
        15 0.5 0.9493 0.69606
        15 0.5 0.0507 0.30394
        15 0.0 0.9493 0.80394
        15 0.0 0.57146 0.41192
        15 0.5 0.42854 0.91192
        15 0.5 0.57146 0.08808
        15 0.0 0.42854 0.58808
        12 0.0 0.5 0.0
        12 0.5 0.5 0.5
        14 0.0 0.30998 0.29844
        14 0.5 0.69002 0.79844
        14 0.5 0.30998 0.20156
        14 0.0 0.69002 0.70156
        """

        self.bondlen = 3

        self.cell = """
        14.664956324039728 22.080000000000002 45.244167763551516
        """

        self.density = 0.46518334143880274

        self.cell = cellvectors(a=14.664956324039728,
                                b=22.080000000000002,
                                c=45.244167763551516)
