# coding: utf-8
"""
Data source: Dutour Sikirić, Mathieu, Olaf Delgado-Friedrichs, and Michel Deza. “Space Fullerenes: a Computer Search for New Frank-Kasper Structures” Acta Crystallographica Section A Foundations of Crystallography 66.Pt 5 (2010): 602–615.

Cage composition:
 (12,14,15,16) = (20,8,8,4,)
"""
from genice2.cell import cellvectors
import genice2.lattices
desc = {"ref": {"SpaceFullerene": 'Sikiric 2010'},
        "usage": "No options available.",
        "brief": "A space fullerene."
        }


class Lattice(genice2.lattices.Lattice):
    def __init__(self):
        self.pairs = """
        225 116
        199 213
        9 185
        40 207
        197 152
        112 98
        72 215
        28 173
        138 153
        32 19
        71 184
        6 10
        192 66
        142 137
        94 201
        137 116
        113 111
        49 34
        42 77
        218 227
        82 186
        47 124
        112 43
        37 122
        6 152
        200 131
        20 1
        142 156
        208 134
        20 139
        174 155
        183 76
        219 177
        19 97
        32 123
        4 195
        151 189
        100 89
        170 3
        38 140
        147 30
        147 202
        132 75
        113 177
        61 149
        98 0
        56 183
        38 60
        93 124
        188 22
        112 86
        126 199
        17 111
        190 180
        144 48
        13 167
        121 55
        162 204
        53 118
        194 30
        12 15
        220 128
        87 212
        117 158
        221 86
        99 19
        115 33
        70 212
        135 83
        25 68
        101 158
        115 80
        1 199
        48 128
        148 7
        44 124
        71 122
        2 104
        204 212
        211 70
        225 160
        51 57
        120 66
        157 184
        59 133
        7 88
        82 14
        185 56
        27 150
        114 133
        207 15
        132 175
        17 139
        223 95
        129 195
        215 144
        216 131
        135 136
        163 164
        86 96
        182 191
        203 11
        25 164
        32 100
        83 119
        54 127
        61 91
        13 88
        57 78
        187 116
        41 128
        198 157
        25 62
        29 87
        102 21
        175 122
        145 75
        161 176
        197 45
        34 134
        125 225
        46 24
        124 222
        16 85
        156 118
        55 68
        65 141
        135 37
        13 143
        161 88
        211 172
        223 45
        8 81
        208 169
        28 142
        76 90
        57 178
        217 194
        170 180
        91 176
        59 187
        145 122
        62 23
        70 140
        109 101
        89 97
        91 207
        203 100
        1 58
        64 11
        94 158
        139 85
        17 65
        80 98
        87 175
        136 78
        142 11
        121 154
        93 226
        14 129
        182 203
        35 103
        217 201
        138 107
        65 95
        179 133
        4 24
        104 155
        36 98
        166 131
        91 186
        159 141
        19 172
        11 123
        45 208
        210 206
        174 191
        20 92
        156 187
        24 164
        26 165
        102 48
        7 63
        169 150
        61 110
        216 44
        185 3
        22 196
        148 92
        102 30
        219 179
        106 70
        193 116
        171 34
        78 163
        117 153
        90 180
        211 183
        161 92
        210 188
        69 74
        26 15
        9 110
        114 169
        52 104
        192 46
        110 47
        121 18
        38 17
        42 173
        156 114
        90 60
        108 200
        121 89
        12 23
        6 67
        8 74
        7 73
        196 123
        163 84
        135 96
        83 27
        217 101
        115 97
        178 157
        120 79
        223 111
        201 179
        84 4
        37 29
        69 191
        193 224
        16 92
        179 208
        132 52
        146 206
        41 21
        219 153
        146 215
        166 170
        5 199
        126 6
        65 67
        127 44
        8 154
        9 54
        139 213
        198 129
        55 50
        185 205
        130 202
        67 85
        73 58
        41 63
        151 181
        167 226
        39 165
        47 205
        204 171
        176 31
        59 160
        96 163
        108 170
        44 33
        88 198
        51 184
        227 186
        41 198
        127 31
        64 118
        134 77
        5 206
        147 12
        12 105
        77 155
        126 214
        120 194
        168 118
        51 24
        30 160
        138 49
        73 107
        189 22
        107 79
        21 178
        18 81
        166 33
        81 27
        146 225
        52 83
        105 46
        197 34
        2 53
        209 84
        224 176
        220 129
        99 60
        182 189
        209 103
        108 205
        39 47
        109 206
        37 112
        222 23
        80 56
        39 149
        32 141
        66 4
        28 188
        110 226
        219 63
        99 196
        109 187
        28 182
        58 214
        87 183
        136 145
        130 40
        216 149
        81 191
        166 89
        189 190
        75 74
        173 174
        71 43
        220 66
        25 165
        53 77
        171 140
        132 96
        168 188
        68 200
        226 186
        61 127
        102 105
        130 26
        95 152
        137 210
        5 193
        117 133
        36 33
        218 202
        192 48
        125 224
        79 201
        154 131
        26 46
        125 207
        0 76
        5 227
        74 68
        62 78
        178 84
        195 103
        148 177
        204 155
        10 196
        151 69
        43 54
        162 223
        29 119
        106 119
        153 128
        105 57
        2 27
        151 55
        42 168
        90 141
        211 60
        162 150
        145 51
        10 213
        113 49
        149 15
        202 222
        16 193
        101 215
        18 181
        72 194
        43 143
        222 165
        93 218
        209 143
        171 111
        138 94
        2 181
        123 67
        50 97
        38 10
        75 164
        115 205
        114 173
        100 180
        159 0
        144 117
        18 203
        94 134
        35 9
        130 72
        167 103
        54 36
        217 59
        22 64
        53 169
        29 0
        157 143
        82 161
        184 195
        162 119
        20 113
        197 214
        69 104
        93 31
        167 14
        13 31
        73 14
        174 150
        3 36
        39 200
        106 95
        1 82
        218 224
        79 63
        144 160
        221 35
        210 213
        190 50
        40 146
        3 76
        177 45
        62 154
        42 158
        40 227
        140 152
        221 56
        52 212
        175 221
        168 109
        108 50
        136 8
        216 23
        209 86
        126 16
        181 64
        120 21
        99 190
        137 85
        220 107
        159 172
        71 35
        147 125
        192 72
        106 159
        80 172
        148 214
        49 58
        """

        self.waters = """
        0.16264 0.4375 0.49351
        0.0927 0.06449 0.04531
        0.54681 0.75 0.37527
        0.02992 0.25 0.56627
        0.42245 0.93551 0.79471
        0.90584 0.875 0.04308
        0.04876 0.75 0.21636
        0.22767 0.625 0.98527
        0.59416 0.375 0.54308
        0.0872 0.125 0.69885
        0.99294 0.93949 0.2454
        0.80349 0.56051 0.29817
        0.69651 0.43949 0.79817
        0.14739 0.625 0.84245
        0.18427 0.0 0.9168
        0.76569 0.25 0.80498
        0.99854 0.56051 0.08839
        0.09325 0.25 0.25589
        0.68583 0.56051 0.43826
        0.97008 0.75 0.43373
        0.11035 0.25 0.09813
        0.4554 0.5625 0.87513
        0.80349 0.93949 0.29817
        0.72413 0.56449 0.72973
        0.50706 0.06051 0.7454
        0.64739 0.875 0.65755
        0.69651 0.06051 0.79817
        0.49854 0.56051 0.41162
        0.71825 0.25 0.26635
        0.27233 0.375 0.48527
        0.63531 0.5625 0.92322
        0.03964 0.56449 0.82976
        0.94721 0.5625 0.38235
        0.9554 0.5625 0.62487
        0.30349 0.93949 0.20183
        0.19651 0.06051 0.70183
        0.05279 0.4375 0.61766
        0.31417 0.43949 0.56174
        0.07756 0.06449 0.29471
        0.80899 0.06051 0.69772
        0.81417 0.06051 0.93826
        0.36728 0.4375 0.92724
        0.57756 0.06449 0.20529
        0.19651 0.43949 0.70183
        0.92245 0.56449 0.70529
        0.30349 0.56051 0.20183
        0.5872 0.125 0.80115
        0.92245 0.93551 0.70529
        0.52992 0.25 0.93373
        0.27265 0.06449 0.12136
        0.83736 0.9375 0.50649
        0.45124 0.25 0.71636
        0.40584 0.875 0.45692
        0.54876 0.75 0.28364
        0.0872 0.375 0.69885
        0.72767 0.875 0.51473
        0.13531 0.9375 0.57678
        0.50706 0.43949 0.7454
        0.18583 0.93949 0.06174
        0.63272 0.5625 0.07276
        0.0446 0.0625 0.37513
        0.95124 0.25 0.78364
        0.64739 0.625 0.65755
        0.33736 0.5625 0.99351
        0.73431 0.75 0.30498
        0.07756 0.43551 0.29471
        0.4554 0.9375 0.87513
        0.99294 0.56051 0.2454
        0.68427 0.0 0.5832
        0.5927 0.06449 0.45469
        0.22331 0.875 0.38343
        0.26569 0.25 0.69503
        0.63531 0.9375 0.92322
        0.22767 0.875 0.98527
        0.59416 0.125 0.54308
        0.50146 0.06051 0.58839
        0.09739 0.25 0.49278
        0.49294 0.93949 0.2546
        0.53964 0.56449 0.67024
        0.40261 0.75 0.99278
        0.08812 0.75 0.55211
        0.5927 0.43551 0.45469
        0.09416 0.125 0.95692
        0.40584 0.625 0.45692
        0.40676 0.75 0.75589
        0.96036 0.43551 0.17024
        0.27221 0.75 0.64127
        0.27233 0.125 0.48527
        0.18427 0.5 0.9168
        0.83736 0.5625 0.50649
        0.02734 0.25 0.41673
        0.95319 0.25 0.87527
        0.0927 0.43551 0.04531
        0.97227 0.75 0.82899
        0.44721 0.9375 0.11766
        0.19101 0.56051 0.30229
        0.38966 0.75 0.59813
        0.90261 0.75 0.50722
        0.13531 0.5625 0.57678
        0.94721 0.9375 0.38235
        0.8647 0.4375 0.42322
        0.63272 0.9375 0.07276
        0.55279 0.4375 0.88235
        0.22413 0.93551 0.77027
        0.49854 0.93949 0.41162
        0.5872 0.375 0.80115
        0.22331 0.625 0.38343
        0.33736 0.9375 0.99351
        0.86728 0.0625 0.57276
        0.72331 0.875 0.11657
        0.00706 0.06051 0.7546
        0.21825 0.25 0.23366
        0.22735 0.56449 0.62136
        0.22779 0.25 0.14127
        0.57756 0.43551 0.20529
        0.97267 0.75 0.58327
        0.81573 0.5 0.0832
        0.52734 0.25 0.08327
        0.67376 0.75 0.24625
        0.31573 0.5 0.4168
        0.47267 0.75 0.91673
        0.72767 0.625 0.51473
        0.34096 0.25 0.60559
        0.9128 0.625 0.30115
        0.90676 0.75 0.74411
        0.81417 0.43949 0.93826
        0.04681 0.75 0.12473
        0.00706 0.43949 0.7546
        0.41748 0.25 0.95913
        0.2767 0.125 0.88343
        0.72735 0.93551 0.87864
        0.7767 0.375 0.61657
        0.4073 0.93551 0.54531
        0.5446 0.4375 0.12487
        0.4128 0.875 0.19885
        0.4073 0.56449 0.54531
        0.50146 0.43949 0.58839
        0.85261 0.375 0.15755
        0.3647 0.0625 0.07678
        0.02773 0.25 0.17102
        0.19101 0.93949 0.30229
        0.0446 0.4375 0.37513
        0.77588 0.43551 0.22973
        0.22413 0.56449 0.77027
        0.59739 0.25 0.00722
        0.45319 0.25 0.62473
        0.77233 0.125 0.01473
        0.72735 0.56449 0.87864
        0.18583 0.56051 0.06174
        0.82624 0.25 0.74625
        0.46036 0.43551 0.32976
        0.68583 0.93949 0.43826
        0.17376 0.75 0.25375
        0.41188 0.25 0.05211
        0.68427 0.5 0.5832
        0.46036 0.06449 0.32976
        0.69101 0.56051 0.19772
        0.30899 0.43949 0.80229
        0.5446 0.0625 0.12487
        0.13272 0.5625 0.42724
        0.66264 0.4375 0.00649
        0.09416 0.375 0.95692
        0.35261 0.375 0.34245
        0.47227 0.75 0.67102
        0.53964 0.93551 0.67024
        0.72413 0.93551 0.72973
        0.86728 0.4375 0.57276
        0.14739 0.875 0.84245
        0.69101 0.93949 0.19772
        0.49294 0.56051 0.2546
        0.91748 0.25 0.54088
        0.27588 0.06449 0.27027
        0.08252 0.75 0.45913
        0.59325 0.25 0.24411
        0.52773 0.25 0.32899
        0.31417 0.06051 0.56174
        0.00146 0.43949 0.91162
        0.27265 0.43551 0.12136
        0.42245 0.56449 0.79471
        0.44721 0.5625 0.11766
        0.91188 0.25 0.44789
        0.65904 0.75 0.39441
        0.72779 0.25 0.35873
        0.16264 0.0625 0.49351
        0.32624 0.25 0.75375
        0.05279 0.0625 0.61766
        0.00146 0.06051 0.91162
        0.72331 0.625 0.11657
        0.77588 0.06449 0.22973
        0.77265 0.06449 0.37864
        0.8647 0.0625 0.42322
        0.61035 0.25 0.40188
        0.55279 0.0625 0.88235
        0.90584 0.625 0.04308
        0.58812 0.75 0.94789
        0.30899 0.06051 0.80229
        0.9128 0.875 0.30115
        0.23431 0.75 0.19503
        0.2767 0.375 0.88343
        0.99854 0.93949 0.08839
        0.7767 0.125 0.61657
        0.47008 0.75 0.06627
        0.77221 0.75 0.85873
        0.77265 0.43551 0.37864
        0.35261 0.125 0.34245
        0.9554 0.9375 0.62487
        0.81573 0.0 0.0832
        0.84096 0.25 0.89441
        0.4128 0.625 0.19885
        0.28176 0.75 0.73366
        0.85261 0.125 0.15755
        0.13272 0.9375 0.42724
        0.31573 0.0 0.4168
        0.96036 0.06449 0.17024
        0.15904 0.75 0.10559
        0.66264 0.0625 0.00649
        0.80899 0.43949 0.69772
        0.58252 0.75 0.04088
        0.88966 0.75 0.90188
        0.3647 0.4375 0.07678
        0.36728 0.0625 0.92724
        0.22735 0.93551 0.62136
        0.78176 0.75 0.76635
        0.27588 0.43551 0.27027
        0.9073 0.56449 0.95469
        0.77233 0.375 0.01473
        0.03964 0.93551 0.82976
        0.9073 0.93551 0.95469
        """

        self.coord = "relative"

        self.cages = """
        12 0.36818 -0.49204 0.67832
        12 -0.06906 1.25 -0.33359
        15 -0.06125 0.25 -0.96705
        12 0.13182 0.00796 0.17832
        14 -0.23899 0.75 -0.00291
        12 -0.5 0.5 -1.0
        14 0.29919 -0.25 0.87245
        15 -0.13766 0.75 -0.82478
        14 -0.26101 0.25 -0.50291
        12 0.31126 -0.25 1.09868
        12 -0.18874 0.75 -0.59868
        15 -0.43875 0.75 -0.46705
        16 -0.40853 0.75 -0.20553
        12 0.43094 -0.75 0.83359
        12 -0.36818 0.00796 -0.67832
        12 -0.43094 -0.25 -0.83359
        14 0.23899 0.25 0.00291
        14 -0.29919 0.25 -0.87245
        12 -0.31126 0.25 -1.09868
        16 -0.09147 0.25 -0.70553
        16 0.09147 -0.25 0.70553
        12 0.06906 0.75 0.33359
        15 0.43875 0.25 0.46705
        14 -0.20081 0.75 -0.37245
        12 0.18874 0.25 0.59868
        15 0.36234 -0.25 1.32478
        12 0.36818 -0.00796 0.67832
        16 0.40853 0.25 0.20553
        12 -0.36818 0.49204 -0.67832
        14 0.26101 -0.25 0.50291
        12 -0.13182 0.50796 -0.17832
        15 0.06125 -0.25 0.96705
        12 0.0 0.5 -0.5
        12 0.5 0.0 1.0
        14 0.20081 0.25 0.37245
        12 -0.13182 -0.00796 -0.17832
        15 0.13766 0.25 0.82478
        12 0.0 0.0 0.5
        12 0.13182 -0.50796 0.17832
        15 -0.36234 0.25 -1.32478
        """

        self.bondlen = 3

        self.cell = """
        28.672684987170673 14.650476121803912 36.53891236784703
        """

        self.density = 0.4440080896067617

        self.cell = cellvectors(a=28.672684987170673,
                                b=14.650476121803912,
                                c=36.53891236784703)
