##################################### TERMS OF USE ###########################################
# The following code is provided for demonstration purpose only, and should not be used      #
# without independent verification. Recorded Future makes no representations or warranties,  #
# express, implied, statutory, or otherwise, regarding any aspect of this code or of the     #
# information it may retrieve, and provides it both strictly “as-is” and without assuming    #
# responsibility for any information it may retrieve. Recorded Future shall not be liable    #
# for, and you assume all risk of using, the foregoing. By using this code, Customer         #
# represents that it is solely responsible for having all necessary licenses, permissions,   #
# rights, and/or consents to connect to third party APIs, and that it is solely responsible  #
# for having all necessary licenses, permissions, rights, and/or consents to any data        #
# accessed from any third party API.                                                         #
##############################################################################################

from typing import Optional

from pydantic import Field

from ...common_models import RFBaseModel
from ..models.common_models import PBAInsiktNote, ResolvedEntity
from ..models.panel_status import PanelStatus


class CyberVulnerabilityPanelStatus(PanelStatus):
    risk_score: Optional[int] = None
    entity_criticality: Optional[str] = None
    targets: Optional[list[ResolvedEntity]] = []
    lifecycle_stage: Optional[str] = None


class VulnerabilityRiskRules(RFBaseModel):
    rule: str
    description: str


class VulnerabilitySummary(RFBaseModel):
    targets: Optional[list[ResolvedEntity]] = []
    lifecycle_stage: Optional[str] = None
    risk_rules: Optional[list[VulnerabilityRiskRules]] = []


class CyberVulnerabilityPanelEvidence(RFBaseModel):
    summary: Optional[VulnerabilitySummary] = Field(default_factory=VulnerabilitySummary)
    affected_products: Optional[list[ResolvedEntity]] = []
    insikt_notes: Optional[list[PBAInsiktNote]] = []
