/**
 * \file
 * \brief PKCS11 Library Operating System Abstraction
 *
 * \copyright (c) 2015-2020 Microchip Technology Inc. and its subsidiaries.
 *
 * \page License
 *
 * Subject to your compliance with these terms, you may use Microchip software
 * and any derivatives exclusively with Microchip products. It is your
 * responsibility to comply with third party license terms applicable to your
 * use of third party software (including open source software) that may
 * accompany Microchip software.
 *
 * THIS SOFTWARE IS SUPPLIED BY MICROCHIP "AS IS". NO WARRANTIES, WHETHER
 * EXPRESS, IMPLIED OR STATUTORY, APPLY TO THIS SOFTWARE, INCLUDING ANY IMPLIED
 * WARRANTIES OF NON-INFRINGEMENT, MERCHANTABILITY, AND FITNESS FOR A
 * PARTICULAR PURPOSE. IN NO EVENT WILL MICROCHIP BE LIABLE FOR ANY INDIRECT,
 * SPECIAL, PUNITIVE, INCIDENTAL OR CONSEQUENTIAL LOSS, DAMAGE, COST OR EXPENSE
 * OF ANY KIND WHATSOEVER RELATED TO THE SOFTWARE, HOWEVER CAUSED, EVEN IF
 * MICROCHIP HAS BEEN ADVISED OF THE POSSIBILITY OR THE DAMAGES ARE
 * FORESEEABLE. TO THE FULLEST EXTENT ALLOWED BY LAW, MICROCHIP'S TOTAL
 * LIABILITY ON ALL CLAIMS IN ANY WAY RELATED TO THIS SOFTWARE WILL NOT EXCEED
 * THE AMOUNT OF FEES, IF ANY, THAT YOU HAVE PAID DIRECTLY TO MICROCHIP FOR
 * THIS SOFTWARE.
 */

#ifndef PKCS11_OS_H_
#define PKCS11_OS_H_

#include "cryptoki.h"
#include "cryptoauthlib.h"

#define ATCA_SHARED_MUTEX_NAME "atca_shared_mutex"

CK_RV pkcs11_os_create_mutex(CK_VOID_PTR_PTR ppMutex);
CK_RV pkcs11_os_destroy_mutex(CK_VOID_PTR pMutex);
CK_RV pkcs11_os_lock_mutex(CK_VOID_PTR pMutex);
CK_RV pkcs11_os_unlock_mutex(CK_VOID_PTR pMutex);

CK_RV pkcs11_os_alloc_shared_ctx(void ** ppShared, size_t size);
CK_RV pkcs11_os_free_shared_ctx(void * pShared, size_t size);

#define pkcs11_os_malloc    hal_malloc
#define pkcs11_os_free      hal_free

#endif /* PKCS11_OS_H_ */
