# txt2ebook

A console tool to convert txt file to different ebook formats.

## Installation

Stable version From PyPI:

```console
uv tool install txt2ebook
```

Upgrade to latest stable version:

```console
uv tool upgrade txt2ebook
```

## Usage

Showing help message of command-line options:

```console
txt2ebook --help
```

<!--help !-->

```console
usage: txt2ebook [-of OUTPUT_FOLDER] [-p] [-y] [-l LANGUAGE] [-rw] [-q] [-v]
                 [-d] [-h] [-V]
                 {env,epub,gmi,massage,md,parse,pdf,tex,typ} ...

txt2ebook/tte is a cli tool to convert txt file to ebook format.

website: https://github.com/kianmeng/txt2ebook
changelog: https://github.com/kianmeng/txt2ebook/blob/master/CHANGELOG.md
issues: https://github.com/kianmeng/txt2ebook/issues

positional arguments:
  {env,epub,gmi,massage,md,parse,pdf,tex,typ}
      sub-command help
    env
      print environment information for bug reporting
    epub
      generate ebook in EPUB format
    gmi
      generate ebook in Gemtext format
    massage
      massage the source txt file
    md
      generate ebook in Markdown format
    parse
      parse and validate the txt file
    pdf
      generate ebook in Markdown format
    tex
      generate ebook in TeX/PDF format
    typ
      generate ebook in Typst format

options:
  -of, --output-folder OUTPUT_FOLDER
      set default output folder (default: 'output')
  -p, --purge
      remove converted ebooks specified by --output-folder option (default: 'False')
  -y, --yes
      assume yes to all prompts (default: 'False')
  -l, --language LANGUAGE
      language of the ebook (default: 'None')
  -rw, --raise-on-warning
      raise exception and stop parsing upon warning
  -q, --quiet
      suppress all logging
  -v, --verbose
      show verbosity of debugging log, use -vv, -vvv for more details
  -d, --debug
      show debugging log and stacktrace
  -h, --help
      show this help message and exit
  -V, --version
      show program's version number and exit
```

<!--help !-->

Convert a txt file into epub:

```console
txt2ebook ebook.txt
```

## Copyright and License

Copyright (c) 2021,2022,2023,2024,2025 Kian-Meng Ang

This program is free software: you can redistribute it and/or modify it under
the terms of the GNU Affero General Public License as published by the Free
Software Foundation, either version 3 of the License, or (at your option) any
later version.

This program is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
PARTICULAR PURPOSE. See the GNU Affero General Public License for more details.

You should have received a copy of the GNU Affero General Public License along
with this program. If not, see <https://www.gnu.org/licenses/>.

The fish logo used in the documentation generated by Sphinx is a public domain
drawing of Troschel's parrotfish (Chlorurus troschelii Var. A.) from
<https://commons.wikimedia.org/entity/M18506436>.
18506436>.
