🌟 ModXPy — The Python Module Universe at Your Fingertips 

Welcome to ModXPy, the ultimate playground for Python’s modules.  
With ModXPy you can instantly import, explore, and experiment with the entire Python standard library — plus any installed third-party modules — all from one simple interface.

UPDATE 2.0.0---

MAJOR UPDATE!!! BIGGEST UPDATE YET!!!

MESSAGE FROM THE CREATOR

As the creator of ModX, I am very proud
to see that ModX has not just upgraded, 
but evolved from 1.0 to 2.0. To celebrate
such a big update (ModX 1 to ModX 2) this
will be the biggest update I've dropped
yet, hence the long update interval between 
1.9 and 2.0. The update adds not 1, not 2
but 3  NEW functions to ModX with plenty of 
polishes, upgrades and even secrets! 
As always, I hope you all enjoy this update.

Yours, Austin

This update adds 1 new function and 2 new
functions to REPLACE some old ones. 

NEW: modorigin(module): Shows where a module
came from. Includes stndlib, built-in, venv
site packs, pip-installed, namespace, editable,
zip/frozen imports, shadowed modules, custom
 *.pth, namespace children modules, and user
local Python installs.

NEW: modbench(module): Shows time (to import)
and memory usage of a module by importing it.
Returns a tuple.

NEW: revdeps(module): Opposite of dependencies().
Instead of showing what modules a typed module imports, 
this function shows what modules import your typed module.
Scans both stndlib modules AND installed third-party
modules.

REMOVED*: modrisks(): too similar to vcompat()
	  modhelp(): Too less modules have help strings.
* These modules were potential functions for 2.0 that
were removed/replaced when added.

POLISHES
1.) Removed underscores in many functions for
    function name consistency + less confusion
2.) All internal functions now start with an
    underscore to fit new modfunctions() update.
3.) modfunctions() rework: Now AST-based, doesn't
    import the module and skips internal functions
    (functions starting with an underscore).
4.) All bulk-import functions now correctly track
    modules imported by ModX, indirectly and by the user.
5.) imported() and modximported() counting logic corrected
6.) nonimported() and dependencies() imporoved to create
    better results.
7.) modxhelp() now AUTO generates help text AND hides
    internal functions.
8.) Shortened modules_loaded() to modsloaded()
9.) imported() now shows dependencies of ModX.
---

 🚀 Installation

Install directly from PyPI:
pip install modxpy

In Python, import as import modx (not modxpy)


# Functions:

🔹 importall()

Imports about every standard library module at once.


🔹 importrandom(n)

Imports n random modules from the standard library.


🔹 importletter(letter)

Imports all standard library modules whose names start with the given letter.


🔹 importexternal()

Attempts to import every third-party module you currently have installed.


🔹 importscreen()

Imports every module that uses a screen/GUI (like pygame or turtle).


🔹 listimportall()

Returns a list of modules that would be imported by import_all().


🔹 modsloaded()

Shows how many modules you currently have downloaded on your device.


🔹 imported()

Lists the modules imported since ModX loaded (user + ModX), including dependencies.


🔹 modximported()

Lists the modules that were ONLY imported by ModX, NOT including user imports

and dependencies.

🔹 importletter(letter)

Import every standard library module from the ModX 'modules' list
whose name starts with the given letter (case-insensitive).


🔹 searchmodules(keyword)

Search for modules whose names contain the keyword.


🔹 info(module_name)

Shows basic info about typed module: file path, built-in status, docstring.


🔹 isimported(module)

Checks if module is currently imported into Python Shell (Not Pythonlib)


🔹 dependencies()

Shows what other modules a specific module depends on without importing it.


🔹 vcompat(module_name, python_version)

Checks if a module is compatible with a python version, if a version was given.


🔹 modfunctions(module)

Show how many and what functions a module has without importing it.


🔹 modxhelp()

Shows ModX's built in help dialogue.


🔹 modclasses(module)

Show how many and what classes a module has without importing it.

🔹 modorigin(module)

Shows where a module came from (e.g. built-in, stndlib or pip-installed).

🔹 modbench(n)

Shows how much time and memory a module takes to import
(typed modules DOES get imported)

🔹 revdeps(module)

Shows what modules import typed module without importing it.


# 💡 Why Use ModX?


1.) Explore the Python standard library in seconds
2.) Stress-test your environment by bulk importing modules
3.) See hidden dependencies that load behind the scenes
4.) Experiment with random imports for fun or testing
5.) Discover new modules you didn’t know existed


ModXPy turns Python’s module system into a playground —
perfect for learning, testing, or just satisfying your curiosity.
Install it today with pip install modxpy, import it with import modx,
and start discovering how many modules Python already has waiting for you!