# Code autogenerated by StandardBots

from dataclasses import dataclass
from typing import List, Tuple, Union, Dict, Any
from enum import Enum

def parse_i_8(data: object) -> int:
  return int(data)

def serialize_i_8(data: int) -> object:
  return data

def parse_i_16(data: object) -> int:
  return int(data)

def serialize_i_16(data: int) -> object:
  return data

def parse_i_32(data: object) -> int:
  return int(data)

def serialize_i_32(data: int) -> object:
  return data

def parse_i_64(data: object) -> int:
  return int(data)

def serialize_i_64(data: int) -> object:
  return data

def parse_i_128(data: object) -> int:
  return int(data)

def serialize_i_128(data: int) -> object:
  return data

def parse_u_8(data: object) -> int:
  return int(data)

def serialize_u_8(data: int) -> object:
  return data

def parse_u_16(data: object) -> int:
  return int(data)

def serialize_u_16(data: int) -> object:
  return data

def parse_u_32(data: object) -> int:
  return int(data)

def serialize_u_32(data: int) -> object:
  return data

def parse_u_63(data: object) -> int:
  return int(data)

def serialize_u_63(data: int) -> object:
  return data

def parse_u_128(data: object) -> int:
  return int(data)

def serialize_u_128(data: int) -> object:
  return data

def parse_object_object(data: object) -> int:
  return int(data)

def serialize_object_object(data: int) -> object:
  return data

def parse_f_32(data: object) -> float:
  return float(data)

def serialize_f_32(data: float) -> object:
  return data

def parse_f_64(data: object) -> float:
  return float(data)

def serialize_f_64(data: float) -> object:
  return data

def parse_object_object(data: object) -> float:
  return float(data)

def serialize_object_object(data: float) -> object:
  return data


def parse_bool(data: object) -> bool:
  return bool(data)

def serialize_bool(data: bool) -> object:
  return data

def parse_str(data: object) -> str:
  return str(data)

def serialize_str(data: str) -> object:
  return data

def serialize_float(data: float) -> object:
  return data

def serialize_int(data: int) -> object:
  return data

@dataclass
class ArmPositionUpdateCanceledEvent:
  """Move robot event when motion is canceled"""
  kind: Union[str, None] = None
  reason: Union[str, None] = None

  def validate_kind(self, value: str) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, str):
      return [False, "kind must be of type str for ArmPositionUpdateCanceledEvent, got " + type(value).__name__]

    return [True, ""]

  def validate_reason(self, value: str) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, str):
      return [False, "reason must be of type str for ArmPositionUpdateCanceledEvent, got " + type(value).__name__]

    return [True, ""]

  def __post_init__(self):
    # Type check incoming model - raise error if invalid (required or wrong type)
    is_valid, error_str = self.validate_kind(self.kind)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_reason(self.reason)
    if not is_valid:
      raise TypeError(error_str)

def parse_arm_position_update_canceled_event(data: object):
  return ArmPositionUpdateCanceledEvent(
    kind=parse_str(data["kind"]) if "kind" in data else None,
    reason=parse_str(data["reason"]) if "reason" in data else None,
  )

def serialize_arm_position_update_canceled_event(data: ArmPositionUpdateCanceledEvent) -> object:
  return {
    "kind": None if data.kind is None else serialize_str(data.kind),
    "reason": None if data.reason is None else serialize_str(data.reason),
  }

class ArmPositionUpdateFailureEventKind(Enum):
  MotionFailedUnknownReason = "motion_failed_unknown_reason"
  """Enum MotionFailedUnknownReason = `motion_failed_unknown_reason`"""
  MotionFailedCollision = "motion_failed_collision"
  """Enum MotionFailedCollision = `motion_failed_collision`"""

def parse_arm_position_update_failure_event_kind(data: object) -> ArmPositionUpdateFailureEventKind:
  return ArmPositionUpdateFailureEventKind(data)

def serialize_arm_position_update_failure_event_kind(data: Union[ArmPositionUpdateFailureEventKind, str]) -> object:
  return ArmPositionUpdateFailureEventKind(data).value

class ArmPositionUpdateKindEnum(Enum):
  Success = "success"
  """Enum Success = `success`"""
  Failure = "failure"
  """Enum Failure = `failure`"""
  Canceled = "canceled"
  """Enum Canceled = `canceled`"""
  Position = "position"
  """Enum Position = `position`"""
  Planning = "planning"
  """Enum Planning = `planning`"""

def parse_arm_position_update_kind_enum(data: object) -> ArmPositionUpdateKindEnum:
  return ArmPositionUpdateKindEnum(data)

def serialize_arm_position_update_kind_enum(data: Union[ArmPositionUpdateKindEnum, str]) -> object:
  return ArmPositionUpdateKindEnum(data).value

class ArmPositionUpdateRequestKindEnum(Enum):
  TooltipPositions = "tooltip_positions"
  """Enum TooltipPositions = `tooltip_positions`"""
  TooltipPosition = "tooltip_position"
  """Enum TooltipPosition = `tooltip_position`"""
  JointRotations = "joint_rotations"
  """Enum JointRotations = `joint_rotations`"""
  JointRotation = "joint_rotation"
  """Enum JointRotation = `joint_rotation`"""

def parse_arm_position_update_request_kind_enum(data: object) -> ArmPositionUpdateRequestKindEnum:
  return ArmPositionUpdateRequestKindEnum(data)

def serialize_arm_position_update_request_kind_enum(data: Union[ArmPositionUpdateRequestKindEnum, str]) -> object:
  return ArmPositionUpdateRequestKindEnum(data).value

class ArmPositionUpdateRequestResponseEventStreamSubscriptionKindEnum(Enum):
  All = "all"
  """Receive all events as the robot moves to the target position."""
  Events = "events"
  """Receive only events as the robot moves to the target position."""
  Positions = "positions"
  """Receive only position events as the robot moves to the target position."""

def parse_arm_position_update_request_response_event_stream_subscription_kind_enum(data: object) -> ArmPositionUpdateRequestResponseEventStreamSubscriptionKindEnum:
  return ArmPositionUpdateRequestResponseEventStreamSubscriptionKindEnum(data)

def serialize_arm_position_update_request_response_event_stream_subscription_kind_enum(data: Union[ArmPositionUpdateRequestResponseEventStreamSubscriptionKindEnum, str]) -> object:
  return ArmPositionUpdateRequestResponseEventStreamSubscriptionKindEnum(data).value

class ArmPositionUpdateRequestResponseKindEnum(Enum):
  Sync = "sync"
  """Receive a single response once the robot has reached the target position."""
  EventStream = "event_stream"
  """Receive a stream of events as the robot moves to the target position. The &#x60;subscriptions&#x60; property can be used to specify which events should be sent. By default, all events are sent."""

def parse_arm_position_update_request_response_kind_enum(data: object) -> ArmPositionUpdateRequestResponseKindEnum:
  return ArmPositionUpdateRequestResponseKindEnum(data)

def serialize_arm_position_update_request_response_kind_enum(data: Union[ArmPositionUpdateRequestResponseKindEnum, str]) -> object:
  return ArmPositionUpdateRequestResponseKindEnum(data).value

class BrakesStateEnum(Enum):
  Engaged = "engaged"
  """Robot Brakes are engaged, robot is not able to move"""
  Disengaged = "disengaged"
  """Robot Brakes are disengaged, robot can move freely"""

def parse_brakes_state_enum(data: object) -> BrakesStateEnum:
  return BrakesStateEnum(data)

def serialize_brakes_state_enum(data: Union[BrakesStateEnum, str]) -> object:
  return BrakesStateEnum(data).value

@dataclass
class CameraIntrinsics:
  """Intrinsic parameters of the camera."""
  width: Union[float, None] = None
  height: Union[float, None] = None
  fx: Union[float, None] = None
  fy: Union[float, None] = None
  ppx: Union[float, None] = None
  ppy: Union[float, None] = None
  error: Union[int, None] = None

  def validate_width(self, value: float) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, float):
      return [False, "width must be of type float for CameraIntrinsics, got " + type(value).__name__]

    return [True, ""]

  def validate_height(self, value: float) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, float):
      return [False, "height must be of type float for CameraIntrinsics, got " + type(value).__name__]

    return [True, ""]

  def validate_fx(self, value: float) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, float):
      return [False, "fx must be of type float for CameraIntrinsics, got " + type(value).__name__]

    return [True, ""]

  def validate_fy(self, value: float) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, float):
      return [False, "fy must be of type float for CameraIntrinsics, got " + type(value).__name__]

    return [True, ""]

  def validate_ppx(self, value: float) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, float):
      return [False, "ppx must be of type float for CameraIntrinsics, got " + type(value).__name__]

    return [True, ""]

  def validate_ppy(self, value: float) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, float):
      return [False, "ppy must be of type float for CameraIntrinsics, got " + type(value).__name__]

    return [True, ""]

  def validate_error(self, value: int) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, int):
      return [False, "error must be of type int for CameraIntrinsics, got " + type(value).__name__]

    return [True, ""]

  def __post_init__(self):
    # Type check incoming model - raise error if invalid (required or wrong type)
    is_valid, error_str = self.validate_width(self.width)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_height(self.height)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_fx(self.fx)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_fy(self.fy)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_ppx(self.ppx)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_ppy(self.ppy)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_error(self.error)
    if not is_valid:
      raise TypeError(error_str)

def parse_camera_intrinsics(data: object):
  return CameraIntrinsics(
    width=parse_f_64(data["width"]) if "width" in data else None,
    height=parse_f_64(data["height"]) if "height" in data else None,
    fx=parse_f_64(data["fx"]) if "fx" in data else None,
    fy=parse_f_64(data["fy"]) if "fy" in data else None,
    ppx=parse_f_64(data["ppx"]) if "ppx" in data else None,
    ppy=parse_f_64(data["ppy"]) if "ppy" in data else None,
    error=parse_i_8(data["error"]) if "error" in data else None,
  )

def serialize_camera_intrinsics(data: CameraIntrinsics) -> object:
  return {
    "width": None if data.width is None else serialize_f_64(data.width),
    "height": None if data.height is None else serialize_f_64(data.height),
    "fx": None if data.fx is None else serialize_f_64(data.fx),
    "fy": None if data.fy is None else serialize_f_64(data.fy),
    "ppx": None if data.ppx is None else serialize_f_64(data.ppx),
    "ppy": None if data.ppy is None else serialize_f_64(data.ppy),
    "error": None if data.error is None else serialize_i_8(data.error),
  }

@dataclass
class CameraSettings:
  """Settings for the camera."""
  brightness: Union[int, None] = None
  contrast: Union[int, None] = None
  exposure: Union[int, None] = None
  sharpness: Union[int, None] = None
  hue: Union[int, None] = None
  whiteBalance: Union[int, None] = None
  autoWhiteBalance: Union[bool, None] = None

  def validate_brightness(self, value: int) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, int):
      return [False, "brightness must be of type int for CameraSettings, got " + type(value).__name__]

    return [True, ""]

  def validate_contrast(self, value: int) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, int):
      return [False, "contrast must be of type int for CameraSettings, got " + type(value).__name__]

    return [True, ""]

  def validate_exposure(self, value: int) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, int):
      return [False, "exposure must be of type int for CameraSettings, got " + type(value).__name__]

    return [True, ""]

  def validate_sharpness(self, value: int) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, int):
      return [False, "sharpness must be of type int for CameraSettings, got " + type(value).__name__]

    return [True, ""]

  def validate_hue(self, value: int) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, int):
      return [False, "hue must be of type int for CameraSettings, got " + type(value).__name__]

    return [True, ""]

  def validate_whiteBalance(self, value: int) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, int):
      return [False, "whiteBalance must be of type int for CameraSettings, got " + type(value).__name__]

    return [True, ""]

  def validate_autoWhiteBalance(self, value: bool) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, bool):
      return [False, "autoWhiteBalance must be of type bool for CameraSettings, got " + type(value).__name__]

    return [True, ""]

  def __post_init__(self):
    # Type check incoming model - raise error if invalid (required or wrong type)
    is_valid, error_str = self.validate_brightness(self.brightness)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_contrast(self.contrast)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_exposure(self.exposure)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_sharpness(self.sharpness)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_hue(self.hue)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_whiteBalance(self.whiteBalance)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_autoWhiteBalance(self.autoWhiteBalance)
    if not is_valid:
      raise TypeError(error_str)

def parse_camera_settings(data: object):
  return CameraSettings(
    brightness=parse_i_16(data["brightness"]) if "brightness" in data else None,
    contrast=parse_i_16(data["contrast"]) if "contrast" in data else None,
    exposure=parse_i_16(data["exposure"]) if "exposure" in data else None,
    sharpness=parse_i_16(data["sharpness"]) if "sharpness" in data else None,
    hue=parse_i_16(data["hue"]) if "hue" in data else None,
    whiteBalance=parse_i_16(data["whiteBalance"]) if "whiteBalance" in data else None,
    autoWhiteBalance=parse_bool(data["autoWhiteBalance"]) if "autoWhiteBalance" in data else None,
  )

def serialize_camera_settings(data: CameraSettings) -> object:
  return {
    "brightness": None if data.brightness is None else serialize_i_16(data.brightness),
    "contrast": None if data.contrast is None else serialize_i_16(data.contrast),
    "exposure": None if data.exposure is None else serialize_i_16(data.exposure),
    "sharpness": None if data.sharpness is None else serialize_i_16(data.sharpness),
    "hue": None if data.hue is None else serialize_i_16(data.hue),
    "whiteBalance": None if data.whiteBalance is None else serialize_i_16(data.whiteBalance),
    "autoWhiteBalance": None if data.autoWhiteBalance is None else serialize_bool(data.autoWhiteBalance),
  }

class ConnectionStatus(Enum):
  Connected = "connected"
  """Enum Connected = `connected`"""
  Disconnected = "disconnected"
  """Enum Disconnected = `disconnected`"""
  Ready = "ready"
  """Enum Ready = `ready`"""

def parse_connection_status(data: object) -> ConnectionStatus:
  return ConnectionStatus(data)

def serialize_connection_status(data: Union[ConnectionStatus, str]) -> object:
  return ConnectionStatus(data).value

@dataclass
class DHAGGripperCommandRequest:
  """Control the DH AG gripper (end effector) of the robot
"""
  target_diameter: Union[float, None] = None
  target_force: Union[float, None] = None
  target_speed: Union[float, None] = None

  def validate_target_diameter(self, value: float) -> Tuple[bool, str]:
    if value is None:
      return [False, "target_diameter is required for DHAGGripperCommandRequest"]

    if not isinstance(value, float):
      return [False, "target_diameter must be of type float for DHAGGripperCommandRequest, got " + type(value).__name__]

    return [True, ""]

  def validate_target_force(self, value: float) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, float):
      return [False, "target_force must be of type float for DHAGGripperCommandRequest, got " + type(value).__name__]

    return [True, ""]

  def validate_target_speed(self, value: float) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, float):
      return [False, "target_speed must be of type float for DHAGGripperCommandRequest, got " + type(value).__name__]

    return [True, ""]

  def __post_init__(self):
    # Type check incoming model - raise error if invalid (required or wrong type)
    is_valid, error_str = self.validate_target_diameter(self.target_diameter)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_target_force(self.target_force)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_target_speed(self.target_speed)
    if not is_valid:
      raise TypeError(error_str)

def parse_dhag_gripper_command_request(data: object):
  return DHAGGripperCommandRequest(
    target_diameter=parse_f_64(data["target_diameter"]) if "target_diameter" in data else None,
    target_force=parse_f_64(data["target_force"]) if "target_force" in data else None,
    target_speed=parse_f_64(data["target_speed"]) if "target_speed" in data else None,
  )

def serialize_dhag_gripper_command_request(data: DHAGGripperCommandRequest) -> object:
  return {
    "target_diameter": serialize_f_64(data.target_diameter),
    "target_force": None if data.target_force is None else serialize_f_64(data.target_force),
    "target_speed": None if data.target_speed is None else serialize_f_64(data.target_speed),
  }

@dataclass
class DHAGGripperConfiguration:
  """Configuration for DH AG Gripper"""
  diameter: Union[float, None] = None

  def validate_diameter(self, value: float) -> Tuple[bool, str]:
    if value is None:
      return [False, "diameter is required for DHAGGripperConfiguration"]

    if not isinstance(value, float):
      return [False, "diameter must be of type float for DHAGGripperConfiguration, got " + type(value).__name__]

    return [True, ""]

  def __post_init__(self):
    # Type check incoming model - raise error if invalid (required or wrong type)
    is_valid, error_str = self.validate_diameter(self.diameter)
    if not is_valid:
      raise TypeError(error_str)

def parse_dhag_gripper_configuration(data: object):
  return DHAGGripperConfiguration(
    diameter=parse_f_64(data["diameter"]) if "diameter" in data else None,
  )

def serialize_dhag_gripper_configuration(data: DHAGGripperConfiguration) -> object:
  return {
    "diameter": serialize_f_64(data.diameter),
  }

@dataclass
class DHCGIGripperCommandRequest:
  """Control the DH CGI gripper (end effector) of the robot
"""
  target_diameter: Union[float, None] = None
  target_force: Union[float, None] = None
  target_speed: Union[float, None] = None

  def validate_target_diameter(self, value: float) -> Tuple[bool, str]:
    if value is None:
      return [False, "target_diameter is required for DHCGIGripperCommandRequest"]

    if not isinstance(value, float):
      return [False, "target_diameter must be of type float for DHCGIGripperCommandRequest, got " + type(value).__name__]

    return [True, ""]

  def validate_target_force(self, value: float) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, float):
      return [False, "target_force must be of type float for DHCGIGripperCommandRequest, got " + type(value).__name__]

    return [True, ""]

  def validate_target_speed(self, value: float) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, float):
      return [False, "target_speed must be of type float for DHCGIGripperCommandRequest, got " + type(value).__name__]

    return [True, ""]

  def __post_init__(self):
    # Type check incoming model - raise error if invalid (required or wrong type)
    is_valid, error_str = self.validate_target_diameter(self.target_diameter)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_target_force(self.target_force)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_target_speed(self.target_speed)
    if not is_valid:
      raise TypeError(error_str)

def parse_dhcgi_gripper_command_request(data: object):
  return DHCGIGripperCommandRequest(
    target_diameter=parse_f_64(data["target_diameter"]) if "target_diameter" in data else None,
    target_force=parse_f_64(data["target_force"]) if "target_force" in data else None,
    target_speed=parse_f_64(data["target_speed"]) if "target_speed" in data else None,
  )

def serialize_dhcgi_gripper_command_request(data: DHCGIGripperCommandRequest) -> object:
  return {
    "target_diameter": serialize_f_64(data.target_diameter),
    "target_force": None if data.target_force is None else serialize_f_64(data.target_force),
    "target_speed": None if data.target_speed is None else serialize_f_64(data.target_speed),
  }

@dataclass
class DHCGIGripperConfiguration:
  """Configuration for DH CGI Gripper"""
  diameter: Union[float, None] = None

  def validate_diameter(self, value: float) -> Tuple[bool, str]:
    if value is None:
      return [False, "diameter is required for DHCGIGripperConfiguration"]

    if not isinstance(value, float):
      return [False, "diameter must be of type float for DHCGIGripperConfiguration, got " + type(value).__name__]

    return [True, ""]

  def __post_init__(self):
    # Type check incoming model - raise error if invalid (required or wrong type)
    is_valid, error_str = self.validate_diameter(self.diameter)
    if not is_valid:
      raise TypeError(error_str)

def parse_dhcgi_gripper_configuration(data: object):
  return DHCGIGripperConfiguration(
    diameter=parse_f_64(data["diameter"]) if "diameter" in data else None,
  )

def serialize_dhcgi_gripper_configuration(data: DHCGIGripperConfiguration) -> object:
  return {
    "diameter": serialize_f_64(data.diameter),
  }

@dataclass
class DHPGCGripperCommandRequest:
  """Control the DH PGC gripper (end effector) of the robot
"""
  target_diameter: Union[float, None] = None
  target_force: Union[float, None] = None
  target_speed: Union[float, None] = None

  def validate_target_diameter(self, value: float) -> Tuple[bool, str]:
    if value is None:
      return [False, "target_diameter is required for DHPGCGripperCommandRequest"]

    if not isinstance(value, float):
      return [False, "target_diameter must be of type float for DHPGCGripperCommandRequest, got " + type(value).__name__]

    return [True, ""]

  def validate_target_force(self, value: float) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, float):
      return [False, "target_force must be of type float for DHPGCGripperCommandRequest, got " + type(value).__name__]

    return [True, ""]

  def validate_target_speed(self, value: float) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, float):
      return [False, "target_speed must be of type float for DHPGCGripperCommandRequest, got " + type(value).__name__]

    return [True, ""]

  def __post_init__(self):
    # Type check incoming model - raise error if invalid (required or wrong type)
    is_valid, error_str = self.validate_target_diameter(self.target_diameter)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_target_force(self.target_force)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_target_speed(self.target_speed)
    if not is_valid:
      raise TypeError(error_str)

def parse_dhpgc_gripper_command_request(data: object):
  return DHPGCGripperCommandRequest(
    target_diameter=parse_f_64(data["target_diameter"]) if "target_diameter" in data else None,
    target_force=parse_f_64(data["target_force"]) if "target_force" in data else None,
    target_speed=parse_f_64(data["target_speed"]) if "target_speed" in data else None,
  )

def serialize_dhpgc_gripper_command_request(data: DHPGCGripperCommandRequest) -> object:
  return {
    "target_diameter": serialize_f_64(data.target_diameter),
    "target_force": None if data.target_force is None else serialize_f_64(data.target_force),
    "target_speed": None if data.target_speed is None else serialize_f_64(data.target_speed),
  }

@dataclass
class DHPGCGripperConfiguration:
  """Configuration for DH PGC Gripper"""
  diameter: Union[float, None] = None

  def validate_diameter(self, value: float) -> Tuple[bool, str]:
    if value is None:
      return [False, "diameter is required for DHPGCGripperConfiguration"]

    if not isinstance(value, float):
      return [False, "diameter must be of type float for DHPGCGripperConfiguration, got " + type(value).__name__]

    return [True, ""]

  def __post_init__(self):
    # Type check incoming model - raise error if invalid (required or wrong type)
    is_valid, error_str = self.validate_diameter(self.diameter)
    if not is_valid:
      raise TypeError(error_str)

def parse_dhpgc_gripper_configuration(data: object):
  return DHPGCGripperConfiguration(
    diameter=parse_f_64(data["diameter"]) if "diameter" in data else None,
  )

def serialize_dhpgc_gripper_configuration(data: DHPGCGripperConfiguration) -> object:
  return {
    "diameter": serialize_f_64(data.diameter),
  }

@dataclass
class EngageEmergencyStopRequest:
  """Engage Emergency Stop. This will immediately stop the robot and prevent it from moving until the robot is unbraked.
"""
  reason: Union[str, None] = None

  def validate_reason(self, value: str) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, str):
      return [False, "reason must be of type str for EngageEmergencyStopRequest, got " + type(value).__name__]

    return [True, ""]

  def __post_init__(self):
    # Type check incoming model - raise error if invalid (required or wrong type)
    is_valid, error_str = self.validate_reason(self.reason)
    if not is_valid:
      raise TypeError(error_str)

def parse_engage_emergency_stop_request(data: object):
  return EngageEmergencyStopRequest(
    reason=parse_str(data["reason"]) if "reason" in data else None,
  )

def serialize_engage_emergency_stop_request(data: EngageEmergencyStopRequest) -> object:
  return {
    "reason": None if data.reason is None else serialize_str(data.reason),
  }

@dataclass
class EnvironmentVariable:
  """Environment variables for a routine"""
  id: Union[str, None] = None
  name: Union[str, None] = None
  value: Union[str, None] = None

  def validate_id(self, value: str) -> Tuple[bool, str]:
    if value is None:
      return [False, "id is required for EnvironmentVariable"]

    if not isinstance(value, str):
      return [False, "id must be of type str for EnvironmentVariable, got " + type(value).__name__]

    return [True, ""]

  def validate_name(self, value: str) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, str):
      return [False, "name must be of type str for EnvironmentVariable, got " + type(value).__name__]

    return [True, ""]

  def validate_value(self, value: str) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, str):
      return [False, "value must be of type str for EnvironmentVariable, got " + type(value).__name__]

    return [True, ""]

  def __post_init__(self):
    # Type check incoming model - raise error if invalid (required or wrong type)
    is_valid, error_str = self.validate_id(self.id)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_name(self.name)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_value(self.value)
    if not is_valid:
      raise TypeError(error_str)

def parse_environment_variable(data: object):
  return EnvironmentVariable(
    id=parse_str(data["id"]) if "id" in data else None,
    name=parse_str(data["name"]) if "name" in data else None,
    value=parse_str(data["value"]) if "value" in data else None,
  )

def serialize_environment_variable(data: EnvironmentVariable) -> object:
  return {
    "id": serialize_str(data.id),
    "name": None if data.name is None else serialize_str(data.name),
    "value": None if data.value is None else serialize_str(data.value),
  }

class ErrorEnum(Enum):
  AuthorizationRequired = "authorization_required"
  """Authorization required to access this resource"""
  RoutineMustBeRunning = "routine_must_be_running"
  """Routine must be running"""
  ApiControlRequired = "api_control_required"
  """API control required"""
  RobotBrakesDisengageFailed = "robot_brakes_disengage_failed"
  """Robot brakes disengage failed"""
  RobotBrakesEngageFailed = "robot_brakes_engage_failed"
  """Robot brakes engage failed"""
  RequestFailedValidation = "request_failed_validation"
  """Request failed validation"""
  RobotNotIdle = "robot_not_idle"
  """Robot must be idle"""
  BrakesMustBeEngaged = "brakes_must_be_engaged"
  """Brakes must be_engaged"""
  BrakesMustBeDisengaged = "brakes_must_be_disengaged"
  """Brakes must be disengaged"""
  EquipmentNoMatching = "equipment_no_matching"
  """No matching equipment found"""
  ServiceInitializing = "service_initializing"
  """The service is unavailable while initializing"""
  CameraDisconnected = "camera_disconnected"
  """Camera service running, but no camera is connected"""
  SettingsValidationError = "settings_validation_error"
  """Camera settings validation failed"""
  SettingsTimeout = "settings_timeout"
  """Camera settings timed out"""
  InternalServerError = "internal_server_error"
  """Internal server error occurred"""
  RecoveryError = "recovery_error"
  """Recovery error occurred"""
  NotFound = "not_found"
  """Requested resource not found"""

def parse_error_enum(data: object) -> ErrorEnum:
  return ErrorEnum(data)

def serialize_error_enum(data: Union[ErrorEnum, str]) -> object:
  return ErrorEnum(data).value

class ForceUnitKind(Enum):
  Newtons = "newtons"
  """Enum Newtons = `newtons`"""
  Pounds = "pounds"
  """Enum Pounds = `pounds`"""

def parse_force_unit_kind(data: object) -> ForceUnitKind:
  return ForceUnitKind(data)

def serialize_force_unit_kind(data: Union[ForceUnitKind, str]) -> object:
  return ForceUnitKind(data).value

class GripperKindEnum(Enum):
  Onrobot2Fg7 = "onrobot_2fg7"
  """An OnRobot 2FG7 Gripper is connected"""
  Onrobot3Fg15 = "onrobot_3fg15"
  """An OnRobot 3FG15 Gripper is connected"""
  DhAg = "dh_ag"
  """A DH AG Gripper is connected"""
  DhPgc = "dh_pgc"
  """A DH PGC Gripper is connected"""
  DhCgi = "dh_cgi"
  """A DH CGI Gripper is connected"""
  NoneConnected = "none_connected"
  """No gripper is connected"""

def parse_gripper_kind_enum(data: object) -> GripperKindEnum:
  return GripperKindEnum(data)

def serialize_gripper_kind_enum(data: Union[GripperKindEnum, str]) -> object:
  return GripperKindEnum(data).value

@dataclass
class IOStateResponse:
  """Response to a query for the current state of I/O."""
  state: Union[str, None] = None

  def validate_state(self, value: str) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, str):
      return [False, "state must be of type str for IOStateResponse, got " + type(value).__name__]

    return [True, ""]

  def __post_init__(self):
    # Type check incoming model - raise error if invalid (required or wrong type)
    is_valid, error_str = self.validate_state(self.state)
    if not is_valid:
      raise TypeError(error_str)

def parse_io_state_response(data: object):
  return IOStateResponse(
    state=parse_str(data["state"]) if "state" in data else None,
  )

def serialize_io_state_response(data: IOStateResponse) -> object:
  return {
    "state": None if data.state is None else serialize_str(data.state),
  }

@dataclass
class IOStateUpdateRequest:
  """Request to update the state of I/O to either start or stop."""
  state: Union[str, None] = None

  def validate_state(self, value: str) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, str):
      return [False, "state must be of type str for IOStateUpdateRequest, got " + type(value).__name__]

    return [True, ""]

  def __post_init__(self):
    # Type check incoming model - raise error if invalid (required or wrong type)
    is_valid, error_str = self.validate_state(self.state)
    if not is_valid:
      raise TypeError(error_str)

def parse_io_state_update_request(data: object):
  return IOStateUpdateRequest(
    state=parse_str(data["state"]) if "state" in data else None,
  )

def serialize_io_state_update_request(data: IOStateUpdateRequest) -> object:
  return {
    "state": None if data.state is None else serialize_str(data.state),
  }

JointRotations = Tuple[float,float,float,float,float,float,]

def parse_joint_rotations(data: object) -> JointRotations:
  return (parse_f_64(data[0]),parse_f_64(data[1]),parse_f_64(data[2]),parse_f_64(data[3]),parse_f_64(data[4]),parse_f_64(data[5]),)

def serialize_joint_rotations(data: JointRotations) -> object:
  return [serialize_f_64(data[0]),serialize_f_64(data[1]),serialize_f_64(data[2]),serialize_f_64(data[3]),serialize_f_64(data[4]),serialize_f_64(data[5]),]

class LinearGripDirectionEnum(Enum):
  Inward = "inward"
  """Move gripper inward to grip. Measure grip position based on interior of gripper fingers and exterior of object"""
  Outward = "outward"
  """Grip gripper outward to grip. Measure grip position based on exterior of gripper fingers and interior of object"""

def parse_linear_grip_direction_enum(data: object) -> LinearGripDirectionEnum:
  return LinearGripDirectionEnum(data)

def serialize_linear_grip_direction_enum(data: Union[LinearGripDirectionEnum, str]) -> object:
  return LinearGripDirectionEnum(data).value

class LinearUnitKind(Enum):
  Millimeters = "millimeters"
  """Enum Millimeters = `millimeters`"""
  Centimeters = "centimeters"
  """Enum Centimeters = `centimeters`"""
  Meters = "meters"
  """Enum Meters = `meters`"""
  Inches = "inches"
  """Enum Inches = `inches`"""
  Feet = "feet"
  """Enum Feet = `feet`"""

def parse_linear_unit_kind(data: object) -> LinearUnitKind:
  return LinearUnitKind(data)

def serialize_linear_unit_kind(data: Union[LinearUnitKind, str]) -> object:
  return LinearUnitKind(data).value

class OnRobot2FG7ControlKindEnum(Enum):
  Move = "move"
  """Move gripper to target grip width"""
  ForceGrip = "force_grip"
  """Grip with target force"""

def parse_on_robot_2_fg_7_control_kind_enum(data: object) -> OnRobot2FG7ControlKindEnum:
  return OnRobot2FG7ControlKindEnum(data)

def serialize_on_robot_2_fg_7_control_kind_enum(data: Union[OnRobot2FG7ControlKindEnum, str]) -> object:
  return OnRobot2FG7ControlKindEnum(data).value

class OnRobot3FG15ControlKindEnum(Enum):
  Move = "move"
  """Move gripper to target grip diameter"""
  ForceGrip = "force_grip"
  """Grip with target force"""
  FlexibleForceGrip = "flexible_force_grip"
  """Grip with target force"""

def parse_on_robot_3_fg_15_control_kind_enum(data: object) -> OnRobot3FG15ControlKindEnum:
  return OnRobot3FG15ControlKindEnum(data)

def serialize_on_robot_3_fg_15_control_kind_enum(data: Union[OnRobot3FG15ControlKindEnum, str]) -> object:
  return OnRobot3FG15ControlKindEnum(data).value

class OrientationKindEnum(Enum):
  Quaternion = "quaternion"
  """Enum Quaternion = `quaternion`"""

def parse_orientation_kind_enum(data: object) -> OrientationKindEnum:
  return OrientationKindEnum(data)

def serialize_orientation_kind_enum(data: Union[OrientationKindEnum, str]) -> object:
  return OrientationKindEnum(data).value

@dataclass
class Pagination:
  """Common Pagination Metadata"""
  total: Union[int, None] = None
  limit: Union[int, None] = None
  offset: Union[int, None] = None

  def validate_total(self, value: int) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, int):
      return [False, "total must be of type int for Pagination, got " + type(value).__name__]

    return [True, ""]

  def validate_limit(self, value: int) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, int):
      return [False, "limit must be of type int for Pagination, got " + type(value).__name__]

    return [True, ""]

  def validate_offset(self, value: int) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, int):
      return [False, "offset must be of type int for Pagination, got " + type(value).__name__]

    return [True, ""]

  def __post_init__(self):
    # Type check incoming model - raise error if invalid (required or wrong type)
    is_valid, error_str = self.validate_total(self.total)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_limit(self.limit)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_offset(self.offset)
    if not is_valid:
      raise TypeError(error_str)

def parse_pagination(data: object):
  return Pagination(
    total=parse_i_64(data["total"]) if "total" in data else None,
    limit=parse_i_64(data["limit"]) if "limit" in data else None,
    offset=parse_i_64(data["offset"]) if "offset" in data else None,
  )

def serialize_pagination(data: Pagination) -> object:
  return {
    "total": None if data.total is None else serialize_i_64(data.total),
    "limit": None if data.limit is None else serialize_i_64(data.limit),
    "offset": None if data.offset is None else serialize_i_64(data.offset),
  }

@dataclass
class Plane:
  """Plane in 3D space"""
  id: Union[str, None] = None
  name: Union[str, None] = None

  def validate_id(self, value: str) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, str):
      return [False, "id must be of type str for Plane, got " + type(value).__name__]

    return [True, ""]

  def validate_name(self, value: str) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, str):
      return [False, "name must be of type str for Plane, got " + type(value).__name__]

    return [True, ""]

  def __post_init__(self):
    # Type check incoming model - raise error if invalid (required or wrong type)
    is_valid, error_str = self.validate_id(self.id)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_name(self.name)
    if not is_valid:
      raise TypeError(error_str)

def parse_plane(data: object):
  return Plane(
    id=parse_str(data["id"]) if "id" in data else None,
    name=parse_str(data["name"]) if "name" in data else None,
  )

def serialize_plane(data: Plane) -> object:
  return {
    "id": None if data.id is None else serialize_str(data.id),
    "name": None if data.name is None else serialize_str(data.name),
  }

@dataclass
class Quaternion:
  """Quaternion orientation"""
  x: Union[float, None] = None
  y: Union[float, None] = None
  z: Union[float, None] = None
  w: Union[float, None] = None

  def validate_x(self, value: float) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, float):
      return [False, "x must be of type float for Quaternion, got " + type(value).__name__]

    return [True, ""]

  def validate_y(self, value: float) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, float):
      return [False, "y must be of type float for Quaternion, got " + type(value).__name__]

    return [True, ""]

  def validate_z(self, value: float) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, float):
      return [False, "z must be of type float for Quaternion, got " + type(value).__name__]

    return [True, ""]

  def validate_w(self, value: float) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, float):
      return [False, "w must be of type float for Quaternion, got " + type(value).__name__]

    return [True, ""]

  def __post_init__(self):
    # Type check incoming model - raise error if invalid (required or wrong type)
    is_valid, error_str = self.validate_x(self.x)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_y(self.y)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_z(self.z)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_w(self.w)
    if not is_valid:
      raise TypeError(error_str)

def parse_quaternion(data: object):
  return Quaternion(
    x=parse_f_64(data["x"]) if "x" in data else None,
    y=parse_f_64(data["y"]) if "y" in data else None,
    z=parse_f_64(data["z"]) if "z" in data else None,
    w=parse_f_64(data["w"]) if "w" in data else None,
  )

def serialize_quaternion(data: Quaternion) -> object:
  return {
    "x": None if data.x is None else serialize_f_64(data.x),
    "y": None if data.y is None else serialize_f_64(data.y),
    "z": None if data.z is None else serialize_f_64(data.z),
    "w": None if data.w is None else serialize_f_64(data.w),
  }

class RobotControlModeEnum(Enum):
  Api = "api"
  """The robot is controlled via the Standard Bots Robot API (this API)"""
  RoutineEditor = "routine_editor"
  """The robot is controlled via the Routine Editor UI"""

def parse_robot_control_mode_enum(data: object) -> RobotControlModeEnum:
  return RobotControlModeEnum(data)

def serialize_robot_control_mode_enum(data: Union[RobotControlModeEnum, str]) -> object:
  return RobotControlModeEnum(data).value

class ROSControlStateEnum(Enum):
  Enabled = "enabled"
  """ROS control is enabled."""
  Disabled = "disabled"
  """ROS control is disabled."""

def parse_ros_control_state_enum(data: object) -> ROSControlStateEnum:
  return ROSControlStateEnum(data)

def serialize_ros_control_state_enum(data: Union[ROSControlStateEnum, str]) -> object:
  return ROSControlStateEnum(data).value

RoutineVariablesStateMap = Dict[str, str]

def parse_routine_variables_state_map(data: object) -> RoutineVariablesStateMap:
  return {
    parse_str(key): parse_str(value) for key, value in data.items()
  }

def serialize_routine_variables_state_map(data: RoutineVariablesStateMap) -> object:
  return {
    serialize_str(key): serialize_str(value) for key, value in data.items()
  }

@dataclass
class RuntimeVariable:
  """Runtime Variable state"""
  value: Union[str, None] = None

  def validate_value(self, value: str) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, str):
      return [False, "value must be of type str for RuntimeVariable, got " + type(value).__name__]

    return [True, ""]

  def __post_init__(self):
    # Type check incoming model - raise error if invalid (required or wrong type)
    is_valid, error_str = self.validate_value(self.value)
    if not is_valid:
      raise TypeError(error_str)

def parse_runtime_variable(data: object):
  return RuntimeVariable(
    value=parse_str(data["value"]) if "value" in data else None,
  )

def serialize_runtime_variable(data: RuntimeVariable) -> object:
  return {
    "value": None if data.value is None else serialize_str(data.value),
  }

SkillsList = List[str]

def parse_skills_list(data: object) -> SkillsList:
  return [parse_str(item) for item in data]

def serialize_skills_list(data: SkillsList) -> List[object]:
  return [serialize_str(item) for item in data]

@dataclass
class SpeechToTextRequest:
  """Request to convert speech to text."""
  encoded_audio_data: Union[str, None] = None

  def validate_encoded_audio_data(self, value: str) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, str):
      return [False, "encoded_audio_data must be of type str for SpeechToTextRequest, got " + type(value).__name__]

    return [True, ""]

  def __post_init__(self):
    # Type check incoming model - raise error if invalid (required or wrong type)
    is_valid, error_str = self.validate_encoded_audio_data(self.encoded_audio_data)
    if not is_valid:
      raise TypeError(error_str)

def parse_speech_to_text_request(data: object):
  return SpeechToTextRequest(
    encoded_audio_data=parse_str(data["encoded_audio_data"]) if "encoded_audio_data" in data else None,
  )

def serialize_speech_to_text_request(data: SpeechToTextRequest) -> object:
  return {
    "encoded_audio_data": None if data.encoded_audio_data is None else serialize_str(data.encoded_audio_data),
  }

class StatusHealthEnum(Enum):
  Ok = "ok"
  """Enum Ok = `ok`"""
  Warning = "warning"
  """Enum Warning = `warning`"""
  Error = "error"
  """Enum Error = `error`"""

def parse_status_health_enum(data: object) -> StatusHealthEnum:
  return StatusHealthEnum(data)

def serialize_status_health_enum(data: Union[StatusHealthEnum, str]) -> object:
  return StatusHealthEnum(data).value

@dataclass
class StatusVersionData:
  """Version Data"""
  id: Union[str, None] = None
  name: Union[str, None] = None

  def validate_id(self, value: str) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, str):
      return [False, "id must be of type str for StatusVersionData, got " + type(value).__name__]

    return [True, ""]

  def validate_name(self, value: str) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, str):
      return [False, "name must be of type str for StatusVersionData, got " + type(value).__name__]

    return [True, ""]

  def __post_init__(self):
    # Type check incoming model - raise error if invalid (required or wrong type)
    is_valid, error_str = self.validate_id(self.id)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_name(self.name)
    if not is_valid:
      raise TypeError(error_str)

def parse_status_version_data(data: object):
  return StatusVersionData(
    id=parse_str(data["id"]) if "id" in data else None,
    name=parse_str(data["name"]) if "name" in data else None,
  )

def serialize_status_version_data(data: StatusVersionData) -> object:
  return {
    "id": None if data.id is None else serialize_str(data.id),
    "name": None if data.name is None else serialize_str(data.name),
  }

class TeleopStateEnum(Enum):
  WaitForTeleop = "wait_for_teleop"
  """The system is waiting to start teleoperation."""
  Teleop = "teleop"
  """Teleoperation is active, and the robot is being controlled remotely."""
  Stopping = "stopping"
  """The robot is stopping."""
  Stopped = "stopped"
  """Teleoperation is stopped, and the robot is not moving."""
  Moving = "moving"
  """The robot is moving but not under teleoperation."""
  Unfrozen = "unfrozen"
  """The mini-arm is unfrozen."""

def parse_teleop_state_enum(data: object) -> TeleopStateEnum:
  return TeleopStateEnum(data)

def serialize_teleop_state_enum(data: Union[TeleopStateEnum, str]) -> object:
  return TeleopStateEnum(data).value

@dataclass
class TeleopStateUpdateRequest:
  """Request to update the state of teleoperation to either start or stop."""
  action: Union[str, None] = None

  def validate_action(self, value: str) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, str):
      return [False, "action must be of type str for TeleopStateUpdateRequest, got " + type(value).__name__]

    return [True, ""]

  def __post_init__(self):
    # Type check incoming model - raise error if invalid (required or wrong type)
    is_valid, error_str = self.validate_action(self.action)
    if not is_valid:
      raise TypeError(error_str)

def parse_teleop_state_update_request(data: object):
  return TeleopStateUpdateRequest(
    action=parse_str(data["action"]) if "action" in data else None,
  )

def serialize_teleop_state_update_request(data: TeleopStateUpdateRequest) -> object:
  return {
    "action": None if data.action is None else serialize_str(data.action),
  }

@dataclass
class ArmPositionUpdateFailureEvent:
  """Move robot event when movement failed"""
  kind: Union[ArmPositionUpdateFailureEventKind, None] = None
  reason: Union[str, None] = None
  internal_reason: Union[str, None] = None

  def validate_kind(self, value: ArmPositionUpdateFailureEventKind) -> Tuple[bool, str]:
    if value is None:
      return [False, "kind is required for ArmPositionUpdateFailureEvent"]

    if not ((isinstance(value, str) and ArmPositionUpdateFailureEventKind in ['motion_failed_unknown_reason', 'motion_failed_collision']) or isinstance(value, ArmPositionUpdateFailureEventKind)):
      return [False, "kind must be of type ArmPositionUpdateFailureEventKind for ArmPositionUpdateFailureEvent, got " + type(value).__name__]

    return [True, ""]

  def validate_reason(self, value: str) -> Tuple[bool, str]:
    if value is None:
      return [False, "reason is required for ArmPositionUpdateFailureEvent"]

    if not isinstance(value, str):
      return [False, "reason must be of type str for ArmPositionUpdateFailureEvent, got " + type(value).__name__]

    return [True, ""]

  def validate_internal_reason(self, value: str) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, str):
      return [False, "internal_reason must be of type str for ArmPositionUpdateFailureEvent, got " + type(value).__name__]

    return [True, ""]

  def __post_init__(self):
    # Type check incoming model - raise error if invalid (required or wrong type)
    is_valid, error_str = self.validate_kind(self.kind)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_reason(self.reason)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_internal_reason(self.internal_reason)
    if not is_valid:
      raise TypeError(error_str)

def parse_arm_position_update_failure_event(data: object):
  return ArmPositionUpdateFailureEvent(
    kind=parse_arm_position_update_failure_event_kind(data["kind"]) if "kind" in data else None,
    reason=parse_str(data["reason"]) if "reason" in data else None,
    internal_reason=parse_str(data["internal_reason"]) if "internal_reason" in data else None,
  )

def serialize_arm_position_update_failure_event(data: ArmPositionUpdateFailureEvent) -> object:
  return {
    "kind": serialize_arm_position_update_failure_event_kind(data.kind),
    "reason": serialize_str(data.reason),
    "internal_reason": None if data.internal_reason is None else serialize_str(data.internal_reason),
  }

ArmPositionUpdateRequestResponseEventStreamSubscriptionsList = List[ArmPositionUpdateRequestResponseEventStreamSubscriptionKindEnum]

def parse_arm_position_update_request_response_event_stream_subscriptions_list(data: object) -> ArmPositionUpdateRequestResponseEventStreamSubscriptionsList:
  return [parse_arm_position_update_request_response_event_stream_subscription_kind_enum(item) for item in data]

def serialize_arm_position_update_request_response_event_stream_subscriptions_list(data: ArmPositionUpdateRequestResponseEventStreamSubscriptionsList) -> List[object]:
  return [serialize_arm_position_update_request_response_event_stream_subscription_kind_enum(item) for item in data]

@dataclass
class BrakesState:
  """State of the robot joint brakes. Each joint contains a brake which can be engaged when the robot is at a standstill to prevent the robot from moving.
"""
  state: Union[BrakesStateEnum, None] = None

  def validate_state(self, value: BrakesStateEnum) -> Tuple[bool, str]:
    if value is None:
      return [False, "state is required for BrakesState"]

    if not ((isinstance(value, str) and BrakesStateEnum in ['engaged', 'disengaged']) or isinstance(value, BrakesStateEnum)):
      return [False, "state must be of type BrakesStateEnum for BrakesState, got " + type(value).__name__]

    return [True, ""]

  def __post_init__(self):
    # Type check incoming model - raise error if invalid (required or wrong type)
    is_valid, error_str = self.validate_state(self.state)
    if not is_valid:
      raise TypeError(error_str)

def parse_brakes_state(data: object):
  return BrakesState(
    state=parse_brakes_state_enum(data["state"]) if "state" in data else None,
  )

def serialize_brakes_state(data: BrakesState) -> object:
  return {
    "state": serialize_brakes_state_enum(data.state),
  }

@dataclass
class CameraIntrinsicsResponse:
  """Response with intrinsic parameters of the camera."""
  intrinsics: Union[CameraIntrinsics, None] = None

  def validate_intrinsics(self, value: CameraIntrinsics) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, CameraIntrinsics):
      return [False, "intrinsics must be of type CameraIntrinsics for CameraIntrinsicsResponse, got " + type(value).__name__]

    return [True, ""]

  def __post_init__(self):
    # Type check incoming model - raise error if invalid (required or wrong type)
    is_valid, error_str = self.validate_intrinsics(self.intrinsics)
    if not is_valid:
      raise TypeError(error_str)

def parse_camera_intrinsics_response(data: object):
  return CameraIntrinsicsResponse(
    intrinsics=parse_camera_intrinsics(data["intrinsics"]) if "intrinsics" in data else None,
  )

def serialize_camera_intrinsics_response(data: CameraIntrinsicsResponse) -> object:
  return {
    "intrinsics": None if data.intrinsics is None else serialize_camera_intrinsics(data.intrinsics),
  }

@dataclass
class CameraFrameRequest:
  """Request for a single camera frame."""
  camera_settings: Union[CameraSettings, None] = None

  def validate_camera_settings(self, value: CameraSettings) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, CameraSettings):
      return [False, "camera_settings must be of type CameraSettings for CameraFrameRequest, got " + type(value).__name__]

    return [True, ""]

  def __post_init__(self):
    # Type check incoming model - raise error if invalid (required or wrong type)
    is_valid, error_str = self.validate_camera_settings(self.camera_settings)
    if not is_valid:
      raise TypeError(error_str)

def parse_camera_frame_request(data: object):
  return CameraFrameRequest(
    camera_settings=parse_camera_settings(data["camera_settings"]) if "camera_settings" in data else None,
  )

def serialize_camera_frame_request(data: CameraFrameRequest) -> object:
  return {
    "camera_settings": None if data.camera_settings is None else serialize_camera_settings(data.camera_settings),
  }

@dataclass
class JointState:
  """State of a joint"""
  braked: Union[bool, None] = None
  connectionStatus: Union[ConnectionStatus, None] = None
  inCollision: Union[bool, None] = None
  disturbance: Union[float, None] = None

  def validate_braked(self, value: bool) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, bool):
      return [False, "braked must be of type bool for JointState, got " + type(value).__name__]

    return [True, ""]

  def validate_connectionStatus(self, value: ConnectionStatus) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not ((isinstance(value, str) and ConnectionStatus in ['connected', 'disconnected', 'ready']) or isinstance(value, ConnectionStatus)):
      return [False, "connectionStatus must be of type ConnectionStatus for JointState, got " + type(value).__name__]

    return [True, ""]

  def validate_inCollision(self, value: bool) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, bool):
      return [False, "inCollision must be of type bool for JointState, got " + type(value).__name__]

    return [True, ""]

  def validate_disturbance(self, value: float) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, float):
      return [False, "disturbance must be of type float for JointState, got " + type(value).__name__]

    return [True, ""]

  def __post_init__(self):
    # Type check incoming model - raise error if invalid (required or wrong type)
    is_valid, error_str = self.validate_braked(self.braked)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_connectionStatus(self.connectionStatus)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_inCollision(self.inCollision)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_disturbance(self.disturbance)
    if not is_valid:
      raise TypeError(error_str)

def parse_joint_state(data: object):
  return JointState(
    braked=parse_bool(data["braked"]) if "braked" in data else None,
    connectionStatus=parse_connection_status(data["connectionStatus"]) if "connectionStatus" in data else None,
    inCollision=parse_bool(data["inCollision"]) if "inCollision" in data else None,
    disturbance=parse_f_64(data["disturbance"]) if "disturbance" in data else None,
  )

def serialize_joint_state(data: JointState) -> object:
  return {
    "braked": None if data.braked is None else serialize_bool(data.braked),
    "connectionStatus": None if data.connectionStatus is None else serialize_connection_status(data.connectionStatus),
    "inCollision": None if data.inCollision is None else serialize_bool(data.inCollision),
    "disturbance": None if data.disturbance is None else serialize_f_64(data.disturbance),
  }

EnvironmentVariablesList = List[EnvironmentVariable]

def parse_environment_variables_list(data: object) -> EnvironmentVariablesList:
  return [parse_environment_variable(item) for item in data]

def serialize_environment_variables_list(data: EnvironmentVariablesList) -> List[object]:
  return [serialize_environment_variable(item) for item in data]

@dataclass
class ErrorResponse:
  """Error Response"""
  error: Union[ErrorEnum, None] = None
  message: Union[str, None] = None

  def validate_error(self, value: ErrorEnum) -> Tuple[bool, str]:
    if value is None:
      return [False, "error is required for ErrorResponse"]

    if not ((isinstance(value, str) and ErrorEnum in ['authorization_required', 'routine_must_be_running', 'api_control_required', 'robot_brakes_disengage_failed', 'robot_brakes_engage_failed', 'request_failed_validation', 'robot_not_idle', 'brakes_must_be_engaged', 'brakes_must_be_disengaged', 'equipment_no_matching', 'service_initializing', 'camera_disconnected', 'settings_validation_error', 'settings_timeout', 'internal_server_error', 'recovery_error', 'not_found']) or isinstance(value, ErrorEnum)):
      return [False, "error must be of type ErrorEnum for ErrorResponse, got " + type(value).__name__]

    return [True, ""]

  def validate_message(self, value: str) -> Tuple[bool, str]:
    if value is None:
      return [False, "message is required for ErrorResponse"]

    if not isinstance(value, str):
      return [False, "message must be of type str for ErrorResponse, got " + type(value).__name__]

    return [True, ""]

  def __post_init__(self):
    # Type check incoming model - raise error if invalid (required or wrong type)
    is_valid, error_str = self.validate_error(self.error)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_message(self.message)
    if not is_valid:
      raise TypeError(error_str)

def parse_error_response(data: object):
  return ErrorResponse(
    error=parse_error_enum(data["error"]) if "error" in data else None,
    message=parse_str(data["message"]) if "message" in data else None,
  )

def serialize_error_response(data: ErrorResponse) -> object:
  return {
    "error": serialize_error_enum(data.error),
    "message": serialize_str(data.message),
  }

@dataclass
class ForceUnit:
  """Reusable Abstraction for force units (eg force, torque)
"""
  unit_kind: Union[ForceUnitKind, None] = None
  value: Union[float, None] = None

  def validate_unit_kind(self, value: ForceUnitKind) -> Tuple[bool, str]:
    if value is None:
      return [False, "unit_kind is required for ForceUnit"]

    if not ((isinstance(value, str) and ForceUnitKind in ['newtons', 'pounds']) or isinstance(value, ForceUnitKind)):
      return [False, "unit_kind must be of type ForceUnitKind for ForceUnit, got " + type(value).__name__]

    return [True, ""]

  def validate_value(self, value: float) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, float):
      return [False, "value must be of type float for ForceUnit, got " + type(value).__name__]

    return [True, ""]

  def __post_init__(self):
    # Type check incoming model - raise error if invalid (required or wrong type)
    is_valid, error_str = self.validate_unit_kind(self.unit_kind)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_value(self.value)
    if not is_valid:
      raise TypeError(error_str)

def parse_force_unit(data: object):
  return ForceUnit(
    unit_kind=parse_force_unit_kind(data["unit_kind"]) if "unit_kind" in data else None,
    value=parse_f_64(data["value"]) if "value" in data else None,
  )

def serialize_force_unit(data: ForceUnit) -> object:
  return {
    "unit_kind": serialize_force_unit_kind(data.unit_kind),
    "value": None if data.value is None else serialize_f_64(data.value),
  }

@dataclass
class GripperConfiguration:
  """Configuration of gripper, also known as End Effector"""
  kind: Union[GripperKindEnum, None] = None
  dh_ag: Union[DHAGGripperConfiguration, None] = None
  dh_pgc: Union[DHPGCGripperConfiguration, None] = None
  dh_cgi: Union[DHCGIGripperConfiguration, None] = None

  def validate_kind(self, value: GripperKindEnum) -> Tuple[bool, str]:
    if value is None:
      return [False, "kind is required for GripperConfiguration"]

    if not ((isinstance(value, str) and GripperKindEnum in ['onrobot_2fg7', 'onrobot_3fg15', 'dh_ag', 'dh_pgc', 'dh_cgi', 'none_connected']) or isinstance(value, GripperKindEnum)):
      return [False, "kind must be of type GripperKindEnum for GripperConfiguration, got " + type(value).__name__]

    return [True, ""]

  def validate_dh_ag(self, value: DHAGGripperConfiguration) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, DHAGGripperConfiguration):
      return [False, "dh_ag must be of type DHAGGripperConfiguration for GripperConfiguration, got " + type(value).__name__]

    return [True, ""]

  def validate_dh_pgc(self, value: DHPGCGripperConfiguration) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, DHPGCGripperConfiguration):
      return [False, "dh_pgc must be of type DHPGCGripperConfiguration for GripperConfiguration, got " + type(value).__name__]

    return [True, ""]

  def validate_dh_cgi(self, value: DHCGIGripperConfiguration) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, DHCGIGripperConfiguration):
      return [False, "dh_cgi must be of type DHCGIGripperConfiguration for GripperConfiguration, got " + type(value).__name__]

    return [True, ""]

  def __post_init__(self):
    # Type check incoming model - raise error if invalid (required or wrong type)
    is_valid, error_str = self.validate_kind(self.kind)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_dh_ag(self.dh_ag)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_dh_pgc(self.dh_pgc)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_dh_cgi(self.dh_cgi)
    if not is_valid:
      raise TypeError(error_str)

def parse_gripper_configuration(data: object):
  return GripperConfiguration(
    kind=parse_gripper_kind_enum(data["kind"]) if "kind" in data else None,
    dh_ag=parse_dhag_gripper_configuration(data["dh_ag"]) if "dh_ag" in data else None,
    dh_pgc=parse_dhpgc_gripper_configuration(data["dh_pgc"]) if "dh_pgc" in data else None,
    dh_cgi=parse_dhcgi_gripper_configuration(data["dh_cgi"]) if "dh_cgi" in data else None,
  )

def serialize_gripper_configuration(data: GripperConfiguration) -> object:
  return {
    "kind": serialize_gripper_kind_enum(data.kind),
    "dh_ag": None if data.dh_ag is None else serialize_dhag_gripper_configuration(data.dh_ag),
    "dh_pgc": None if data.dh_pgc is None else serialize_dhpgc_gripper_configuration(data.dh_pgc),
    "dh_cgi": None if data.dh_cgi is None else serialize_dhcgi_gripper_configuration(data.dh_cgi),
  }

@dataclass
class ArmJointRotations:
  """Rotational positions of arm joints"""
  joints: Union[JointRotations, None] = None

  def validate_joints(self, value: JointRotations) -> Tuple[bool, str]:
    if value is None:
      return [False, "joints is required for ArmJointRotations"]

    if not (isinstance(value, tuple) and len(value) == 6):
      return [False, "joints must be of type JointRotations for ArmJointRotations, got " + type(value).__name__]

    return [True, ""]

  def __post_init__(self):
    # Type check incoming model - raise error if invalid (required or wrong type)
    is_valid, error_str = self.validate_joints(self.joints)
    if not is_valid:
      raise TypeError(error_str)

def parse_arm_joint_rotations(data: object):
  return ArmJointRotations(
    joints=parse_joint_rotations(data["joints"]) if "joints" in data else None,
  )

def serialize_arm_joint_rotations(data: ArmJointRotations) -> object:
  return {
    "joints": serialize_joint_rotations(data.joints),
  }

@dataclass
class LinearUnit:
  """Reusable Abstraction for linear units (eg distance, position, offset)
"""
  unit_kind: Union[LinearUnitKind, None] = None
  value: Union[float, None] = None

  def validate_unit_kind(self, value: LinearUnitKind) -> Tuple[bool, str]:
    if value is None:
      return [False, "unit_kind is required for LinearUnit"]

    if not ((isinstance(value, str) and LinearUnitKind in ['millimeters', 'centimeters', 'meters', 'inches', 'feet']) or isinstance(value, LinearUnitKind)):
      return [False, "unit_kind must be of type LinearUnitKind for LinearUnit, got " + type(value).__name__]

    return [True, ""]

  def validate_value(self, value: float) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, float):
      return [False, "value must be of type float for LinearUnit, got " + type(value).__name__]

    return [True, ""]

  def __post_init__(self):
    # Type check incoming model - raise error if invalid (required or wrong type)
    is_valid, error_str = self.validate_unit_kind(self.unit_kind)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_value(self.value)
    if not is_valid:
      raise TypeError(error_str)

def parse_linear_unit(data: object):
  return LinearUnit(
    unit_kind=parse_linear_unit_kind(data["unit_kind"]) if "unit_kind" in data else None,
    value=parse_f_64(data["value"]) if "value" in data else None,
  )

def serialize_linear_unit(data: LinearUnit) -> object:
  return {
    "unit_kind": serialize_linear_unit_kind(data.unit_kind),
    "value": None if data.value is None else serialize_f_64(data.value),
  }

@dataclass
class Position:
  """Position of an object in 3D space. All empty values default to 0"""
  unit_kind: Union[LinearUnitKind, None] = None
  x: Union[float, None] = None
  y: Union[float, None] = None
  z: Union[float, None] = None

  def validate_unit_kind(self, value: LinearUnitKind) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not ((isinstance(value, str) and LinearUnitKind in ['millimeters', 'centimeters', 'meters', 'inches', 'feet']) or isinstance(value, LinearUnitKind)):
      return [False, "unit_kind must be of type LinearUnitKind for Position, got " + type(value).__name__]

    return [True, ""]

  def validate_x(self, value: float) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, float):
      return [False, "x must be of type float for Position, got " + type(value).__name__]

    return [True, ""]

  def validate_y(self, value: float) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, float):
      return [False, "y must be of type float for Position, got " + type(value).__name__]

    return [True, ""]

  def validate_z(self, value: float) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, float):
      return [False, "z must be of type float for Position, got " + type(value).__name__]

    return [True, ""]

  def __post_init__(self):
    # Type check incoming model - raise error if invalid (required or wrong type)
    is_valid, error_str = self.validate_unit_kind(self.unit_kind)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_x(self.x)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_y(self.y)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_z(self.z)
    if not is_valid:
      raise TypeError(error_str)

def parse_position(data: object):
  return Position(
    unit_kind=parse_linear_unit_kind(data["unit_kind"]) if "unit_kind" in data else None,
    x=parse_f_64(data["x"]) if "x" in data else None,
    y=parse_f_64(data["y"]) if "y" in data else None,
    z=parse_f_64(data["z"]) if "z" in data else None,
  )

def serialize_position(data: Position) -> object:
  return {
    "unit_kind": None if data.unit_kind is None else serialize_linear_unit_kind(data.unit_kind),
    "x": None if data.x is None else serialize_f_64(data.x),
    "y": None if data.y is None else serialize_f_64(data.y),
    "z": None if data.z is None else serialize_f_64(data.z),
  }

PlanesList = List[Plane]

def parse_planes_list(data: object) -> PlanesList:
  return [parse_plane(item) for item in data]

def serialize_planes_list(data: PlanesList) -> List[object]:
  return [serialize_plane(item) for item in data]

@dataclass
class Orientation:
  """Orientation of an object in 3D space"""
  kind: Union[OrientationKindEnum, None] = None
  quaternion: Union[Quaternion, None] = None

  def validate_kind(self, value: OrientationKindEnum) -> Tuple[bool, str]:
    if value is None:
      return [False, "kind is required for Orientation"]

    if not ((isinstance(value, str) and OrientationKindEnum in ['quaternion']) or isinstance(value, OrientationKindEnum)):
      return [False, "kind must be of type OrientationKindEnum for Orientation, got " + type(value).__name__]

    return [True, ""]

  def validate_quaternion(self, value: Quaternion) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, Quaternion):
      return [False, "quaternion must be of type Quaternion for Orientation, got " + type(value).__name__]

    return [True, ""]

  def __post_init__(self):
    # Type check incoming model - raise error if invalid (required or wrong type)
    is_valid, error_str = self.validate_kind(self.kind)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_quaternion(self.quaternion)
    if not is_valid:
      raise TypeError(error_str)

def parse_orientation(data: object):
  return Orientation(
    kind=parse_orientation_kind_enum(data["kind"]) if "kind" in data else None,
    quaternion=parse_quaternion(data["quaternion"]) if "quaternion" in data else None,
  )

def serialize_orientation(data: Orientation) -> object:
  return {
    "kind": serialize_orientation_kind_enum(data.kind),
    "quaternion": None if data.quaternion is None else serialize_quaternion(data.quaternion),
  }

@dataclass
class RobotControlMode:
  """Definition of Robot Control State, which tells you which service or system is controlling the Robot"""
  kind: Union[RobotControlModeEnum, None] = None

  def validate_kind(self, value: RobotControlModeEnum) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not ((isinstance(value, str) and RobotControlModeEnum in ['api', 'routine_editor']) or isinstance(value, RobotControlModeEnum)):
      return [False, "kind must be of type RobotControlModeEnum for RobotControlMode, got " + type(value).__name__]

    return [True, ""]

  def __post_init__(self):
    # Type check incoming model - raise error if invalid (required or wrong type)
    is_valid, error_str = self.validate_kind(self.kind)
    if not is_valid:
      raise TypeError(error_str)

def parse_robot_control_mode(data: object):
  return RobotControlMode(
    kind=parse_robot_control_mode_enum(data["kind"]) if "kind" in data else None,
  )

def serialize_robot_control_mode(data: RobotControlMode) -> object:
  return {
    "kind": None if data.kind is None else serialize_robot_control_mode_enum(data.kind),
  }

@dataclass
class ROSControlStateResponse:
  """Response to a query for the current state of ROS control."""
  state: Union[ROSControlStateEnum, None] = None

  def validate_state(self, value: ROSControlStateEnum) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not ((isinstance(value, str) and ROSControlStateEnum in ['enabled', 'disabled']) or isinstance(value, ROSControlStateEnum)):
      return [False, "state must be of type ROSControlStateEnum for ROSControlStateResponse, got " + type(value).__name__]

    return [True, ""]

  def __post_init__(self):
    # Type check incoming model - raise error if invalid (required or wrong type)
    is_valid, error_str = self.validate_state(self.state)
    if not is_valid:
      raise TypeError(error_str)

def parse_ros_control_state_response(data: object):
  return ROSControlStateResponse(
    state=parse_ros_control_state_enum(data["state"]) if "state" in data else None,
  )

def serialize_ros_control_state_response(data: ROSControlStateResponse) -> object:
  return {
    "state": None if data.state is None else serialize_ros_control_state_enum(data.state),
  }

@dataclass
class ROSControlUpdateRequest:
  """Request to update the state of direct ROS control."""
  action: Union[ROSControlStateEnum, None] = None

  def validate_action(self, value: ROSControlStateEnum) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not ((isinstance(value, str) and ROSControlStateEnum in ['enabled', 'disabled']) or isinstance(value, ROSControlStateEnum)):
      return [False, "action must be of type ROSControlStateEnum for ROSControlUpdateRequest, got " + type(value).__name__]

    return [True, ""]

  def __post_init__(self):
    # Type check incoming model - raise error if invalid (required or wrong type)
    is_valid, error_str = self.validate_action(self.action)
    if not is_valid:
      raise TypeError(error_str)

def parse_ros_control_update_request(data: object):
  return ROSControlUpdateRequest(
    action=parse_ros_control_state_enum(data["action"]) if "action" in data else None,
  )

def serialize_ros_control_update_request(data: ROSControlUpdateRequest) -> object:
  return {
    "action": None if data.action is None else serialize_ros_control_state_enum(data.action),
  }

@dataclass
class PlayRoutineRequest:
  """Request to play a routine"""
  variables: Union[RoutineVariablesStateMap, None] = None

  def validate_variables(self, value: RoutineVariablesStateMap) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not (isinstance(value, dict) and all((isinstance(k, str) and isinstance(val, str)) for k, val in value.items())):
      return [False, "variables must be of type RoutineVariablesStateMap for PlayRoutineRequest, got " + type(value).__name__]

    return [True, ""]

  def __post_init__(self):
    # Type check incoming model - raise error if invalid (required or wrong type)
    is_valid, error_str = self.validate_variables(self.variables)
    if not is_valid:
      raise TypeError(error_str)

def parse_play_routine_request(data: object):
  return PlayRoutineRequest(
    variables=parse_routine_variables_state_map(data["variables"]) if "variables" in data else None,
  )

def serialize_play_routine_request(data: PlayRoutineRequest) -> object:
  return {
    "variables": None if data.variables is None else serialize_routine_variables_state_map(data.variables),
  }

@dataclass
class TextToSkillRequest:
  """Request to convert text to a skill."""
  text: Union[str, None] = None
  skills: Union[SkillsList, None] = None

  def validate_text(self, value: str) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, str):
      return [False, "text must be of type str for TextToSkillRequest, got " + type(value).__name__]

    return [True, ""]

  def validate_skills(self, value: SkillsList) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not (isinstance(value, list) and all(isinstance(x, str) for x in value)):
      return [False, "skills must be of type SkillsList for TextToSkillRequest, got " + type(value).__name__]

    return [True, ""]

  def __post_init__(self):
    # Type check incoming model - raise error if invalid (required or wrong type)
    is_valid, error_str = self.validate_text(self.text)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_skills(self.skills)
    if not is_valid:
      raise TypeError(error_str)

def parse_text_to_skill_request(data: object):
  return TextToSkillRequest(
    text=parse_str(data["text"]) if "text" in data else None,
    skills=parse_skills_list(data["skills"]) if "skills" in data else None,
  )

def serialize_text_to_skill_request(data: TextToSkillRequest) -> object:
  return {
    "text": None if data.text is None else serialize_str(data.text),
    "skills": None if data.skills is None else serialize_skills_list(data.skills),
  }

@dataclass
class StatusHealthResponse:
  """Status Health Response"""
  health: Union[StatusHealthEnum, None] = None
  build: Union[StatusVersionData, None] = None

  def validate_health(self, value: StatusHealthEnum) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not ((isinstance(value, str) and StatusHealthEnum in ['ok', 'warning', 'error']) or isinstance(value, StatusHealthEnum)):
      return [False, "health must be of type StatusHealthEnum for StatusHealthResponse, got " + type(value).__name__]

    return [True, ""]

  def validate_build(self, value: StatusVersionData) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, StatusVersionData):
      return [False, "build must be of type StatusVersionData for StatusHealthResponse, got " + type(value).__name__]

    return [True, ""]

  def __post_init__(self):
    # Type check incoming model - raise error if invalid (required or wrong type)
    is_valid, error_str = self.validate_health(self.health)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_build(self.build)
    if not is_valid:
      raise TypeError(error_str)

def parse_status_health_response(data: object):
  return StatusHealthResponse(
    health=parse_status_health_enum(data["health"]) if "health" in data else None,
    build=parse_status_version_data(data["build"]) if "build" in data else None,
  )

def serialize_status_health_response(data: StatusHealthResponse) -> object:
  return {
    "health": None if data.health is None else serialize_status_health_enum(data.health),
    "build": None if data.build is None else serialize_status_version_data(data.build),
  }

@dataclass
class TeleopStateResponse:
  """Response to a query for the current state of teleoperation."""
  state: Union[TeleopStateEnum, None] = None

  def validate_state(self, value: TeleopStateEnum) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not ((isinstance(value, str) and TeleopStateEnum in ['wait_for_teleop', 'teleop', 'stopping', 'stopped', 'moving', 'unfrozen']) or isinstance(value, TeleopStateEnum)):
      return [False, "state must be of type TeleopStateEnum for TeleopStateResponse, got " + type(value).__name__]

    return [True, ""]

  def __post_init__(self):
    # Type check incoming model - raise error if invalid (required or wrong type)
    is_valid, error_str = self.validate_state(self.state)
    if not is_valid:
      raise TypeError(error_str)

def parse_teleop_state_response(data: object):
  return TeleopStateResponse(
    state=parse_teleop_state_enum(data["state"]) if "state" in data else None,
  )

def serialize_teleop_state_response(data: TeleopStateResponse) -> object:
  return {
    "state": None if data.state is None else serialize_teleop_state_enum(data.state),
  }

@dataclass
class ArmPositionUpdateRequestResponseEventStreamDetails:
  """Specify how the response should be sent
"""
  subscriptions: Union[ArmPositionUpdateRequestResponseEventStreamSubscriptionsList, None] = None

  def validate_subscriptions(self, value: ArmPositionUpdateRequestResponseEventStreamSubscriptionsList) -> Tuple[bool, str]:
    if value is None:
      return [False, "subscriptions is required for ArmPositionUpdateRequestResponseEventStreamDetails"]

    if not (isinstance(value, list) and all(((isinstance(x, str) and ArmPositionUpdateRequestResponseEventStreamSubscriptionKindEnum in ['all', 'events', 'positions']) or isinstance(x, ArmPositionUpdateRequestResponseEventStreamSubscriptionKindEnum)) for x in value)):
      return [False, "subscriptions must be of type ArmPositionUpdateRequestResponseEventStreamSubscriptionsList for ArmPositionUpdateRequestResponseEventStreamDetails, got " + type(value).__name__]

    return [True, ""]

  def __post_init__(self):
    # Type check incoming model - raise error if invalid (required or wrong type)
    is_valid, error_str = self.validate_subscriptions(self.subscriptions)
    if not is_valid:
      raise TypeError(error_str)

def parse_arm_position_update_request_response_event_stream_details(data: object):
  return ArmPositionUpdateRequestResponseEventStreamDetails(
    subscriptions=parse_arm_position_update_request_response_event_stream_subscriptions_list(data["subscriptions"]) if "subscriptions" in data else None,
  )

def serialize_arm_position_update_request_response_event_stream_details(data: ArmPositionUpdateRequestResponseEventStreamDetails) -> object:
  return {
    "subscriptions": serialize_arm_position_update_request_response_event_stream_subscriptions_list(data.subscriptions),
  }

@dataclass
class JointsStateResponse:
  """Response to a query for the current state of the joints"""
  J0: Union[JointState, None] = None
  J1: Union[JointState, None] = None
  J2: Union[JointState, None] = None
  J3: Union[JointState, None] = None
  J4: Union[JointState, None] = None
  J5: Union[JointState, None] = None

  def validate_J0(self, value: JointState) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, JointState):
      return [False, "J0 must be of type JointState for JointsStateResponse, got " + type(value).__name__]

    return [True, ""]

  def validate_J1(self, value: JointState) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, JointState):
      return [False, "J1 must be of type JointState for JointsStateResponse, got " + type(value).__name__]

    return [True, ""]

  def validate_J2(self, value: JointState) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, JointState):
      return [False, "J2 must be of type JointState for JointsStateResponse, got " + type(value).__name__]

    return [True, ""]

  def validate_J3(self, value: JointState) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, JointState):
      return [False, "J3 must be of type JointState for JointsStateResponse, got " + type(value).__name__]

    return [True, ""]

  def validate_J4(self, value: JointState) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, JointState):
      return [False, "J4 must be of type JointState for JointsStateResponse, got " + type(value).__name__]

    return [True, ""]

  def validate_J5(self, value: JointState) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, JointState):
      return [False, "J5 must be of type JointState for JointsStateResponse, got " + type(value).__name__]

    return [True, ""]

  def __post_init__(self):
    # Type check incoming model - raise error if invalid (required or wrong type)
    is_valid, error_str = self.validate_J0(self.J0)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_J1(self.J1)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_J2(self.J2)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_J3(self.J3)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_J4(self.J4)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_J5(self.J5)
    if not is_valid:
      raise TypeError(error_str)

def parse_joints_state_response(data: object):
  return JointsStateResponse(
    J0=parse_joint_state(data["J0"]) if "J0" in data else None,
    J1=parse_joint_state(data["J1"]) if "J1" in data else None,
    J2=parse_joint_state(data["J2"]) if "J2" in data else None,
    J3=parse_joint_state(data["J3"]) if "J3" in data else None,
    J4=parse_joint_state(data["J4"]) if "J4" in data else None,
    J5=parse_joint_state(data["J5"]) if "J5" in data else None,
  )

def serialize_joints_state_response(data: JointsStateResponse) -> object:
  return {
    "J0": None if data.J0 is None else serialize_joint_state(data.J0),
    "J1": None if data.J1 is None else serialize_joint_state(data.J1),
    "J2": None if data.J2 is None else serialize_joint_state(data.J2),
    "J3": None if data.J3 is None else serialize_joint_state(data.J3),
    "J4": None if data.J4 is None else serialize_joint_state(data.J4),
    "J5": None if data.J5 is None else serialize_joint_state(data.J5),
  }

@dataclass
class Routine:
  """Robot Routine containing steps to automate robot movement and operations"""
  id: Union[str, None] = None
  name: Union[str, None] = None
  environment_variables: Union[EnvironmentVariablesList, None] = None

  def validate_id(self, value: str) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, str):
      return [False, "id must be of type str for Routine, got " + type(value).__name__]

    return [True, ""]

  def validate_name(self, value: str) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, str):
      return [False, "name must be of type str for Routine, got " + type(value).__name__]

    return [True, ""]

  def validate_environment_variables(self, value: EnvironmentVariablesList) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not (isinstance(value, list) and all(isinstance(x, EnvironmentVariable) for x in value)):
      return [False, "environment_variables must be of type EnvironmentVariablesList for Routine, got " + type(value).__name__]

    return [True, ""]

  def __post_init__(self):
    # Type check incoming model - raise error if invalid (required or wrong type)
    is_valid, error_str = self.validate_id(self.id)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_name(self.name)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_environment_variables(self.environment_variables)
    if not is_valid:
      raise TypeError(error_str)

def parse_routine(data: object):
  return Routine(
    id=parse_str(data["id"]) if "id" in data else None,
    name=parse_str(data["name"]) if "name" in data else None,
    environment_variables=parse_environment_variables_list(data["environment_variables"]) if "environment_variables" in data else None,
  )

def serialize_routine(data: Routine) -> object:
  return {
    "id": None if data.id is None else serialize_str(data.id),
    "name": None if data.name is None else serialize_str(data.name),
    "environment_variables": None if data.environment_variables is None else serialize_environment_variables_list(data.environment_variables),
  }

ArmJointRotationsList = List[ArmJointRotations]

def parse_arm_joint_rotations_list(data: object) -> ArmJointRotationsList:
  return [parse_arm_joint_rotations(item) for item in data]

def serialize_arm_joint_rotations_list(data: ArmJointRotationsList) -> List[object]:
  return [serialize_arm_joint_rotations(item) for item in data]

@dataclass
class OnRobot2FG7GripperCommandRequest:
  """Control the OnRobot 2FG7 gripper (end effector) of the robot
"""
  grip_direction: Union[LinearGripDirectionEnum, None] = None
  target_force: Union[ForceUnit, None] = None
  target_grip_width: Union[LinearUnit, None] = None
  control_kind: Union[OnRobot2FG7ControlKindEnum, None] = None

  def validate_grip_direction(self, value: LinearGripDirectionEnum) -> Tuple[bool, str]:
    if value is None:
      return [False, "grip_direction is required for OnRobot2FG7GripperCommandRequest"]

    if not ((isinstance(value, str) and LinearGripDirectionEnum in ['inward', 'outward']) or isinstance(value, LinearGripDirectionEnum)):
      return [False, "grip_direction must be of type LinearGripDirectionEnum for OnRobot2FG7GripperCommandRequest, got " + type(value).__name__]

    return [True, ""]

  def validate_target_force(self, value: ForceUnit) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, ForceUnit):
      return [False, "target_force must be of type ForceUnit for OnRobot2FG7GripperCommandRequest, got " + type(value).__name__]

    return [True, ""]

  def validate_target_grip_width(self, value: LinearUnit) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, LinearUnit):
      return [False, "target_grip_width must be of type LinearUnit for OnRobot2FG7GripperCommandRequest, got " + type(value).__name__]

    return [True, ""]

  def validate_control_kind(self, value: OnRobot2FG7ControlKindEnum) -> Tuple[bool, str]:
    if value is None:
      return [False, "control_kind is required for OnRobot2FG7GripperCommandRequest"]

    if not ((isinstance(value, str) and OnRobot2FG7ControlKindEnum in ['move', 'force_grip']) or isinstance(value, OnRobot2FG7ControlKindEnum)):
      return [False, "control_kind must be of type OnRobot2FG7ControlKindEnum for OnRobot2FG7GripperCommandRequest, got " + type(value).__name__]

    return [True, ""]

  def __post_init__(self):
    # Type check incoming model - raise error if invalid (required or wrong type)
    is_valid, error_str = self.validate_grip_direction(self.grip_direction)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_target_force(self.target_force)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_target_grip_width(self.target_grip_width)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_control_kind(self.control_kind)
    if not is_valid:
      raise TypeError(error_str)

def parse_on_robot_2_fg_7_gripper_command_request(data: object):
  return OnRobot2FG7GripperCommandRequest(
    grip_direction=parse_linear_grip_direction_enum(data["grip_direction"]) if "grip_direction" in data else None,
    target_force=parse_force_unit(data["target_force"]) if "target_force" in data else None,
    target_grip_width=parse_linear_unit(data["target_grip_width"]) if "target_grip_width" in data else None,
    control_kind=parse_on_robot_2_fg_7_control_kind_enum(data["control_kind"]) if "control_kind" in data else None,
  )

def serialize_on_robot_2_fg_7_gripper_command_request(data: OnRobot2FG7GripperCommandRequest) -> object:
  return {
    "grip_direction": serialize_linear_grip_direction_enum(data.grip_direction),
    "target_force": None if data.target_force is None else serialize_force_unit(data.target_force),
    "target_grip_width": None if data.target_grip_width is None else serialize_linear_unit(data.target_grip_width),
    "control_kind": serialize_on_robot_2_fg_7_control_kind_enum(data.control_kind),
  }

@dataclass
class OnRobot3FG15GripperCommandRequest:
  """Control the OnRobot 3FG15 gripper (end effector) of the robot
"""
  grip_direction: Union[LinearGripDirectionEnum, None] = None
  target_force: Union[ForceUnit, None] = None
  target_grip_diameter: Union[LinearUnit, None] = None
  control_kind: Union[OnRobot3FG15ControlKindEnum, None] = None

  def validate_grip_direction(self, value: LinearGripDirectionEnum) -> Tuple[bool, str]:
    if value is None:
      return [False, "grip_direction is required for OnRobot3FG15GripperCommandRequest"]

    if not ((isinstance(value, str) and LinearGripDirectionEnum in ['inward', 'outward']) or isinstance(value, LinearGripDirectionEnum)):
      return [False, "grip_direction must be of type LinearGripDirectionEnum for OnRobot3FG15GripperCommandRequest, got " + type(value).__name__]

    return [True, ""]

  def validate_target_force(self, value: ForceUnit) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, ForceUnit):
      return [False, "target_force must be of type ForceUnit for OnRobot3FG15GripperCommandRequest, got " + type(value).__name__]

    return [True, ""]

  def validate_target_grip_diameter(self, value: LinearUnit) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, LinearUnit):
      return [False, "target_grip_diameter must be of type LinearUnit for OnRobot3FG15GripperCommandRequest, got " + type(value).__name__]

    return [True, ""]

  def validate_control_kind(self, value: OnRobot3FG15ControlKindEnum) -> Tuple[bool, str]:
    if value is None:
      return [False, "control_kind is required for OnRobot3FG15GripperCommandRequest"]

    if not ((isinstance(value, str) and OnRobot3FG15ControlKindEnum in ['move', 'force_grip', 'flexible_force_grip']) or isinstance(value, OnRobot3FG15ControlKindEnum)):
      return [False, "control_kind must be of type OnRobot3FG15ControlKindEnum for OnRobot3FG15GripperCommandRequest, got " + type(value).__name__]

    return [True, ""]

  def __post_init__(self):
    # Type check incoming model - raise error if invalid (required or wrong type)
    is_valid, error_str = self.validate_grip_direction(self.grip_direction)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_target_force(self.target_force)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_target_grip_diameter(self.target_grip_diameter)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_control_kind(self.control_kind)
    if not is_valid:
      raise TypeError(error_str)

def parse_on_robot_3_fg_15_gripper_command_request(data: object):
  return OnRobot3FG15GripperCommandRequest(
    grip_direction=parse_linear_grip_direction_enum(data["grip_direction"]) if "grip_direction" in data else None,
    target_force=parse_force_unit(data["target_force"]) if "target_force" in data else None,
    target_grip_diameter=parse_linear_unit(data["target_grip_diameter"]) if "target_grip_diameter" in data else None,
    control_kind=parse_on_robot_3_fg_15_control_kind_enum(data["control_kind"]) if "control_kind" in data else None,
  )

def serialize_on_robot_3_fg_15_gripper_command_request(data: OnRobot3FG15GripperCommandRequest) -> object:
  return {
    "grip_direction": serialize_linear_grip_direction_enum(data.grip_direction),
    "target_force": None if data.target_force is None else serialize_force_unit(data.target_force),
    "target_grip_diameter": None if data.target_grip_diameter is None else serialize_linear_unit(data.target_grip_diameter),
    "control_kind": serialize_on_robot_3_fg_15_control_kind_enum(data.control_kind),
  }

@dataclass
class PlanesPaginatedResponse:
  """Paginated response containing plane data"""
  items: Union[PlanesList, None] = None
  pagination: Union[Pagination, None] = None

  def validate_items(self, value: PlanesList) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not (isinstance(value, list) and all(isinstance(x, Plane) for x in value)):
      return [False, "items must be of type PlanesList for PlanesPaginatedResponse, got " + type(value).__name__]

    return [True, ""]

  def validate_pagination(self, value: Pagination) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, Pagination):
      return [False, "pagination must be of type Pagination for PlanesPaginatedResponse, got " + type(value).__name__]

    return [True, ""]

  def __post_init__(self):
    # Type check incoming model - raise error if invalid (required or wrong type)
    is_valid, error_str = self.validate_items(self.items)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_pagination(self.pagination)
    if not is_valid:
      raise TypeError(error_str)

def parse_planes_paginated_response(data: object):
  return PlanesPaginatedResponse(
    items=parse_planes_list(data["items"]) if "items" in data else None,
    pagination=parse_pagination(data["pagination"]) if "pagination" in data else None,
  )

def serialize_planes_paginated_response(data: PlanesPaginatedResponse) -> object:
  return {
    "items": None if data.items is None else serialize_planes_list(data.items),
    "pagination": None if data.pagination is None else serialize_pagination(data.pagination),
  }

@dataclass
class PositionAndOrientation:
  """Position of the arm tooltip"""
  axis_alignment: Union[str, None] = None
  reference_frame: Union[str, None] = None
  position: Union[Position, None] = None
  orientation: Union[Orientation, None] = None

  def validate_axis_alignment(self, value: str) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, str):
      return [False, "axis_alignment must be of type str for PositionAndOrientation, got " + type(value).__name__]

    return [True, ""]

  def validate_reference_frame(self, value: str) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, str):
      return [False, "reference_frame must be of type str for PositionAndOrientation, got " + type(value).__name__]

    return [True, ""]

  def validate_position(self, value: Position) -> Tuple[bool, str]:
    if value is None:
      return [False, "position is required for PositionAndOrientation"]

    if not isinstance(value, Position):
      return [False, "position must be of type Position for PositionAndOrientation, got " + type(value).__name__]

    return [True, ""]

  def validate_orientation(self, value: Orientation) -> Tuple[bool, str]:
    if value is None:
      return [False, "orientation is required for PositionAndOrientation"]

    if not isinstance(value, Orientation):
      return [False, "orientation must be of type Orientation for PositionAndOrientation, got " + type(value).__name__]

    return [True, ""]

  def __post_init__(self):
    # Type check incoming model - raise error if invalid (required or wrong type)
    is_valid, error_str = self.validate_axis_alignment(self.axis_alignment)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_reference_frame(self.reference_frame)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_position(self.position)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_orientation(self.orientation)
    if not is_valid:
      raise TypeError(error_str)

def parse_position_and_orientation(data: object):
  return PositionAndOrientation(
    axis_alignment=parse_str(data["axis_alignment"]) if "axis_alignment" in data else None,
    reference_frame=parse_str(data["reference_frame"]) if "reference_frame" in data else None,
    position=parse_position(data["position"]) if "position" in data else None,
    orientation=parse_orientation(data["orientation"]) if "orientation" in data else None,
  )

def serialize_position_and_orientation(data: PositionAndOrientation) -> object:
  return {
    "axis_alignment": None if data.axis_alignment is None else serialize_str(data.axis_alignment),
    "reference_frame": None if data.reference_frame is None else serialize_str(data.reference_frame),
    "position": serialize_position(data.position),
    "orientation": serialize_orientation(data.orientation),
  }

@dataclass
class ArmPositionUpdateRequestResponseFormat:
  """Specify how the response should be sent
"""
  kind: Union[ArmPositionUpdateRequestResponseKindEnum, None] = None
  event_stream: Union[ArmPositionUpdateRequestResponseEventStreamDetails, None] = None

  def validate_kind(self, value: ArmPositionUpdateRequestResponseKindEnum) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not ((isinstance(value, str) and ArmPositionUpdateRequestResponseKindEnum in ['sync', 'event_stream']) or isinstance(value, ArmPositionUpdateRequestResponseKindEnum)):
      return [False, "kind must be of type ArmPositionUpdateRequestResponseKindEnum for ArmPositionUpdateRequestResponseFormat, got " + type(value).__name__]

    return [True, ""]

  def validate_event_stream(self, value: ArmPositionUpdateRequestResponseEventStreamDetails) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, ArmPositionUpdateRequestResponseEventStreamDetails):
      return [False, "event_stream must be of type ArmPositionUpdateRequestResponseEventStreamDetails for ArmPositionUpdateRequestResponseFormat, got " + type(value).__name__]

    return [True, ""]

  def __post_init__(self):
    # Type check incoming model - raise error if invalid (required or wrong type)
    is_valid, error_str = self.validate_kind(self.kind)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_event_stream(self.event_stream)
    if not is_valid:
      raise TypeError(error_str)

def parse_arm_position_update_request_response_format(data: object):
  return ArmPositionUpdateRequestResponseFormat(
    kind=parse_arm_position_update_request_response_kind_enum(data["kind"]) if "kind" in data else None,
    event_stream=parse_arm_position_update_request_response_event_stream_details(data["event_stream"]) if "event_stream" in data else None,
  )

def serialize_arm_position_update_request_response_format(data: ArmPositionUpdateRequestResponseFormat) -> object:
  return {
    "kind": None if data.kind is None else serialize_arm_position_update_request_response_kind_enum(data.kind),
    "event_stream": None if data.event_stream is None else serialize_arm_position_update_request_response_event_stream_details(data.event_stream),
  }

RoutinesList = List[Routine]

def parse_routines_list(data: object) -> RoutinesList:
  return [parse_routine(item) for item in data]

def serialize_routines_list(data: RoutinesList) -> List[object]:
  return [serialize_routine(item) for item in data]

@dataclass
class GripperCommandRequest:
  """Control the gripper (end effector) of the robot
"""
  kind: Union[GripperKindEnum, None] = None
  onrobot_2fg7: Union[OnRobot2FG7GripperCommandRequest, None] = None
  onrobot_3fg15: Union[OnRobot3FG15GripperCommandRequest, None] = None
  dh_ag: Union[DHAGGripperCommandRequest, None] = None
  dh_pgc: Union[DHPGCGripperCommandRequest, None] = None
  dh_cgi: Union[DHCGIGripperCommandRequest, None] = None

  def validate_kind(self, value: GripperKindEnum) -> Tuple[bool, str]:
    if value is None:
      return [False, "kind is required for GripperCommandRequest"]

    if not ((isinstance(value, str) and GripperKindEnum in ['onrobot_2fg7', 'onrobot_3fg15', 'dh_ag', 'dh_pgc', 'dh_cgi', 'none_connected']) or isinstance(value, GripperKindEnum)):
      return [False, "kind must be of type GripperKindEnum for GripperCommandRequest, got " + type(value).__name__]

    return [True, ""]

  def validate_onrobot_2fg7(self, value: OnRobot2FG7GripperCommandRequest) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, OnRobot2FG7GripperCommandRequest):
      return [False, "onrobot_2fg7 must be of type OnRobot2FG7GripperCommandRequest for GripperCommandRequest, got " + type(value).__name__]

    return [True, ""]

  def validate_onrobot_3fg15(self, value: OnRobot3FG15GripperCommandRequest) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, OnRobot3FG15GripperCommandRequest):
      return [False, "onrobot_3fg15 must be of type OnRobot3FG15GripperCommandRequest for GripperCommandRequest, got " + type(value).__name__]

    return [True, ""]

  def validate_dh_ag(self, value: DHAGGripperCommandRequest) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, DHAGGripperCommandRequest):
      return [False, "dh_ag must be of type DHAGGripperCommandRequest for GripperCommandRequest, got " + type(value).__name__]

    return [True, ""]

  def validate_dh_pgc(self, value: DHPGCGripperCommandRequest) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, DHPGCGripperCommandRequest):
      return [False, "dh_pgc must be of type DHPGCGripperCommandRequest for GripperCommandRequest, got " + type(value).__name__]

    return [True, ""]

  def validate_dh_cgi(self, value: DHCGIGripperCommandRequest) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, DHCGIGripperCommandRequest):
      return [False, "dh_cgi must be of type DHCGIGripperCommandRequest for GripperCommandRequest, got " + type(value).__name__]

    return [True, ""]

  def __post_init__(self):
    # Type check incoming model - raise error if invalid (required or wrong type)
    is_valid, error_str = self.validate_kind(self.kind)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_onrobot_2fg7(self.onrobot_2fg7)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_onrobot_3fg15(self.onrobot_3fg15)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_dh_ag(self.dh_ag)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_dh_pgc(self.dh_pgc)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_dh_cgi(self.dh_cgi)
    if not is_valid:
      raise TypeError(error_str)

def parse_gripper_command_request(data: object):
  return GripperCommandRequest(
    kind=parse_gripper_kind_enum(data["kind"]) if "kind" in data else None,
    onrobot_2fg7=parse_on_robot_2_fg_7_gripper_command_request(data["onrobot_2fg7"]) if "onrobot_2fg7" in data else None,
    onrobot_3fg15=parse_on_robot_3_fg_15_gripper_command_request(data["onrobot_3fg15"]) if "onrobot_3fg15" in data else None,
    dh_ag=parse_dhag_gripper_command_request(data["dh_ag"]) if "dh_ag" in data else None,
    dh_pgc=parse_dhpgc_gripper_command_request(data["dh_pgc"]) if "dh_pgc" in data else None,
    dh_cgi=parse_dhcgi_gripper_command_request(data["dh_cgi"]) if "dh_cgi" in data else None,
  )

def serialize_gripper_command_request(data: GripperCommandRequest) -> object:
  return {
    "kind": serialize_gripper_kind_enum(data.kind),
    "onrobot_2fg7": None if data.onrobot_2fg7 is None else serialize_on_robot_2_fg_7_gripper_command_request(data.onrobot_2fg7),
    "onrobot_3fg15": None if data.onrobot_3fg15 is None else serialize_on_robot_3_fg_15_gripper_command_request(data.onrobot_3fg15),
    "dh_ag": None if data.dh_ag is None else serialize_dhag_gripper_command_request(data.dh_ag),
    "dh_pgc": None if data.dh_pgc is None else serialize_dhpgc_gripper_command_request(data.dh_pgc),
    "dh_cgi": None if data.dh_cgi is None else serialize_dhcgi_gripper_command_request(data.dh_cgi),
  }

@dataclass
class CombinedArmPosition:
  """Combined tooltip position and joint rotations defining the arm&#x27;s position"""
  joint_rotations: Union[JointRotations, None] = None
  tooltip_position: Union[PositionAndOrientation, None] = None

  def validate_joint_rotations(self, value: JointRotations) -> Tuple[bool, str]:
    if value is None:
      return [False, "joint_rotations is required for CombinedArmPosition"]

    if not (isinstance(value, tuple) and len(value) == 6):
      return [False, "joint_rotations must be of type JointRotations for CombinedArmPosition, got " + type(value).__name__]

    return [True, ""]

  def validate_tooltip_position(self, value: PositionAndOrientation) -> Tuple[bool, str]:
    if value is None:
      return [False, "tooltip_position is required for CombinedArmPosition"]

    if not isinstance(value, PositionAndOrientation):
      return [False, "tooltip_position must be of type PositionAndOrientation for CombinedArmPosition, got " + type(value).__name__]

    return [True, ""]

  def __post_init__(self):
    # Type check incoming model - raise error if invalid (required or wrong type)
    is_valid, error_str = self.validate_joint_rotations(self.joint_rotations)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_tooltip_position(self.tooltip_position)
    if not is_valid:
      raise TypeError(error_str)

def parse_combined_arm_position(data: object):
  return CombinedArmPosition(
    joint_rotations=parse_joint_rotations(data["joint_rotations"]) if "joint_rotations" in data else None,
    tooltip_position=parse_position_and_orientation(data["tooltip_position"]) if "tooltip_position" in data else None,
  )

def serialize_combined_arm_position(data: CombinedArmPosition) -> object:
  return {
    "joint_rotations": serialize_joint_rotations(data.joint_rotations),
    "tooltip_position": serialize_position_and_orientation(data.tooltip_position),
  }

PositionAndOrientationList = List[PositionAndOrientation]

def parse_position_and_orientation_list(data: object) -> PositionAndOrientationList:
  return [parse_position_and_orientation(item) for item in data]

def serialize_position_and_orientation_list(data: PositionAndOrientationList) -> List[object]:
  return [serialize_position_and_orientation(item) for item in data]

@dataclass
class RoutinesPaginatedResponse:
  """Paginated response containing routine data"""
  items: Union[RoutinesList, None] = None
  pagination: Union[Pagination, None] = None

  def validate_items(self, value: RoutinesList) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not (isinstance(value, list) and all(isinstance(x, Routine) for x in value)):
      return [False, "items must be of type RoutinesList for RoutinesPaginatedResponse, got " + type(value).__name__]

    return [True, ""]

  def validate_pagination(self, value: Pagination) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, Pagination):
      return [False, "pagination must be of type Pagination for RoutinesPaginatedResponse, got " + type(value).__name__]

    return [True, ""]

  def __post_init__(self):
    # Type check incoming model - raise error if invalid (required or wrong type)
    is_valid, error_str = self.validate_items(self.items)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_pagination(self.pagination)
    if not is_valid:
      raise TypeError(error_str)

def parse_routines_paginated_response(data: object):
  return RoutinesPaginatedResponse(
    items=parse_routines_list(data["items"]) if "items" in data else None,
    pagination=parse_pagination(data["pagination"]) if "pagination" in data else None,
  )

def serialize_routines_paginated_response(data: RoutinesPaginatedResponse) -> object:
  return {
    "items": None if data.items is None else serialize_routines_list(data.items),
    "pagination": None if data.pagination is None else serialize_pagination(data.pagination),
  }

@dataclass
class ArmPositionUpdateEvent:
  """Event emitted by the move robot API"""
  kind: Union[ArmPositionUpdateKindEnum, None] = None
  failure: Union[ArmPositionUpdateFailureEvent, None] = None
  canceled: Union[ArmPositionUpdateCanceledEvent, None] = None
  position: Union[CombinedArmPosition, None] = None

  def validate_kind(self, value: ArmPositionUpdateKindEnum) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not ((isinstance(value, str) and ArmPositionUpdateKindEnum in ['success', 'failure', 'canceled', 'position', 'planning']) or isinstance(value, ArmPositionUpdateKindEnum)):
      return [False, "kind must be of type ArmPositionUpdateKindEnum for ArmPositionUpdateEvent, got " + type(value).__name__]

    return [True, ""]

  def validate_failure(self, value: ArmPositionUpdateFailureEvent) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, ArmPositionUpdateFailureEvent):
      return [False, "failure must be of type ArmPositionUpdateFailureEvent for ArmPositionUpdateEvent, got " + type(value).__name__]

    return [True, ""]

  def validate_canceled(self, value: ArmPositionUpdateCanceledEvent) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, ArmPositionUpdateCanceledEvent):
      return [False, "canceled must be of type ArmPositionUpdateCanceledEvent for ArmPositionUpdateEvent, got " + type(value).__name__]

    return [True, ""]

  def validate_position(self, value: CombinedArmPosition) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, CombinedArmPosition):
      return [False, "position must be of type CombinedArmPosition for ArmPositionUpdateEvent, got " + type(value).__name__]

    return [True, ""]

  def __post_init__(self):
    # Type check incoming model - raise error if invalid (required or wrong type)
    is_valid, error_str = self.validate_kind(self.kind)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_failure(self.failure)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_canceled(self.canceled)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_position(self.position)
    if not is_valid:
      raise TypeError(error_str)

def parse_arm_position_update_event(data: object):
  return ArmPositionUpdateEvent(
    kind=parse_arm_position_update_kind_enum(data["kind"]) if "kind" in data else None,
    failure=parse_arm_position_update_failure_event(data["failure"]) if "failure" in data else None,
    canceled=parse_arm_position_update_canceled_event(data["canceled"]) if "canceled" in data else None,
    position=parse_combined_arm_position(data["position"]) if "position" in data else None,
  )

def serialize_arm_position_update_event(data: ArmPositionUpdateEvent) -> object:
  return {
    "kind": None if data.kind is None else serialize_arm_position_update_kind_enum(data.kind),
    "failure": None if data.failure is None else serialize_arm_position_update_failure_event(data.failure),
    "canceled": None if data.canceled is None else serialize_arm_position_update_canceled_event(data.canceled),
    "position": None if data.position is None else serialize_combined_arm_position(data.position),
  }

@dataclass
class ArmPositionUpdateRequest:
  """Move the robot"""
  kind: Union[ArmPositionUpdateRequestKindEnum, None] = None
  tooltip_positions: Union[PositionAndOrientationList, None] = None
  tooltip_position: Union[PositionAndOrientation, None] = None
  joint_rotations: Union[ArmJointRotationsList, None] = None
  joint_rotation: Union[ArmJointRotations, None] = None
  response: Union[ArmPositionUpdateRequestResponseFormat, None] = None

  def validate_kind(self, value: ArmPositionUpdateRequestKindEnum) -> Tuple[bool, str]:
    if value is None:
      return [False, "kind is required for ArmPositionUpdateRequest"]

    if not ((isinstance(value, str) and ArmPositionUpdateRequestKindEnum in ['tooltip_positions', 'tooltip_position', 'joint_rotations', 'joint_rotation']) or isinstance(value, ArmPositionUpdateRequestKindEnum)):
      return [False, "kind must be of type ArmPositionUpdateRequestKindEnum for ArmPositionUpdateRequest, got " + type(value).__name__]

    return [True, ""]

  def validate_tooltip_positions(self, value: PositionAndOrientationList) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not (isinstance(value, list) and all(isinstance(x, PositionAndOrientation) for x in value)):
      return [False, "tooltip_positions must be of type PositionAndOrientationList for ArmPositionUpdateRequest, got " + type(value).__name__]

    return [True, ""]

  def validate_tooltip_position(self, value: PositionAndOrientation) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, PositionAndOrientation):
      return [False, "tooltip_position must be of type PositionAndOrientation for ArmPositionUpdateRequest, got " + type(value).__name__]

    return [True, ""]

  def validate_joint_rotations(self, value: ArmJointRotationsList) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not (isinstance(value, list) and all(isinstance(x, ArmJointRotations) for x in value)):
      return [False, "joint_rotations must be of type ArmJointRotationsList for ArmPositionUpdateRequest, got " + type(value).__name__]

    return [True, ""]

  def validate_joint_rotation(self, value: ArmJointRotations) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, ArmJointRotations):
      return [False, "joint_rotation must be of type ArmJointRotations for ArmPositionUpdateRequest, got " + type(value).__name__]

    return [True, ""]

  def validate_response(self, value: ArmPositionUpdateRequestResponseFormat) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, ArmPositionUpdateRequestResponseFormat):
      return [False, "response must be of type ArmPositionUpdateRequestResponseFormat for ArmPositionUpdateRequest, got " + type(value).__name__]

    return [True, ""]

  def __post_init__(self):
    # Type check incoming model - raise error if invalid (required or wrong type)
    is_valid, error_str = self.validate_kind(self.kind)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_tooltip_positions(self.tooltip_positions)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_tooltip_position(self.tooltip_position)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_joint_rotations(self.joint_rotations)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_joint_rotation(self.joint_rotation)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_response(self.response)
    if not is_valid:
      raise TypeError(error_str)

def parse_arm_position_update_request(data: object):
  return ArmPositionUpdateRequest(
    kind=parse_arm_position_update_request_kind_enum(data["kind"]) if "kind" in data else None,
    tooltip_positions=parse_position_and_orientation_list(data["tooltip_positions"]) if "tooltip_positions" in data else None,
    tooltip_position=parse_position_and_orientation(data["tooltip_position"]) if "tooltip_position" in data else None,
    joint_rotations=parse_arm_joint_rotations_list(data["joint_rotations"]) if "joint_rotations" in data else None,
    joint_rotation=parse_arm_joint_rotations(data["joint_rotation"]) if "joint_rotation" in data else None,
    response=parse_arm_position_update_request_response_format(data["response"]) if "response" in data else None,
  )

def serialize_arm_position_update_request(data: ArmPositionUpdateRequest) -> object:
  return {
    "kind": serialize_arm_position_update_request_kind_enum(data.kind),
    "tooltip_positions": None if data.tooltip_positions is None else serialize_position_and_orientation_list(data.tooltip_positions),
    "tooltip_position": None if data.tooltip_position is None else serialize_position_and_orientation(data.tooltip_position),
    "joint_rotations": None if data.joint_rotations is None else serialize_arm_joint_rotations_list(data.joint_rotations),
    "joint_rotation": None if data.joint_rotation is None else serialize_arm_joint_rotations(data.joint_rotation),
    "response": None if data.response is None else serialize_arm_position_update_request_response_format(data.response),
  }

ArmPositionUpdateEventStream = List[ArmPositionUpdateEvent]

def parse_arm_position_update_event_stream(data: object) -> ArmPositionUpdateEventStream:
  return [parse_arm_position_update_event(item) for item in data]

def serialize_arm_position_update_event_stream(data: ArmPositionUpdateEventStream) -> List[object]:
  return [serialize_arm_position_update_event(item) for item in data]

