# Generated by Django 2.2.28 on 2022-06-03 04:23

from django.db import migrations
from django.db import models
import django.contrib.postgres.fields.jsonb
import django.core.validators
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='Config',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('adapter_address', models.URLField(blank=True, null=True, verbose_name='Адрес web-сервиса Адаптера')),
                ('app_mnemonics', models.CharField(blank=True, max_length=200, null=True, verbose_name='Наименование мнемоники информационной системы')),
                ('node_mnemonics', models.CharField(blank=True, max_length=200, null=True, verbose_name='Мнемоника узла информационной системы')),
                ('send_request_retry_time', models.IntegerField(blank=True, default=10, help_text='сек', null=True, validators=[django.core.validators.MinValueValidator(1), django.core.validators.MaxValueValidator(6000)], verbose_name='Период переотправки запроса SendRequest')),
                ('send_request_retry_count', models.IntegerField(blank=True, default=3, null=True, validators=[django.core.validators.MinValueValidator(1), django.core.validators.MaxValueValidator(20)], verbose_name='Количество попыток отправки SendRequest в случае ошибки Адаптера')),
                ('get_request_retry_time', models.IntegerField(blank=True, default=3, help_text='сек', null=True, validators=[django.core.validators.MinValueValidator(1), django.core.validators.MaxValueValidator(6000)], verbose_name='Периодичность отправки запроса GetRequest')),
                ('find_request_retry_time', models.IntegerField(blank=True, default=30, help_text='сек', null=True, validators=[django.core.validators.MinValueValidator(1), django.core.validators.MaxValueValidator(6000)], verbose_name='Период опроса Адаптера на наличие ответов СМЭВ')),
            ],
            options={
                'verbose_name': 'Настройки клиента к Адаптеру СМЭВ',
                'verbose_name_plural': 'Настройки клиента к Адаптеру СМЭВ',
            },
        ),
        migrations.CreateModel(
            name='Message',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('message_type', models.TextField(verbose_name='Вид сведений')),
                ('body', models.TextField(verbose_name='Тело запроса')),
                ('attachments', django.contrib.postgres.fields.jsonb.JSONField(blank=True, null=True, verbose_name='Вложения запроса')),
                ('client_id', models.TextField(blank=True, null=True, unique=True, verbose_name='Клиентский идентификатор запроса')),
                ('message_id', models.TextField(blank=True, null=True, unique=True, verbose_name='Идентификатор запроса СМЭВ 3')),
                ('reference_message_id', models.TextField(blank=True, null=True, verbose_name='Идентификатор корневого запроса (запроса, порождающего цепочку запросов)')),
                ('test', models.BooleanField(default=False, verbose_name='Признак тестового взаимодействия')),
                ('timestamp', models.DateTimeField(auto_now_add=True, verbose_name='Дата и время создания')),
                ('reply_to', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, to='adapter_client.Message', verbose_name='Сообщение, на которое пришел ответ')),
            ],
            options={
                'verbose_name': 'Сообщение',
                'verbose_name_plural': 'Сообщения',
            },
        ),
        migrations.CreateModel(
            name='OutgoingMessage',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('status', models.IntegerField(choices=[(1, 'Новый'), (2, 'Отправлен в Адаптер'), (3, 'Повторная отправка'), (4, 'Ошибка отправки')], default=1, verbose_name='Статус исходящего сообщения')),
                ('timestamp', models.DateTimeField(verbose_name='Дата и время создания')),
                ('attempts', models.IntegerField(verbose_name='Количество попыток отправки')),
                ('message', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, to='adapter_client.Message')),
            ],
        ),
        migrations.CreateModel(
            name='JournalEntry',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('address', models.TextField(blank=True, null=True, verbose_name='Адрес запроса')),
                ('timestamp', models.DateTimeField(auto_now_add=True, verbose_name='Дата отправки')),
                ('request_type', models.IntegerField(choices=[(1, 'Send'), (2, 'Get'), (3, 'Find')], verbose_name='Тип запроса')),
                ('request', models.TextField(blank=True, null=True, verbose_name='Запрос')),
                ('response', models.TextField(blank=True, null=True, verbose_name='Ответ')),
                ('error', models.TextField(blank=True, null=True, verbose_name='Ошибка')),
                ('message', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='adapter_client.Message', verbose_name='Сообщение')),
            ],
            options={
                'verbose_name': 'Запись журнала обмена',
                'verbose_name_plural': 'Записи журнала обмена',
            },
        ),
        migrations.CreateModel(
            name='IncomingMessage',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('status', models.IntegerField(choices=[(1, 'Получен'), (2, 'Ошибка ответа'), (3, 'Обработано РИС')], default=1, verbose_name='Статус входящего сообщения')),
                ('timestamp', models.DateTimeField(verbose_name='Дата и время создания')),
                ('message', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, to='adapter_client.Message')),
            ],
        ),
    ]
