# This file was auto-generated by Fern from our API Definition.

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from ..types.custom_agent_response import CustomAgentResponse
from .drive.client import AsyncDriveClient, DriveClient
from .general.client import AsyncGeneralClient, GeneralClient
from .raw_client import AsyncRawAgentsClient, RawAgentsClient
from .research.client import AsyncResearchClient, ResearchClient
from .sql.client import AsyncSqlClient, SqlClient

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class AgentsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawAgentsClient(client_wrapper=client_wrapper)
        self.drive = DriveClient(client_wrapper=client_wrapper)

        self.general = GeneralClient(client_wrapper=client_wrapper)

        self.research = ResearchClient(client_wrapper=client_wrapper)

        self.sql = SqlClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawAgentsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawAgentsClient
        """
        return self._raw_client

    def invoke_by_id(
        self,
        agent_id: str,
        *,
        config: typing.Dict[str, typing.Optional[typing.Any]],
        messages: typing.Sequence[typing.Dict[str, typing.Optional[typing.Any]]],
        request_options: typing.Optional[RequestOptions] = None,
    ) -> CustomAgentResponse:
        """
        Coming soon!

        Invoke a custom agent created in [spaces](https://resources.athenaintel.com/docs/agents/create-your-agent).

        Custom agents can be created and configured in spaces to perform specialized tasks.
        Refer to the specific agent's documentation for details on configuration options
        and expected responses.

        Parameters
        ----------
        agent_id : str
            The ID of the custom agent to invoke. Create custom agents in [spaces](https://resources.athenaintel.com/docs/agents/create-your-agent).

        config : typing.Dict[str, typing.Optional[typing.Any]]
            Configuration for the custom agent. See the agent's documentation for specific configuration options.

        messages : typing.Sequence[typing.Dict[str, typing.Optional[typing.Any]]]
            The messages to send to the custom agent

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CustomAgentResponse
            Successful Response

        Examples
        --------
        from athena import Athena

        client = Athena(
            api_key="YOUR_API_KEY",
        )
        client.agents.invoke_by_id(
            agent_id="agent_id",
            config={"key": "value"},
            messages=[{"key": "value"}],
        )
        """
        _response = self._raw_client.invoke_by_id(
            agent_id, config=config, messages=messages, request_options=request_options
        )
        return _response.data


class AsyncAgentsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawAgentsClient(client_wrapper=client_wrapper)
        self.drive = AsyncDriveClient(client_wrapper=client_wrapper)

        self.general = AsyncGeneralClient(client_wrapper=client_wrapper)

        self.research = AsyncResearchClient(client_wrapper=client_wrapper)

        self.sql = AsyncSqlClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawAgentsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawAgentsClient
        """
        return self._raw_client

    async def invoke_by_id(
        self,
        agent_id: str,
        *,
        config: typing.Dict[str, typing.Optional[typing.Any]],
        messages: typing.Sequence[typing.Dict[str, typing.Optional[typing.Any]]],
        request_options: typing.Optional[RequestOptions] = None,
    ) -> CustomAgentResponse:
        """
        Coming soon!

        Invoke a custom agent created in [spaces](https://resources.athenaintel.com/docs/agents/create-your-agent).

        Custom agents can be created and configured in spaces to perform specialized tasks.
        Refer to the specific agent's documentation for details on configuration options
        and expected responses.

        Parameters
        ----------
        agent_id : str
            The ID of the custom agent to invoke. Create custom agents in [spaces](https://resources.athenaintel.com/docs/agents/create-your-agent).

        config : typing.Dict[str, typing.Optional[typing.Any]]
            Configuration for the custom agent. See the agent's documentation for specific configuration options.

        messages : typing.Sequence[typing.Dict[str, typing.Optional[typing.Any]]]
            The messages to send to the custom agent

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CustomAgentResponse
            Successful Response

        Examples
        --------
        import asyncio

        from athena import AsyncAthena

        client = AsyncAthena(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.agents.invoke_by_id(
                agent_id="agent_id",
                config={"key": "value"},
                messages=[{"key": "value"}],
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.invoke_by_id(
            agent_id, config=config, messages=messages, request_options=request_options
        )
        return _response.data
