# This file was auto-generated by Fern from our API Definition.

import typing

from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.request_options import RequestOptions
from ...types.sql_agent_response import SqlAgentResponse
from .raw_client import AsyncRawSqlClient, RawSqlClient

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class SqlClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawSqlClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawSqlClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawSqlClient
        """
        return self._raw_client

    def invoke(
        self,
        *,
        config: typing.Dict[str, typing.Optional[typing.Any]],
        messages: typing.Sequence[typing.Dict[str, typing.Optional[typing.Any]]],
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SqlAgentResponse:
        """
        Coming soon! Generate, execute, and test SQL queries. Returns an asset ID for the query object.

        Parameters
        ----------
        config : typing.Dict[str, typing.Optional[typing.Any]]
            Configuration for the SQL agent including database connection details and query parameters

        messages : typing.Sequence[typing.Dict[str, typing.Optional[typing.Any]]]
            The messages to send to the SQL agent

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SqlAgentResponse
            Successful Response

        Examples
        --------
        from athena import Athena

        client = Athena(
            api_key="YOUR_API_KEY",
        )
        client.agents.sql.invoke(
            config={"key": "value"},
            messages=[{"key": "value"}],
        )
        """
        _response = self._raw_client.invoke(config=config, messages=messages, request_options=request_options)
        return _response.data


class AsyncSqlClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawSqlClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawSqlClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawSqlClient
        """
        return self._raw_client

    async def invoke(
        self,
        *,
        config: typing.Dict[str, typing.Optional[typing.Any]],
        messages: typing.Sequence[typing.Dict[str, typing.Optional[typing.Any]]],
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SqlAgentResponse:
        """
        Coming soon! Generate, execute, and test SQL queries. Returns an asset ID for the query object.

        Parameters
        ----------
        config : typing.Dict[str, typing.Optional[typing.Any]]
            Configuration for the SQL agent including database connection details and query parameters

        messages : typing.Sequence[typing.Dict[str, typing.Optional[typing.Any]]]
            The messages to send to the SQL agent

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SqlAgentResponse
            Successful Response

        Examples
        --------
        import asyncio

        from athena import AsyncAthena

        client = AsyncAthena(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.agents.sql.invoke(
                config={"key": "value"},
                messages=[{"key": "value"}],
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.invoke(config=config, messages=messages, request_options=request_options)
        return _response.data
