# This file was auto-generated by Fern from our API Definition.

import typing

from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.request_options import RequestOptions
from .raw_client import AsyncRawCalendarClient, RawCalendarClient


class CalendarClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawCalendarClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawCalendarClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawCalendarClient
        """
        return self._raw_client

    def list_events(self, *, request_options: typing.Optional[RequestOptions] = None) -> typing.Optional[typing.Any]:
        """
        Coming soon! List calendar events with optional filtering.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.Optional[typing.Any]
            Successful Response

        Examples
        --------
        from athena import Athena

        client = Athena(
            api_key="YOUR_API_KEY",
        )
        client.tools.calendar.list_events()
        """
        _response = self._raw_client.list_events(request_options=request_options)
        return _response.data

    def create_event(self, *, request_options: typing.Optional[RequestOptions] = None) -> typing.Optional[typing.Any]:
        """
        Coming soon! Create new calendar events.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.Optional[typing.Any]
            Successful Response

        Examples
        --------
        from athena import Athena

        client = Athena(
            api_key="YOUR_API_KEY",
        )
        client.tools.calendar.create_event()
        """
        _response = self._raw_client.create_event(request_options=request_options)
        return _response.data


class AsyncCalendarClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawCalendarClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawCalendarClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawCalendarClient
        """
        return self._raw_client

    async def list_events(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> typing.Optional[typing.Any]:
        """
        Coming soon! List calendar events with optional filtering.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.Optional[typing.Any]
            Successful Response

        Examples
        --------
        import asyncio

        from athena import AsyncAthena

        client = AsyncAthena(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.tools.calendar.list_events()


        asyncio.run(main())
        """
        _response = await self._raw_client.list_events(request_options=request_options)
        return _response.data

    async def create_event(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> typing.Optional[typing.Any]:
        """
        Coming soon! Create new calendar events.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.Optional[typing.Any]
            Successful Response

        Examples
        --------
        import asyncio

        from athena import AsyncAthena

        client = AsyncAthena(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.tools.calendar.create_event()


        asyncio.run(main())
        """
        _response = await self._raw_client.create_event(request_options=request_options)
        return _response.data
