# This file was auto-generated by Fern from our API Definition.

import typing

from .. import core
from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from ..types.asset_content_request_out import AssetContentRequestOut
from ..types.asset_screenshot_response_out import AssetScreenshotResponseOut
from ..types.data_frame_request_out import DataFrameRequestOut
from ..types.file_chunk_request_out import FileChunkRequestOut
from ..types.folder_response import FolderResponse
from ..types.save_asset_request_out import SaveAssetRequestOut
from .calendar.client import AsyncCalendarClient, CalendarClient
from .email.client import AsyncEmailClient, EmailClient
from .raw_client import AsyncRawToolsClient, RawToolsClient
from .structured_data_extractor.client import AsyncStructuredDataExtractorClient, StructuredDataExtractorClient
from .tasks.client import AsyncTasksClient, TasksClient
from .types.tools_data_frame_request_columns_item import ToolsDataFrameRequestColumnsItem

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class ToolsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawToolsClient(client_wrapper=client_wrapper)
        self.calendar = CalendarClient(client_wrapper=client_wrapper)

        self.email = EmailClient(client_wrapper=client_wrapper)

        self.structured_data_extractor = StructuredDataExtractorClient(client_wrapper=client_wrapper)

        self.tasks = TasksClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawToolsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawToolsClient
        """
        return self._raw_client

    def get_asset_chunks(
        self, *, asset_ids: typing.Sequence[str], request_options: typing.Optional[RequestOptions] = None
    ) -> FileChunkRequestOut:
        """
        Get the chunks of a file.

        Parameters
        ----------
        asset_ids : typing.Sequence[str]
            Identifiers of the assets

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        FileChunkRequestOut
            Successful Response

        Examples
        --------
        from athena import Athena

        client = Athena(
            api_key="YOUR_API_KEY",
        )
        client.tools.get_asset_chunks(
            asset_ids=[
                "asset_9249292-d118-42d3-96b4-00eccfe0754f",
                "asset_9249292-d118-42d3-95b4-01eccfe0754f",
            ],
        )
        """
        _response = self._raw_client.get_asset_chunks(asset_ids=asset_ids, request_options=request_options)
        return _response.data

    def get_asset_content(
        self, *, asset_id: str, request_options: typing.Optional[RequestOptions] = None
    ) -> AssetContentRequestOut:
        """
        Get the content of an asset.

        Parameters
        ----------
        asset_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AssetContentRequestOut
            Successful Response

        Examples
        --------
        from athena import Athena

        client = Athena(
            api_key="YOUR_API_KEY",
        )
        client.tools.get_asset_content(
            asset_id="asset_id",
        )
        """
        _response = self._raw_client.get_asset_content(asset_id=asset_id, request_options=request_options)
        return _response.data

    def get_asset_screenshot(
        self,
        *,
        asset_id: str,
        page_number: typing.Optional[int] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AssetScreenshotResponseOut:
        """
        Get a screenshot of a specific page from an asset.

        Parameters
        ----------
        asset_id : str

        page_number : typing.Optional[int]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AssetScreenshotResponseOut
            Successful Response

        Examples
        --------
        from athena import Athena

        client = Athena(
            api_key="YOUR_API_KEY",
        )
        client.tools.get_asset_screenshot(
            asset_id="asset_id",
        )
        """
        _response = self._raw_client.get_asset_screenshot(
            asset_id=asset_id, page_number=page_number, request_options=request_options
        )
        return _response.data

    def list_contents(
        self,
        *,
        asset_id: typing.Optional[str] = None,
        folder_id: typing.Optional[str] = None,
        include_asset_details: typing.Optional[bool] = None,
        include_system_files: typing.Optional[bool] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> FolderResponse:
        """
        List contents of an asset (Folder, Collection, Project) or entire workspace in a tree structure.

        Parameters
        ----------
        asset_id : typing.Optional[str]

        folder_id : typing.Optional[str]

        include_asset_details : typing.Optional[bool]

        include_system_files : typing.Optional[bool]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        FolderResponse
            Successful Response

        Examples
        --------
        from athena import Athena

        client = Athena(
            api_key="YOUR_API_KEY",
        )
        client.tools.list_contents()
        """
        _response = self._raw_client.list_contents(
            asset_id=asset_id,
            folder_id=folder_id,
            include_asset_details=include_asset_details,
            include_system_files=include_system_files,
            request_options=request_options,
        )
        return _response.data

    def data_frame(
        self,
        *,
        asset_id: str,
        row_limit: typing.Optional[int] = None,
        index_column: typing.Optional[int] = None,
        columns: typing.Optional[
            typing.Union[ToolsDataFrameRequestColumnsItem, typing.Sequence[ToolsDataFrameRequestColumnsItem]]
        ] = None,
        sheet_name: typing.Optional[str] = None,
        separator: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> DataFrameRequestOut:
        """
        Parameters
        ----------
        asset_id : str

        row_limit : typing.Optional[int]

        index_column : typing.Optional[int]

        columns : typing.Optional[typing.Union[ToolsDataFrameRequestColumnsItem, typing.Sequence[ToolsDataFrameRequestColumnsItem]]]
            should be a list of strings or a list of integers

        sheet_name : typing.Optional[str]
            only for excel files

        separator : typing.Optional[str]
            only for csv files

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        DataFrameRequestOut
            Successful Response

        Examples
        --------
        from athena import Athena

        client = Athena(
            api_key="YOUR_API_KEY",
        )
        client.tools.data_frame(
            asset_id="asset_id",
        )
        """
        _response = self._raw_client.data_frame(
            asset_id=asset_id,
            row_limit=row_limit,
            index_column=index_column,
            columns=columns,
            sheet_name=sheet_name,
            separator=separator,
            request_options=request_options,
        )
        return _response.data

    def raw_data(
        self, *, asset_id: str, request_options: typing.Optional[RequestOptions] = None
    ) -> typing.Iterator[bytes]:
        """
        Get the raw file data for given asset.

        Parameters
        ----------
        asset_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration. You can pass in configuration such as `chunk_size`, and more to customize the request and response.

        Returns
        -------
        typing.Iterator[bytes]
            Stream the file in original format.
        """
        with self._raw_client.raw_data(asset_id=asset_id, request_options=request_options) as r:
            yield from r.data

    def save_asset(
        self,
        *,
        file: core.File,
        parent_folder_id: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SaveAssetRequestOut:
        """
        Parameters
        ----------
        file : core.File
            See core.File for more documentation

        parent_folder_id : typing.Optional[str]
            Identifier of the folder into which the asset should be saved

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SaveAssetRequestOut
            Successful Response

        Examples
        --------
        from athena import Athena

        client = Athena(
            api_key="YOUR_API_KEY",
        )
        client.tools.save_asset()
        """
        _response = self._raw_client.save_asset(
            file=file, parent_folder_id=parent_folder_id, request_options=request_options
        )
        return _response.data


class AsyncToolsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawToolsClient(client_wrapper=client_wrapper)
        self.calendar = AsyncCalendarClient(client_wrapper=client_wrapper)

        self.email = AsyncEmailClient(client_wrapper=client_wrapper)

        self.structured_data_extractor = AsyncStructuredDataExtractorClient(client_wrapper=client_wrapper)

        self.tasks = AsyncTasksClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawToolsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawToolsClient
        """
        return self._raw_client

    async def get_asset_chunks(
        self, *, asset_ids: typing.Sequence[str], request_options: typing.Optional[RequestOptions] = None
    ) -> FileChunkRequestOut:
        """
        Get the chunks of a file.

        Parameters
        ----------
        asset_ids : typing.Sequence[str]
            Identifiers of the assets

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        FileChunkRequestOut
            Successful Response

        Examples
        --------
        import asyncio

        from athena import AsyncAthena

        client = AsyncAthena(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.tools.get_asset_chunks(
                asset_ids=[
                    "asset_9249292-d118-42d3-96b4-00eccfe0754f",
                    "asset_9249292-d118-42d3-95b4-01eccfe0754f",
                ],
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get_asset_chunks(asset_ids=asset_ids, request_options=request_options)
        return _response.data

    async def get_asset_content(
        self, *, asset_id: str, request_options: typing.Optional[RequestOptions] = None
    ) -> AssetContentRequestOut:
        """
        Get the content of an asset.

        Parameters
        ----------
        asset_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AssetContentRequestOut
            Successful Response

        Examples
        --------
        import asyncio

        from athena import AsyncAthena

        client = AsyncAthena(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.tools.get_asset_content(
                asset_id="asset_id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get_asset_content(asset_id=asset_id, request_options=request_options)
        return _response.data

    async def get_asset_screenshot(
        self,
        *,
        asset_id: str,
        page_number: typing.Optional[int] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AssetScreenshotResponseOut:
        """
        Get a screenshot of a specific page from an asset.

        Parameters
        ----------
        asset_id : str

        page_number : typing.Optional[int]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AssetScreenshotResponseOut
            Successful Response

        Examples
        --------
        import asyncio

        from athena import AsyncAthena

        client = AsyncAthena(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.tools.get_asset_screenshot(
                asset_id="asset_id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get_asset_screenshot(
            asset_id=asset_id, page_number=page_number, request_options=request_options
        )
        return _response.data

    async def list_contents(
        self,
        *,
        asset_id: typing.Optional[str] = None,
        folder_id: typing.Optional[str] = None,
        include_asset_details: typing.Optional[bool] = None,
        include_system_files: typing.Optional[bool] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> FolderResponse:
        """
        List contents of an asset (Folder, Collection, Project) or entire workspace in a tree structure.

        Parameters
        ----------
        asset_id : typing.Optional[str]

        folder_id : typing.Optional[str]

        include_asset_details : typing.Optional[bool]

        include_system_files : typing.Optional[bool]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        FolderResponse
            Successful Response

        Examples
        --------
        import asyncio

        from athena import AsyncAthena

        client = AsyncAthena(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.tools.list_contents()


        asyncio.run(main())
        """
        _response = await self._raw_client.list_contents(
            asset_id=asset_id,
            folder_id=folder_id,
            include_asset_details=include_asset_details,
            include_system_files=include_system_files,
            request_options=request_options,
        )
        return _response.data

    async def data_frame(
        self,
        *,
        asset_id: str,
        row_limit: typing.Optional[int] = None,
        index_column: typing.Optional[int] = None,
        columns: typing.Optional[
            typing.Union[ToolsDataFrameRequestColumnsItem, typing.Sequence[ToolsDataFrameRequestColumnsItem]]
        ] = None,
        sheet_name: typing.Optional[str] = None,
        separator: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> DataFrameRequestOut:
        """
        Parameters
        ----------
        asset_id : str

        row_limit : typing.Optional[int]

        index_column : typing.Optional[int]

        columns : typing.Optional[typing.Union[ToolsDataFrameRequestColumnsItem, typing.Sequence[ToolsDataFrameRequestColumnsItem]]]
            should be a list of strings or a list of integers

        sheet_name : typing.Optional[str]
            only for excel files

        separator : typing.Optional[str]
            only for csv files

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        DataFrameRequestOut
            Successful Response

        Examples
        --------
        import asyncio

        from athena import AsyncAthena

        client = AsyncAthena(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.tools.data_frame(
                asset_id="asset_id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.data_frame(
            asset_id=asset_id,
            row_limit=row_limit,
            index_column=index_column,
            columns=columns,
            sheet_name=sheet_name,
            separator=separator,
            request_options=request_options,
        )
        return _response.data

    async def raw_data(
        self, *, asset_id: str, request_options: typing.Optional[RequestOptions] = None
    ) -> typing.AsyncIterator[bytes]:
        """
        Get the raw file data for given asset.

        Parameters
        ----------
        asset_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration. You can pass in configuration such as `chunk_size`, and more to customize the request and response.

        Returns
        -------
        typing.AsyncIterator[bytes]
            Stream the file in original format.
        """
        async with self._raw_client.raw_data(asset_id=asset_id, request_options=request_options) as r:
            async for _chunk in r.data:
                yield _chunk

    async def save_asset(
        self,
        *,
        file: core.File,
        parent_folder_id: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SaveAssetRequestOut:
        """
        Parameters
        ----------
        file : core.File
            See core.File for more documentation

        parent_folder_id : typing.Optional[str]
            Identifier of the folder into which the asset should be saved

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SaveAssetRequestOut
            Successful Response

        Examples
        --------
        import asyncio

        from athena import AsyncAthena

        client = AsyncAthena(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.tools.save_asset()


        asyncio.run(main())
        """
        _response = await self._raw_client.save_asset(
            file=file, parent_folder_id=parent_folder_id, request_options=request_options
        )
        return _response.data
