#!/usr/bin/env python
# -*- coding: utf-8 -*-

from pymisp import PyMISP, MISPEvent
from keys import misp_url, misp_key, misp_verifycert
import argparse


if __name__ == '__main__':
    parser = argparse.ArgumentParser(description="Update a MISP event.")
    parser.add_argument("-e", "--event", required=True, help="Event ID to update.")
    parser.add_argument("-i", "--input", required=True, help="Input file")

    args = parser.parse_args()

    misp = PyMISP(misp_url, misp_key, misp_verifycert)

    me = MISPEvent()
    me.load_file(args.input)

    result = misp.update_event(me, args.event)
