# BibleMate AI

BibleMate AI is a groundbreaking, autonomous AI agent designed to revolutionize your Bible study. It can create study plans, coordinate multiple Bible tools, and take multi-step actions to complete complex Bible-related tasks, such as conducting an in-depth study of a particular Bible passage.

## Core Features

*   **Autonomous AI Agent:** BibleMate AI can work independently to fulfill your bible study requests.
*   **Multi-step Task Execution:** It can break down complex tasks into smaller, manageable steps and execute them sequentially.
*   **Rich Toolset:** Comes with over 40 built-in bible tools, powered by our comprehensive bible suite, the [UniqueBible App](https://github.com/eliranwong/UniqueBible).
*   **Customizable and Extensible:** Advanced users can customize existing tools or add new ones to suit their specific needs.

## Built-in Tools

To see the full list of built-in tools and their descriptions, please see the [TOOLS.md](TOOLS.md) file.

## Demo

See BibleMate AI in action in our YouTube video: [BibleMate AI Demo](https://youtu.be/QvPIyHOhrP0)

## Our Other AI Projects

BibleMate AI was developed from our agent development kit (ADK), [AgentMake AI](https://github.com/eliranwong/agentmake), and was a side-project we explored while developing [BibleMate AI](https://github.com/eliranwong/BibleMate). Its success as a bible study tool prompted us to develop it further as a standalone project.

## BibleMate AI Agentic Workflow

1.  **BibleMate AI** receives a request from a user.
2.  **BibleMate AI** analyzes the request and determines that it requires multiple steps to complete.
3.  **BibleMate AI** generates a `Master Plan` that outlines the steps needed to complete the request.
4.  **BibleMate AI** sends the `Master Plan` to a supervisor agent, who reviews the prompt and provides suggestions for improvement.
5.  **BibleMate AI** sends the suggestions to a bible tool selection agent, who selects the most appropriate bible tools for each step of the `Master Plan`.
6.  **BibleMate AI** sends the selected bible tools and the `Master Plan` to an instruction generation agent, who converts the suggestions into clear and concise instructions for an AI assistant to follow.
7.  **BibleMate AI** sends the instructions to an AI assistant, who executes the instructions using the selected bible tools.
8.  **BibleMate AI** monitors the progress of the AI assistant and provides additional suggestions or instructions as needed.
9.  Once all steps are completed, **BibleMate AI** provides a concise summary of the results to the user.
10. The user receives the final response, which fully resolves their original request.

## Getting Started

> pip install --upgrade biblemate

> biblemate

## Configure AI Backend

After BibleMate AI is launched, enter:

> .backend

A text editor is opened for you to edit the AgentMake AI settings. Change the `DEFAULT_AI_BACKEND` to your own choice of AI backend and enter API keys where appropriate.

## AI Modes

You can swap between two AI modes:

Chat mode – Provide users with direct text responses without using tools. This is useful when users have simple queries and need straightforward answers.

Agent mode - Fully autonomous agent designed to plan, orchestrate tools, and take multiple actions to address user requests.

How to swap?

* Enter `.chat` in BibleMate AI prompt to enable chat mode and disable agent mode.
* Enter `.agent` in BibleMate AI prompt to enable agent mode and disable chat mode.

## Manual Tool Selection

In some cases, you may want to specify a particular tool for a simple task, rather than having a tool automatically selected in the fully automatic `agent mode`.

You can specify a single tool by prefixing a tool name with `@` at the beginning of your prompt. For example,

```
@retrieve_bible_cross_references Deut 6:4; John 3:16
```

Watch this video: https://youtu.be/50m1KRj6uhs

## Custom Master Plan with Multiple Tools

In some cases, you may want to specify a `custom plan` with multiple tools specified for different steps for a complex task, rather than having a `master plan` automatically generated in fully automatic agent mode.

You can use a custom 'Master Plan' of your own, instead of one generated by BibleMate AI. To do this, start your BibleMate AI prompt with '@@' followed by your own master plan for a Bible study. For example,

```
@@ Analyze John 3:16 with the following steps: 
1. Call tool 'retrieve_english_bible_verses' for Bible text, 
2. Call tool 'retrieve_bible_cross_references' for Bible cross-references, 
3. Call tool 'interpret_new_testament_verse' for interpretation, and 
4. Call tool 'write_bible_theology' to explain its theology.
```

Watch this video: https://youtu.be/Lejq0sAx030

The '@@' trick works even when you are using 'chat' mode with 'agent' mode disabled.

## Action Menu

There is a set of predefined entries, that starts with a dot sign `.`:

- `.new` - new conversation
- `.quit` - quit
- `.backend` - change backend
- `.chat` - enable chat mode
- `.agent` - enable agent mode
- `.tools` - list available tools
- `.backup` - backup conversation
- `.open` - open a file or directory, e.g. `.open /home/user/report.html`

## Keyboard Shortcuts

The following key bindings are supported in BibleMate AI prompt field:

- `Ctrl+N` new conversation
- `Ctrl+Q` quit
- `Ctrl+C` copy selected prompt text
- `Ctrl+V` paste text in a prompt
- `Ctrl+I` or `TAB` new line
- `Ctrl+Z` clear prompt text
- `Esc+a` jump to the beginning of a prompt
- `Esc+z` jump to the end of a prompt
- `Esc+b` or `HOME` jump to the beginning of a line in a prompt
- `Esc+e` or `END` jump to the end of a line in a prompt

## License

This project is licensed under the Creative Commons Attribution-NonCommercial 4.0 International License - see the [LICENSE](LICENSE) file for details.

## Acknowledgments

BibleMate AI is built upon the foundations of our other projects:
*   [UniqueBible App](https.github.com/eliranwong/UniqueBible)
*   [XoMate AI](https.github.com/eliranwong/xomate)
*   [AgentMake AI](https.github.com/eliranwong/agentmake)
*   [AgentMake AI MCP](https.github.com/eliranwong/agentmakemcp)