from metripy.Application.Config.ReportConfig import ReportConfig
from metripy.Component.Output.CliOutput import CliOutput
from metripy.Report import ReporterInterface
from metripy.Report.Html.Reporter import Reporter as HtmlReporter
from metripy.Report.Json.GitJsonReporter import GitJsonReporter


class ReporterFactory:
    @staticmethod
    def create(config: ReportConfig, output: CliOutput) -> ReporterInterface:
        if config.type == "html":
            return HtmlReporter(config, output)
        elif config.type == "json":
            raise NotImplementedError
        elif config.type == "csv":
            raise NotImplementedError
        elif config.type == "cli":
            raise NotImplementedError
        elif config.type == "json-git":
            return GitJsonReporter(config, output)
        else:
            raise ValueError(f"Unsupported report type: {config.type}")
