"""Update ConsentStatus enum

Revision ID: 67d0e389b003
Revises: f36ce1bde293
Create Date: 2025-09-02 19:32:05.025508

"""

import sqlalchemy as sa
from alembic import op

# revision identifiers, used by Alembic.
revision = "67d0e389b003"
down_revision = "f36ce1bde293"
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.execute("ALTER TYPE consentstatus ADD VALUE 'pre_consent'")
    op.execute("ALTER TYPE consentstatus ADD VALUE 'cmp_error'")
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    # Remove any records that have the new enum values before dropping them
    op.execute(
        "UPDATE asset SET consent_status = 'unknown' WHERE consent_status IN ('pre_consent', 'cmp_error')"
    )

    # Recreate the enum without the new values
    op.execute("ALTER TYPE consentstatus RENAME TO consentstatus_old")
    op.execute(
        "CREATE TYPE consentstatus AS ENUM ('with_consent', 'without_consent', 'exempt', 'unknown')"
    )

    # Drop default, change type, and set default back
    op.execute("ALTER TABLE asset ALTER COLUMN consent_status DROP DEFAULT")
    op.execute(
        "ALTER TABLE asset ALTER COLUMN consent_status TYPE consentstatus USING "
        "consent_status::text::consentstatus"
    )
    op.execute("ALTER TABLE asset ALTER COLUMN consent_status SET DEFAULT 'unknown'")
    op.execute("DROP TYPE consentstatus_old")
    # ### end Alembic commands ###
