"""add privacy request duplication cols

Revision ID: c09e76282dd1
Revises: 67f0f2f4748e
Create Date: 2025-10-21 21:46:38.006328

"""

import sqlalchemy as sa
from alembic import op

# revision identifiers, used by Alembic.
revision = "c09e76282dd1"
down_revision = "67f0f2f4748e"
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    # Add duplicate group tracking column
    op.add_column(
        "privacyrequest",
        sa.Column("duplicate_request_group_id", sa.String(), nullable=True),
    )
    op.create_index(
        op.f("ix_privacyrequest_duplicate_request_group_id"),
        "privacyrequest",
        ["duplicate_request_group_id"],
        unique=False,
    )

    # Add 'duplicate' status to enum
    op.execute("alter type privacyrequeststatus add value 'duplicate'")
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    # Drop group tracking column and index
    op.drop_index(
        op.f("ix_privacyrequest_duplicate_request_group_id"),
        table_name="privacyrequest",
    )
    op.drop_column("privacyrequest", "duplicate_request_group_id")

    # Remove 'duplicate' status from enum
    # First delete any requests with duplicate status
    op.execute("UPDATE privacyrequest SET status = 'error' WHERE status = 'duplicate'")

    # Recreate enum without 'duplicate'
    op.execute("alter type privacyrequeststatus rename to privacyrequeststatus_old")
    op.execute(
        "create type privacyrequeststatus as enum("
        "'identity_unverified', 'requires_input', 'pending', 'approved', 'denied', "
        "'in_processing', 'complete', 'paused', 'awaiting_email_send', "
        "'requires_manual_finalization', 'canceled', 'error')"
    )
    op.execute(
        "alter table privacyrequest alter column status type privacyrequeststatus "
        "using status::text::privacyrequeststatus"
    )
    op.execute("drop type privacyrequeststatus_old")
    # ### end Alembic commands ###
