"""Store SaaS Template Datasets

Revision ID: 7d82c8fc4c34
Revises: a1b2c3d4e5f6
Create Date: 2025-11-11 13:17:36.602477

"""

import sqlalchemy as sa
from alembic import op
from sqlalchemy.dialects import postgresql

# revision identifiers, used by Alembic.
revision = "7d82c8fc4c34"
down_revision = "a1b2c3d4e5f6"
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "saas_template_dataset",
        sa.Column("id", sa.String(length=255), nullable=False),
        sa.Column(
            "created_at",
            sa.DateTime(timezone=True),
            server_default=sa.text("now()"),
            nullable=True,
        ),
        sa.Column(
            "updated_at",
            sa.DateTime(timezone=True),
            server_default=sa.text("now()"),
            nullable=True,
        ),
        sa.Column("connection_type", sa.String(), nullable=False),
        sa.Column(
            "dataset_json", postgresql.JSONB(astext_type=sa.Text()), nullable=False
        ),
        sa.PrimaryKeyConstraint("id"),
    )
    op.create_index(
        op.f("ix_saas_template_dataset_connection_type"),
        "saas_template_dataset",
        ["connection_type"],
        unique=True,
    )
    op.create_index(
        op.f("ix_saas_template_dataset_id"),
        "saas_template_dataset",
        ["id"],
        unique=False,
    )
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_index(
        op.f("ix_saas_template_dataset_id"), table_name="saas_template_dataset"
    )
    op.drop_index(
        op.f("ix_saas_template_dataset_connection_type"),
        table_name="saas_template_dataset",
    )
    op.drop_table("saas_template_dataset")
    # ### end Alembic commands ###
