# DiffCraft
> Craft the perfect git commit, instantly.

[![PyPI version](https://badge.fury.io/py/diffcraft.svg)](https://badge.fury.io/py/diffcraft)
[![License: MIT](https://img.shields.io/badge/License-MIT-blue.svg)](https://opensource.org/licenses/MIT)
[![GitHub Repo](https://img.shields.io/badge/GitHub-Repo-purple?logo=github)](https://github.com/bvrvl/diffcraft)

DiffCraft is a smart command-line tool that uses Google's Gemini to instantly generate high-quality, conventional commit messages from your staged code changes.

Install:
```bash
pip install diffcraft
```

## Features:

*   🤖 **AI-Powered Commits:** Analyzes your `git diff` to create meaningful and descriptive commit messages that truly reflect your changes.
*   ✅ **Enforce Best Practices:** Automatically follows the [Conventional Commits](https://www.conventionalcommits.org/) standard, improving your project's readability and making it easier to automate releases.
*   ⚙️ **You're Always in Control:** Interactively **[A]ccept** the suggestion, **[E]dit** it in your own editor, **[R]egenerate** a new one, or **[Q]uit**.
*   🌍 **Flexible & Powerful:** Generate commits in different languages (`--lang`), provide context from your commit history (`--history`), and force specific types (`--type`).

## Installation

DiffCraft is available on PyPI and can be installed with a single pip command.

```bash
pip install diffcraft
```
## Setup & Configuration

To use DiffCraft, you need a Google Gemini API key.

### Method 1: .env File (Recommended)

This method is easy and keeps your API key specific to your project.

1. Get your free API key from [Google AI Studio](https://aistudio.google.com/app/apikey).

2. In the root directory of your git project, create a new file named .env.

3. Add the following line to the .env file, pasting your own key:
```code
GEMINI_API_KEY="YOUR_API_KEY_HERE"
```
🔒 Important Security Note
Remember to add the .env file to your project's .gitignore to ensure your secret API key is never committed to your repository! If your .gitignore doesn't have it, add this line:
```code
.env
```

### Method 2: Environment Variable (Advanced)

This method is ideal for servers, CI/CD pipelines, Docker containers, or any user who prefers to manage API keys globally.
DiffCraft will always prioritize a system-wide environment variable over a local .env file.
Open your terminal and use the appropriate command for your operating system.

**macOS / Linux**
```Bash
export GEMINI_API_KEY="YOUR_API_KEY_HERE"
```
*To make this permanent, add the command to your ~/.zshrc or ~/.bashrc file.*

**Windows (PowerShell)**
```Powershell
$env:GEMINI_API_KEY="YOUR_API_KEY_HERE"
```
**Windows (CMD)**
```Cmd
set GEMINI_API_KEY="YOUR_API_KEY_HERE"
```
*For permanent setup on Windows, search for "Edit the system environment variables" in the Start Menu. You will need to close and reopen your terminal for the changes to take effect.*

## Usage
The workflow is designed to be seamless.

1. Stage your files as you normally would:
```Bash
git add README.md
git add .
git add src/
```
2. Run the craft command:
```Bash
craft
```
This will generate a commit message and present you with the interactive prompt.

Or,
```Bash
craft README.md
craft .
craft src/
```
This will both stage the files and generate a commit message.
### Command-Line Options
For a full list of commands and detailed explanations, use the `--help` flag:
```Bash
craft --help
```
**Example: Generate a 'fix' commit and edit it immediately**
```Bash
craft --type fix --edit
```
**Example: Generate a commit in Spanish using the last 3 commits for context**
```Bash
craft --lang Spanish --history 3
```

## Contributing
Found a bug or have a feature request? We'd love your help! Please open an issue or submit a pull request on our [GitHub Repository](https://github.com/bvrvl/diffcraft)

## License
This project is licensed under the MIT License. See the LICENSE file for details.