"""create Activities Segments table

Revision ID: dd73d23a7a3d
Revises: caf0e0dc621a
Create Date: 2018-05-14 12:12:57.299200

"""
from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision = 'dd73d23a7a3d'
down_revision = 'caf0e0dc621a'
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('activity_segments',
    sa.Column('activity_id', sa.Integer(), nullable=False),
    sa.Column('segment_id', sa.Integer(), nullable=False),
    sa.Column('duration', sa.Interval(), nullable=False),
    sa.Column('pauses', sa.Interval(), nullable=True),
    sa.Column('moving', sa.Interval(), nullable=True),
    sa.Column('distance', sa.Numeric(precision=6, scale=3), nullable=True),
    sa.Column('min_alt', sa.Numeric(precision=6, scale=2), nullable=True),
    sa.Column('max_alt', sa.Numeric(precision=6, scale=2), nullable=True),
    sa.Column('descent', sa.Numeric(precision=7, scale=2), nullable=True),
    sa.Column('ascent', sa.Numeric(precision=7, scale=2), nullable=True),
    sa.Column('max_speed', sa.Numeric(precision=6, scale=2), nullable=True),
    sa.Column('ave_speed', sa.Numeric(precision=6, scale=2), nullable=True),
    sa.ForeignKeyConstraint(['activity_id'], ['activities.id'], ),
    sa.PrimaryKeyConstraint('activity_id', 'segment_id')
    )
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_table('activity_segments')
    # ### end Alembic commands ###
