"""add missing indexes on Workout table

Revision ID: e30007d681cb
Revises: ed409fd9db9d
Create Date: 2022-02-05 11:52:23.847975

"""
from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision = 'e30007d681cb'
down_revision = 'ed409fd9db9d'
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_index(op.f('ix_workouts_map_id'), 'workouts', ['map_id'], unique=False)
    op.create_index(op.f('ix_workouts_sport_id'), 'workouts', ['sport_id'], unique=False)
    op.create_index(op.f('ix_workouts_user_id'), 'workouts', ['user_id'], unique=False)
    op.create_index(op.f('ix_workouts_workout_date'), 'workouts', ['workout_date'], unique=False)
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_index(op.f('ix_workouts_workout_date'), table_name='workouts')
    op.drop_index(op.f('ix_workouts_user_id'), table_name='workouts')
    op.drop_index(op.f('ix_workouts_sport_id'), table_name='workouts')
    op.drop_index(op.f('ix_workouts_map_id'), table_name='workouts')
    # ### end Alembic commands ###
