# mypy: ignore-errors
# flake8: noqa

# This file is autogenerated by /metadata-ingestion/scripts/avro_codegen.py
# Do not modify manually!

# pylint: skip-file
# fmt: off
# isort: skip_file

# The SchemaFromJSONData method only exists in avro-python3, but is called make_avsc_object in avro.
# We can use this fact to detect conflicts between the two packages. Pip won't detect those conflicts
# because both are namespace packages, and hence are allowed to overwrite files from each other.
# This means that installation order matters, which is a pretty unintuitive outcome.
# See https://github.com/pypa/pip/issues/4625 for details.
try:
    from avro.schema import SchemaFromJSONData  # type: ignore
    import warnings

    warnings.warn("It seems like 'avro-python3' is installed, which conflicts with the 'avro' package used by datahub. "
                + "Try running `pip uninstall avro-python3 && pip install --upgrade --force-reinstall avro` to fix this issue.")
except ImportError:
    pass

import json
import os.path
import decimal
import datetime
import six
from avrogen.dict_wrapper import DictWrapper
from avrogen import avrojson
from avro.schema import RecordSchema, make_avsc_object
from avro import schema as avro_schema
from typing import ClassVar, List, Dict, Union, Optional, Type


def __read_file(file_name):
    with open(file_name, "r") as f:
        return f.read()
        

def __get_names_and_schema(json_str):
    names = avro_schema.Names()
    schema = make_avsc_object(json.loads(json_str), names)
    return names, schema


_SCHEMA_JSON_STR = __read_file(os.path.join(os.path.dirname(__file__), "schema.avsc"))


__NAMES, _SCHEMA = __get_names_and_schema(_SCHEMA_JSON_STR)
__SCHEMAS: Dict[str, RecordSchema] = {}

from datahub._codegen.aspect import _Aspect



def get_schema_type(fullname: str) -> RecordSchema:
    return __SCHEMAS[fullname]
    
    
__SCHEMAS = dict((n.fullname.lstrip("."), n) for n in six.itervalues(__NAMES.names))

class KafkaAuditHeaderClass(DictWrapper):
    """This header records information about the context of an event as it is emitted into kafka and is intended to be used by the kafka audit application.  For more information see go/kafkaauditheader"""
    
    RECORD_SCHEMA = get_schema_type("com.linkedin.events.KafkaAuditHeader")
    def __init__(self,
        time: int,
        server: str,
        appName: str,
        messageId: bytes,
        instance: Union[None, str]=None,
        auditVersion: Union[None, int]=None,
        fabricUrn: Union[None, str]=None,
        clusterConnectionString: Union[None, str]=None,
    ):
        super().__init__()
        
        self.time = time
        self.server = server
        self.instance = instance
        self.appName = appName
        self.messageId = messageId
        self.auditVersion = auditVersion
        self.fabricUrn = fabricUrn
        self.clusterConnectionString = clusterConnectionString
    
    def _restore_defaults(self) -> None:
        self.time = int()
        self.server = str()
        self.instance = self.RECORD_SCHEMA.fields_dict["instance"].default
        self.appName = str()
        self.messageId = bytes()
        self.auditVersion = self.RECORD_SCHEMA.fields_dict["auditVersion"].default
        self.fabricUrn = self.RECORD_SCHEMA.fields_dict["fabricUrn"].default
        self.clusterConnectionString = self.RECORD_SCHEMA.fields_dict["clusterConnectionString"].default
    
    
    @property
    def time(self) -> int:
        """The time at which the event was emitted into kafka."""
        return self._inner_dict.get('time')  # type: ignore
    
    @time.setter
    def time(self, value: int) -> None:
        self._inner_dict['time'] = value
    
    
    @property
    def server(self) -> str:
        """The fully qualified name of the host from which the event is being emitted."""
        return self._inner_dict.get('server')  # type: ignore
    
    @server.setter
    def server(self, value: str) -> None:
        self._inner_dict['server'] = value
    
    
    @property
    def instance(self) -> Union[None, str]:
        """The instance on the server from which the event is being emitted. e.g. i001"""
        return self._inner_dict.get('instance')  # type: ignore
    
    @instance.setter
    def instance(self, value: Union[None, str]) -> None:
        self._inner_dict['instance'] = value
    
    
    @property
    def appName(self) -> str:
        """The name of the application from which the event is being emitted. see go/appname"""
        return self._inner_dict.get('appName')  # type: ignore
    
    @appName.setter
    def appName(self, value: str) -> None:
        self._inner_dict['appName'] = value
    
    
    @property
    def messageId(self) -> bytes:
        """A unique identifier for the message"""
        return self._inner_dict.get('messageId')  # type: ignore
    
    @messageId.setter
    def messageId(self, value: bytes) -> None:
        self._inner_dict['messageId'] = value
    
    
    @property
    def auditVersion(self) -> Union[None, int]:
        """The version that is being used for auditing. In version 0, the audit trail buckets events into 10 minute audit windows based on the EventHeader timestamp. In version 1, the audit trail buckets events as follows: if the schema has an outer KafkaAuditHeader, use the outer audit header timestamp for bucketing; else if the EventHeader has an inner KafkaAuditHeader use that inner audit header's timestamp for bucketing"""
        return self._inner_dict.get('auditVersion')  # type: ignore
    
    @auditVersion.setter
    def auditVersion(self, value: Union[None, int]) -> None:
        self._inner_dict['auditVersion'] = value
    
    
    @property
    def fabricUrn(self) -> Union[None, str]:
        """The fabricUrn of the host from which the event is being emitted. Fabric Urn in the format of urn:li:fabric:{fabric_name}. See go/fabric."""
        return self._inner_dict.get('fabricUrn')  # type: ignore
    
    @fabricUrn.setter
    def fabricUrn(self, value: Union[None, str]) -> None:
        self._inner_dict['fabricUrn'] = value
    
    
    @property
    def clusterConnectionString(self) -> Union[None, str]:
        """This is a String that the client uses to establish some kind of connection with the Kafka cluster. The exact format of it depends on specific versions of clients and brokers. This information could potentially identify the fabric and cluster with which the client is producing to or consuming from."""
        return self._inner_dict.get('clusterConnectionString')  # type: ignore
    
    @clusterConnectionString.setter
    def clusterConnectionString(self, value: Union[None, str]) -> None:
        self._inner_dict['clusterConnectionString'] = value
    
    
class DataHubAccessTokenInfoClass(_Aspect):
    """Information about a DataHub Access Token"""


    ASPECT_NAME = 'dataHubAccessTokenInfo'
    ASPECT_INFO = {}
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.access.token.DataHubAccessTokenInfo")

    def __init__(self,
        name: str,
        actorUrn: str,
        ownerUrn: str,
        createdAt: int,
        expiresAt: Union[None, int]=None,
        description: Union[None, str]=None,
    ):
        super().__init__()
        
        self.name = name
        self.actorUrn = actorUrn
        self.ownerUrn = ownerUrn
        self.createdAt = createdAt
        self.expiresAt = expiresAt
        self.description = description
    
    def _restore_defaults(self) -> None:
        self.name = str()
        self.actorUrn = str()
        self.ownerUrn = str()
        self.createdAt = int()
        self.expiresAt = self.RECORD_SCHEMA.fields_dict["expiresAt"].default
        self.description = self.RECORD_SCHEMA.fields_dict["description"].default
    
    
    @property
    def name(self) -> str:
        """User defined name for the access token if defined."""
        return self._inner_dict.get('name')  # type: ignore
    
    @name.setter
    def name(self, value: str) -> None:
        self._inner_dict['name'] = value
    
    
    @property
    def actorUrn(self) -> str:
        """Urn of the actor to which this access token belongs to."""
        return self._inner_dict.get('actorUrn')  # type: ignore
    
    @actorUrn.setter
    def actorUrn(self, value: str) -> None:
        self._inner_dict['actorUrn'] = value
    
    
    @property
    def ownerUrn(self) -> str:
        """Urn of the actor which created this access token."""
        return self._inner_dict.get('ownerUrn')  # type: ignore
    
    @ownerUrn.setter
    def ownerUrn(self, value: str) -> None:
        self._inner_dict['ownerUrn'] = value
    
    
    @property
    def createdAt(self) -> int:
        """When the token was created."""
        return self._inner_dict.get('createdAt')  # type: ignore
    
    @createdAt.setter
    def createdAt(self, value: int) -> None:
        self._inner_dict['createdAt'] = value
    
    
    @property
    def expiresAt(self) -> Union[None, int]:
        """When the token expires."""
        return self._inner_dict.get('expiresAt')  # type: ignore
    
    @expiresAt.setter
    def expiresAt(self, value: Union[None, int]) -> None:
        self._inner_dict['expiresAt'] = value
    
    
    @property
    def description(self) -> Union[None, str]:
        """Description of the token if defined."""
        return self._inner_dict.get('description')  # type: ignore
    
    @description.setter
    def description(self, value: Union[None, str]) -> None:
        self._inner_dict['description'] = value
    
    
class AssertionActionClass(DictWrapper):
    """The Actions about an Assertion.
    In the future, we'll likely extend this model to support additional
    parameters or options related to the assertion actions."""
    
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.assertion.AssertionAction")
    def __init__(self,
        type: Union[str, "AssertionActionTypeClass"],
    ):
        super().__init__()
        
        self.type = type
    
    def _restore_defaults(self) -> None:
        self.type = AssertionActionTypeClass.RAISE_INCIDENT
    
    
    @property
    def type(self) -> Union[str, "AssertionActionTypeClass"]:
        """The type of the Action"""
        return self._inner_dict.get('type')  # type: ignore
    
    @type.setter
    def type(self, value: Union[str, "AssertionActionTypeClass"]) -> None:
        self._inner_dict['type'] = value
    
    
class AssertionActionTypeClass(object):
    # No docs available.
    
    RAISE_INCIDENT = "RAISE_INCIDENT"
    """Raise an incident."""
    
    RESOLVE_INCIDENT = "RESOLVE_INCIDENT"
    """Resolve open incidents related to the assertion."""
    
    
    
class AssertionActionsClass(_Aspect):
    """The Actions about an Assertion"""


    ASPECT_NAME = 'assertionActions'
    ASPECT_INFO = {}
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.assertion.AssertionActions")

    def __init__(self,
        onSuccess: Optional[List["AssertionActionClass"]]=None,
        onFailure: Optional[List["AssertionActionClass"]]=None,
    ):
        super().__init__()
        
        if onSuccess is None:
            # default: []
            self.onSuccess = list()
        else:
            self.onSuccess = onSuccess
        if onFailure is None:
            # default: []
            self.onFailure = list()
        else:
            self.onFailure = onFailure
    
    def _restore_defaults(self) -> None:
        self.onSuccess = list()
        self.onFailure = list()
    
    
    @property
    def onSuccess(self) -> List["AssertionActionClass"]:
        """Actions to be executed on successful assertion run."""
        return self._inner_dict.get('onSuccess')  # type: ignore
    
    @onSuccess.setter
    def onSuccess(self, value: List["AssertionActionClass"]) -> None:
        self._inner_dict['onSuccess'] = value
    
    
    @property
    def onFailure(self) -> List["AssertionActionClass"]:
        """Actions to be executed on failed assertion run."""
        return self._inner_dict.get('onFailure')  # type: ignore
    
    @onFailure.setter
    def onFailure(self, value: List["AssertionActionClass"]) -> None:
        self._inner_dict['onFailure'] = value
    
    
class AssertionInfoClass(_Aspect):
    """Information about an assertion"""


    ASPECT_NAME = 'assertionInfo'
    ASPECT_INFO = {}
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.assertion.AssertionInfo")

    def __init__(self,
        type: Union[str, "AssertionTypeClass"],
        customProperties: Optional[Dict[str, str]]=None,
        externalUrl: Union[None, str]=None,
        datasetAssertion: Union[None, "DatasetAssertionInfoClass"]=None,
        freshnessAssertion: Union[None, "FreshnessAssertionInfoClass"]=None,
        volumeAssertion: Union[None, "VolumeAssertionInfoClass"]=None,
        sqlAssertion: Union[None, "SqlAssertionInfoClass"]=None,
        schemaAssertion: Union[None, "SchemaAssertionInfoClass"]=None,
        source: Union[None, "AssertionSourceClass"]=None,
        description: Union[None, str]=None,
    ):
        super().__init__()
        
        if customProperties is None:
            # default: {}
            self.customProperties = dict()
        else:
            self.customProperties = customProperties
        self.externalUrl = externalUrl
        self.type = type
        self.datasetAssertion = datasetAssertion
        self.freshnessAssertion = freshnessAssertion
        self.volumeAssertion = volumeAssertion
        self.sqlAssertion = sqlAssertion
        self.schemaAssertion = schemaAssertion
        self.source = source
        self.description = description
    
    def _restore_defaults(self) -> None:
        self.customProperties = dict()
        self.externalUrl = self.RECORD_SCHEMA.fields_dict["externalUrl"].default
        self.type = AssertionTypeClass.DATASET
        self.datasetAssertion = self.RECORD_SCHEMA.fields_dict["datasetAssertion"].default
        self.freshnessAssertion = self.RECORD_SCHEMA.fields_dict["freshnessAssertion"].default
        self.volumeAssertion = self.RECORD_SCHEMA.fields_dict["volumeAssertion"].default
        self.sqlAssertion = self.RECORD_SCHEMA.fields_dict["sqlAssertion"].default
        self.schemaAssertion = self.RECORD_SCHEMA.fields_dict["schemaAssertion"].default
        self.source = self.RECORD_SCHEMA.fields_dict["source"].default
        self.description = self.RECORD_SCHEMA.fields_dict["description"].default
    
    
    @property
    def customProperties(self) -> Dict[str, str]:
        """Custom property bag."""
        return self._inner_dict.get('customProperties')  # type: ignore
    
    @customProperties.setter
    def customProperties(self, value: Dict[str, str]) -> None:
        self._inner_dict['customProperties'] = value
    
    
    @property
    def externalUrl(self) -> Union[None, str]:
        """URL where the reference exist"""
        return self._inner_dict.get('externalUrl')  # type: ignore
    
    @externalUrl.setter
    def externalUrl(self, value: Union[None, str]) -> None:
        self._inner_dict['externalUrl'] = value
    
    
    @property
    def type(self) -> Union[str, "AssertionTypeClass"]:
        """Type of assertion. Assertion types can evolve to span Datasets, Flows (Pipelines), Models, Features etc."""
        return self._inner_dict.get('type')  # type: ignore
    
    @type.setter
    def type(self, value: Union[str, "AssertionTypeClass"]) -> None:
        self._inner_dict['type'] = value
    
    
    @property
    def datasetAssertion(self) -> Union[None, "DatasetAssertionInfoClass"]:
        """A Dataset Assertion definition. This field is populated when the type is DATASET."""
        return self._inner_dict.get('datasetAssertion')  # type: ignore
    
    @datasetAssertion.setter
    def datasetAssertion(self, value: Union[None, "DatasetAssertionInfoClass"]) -> None:
        self._inner_dict['datasetAssertion'] = value
    
    
    @property
    def freshnessAssertion(self) -> Union[None, "FreshnessAssertionInfoClass"]:
        """An Freshness Assertion definition. This field is populated when the type is FRESHNESS."""
        return self._inner_dict.get('freshnessAssertion')  # type: ignore
    
    @freshnessAssertion.setter
    def freshnessAssertion(self, value: Union[None, "FreshnessAssertionInfoClass"]) -> None:
        self._inner_dict['freshnessAssertion'] = value
    
    
    @property
    def volumeAssertion(self) -> Union[None, "VolumeAssertionInfoClass"]:
        """An Volume Assertion definition. This field is populated when the type is VOLUME."""
        return self._inner_dict.get('volumeAssertion')  # type: ignore
    
    @volumeAssertion.setter
    def volumeAssertion(self, value: Union[None, "VolumeAssertionInfoClass"]) -> None:
        self._inner_dict['volumeAssertion'] = value
    
    
    @property
    def sqlAssertion(self) -> Union[None, "SqlAssertionInfoClass"]:
        """A SQL Assertion definition. This field is populated when the type is SQL."""
        return self._inner_dict.get('sqlAssertion')  # type: ignore
    
    @sqlAssertion.setter
    def sqlAssertion(self, value: Union[None, "SqlAssertionInfoClass"]) -> None:
        self._inner_dict['sqlAssertion'] = value
    
    
    @property
    def schemaAssertion(self) -> Union[None, "SchemaAssertionInfoClass"]:
        """An schema Assertion definition. This field is populated when the type is DATA_SCHEMA"""
        return self._inner_dict.get('schemaAssertion')  # type: ignore
    
    @schemaAssertion.setter
    def schemaAssertion(self, value: Union[None, "SchemaAssertionInfoClass"]) -> None:
        self._inner_dict['schemaAssertion'] = value
    
    
    @property
    def source(self) -> Union[None, "AssertionSourceClass"]:
        """The source or origin of the Assertion definition.
    
    If the source type of the Assertion is EXTERNAL, it is expected to have a corresponding dataPlatformInstance aspect detailing
    the platform where it was ingested from."""
        return self._inner_dict.get('source')  # type: ignore
    
    @source.setter
    def source(self, value: Union[None, "AssertionSourceClass"]) -> None:
        self._inner_dict['source'] = value
    
    
    @property
    def description(self) -> Union[None, str]:
        """An optional human-readable description of the assertion"""
        return self._inner_dict.get('description')  # type: ignore
    
    @description.setter
    def description(self, value: Union[None, str]) -> None:
        self._inner_dict['description'] = value
    
    
class AssertionResultClass(DictWrapper):
    """The result of running an assertion"""
    
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.assertion.AssertionResult")
    def __init__(self,
        type: Union[str, "AssertionResultTypeClass"],
        rowCount: Union[None, int]=None,
        missingCount: Union[None, int]=None,
        unexpectedCount: Union[None, int]=None,
        actualAggValue: Union[None, float]=None,
        nativeResults: Union[None, Dict[str, str]]=None,
        externalUrl: Union[None, str]=None,
        error: Union[None, "AssertionResultErrorClass"]=None,
    ):
        super().__init__()
        
        self.type = type
        self.rowCount = rowCount
        self.missingCount = missingCount
        self.unexpectedCount = unexpectedCount
        self.actualAggValue = actualAggValue
        self.nativeResults = nativeResults
        self.externalUrl = externalUrl
        self.error = error
    
    def _restore_defaults(self) -> None:
        self.type = AssertionResultTypeClass.INIT
        self.rowCount = self.RECORD_SCHEMA.fields_dict["rowCount"].default
        self.missingCount = self.RECORD_SCHEMA.fields_dict["missingCount"].default
        self.unexpectedCount = self.RECORD_SCHEMA.fields_dict["unexpectedCount"].default
        self.actualAggValue = self.RECORD_SCHEMA.fields_dict["actualAggValue"].default
        self.nativeResults = self.RECORD_SCHEMA.fields_dict["nativeResults"].default
        self.externalUrl = self.RECORD_SCHEMA.fields_dict["externalUrl"].default
        self.error = self.RECORD_SCHEMA.fields_dict["error"].default
    
    
    @property
    def type(self) -> Union[str, "AssertionResultTypeClass"]:
        """ The final result, e.g. either SUCCESS, FAILURE, or ERROR."""
        return self._inner_dict.get('type')  # type: ignore
    
    @type.setter
    def type(self, value: Union[str, "AssertionResultTypeClass"]) -> None:
        self._inner_dict['type'] = value
    
    
    @property
    def rowCount(self) -> Union[None, int]:
        """Number of rows for evaluated batch"""
        return self._inner_dict.get('rowCount')  # type: ignore
    
    @rowCount.setter
    def rowCount(self, value: Union[None, int]) -> None:
        self._inner_dict['rowCount'] = value
    
    
    @property
    def missingCount(self) -> Union[None, int]:
        """Number of rows with missing value for evaluated batch"""
        return self._inner_dict.get('missingCount')  # type: ignore
    
    @missingCount.setter
    def missingCount(self, value: Union[None, int]) -> None:
        self._inner_dict['missingCount'] = value
    
    
    @property
    def unexpectedCount(self) -> Union[None, int]:
        """Number of rows with unexpected value for evaluated batch"""
        return self._inner_dict.get('unexpectedCount')  # type: ignore
    
    @unexpectedCount.setter
    def unexpectedCount(self, value: Union[None, int]) -> None:
        self._inner_dict['unexpectedCount'] = value
    
    
    @property
    def actualAggValue(self) -> Union[None, float]:
        """Observed aggregate value for evaluated batch"""
        return self._inner_dict.get('actualAggValue')  # type: ignore
    
    @actualAggValue.setter
    def actualAggValue(self, value: Union[None, float]) -> None:
        self._inner_dict['actualAggValue'] = value
    
    
    @property
    def nativeResults(self) -> Union[None, Dict[str, str]]:
        """Other results of evaluation"""
        return self._inner_dict.get('nativeResults')  # type: ignore
    
    @nativeResults.setter
    def nativeResults(self, value: Union[None, Dict[str, str]]) -> None:
        self._inner_dict['nativeResults'] = value
    
    
    @property
    def externalUrl(self) -> Union[None, str]:
        """External URL where full results are available. Only present when assertion source is not native."""
        return self._inner_dict.get('externalUrl')  # type: ignore
    
    @externalUrl.setter
    def externalUrl(self, value: Union[None, str]) -> None:
        self._inner_dict['externalUrl'] = value
    
    
    @property
    def error(self) -> Union[None, "AssertionResultErrorClass"]:
        """ The error object if AssertionResultType is an Error"""
        return self._inner_dict.get('error')  # type: ignore
    
    @error.setter
    def error(self, value: Union[None, "AssertionResultErrorClass"]) -> None:
        self._inner_dict['error'] = value
    
    
class AssertionResultErrorClass(DictWrapper):
    """ An error encountered when evaluating an AssertionResult"""
    
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.assertion.AssertionResultError")
    def __init__(self,
        type: Union[str, "AssertionResultErrorTypeClass"],
        properties: Union[None, Dict[str, str]]=None,
    ):
        super().__init__()
        
        self.type = type
        self.properties = properties
    
    def _restore_defaults(self) -> None:
        self.type = AssertionResultErrorTypeClass.SOURCE_CONNECTION_ERROR
        self.properties = self.RECORD_SCHEMA.fields_dict["properties"].default
    
    
    @property
    def type(self) -> Union[str, "AssertionResultErrorTypeClass"]:
        """ The type of error encountered"""
        return self._inner_dict.get('type')  # type: ignore
    
    @type.setter
    def type(self, value: Union[str, "AssertionResultErrorTypeClass"]) -> None:
        self._inner_dict['type'] = value
    
    
    @property
    def properties(self) -> Union[None, Dict[str, str]]:
        """ Additional metadata depending on the type of error"""
        return self._inner_dict.get('properties')  # type: ignore
    
    @properties.setter
    def properties(self, value: Union[None, Dict[str, str]]) -> None:
        self._inner_dict['properties'] = value
    
    
class AssertionResultErrorTypeClass(object):
    # No docs available.
    
    SOURCE_CONNECTION_ERROR = "SOURCE_CONNECTION_ERROR"
    """ Source is unreachable"""
    
    SOURCE_QUERY_FAILED = "SOURCE_QUERY_FAILED"
    """ Source query failed to execute"""
    
    INSUFFICIENT_DATA = "INSUFFICIENT_DATA"
    """ Insufficient data to evaluate the assertion"""
    
    INVALID_PARAMETERS = "INVALID_PARAMETERS"
    """ Invalid parameters were detected"""
    
    INVALID_SOURCE_TYPE = "INVALID_SOURCE_TYPE"
    """ Event type not supported by the specified source"""
    
    UNSUPPORTED_PLATFORM = "UNSUPPORTED_PLATFORM"
    """ Unsupported platform"""
    
    UNKNOWN_ERROR = "UNKNOWN_ERROR"
    """ Unknown error"""
    
    
    
class AssertionResultTypeClass(object):
    """ The final result of evaluating an assertion, e.g. SUCCESS, FAILURE, or ERROR."""
    
    INIT = "INIT"
    """ The Assertion has not yet been fully evaluated"""
    
    SUCCESS = "SUCCESS"
    """ The Assertion Succeeded"""
    
    FAILURE = "FAILURE"
    """ The Assertion Failed"""
    
    ERROR = "ERROR"
    """ The Assertion encountered an Error"""
    
    
    
class AssertionRunEventClass(_Aspect):
    """An event representing the current status of evaluating an assertion on a batch.
    AssertionRunEvent should be used for reporting the status of a run as an assertion evaluation progresses."""


    ASPECT_NAME = 'assertionRunEvent'
    ASPECT_TYPE = 'timeseries'
    ASPECT_INFO = {}
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.assertion.AssertionRunEvent")

    def __init__(self,
        timestampMillis: int,
        runId: str,
        asserteeUrn: str,
        status: Union[str, "AssertionRunStatusClass"],
        assertionUrn: str,
        result: Union[None, "AssertionResultClass"]=None,
        runtimeContext: Union[None, Dict[str, str]]=None,
        batchSpec: Union[None, "BatchSpecClass"]=None,
        eventGranularity: Union[None, "TimeWindowSizeClass"]=None,
        partitionSpec: Optional[Union["PartitionSpecClass", None]]=None,
        messageId: Union[None, str]=None,
    ):
        super().__init__()
        
        self.timestampMillis = timestampMillis
        self.runId = runId
        self.asserteeUrn = asserteeUrn
        self.status = status
        self.result = result
        self.runtimeContext = runtimeContext
        self.batchSpec = batchSpec
        self.assertionUrn = assertionUrn
        self.eventGranularity = eventGranularity
        if partitionSpec is None:
            # default: {'partition': 'FULL_TABLE_SNAPSHOT', 'type': 'FULL_TABLE', 'timePartition': None}
            self.partitionSpec = _json_converter.from_json_object(self.RECORD_SCHEMA.fields_dict["partitionSpec"].default, writers_schema=self.RECORD_SCHEMA.fields_dict["partitionSpec"].type)
        else:
            self.partitionSpec = partitionSpec
        self.messageId = messageId
    
    def _restore_defaults(self) -> None:
        self.timestampMillis = int()
        self.runId = str()
        self.asserteeUrn = str()
        self.status = AssertionRunStatusClass.COMPLETE
        self.result = self.RECORD_SCHEMA.fields_dict["result"].default
        self.runtimeContext = self.RECORD_SCHEMA.fields_dict["runtimeContext"].default
        self.batchSpec = self.RECORD_SCHEMA.fields_dict["batchSpec"].default
        self.assertionUrn = str()
        self.eventGranularity = self.RECORD_SCHEMA.fields_dict["eventGranularity"].default
        self.partitionSpec = _json_converter.from_json_object(self.RECORD_SCHEMA.fields_dict["partitionSpec"].default, writers_schema=self.RECORD_SCHEMA.fields_dict["partitionSpec"].type)
        self.messageId = self.RECORD_SCHEMA.fields_dict["messageId"].default
    
    
    @property
    def timestampMillis(self) -> int:
        """The event timestamp field as epoch at UTC in milli seconds."""
        return self._inner_dict.get('timestampMillis')  # type: ignore
    
    @timestampMillis.setter
    def timestampMillis(self, value: int) -> None:
        self._inner_dict['timestampMillis'] = value
    
    
    @property
    def runId(self) -> str:
        """ Native (platform-specific) identifier for this run"""
        return self._inner_dict.get('runId')  # type: ignore
    
    @runId.setter
    def runId(self, value: str) -> None:
        self._inner_dict['runId'] = value
    
    
    @property
    def asserteeUrn(self) -> str:
        # No docs available.
        return self._inner_dict.get('asserteeUrn')  # type: ignore
    
    @asserteeUrn.setter
    def asserteeUrn(self, value: str) -> None:
        self._inner_dict['asserteeUrn'] = value
    
    
    @property
    def status(self) -> Union[str, "AssertionRunStatusClass"]:
        """The status of the assertion run as per this timeseries event."""
        return self._inner_dict.get('status')  # type: ignore
    
    @status.setter
    def status(self, value: Union[str, "AssertionRunStatusClass"]) -> None:
        self._inner_dict['status'] = value
    
    
    @property
    def result(self) -> Union[None, "AssertionResultClass"]:
        """Results of assertion, present if the status is COMPLETE"""
        return self._inner_dict.get('result')  # type: ignore
    
    @result.setter
    def result(self, value: Union[None, "AssertionResultClass"]) -> None:
        self._inner_dict['result'] = value
    
    
    @property
    def runtimeContext(self) -> Union[None, Dict[str, str]]:
        """Runtime parameters of evaluation"""
        return self._inner_dict.get('runtimeContext')  # type: ignore
    
    @runtimeContext.setter
    def runtimeContext(self, value: Union[None, Dict[str, str]]) -> None:
        self._inner_dict['runtimeContext'] = value
    
    
    @property
    def batchSpec(self) -> Union[None, "BatchSpecClass"]:
        """Specification of the batch which this run is evaluating"""
        return self._inner_dict.get('batchSpec')  # type: ignore
    
    @batchSpec.setter
    def batchSpec(self, value: Union[None, "BatchSpecClass"]) -> None:
        self._inner_dict['batchSpec'] = value
    
    
    @property
    def assertionUrn(self) -> str:
        # No docs available.
        return self._inner_dict.get('assertionUrn')  # type: ignore
    
    @assertionUrn.setter
    def assertionUrn(self, value: str) -> None:
        self._inner_dict['assertionUrn'] = value
    
    
    @property
    def eventGranularity(self) -> Union[None, "TimeWindowSizeClass"]:
        """Granularity of the event if applicable"""
        return self._inner_dict.get('eventGranularity')  # type: ignore
    
    @eventGranularity.setter
    def eventGranularity(self, value: Union[None, "TimeWindowSizeClass"]) -> None:
        self._inner_dict['eventGranularity'] = value
    
    
    @property
    def partitionSpec(self) -> Union["PartitionSpecClass", None]:
        """The optional partition specification."""
        return self._inner_dict.get('partitionSpec')  # type: ignore
    
    @partitionSpec.setter
    def partitionSpec(self, value: Union["PartitionSpecClass", None]) -> None:
        self._inner_dict['partitionSpec'] = value
    
    
    @property
    def messageId(self) -> Union[None, str]:
        """The optional messageId, if provided serves as a custom user-defined unique identifier for an aspect value."""
        return self._inner_dict.get('messageId')  # type: ignore
    
    @messageId.setter
    def messageId(self, value: Union[None, str]) -> None:
        self._inner_dict['messageId'] = value
    
    
class AssertionRunStatusClass(object):
    """The lifecycle status of an assertion run."""
    
    COMPLETE = "COMPLETE"
    """The Assertion Run has completed"""
    
    
    
class AssertionSourceClass(DictWrapper):
    """The source of an assertion"""
    
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.assertion.AssertionSource")
    def __init__(self,
        type: Union[str, "AssertionSourceTypeClass"],
    ):
        super().__init__()
        
        self.type = type
    
    def _restore_defaults(self) -> None:
        self.type = AssertionSourceTypeClass.NATIVE
    
    
    @property
    def type(self) -> Union[str, "AssertionSourceTypeClass"]:
        """The type of the Assertion Source"""
        return self._inner_dict.get('type')  # type: ignore
    
    @type.setter
    def type(self, value: Union[str, "AssertionSourceTypeClass"]) -> None:
        self._inner_dict['type'] = value
    
    
class AssertionSourceTypeClass(object):
    # No docs available.
    
    NATIVE = "NATIVE"
    """The assertion was defined natively on DataHub by a user."""
    
    EXTERNAL = "EXTERNAL"
    """The assertion was defined and managed externally of DataHub."""
    
    INFERRED = "INFERRED"
    """The assertion was inferred, e.g. from offline AI / ML models."""
    
    
    
class AssertionStdAggregationClass(object):
    """The function that is applied to the aggregation input (schema, rows, column values) before evaluating an operator."""
    
    ROW_COUNT = "ROW_COUNT"
    """Assertion is applied on number of rows."""
    
    COLUMNS = "COLUMNS"
    """Assertion is applied on all columns."""
    
    COLUMN_COUNT = "COLUMN_COUNT"
    """Assertion is applied on number of columns."""
    
    IDENTITY = "IDENTITY"
    """Assertion is applied on individual column value. (No aggregation)"""
    
    MEAN = "MEAN"
    """Assertion is applied on column mean"""
    
    MEDIAN = "MEDIAN"
    """Assertion is applied on column median"""
    
    UNIQUE_COUNT = "UNIQUE_COUNT"
    """Assertion is applied on number of distinct values in column"""
    
    UNIQUE_PROPORTION = "UNIQUE_PROPORTION"
    """Assertion is applied on proportion of distinct values in column"""
    
    UNIQUE_PROPOTION = "UNIQUE_PROPOTION"
    """Assertion is applied on proportion of distinct values in column
    
    Deprecated! Use UNIQUE_PROPORTION instead."""
    
    NULL_COUNT = "NULL_COUNT"
    """Assertion is applied on number of null values in column"""
    
    NULL_PROPORTION = "NULL_PROPORTION"
    """Assertion is applied on proportion of null values in column"""
    
    STDDEV = "STDDEV"
    """Assertion is applied on column std deviation"""
    
    MIN = "MIN"
    """Assertion is applied on column min"""
    
    MAX = "MAX"
    """Assertion is applied on column std deviation"""
    
    SUM = "SUM"
    """Assertion is applied on column sum"""
    
    _NATIVE_ = "_NATIVE_"
    """Other"""
    
    
    
class AssertionStdOperatorClass(object):
    """A boolean operator that is applied on the input to an assertion, after an aggregation function has been applied."""
    
    BETWEEN = "BETWEEN"
    """Value being asserted is between min_value and max_value.  Requires 'minValue' & 'maxValue' parameters."""
    
    LESS_THAN = "LESS_THAN"
    """Value being asserted is less than a max value. Requires 'value' parameter."""
    
    LESS_THAN_OR_EQUAL_TO = "LESS_THAN_OR_EQUAL_TO"
    """Value being asserted is less than or equal to some value. Requires 'value' parameter."""
    
    GREATER_THAN = "GREATER_THAN"
    """Value being asserted is greater than some value. Requires 'value' parameter."""
    
    GREATER_THAN_OR_EQUAL_TO = "GREATER_THAN_OR_EQUAL_TO"
    """Value being asserted is greater than or equal to some value. Requires 'value' parameter."""
    
    EQUAL_TO = "EQUAL_TO"
    """Value being asserted is equal to value. Requires 'value' parameter."""
    
    NOT_NULL = "NOT_NULL"
    """Value being asserted is not null. Requires no parameters."""
    
    CONTAIN = "CONTAIN"
    """Value being asserted contains value. Requires 'value' parameter."""
    
    END_WITH = "END_WITH"
    """Value being asserted ends with value. Requires 'value' parameter."""
    
    START_WITH = "START_WITH"
    """Value being asserted starts with value. Requires 'value' parameter."""
    
    REGEX_MATCH = "REGEX_MATCH"
    """Value being asserted matches the regex value. Requires 'value' parameter."""
    
    IN = "IN"
    """Value being asserted is one of the array values. Requires 'value' parameter."""
    
    NOT_IN = "NOT_IN"
    """Value being asserted is not in one of the array values. Requires 'value' parameter."""
    
    _NATIVE_ = "_NATIVE_"
    """Other"""
    
    
    
class AssertionStdParameterClass(DictWrapper):
    """Single parameter for AssertionStdOperators."""
    
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.assertion.AssertionStdParameter")
    def __init__(self,
        value: str,
        type: Union[str, "AssertionStdParameterTypeClass"],
    ):
        super().__init__()
        
        self.value = value
        self.type = type
    
    def _restore_defaults(self) -> None:
        self.value = str()
        self.type = AssertionStdParameterTypeClass.STRING
    
    
    @property
    def value(self) -> str:
        """The parameter value"""
        return self._inner_dict.get('value')  # type: ignore
    
    @value.setter
    def value(self, value: str) -> None:
        self._inner_dict['value'] = value
    
    
    @property
    def type(self) -> Union[str, "AssertionStdParameterTypeClass"]:
        """The type of the parameter"""
        return self._inner_dict.get('type')  # type: ignore
    
    @type.setter
    def type(self, value: Union[str, "AssertionStdParameterTypeClass"]) -> None:
        self._inner_dict['type'] = value
    
    
class AssertionStdParameterTypeClass(object):
    # No docs available.
    
    STRING = "STRING"
    NUMBER = "NUMBER"
    LIST = "LIST"
    SET = "SET"
    UNKNOWN = "UNKNOWN"
    
    
class AssertionStdParametersClass(DictWrapper):
    """Parameters for AssertionStdOperators."""
    
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.assertion.AssertionStdParameters")
    def __init__(self,
        value: Union[None, "AssertionStdParameterClass"]=None,
        maxValue: Union[None, "AssertionStdParameterClass"]=None,
        minValue: Union[None, "AssertionStdParameterClass"]=None,
    ):
        super().__init__()
        
        self.value = value
        self.maxValue = maxValue
        self.minValue = minValue
    
    def _restore_defaults(self) -> None:
        self.value = self.RECORD_SCHEMA.fields_dict["value"].default
        self.maxValue = self.RECORD_SCHEMA.fields_dict["maxValue"].default
        self.minValue = self.RECORD_SCHEMA.fields_dict["minValue"].default
    
    
    @property
    def value(self) -> Union[None, "AssertionStdParameterClass"]:
        """The value parameter of an assertion"""
        return self._inner_dict.get('value')  # type: ignore
    
    @value.setter
    def value(self, value: Union[None, "AssertionStdParameterClass"]) -> None:
        self._inner_dict['value'] = value
    
    
    @property
    def maxValue(self) -> Union[None, "AssertionStdParameterClass"]:
        """The maxValue parameter of an assertion"""
        return self._inner_dict.get('maxValue')  # type: ignore
    
    @maxValue.setter
    def maxValue(self, value: Union[None, "AssertionStdParameterClass"]) -> None:
        self._inner_dict['maxValue'] = value
    
    
    @property
    def minValue(self) -> Union[None, "AssertionStdParameterClass"]:
        """The minValue parameter of an assertion"""
        return self._inner_dict.get('minValue')  # type: ignore
    
    @minValue.setter
    def minValue(self, value: Union[None, "AssertionStdParameterClass"]) -> None:
        self._inner_dict['minValue'] = value
    
    
class AssertionTypeClass(object):
    # No docs available.
    
    DATASET = "DATASET"
    """A single-dataset assertion. When this is the value, the datasetAssertion field will be populated."""
    
    FRESHNESS = "FRESHNESS"
    """A freshness assertion, or an assertion which indicates when a particular operation should occur
    to an asset."""
    
    VOLUME = "VOLUME"
    """A volume assertion, or an assertion which indicates how much data should be available for a
    particular asset."""
    
    SQL = "SQL"
    """A raw SQL-statement based assertion"""
    
    DATA_SCHEMA = "DATA_SCHEMA"
    """A schema or structural assertion.
    
    Would have named this SCHEMA but the codegen for PDL does not allow this (reserved word)."""
    
    
    
class AssertionValueChangeTypeClass(object):
    """An enum to represent a type of change in an assertion value, metric, or measurement."""
    
    ABSOLUTE = "ABSOLUTE"
    """A change that is defined in absolute terms."""
    
    PERCENTAGE = "PERCENTAGE"
    """A change that is defined in relative terms using percentage change
    from the original value."""
    
    
    
class BatchSpecClass(DictWrapper):
    """A batch on which certain operations, e.g. data quality evaluation, is done."""
    
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.assertion.BatchSpec")
    def __init__(self,
        customProperties: Optional[Dict[str, str]]=None,
        nativeBatchId: Union[None, str]=None,
        query: Union[None, str]=None,
        limit: Union[None, int]=None,
    ):
        super().__init__()
        
        if customProperties is None:
            # default: {}
            self.customProperties = dict()
        else:
            self.customProperties = customProperties
        self.nativeBatchId = nativeBatchId
        self.query = query
        self.limit = limit
    
    def _restore_defaults(self) -> None:
        self.customProperties = dict()
        self.nativeBatchId = self.RECORD_SCHEMA.fields_dict["nativeBatchId"].default
        self.query = self.RECORD_SCHEMA.fields_dict["query"].default
        self.limit = self.RECORD_SCHEMA.fields_dict["limit"].default
    
    
    @property
    def customProperties(self) -> Dict[str, str]:
        """Custom property bag."""
        return self._inner_dict.get('customProperties')  # type: ignore
    
    @customProperties.setter
    def customProperties(self, value: Dict[str, str]) -> None:
        self._inner_dict['customProperties'] = value
    
    
    @property
    def nativeBatchId(self) -> Union[None, str]:
        """The native identifier as specified by the system operating on the batch."""
        return self._inner_dict.get('nativeBatchId')  # type: ignore
    
    @nativeBatchId.setter
    def nativeBatchId(self, value: Union[None, str]) -> None:
        self._inner_dict['nativeBatchId'] = value
    
    
    @property
    def query(self) -> Union[None, str]:
        """A query that identifies a batch of data"""
        return self._inner_dict.get('query')  # type: ignore
    
    @query.setter
    def query(self, value: Union[None, str]) -> None:
        self._inner_dict['query'] = value
    
    
    @property
    def limit(self) -> Union[None, int]:
        """Any limit to the number of rows in the batch, if applied"""
        return self._inner_dict.get('limit')  # type: ignore
    
    @limit.setter
    def limit(self, value: Union[None, int]) -> None:
        self._inner_dict['limit'] = value
    
    
class DatasetAssertionInfoClass(DictWrapper):
    """Attributes that are applicable to single-Dataset Assertions"""
    
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.assertion.DatasetAssertionInfo")
    def __init__(self,
        dataset: str,
        scope: Union[str, "DatasetAssertionScopeClass"],
        operator: Union[str, "AssertionStdOperatorClass"],
        fields: Union[None, List[str]]=None,
        aggregation: Union[None, Union[str, "AssertionStdAggregationClass"]]=None,
        parameters: Union[None, "AssertionStdParametersClass"]=None,
        nativeType: Union[None, str]=None,
        nativeParameters: Union[None, Dict[str, str]]=None,
        logic: Union[None, str]=None,
    ):
        super().__init__()
        
        self.dataset = dataset
        self.scope = scope
        self.fields = fields
        self.aggregation = aggregation
        self.operator = operator
        self.parameters = parameters
        self.nativeType = nativeType
        self.nativeParameters = nativeParameters
        self.logic = logic
    
    def _restore_defaults(self) -> None:
        self.dataset = str()
        self.scope = DatasetAssertionScopeClass.DATASET_COLUMN
        self.fields = self.RECORD_SCHEMA.fields_dict["fields"].default
        self.aggregation = self.RECORD_SCHEMA.fields_dict["aggregation"].default
        self.operator = AssertionStdOperatorClass.BETWEEN
        self.parameters = self.RECORD_SCHEMA.fields_dict["parameters"].default
        self.nativeType = self.RECORD_SCHEMA.fields_dict["nativeType"].default
        self.nativeParameters = self.RECORD_SCHEMA.fields_dict["nativeParameters"].default
        self.logic = self.RECORD_SCHEMA.fields_dict["logic"].default
    
    
    @property
    def dataset(self) -> str:
        """The dataset targeted by this assertion."""
        return self._inner_dict.get('dataset')  # type: ignore
    
    @dataset.setter
    def dataset(self, value: str) -> None:
        self._inner_dict['dataset'] = value
    
    
    @property
    def scope(self) -> Union[str, "DatasetAssertionScopeClass"]:
        """Scope of the Assertion. What part of the dataset does this assertion apply to?"""
        return self._inner_dict.get('scope')  # type: ignore
    
    @scope.setter
    def scope(self, value: Union[str, "DatasetAssertionScopeClass"]) -> None:
        self._inner_dict['scope'] = value
    
    
    @property
    def fields(self) -> Union[None, List[str]]:
        """One or more dataset schema fields that are targeted by this assertion.
    
    This field is expected to be provided if the assertion scope is DATASET_COLUMN."""
        return self._inner_dict.get('fields')  # type: ignore
    
    @fields.setter
    def fields(self, value: Union[None, List[str]]) -> None:
        self._inner_dict['fields'] = value
    
    
    @property
    def aggregation(self) -> Union[None, Union[str, "AssertionStdAggregationClass"]]:
        """Standardized assertion operator
    This field is left blank if there is no selected aggregation or metric for a particular column."""
        return self._inner_dict.get('aggregation')  # type: ignore
    
    @aggregation.setter
    def aggregation(self, value: Union[None, Union[str, "AssertionStdAggregationClass"]]) -> None:
        self._inner_dict['aggregation'] = value
    
    
    @property
    def operator(self) -> Union[str, "AssertionStdOperatorClass"]:
        """Standardized assertion operator"""
        return self._inner_dict.get('operator')  # type: ignore
    
    @operator.setter
    def operator(self, value: Union[str, "AssertionStdOperatorClass"]) -> None:
        self._inner_dict['operator'] = value
    
    
    @property
    def parameters(self) -> Union[None, "AssertionStdParametersClass"]:
        """Standard parameters required for the assertion. e.g. min_value, max_value, value, columns"""
        return self._inner_dict.get('parameters')  # type: ignore
    
    @parameters.setter
    def parameters(self, value: Union[None, "AssertionStdParametersClass"]) -> None:
        self._inner_dict['parameters'] = value
    
    
    @property
    def nativeType(self) -> Union[None, str]:
        """Native assertion type"""
        return self._inner_dict.get('nativeType')  # type: ignore
    
    @nativeType.setter
    def nativeType(self, value: Union[None, str]) -> None:
        self._inner_dict['nativeType'] = value
    
    
    @property
    def nativeParameters(self) -> Union[None, Dict[str, str]]:
        """Native parameters required for the assertion."""
        return self._inner_dict.get('nativeParameters')  # type: ignore
    
    @nativeParameters.setter
    def nativeParameters(self, value: Union[None, Dict[str, str]]) -> None:
        self._inner_dict['nativeParameters'] = value
    
    
    @property
    def logic(self) -> Union[None, str]:
        # No docs available.
        return self._inner_dict.get('logic')  # type: ignore
    
    @logic.setter
    def logic(self, value: Union[None, str]) -> None:
        self._inner_dict['logic'] = value
    
    
class DatasetAssertionScopeClass(object):
    # No docs available.
    
    DATASET_COLUMN = "DATASET_COLUMN"
    """This assertion applies to dataset column(s)"""
    
    DATASET_ROWS = "DATASET_ROWS"
    """This assertion applies to entire rows of the dataset"""
    
    DATASET_STORAGE_SIZE = "DATASET_STORAGE_SIZE"
    """This assertion applies to the storage size of the dataset"""
    
    DATASET_SCHEMA = "DATASET_SCHEMA"
    """This assertion applies to the schema of the dataset"""
    
    UNKNOWN = "UNKNOWN"
    """The scope of the assertion is unknown"""
    
    
    
class FixedIntervalScheduleClass(DictWrapper):
    """Attributes defining a relative fixed interval SLA schedule."""
    
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.assertion.FixedIntervalSchedule")
    def __init__(self,
        unit: Union[str, "CalendarIntervalClass"],
        multiple: Optional[int]=None,
    ):
        super().__init__()
        
        self.unit = unit
        if multiple is None:
            # default: 1
            self.multiple = self.RECORD_SCHEMA.fields_dict["multiple"].default
        else:
            self.multiple = multiple
    
    def _restore_defaults(self) -> None:
        self.unit = CalendarIntervalClass.SECOND
        self.multiple = self.RECORD_SCHEMA.fields_dict["multiple"].default
    
    
    @property
    def unit(self) -> Union[str, "CalendarIntervalClass"]:
        """Interval unit such as minute/hour/day etc."""
        return self._inner_dict.get('unit')  # type: ignore
    
    @unit.setter
    def unit(self, value: Union[str, "CalendarIntervalClass"]) -> None:
        self._inner_dict['unit'] = value
    
    
    @property
    def multiple(self) -> int:
        """How many units. Defaults to 1."""
        return self._inner_dict.get('multiple')  # type: ignore
    
    @multiple.setter
    def multiple(self, value: int) -> None:
        self._inner_dict['multiple'] = value
    
    
class FreshnessAssertionInfoClass(DictWrapper):
    """Attributes defining a Freshness Assertion."""
    
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.assertion.FreshnessAssertionInfo")
    def __init__(self,
        type: Union[str, "FreshnessAssertionTypeClass"],
        entity: str,
        schedule: "FreshnessAssertionScheduleClass",
        filter: Union[None, "DatasetFilterClass"]=None,
    ):
        super().__init__()
        
        self.type = type
        self.entity = entity
        self.schedule = schedule
        self.filter = filter
    
    def _restore_defaults(self) -> None:
        self.type = FreshnessAssertionTypeClass.DATASET_CHANGE
        self.entity = str()
        self.schedule = FreshnessAssertionScheduleClass._construct_with_defaults()
        self.filter = self.RECORD_SCHEMA.fields_dict["filter"].default
    
    
    @property
    def type(self) -> Union[str, "FreshnessAssertionTypeClass"]:
        """The type of the freshness assertion being monitored."""
        return self._inner_dict.get('type')  # type: ignore
    
    @type.setter
    def type(self, value: Union[str, "FreshnessAssertionTypeClass"]) -> None:
        self._inner_dict['type'] = value
    
    
    @property
    def entity(self) -> str:
        """The entity targeted by this Freshness check."""
        return self._inner_dict.get('entity')  # type: ignore
    
    @entity.setter
    def entity(self, value: str) -> None:
        self._inner_dict['entity'] = value
    
    
    @property
    def schedule(self) -> "FreshnessAssertionScheduleClass":
        """Produce FAILURE Assertion Result if the asset is not updated on the cadence and within the time range described by the schedule."""
        return self._inner_dict.get('schedule')  # type: ignore
    
    @schedule.setter
    def schedule(self, value: "FreshnessAssertionScheduleClass") -> None:
        self._inner_dict['schedule'] = value
    
    
    @property
    def filter(self) -> Union[None, "DatasetFilterClass"]:
        """A definition of the specific filters that should be applied, when performing monitoring.
    If not provided, there is no filter, and the full table is under consideration."""
        return self._inner_dict.get('filter')  # type: ignore
    
    @filter.setter
    def filter(self, value: Union[None, "DatasetFilterClass"]) -> None:
        self._inner_dict['filter'] = value
    
    
class FreshnessAssertionScheduleClass(DictWrapper):
    """Attributes defining a single Freshness schedule."""
    
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.assertion.FreshnessAssertionSchedule")
    def __init__(self,
        type: Union[str, "FreshnessAssertionScheduleTypeClass"],
        cron: Union[None, "FreshnessCronScheduleClass"]=None,
        fixedInterval: Union[None, "FixedIntervalScheduleClass"]=None,
    ):
        super().__init__()
        
        self.type = type
        self.cron = cron
        self.fixedInterval = fixedInterval
    
    def _restore_defaults(self) -> None:
        self.type = FreshnessAssertionScheduleTypeClass.CRON
        self.cron = self.RECORD_SCHEMA.fields_dict["cron"].default
        self.fixedInterval = self.RECORD_SCHEMA.fields_dict["fixedInterval"].default
    
    
    @property
    def type(self) -> Union[str, "FreshnessAssertionScheduleTypeClass"]:
        """The type of a Freshness Assertion Schedule.
    
    Once we support data-time-relative schedules (e.g. schedules relative to time partitions),
    we will add those schedule types here."""
        return self._inner_dict.get('type')  # type: ignore
    
    @type.setter
    def type(self, value: Union[str, "FreshnessAssertionScheduleTypeClass"]) -> None:
        self._inner_dict['type'] = value
    
    
    @property
    def cron(self) -> Union[None, "FreshnessCronScheduleClass"]:
        """A cron schedule. This field is required when type is CRON."""
        return self._inner_dict.get('cron')  # type: ignore
    
    @cron.setter
    def cron(self, value: Union[None, "FreshnessCronScheduleClass"]) -> None:
        self._inner_dict['cron'] = value
    
    
    @property
    def fixedInterval(self) -> Union[None, "FixedIntervalScheduleClass"]:
        """A fixed interval schedule. This field is required when type is FIXED_INTERVAL."""
        return self._inner_dict.get('fixedInterval')  # type: ignore
    
    @fixedInterval.setter
    def fixedInterval(self, value: Union[None, "FixedIntervalScheduleClass"]) -> None:
        self._inner_dict['fixedInterval'] = value
    
    
class FreshnessAssertionScheduleTypeClass(object):
    # No docs available.
    
    CRON = "CRON"
    """An highly configurable recurring schedule which describes the times of events described
    by a CRON schedule, with the evaluation schedule assuming to be matching the cron schedule.
    
    In a CRON schedule type, we compute the look-back window to be the time between the last scheduled event
    and the current event (evaluation time). This means that the evaluation schedule must match exactly
    the schedule defined inside the cron schedule.
    
    For example, a CRON schedule defined as "0 8 * * *" would represent a schedule of "every day by 8am". Assuming
    that the assertion evaluation schedule is defined to match this, the freshness assertion would be evaluated in the following way:
    
        1. Compute the "last scheduled occurrence" of the event using the CRON schedule. For example, yesterday at 8am.
        2. Compute the bounds of a time window between the "last scheduled occurrence" (yesterday at 8am) until the "current occurrence" (today at 8am)
        3. Verify that the target event has occurred within the CRON-interval window.
        4. If the target event has occurred within the time window, then assertion passes.
        5. If the target event has not occurred within the time window, then the assertion fails."""
    
    FIXED_INTERVAL = "FIXED_INTERVAL"
    """A fixed interval which is used to compute a look-back window for use when evaluating the assertion relative
    to the Evaluation Time of the Assertion.
    
    To compute the valid look-back window, we subtract the fixed interval from the evaluation time. Then, we verify
    that the target event has occurred within that window.
    
    For example, a fixed interval of "24h" would represent a schedule of "in the last 24 hours".
    The 24 hour interval is relative to the evaluation time of the assertion. For example if we schedule the assertion
    to be evaluated each hour, we'd compute the result as follows:
    
        1. Subtract the fixed interval from the current time (Evaluation time) to compute the bounds of a fixed look-back window.
        2. Verify that the target event has occurred within the CRON-interval window.
        3. If the target event has occurred within the time window, then assertion passes.
        4. If the target event has not occurred within the time window, then the assertion fails."""
    
    
    
class FreshnessAssertionTypeClass(object):
    # No docs available.
    
    DATASET_CHANGE = "DATASET_CHANGE"
    """An Freshness based on Operations performed on a particular Dataset (insert, update, delete, etc) and sourced from an audit log, as
    opposed to based on the highest watermark in a timestamp column (e.g. a query). Only valid when entity is of type "dataset"."""
    
    DATA_JOB_RUN = "DATA_JOB_RUN"
    """An Freshness based on a successful execution of a Data Job."""
    
    
    
class FreshnessCronScheduleClass(DictWrapper):
    """Attributes defining a CRON-formatted schedule used for defining a freshness assertion."""
    
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.assertion.FreshnessCronSchedule")
    def __init__(self,
        cron: str,
        timezone: str,
        windowStartOffsetMs: Union[None, int]=None,
    ):
        super().__init__()
        
        self.cron = cron
        self.timezone = timezone
        self.windowStartOffsetMs = windowStartOffsetMs
    
    def _restore_defaults(self) -> None:
        self.cron = str()
        self.timezone = str()
        self.windowStartOffsetMs = self.RECORD_SCHEMA.fields_dict["windowStartOffsetMs"].default
    
    
    @property
    def cron(self) -> str:
        """A cron-formatted execution interval, as a cron string, e.g. 1 * * * *"""
        return self._inner_dict.get('cron')  # type: ignore
    
    @cron.setter
    def cron(self, value: str) -> None:
        self._inner_dict['cron'] = value
    
    
    @property
    def timezone(self) -> str:
        """Timezone in which the cron interval applies, e.g. America/Los Angeles"""
        return self._inner_dict.get('timezone')  # type: ignore
    
    @timezone.setter
    def timezone(self, value: str) -> None:
        self._inner_dict['timezone'] = value
    
    
    @property
    def windowStartOffsetMs(self) -> Union[None, int]:
        """An optional offset in milliseconds to SUBTRACT from the timestamp generated by the cron schedule
    to generate the lower bounds of the "freshness window", or the window of time in which an event must have occurred in order for the Freshness check
    to be considering passing.
    
    If left empty, the start of the SLA window will be the _end_ of the previously evaluated Freshness window."""
        return self._inner_dict.get('windowStartOffsetMs')  # type: ignore
    
    @windowStartOffsetMs.setter
    def windowStartOffsetMs(self, value: Union[None, int]) -> None:
        self._inner_dict['windowStartOffsetMs'] = value
    
    
class IncrementingSegmentFieldTransformerClass(DictWrapper):
    """The definition of the transformer function  that should be applied to a given field / column value in a dataset
    in order to determine the segment or bucket that it belongs to, which in turn is used to evaluate
    volume assertions."""
    
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.assertion.IncrementingSegmentFieldTransformer")
    def __init__(self,
        type: Union[str, "IncrementingSegmentFieldTransformerTypeClass"],
        nativeType: Union[None, str]=None,
    ):
        super().__init__()
        
        self.type = type
        self.nativeType = nativeType
    
    def _restore_defaults(self) -> None:
        self.type = IncrementingSegmentFieldTransformerTypeClass.TIMESTAMP_MS_TO_MINUTE
        self.nativeType = self.RECORD_SCHEMA.fields_dict["nativeType"].default
    
    
    @property
    def type(self) -> Union[str, "IncrementingSegmentFieldTransformerTypeClass"]:
        """A 'standard' transformer type. Note that not all source systems will support all operators."""
        return self._inner_dict.get('type')  # type: ignore
    
    @type.setter
    def type(self, value: Union[str, "IncrementingSegmentFieldTransformerTypeClass"]) -> None:
        self._inner_dict['type'] = value
    
    
    @property
    def nativeType(self) -> Union[None, str]:
        """The 'native' transformer type, useful as a back door if a custom operator is required.
    This field is required if the type is NATIVE."""
        return self._inner_dict.get('nativeType')  # type: ignore
    
    @nativeType.setter
    def nativeType(self, value: Union[None, str]) -> None:
        self._inner_dict['nativeType'] = value
    
    
class IncrementingSegmentFieldTransformerTypeClass(object):
    # No docs available.
    
    TIMESTAMP_MS_TO_MINUTE = "TIMESTAMP_MS_TO_MINUTE"
    """Rounds a timestamp (in seconds) down to the start of the month."""
    
    TIMESTAMP_MS_TO_HOUR = "TIMESTAMP_MS_TO_HOUR"
    """Rounds a timestamp (in milliseconds) down to the nearest hour."""
    
    TIMESTAMP_MS_TO_DATE = "TIMESTAMP_MS_TO_DATE"
    """Rounds a timestamp (in milliseconds) down to the start of the day."""
    
    TIMESTAMP_MS_TO_MONTH = "TIMESTAMP_MS_TO_MONTH"
    """Rounds a timestamp (in milliseconds) down to the start of the month"""
    
    TIMESTAMP_MS_TO_YEAR = "TIMESTAMP_MS_TO_YEAR"
    """Rounds a timestamp (in milliseconds) down to the start of the year"""
    
    FLOOR = "FLOOR"
    """Rounds a numeric value down to the nearest integer."""
    
    CEILING = "CEILING"
    """Rounds a numeric value up to the nearest integer."""
    
    NATIVE = "NATIVE"
    """A backdoor to provide a native operator type specific to a given source system like
    Snowflake, Redshift, BQ, etc."""
    
    
    
class IncrementingSegmentRowCountChangeClass(DictWrapper):
    """Attributes defining an INCREMENTING_SEGMENT_ROW_COUNT_CHANGE volume assertion."""
    
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.assertion.IncrementingSegmentRowCountChange")
    def __init__(self,
        segment: "IncrementingSegmentSpecClass",
        type: Union[str, "AssertionValueChangeTypeClass"],
        operator: Union[str, "AssertionStdOperatorClass"],
        parameters: "AssertionStdParametersClass",
    ):
        super().__init__()
        
        self.segment = segment
        self.type = type
        self.operator = operator
        self.parameters = parameters
    
    def _restore_defaults(self) -> None:
        self.segment = IncrementingSegmentSpecClass._construct_with_defaults()
        self.type = AssertionValueChangeTypeClass.ABSOLUTE
        self.operator = AssertionStdOperatorClass.BETWEEN
        self.parameters = AssertionStdParametersClass._construct_with_defaults()
    
    
    @property
    def segment(self) -> "IncrementingSegmentSpecClass":
        """A specification of how the 'segment' can be derived using a column and an optional transformer function."""
        return self._inner_dict.get('segment')  # type: ignore
    
    @segment.setter
    def segment(self, value: "IncrementingSegmentSpecClass") -> None:
        self._inner_dict['segment'] = value
    
    
    @property
    def type(self) -> Union[str, "AssertionValueChangeTypeClass"]:
        """The type of the value used to evaluate the assertion: a fixed absolute value or a relative percentage."""
        return self._inner_dict.get('type')  # type: ignore
    
    @type.setter
    def type(self, value: Union[str, "AssertionValueChangeTypeClass"]) -> None:
        self._inner_dict['type'] = value
    
    
    @property
    def operator(self) -> Union[str, "AssertionStdOperatorClass"]:
        """The operator you'd like to apply to the row count value
    
    Note that only numeric operators are valid inputs:
    GREATER_THAN, GREATER_THAN_OR_EQUAL_TO, EQUAL_TO, LESS_THAN, LESS_THAN_OR_EQUAL_TO,
    BETWEEN."""
        return self._inner_dict.get('operator')  # type: ignore
    
    @operator.setter
    def operator(self, value: Union[str, "AssertionStdOperatorClass"]) -> None:
        self._inner_dict['operator'] = value
    
    
    @property
    def parameters(self) -> "AssertionStdParametersClass":
        """The parameters you'd like to provide as input to the operator.
    
    Note that only numeric parameter types are valid inputs: NUMBER."""
        return self._inner_dict.get('parameters')  # type: ignore
    
    @parameters.setter
    def parameters(self, value: "AssertionStdParametersClass") -> None:
        self._inner_dict['parameters'] = value
    
    
class IncrementingSegmentRowCountTotalClass(DictWrapper):
    """Attributes defining an INCREMENTING_SEGMENT_ROW_COUNT_TOTAL volume assertion."""
    
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.assertion.IncrementingSegmentRowCountTotal")
    def __init__(self,
        segment: "IncrementingSegmentSpecClass",
        operator: Union[str, "AssertionStdOperatorClass"],
        parameters: "AssertionStdParametersClass",
    ):
        super().__init__()
        
        self.segment = segment
        self.operator = operator
        self.parameters = parameters
    
    def _restore_defaults(self) -> None:
        self.segment = IncrementingSegmentSpecClass._construct_with_defaults()
        self.operator = AssertionStdOperatorClass.BETWEEN
        self.parameters = AssertionStdParametersClass._construct_with_defaults()
    
    
    @property
    def segment(self) -> "IncrementingSegmentSpecClass":
        """A specification of how the 'segment' can be derived using a column and an optional transformer function."""
        return self._inner_dict.get('segment')  # type: ignore
    
    @segment.setter
    def segment(self, value: "IncrementingSegmentSpecClass") -> None:
        self._inner_dict['segment'] = value
    
    
    @property
    def operator(self) -> Union[str, "AssertionStdOperatorClass"]:
        """The operator you'd like to apply.
    
    Note that only numeric operators are valid inputs:
    GREATER_THAN, GREATER_THAN_OR_EQUAL_TO, EQUAL_TO, LESS_THAN, LESS_THAN_OR_EQUAL_TO,
    BETWEEN."""
        return self._inner_dict.get('operator')  # type: ignore
    
    @operator.setter
    def operator(self, value: Union[str, "AssertionStdOperatorClass"]) -> None:
        self._inner_dict['operator'] = value
    
    
    @property
    def parameters(self) -> "AssertionStdParametersClass":
        """The parameters you'd like to provide as input to the operator.
    
    Note that only numeric parameter types are valid inputs: NUMBER."""
        return self._inner_dict.get('parameters')  # type: ignore
    
    @parameters.setter
    def parameters(self, value: "AssertionStdParametersClass") -> None:
        self._inner_dict['parameters'] = value
    
    
class IncrementingSegmentSpecClass(DictWrapper):
    """Core attributes required to identify an incrementing segment in a table. This type is mainly useful
    for tables that constantly increase with new rows being added on a particular cadence (e.g. fact or event tables)
    
    An incrementing segment represents a logical chunk of data which is INSERTED
    into a dataset on a regular interval, along with the presence of a constantly-incrementing column
    value such as an event time, date partition, or last modified column.
    
    An incrementing segment is principally identified by 2 key attributes combined:
    
     1. A field or column that represents the incrementing value. New rows that are inserted will be identified using this column.
        Note that the value of this column may not by itself represent the "bucket" or the "segment" in which the row falls.
    
     2. [Optional] An transformer function that may be applied to the selected column value in order
        to obtain the final "segment identifier" or "bucket identifier". Rows that have the same value after applying the transformation
        will be grouped into the same segment, using which the final value (e.g. row count) will be determined."""
    
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.assertion.IncrementingSegmentSpec")
    def __init__(self,
        field: "SchemaFieldSpecClass",
        transformer: Union[None, "IncrementingSegmentFieldTransformerClass"]=None,
    ):
        super().__init__()
        
        self.field = field
        self.transformer = transformer
    
    def _restore_defaults(self) -> None:
        self.field = SchemaFieldSpecClass._construct_with_defaults()
        self.transformer = self.RECORD_SCHEMA.fields_dict["transformer"].default
    
    
    @property
    def field(self) -> "SchemaFieldSpecClass":
        """The field to use to generate segments. It must be constantly incrementing as new rows are inserted."""
        return self._inner_dict.get('field')  # type: ignore
    
    @field.setter
    def field(self, value: "SchemaFieldSpecClass") -> None:
        self._inner_dict['field'] = value
    
    
    @property
    def transformer(self) -> Union[None, "IncrementingSegmentFieldTransformerClass"]:
        """Optional transformer function to apply to the field in order to obtain the final segment or bucket identifier.
    If not provided, then no operator will be applied to the field. (identity function)"""
        return self._inner_dict.get('transformer')  # type: ignore
    
    @transformer.setter
    def transformer(self, value: Union[None, "IncrementingSegmentFieldTransformerClass"]) -> None:
        self._inner_dict['transformer'] = value
    
    
class RowCountChangeClass(DictWrapper):
    """Attributes defining a ROW_COUNT_CHANGE volume assertion."""
    
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.assertion.RowCountChange")
    def __init__(self,
        type: Union[str, "AssertionValueChangeTypeClass"],
        operator: Union[str, "AssertionStdOperatorClass"],
        parameters: "AssertionStdParametersClass",
    ):
        super().__init__()
        
        self.type = type
        self.operator = operator
        self.parameters = parameters
    
    def _restore_defaults(self) -> None:
        self.type = AssertionValueChangeTypeClass.ABSOLUTE
        self.operator = AssertionStdOperatorClass.BETWEEN
        self.parameters = AssertionStdParametersClass._construct_with_defaults()
    
    
    @property
    def type(self) -> Union[str, "AssertionValueChangeTypeClass"]:
        """The type of the value used to evaluate the assertion: a fixed absolute value or a relative percentage."""
        return self._inner_dict.get('type')  # type: ignore
    
    @type.setter
    def type(self, value: Union[str, "AssertionValueChangeTypeClass"]) -> None:
        self._inner_dict['type'] = value
    
    
    @property
    def operator(self) -> Union[str, "AssertionStdOperatorClass"]:
        """The operator you'd like to apply.
    
    Note that only numeric operators are valid inputs:
    GREATER_THAN, GREATER_THAN_OR_EQUAL_TO, EQUAL_TO, LESS_THAN, LESS_THAN_OR_EQUAL_TO,
    BETWEEN."""
        return self._inner_dict.get('operator')  # type: ignore
    
    @operator.setter
    def operator(self, value: Union[str, "AssertionStdOperatorClass"]) -> None:
        self._inner_dict['operator'] = value
    
    
    @property
    def parameters(self) -> "AssertionStdParametersClass":
        """The parameters you'd like to provide as input to the operator.
    
    Note that only numeric parameter types are valid inputs: NUMBER."""
        return self._inner_dict.get('parameters')  # type: ignore
    
    @parameters.setter
    def parameters(self, value: "AssertionStdParametersClass") -> None:
        self._inner_dict['parameters'] = value
    
    
class RowCountTotalClass(DictWrapper):
    """Attributes defining a ROW_COUNT_TOTAL volume assertion."""
    
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.assertion.RowCountTotal")
    def __init__(self,
        operator: Union[str, "AssertionStdOperatorClass"],
        parameters: "AssertionStdParametersClass",
    ):
        super().__init__()
        
        self.operator = operator
        self.parameters = parameters
    
    def _restore_defaults(self) -> None:
        self.operator = AssertionStdOperatorClass.BETWEEN
        self.parameters = AssertionStdParametersClass._construct_with_defaults()
    
    
    @property
    def operator(self) -> Union[str, "AssertionStdOperatorClass"]:
        """The operator you'd like to apply.
    
    Note that only numeric operators are valid inputs:
    GREATER_THAN, GREATER_THAN_OR_EQUAL_TO, EQUAL_TO, LESS_THAN, LESS_THAN_OR_EQUAL_TO,
    BETWEEN."""
        return self._inner_dict.get('operator')  # type: ignore
    
    @operator.setter
    def operator(self, value: Union[str, "AssertionStdOperatorClass"]) -> None:
        self._inner_dict['operator'] = value
    
    
    @property
    def parameters(self) -> "AssertionStdParametersClass":
        """The parameters you'd like to provide as input to the operator.
    
    Note that only numeric parameter types are valid inputs: NUMBER."""
        return self._inner_dict.get('parameters')  # type: ignore
    
    @parameters.setter
    def parameters(self, value: "AssertionStdParametersClass") -> None:
        self._inner_dict['parameters'] = value
    
    
class SchemaAssertionInfoClass(DictWrapper):
    """Attributes that are applicable to schema assertions"""
    
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.assertion.SchemaAssertionInfo")
    def __init__(self,
        entity: str,
        schema: "SchemaMetadataClass",
    ):
        super().__init__()
        
        self.entity = entity
        self.schema = schema
    
    def _restore_defaults(self) -> None:
        self.entity = str()
        self.schema = SchemaMetadataClass._construct_with_defaults()
    
    
    @property
    def entity(self) -> str:
        """The entity targeted by the assertion"""
        return self._inner_dict.get('entity')  # type: ignore
    
    @entity.setter
    def entity(self, value: str) -> None:
        self._inner_dict['entity'] = value
    
    
    @property
    def schema(self) -> "SchemaMetadataClass":
        """A definition of the expected structure for the asset
    
    Note that many of the fields of this model, especially those related to metadata (tags, terms)
    will go unused in this context."""
        return self._inner_dict.get('schema')  # type: ignore
    
    @schema.setter
    def schema(self, value: "SchemaMetadataClass") -> None:
        self._inner_dict['schema'] = value
    
    
class SqlAssertionInfoClass(DictWrapper):
    """Attributes defining a SQL Assertion"""
    
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.assertion.SqlAssertionInfo")
    def __init__(self,
        type: Union[str, "SqlAssertionTypeClass"],
        entity: str,
        statement: str,
        operator: Union[str, "AssertionStdOperatorClass"],
        parameters: "AssertionStdParametersClass",
        changeType: Union[None, Union[str, "AssertionValueChangeTypeClass"]]=None,
    ):
        super().__init__()
        
        self.type = type
        self.entity = entity
        self.statement = statement
        self.changeType = changeType
        self.operator = operator
        self.parameters = parameters
    
    def _restore_defaults(self) -> None:
        self.type = SqlAssertionTypeClass.METRIC
        self.entity = str()
        self.statement = str()
        self.changeType = self.RECORD_SCHEMA.fields_dict["changeType"].default
        self.operator = AssertionStdOperatorClass.BETWEEN
        self.parameters = AssertionStdParametersClass._construct_with_defaults()
    
    
    @property
    def type(self) -> Union[str, "SqlAssertionTypeClass"]:
        """The type of the SQL assertion being monitored."""
        return self._inner_dict.get('type')  # type: ignore
    
    @type.setter
    def type(self, value: Union[str, "SqlAssertionTypeClass"]) -> None:
        self._inner_dict['type'] = value
    
    
    @property
    def entity(self) -> str:
        """The entity targeted by this SQL check."""
        return self._inner_dict.get('entity')  # type: ignore
    
    @entity.setter
    def entity(self, value: str) -> None:
        self._inner_dict['entity'] = value
    
    
    @property
    def statement(self) -> str:
        """The SQL statement to be executed when evaluating the assertion (or computing the metric).
    This should be a valid and complete statement, executable by itself.
    
    Usually this should be a SELECT query statement."""
        return self._inner_dict.get('statement')  # type: ignore
    
    @statement.setter
    def statement(self, value: str) -> None:
        self._inner_dict['statement'] = value
    
    
    @property
    def changeType(self) -> Union[None, Union[str, "AssertionValueChangeTypeClass"]]:
        """The type of the value used to evaluate the assertion: a fixed absolute value or a relative percentage.
    This value is required if the type is METRIC_CHANGE."""
        return self._inner_dict.get('changeType')  # type: ignore
    
    @changeType.setter
    def changeType(self, value: Union[None, Union[str, "AssertionValueChangeTypeClass"]]) -> None:
        self._inner_dict['changeType'] = value
    
    
    @property
    def operator(self) -> Union[str, "AssertionStdOperatorClass"]:
        """The operator you'd like to apply to the result of the SQL query.
    
    Note that at this time, only numeric operators are valid inputs:
    GREATER_THAN, GREATER_THAN_OR_EQUAL_TO, EQUAL_TO, LESS_THAN, LESS_THAN_OR_EQUAL_TO,
    BETWEEN."""
        return self._inner_dict.get('operator')  # type: ignore
    
    @operator.setter
    def operator(self, value: Union[str, "AssertionStdOperatorClass"]) -> None:
        self._inner_dict['operator'] = value
    
    
    @property
    def parameters(self) -> "AssertionStdParametersClass":
        """The parameters you'd like to provide as input to the operator.
    
    Note that only numeric parameter types are valid inputs: NUMBER."""
        return self._inner_dict.get('parameters')  # type: ignore
    
    @parameters.setter
    def parameters(self, value: "AssertionStdParametersClass") -> None:
        self._inner_dict['parameters'] = value
    
    
class SqlAssertionTypeClass(object):
    # No docs available.
    
    METRIC = "METRIC"
    """A SQL Metric Assertion, e.g. one based on a numeric value returned by an arbitrary SQL query."""
    
    METRIC_CHANGE = "METRIC_CHANGE"
    """A SQL assertion that is evaluated against the CHANGE in a metric assertion
    over time."""
    
    
    
class VolumeAssertionInfoClass(DictWrapper):
    """Attributes defining a dataset Volume Assertion"""
    
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.assertion.VolumeAssertionInfo")
    def __init__(self,
        type: Union[str, "VolumeAssertionTypeClass"],
        entity: str,
        rowCountTotal: Union[None, "RowCountTotalClass"]=None,
        rowCountChange: Union[None, "RowCountChangeClass"]=None,
        incrementingSegmentRowCountTotal: Union[None, "IncrementingSegmentRowCountTotalClass"]=None,
        incrementingSegmentRowCountChange: Union[None, "IncrementingSegmentRowCountChangeClass"]=None,
        filter: Union[None, "DatasetFilterClass"]=None,
    ):
        super().__init__()
        
        self.type = type
        self.entity = entity
        self.rowCountTotal = rowCountTotal
        self.rowCountChange = rowCountChange
        self.incrementingSegmentRowCountTotal = incrementingSegmentRowCountTotal
        self.incrementingSegmentRowCountChange = incrementingSegmentRowCountChange
        self.filter = filter
    
    def _restore_defaults(self) -> None:
        self.type = VolumeAssertionTypeClass.ROW_COUNT_TOTAL
        self.entity = str()
        self.rowCountTotal = self.RECORD_SCHEMA.fields_dict["rowCountTotal"].default
        self.rowCountChange = self.RECORD_SCHEMA.fields_dict["rowCountChange"].default
        self.incrementingSegmentRowCountTotal = self.RECORD_SCHEMA.fields_dict["incrementingSegmentRowCountTotal"].default
        self.incrementingSegmentRowCountChange = self.RECORD_SCHEMA.fields_dict["incrementingSegmentRowCountChange"].default
        self.filter = self.RECORD_SCHEMA.fields_dict["filter"].default
    
    
    @property
    def type(self) -> Union[str, "VolumeAssertionTypeClass"]:
        """The type of the freshness assertion being monitored."""
        return self._inner_dict.get('type')  # type: ignore
    
    @type.setter
    def type(self, value: Union[str, "VolumeAssertionTypeClass"]) -> None:
        self._inner_dict['type'] = value
    
    
    @property
    def entity(self) -> str:
        """The entity targeted by this Volume check."""
        return self._inner_dict.get('entity')  # type: ignore
    
    @entity.setter
    def entity(self, value: str) -> None:
        self._inner_dict['entity'] = value
    
    
    @property
    def rowCountTotal(self) -> Union[None, "RowCountTotalClass"]:
        """Produce FAILURE Assertion Result if the row count of the asset does not meet specific requirements.
    Required if type is 'ROW_COUNT_TOTAL'"""
        return self._inner_dict.get('rowCountTotal')  # type: ignore
    
    @rowCountTotal.setter
    def rowCountTotal(self, value: Union[None, "RowCountTotalClass"]) -> None:
        self._inner_dict['rowCountTotal'] = value
    
    
    @property
    def rowCountChange(self) -> Union[None, "RowCountChangeClass"]:
        """Produce FAILURE Assertion Result if the delta row count of the asset does not meet specific requirements
    within a given period of time.
    Required if type is 'ROW_COUNT_CHANGE'"""
        return self._inner_dict.get('rowCountChange')  # type: ignore
    
    @rowCountChange.setter
    def rowCountChange(self, value: Union[None, "RowCountChangeClass"]) -> None:
        self._inner_dict['rowCountChange'] = value
    
    
    @property
    def incrementingSegmentRowCountTotal(self) -> Union[None, "IncrementingSegmentRowCountTotalClass"]:
        """Produce FAILURE Assertion Result if the asset's latest incrementing segment row count total
    does not meet specific requirements. Required if type is 'INCREMENTING_SEGMENT_ROW_COUNT_TOTAL'"""
        return self._inner_dict.get('incrementingSegmentRowCountTotal')  # type: ignore
    
    @incrementingSegmentRowCountTotal.setter
    def incrementingSegmentRowCountTotal(self, value: Union[None, "IncrementingSegmentRowCountTotalClass"]) -> None:
        self._inner_dict['incrementingSegmentRowCountTotal'] = value
    
    
    @property
    def incrementingSegmentRowCountChange(self) -> Union[None, "IncrementingSegmentRowCountChangeClass"]:
        """Produce FAILURE Assertion Result if the asset's incrementing segment row count delta
    does not meet specific requirements. Required if type is 'INCREMENTING_SEGMENT_ROW_COUNT_CHANGE'"""
        return self._inner_dict.get('incrementingSegmentRowCountChange')  # type: ignore
    
    @incrementingSegmentRowCountChange.setter
    def incrementingSegmentRowCountChange(self, value: Union[None, "IncrementingSegmentRowCountChangeClass"]) -> None:
        self._inner_dict['incrementingSegmentRowCountChange'] = value
    
    
    @property
    def filter(self) -> Union[None, "DatasetFilterClass"]:
        """A definition of the specific filters that should be applied, when performing monitoring.
    If not provided, there is no filter, and the full table is under consideration."""
        return self._inner_dict.get('filter')  # type: ignore
    
    @filter.setter
    def filter(self, value: Union[None, "DatasetFilterClass"]) -> None:
        self._inner_dict['filter'] = value
    
    
class VolumeAssertionTypeClass(object):
    # No docs available.
    
    ROW_COUNT_TOTAL = "ROW_COUNT_TOTAL"
    """A volume assertion that is evaluated against the total row count of a dataset."""
    
    ROW_COUNT_CHANGE = "ROW_COUNT_CHANGE"
    """A volume assertion that is evaluated against an incremental row count of a dataset,
    or a row count change."""
    
    INCREMENTING_SEGMENT_ROW_COUNT_TOTAL = "INCREMENTING_SEGMENT_ROW_COUNT_TOTAL"
    """A volume assertion that checks the latest "segment" in a table based on an incrementing
    column to check whether it's row count falls into a particular range.
    
    This can be used to monitor the row count of an incrementing date-partition column segment."""
    
    INCREMENTING_SEGMENT_ROW_COUNT_CHANGE = "INCREMENTING_SEGMENT_ROW_COUNT_CHANGE"
    """A volume assertion that compares the row counts in neighboring "segments" or "partitions"
    of an incrementing column.
    This can be used to track changes between subsequent date partition
    in a table, for example."""
    
    
    
class ChartInfoClass(_Aspect):
    """Information about a chart"""


    ASPECT_NAME = 'chartInfo'
    ASPECT_INFO = {}
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.chart.ChartInfo")

    def __init__(self,
        title: str,
        description: str,
        lastModified: "ChangeAuditStampsClass",
        customProperties: Optional[Dict[str, str]]=None,
        externalUrl: Union[None, str]=None,
        chartUrl: Union[None, str]=None,
        inputs: Union[None, List[str]]=None,
        inputEdges: Union[None, List["EdgeClass"]]=None,
        type: Union[None, Union[str, "ChartTypeClass"]]=None,
        access: Union[None, Union[str, "AccessLevelClass"]]=None,
        lastRefreshed: Union[None, int]=None,
    ):
        super().__init__()
        
        if customProperties is None:
            # default: {}
            self.customProperties = dict()
        else:
            self.customProperties = customProperties
        self.externalUrl = externalUrl
        self.title = title
        self.description = description
        self.lastModified = lastModified
        self.chartUrl = chartUrl
        self.inputs = inputs
        self.inputEdges = inputEdges
        self.type = type
        self.access = access
        self.lastRefreshed = lastRefreshed
    
    def _restore_defaults(self) -> None:
        self.customProperties = dict()
        self.externalUrl = self.RECORD_SCHEMA.fields_dict["externalUrl"].default
        self.title = str()
        self.description = str()
        self.lastModified = ChangeAuditStampsClass._construct_with_defaults()
        self.chartUrl = self.RECORD_SCHEMA.fields_dict["chartUrl"].default
        self.inputs = self.RECORD_SCHEMA.fields_dict["inputs"].default
        self.inputEdges = self.RECORD_SCHEMA.fields_dict["inputEdges"].default
        self.type = self.RECORD_SCHEMA.fields_dict["type"].default
        self.access = self.RECORD_SCHEMA.fields_dict["access"].default
        self.lastRefreshed = self.RECORD_SCHEMA.fields_dict["lastRefreshed"].default
    
    
    @property
    def customProperties(self) -> Dict[str, str]:
        """Custom property bag."""
        return self._inner_dict.get('customProperties')  # type: ignore
    
    @customProperties.setter
    def customProperties(self, value: Dict[str, str]) -> None:
        self._inner_dict['customProperties'] = value
    
    
    @property
    def externalUrl(self) -> Union[None, str]:
        """URL where the reference exist"""
        return self._inner_dict.get('externalUrl')  # type: ignore
    
    @externalUrl.setter
    def externalUrl(self, value: Union[None, str]) -> None:
        self._inner_dict['externalUrl'] = value
    
    
    @property
    def title(self) -> str:
        """Title of the chart"""
        return self._inner_dict.get('title')  # type: ignore
    
    @title.setter
    def title(self, value: str) -> None:
        self._inner_dict['title'] = value
    
    
    @property
    def description(self) -> str:
        """Detailed description about the chart"""
        return self._inner_dict.get('description')  # type: ignore
    
    @description.setter
    def description(self, value: str) -> None:
        self._inner_dict['description'] = value
    
    
    @property
    def lastModified(self) -> "ChangeAuditStampsClass":
        """Captures information about who created/last modified/deleted this chart and when"""
        return self._inner_dict.get('lastModified')  # type: ignore
    
    @lastModified.setter
    def lastModified(self, value: "ChangeAuditStampsClass") -> None:
        self._inner_dict['lastModified'] = value
    
    
    @property
    def chartUrl(self) -> Union[None, str]:
        """URL for the chart. This could be used as an external link on DataHub to allow users access/view the chart"""
        return self._inner_dict.get('chartUrl')  # type: ignore
    
    @chartUrl.setter
    def chartUrl(self, value: Union[None, str]) -> None:
        self._inner_dict['chartUrl'] = value
    
    
    @property
    def inputs(self) -> Union[None, List[str]]:
        """Data sources for the chart
    Deprecated! Use inputEdges instead."""
        return self._inner_dict.get('inputs')  # type: ignore
    
    @inputs.setter
    def inputs(self, value: Union[None, List[str]]) -> None:
        self._inner_dict['inputs'] = value
    
    
    @property
    def inputEdges(self) -> Union[None, List["EdgeClass"]]:
        """Data sources for the chart"""
        return self._inner_dict.get('inputEdges')  # type: ignore
    
    @inputEdges.setter
    def inputEdges(self, value: Union[None, List["EdgeClass"]]) -> None:
        self._inner_dict['inputEdges'] = value
    
    
    @property
    def type(self) -> Union[None, Union[str, "ChartTypeClass"]]:
        """Type of the chart"""
        return self._inner_dict.get('type')  # type: ignore
    
    @type.setter
    def type(self, value: Union[None, Union[str, "ChartTypeClass"]]) -> None:
        self._inner_dict['type'] = value
    
    
    @property
    def access(self) -> Union[None, Union[str, "AccessLevelClass"]]:
        """Access level for the chart"""
        return self._inner_dict.get('access')  # type: ignore
    
    @access.setter
    def access(self, value: Union[None, Union[str, "AccessLevelClass"]]) -> None:
        self._inner_dict['access'] = value
    
    
    @property
    def lastRefreshed(self) -> Union[None, int]:
        """The time when this chart last refreshed"""
        return self._inner_dict.get('lastRefreshed')  # type: ignore
    
    @lastRefreshed.setter
    def lastRefreshed(self, value: Union[None, int]) -> None:
        self._inner_dict['lastRefreshed'] = value
    
    
class ChartQueryClass(_Aspect):
    """Information for chart query which is used for getting data of the chart"""


    ASPECT_NAME = 'chartQuery'
    ASPECT_INFO = {}
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.chart.ChartQuery")

    def __init__(self,
        rawQuery: str,
        type: Union[str, "ChartQueryTypeClass"],
    ):
        super().__init__()
        
        self.rawQuery = rawQuery
        self.type = type
    
    def _restore_defaults(self) -> None:
        self.rawQuery = str()
        self.type = ChartQueryTypeClass.LOOKML
    
    
    @property
    def rawQuery(self) -> str:
        """Raw query to build a chart from input datasets"""
        return self._inner_dict.get('rawQuery')  # type: ignore
    
    @rawQuery.setter
    def rawQuery(self, value: str) -> None:
        self._inner_dict['rawQuery'] = value
    
    
    @property
    def type(self) -> Union[str, "ChartQueryTypeClass"]:
        """Chart query type"""
        return self._inner_dict.get('type')  # type: ignore
    
    @type.setter
    def type(self, value: Union[str, "ChartQueryTypeClass"]) -> None:
        self._inner_dict['type'] = value
    
    
class ChartQueryTypeClass(object):
    # No docs available.
    
    LOOKML = "LOOKML"
    """LookML queries"""
    
    SQL = "SQL"
    """SQL type queries"""
    
    
    
class ChartTypeClass(object):
    """The various types of charts"""
    
    BAR = "BAR"
    """Chart showing a Bar chart"""
    
    PIE = "PIE"
    """Chart showing a Pie chart"""
    
    SCATTER = "SCATTER"
    """Chart showing a Scatter plot"""
    
    TABLE = "TABLE"
    """Chart showing a table"""
    
    TEXT = "TEXT"
    """Chart showing Markdown formatted text"""
    
    LINE = "LINE"
    
    AREA = "AREA"
    
    HISTOGRAM = "HISTOGRAM"
    
    BOX_PLOT = "BOX_PLOT"
    
    WORD_CLOUD = "WORD_CLOUD"
    
    COHORT = "COHORT"
    
    
    
class ChartUsageStatisticsClass(_Aspect):
    """Experimental (Subject to breaking change) -- Stats corresponding to chart's usage.
    
    If this aspect represents the latest snapshot of the statistics about a Chart, the eventGranularity field should be null.
    If this aspect represents a bucketed window of usage statistics (e.g. over a day), then the eventGranularity field should be set accordingly."""


    ASPECT_NAME = 'chartUsageStatistics'
    ASPECT_TYPE = 'timeseries'
    ASPECT_INFO = {}
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.chart.ChartUsageStatistics")

    def __init__(self,
        timestampMillis: int,
        eventGranularity: Union[None, "TimeWindowSizeClass"]=None,
        partitionSpec: Optional[Union["PartitionSpecClass", None]]=None,
        messageId: Union[None, str]=None,
        viewsCount: Union[None, int]=None,
        uniqueUserCount: Union[None, int]=None,
        userCounts: Union[None, List["ChartUserUsageCountsClass"]]=None,
    ):
        super().__init__()
        
        self.timestampMillis = timestampMillis
        self.eventGranularity = eventGranularity
        if partitionSpec is None:
            # default: {'partition': 'FULL_TABLE_SNAPSHOT', 'type': 'FULL_TABLE', 'timePartition': None}
            self.partitionSpec = _json_converter.from_json_object(self.RECORD_SCHEMA.fields_dict["partitionSpec"].default, writers_schema=self.RECORD_SCHEMA.fields_dict["partitionSpec"].type)
        else:
            self.partitionSpec = partitionSpec
        self.messageId = messageId
        self.viewsCount = viewsCount
        self.uniqueUserCount = uniqueUserCount
        self.userCounts = userCounts
    
    def _restore_defaults(self) -> None:
        self.timestampMillis = int()
        self.eventGranularity = self.RECORD_SCHEMA.fields_dict["eventGranularity"].default
        self.partitionSpec = _json_converter.from_json_object(self.RECORD_SCHEMA.fields_dict["partitionSpec"].default, writers_schema=self.RECORD_SCHEMA.fields_dict["partitionSpec"].type)
        self.messageId = self.RECORD_SCHEMA.fields_dict["messageId"].default
        self.viewsCount = self.RECORD_SCHEMA.fields_dict["viewsCount"].default
        self.uniqueUserCount = self.RECORD_SCHEMA.fields_dict["uniqueUserCount"].default
        self.userCounts = self.RECORD_SCHEMA.fields_dict["userCounts"].default
    
    
    @property
    def timestampMillis(self) -> int:
        """The event timestamp field as epoch at UTC in milli seconds."""
        return self._inner_dict.get('timestampMillis')  # type: ignore
    
    @timestampMillis.setter
    def timestampMillis(self, value: int) -> None:
        self._inner_dict['timestampMillis'] = value
    
    
    @property
    def eventGranularity(self) -> Union[None, "TimeWindowSizeClass"]:
        """Granularity of the event if applicable"""
        return self._inner_dict.get('eventGranularity')  # type: ignore
    
    @eventGranularity.setter
    def eventGranularity(self, value: Union[None, "TimeWindowSizeClass"]) -> None:
        self._inner_dict['eventGranularity'] = value
    
    
    @property
    def partitionSpec(self) -> Union["PartitionSpecClass", None]:
        """The optional partition specification."""
        return self._inner_dict.get('partitionSpec')  # type: ignore
    
    @partitionSpec.setter
    def partitionSpec(self, value: Union["PartitionSpecClass", None]) -> None:
        self._inner_dict['partitionSpec'] = value
    
    
    @property
    def messageId(self) -> Union[None, str]:
        """The optional messageId, if provided serves as a custom user-defined unique identifier for an aspect value."""
        return self._inner_dict.get('messageId')  # type: ignore
    
    @messageId.setter
    def messageId(self, value: Union[None, str]) -> None:
        self._inner_dict['messageId'] = value
    
    
    @property
    def viewsCount(self) -> Union[None, int]:
        """The total number of times chart has been viewed"""
        return self._inner_dict.get('viewsCount')  # type: ignore
    
    @viewsCount.setter
    def viewsCount(self, value: Union[None, int]) -> None:
        self._inner_dict['viewsCount'] = value
    
    
    @property
    def uniqueUserCount(self) -> Union[None, int]:
        """Unique user count"""
        return self._inner_dict.get('uniqueUserCount')  # type: ignore
    
    @uniqueUserCount.setter
    def uniqueUserCount(self, value: Union[None, int]) -> None:
        self._inner_dict['uniqueUserCount'] = value
    
    
    @property
    def userCounts(self) -> Union[None, List["ChartUserUsageCountsClass"]]:
        """Users within this bucket, with frequency counts"""
        return self._inner_dict.get('userCounts')  # type: ignore
    
    @userCounts.setter
    def userCounts(self, value: Union[None, List["ChartUserUsageCountsClass"]]) -> None:
        self._inner_dict['userCounts'] = value
    
    
class ChartUserUsageCountsClass(DictWrapper):
    """Records a single user's usage counts for a given resource"""
    
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.chart.ChartUserUsageCounts")
    def __init__(self,
        user: str,
        viewsCount: Union[None, int]=None,
    ):
        super().__init__()
        
        self.user = user
        self.viewsCount = viewsCount
    
    def _restore_defaults(self) -> None:
        self.user = str()
        self.viewsCount = self.RECORD_SCHEMA.fields_dict["viewsCount"].default
    
    
    @property
    def user(self) -> str:
        """The unique id of the user."""
        return self._inner_dict.get('user')  # type: ignore
    
    @user.setter
    def user(self, value: str) -> None:
        self._inner_dict['user'] = value
    
    
    @property
    def viewsCount(self) -> Union[None, int]:
        """The number of times the user has viewed the chart"""
        return self._inner_dict.get('viewsCount')  # type: ignore
    
    @viewsCount.setter
    def viewsCount(self, value: Union[None, int]) -> None:
        self._inner_dict['viewsCount'] = value
    
    
class EditableChartPropertiesClass(_Aspect):
    """Stores editable changes made to properties. This separates changes made from
    ingestion pipelines and edits in the UI to avoid accidental overwrites of user-provided data by ingestion pipelines"""


    ASPECT_NAME = 'editableChartProperties'
    ASPECT_INFO = {}
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.chart.EditableChartProperties")

    def __init__(self,
        created: Optional["AuditStampClass"]=None,
        lastModified: Optional["AuditStampClass"]=None,
        deleted: Union[None, "AuditStampClass"]=None,
        description: Union[None, str]=None,
    ):
        super().__init__()
        
        if created is None:
            # default: {'actor': 'urn:li:corpuser:unknown', 'impersonator': None, 'time': 0, 'message': None}
            self.created = _json_converter.from_json_object(self.RECORD_SCHEMA.fields_dict["created"].default, writers_schema=self.RECORD_SCHEMA.fields_dict["created"].type)
        else:
            self.created = created
        if lastModified is None:
            # default: {'actor': 'urn:li:corpuser:unknown', 'impersonator': None, 'time': 0, 'message': None}
            self.lastModified = _json_converter.from_json_object(self.RECORD_SCHEMA.fields_dict["lastModified"].default, writers_schema=self.RECORD_SCHEMA.fields_dict["lastModified"].type)
        else:
            self.lastModified = lastModified
        self.deleted = deleted
        self.description = description
    
    def _restore_defaults(self) -> None:
        self.created = _json_converter.from_json_object(self.RECORD_SCHEMA.fields_dict["created"].default, writers_schema=self.RECORD_SCHEMA.fields_dict["created"].type)
        self.lastModified = _json_converter.from_json_object(self.RECORD_SCHEMA.fields_dict["lastModified"].default, writers_schema=self.RECORD_SCHEMA.fields_dict["lastModified"].type)
        self.deleted = self.RECORD_SCHEMA.fields_dict["deleted"].default
        self.description = self.RECORD_SCHEMA.fields_dict["description"].default
    
    
    @property
    def created(self) -> "AuditStampClass":
        """An AuditStamp corresponding to the creation of this resource/association/sub-resource. A value of 0 for time indicates missing data."""
        return self._inner_dict.get('created')  # type: ignore
    
    @created.setter
    def created(self, value: "AuditStampClass") -> None:
        self._inner_dict['created'] = value
    
    
    @property
    def lastModified(self) -> "AuditStampClass":
        """An AuditStamp corresponding to the last modification of this resource/association/sub-resource. If no modification has happened since creation, lastModified should be the same as created. A value of 0 for time indicates missing data."""
        return self._inner_dict.get('lastModified')  # type: ignore
    
    @lastModified.setter
    def lastModified(self, value: "AuditStampClass") -> None:
        self._inner_dict['lastModified'] = value
    
    
    @property
    def deleted(self) -> Union[None, "AuditStampClass"]:
        """An AuditStamp corresponding to the deletion of this resource/association/sub-resource. Logically, deleted MUST have a later timestamp than creation. It may or may not have the same time as lastModified depending upon the resource/association/sub-resource semantics."""
        return self._inner_dict.get('deleted')  # type: ignore
    
    @deleted.setter
    def deleted(self, value: Union[None, "AuditStampClass"]) -> None:
        self._inner_dict['deleted'] = value
    
    
    @property
    def description(self) -> Union[None, str]:
        """Edited documentation of the chart """
        return self._inner_dict.get('description')  # type: ignore
    
    @description.setter
    def description(self, value: Union[None, str]) -> None:
        self._inner_dict['description'] = value
    
    
class AccessClass(_Aspect):
    """Aspect used for associating roles to a dataset or any asset"""


    ASPECT_NAME = 'access'
    ASPECT_INFO = {}
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.common.Access")

    def __init__(self,
        roles: Union[None, List["RoleAssociationClass"]]=None,
    ):
        super().__init__()
        
        self.roles = roles
    
    def _restore_defaults(self) -> None:
        self.roles = self.RECORD_SCHEMA.fields_dict["roles"].default
    
    
    @property
    def roles(self) -> Union[None, List["RoleAssociationClass"]]:
        """List of Roles which needs to be associated"""
        return self._inner_dict.get('roles')  # type: ignore
    
    @roles.setter
    def roles(self, value: Union[None, List["RoleAssociationClass"]]) -> None:
        self._inner_dict['roles'] = value
    
    
class AccessLevelClass(object):
    """The various access levels"""
    
    PUBLIC = "PUBLIC"
    """Publicly available access level"""
    
    PRIVATE = "PRIVATE"
    """Private availability to certain set of users"""
    
    
    
class AuditStampClass(DictWrapper):
    """Data captured on a resource/association/sub-resource level giving insight into when that resource/association/sub-resource moved into a particular lifecycle stage, and who acted to move it into that specific lifecycle stage."""
    
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.common.AuditStamp")
    def __init__(self,
        time: int,
        actor: str,
        impersonator: Union[None, str]=None,
        message: Union[None, str]=None,
    ):
        super().__init__()
        
        self.time = time
        self.actor = actor
        self.impersonator = impersonator
        self.message = message
    
    def _restore_defaults(self) -> None:
        self.time = int()
        self.actor = str()
        self.impersonator = self.RECORD_SCHEMA.fields_dict["impersonator"].default
        self.message = self.RECORD_SCHEMA.fields_dict["message"].default
    
    
    @property
    def time(self) -> int:
        """When did the resource/association/sub-resource move into the specific lifecycle stage represented by this AuditEvent."""
        return self._inner_dict.get('time')  # type: ignore
    
    @time.setter
    def time(self, value: int) -> None:
        self._inner_dict['time'] = value
    
    
    @property
    def actor(self) -> str:
        """The entity (e.g. a member URN) which will be credited for moving the resource/association/sub-resource into the specific lifecycle stage. It is also the one used to authorize the change."""
        return self._inner_dict.get('actor')  # type: ignore
    
    @actor.setter
    def actor(self, value: str) -> None:
        self._inner_dict['actor'] = value
    
    
    @property
    def impersonator(self) -> Union[None, str]:
        """The entity (e.g. a service URN) which performs the change on behalf of the Actor and must be authorized to act as the Actor."""
        return self._inner_dict.get('impersonator')  # type: ignore
    
    @impersonator.setter
    def impersonator(self, value: Union[None, str]) -> None:
        self._inner_dict['impersonator'] = value
    
    
    @property
    def message(self) -> Union[None, str]:
        """Additional context around how DataHub was informed of the particular change. For example: was the change created by an automated process, or manually."""
        return self._inner_dict.get('message')  # type: ignore
    
    @message.setter
    def message(self, value: Union[None, str]) -> None:
        self._inner_dict['message'] = value
    
    
class BrowsePathEntryClass(DictWrapper):
    """Represents a single level in an entity's browsePathV2"""
    
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.common.BrowsePathEntry")
    def __init__(self,
        id: str,
        urn: Union[None, str]=None,
    ):
        super().__init__()
        
        self.id = id
        self.urn = urn
    
    def _restore_defaults(self) -> None:
        self.id = str()
        self.urn = self.RECORD_SCHEMA.fields_dict["urn"].default
    
    
    @property
    def id(self) -> str:
        """The ID of the browse path entry. This is what gets stored in the index.
    If there's an urn associated with this entry, id and urn will be the same"""
        return self._inner_dict.get('id')  # type: ignore
    
    @id.setter
    def id(self, value: str) -> None:
        self._inner_dict['id'] = value
    
    
    @property
    def urn(self) -> Union[None, str]:
        """Optional urn pointing to some entity in DataHub"""
        return self._inner_dict.get('urn')  # type: ignore
    
    @urn.setter
    def urn(self, value: Union[None, str]) -> None:
        self._inner_dict['urn'] = value
    
    
class BrowsePathsClass(_Aspect):
    """Shared aspect containing Browse Paths to be indexed for an entity."""


    ASPECT_NAME = 'browsePaths'
    ASPECT_INFO = {}
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.common.BrowsePaths")

    def __init__(self,
        paths: List[str],
    ):
        super().__init__()
        
        self.paths = paths
    
    def _restore_defaults(self) -> None:
        self.paths = list()
    
    
    @property
    def paths(self) -> List[str]:
        """A list of valid browse paths for the entity.
    
    Browse paths are expected to be forward slash-separated strings. For example: 'prod/snowflake/datasetName'"""
        return self._inner_dict.get('paths')  # type: ignore
    
    @paths.setter
    def paths(self, value: List[str]) -> None:
        self._inner_dict['paths'] = value
    
    
class BrowsePathsV2Class(_Aspect):
    """Shared aspect containing a Browse Path to be indexed for an entity."""


    ASPECT_NAME = 'browsePathsV2'
    ASPECT_INFO = {}
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.common.BrowsePathsV2")

    def __init__(self,
        path: List["BrowsePathEntryClass"],
    ):
        super().__init__()
        
        self.path = path
    
    def _restore_defaults(self) -> None:
        self.path = list()
    
    
    @property
    def path(self) -> List["BrowsePathEntryClass"]:
        """A valid browse path for the entity. This field is provided by DataHub by default.
    This aspect is a newer version of browsePaths where we can encode more information in the path.
    This path is also based on containers for a given entity if it has containers.
    
    This is stored in elasticsearch as unit-separator delimited strings and only includes platform specific folders or containers.
    These paths should not include high level info captured elsewhere ie. Platform and Environment."""
        return self._inner_dict.get('path')  # type: ignore
    
    @path.setter
    def path(self, value: List["BrowsePathEntryClass"]) -> None:
        self._inner_dict['path'] = value
    
    
class ChangeAuditStampsClass(DictWrapper):
    """Data captured on a resource/association/sub-resource level giving insight into when that resource/association/sub-resource moved into various lifecycle stages, and who acted to move it into those lifecycle stages. The recommended best practice is to include this record in your record schema, and annotate its fields as @readOnly in your resource. See https://github.com/linkedin/rest.li/wiki/Validation-in-Rest.li#restli-validation-annotations"""
    
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.common.ChangeAuditStamps")
    def __init__(self,
        created: Optional["AuditStampClass"]=None,
        lastModified: Optional["AuditStampClass"]=None,
        deleted: Union[None, "AuditStampClass"]=None,
    ):
        super().__init__()
        
        if created is None:
            # default: {'actor': 'urn:li:corpuser:unknown', 'impersonator': None, 'time': 0, 'message': None}
            self.created = _json_converter.from_json_object(self.RECORD_SCHEMA.fields_dict["created"].default, writers_schema=self.RECORD_SCHEMA.fields_dict["created"].type)
        else:
            self.created = created
        if lastModified is None:
            # default: {'actor': 'urn:li:corpuser:unknown', 'impersonator': None, 'time': 0, 'message': None}
            self.lastModified = _json_converter.from_json_object(self.RECORD_SCHEMA.fields_dict["lastModified"].default, writers_schema=self.RECORD_SCHEMA.fields_dict["lastModified"].type)
        else:
            self.lastModified = lastModified
        self.deleted = deleted
    
    def _restore_defaults(self) -> None:
        self.created = _json_converter.from_json_object(self.RECORD_SCHEMA.fields_dict["created"].default, writers_schema=self.RECORD_SCHEMA.fields_dict["created"].type)
        self.lastModified = _json_converter.from_json_object(self.RECORD_SCHEMA.fields_dict["lastModified"].default, writers_schema=self.RECORD_SCHEMA.fields_dict["lastModified"].type)
        self.deleted = self.RECORD_SCHEMA.fields_dict["deleted"].default
    
    
    @property
    def created(self) -> "AuditStampClass":
        """An AuditStamp corresponding to the creation of this resource/association/sub-resource. A value of 0 for time indicates missing data."""
        return self._inner_dict.get('created')  # type: ignore
    
    @created.setter
    def created(self, value: "AuditStampClass") -> None:
        self._inner_dict['created'] = value
    
    
    @property
    def lastModified(self) -> "AuditStampClass":
        """An AuditStamp corresponding to the last modification of this resource/association/sub-resource. If no modification has happened since creation, lastModified should be the same as created. A value of 0 for time indicates missing data."""
        return self._inner_dict.get('lastModified')  # type: ignore
    
    @lastModified.setter
    def lastModified(self, value: "AuditStampClass") -> None:
        self._inner_dict['lastModified'] = value
    
    
    @property
    def deleted(self) -> Union[None, "AuditStampClass"]:
        """An AuditStamp corresponding to the deletion of this resource/association/sub-resource. Logically, deleted MUST have a later timestamp than creation. It may or may not have the same time as lastModified depending upon the resource/association/sub-resource semantics."""
        return self._inner_dict.get('deleted')  # type: ignore
    
    @deleted.setter
    def deleted(self, value: Union[None, "AuditStampClass"]) -> None:
        self._inner_dict['deleted'] = value
    
    
class CostClass(_Aspect):
    # No docs available.


    ASPECT_NAME = 'cost'
    ASPECT_INFO = {}
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.common.Cost")

    def __init__(self,
        costType: Union[str, "CostTypeClass"],
        cost: "CostCostClass",
    ):
        super().__init__()
        
        self.costType = costType
        self.cost = cost
    
    def _restore_defaults(self) -> None:
        self.costType = CostTypeClass.ORG_COST_TYPE
        self.cost = CostCostClass._construct_with_defaults()
    
    
    @property
    def costType(self) -> Union[str, "CostTypeClass"]:
        # No docs available.
        return self._inner_dict.get('costType')  # type: ignore
    
    @costType.setter
    def costType(self, value: Union[str, "CostTypeClass"]) -> None:
        self._inner_dict['costType'] = value
    
    
    @property
    def cost(self) -> "CostCostClass":
        # No docs available.
        return self._inner_dict.get('cost')  # type: ignore
    
    @cost.setter
    def cost(self, value: "CostCostClass") -> None:
        self._inner_dict['cost'] = value
    
    
class CostCostClass(DictWrapper):
    # No docs available.
    
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.common.CostCost")
    def __init__(self,
        fieldDiscriminator: Union[str, "CostCostDiscriminatorClass"],
        costId: Union[None, float]=None,
        costCode: Union[None, str]=None,
    ):
        super().__init__()
        
        self.costId = costId
        self.costCode = costCode
        self.fieldDiscriminator = fieldDiscriminator
    
    def _restore_defaults(self) -> None:
        self.costId = self.RECORD_SCHEMA.fields_dict["costId"].default
        self.costCode = self.RECORD_SCHEMA.fields_dict["costCode"].default
        self.fieldDiscriminator = CostCostDiscriminatorClass.costId
    
    
    @property
    def costId(self) -> Union[None, float]:
        # No docs available.
        return self._inner_dict.get('costId')  # type: ignore
    
    @costId.setter
    def costId(self, value: Union[None, float]) -> None:
        self._inner_dict['costId'] = value
    
    
    @property
    def costCode(self) -> Union[None, str]:
        # No docs available.
        return self._inner_dict.get('costCode')  # type: ignore
    
    @costCode.setter
    def costCode(self, value: Union[None, str]) -> None:
        self._inner_dict['costCode'] = value
    
    
    @property
    def fieldDiscriminator(self) -> Union[str, "CostCostDiscriminatorClass"]:
        """Contains the name of the field that has its value set."""
        return self._inner_dict.get('fieldDiscriminator')  # type: ignore
    
    @fieldDiscriminator.setter
    def fieldDiscriminator(self, value: Union[str, "CostCostDiscriminatorClass"]) -> None:
        self._inner_dict['fieldDiscriminator'] = value
    
    
class CostCostDiscriminatorClass(object):
    # No docs available.
    
    costId = "costId"
    costCode = "costCode"
    
    
class CostTypeClass(object):
    """Type of Cost Code"""
    
    ORG_COST_TYPE = "ORG_COST_TYPE"
    """Org Cost Type to which the Cost of this entity should be attributed to"""
    
    
    
class DataPlatformInstanceClass(_Aspect):
    """The specific instance of the data platform that this entity belongs to"""


    ASPECT_NAME = 'dataPlatformInstance'
    ASPECT_INFO = {}
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.common.DataPlatformInstance")

    def __init__(self,
        platform: str,
        instance: Union[None, str]=None,
    ):
        super().__init__()
        
        self.platform = platform
        self.instance = instance
    
    def _restore_defaults(self) -> None:
        self.platform = str()
        self.instance = self.RECORD_SCHEMA.fields_dict["instance"].default
    
    
    @property
    def platform(self) -> str:
        """Data Platform"""
        return self._inner_dict.get('platform')  # type: ignore
    
    @platform.setter
    def platform(self, value: str) -> None:
        self._inner_dict['platform'] = value
    
    
    @property
    def instance(self) -> Union[None, str]:
        """Instance of the data platform (e.g. db instance)"""
        return self._inner_dict.get('instance')  # type: ignore
    
    @instance.setter
    def instance(self, value: Union[None, str]) -> None:
        self._inner_dict['instance'] = value
    
    
class DeprecationClass(_Aspect):
    """Deprecation status of an entity"""


    ASPECT_NAME = 'deprecation'
    ASPECT_INFO = {}
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.common.Deprecation")

    def __init__(self,
        deprecated: bool,
        note: str,
        actor: str,
        decommissionTime: Union[None, int]=None,
    ):
        super().__init__()
        
        self.deprecated = deprecated
        self.decommissionTime = decommissionTime
        self.note = note
        self.actor = actor
    
    def _restore_defaults(self) -> None:
        self.deprecated = bool()
        self.decommissionTime = self.RECORD_SCHEMA.fields_dict["decommissionTime"].default
        self.note = str()
        self.actor = str()
    
    
    @property
    def deprecated(self) -> bool:
        """Whether the entity is deprecated."""
        return self._inner_dict.get('deprecated')  # type: ignore
    
    @deprecated.setter
    def deprecated(self, value: bool) -> None:
        self._inner_dict['deprecated'] = value
    
    
    @property
    def decommissionTime(self) -> Union[None, int]:
        """The time user plan to decommission this entity."""
        return self._inner_dict.get('decommissionTime')  # type: ignore
    
    @decommissionTime.setter
    def decommissionTime(self, value: Union[None, int]) -> None:
        self._inner_dict['decommissionTime'] = value
    
    
    @property
    def note(self) -> str:
        """Additional information about the entity deprecation plan, such as the wiki, doc, RB."""
        return self._inner_dict.get('note')  # type: ignore
    
    @note.setter
    def note(self, value: str) -> None:
        self._inner_dict['note'] = value
    
    
    @property
    def actor(self) -> str:
        """The user URN which will be credited for modifying this deprecation content."""
        return self._inner_dict.get('actor')  # type: ignore
    
    @actor.setter
    def actor(self, value: str) -> None:
        self._inner_dict['actor'] = value
    
    
class EdgeClass(DictWrapper):
    """A common structure to represent all edges to entities when used inside aspects as collections
    This ensures that all edges have common structure around audit-stamps and will support PATCH, time-travel automatically."""
    
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.common.Edge")
    def __init__(self,
        destinationUrn: str,
        sourceUrn: Union[None, str]=None,
        created: Union[None, "AuditStampClass"]=None,
        lastModified: Union[None, "AuditStampClass"]=None,
        properties: Union[None, Dict[str, str]]=None,
    ):
        super().__init__()
        
        self.sourceUrn = sourceUrn
        self.destinationUrn = destinationUrn
        self.created = created
        self.lastModified = lastModified
        self.properties = properties
    
    def _restore_defaults(self) -> None:
        self.sourceUrn = self.RECORD_SCHEMA.fields_dict["sourceUrn"].default
        self.destinationUrn = str()
        self.created = self.RECORD_SCHEMA.fields_dict["created"].default
        self.lastModified = self.RECORD_SCHEMA.fields_dict["lastModified"].default
        self.properties = self.RECORD_SCHEMA.fields_dict["properties"].default
    
    
    @property
    def sourceUrn(self) -> Union[None, str]:
        """Urn of the source of this relationship edge.
    If not specified, assumed to be the entity that this aspect belongs to."""
        return self._inner_dict.get('sourceUrn')  # type: ignore
    
    @sourceUrn.setter
    def sourceUrn(self, value: Union[None, str]) -> None:
        self._inner_dict['sourceUrn'] = value
    
    
    @property
    def destinationUrn(self) -> str:
        """Urn of the destination of this relationship edge."""
        return self._inner_dict.get('destinationUrn')  # type: ignore
    
    @destinationUrn.setter
    def destinationUrn(self, value: str) -> None:
        self._inner_dict['destinationUrn'] = value
    
    
    @property
    def created(self) -> Union[None, "AuditStampClass"]:
        """Audit stamp containing who created this relationship edge and when"""
        return self._inner_dict.get('created')  # type: ignore
    
    @created.setter
    def created(self, value: Union[None, "AuditStampClass"]) -> None:
        self._inner_dict['created'] = value
    
    
    @property
    def lastModified(self) -> Union[None, "AuditStampClass"]:
        """Audit stamp containing who last modified this relationship edge and when"""
        return self._inner_dict.get('lastModified')  # type: ignore
    
    @lastModified.setter
    def lastModified(self, value: Union[None, "AuditStampClass"]) -> None:
        self._inner_dict['lastModified'] = value
    
    
    @property
    def properties(self) -> Union[None, Dict[str, str]]:
        """A generic properties bag that allows us to store specific information on this graph edge."""
        return self._inner_dict.get('properties')  # type: ignore
    
    @properties.setter
    def properties(self, value: Union[None, Dict[str, str]]) -> None:
        self._inner_dict['properties'] = value
    
    
class EmbedClass(_Aspect):
    """Information regarding rendering an embed for an asset."""


    ASPECT_NAME = 'embed'
    ASPECT_INFO = {}
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.common.Embed")

    def __init__(self,
        renderUrl: Union[None, str]=None,
    ):
        super().__init__()
        
        self.renderUrl = renderUrl
    
    def _restore_defaults(self) -> None:
        self.renderUrl = self.RECORD_SCHEMA.fields_dict["renderUrl"].default
    
    
    @property
    def renderUrl(self) -> Union[None, str]:
        """An embed URL to be rendered inside of an iframe."""
        return self._inner_dict.get('renderUrl')  # type: ignore
    
    @renderUrl.setter
    def renderUrl(self, value: Union[None, str]) -> None:
        self._inner_dict['renderUrl'] = value
    
    
class FabricTypeClass(object):
    """Fabric group type"""
    
    DEV = "DEV"
    """Designates development fabrics"""
    
    TEST = "TEST"
    """Designates testing fabrics"""
    
    QA = "QA"
    """Designates quality assurance fabrics"""
    
    UAT = "UAT"
    """Designates user acceptance testing fabrics"""
    
    EI = "EI"
    """Designates early-integration fabrics"""
    
    PRE = "PRE"
    """Designates pre-production fabrics"""
    
    STG = "STG"
    """Designates staging fabrics"""
    
    NON_PROD = "NON_PROD"
    """Designates non-production fabrics"""
    
    PROD = "PROD"
    """Designates production fabrics"""
    
    CORP = "CORP"
    """Designates corporation fabrics"""
    
    
    
class FieldFormPromptAssociationClass(DictWrapper):
    """Information about the status of a particular prompt for a specific schema field
    on an entity."""
    
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.common.FieldFormPromptAssociation")
    def __init__(self,
        fieldPath: str,
        lastModified: "AuditStampClass",
    ):
        super().__init__()
        
        self.fieldPath = fieldPath
        self.lastModified = lastModified
    
    def _restore_defaults(self) -> None:
        self.fieldPath = str()
        self.lastModified = AuditStampClass._construct_with_defaults()
    
    
    @property
    def fieldPath(self) -> str:
        """The field path on a schema field."""
        return self._inner_dict.get('fieldPath')  # type: ignore
    
    @fieldPath.setter
    def fieldPath(self, value: str) -> None:
        self._inner_dict['fieldPath'] = value
    
    
    @property
    def lastModified(self) -> "AuditStampClass":
        """The last time this prompt was touched for the field on the entity (set, unset)"""
        return self._inner_dict.get('lastModified')  # type: ignore
    
    @lastModified.setter
    def lastModified(self, value: "AuditStampClass") -> None:
        self._inner_dict['lastModified'] = value
    
    
class FormAssociationClass(DictWrapper):
    """Properties of an applied form."""
    
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.common.FormAssociation")
    def __init__(self,
        urn: str,
        incompletePrompts: Optional[List["FormPromptAssociationClass"]]=None,
        completedPrompts: Optional[List["FormPromptAssociationClass"]]=None,
    ):
        super().__init__()
        
        self.urn = urn
        if incompletePrompts is None:
            # default: []
            self.incompletePrompts = list()
        else:
            self.incompletePrompts = incompletePrompts
        if completedPrompts is None:
            # default: []
            self.completedPrompts = list()
        else:
            self.completedPrompts = completedPrompts
    
    def _restore_defaults(self) -> None:
        self.urn = str()
        self.incompletePrompts = list()
        self.completedPrompts = list()
    
    
    @property
    def urn(self) -> str:
        """Urn of the applied form"""
        return self._inner_dict.get('urn')  # type: ignore
    
    @urn.setter
    def urn(self, value: str) -> None:
        self._inner_dict['urn'] = value
    
    
    @property
    def incompletePrompts(self) -> List["FormPromptAssociationClass"]:
        """A list of prompts that are not yet complete for this form."""
        return self._inner_dict.get('incompletePrompts')  # type: ignore
    
    @incompletePrompts.setter
    def incompletePrompts(self, value: List["FormPromptAssociationClass"]) -> None:
        self._inner_dict['incompletePrompts'] = value
    
    
    @property
    def completedPrompts(self) -> List["FormPromptAssociationClass"]:
        """A list of prompts that have been completed for this form."""
        return self._inner_dict.get('completedPrompts')  # type: ignore
    
    @completedPrompts.setter
    def completedPrompts(self, value: List["FormPromptAssociationClass"]) -> None:
        self._inner_dict['completedPrompts'] = value
    
    
class FormPromptAssociationClass(DictWrapper):
    """Information about the status of a particular prompt.
    Note that this is where we can add additional information about individual responses:
    actor, timestamp, and the response itself."""
    
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.common.FormPromptAssociation")
    def __init__(self,
        id: str,
        lastModified: "AuditStampClass",
        fieldAssociations: Union[None, "FormPromptFieldAssociationsClass"]=None,
    ):
        super().__init__()
        
        self.id = id
        self.lastModified = lastModified
        self.fieldAssociations = fieldAssociations
    
    def _restore_defaults(self) -> None:
        self.id = str()
        self.lastModified = AuditStampClass._construct_with_defaults()
        self.fieldAssociations = self.RECORD_SCHEMA.fields_dict["fieldAssociations"].default
    
    
    @property
    def id(self) -> str:
        """The id for the prompt. This must be GLOBALLY UNIQUE."""
        return self._inner_dict.get('id')  # type: ignore
    
    @id.setter
    def id(self, value: str) -> None:
        self._inner_dict['id'] = value
    
    
    @property
    def lastModified(self) -> "AuditStampClass":
        """The last time this prompt was touched for the entity (set, unset)"""
        return self._inner_dict.get('lastModified')  # type: ignore
    
    @lastModified.setter
    def lastModified(self, value: "AuditStampClass") -> None:
        self._inner_dict['lastModified'] = value
    
    
    @property
    def fieldAssociations(self) -> Union[None, "FormPromptFieldAssociationsClass"]:
        """Optional information about the field-level prompt associations."""
        return self._inner_dict.get('fieldAssociations')  # type: ignore
    
    @fieldAssociations.setter
    def fieldAssociations(self, value: Union[None, "FormPromptFieldAssociationsClass"]) -> None:
        self._inner_dict['fieldAssociations'] = value
    
    
class FormPromptFieldAssociationsClass(DictWrapper):
    """Information about the field-level prompt associations on a top-level prompt association."""
    
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.common.FormPromptFieldAssociations")
    def __init__(self,
        completedFieldPrompts: Union[None, List["FieldFormPromptAssociationClass"]]=None,
        incompleteFieldPrompts: Union[None, List["FieldFormPromptAssociationClass"]]=None,
    ):
        super().__init__()
        
        self.completedFieldPrompts = completedFieldPrompts
        self.incompleteFieldPrompts = incompleteFieldPrompts
    
    def _restore_defaults(self) -> None:
        self.completedFieldPrompts = self.RECORD_SCHEMA.fields_dict["completedFieldPrompts"].default
        self.incompleteFieldPrompts = self.RECORD_SCHEMA.fields_dict["incompleteFieldPrompts"].default
    
    
    @property
    def completedFieldPrompts(self) -> Union[None, List["FieldFormPromptAssociationClass"]]:
        """A list of field-level prompt associations that are not yet complete for this form."""
        return self._inner_dict.get('completedFieldPrompts')  # type: ignore
    
    @completedFieldPrompts.setter
    def completedFieldPrompts(self, value: Union[None, List["FieldFormPromptAssociationClass"]]) -> None:
        self._inner_dict['completedFieldPrompts'] = value
    
    
    @property
    def incompleteFieldPrompts(self) -> Union[None, List["FieldFormPromptAssociationClass"]]:
        """A list of field-level prompt associations that are complete for this form."""
        return self._inner_dict.get('incompleteFieldPrompts')  # type: ignore
    
    @incompleteFieldPrompts.setter
    def incompleteFieldPrompts(self, value: Union[None, List["FieldFormPromptAssociationClass"]]) -> None:
        self._inner_dict['incompleteFieldPrompts'] = value
    
    
class FormVerificationAssociationClass(DictWrapper):
    """An association between a verification and an entity that has been granted
    via completion of one or more forms of type 'VERIFICATION'."""
    
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.common.FormVerificationAssociation")
    def __init__(self,
        form: str,
        lastModified: Union[None, "AuditStampClass"]=None,
    ):
        super().__init__()
        
        self.form = form
        self.lastModified = lastModified
    
    def _restore_defaults(self) -> None:
        self.form = str()
        self.lastModified = self.RECORD_SCHEMA.fields_dict["lastModified"].default
    
    
    @property
    def form(self) -> str:
        """The urn of the form that granted this verification."""
        return self._inner_dict.get('form')  # type: ignore
    
    @form.setter
    def form(self, value: str) -> None:
        self._inner_dict['form'] = value
    
    
    @property
    def lastModified(self) -> Union[None, "AuditStampClass"]:
        """An audit stamp capturing who and when verification was applied for this form."""
        return self._inner_dict.get('lastModified')  # type: ignore
    
    @lastModified.setter
    def lastModified(self, value: Union[None, "AuditStampClass"]) -> None:
        self._inner_dict['lastModified'] = value
    
    
class FormsClass(_Aspect):
    """Forms that are assigned to this entity to be filled out"""


    ASPECT_NAME = 'forms'
    ASPECT_INFO = {}
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.common.Forms")

    def __init__(self,
        incompleteForms: List["FormAssociationClass"],
        completedForms: List["FormAssociationClass"],
        verifications: Optional[List["FormVerificationAssociationClass"]]=None,
    ):
        super().__init__()
        
        self.incompleteForms = incompleteForms
        self.completedForms = completedForms
        if verifications is None:
            # default: []
            self.verifications = list()
        else:
            self.verifications = verifications
    
    def _restore_defaults(self) -> None:
        self.incompleteForms = list()
        self.completedForms = list()
        self.verifications = list()
    
    
    @property
    def incompleteForms(self) -> List["FormAssociationClass"]:
        """All incomplete forms assigned to the entity."""
        return self._inner_dict.get('incompleteForms')  # type: ignore
    
    @incompleteForms.setter
    def incompleteForms(self, value: List["FormAssociationClass"]) -> None:
        self._inner_dict['incompleteForms'] = value
    
    
    @property
    def completedForms(self) -> List["FormAssociationClass"]:
        """All complete forms assigned to the entity."""
        return self._inner_dict.get('completedForms')  # type: ignore
    
    @completedForms.setter
    def completedForms(self, value: List["FormAssociationClass"]) -> None:
        self._inner_dict['completedForms'] = value
    
    
    @property
    def verifications(self) -> List["FormVerificationAssociationClass"]:
        """Verifications that have been applied to the entity via completed forms."""
        return self._inner_dict.get('verifications')  # type: ignore
    
    @verifications.setter
    def verifications(self, value: List["FormVerificationAssociationClass"]) -> None:
        self._inner_dict['verifications'] = value
    
    
class GlobalTagsClass(_Aspect):
    """Tag aspect used for applying tags to an entity"""


    ASPECT_NAME = 'globalTags'
    ASPECT_INFO = {}
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.common.GlobalTags")

    def __init__(self,
        tags: List["TagAssociationClass"],
    ):
        super().__init__()
        
        self.tags = tags
    
    def _restore_defaults(self) -> None:
        self.tags = list()
    
    
    @property
    def tags(self) -> List["TagAssociationClass"]:
        """Tags associated with a given entity"""
        return self._inner_dict.get('tags')  # type: ignore
    
    @tags.setter
    def tags(self, value: List["TagAssociationClass"]) -> None:
        self._inner_dict['tags'] = value
    
    
class GlossaryTermAssociationClass(DictWrapper):
    """Properties of an applied glossary term."""
    
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.common.GlossaryTermAssociation")
    def __init__(self,
        urn: str,
        actor: Union[None, str]=None,
        context: Union[None, str]=None,
    ):
        super().__init__()
        
        self.urn = urn
        self.actor = actor
        self.context = context
    
    def _restore_defaults(self) -> None:
        self.urn = str()
        self.actor = self.RECORD_SCHEMA.fields_dict["actor"].default
        self.context = self.RECORD_SCHEMA.fields_dict["context"].default
    
    
    @property
    def urn(self) -> str:
        """Urn of the applied glossary term"""
        return self._inner_dict.get('urn')  # type: ignore
    
    @urn.setter
    def urn(self, value: str) -> None:
        self._inner_dict['urn'] = value
    
    
    @property
    def actor(self) -> Union[None, str]:
        """The user URN which will be credited for adding associating this term to the entity"""
        return self._inner_dict.get('actor')  # type: ignore
    
    @actor.setter
    def actor(self, value: Union[None, str]) -> None:
        self._inner_dict['actor'] = value
    
    
    @property
    def context(self) -> Union[None, str]:
        """Additional context about the association"""
        return self._inner_dict.get('context')  # type: ignore
    
    @context.setter
    def context(self, value: Union[None, str]) -> None:
        self._inner_dict['context'] = value
    
    
class GlossaryTermsClass(_Aspect):
    """Related business terms information"""


    ASPECT_NAME = 'glossaryTerms'
    ASPECT_INFO = {}
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.common.GlossaryTerms")

    def __init__(self,
        terms: List["GlossaryTermAssociationClass"],
        auditStamp: "AuditStampClass",
    ):
        super().__init__()
        
        self.terms = terms
        self.auditStamp = auditStamp
    
    def _restore_defaults(self) -> None:
        self.terms = list()
        self.auditStamp = AuditStampClass._construct_with_defaults()
    
    
    @property
    def terms(self) -> List["GlossaryTermAssociationClass"]:
        """The related business terms"""
        return self._inner_dict.get('terms')  # type: ignore
    
    @terms.setter
    def terms(self, value: List["GlossaryTermAssociationClass"]) -> None:
        self._inner_dict['terms'] = value
    
    
    @property
    def auditStamp(self) -> "AuditStampClass":
        """Audit stamp containing who reported the related business term"""
        return self._inner_dict.get('auditStamp')  # type: ignore
    
    @auditStamp.setter
    def auditStamp(self, value: "AuditStampClass") -> None:
        self._inner_dict['auditStamp'] = value
    
    
class IncidentSummaryDetailsClass(DictWrapper):
    """Summary statistics about incidents on an entity."""
    
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.common.IncidentSummaryDetails")
    def __init__(self,
        urn: str,
        type: str,
        createdAt: int,
        resolvedAt: Union[None, int]=None,
        priority: Union[None, int]=None,
    ):
        super().__init__()
        
        self.urn = urn
        self.type = type
        self.createdAt = createdAt
        self.resolvedAt = resolvedAt
        self.priority = priority
    
    def _restore_defaults(self) -> None:
        self.urn = str()
        self.type = str()
        self.createdAt = int()
        self.resolvedAt = self.RECORD_SCHEMA.fields_dict["resolvedAt"].default
        self.priority = self.RECORD_SCHEMA.fields_dict["priority"].default
    
    
    @property
    def urn(self) -> str:
        """The urn of the incident"""
        return self._inner_dict.get('urn')  # type: ignore
    
    @urn.setter
    def urn(self, value: str) -> None:
        self._inner_dict['urn'] = value
    
    
    @property
    def type(self) -> str:
        """The type of an incident"""
        return self._inner_dict.get('type')  # type: ignore
    
    @type.setter
    def type(self, value: str) -> None:
        self._inner_dict['type'] = value
    
    
    @property
    def createdAt(self) -> int:
        """The time at which the incident was raised in milliseconds since epoch."""
        return self._inner_dict.get('createdAt')  # type: ignore
    
    @createdAt.setter
    def createdAt(self, value: int) -> None:
        self._inner_dict['createdAt'] = value
    
    
    @property
    def resolvedAt(self) -> Union[None, int]:
        """The time at which the incident was marked as resolved in milliseconds since epoch. Null if the incident is still active."""
        return self._inner_dict.get('resolvedAt')  # type: ignore
    
    @resolvedAt.setter
    def resolvedAt(self, value: Union[None, int]) -> None:
        self._inner_dict['resolvedAt'] = value
    
    
    @property
    def priority(self) -> Union[None, int]:
        """The priority of the incident"""
        return self._inner_dict.get('priority')  # type: ignore
    
    @priority.setter
    def priority(self, value: Union[None, int]) -> None:
        self._inner_dict['priority'] = value
    
    
class IncidentsSummaryClass(_Aspect):
    """Summary related incidents on an entity."""


    ASPECT_NAME = 'incidentsSummary'
    ASPECT_INFO = {}
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.common.IncidentsSummary")

    def __init__(self,
        resolvedIncidents: Optional[List[str]]=None,
        activeIncidents: Optional[List[str]]=None,
        resolvedIncidentDetails: Optional[List["IncidentSummaryDetailsClass"]]=None,
        activeIncidentDetails: Optional[List["IncidentSummaryDetailsClass"]]=None,
    ):
        super().__init__()
        
        if resolvedIncidents is None:
            # default: []
            self.resolvedIncidents = list()
        else:
            self.resolvedIncidents = resolvedIncidents
        if activeIncidents is None:
            # default: []
            self.activeIncidents = list()
        else:
            self.activeIncidents = activeIncidents
        if resolvedIncidentDetails is None:
            # default: []
            self.resolvedIncidentDetails = list()
        else:
            self.resolvedIncidentDetails = resolvedIncidentDetails
        if activeIncidentDetails is None:
            # default: []
            self.activeIncidentDetails = list()
        else:
            self.activeIncidentDetails = activeIncidentDetails
    
    def _restore_defaults(self) -> None:
        self.resolvedIncidents = list()
        self.activeIncidents = list()
        self.resolvedIncidentDetails = list()
        self.activeIncidentDetails = list()
    
    
    @property
    def resolvedIncidents(self) -> List[str]:
        """Resolved incidents for an asset
    Deprecated! Use the richer resolvedIncidentsDetails instead."""
        return self._inner_dict.get('resolvedIncidents')  # type: ignore
    
    @resolvedIncidents.setter
    def resolvedIncidents(self, value: List[str]) -> None:
        self._inner_dict['resolvedIncidents'] = value
    
    
    @property
    def activeIncidents(self) -> List[str]:
        """Active incidents for an asset
    Deprecated! Use the richer activeIncidentsDetails instead."""
        return self._inner_dict.get('activeIncidents')  # type: ignore
    
    @activeIncidents.setter
    def activeIncidents(self, value: List[str]) -> None:
        self._inner_dict['activeIncidents'] = value
    
    
    @property
    def resolvedIncidentDetails(self) -> List["IncidentSummaryDetailsClass"]:
        """Summary details about the set of resolved incidents"""
        return self._inner_dict.get('resolvedIncidentDetails')  # type: ignore
    
    @resolvedIncidentDetails.setter
    def resolvedIncidentDetails(self, value: List["IncidentSummaryDetailsClass"]) -> None:
        self._inner_dict['resolvedIncidentDetails'] = value
    
    
    @property
    def activeIncidentDetails(self) -> List["IncidentSummaryDetailsClass"]:
        """Summary details about the set of active incidents"""
        return self._inner_dict.get('activeIncidentDetails')  # type: ignore
    
    @activeIncidentDetails.setter
    def activeIncidentDetails(self, value: List["IncidentSummaryDetailsClass"]) -> None:
        self._inner_dict['activeIncidentDetails'] = value
    
    
class InputFieldClass(DictWrapper):
    """Information about a field a chart or dashboard references"""
    
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.common.InputField")
    def __init__(self,
        schemaFieldUrn: str,
        schemaField: Union[None, "SchemaFieldClass"]=None,
    ):
        super().__init__()
        
        self.schemaFieldUrn = schemaFieldUrn
        self.schemaField = schemaField
    
    def _restore_defaults(self) -> None:
        self.schemaFieldUrn = str()
        self.schemaField = self.RECORD_SCHEMA.fields_dict["schemaField"].default
    
    
    @property
    def schemaFieldUrn(self) -> str:
        """Urn of the schema being referenced for lineage purposes"""
        return self._inner_dict.get('schemaFieldUrn')  # type: ignore
    
    @schemaFieldUrn.setter
    def schemaFieldUrn(self, value: str) -> None:
        self._inner_dict['schemaFieldUrn'] = value
    
    
    @property
    def schemaField(self) -> Union[None, "SchemaFieldClass"]:
        """Copied version of the referenced schema field object for indexing purposes"""
        return self._inner_dict.get('schemaField')  # type: ignore
    
    @schemaField.setter
    def schemaField(self, value: Union[None, "SchemaFieldClass"]) -> None:
        self._inner_dict['schemaField'] = value
    
    
class InputFieldsClass(_Aspect):
    """Information about the fields a chart or dashboard references"""


    ASPECT_NAME = 'inputFields'
    ASPECT_INFO = {}
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.common.InputFields")

    def __init__(self,
        fields: List["InputFieldClass"],
    ):
        super().__init__()
        
        self.fields = fields
    
    def _restore_defaults(self) -> None:
        self.fields = list()
    
    
    @property
    def fields(self) -> List["InputFieldClass"]:
        """List of fields being referenced"""
        return self._inner_dict.get('fields')  # type: ignore
    
    @fields.setter
    def fields(self, value: List["InputFieldClass"]) -> None:
        self._inner_dict['fields'] = value
    
    
class InstitutionalMemoryClass(_Aspect):
    """Institutional memory of an entity. This is a way to link to relevant documentation and provide description of the documentation. Institutional or tribal knowledge is very important for users to leverage the entity."""


    ASPECT_NAME = 'institutionalMemory'
    ASPECT_INFO = {}
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.common.InstitutionalMemory")

    def __init__(self,
        elements: List["InstitutionalMemoryMetadataClass"],
    ):
        super().__init__()
        
        self.elements = elements
    
    def _restore_defaults(self) -> None:
        self.elements = list()
    
    
    @property
    def elements(self) -> List["InstitutionalMemoryMetadataClass"]:
        """List of records that represent institutional memory of an entity. Each record consists of a link, description, creator and timestamps associated with that record."""
        return self._inner_dict.get('elements')  # type: ignore
    
    @elements.setter
    def elements(self, value: List["InstitutionalMemoryMetadataClass"]) -> None:
        self._inner_dict['elements'] = value
    
    
class InstitutionalMemoryMetadataClass(DictWrapper):
    """Metadata corresponding to a record of institutional memory."""
    
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.common.InstitutionalMemoryMetadata")
    def __init__(self,
        url: str,
        description: str,
        createStamp: "AuditStampClass",
    ):
        super().__init__()
        
        self.url = url
        self.description = description
        self.createStamp = createStamp
    
    def _restore_defaults(self) -> None:
        self.url = str()
        self.description = str()
        self.createStamp = AuditStampClass._construct_with_defaults()
    
    
    @property
    def url(self) -> str:
        """Link to an engineering design document or a wiki page."""
        return self._inner_dict.get('url')  # type: ignore
    
    @url.setter
    def url(self, value: str) -> None:
        self._inner_dict['url'] = value
    
    
    @property
    def description(self) -> str:
        """Description of the link."""
        return self._inner_dict.get('description')  # type: ignore
    
    @description.setter
    def description(self, value: str) -> None:
        self._inner_dict['description'] = value
    
    
    @property
    def createStamp(self) -> "AuditStampClass":
        """Audit stamp associated with creation of this record"""
        return self._inner_dict.get('createStamp')  # type: ignore
    
    @createStamp.setter
    def createStamp(self, value: "AuditStampClass") -> None:
        self._inner_dict['createStamp'] = value
    
    
class MLFeatureDataTypeClass(object):
    """MLFeature Data Type"""
    
    USELESS = "USELESS"
    """Useless data is unique, discrete data with no potential relationship with the outcome variable.
    A useless feature has high cardinality. An example would be bank account numbers that were generated randomly."""
    
    NOMINAL = "NOMINAL"
    """Nominal data is made of discrete values with no numerical relationship between the different categories - mean and median are meaningless.
    Animal species is one example. For example, pig is not higher than bird and lower than fish."""
    
    ORDINAL = "ORDINAL"
    """Ordinal data are discrete integers that can be ranked or sorted.
    For example, the distance between first and second may not be the same as the distance between second and third."""
    
    BINARY = "BINARY"
    """Binary data is discrete data that can be in only one of two categories - either yes or no, 1 or 0, off or on, etc"""
    
    COUNT = "COUNT"
    """Count data is discrete whole number data - no negative numbers here.
    Count data often has many small values, such as zero and one."""
    
    TIME = "TIME"
    """Time data is a cyclical, repeating continuous form of data.
    The relevant time features can be any period- daily, weekly, monthly, annual, etc."""
    
    INTERVAL = "INTERVAL"
    """Interval data has equal spaces between the numbers and does not represent a temporal pattern.
    Examples include percentages, temperatures, and income."""
    
    IMAGE = "IMAGE"
    """Image Data"""
    
    VIDEO = "VIDEO"
    """Video Data"""
    
    AUDIO = "AUDIO"
    """Audio Data"""
    
    TEXT = "TEXT"
    """Text Data"""
    
    MAP = "MAP"
    """Mapping Data Type ex: dict, map"""
    
    SEQUENCE = "SEQUENCE"
    """Sequence Data Type ex: list, tuple, range"""
    
    SET = "SET"
    """Set Data Type ex: set, frozenset"""
    
    CONTINUOUS = "CONTINUOUS"
    """Continuous data are made of uncountable values, often the result of a measurement such as height, weight, age etc."""
    
    BYTE = "BYTE"
    """Bytes data are binary-encoded values that can represent complex objects."""
    
    UNKNOWN = "UNKNOWN"
    """Unknown data are data that we don't know the type for."""
    
    
    
class MediaClass(DictWrapper):
    """Carries information about which roles a user is assigned to."""
    
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.common.Media")
    def __init__(self,
        type: Union[str, "MediaTypeClass"],
        location: str,
    ):
        super().__init__()
        
        self.type = type
        self.location = location
    
    def _restore_defaults(self) -> None:
        self.type = MediaTypeClass.IMAGE
        self.location = str()
    
    
    @property
    def type(self) -> Union[str, "MediaTypeClass"]:
        """Type of content the Media is storing, e.g. image, video, etc."""
        return self._inner_dict.get('type')  # type: ignore
    
    @type.setter
    def type(self, value: Union[str, "MediaTypeClass"]) -> None:
        self._inner_dict['type'] = value
    
    
    @property
    def location(self) -> str:
        """Where the media content is stored."""
        return self._inner_dict.get('location')  # type: ignore
    
    @location.setter
    def location(self, value: str) -> None:
        self._inner_dict['location'] = value
    
    
class MediaTypeClass(object):
    """Enum defining the type of content a Media object holds."""
    
    IMAGE = "IMAGE"
    """The Media holds an image."""
    
    
    
class OperationClass(_Aspect):
    """Operational info for an entity."""


    ASPECT_NAME = 'operation'
    ASPECT_TYPE = 'timeseries'
    ASPECT_INFO = {}
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.common.Operation")

    def __init__(self,
        timestampMillis: int,
        operationType: Union[str, "OperationTypeClass"],
        lastUpdatedTimestamp: int,
        eventGranularity: Union[None, "TimeWindowSizeClass"]=None,
        partitionSpec: Optional[Union["PartitionSpecClass", None]]=None,
        messageId: Union[None, str]=None,
        actor: Union[None, str]=None,
        customOperationType: Union[None, str]=None,
        numAffectedRows: Union[None, int]=None,
        affectedDatasets: Union[None, List[str]]=None,
        sourceType: Union[None, Union[str, "OperationSourceTypeClass"]]=None,
        customProperties: Union[None, Dict[str, str]]=None,
    ):
        super().__init__()
        
        self.timestampMillis = timestampMillis
        self.eventGranularity = eventGranularity
        if partitionSpec is None:
            # default: {'partition': 'FULL_TABLE_SNAPSHOT', 'type': 'FULL_TABLE', 'timePartition': None}
            self.partitionSpec = _json_converter.from_json_object(self.RECORD_SCHEMA.fields_dict["partitionSpec"].default, writers_schema=self.RECORD_SCHEMA.fields_dict["partitionSpec"].type)
        else:
            self.partitionSpec = partitionSpec
        self.messageId = messageId
        self.actor = actor
        self.operationType = operationType
        self.customOperationType = customOperationType
        self.numAffectedRows = numAffectedRows
        self.affectedDatasets = affectedDatasets
        self.sourceType = sourceType
        self.customProperties = customProperties
        self.lastUpdatedTimestamp = lastUpdatedTimestamp
    
    def _restore_defaults(self) -> None:
        self.timestampMillis = int()
        self.eventGranularity = self.RECORD_SCHEMA.fields_dict["eventGranularity"].default
        self.partitionSpec = _json_converter.from_json_object(self.RECORD_SCHEMA.fields_dict["partitionSpec"].default, writers_schema=self.RECORD_SCHEMA.fields_dict["partitionSpec"].type)
        self.messageId = self.RECORD_SCHEMA.fields_dict["messageId"].default
        self.actor = self.RECORD_SCHEMA.fields_dict["actor"].default
        self.operationType = OperationTypeClass.INSERT
        self.customOperationType = self.RECORD_SCHEMA.fields_dict["customOperationType"].default
        self.numAffectedRows = self.RECORD_SCHEMA.fields_dict["numAffectedRows"].default
        self.affectedDatasets = self.RECORD_SCHEMA.fields_dict["affectedDatasets"].default
        self.sourceType = self.RECORD_SCHEMA.fields_dict["sourceType"].default
        self.customProperties = self.RECORD_SCHEMA.fields_dict["customProperties"].default
        self.lastUpdatedTimestamp = int()
    
    
    @property
    def timestampMillis(self) -> int:
        """The event timestamp field as epoch at UTC in milli seconds."""
        return self._inner_dict.get('timestampMillis')  # type: ignore
    
    @timestampMillis.setter
    def timestampMillis(self, value: int) -> None:
        self._inner_dict['timestampMillis'] = value
    
    
    @property
    def eventGranularity(self) -> Union[None, "TimeWindowSizeClass"]:
        """Granularity of the event if applicable"""
        return self._inner_dict.get('eventGranularity')  # type: ignore
    
    @eventGranularity.setter
    def eventGranularity(self, value: Union[None, "TimeWindowSizeClass"]) -> None:
        self._inner_dict['eventGranularity'] = value
    
    
    @property
    def partitionSpec(self) -> Union["PartitionSpecClass", None]:
        """The optional partition specification."""
        return self._inner_dict.get('partitionSpec')  # type: ignore
    
    @partitionSpec.setter
    def partitionSpec(self, value: Union["PartitionSpecClass", None]) -> None:
        self._inner_dict['partitionSpec'] = value
    
    
    @property
    def messageId(self) -> Union[None, str]:
        """The optional messageId, if provided serves as a custom user-defined unique identifier for an aspect value."""
        return self._inner_dict.get('messageId')  # type: ignore
    
    @messageId.setter
    def messageId(self, value: Union[None, str]) -> None:
        self._inner_dict['messageId'] = value
    
    
    @property
    def actor(self) -> Union[None, str]:
        """Actor who issued this operation."""
        return self._inner_dict.get('actor')  # type: ignore
    
    @actor.setter
    def actor(self, value: Union[None, str]) -> None:
        self._inner_dict['actor'] = value
    
    
    @property
    def operationType(self) -> Union[str, "OperationTypeClass"]:
        """Operation type of change."""
        return self._inner_dict.get('operationType')  # type: ignore
    
    @operationType.setter
    def operationType(self, value: Union[str, "OperationTypeClass"]) -> None:
        self._inner_dict['operationType'] = value
    
    
    @property
    def customOperationType(self) -> Union[None, str]:
        """A custom type of operation. Required if operationType is CUSTOM."""
        return self._inner_dict.get('customOperationType')  # type: ignore
    
    @customOperationType.setter
    def customOperationType(self, value: Union[None, str]) -> None:
        self._inner_dict['customOperationType'] = value
    
    
    @property
    def numAffectedRows(self) -> Union[None, int]:
        """How many rows were affected by this operation."""
        return self._inner_dict.get('numAffectedRows')  # type: ignore
    
    @numAffectedRows.setter
    def numAffectedRows(self, value: Union[None, int]) -> None:
        self._inner_dict['numAffectedRows'] = value
    
    
    @property
    def affectedDatasets(self) -> Union[None, List[str]]:
        """Which other datasets were affected by this operation."""
        return self._inner_dict.get('affectedDatasets')  # type: ignore
    
    @affectedDatasets.setter
    def affectedDatasets(self, value: Union[None, List[str]]) -> None:
        self._inner_dict['affectedDatasets'] = value
    
    
    @property
    def sourceType(self) -> Union[None, Union[str, "OperationSourceTypeClass"]]:
        """Source Type"""
        return self._inner_dict.get('sourceType')  # type: ignore
    
    @sourceType.setter
    def sourceType(self, value: Union[None, Union[str, "OperationSourceTypeClass"]]) -> None:
        self._inner_dict['sourceType'] = value
    
    
    @property
    def customProperties(self) -> Union[None, Dict[str, str]]:
        """Custom properties"""
        return self._inner_dict.get('customProperties')  # type: ignore
    
    @customProperties.setter
    def customProperties(self, value: Union[None, Dict[str, str]]) -> None:
        self._inner_dict['customProperties'] = value
    
    
    @property
    def lastUpdatedTimestamp(self) -> int:
        """The time at which the operation occurred. Would be better named 'operationTime'"""
        return self._inner_dict.get('lastUpdatedTimestamp')  # type: ignore
    
    @lastUpdatedTimestamp.setter
    def lastUpdatedTimestamp(self, value: int) -> None:
        self._inner_dict['lastUpdatedTimestamp'] = value
    
    
class OperationSourceTypeClass(object):
    """The source of an operation"""
    
    DATA_PROCESS = "DATA_PROCESS"
    """Provided by a Data Process"""
    
    DATA_PLATFORM = "DATA_PLATFORM"
    """Rows were updated"""
    
    
    
class OperationTypeClass(object):
    """Enum to define the operation type when an entity changes."""
    
    INSERT = "INSERT"
    """Rows were inserted"""
    
    UPDATE = "UPDATE"
    """Rows were updated"""
    
    DELETE = "DELETE"
    """Rows were deleted"""
    
    CREATE = "CREATE"
    """Asset was created"""
    
    ALTER = "ALTER"
    """Asset was altered"""
    
    DROP = "DROP"
    """Asset was dropped"""
    
    CUSTOM = "CUSTOM"
    """Custom asset operation"""
    
    UNKNOWN = "UNKNOWN"
    
    
    
class OriginClass(_Aspect):
    """Carries information about where an entity originated from."""


    ASPECT_NAME = 'origin'
    ASPECT_INFO = {}
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.common.Origin")

    def __init__(self,
        type: Union[str, "OriginTypeClass"],
        externalType: Union[None, str]=None,
    ):
        super().__init__()
        
        self.type = type
        self.externalType = externalType
    
    def _restore_defaults(self) -> None:
        self.type = OriginTypeClass.NATIVE
        self.externalType = self.RECORD_SCHEMA.fields_dict["externalType"].default
    
    
    @property
    def type(self) -> Union[str, "OriginTypeClass"]:
        """Where an entity originated from. Either NATIVE or EXTERNAL."""
        return self._inner_dict.get('type')  # type: ignore
    
    @type.setter
    def type(self, value: Union[str, "OriginTypeClass"]) -> None:
        self._inner_dict['type'] = value
    
    
    @property
    def externalType(self) -> Union[None, str]:
        """Only populated if type is EXTERNAL. The externalType of the entity, such as the name of the identity provider."""
        return self._inner_dict.get('externalType')  # type: ignore
    
    @externalType.setter
    def externalType(self, value: Union[None, str]) -> None:
        self._inner_dict['externalType'] = value
    
    
class OriginTypeClass(object):
    """Enum to define where an entity originated from."""
    
    NATIVE = "NATIVE"
    """The entity is native to DataHub."""
    
    EXTERNAL = "EXTERNAL"
    """The entity is external to DataHub."""
    
    
    
class OwnerClass(DictWrapper):
    """Ownership information"""
    
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.common.Owner")
    def __init__(self,
        owner: str,
        type: Union[str, "OwnershipTypeClass"],
        typeUrn: Union[None, str]=None,
        source: Union[None, "OwnershipSourceClass"]=None,
    ):
        super().__init__()
        
        self.owner = owner
        self.type = type
        self.typeUrn = typeUrn
        self.source = source
    
    def _restore_defaults(self) -> None:
        self.owner = str()
        self.type = OwnershipTypeClass.CUSTOM
        self.typeUrn = self.RECORD_SCHEMA.fields_dict["typeUrn"].default
        self.source = self.RECORD_SCHEMA.fields_dict["source"].default
    
    
    @property
    def owner(self) -> str:
        """Owner URN, e.g. urn:li:corpuser:ldap, urn:li:corpGroup:group_name, and urn:li:multiProduct:mp_name
    (Caveat: only corpuser is currently supported in the frontend.)"""
        return self._inner_dict.get('owner')  # type: ignore
    
    @owner.setter
    def owner(self, value: str) -> None:
        self._inner_dict['owner'] = value
    
    
    @property
    def type(self) -> Union[str, "OwnershipTypeClass"]:
        """The type of the ownership"""
        return self._inner_dict.get('type')  # type: ignore
    
    @type.setter
    def type(self, value: Union[str, "OwnershipTypeClass"]) -> None:
        self._inner_dict['type'] = value
    
    
    @property
    def typeUrn(self) -> Union[None, str]:
        """The type of the ownership
    Urn of type O"""
        return self._inner_dict.get('typeUrn')  # type: ignore
    
    @typeUrn.setter
    def typeUrn(self, value: Union[None, str]) -> None:
        self._inner_dict['typeUrn'] = value
    
    
    @property
    def source(self) -> Union[None, "OwnershipSourceClass"]:
        """Source information for the ownership"""
        return self._inner_dict.get('source')  # type: ignore
    
    @source.setter
    def source(self, value: Union[None, "OwnershipSourceClass"]) -> None:
        self._inner_dict['source'] = value
    
    
class OwnershipClass(_Aspect):
    """Ownership information of an entity."""


    ASPECT_NAME = 'ownership'
    ASPECT_INFO = {}
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.common.Ownership")

    def __init__(self,
        owners: List["OwnerClass"],
        ownerTypes: Optional[Union[Dict[str, List[str]], None]]=None,
        lastModified: Optional["AuditStampClass"]=None,
    ):
        super().__init__()
        
        self.owners = owners
        if ownerTypes is None:
            # default: {}
            self.ownerTypes = dict()
        else:
            self.ownerTypes = ownerTypes
        if lastModified is None:
            # default: {'actor': 'urn:li:corpuser:unknown', 'impersonator': None, 'time': 0, 'message': None}
            self.lastModified = _json_converter.from_json_object(self.RECORD_SCHEMA.fields_dict["lastModified"].default, writers_schema=self.RECORD_SCHEMA.fields_dict["lastModified"].type)
        else:
            self.lastModified = lastModified
    
    def _restore_defaults(self) -> None:
        self.owners = list()
        self.ownerTypes = dict()
        self.lastModified = _json_converter.from_json_object(self.RECORD_SCHEMA.fields_dict["lastModified"].default, writers_schema=self.RECORD_SCHEMA.fields_dict["lastModified"].type)
    
    
    @property
    def owners(self) -> List["OwnerClass"]:
        """List of owners of the entity."""
        return self._inner_dict.get('owners')  # type: ignore
    
    @owners.setter
    def owners(self, value: List["OwnerClass"]) -> None:
        self._inner_dict['owners'] = value
    
    
    @property
    def ownerTypes(self) -> Union[Dict[str, List[str]], None]:
        """Ownership type to Owners map, populated via mutation hook."""
        return self._inner_dict.get('ownerTypes')  # type: ignore
    
    @ownerTypes.setter
    def ownerTypes(self, value: Union[Dict[str, List[str]], None]) -> None:
        self._inner_dict['ownerTypes'] = value
    
    
    @property
    def lastModified(self) -> "AuditStampClass":
        """Audit stamp containing who last modified the record and when. A value of 0 in the time field indicates missing data."""
        return self._inner_dict.get('lastModified')  # type: ignore
    
    @lastModified.setter
    def lastModified(self, value: "AuditStampClass") -> None:
        self._inner_dict['lastModified'] = value
    
    
class OwnershipSourceClass(DictWrapper):
    """Source/provider of the ownership information"""
    
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.common.OwnershipSource")
    def __init__(self,
        type: Union[str, "OwnershipSourceTypeClass"],
        url: Union[None, str]=None,
    ):
        super().__init__()
        
        self.type = type
        self.url = url
    
    def _restore_defaults(self) -> None:
        self.type = OwnershipSourceTypeClass.AUDIT
        self.url = self.RECORD_SCHEMA.fields_dict["url"].default
    
    
    @property
    def type(self) -> Union[str, "OwnershipSourceTypeClass"]:
        """The type of the source"""
        return self._inner_dict.get('type')  # type: ignore
    
    @type.setter
    def type(self, value: Union[str, "OwnershipSourceTypeClass"]) -> None:
        self._inner_dict['type'] = value
    
    
    @property
    def url(self) -> Union[None, str]:
        """A reference URL for the source"""
        return self._inner_dict.get('url')  # type: ignore
    
    @url.setter
    def url(self, value: Union[None, str]) -> None:
        self._inner_dict['url'] = value
    
    
class OwnershipSourceTypeClass(object):
    # No docs available.
    
    AUDIT = "AUDIT"
    """Auditing system or audit logs"""
    
    DATABASE = "DATABASE"
    """Database, e.g. GRANTS table"""
    
    FILE_SYSTEM = "FILE_SYSTEM"
    """File system, e.g. file/directory owner"""
    
    ISSUE_TRACKING_SYSTEM = "ISSUE_TRACKING_SYSTEM"
    """Issue tracking system, e.g. Jira"""
    
    MANUAL = "MANUAL"
    """Manually provided by a user"""
    
    SERVICE = "SERVICE"
    """Other ownership-like service, e.g. Nuage, ACL service etc"""
    
    SOURCE_CONTROL = "SOURCE_CONTROL"
    """SCM system, e.g. GIT, SVN"""
    
    OTHER = "OTHER"
    """Other sources"""
    
    
    
class OwnershipTypeClass(object):
    """Asset owner types"""
    
    CUSTOM = "CUSTOM"
    """Set when ownership type is unknown or a when new one is specified as an ownership type entity for which we have no
    enum value for. This is used for backwards compatibility"""
    
    TECHNICAL_OWNER = "TECHNICAL_OWNER"
    """person or group who is responsible for technical aspects of the asset."""
    
    BUSINESS_OWNER = "BUSINESS_OWNER"
    """A person or group who is responsible for logical, or business related, aspects of the asset."""
    
    DATA_STEWARD = "DATA_STEWARD"
    """A steward, expert, or delegate responsible for the asset."""
    
    NONE = "NONE"
    """No specific type associated to the owner."""
    
    DEVELOPER = "DEVELOPER"
    """A person or group that is in charge of developing the code
    Deprecated! Use TECHNICAL_OWNER instead."""
    
    DATAOWNER = "DATAOWNER"
    """A person or group that is owning the data
    Deprecated! Use TECHNICAL_OWNER instead."""
    
    DELEGATE = "DELEGATE"
    """A person or a group that overseas the operation, e.g. a DBA or SRE.
    Deprecated! Use TECHNICAL_OWNER instead."""
    
    PRODUCER = "PRODUCER"
    """A person, group, or service that produces/generates the data
    Deprecated! Use TECHNICAL_OWNER instead."""
    
    CONSUMER = "CONSUMER"
    """A person, group, or service that consumes the data
    Deprecated! Use TECHNICAL_OWNER or BUSINESS_OWNER instead."""
    
    STAKEHOLDER = "STAKEHOLDER"
    """A person or a group that has direct business interest
    Deprecated! Use TECHNICAL_OWNER, BUSINESS_OWNER, or STEWARD instead."""
    
    
    
class RoleAssociationClass(DictWrapper):
    """Properties of an applied Role. For now, just an Urn"""
    
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.common.RoleAssociation")
    def __init__(self,
        urn: str,
    ):
        super().__init__()
        
        self.urn = urn
    
    def _restore_defaults(self) -> None:
        self.urn = str()
    
    
    @property
    def urn(self) -> str:
        """Urn of the External Role"""
        return self._inner_dict.get('urn')  # type: ignore
    
    @urn.setter
    def urn(self, value: str) -> None:
        self._inner_dict['urn'] = value
    
    
class SiblingsClass(_Aspect):
    """Siblings information of an entity."""


    ASPECT_NAME = 'siblings'
    ASPECT_INFO = {}
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.common.Siblings")

    def __init__(self,
        siblings: List[str],
        primary: bool,
    ):
        super().__init__()
        
        self.siblings = siblings
        self.primary = primary
    
    def _restore_defaults(self) -> None:
        self.siblings = list()
        self.primary = bool()
    
    
    @property
    def siblings(self) -> List[str]:
        """List of sibling entities"""
        return self._inner_dict.get('siblings')  # type: ignore
    
    @siblings.setter
    def siblings(self, value: List[str]) -> None:
        self._inner_dict['siblings'] = value
    
    
    @property
    def primary(self) -> bool:
        """If this is the leader entity of the set of siblings"""
        return self._inner_dict.get('primary')  # type: ignore
    
    @primary.setter
    def primary(self, value: bool) -> None:
        self._inner_dict['primary'] = value
    
    
class StatusClass(_Aspect):
    """The lifecycle status metadata of an entity, e.g. dataset, metric, feature, etc.
    This aspect is used to represent soft deletes conventionally."""


    ASPECT_NAME = 'status'
    ASPECT_INFO = {}
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.common.Status")

    def __init__(self,
        removed: Optional[bool]=None,
    ):
        super().__init__()
        
        if removed is None:
            # default: False
            self.removed = self.RECORD_SCHEMA.fields_dict["removed"].default
        else:
            self.removed = removed
    
    def _restore_defaults(self) -> None:
        self.removed = self.RECORD_SCHEMA.fields_dict["removed"].default
    
    
    @property
    def removed(self) -> bool:
        """Whether the entity has been removed (soft-deleted)."""
        return self._inner_dict.get('removed')  # type: ignore
    
    @removed.setter
    def removed(self, value: bool) -> None:
        self._inner_dict['removed'] = value
    
    
class SubTypesClass(_Aspect):
    """Sub Types. Use this aspect to specialize a generic Entity
    e.g. Making a Dataset also be a View or also be a LookerExplore"""


    ASPECT_NAME = 'subTypes'
    ASPECT_INFO = {}
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.common.SubTypes")

    def __init__(self,
        typeNames: List[str],
    ):
        super().__init__()
        
        self.typeNames = typeNames
    
    def _restore_defaults(self) -> None:
        self.typeNames = list()
    
    
    @property
    def typeNames(self) -> List[str]:
        """The names of the specific types."""
        return self._inner_dict.get('typeNames')  # type: ignore
    
    @typeNames.setter
    def typeNames(self, value: List[str]) -> None:
        self._inner_dict['typeNames'] = value
    
    
class TagAssociationClass(DictWrapper):
    """Properties of an applied tag. For now, just an Urn. In the future we can extend this with other properties, e.g.
    propagation parameters."""
    
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.common.TagAssociation")
    def __init__(self,
        tag: str,
        context: Union[None, str]=None,
    ):
        super().__init__()
        
        self.tag = tag
        self.context = context
    
    def _restore_defaults(self) -> None:
        self.tag = str()
        self.context = self.RECORD_SCHEMA.fields_dict["context"].default
    
    
    @property
    def tag(self) -> str:
        """Urn of the applied tag"""
        return self._inner_dict.get('tag')  # type: ignore
    
    @tag.setter
    def tag(self, value: str) -> None:
        self._inner_dict['tag'] = value
    
    
    @property
    def context(self) -> Union[None, str]:
        """Additional context about the association"""
        return self._inner_dict.get('context')  # type: ignore
    
    @context.setter
    def context(self, value: Union[None, str]) -> None:
        self._inner_dict['context'] = value
    
    
class TimeStampClass(DictWrapper):
    """A standard event timestamp"""
    
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.common.TimeStamp")
    def __init__(self,
        time: int,
        actor: Union[None, str]=None,
    ):
        super().__init__()
        
        self.time = time
        self.actor = actor
    
    def _restore_defaults(self) -> None:
        self.time = int()
        self.actor = self.RECORD_SCHEMA.fields_dict["actor"].default
    
    
    @property
    def time(self) -> int:
        """When did the event occur"""
        return self._inner_dict.get('time')  # type: ignore
    
    @time.setter
    def time(self, value: int) -> None:
        self._inner_dict['time'] = value
    
    
    @property
    def actor(self) -> Union[None, str]:
        """Optional: The actor urn involved in the event."""
        return self._inner_dict.get('actor')  # type: ignore
    
    @actor.setter
    def actor(self, value: Union[None, str]) -> None:
        self._inner_dict['actor'] = value
    
    
class VersionTagClass(DictWrapper):
    """A resource-defined string representing the resource state for the purpose of concurrency control"""
    
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.common.VersionTag")
    def __init__(self,
        versionTag: Union[None, str]=None,
    ):
        super().__init__()
        
        self.versionTag = versionTag
    
    def _restore_defaults(self) -> None:
        self.versionTag = self.RECORD_SCHEMA.fields_dict["versionTag"].default
    
    
    @property
    def versionTag(self) -> Union[None, str]:
        # No docs available.
        return self._inner_dict.get('versionTag')  # type: ignore
    
    @versionTag.setter
    def versionTag(self, value: Union[None, str]) -> None:
        self._inner_dict['versionTag'] = value
    
    
class WindowDurationClass(object):
    """Enum to define the length of a bucket when doing aggregations"""
    
    YEAR = "YEAR"
    MONTH = "MONTH"
    WEEK = "WEEK"
    DAY = "DAY"
    HOUR = "HOUR"
    
    
class TransformationTypeClass(object):
    """Type of the transformation involved in generating destination fields from source fields."""
    
    BLACKBOX = "BLACKBOX"
    """Field transformation expressed as unknown black box function."""
    
    IDENTITY = "IDENTITY"
    """Field transformation expressed as Identity function."""
    
    
    
class UDFTransformerClass(DictWrapper):
    """Field transformation expressed in UDF"""
    
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.common.fieldtransformer.UDFTransformer")
    def __init__(self,
        udf: str,
    ):
        super().__init__()
        
        self.udf = udf
    
    def _restore_defaults(self) -> None:
        self.udf = str()
    
    
    @property
    def udf(self) -> str:
        """A UDF mentioning how the source fields got transformed to destination field. This is the FQCN(Fully Qualified Class Name) of the udf."""
        return self._inner_dict.get('udf')  # type: ignore
    
    @udf.setter
    def udf(self, value: str) -> None:
        self._inner_dict['udf'] = value
    
    
class ContainerClass(_Aspect):
    """Link from an asset to its parent container"""


    ASPECT_NAME = 'container'
    ASPECT_INFO = {}
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.container.Container")

    def __init__(self,
        container: str,
    ):
        super().__init__()
        
        self.container = container
    
    def _restore_defaults(self) -> None:
        self.container = str()
    
    
    @property
    def container(self) -> str:
        """The parent container of an asset"""
        return self._inner_dict.get('container')  # type: ignore
    
    @container.setter
    def container(self, value: str) -> None:
        self._inner_dict['container'] = value
    
    
class ContainerPropertiesClass(_Aspect):
    """Information about a Asset Container as received from a 3rd party source system"""


    ASPECT_NAME = 'containerProperties'
    ASPECT_INFO = {}
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.container.ContainerProperties")

    def __init__(self,
        name: str,
        customProperties: Optional[Dict[str, str]]=None,
        externalUrl: Union[None, str]=None,
        qualifiedName: Union[None, str]=None,
        description: Union[None, str]=None,
        created: Union[None, "TimeStampClass"]=None,
        lastModified: Union[None, "TimeStampClass"]=None,
    ):
        super().__init__()
        
        if customProperties is None:
            # default: {}
            self.customProperties = dict()
        else:
            self.customProperties = customProperties
        self.externalUrl = externalUrl
        self.name = name
        self.qualifiedName = qualifiedName
        self.description = description
        self.created = created
        self.lastModified = lastModified
    
    def _restore_defaults(self) -> None:
        self.customProperties = dict()
        self.externalUrl = self.RECORD_SCHEMA.fields_dict["externalUrl"].default
        self.name = str()
        self.qualifiedName = self.RECORD_SCHEMA.fields_dict["qualifiedName"].default
        self.description = self.RECORD_SCHEMA.fields_dict["description"].default
        self.created = self.RECORD_SCHEMA.fields_dict["created"].default
        self.lastModified = self.RECORD_SCHEMA.fields_dict["lastModified"].default
    
    
    @property
    def customProperties(self) -> Dict[str, str]:
        """Custom property bag."""
        return self._inner_dict.get('customProperties')  # type: ignore
    
    @customProperties.setter
    def customProperties(self, value: Dict[str, str]) -> None:
        self._inner_dict['customProperties'] = value
    
    
    @property
    def externalUrl(self) -> Union[None, str]:
        """URL where the reference exist"""
        return self._inner_dict.get('externalUrl')  # type: ignore
    
    @externalUrl.setter
    def externalUrl(self, value: Union[None, str]) -> None:
        self._inner_dict['externalUrl'] = value
    
    
    @property
    def name(self) -> str:
        """Display name of the Asset Container"""
        return self._inner_dict.get('name')  # type: ignore
    
    @name.setter
    def name(self, value: str) -> None:
        self._inner_dict['name'] = value
    
    
    @property
    def qualifiedName(self) -> Union[None, str]:
        """Fully-qualified name of the Container"""
        return self._inner_dict.get('qualifiedName')  # type: ignore
    
    @qualifiedName.setter
    def qualifiedName(self, value: Union[None, str]) -> None:
        self._inner_dict['qualifiedName'] = value
    
    
    @property
    def description(self) -> Union[None, str]:
        """Description of the Asset Container as it exists inside a source system"""
        return self._inner_dict.get('description')  # type: ignore
    
    @description.setter
    def description(self, value: Union[None, str]) -> None:
        self._inner_dict['description'] = value
    
    
    @property
    def created(self) -> Union[None, "TimeStampClass"]:
        """A timestamp documenting when the asset was created in the source Data Platform (not on DataHub)"""
        return self._inner_dict.get('created')  # type: ignore
    
    @created.setter
    def created(self, value: Union[None, "TimeStampClass"]) -> None:
        self._inner_dict['created'] = value
    
    
    @property
    def lastModified(self) -> Union[None, "TimeStampClass"]:
        """A timestamp documenting when the asset was last modified in the source Data Platform (not on DataHub)"""
        return self._inner_dict.get('lastModified')  # type: ignore
    
    @lastModified.setter
    def lastModified(self, value: Union[None, "TimeStampClass"]) -> None:
        self._inner_dict['lastModified'] = value
    
    
class EditableContainerPropertiesClass(_Aspect):
    """Editable information about an Asset Container as defined on the DataHub Platform"""


    ASPECT_NAME = 'editableContainerProperties'
    ASPECT_INFO = {}
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.container.EditableContainerProperties")

    def __init__(self,
        description: Union[None, str]=None,
    ):
        super().__init__()
        
        self.description = description
    
    def _restore_defaults(self) -> None:
        self.description = self.RECORD_SCHEMA.fields_dict["description"].default
    
    
    @property
    def description(self) -> Union[None, str]:
        """Description of the Asset Container as its received on the DataHub Platform"""
        return self._inner_dict.get('description')  # type: ignore
    
    @description.setter
    def description(self, value: Union[None, str]) -> None:
        self._inner_dict['description'] = value
    
    
class DashboardInfoClass(_Aspect):
    """Information about a dashboard"""


    ASPECT_NAME = 'dashboardInfo'
    ASPECT_INFO = {}
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.dashboard.DashboardInfo")

    def __init__(self,
        title: str,
        description: str,
        lastModified: "ChangeAuditStampsClass",
        customProperties: Optional[Dict[str, str]]=None,
        externalUrl: Union[None, str]=None,
        charts: Optional[List[str]]=None,
        chartEdges: Union[None, List["EdgeClass"]]=None,
        datasets: Optional[List[str]]=None,
        datasetEdges: Union[None, List["EdgeClass"]]=None,
        dashboardUrl: Union[None, str]=None,
        access: Union[None, Union[str, "AccessLevelClass"]]=None,
        lastRefreshed: Union[None, int]=None,
    ):
        super().__init__()
        
        if customProperties is None:
            # default: {}
            self.customProperties = dict()
        else:
            self.customProperties = customProperties
        self.externalUrl = externalUrl
        self.title = title
        self.description = description
        if charts is None:
            # default: []
            self.charts = list()
        else:
            self.charts = charts
        self.chartEdges = chartEdges
        if datasets is None:
            # default: []
            self.datasets = list()
        else:
            self.datasets = datasets
        self.datasetEdges = datasetEdges
        self.lastModified = lastModified
        self.dashboardUrl = dashboardUrl
        self.access = access
        self.lastRefreshed = lastRefreshed
    
    def _restore_defaults(self) -> None:
        self.customProperties = dict()
        self.externalUrl = self.RECORD_SCHEMA.fields_dict["externalUrl"].default
        self.title = str()
        self.description = str()
        self.charts = list()
        self.chartEdges = self.RECORD_SCHEMA.fields_dict["chartEdges"].default
        self.datasets = list()
        self.datasetEdges = self.RECORD_SCHEMA.fields_dict["datasetEdges"].default
        self.lastModified = ChangeAuditStampsClass._construct_with_defaults()
        self.dashboardUrl = self.RECORD_SCHEMA.fields_dict["dashboardUrl"].default
        self.access = self.RECORD_SCHEMA.fields_dict["access"].default
        self.lastRefreshed = self.RECORD_SCHEMA.fields_dict["lastRefreshed"].default
    
    
    @property
    def customProperties(self) -> Dict[str, str]:
        """Custom property bag."""
        return self._inner_dict.get('customProperties')  # type: ignore
    
    @customProperties.setter
    def customProperties(self, value: Dict[str, str]) -> None:
        self._inner_dict['customProperties'] = value
    
    
    @property
    def externalUrl(self) -> Union[None, str]:
        """URL where the reference exist"""
        return self._inner_dict.get('externalUrl')  # type: ignore
    
    @externalUrl.setter
    def externalUrl(self, value: Union[None, str]) -> None:
        self._inner_dict['externalUrl'] = value
    
    
    @property
    def title(self) -> str:
        """Title of the dashboard"""
        return self._inner_dict.get('title')  # type: ignore
    
    @title.setter
    def title(self, value: str) -> None:
        self._inner_dict['title'] = value
    
    
    @property
    def description(self) -> str:
        """Detailed description about the dashboard"""
        return self._inner_dict.get('description')  # type: ignore
    
    @description.setter
    def description(self, value: str) -> None:
        self._inner_dict['description'] = value
    
    
    @property
    def charts(self) -> List[str]:
        """Charts in a dashboard
    Deprecated! Use chartEdges instead."""
        return self._inner_dict.get('charts')  # type: ignore
    
    @charts.setter
    def charts(self, value: List[str]) -> None:
        self._inner_dict['charts'] = value
    
    
    @property
    def chartEdges(self) -> Union[None, List["EdgeClass"]]:
        """Charts in a dashboard"""
        return self._inner_dict.get('chartEdges')  # type: ignore
    
    @chartEdges.setter
    def chartEdges(self, value: Union[None, List["EdgeClass"]]) -> None:
        self._inner_dict['chartEdges'] = value
    
    
    @property
    def datasets(self) -> List[str]:
        """Datasets consumed by a dashboard
    Deprecated! Use datasetEdges instead."""
        return self._inner_dict.get('datasets')  # type: ignore
    
    @datasets.setter
    def datasets(self, value: List[str]) -> None:
        self._inner_dict['datasets'] = value
    
    
    @property
    def datasetEdges(self) -> Union[None, List["EdgeClass"]]:
        """Datasets consumed by a dashboard"""
        return self._inner_dict.get('datasetEdges')  # type: ignore
    
    @datasetEdges.setter
    def datasetEdges(self, value: Union[None, List["EdgeClass"]]) -> None:
        self._inner_dict['datasetEdges'] = value
    
    
    @property
    def lastModified(self) -> "ChangeAuditStampsClass":
        """Captures information about who created/last modified/deleted this dashboard and when"""
        return self._inner_dict.get('lastModified')  # type: ignore
    
    @lastModified.setter
    def lastModified(self, value: "ChangeAuditStampsClass") -> None:
        self._inner_dict['lastModified'] = value
    
    
    @property
    def dashboardUrl(self) -> Union[None, str]:
        """URL for the dashboard. This could be used as an external link on DataHub to allow users access/view the dashboard"""
        return self._inner_dict.get('dashboardUrl')  # type: ignore
    
    @dashboardUrl.setter
    def dashboardUrl(self, value: Union[None, str]) -> None:
        self._inner_dict['dashboardUrl'] = value
    
    
    @property
    def access(self) -> Union[None, Union[str, "AccessLevelClass"]]:
        """Access level for the dashboard"""
        return self._inner_dict.get('access')  # type: ignore
    
    @access.setter
    def access(self, value: Union[None, Union[str, "AccessLevelClass"]]) -> None:
        self._inner_dict['access'] = value
    
    
    @property
    def lastRefreshed(self) -> Union[None, int]:
        """The time when this dashboard last refreshed"""
        return self._inner_dict.get('lastRefreshed')  # type: ignore
    
    @lastRefreshed.setter
    def lastRefreshed(self, value: Union[None, int]) -> None:
        self._inner_dict['lastRefreshed'] = value
    
    
class DashboardUsageStatisticsClass(_Aspect):
    """Experimental (Subject to breaking change) -- Stats corresponding to dashboard's usage.
    
    If this aspect represents the latest snapshot of the statistics about a Dashboard, the eventGranularity field should be null. 
    If this aspect represents a bucketed window of usage statistics (e.g. over a day), then the eventGranularity field should be set accordingly. """


    ASPECT_NAME = 'dashboardUsageStatistics'
    ASPECT_TYPE = 'timeseries'
    ASPECT_INFO = {}
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.dashboard.DashboardUsageStatistics")

    def __init__(self,
        timestampMillis: int,
        eventGranularity: Union[None, "TimeWindowSizeClass"]=None,
        partitionSpec: Optional[Union["PartitionSpecClass", None]]=None,
        messageId: Union[None, str]=None,
        viewsCount: Union[None, int]=None,
        executionsCount: Union[None, int]=None,
        uniqueUserCount: Union[None, int]=None,
        userCounts: Union[None, List["DashboardUserUsageCountsClass"]]=None,
        favoritesCount: Union[None, int]=None,
        lastViewedAt: Union[None, int]=None,
    ):
        super().__init__()
        
        self.timestampMillis = timestampMillis
        self.eventGranularity = eventGranularity
        if partitionSpec is None:
            # default: {'partition': 'FULL_TABLE_SNAPSHOT', 'type': 'FULL_TABLE', 'timePartition': None}
            self.partitionSpec = _json_converter.from_json_object(self.RECORD_SCHEMA.fields_dict["partitionSpec"].default, writers_schema=self.RECORD_SCHEMA.fields_dict["partitionSpec"].type)
        else:
            self.partitionSpec = partitionSpec
        self.messageId = messageId
        self.viewsCount = viewsCount
        self.executionsCount = executionsCount
        self.uniqueUserCount = uniqueUserCount
        self.userCounts = userCounts
        self.favoritesCount = favoritesCount
        self.lastViewedAt = lastViewedAt
    
    def _restore_defaults(self) -> None:
        self.timestampMillis = int()
        self.eventGranularity = self.RECORD_SCHEMA.fields_dict["eventGranularity"].default
        self.partitionSpec = _json_converter.from_json_object(self.RECORD_SCHEMA.fields_dict["partitionSpec"].default, writers_schema=self.RECORD_SCHEMA.fields_dict["partitionSpec"].type)
        self.messageId = self.RECORD_SCHEMA.fields_dict["messageId"].default
        self.viewsCount = self.RECORD_SCHEMA.fields_dict["viewsCount"].default
        self.executionsCount = self.RECORD_SCHEMA.fields_dict["executionsCount"].default
        self.uniqueUserCount = self.RECORD_SCHEMA.fields_dict["uniqueUserCount"].default
        self.userCounts = self.RECORD_SCHEMA.fields_dict["userCounts"].default
        self.favoritesCount = self.RECORD_SCHEMA.fields_dict["favoritesCount"].default
        self.lastViewedAt = self.RECORD_SCHEMA.fields_dict["lastViewedAt"].default
    
    
    @property
    def timestampMillis(self) -> int:
        """The event timestamp field as epoch at UTC in milli seconds."""
        return self._inner_dict.get('timestampMillis')  # type: ignore
    
    @timestampMillis.setter
    def timestampMillis(self, value: int) -> None:
        self._inner_dict['timestampMillis'] = value
    
    
    @property
    def eventGranularity(self) -> Union[None, "TimeWindowSizeClass"]:
        """Granularity of the event if applicable"""
        return self._inner_dict.get('eventGranularity')  # type: ignore
    
    @eventGranularity.setter
    def eventGranularity(self, value: Union[None, "TimeWindowSizeClass"]) -> None:
        self._inner_dict['eventGranularity'] = value
    
    
    @property
    def partitionSpec(self) -> Union["PartitionSpecClass", None]:
        """The optional partition specification."""
        return self._inner_dict.get('partitionSpec')  # type: ignore
    
    @partitionSpec.setter
    def partitionSpec(self, value: Union["PartitionSpecClass", None]) -> None:
        self._inner_dict['partitionSpec'] = value
    
    
    @property
    def messageId(self) -> Union[None, str]:
        """The optional messageId, if provided serves as a custom user-defined unique identifier for an aspect value."""
        return self._inner_dict.get('messageId')  # type: ignore
    
    @messageId.setter
    def messageId(self, value: Union[None, str]) -> None:
        self._inner_dict['messageId'] = value
    
    
    @property
    def viewsCount(self) -> Union[None, int]:
        """The total number of times dashboard has been viewed"""
        return self._inner_dict.get('viewsCount')  # type: ignore
    
    @viewsCount.setter
    def viewsCount(self, value: Union[None, int]) -> None:
        self._inner_dict['viewsCount'] = value
    
    
    @property
    def executionsCount(self) -> Union[None, int]:
        """The total number of dashboard executions (refreshes / syncs) """
        return self._inner_dict.get('executionsCount')  # type: ignore
    
    @executionsCount.setter
    def executionsCount(self, value: Union[None, int]) -> None:
        self._inner_dict['executionsCount'] = value
    
    
    @property
    def uniqueUserCount(self) -> Union[None, int]:
        """Unique user count"""
        return self._inner_dict.get('uniqueUserCount')  # type: ignore
    
    @uniqueUserCount.setter
    def uniqueUserCount(self, value: Union[None, int]) -> None:
        self._inner_dict['uniqueUserCount'] = value
    
    
    @property
    def userCounts(self) -> Union[None, List["DashboardUserUsageCountsClass"]]:
        """Users within this bucket, with frequency counts"""
        return self._inner_dict.get('userCounts')  # type: ignore
    
    @userCounts.setter
    def userCounts(self, value: Union[None, List["DashboardUserUsageCountsClass"]]) -> None:
        self._inner_dict['userCounts'] = value
    
    
    @property
    def favoritesCount(self) -> Union[None, int]:
        """The total number of times that the dashboard has been favorited """
        return self._inner_dict.get('favoritesCount')  # type: ignore
    
    @favoritesCount.setter
    def favoritesCount(self, value: Union[None, int]) -> None:
        self._inner_dict['favoritesCount'] = value
    
    
    @property
    def lastViewedAt(self) -> Union[None, int]:
        """Last viewed at
    
    This should not be set in cases where statistics are windowed. """
        return self._inner_dict.get('lastViewedAt')  # type: ignore
    
    @lastViewedAt.setter
    def lastViewedAt(self, value: Union[None, int]) -> None:
        self._inner_dict['lastViewedAt'] = value
    
    
class DashboardUserUsageCountsClass(DictWrapper):
    """Records a single user's usage counts for a given resource"""
    
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.dashboard.DashboardUserUsageCounts")
    def __init__(self,
        user: str,
        viewsCount: Union[None, int]=None,
        executionsCount: Union[None, int]=None,
        usageCount: Union[None, int]=None,
        userEmail: Union[None, str]=None,
    ):
        super().__init__()
        
        self.user = user
        self.viewsCount = viewsCount
        self.executionsCount = executionsCount
        self.usageCount = usageCount
        self.userEmail = userEmail
    
    def _restore_defaults(self) -> None:
        self.user = str()
        self.viewsCount = self.RECORD_SCHEMA.fields_dict["viewsCount"].default
        self.executionsCount = self.RECORD_SCHEMA.fields_dict["executionsCount"].default
        self.usageCount = self.RECORD_SCHEMA.fields_dict["usageCount"].default
        self.userEmail = self.RECORD_SCHEMA.fields_dict["userEmail"].default
    
    
    @property
    def user(self) -> str:
        """The unique id of the user."""
        return self._inner_dict.get('user')  # type: ignore
    
    @user.setter
    def user(self, value: str) -> None:
        self._inner_dict['user'] = value
    
    
    @property
    def viewsCount(self) -> Union[None, int]:
        """The number of times the user has viewed the dashboard"""
        return self._inner_dict.get('viewsCount')  # type: ignore
    
    @viewsCount.setter
    def viewsCount(self, value: Union[None, int]) -> None:
        self._inner_dict['viewsCount'] = value
    
    
    @property
    def executionsCount(self) -> Union[None, int]:
        """The number of times the user has executed (refreshed) the dashboard"""
        return self._inner_dict.get('executionsCount')  # type: ignore
    
    @executionsCount.setter
    def executionsCount(self, value: Union[None, int]) -> None:
        self._inner_dict['executionsCount'] = value
    
    
    @property
    def usageCount(self) -> Union[None, int]:
        """Normalized numeric metric representing user's dashboard usage -- the number of times the user executed or viewed the dashboard. """
        return self._inner_dict.get('usageCount')  # type: ignore
    
    @usageCount.setter
    def usageCount(self, value: Union[None, int]) -> None:
        self._inner_dict['usageCount'] = value
    
    
    @property
    def userEmail(self) -> Union[None, str]:
        """If user_email is set, we attempt to resolve the user's urn upon ingest"""
        return self._inner_dict.get('userEmail')  # type: ignore
    
    @userEmail.setter
    def userEmail(self, value: Union[None, str]) -> None:
        self._inner_dict['userEmail'] = value
    
    
class EditableDashboardPropertiesClass(_Aspect):
    """Stores editable changes made to properties. This separates changes made from
    ingestion pipelines and edits in the UI to avoid accidental overwrites of user-provided data by ingestion pipelines"""


    ASPECT_NAME = 'editableDashboardProperties'
    ASPECT_INFO = {}
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.dashboard.EditableDashboardProperties")

    def __init__(self,
        created: Optional["AuditStampClass"]=None,
        lastModified: Optional["AuditStampClass"]=None,
        deleted: Union[None, "AuditStampClass"]=None,
        description: Union[None, str]=None,
    ):
        super().__init__()
        
        if created is None:
            # default: {'actor': 'urn:li:corpuser:unknown', 'impersonator': None, 'time': 0, 'message': None}
            self.created = _json_converter.from_json_object(self.RECORD_SCHEMA.fields_dict["created"].default, writers_schema=self.RECORD_SCHEMA.fields_dict["created"].type)
        else:
            self.created = created
        if lastModified is None:
            # default: {'actor': 'urn:li:corpuser:unknown', 'impersonator': None, 'time': 0, 'message': None}
            self.lastModified = _json_converter.from_json_object(self.RECORD_SCHEMA.fields_dict["lastModified"].default, writers_schema=self.RECORD_SCHEMA.fields_dict["lastModified"].type)
        else:
            self.lastModified = lastModified
        self.deleted = deleted
        self.description = description
    
    def _restore_defaults(self) -> None:
        self.created = _json_converter.from_json_object(self.RECORD_SCHEMA.fields_dict["created"].default, writers_schema=self.RECORD_SCHEMA.fields_dict["created"].type)
        self.lastModified = _json_converter.from_json_object(self.RECORD_SCHEMA.fields_dict["lastModified"].default, writers_schema=self.RECORD_SCHEMA.fields_dict["lastModified"].type)
        self.deleted = self.RECORD_SCHEMA.fields_dict["deleted"].default
        self.description = self.RECORD_SCHEMA.fields_dict["description"].default
    
    
    @property
    def created(self) -> "AuditStampClass":
        """An AuditStamp corresponding to the creation of this resource/association/sub-resource. A value of 0 for time indicates missing data."""
        return self._inner_dict.get('created')  # type: ignore
    
    @created.setter
    def created(self, value: "AuditStampClass") -> None:
        self._inner_dict['created'] = value
    
    
    @property
    def lastModified(self) -> "AuditStampClass":
        """An AuditStamp corresponding to the last modification of this resource/association/sub-resource. If no modification has happened since creation, lastModified should be the same as created. A value of 0 for time indicates missing data."""
        return self._inner_dict.get('lastModified')  # type: ignore
    
    @lastModified.setter
    def lastModified(self, value: "AuditStampClass") -> None:
        self._inner_dict['lastModified'] = value
    
    
    @property
    def deleted(self) -> Union[None, "AuditStampClass"]:
        """An AuditStamp corresponding to the deletion of this resource/association/sub-resource. Logically, deleted MUST have a later timestamp than creation. It may or may not have the same time as lastModified depending upon the resource/association/sub-resource semantics."""
        return self._inner_dict.get('deleted')  # type: ignore
    
    @deleted.setter
    def deleted(self, value: Union[None, "AuditStampClass"]) -> None:
        self._inner_dict['deleted'] = value
    
    
    @property
    def description(self) -> Union[None, str]:
        """Edited documentation of the dashboard"""
        return self._inner_dict.get('description')  # type: ignore
    
    @description.setter
    def description(self, value: Union[None, str]) -> None:
        self._inner_dict['description'] = value
    
    
class DataContractPropertiesClass(_Aspect):
    """Information about a data contract"""


    ASPECT_NAME = 'dataContractProperties'
    ASPECT_INFO = {}
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.datacontract.DataContractProperties")

    def __init__(self,
        entity: str,
        schema: Union[None, List["SchemaContractClass"]]=None,
        freshness: Union[None, List["FreshnessContractClass"]]=None,
        dataQuality: Union[None, List["DataQualityContractClass"]]=None,
        rawContract: Union[None, str]=None,
    ):
        super().__init__()
        
        self.entity = entity
        self.schema = schema
        self.freshness = freshness
        self.dataQuality = dataQuality
        self.rawContract = rawContract
    
    def _restore_defaults(self) -> None:
        self.entity = str()
        self.schema = self.RECORD_SCHEMA.fields_dict["schema"].default
        self.freshness = self.RECORD_SCHEMA.fields_dict["freshness"].default
        self.dataQuality = self.RECORD_SCHEMA.fields_dict["dataQuality"].default
        self.rawContract = self.RECORD_SCHEMA.fields_dict["rawContract"].default
    
    
    @property
    def entity(self) -> str:
        """The entity that this contract is associated with. Currently, we only support Dataset contracts, but
    in the future we may also support Data Product level contracts."""
        return self._inner_dict.get('entity')  # type: ignore
    
    @entity.setter
    def entity(self, value: str) -> None:
        self._inner_dict['entity'] = value
    
    
    @property
    def schema(self) -> Union[None, List["SchemaContractClass"]]:
        """An optional set of schema contracts. If this is a dataset contract, there will only be one."""
        return self._inner_dict.get('schema')  # type: ignore
    
    @schema.setter
    def schema(self, value: Union[None, List["SchemaContractClass"]]) -> None:
        self._inner_dict['schema'] = value
    
    
    @property
    def freshness(self) -> Union[None, List["FreshnessContractClass"]]:
        """An optional set of FRESHNESS contracts. If this is a dataset contract, there will only be one."""
        return self._inner_dict.get('freshness')  # type: ignore
    
    @freshness.setter
    def freshness(self, value: Union[None, List["FreshnessContractClass"]]) -> None:
        self._inner_dict['freshness'] = value
    
    
    @property
    def dataQuality(self) -> Union[None, List["DataQualityContractClass"]]:
        """An optional set of Data Quality contracts, e.g. table and column level contract constraints."""
        return self._inner_dict.get('dataQuality')  # type: ignore
    
    @dataQuality.setter
    def dataQuality(self, value: Union[None, List["DataQualityContractClass"]]) -> None:
        self._inner_dict['dataQuality'] = value
    
    
    @property
    def rawContract(self) -> Union[None, str]:
        """YAML-formatted contract definition"""
        return self._inner_dict.get('rawContract')  # type: ignore
    
    @rawContract.setter
    def rawContract(self, value: Union[None, str]) -> None:
        self._inner_dict['rawContract'] = value
    
    
class DataContractStateClass(object):
    # No docs available.
    
    ACTIVE = "ACTIVE"
    """The data contract is active."""
    
    PENDING = "PENDING"
    """The data contract is pending implementation."""
    
    
    
class DataContractStatusClass(_Aspect):
    """Information about the status of a data contract"""


    ASPECT_NAME = 'dataContractStatus'
    ASPECT_INFO = {}
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.datacontract.DataContractStatus")

    def __init__(self,
        state: Union[str, "DataContractStateClass"],
        customProperties: Optional[Dict[str, str]]=None,
    ):
        super().__init__()
        
        if customProperties is None:
            # default: {}
            self.customProperties = dict()
        else:
            self.customProperties = customProperties
        self.state = state
    
    def _restore_defaults(self) -> None:
        self.customProperties = dict()
        self.state = DataContractStateClass.ACTIVE
    
    
    @property
    def customProperties(self) -> Dict[str, str]:
        """Custom property bag."""
        return self._inner_dict.get('customProperties')  # type: ignore
    
    @customProperties.setter
    def customProperties(self, value: Dict[str, str]) -> None:
        self._inner_dict['customProperties'] = value
    
    
    @property
    def state(self) -> Union[str, "DataContractStateClass"]:
        """The latest state of the data contract"""
        return self._inner_dict.get('state')  # type: ignore
    
    @state.setter
    def state(self, value: Union[str, "DataContractStateClass"]) -> None:
        self._inner_dict['state'] = value
    
    
class DataQualityContractClass(DictWrapper):
    """A data quality contract pertaining to a physical data asset
    Data Quality contracts are used to make assertions about data quality metrics for a physical data asset"""
    
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.datacontract.DataQualityContract")
    def __init__(self,
        assertion: str,
    ):
        super().__init__()
        
        self.assertion = assertion
    
    def _restore_defaults(self) -> None:
        self.assertion = str()
    
    
    @property
    def assertion(self) -> str:
        """The assertion representing the Data Quality contract.
    E.g. a table or column-level assertion."""
        return self._inner_dict.get('assertion')  # type: ignore
    
    @assertion.setter
    def assertion(self, value: str) -> None:
        self._inner_dict['assertion'] = value
    
    
class FreshnessContractClass(DictWrapper):
    """A contract pertaining to the operational SLAs of a physical data asset"""
    
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.datacontract.FreshnessContract")
    def __init__(self,
        assertion: str,
    ):
        super().__init__()
        
        self.assertion = assertion
    
    def _restore_defaults(self) -> None:
        self.assertion = str()
    
    
    @property
    def assertion(self) -> str:
        """The assertion representing the SLA contract."""
        return self._inner_dict.get('assertion')  # type: ignore
    
    @assertion.setter
    def assertion(self, value: str) -> None:
        self._inner_dict['assertion'] = value
    
    
class SchemaContractClass(DictWrapper):
    """Expectations for a logical schema"""
    
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.datacontract.SchemaContract")
    def __init__(self,
        assertion: str,
    ):
        super().__init__()
        
        self.assertion = assertion
    
    def _restore_defaults(self) -> None:
        self.assertion = str()
    
    
    @property
    def assertion(self) -> str:
        """The assertion representing the schema contract."""
        return self._inner_dict.get('assertion')  # type: ignore
    
    @assertion.setter
    def assertion(self, value: str) -> None:
        self._inner_dict['assertion'] = value
    
    
class DataHubSearchConfigClass(DictWrapper):
    """Configuration for how any given field should be indexed and matched in the DataHub search index."""
    
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.datahub.DataHubSearchConfig")
    def __init__(self,
        fieldName: Union[None, str]=None,
        fieldType: Union[None, Union[str, "SearchFieldTypeClass"]]=None,
        queryByDefault: Optional[bool]=None,
        enableAutocomplete: Optional[bool]=None,
        addToFilters: Optional[bool]=None,
        addHasValuesToFilters: Optional[bool]=None,
        filterNameOverride: Union[None, str]=None,
        hasValuesFilterNameOverride: Union[None, str]=None,
        boostScore: Optional[float]=None,
        hasValuesFieldName: Union[None, str]=None,
        numValuesFieldName: Union[None, str]=None,
        weightsPerFieldValue: Union[None, Dict[str, float]]=None,
        fieldNameAliases: Union[None, List[str]]=None,
    ):
        super().__init__()
        
        self.fieldName = fieldName
        self.fieldType = fieldType
        if queryByDefault is None:
            # default: False
            self.queryByDefault = self.RECORD_SCHEMA.fields_dict["queryByDefault"].default
        else:
            self.queryByDefault = queryByDefault
        if enableAutocomplete is None:
            # default: False
            self.enableAutocomplete = self.RECORD_SCHEMA.fields_dict["enableAutocomplete"].default
        else:
            self.enableAutocomplete = enableAutocomplete
        if addToFilters is None:
            # default: False
            self.addToFilters = self.RECORD_SCHEMA.fields_dict["addToFilters"].default
        else:
            self.addToFilters = addToFilters
        if addHasValuesToFilters is None:
            # default: True
            self.addHasValuesToFilters = self.RECORD_SCHEMA.fields_dict["addHasValuesToFilters"].default
        else:
            self.addHasValuesToFilters = addHasValuesToFilters
        self.filterNameOverride = filterNameOverride
        self.hasValuesFilterNameOverride = hasValuesFilterNameOverride
        if boostScore is None:
            # default: 1.0
            self.boostScore = self.RECORD_SCHEMA.fields_dict["boostScore"].default
        else:
            self.boostScore = boostScore
        self.hasValuesFieldName = hasValuesFieldName
        self.numValuesFieldName = numValuesFieldName
        self.weightsPerFieldValue = weightsPerFieldValue
        self.fieldNameAliases = fieldNameAliases
    
    def _restore_defaults(self) -> None:
        self.fieldName = self.RECORD_SCHEMA.fields_dict["fieldName"].default
        self.fieldType = self.RECORD_SCHEMA.fields_dict["fieldType"].default
        self.queryByDefault = self.RECORD_SCHEMA.fields_dict["queryByDefault"].default
        self.enableAutocomplete = self.RECORD_SCHEMA.fields_dict["enableAutocomplete"].default
        self.addToFilters = self.RECORD_SCHEMA.fields_dict["addToFilters"].default
        self.addHasValuesToFilters = self.RECORD_SCHEMA.fields_dict["addHasValuesToFilters"].default
        self.filterNameOverride = self.RECORD_SCHEMA.fields_dict["filterNameOverride"].default
        self.hasValuesFilterNameOverride = self.RECORD_SCHEMA.fields_dict["hasValuesFilterNameOverride"].default
        self.boostScore = self.RECORD_SCHEMA.fields_dict["boostScore"].default
        self.hasValuesFieldName = self.RECORD_SCHEMA.fields_dict["hasValuesFieldName"].default
        self.numValuesFieldName = self.RECORD_SCHEMA.fields_dict["numValuesFieldName"].default
        self.weightsPerFieldValue = self.RECORD_SCHEMA.fields_dict["weightsPerFieldValue"].default
        self.fieldNameAliases = self.RECORD_SCHEMA.fields_dict["fieldNameAliases"].default
    
    
    @property
    def fieldName(self) -> Union[None, str]:
        """Name of the field in the search index. Defaults to the field name otherwise"""
        return self._inner_dict.get('fieldName')  # type: ignore
    
    @fieldName.setter
    def fieldName(self, value: Union[None, str]) -> None:
        self._inner_dict['fieldName'] = value
    
    
    @property
    def fieldType(self) -> Union[None, Union[str, "SearchFieldTypeClass"]]:
        """Type of the field. Defines how the field is indexed and matched"""
        return self._inner_dict.get('fieldType')  # type: ignore
    
    @fieldType.setter
    def fieldType(self, value: Union[None, Union[str, "SearchFieldTypeClass"]]) -> None:
        self._inner_dict['fieldType'] = value
    
    
    @property
    def queryByDefault(self) -> bool:
        """Whether we should match the field for the default search query"""
        return self._inner_dict.get('queryByDefault')  # type: ignore
    
    @queryByDefault.setter
    def queryByDefault(self, value: bool) -> None:
        self._inner_dict['queryByDefault'] = value
    
    
    @property
    def enableAutocomplete(self) -> bool:
        """Whether we should use the field for default autocomplete"""
        return self._inner_dict.get('enableAutocomplete')  # type: ignore
    
    @enableAutocomplete.setter
    def enableAutocomplete(self, value: bool) -> None:
        self._inner_dict['enableAutocomplete'] = value
    
    
    @property
    def addToFilters(self) -> bool:
        """Whether or not to add field to filters."""
        return self._inner_dict.get('addToFilters')  # type: ignore
    
    @addToFilters.setter
    def addToFilters(self, value: bool) -> None:
        self._inner_dict['addToFilters'] = value
    
    
    @property
    def addHasValuesToFilters(self) -> bool:
        """Whether or not to add the "has values" to filters.
    check if this is conditional on addToFilters being true"""
        return self._inner_dict.get('addHasValuesToFilters')  # type: ignore
    
    @addHasValuesToFilters.setter
    def addHasValuesToFilters(self, value: bool) -> None:
        self._inner_dict['addHasValuesToFilters'] = value
    
    
    @property
    def filterNameOverride(self) -> Union[None, str]:
        """Display name of the filter"""
        return self._inner_dict.get('filterNameOverride')  # type: ignore
    
    @filterNameOverride.setter
    def filterNameOverride(self, value: Union[None, str]) -> None:
        self._inner_dict['filterNameOverride'] = value
    
    
    @property
    def hasValuesFilterNameOverride(self) -> Union[None, str]:
        """Display name of the has values filter"""
        return self._inner_dict.get('hasValuesFilterNameOverride')  # type: ignore
    
    @hasValuesFilterNameOverride.setter
    def hasValuesFilterNameOverride(self, value: Union[None, str]) -> None:
        self._inner_dict['hasValuesFilterNameOverride'] = value
    
    
    @property
    def boostScore(self) -> float:
        """Boost multiplier to the match score. Matches on fields with higher boost score ranks higher"""
        return self._inner_dict.get('boostScore')  # type: ignore
    
    @boostScore.setter
    def boostScore(self, value: float) -> None:
        self._inner_dict['boostScore'] = value
    
    
    @property
    def hasValuesFieldName(self) -> Union[None, str]:
        """If set, add a index field of the given name that checks whether the field exists"""
        return self._inner_dict.get('hasValuesFieldName')  # type: ignore
    
    @hasValuesFieldName.setter
    def hasValuesFieldName(self, value: Union[None, str]) -> None:
        self._inner_dict['hasValuesFieldName'] = value
    
    
    @property
    def numValuesFieldName(self) -> Union[None, str]:
        """If set, add a index field of the given name that checks the number of elements"""
        return self._inner_dict.get('numValuesFieldName')  # type: ignore
    
    @numValuesFieldName.setter
    def numValuesFieldName(self, value: Union[None, str]) -> None:
        self._inner_dict['numValuesFieldName'] = value
    
    
    @property
    def weightsPerFieldValue(self) -> Union[None, Dict[str, float]]:
        """(Optional) Weights to apply to score for a given value"""
        return self._inner_dict.get('weightsPerFieldValue')  # type: ignore
    
    @weightsPerFieldValue.setter
    def weightsPerFieldValue(self, value: Union[None, Dict[str, float]]) -> None:
        self._inner_dict['weightsPerFieldValue'] = value
    
    
    @property
    def fieldNameAliases(self) -> Union[None, List[str]]:
        """(Optional) Aliases for this given field that can be used for sorting etc."""
        return self._inner_dict.get('fieldNameAliases')  # type: ignore
    
    @fieldNameAliases.setter
    def fieldNameAliases(self, value: Union[None, List[str]]) -> None:
        self._inner_dict['fieldNameAliases'] = value
    
    
class SearchFieldTypeClass(object):
    # No docs available.
    
    KEYWORD = "KEYWORD"
    TEXT = "TEXT"
    TEXT_PARTIAL = "TEXT_PARTIAL"
    BROWSE_PATH = "BROWSE_PATH"
    URN = "URN"
    URN_PARTIAL = "URN_PARTIAL"
    BOOLEAN = "BOOLEAN"
    COUNT = "COUNT"
    DATETIME = "DATETIME"
    OBJECT = "OBJECT"
    BROWSE_PATH_V2 = "BROWSE_PATH_V2"
    WORD_GRAM = "WORD_GRAM"
    
    
class DataFlowInfoClass(_Aspect):
    """Information about a Data processing flow"""


    ASPECT_NAME = 'dataFlowInfo'
    ASPECT_INFO = {}
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.datajob.DataFlowInfo")

    def __init__(self,
        name: str,
        customProperties: Optional[Dict[str, str]]=None,
        externalUrl: Union[None, str]=None,
        description: Union[None, str]=None,
        project: Union[None, str]=None,
        created: Union[None, "TimeStampClass"]=None,
        lastModified: Union[None, "TimeStampClass"]=None,
    ):
        super().__init__()
        
        if customProperties is None:
            # default: {}
            self.customProperties = dict()
        else:
            self.customProperties = customProperties
        self.externalUrl = externalUrl
        self.name = name
        self.description = description
        self.project = project
        self.created = created
        self.lastModified = lastModified
    
    def _restore_defaults(self) -> None:
        self.customProperties = dict()
        self.externalUrl = self.RECORD_SCHEMA.fields_dict["externalUrl"].default
        self.name = str()
        self.description = self.RECORD_SCHEMA.fields_dict["description"].default
        self.project = self.RECORD_SCHEMA.fields_dict["project"].default
        self.created = self.RECORD_SCHEMA.fields_dict["created"].default
        self.lastModified = self.RECORD_SCHEMA.fields_dict["lastModified"].default
    
    
    @property
    def customProperties(self) -> Dict[str, str]:
        """Custom property bag."""
        return self._inner_dict.get('customProperties')  # type: ignore
    
    @customProperties.setter
    def customProperties(self, value: Dict[str, str]) -> None:
        self._inner_dict['customProperties'] = value
    
    
    @property
    def externalUrl(self) -> Union[None, str]:
        """URL where the reference exist"""
        return self._inner_dict.get('externalUrl')  # type: ignore
    
    @externalUrl.setter
    def externalUrl(self, value: Union[None, str]) -> None:
        self._inner_dict['externalUrl'] = value
    
    
    @property
    def name(self) -> str:
        """Flow name"""
        return self._inner_dict.get('name')  # type: ignore
    
    @name.setter
    def name(self, value: str) -> None:
        self._inner_dict['name'] = value
    
    
    @property
    def description(self) -> Union[None, str]:
        """Flow description"""
        return self._inner_dict.get('description')  # type: ignore
    
    @description.setter
    def description(self, value: Union[None, str]) -> None:
        self._inner_dict['description'] = value
    
    
    @property
    def project(self) -> Union[None, str]:
        """Optional project/namespace associated with the flow"""
        return self._inner_dict.get('project')  # type: ignore
    
    @project.setter
    def project(self, value: Union[None, str]) -> None:
        self._inner_dict['project'] = value
    
    
    @property
    def created(self) -> Union[None, "TimeStampClass"]:
        """A timestamp documenting when the asset was created in the source Data Platform (not on DataHub)"""
        return self._inner_dict.get('created')  # type: ignore
    
    @created.setter
    def created(self, value: Union[None, "TimeStampClass"]) -> None:
        self._inner_dict['created'] = value
    
    
    @property
    def lastModified(self) -> Union[None, "TimeStampClass"]:
        """A timestamp documenting when the asset was last modified in the source Data Platform (not on DataHub)"""
        return self._inner_dict.get('lastModified')  # type: ignore
    
    @lastModified.setter
    def lastModified(self, value: Union[None, "TimeStampClass"]) -> None:
        self._inner_dict['lastModified'] = value
    
    
class DataJobInfoClass(_Aspect):
    """Information about a Data processing job"""


    ASPECT_NAME = 'dataJobInfo'
    ASPECT_INFO = {}
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.datajob.DataJobInfo")

    def __init__(self,
        name: str,
        type: Union[Union[str, "AzkabanJobTypeClass"], str],
        customProperties: Optional[Dict[str, str]]=None,
        externalUrl: Union[None, str]=None,
        description: Union[None, str]=None,
        flowUrn: Union[None, str]=None,
        created: Union[None, "TimeStampClass"]=None,
        lastModified: Union[None, "TimeStampClass"]=None,
        status: Union[None, Union[str, "JobStatusClass"]]=None,
    ):
        super().__init__()
        
        if customProperties is None:
            # default: {}
            self.customProperties = dict()
        else:
            self.customProperties = customProperties
        self.externalUrl = externalUrl
        self.name = name
        self.description = description
        self.type = type
        self.flowUrn = flowUrn
        self.created = created
        self.lastModified = lastModified
        self.status = status
    
    def _restore_defaults(self) -> None:
        self.customProperties = dict()
        self.externalUrl = self.RECORD_SCHEMA.fields_dict["externalUrl"].default
        self.name = str()
        self.description = self.RECORD_SCHEMA.fields_dict["description"].default
        self.type = AzkabanJobTypeClass.COMMAND
        self.flowUrn = self.RECORD_SCHEMA.fields_dict["flowUrn"].default
        self.created = self.RECORD_SCHEMA.fields_dict["created"].default
        self.lastModified = self.RECORD_SCHEMA.fields_dict["lastModified"].default
        self.status = self.RECORD_SCHEMA.fields_dict["status"].default
    
    
    @property
    def customProperties(self) -> Dict[str, str]:
        """Custom property bag."""
        return self._inner_dict.get('customProperties')  # type: ignore
    
    @customProperties.setter
    def customProperties(self, value: Dict[str, str]) -> None:
        self._inner_dict['customProperties'] = value
    
    
    @property
    def externalUrl(self) -> Union[None, str]:
        """URL where the reference exist"""
        return self._inner_dict.get('externalUrl')  # type: ignore
    
    @externalUrl.setter
    def externalUrl(self, value: Union[None, str]) -> None:
        self._inner_dict['externalUrl'] = value
    
    
    @property
    def name(self) -> str:
        """Job name"""
        return self._inner_dict.get('name')  # type: ignore
    
    @name.setter
    def name(self, value: str) -> None:
        self._inner_dict['name'] = value
    
    
    @property
    def description(self) -> Union[None, str]:
        """Job description"""
        return self._inner_dict.get('description')  # type: ignore
    
    @description.setter
    def description(self, value: Union[None, str]) -> None:
        self._inner_dict['description'] = value
    
    
    @property
    def type(self) -> Union[Union[str, "AzkabanJobTypeClass"], str]:
        """Datajob type
    *NOTE**: AzkabanJobType is deprecated. Please use strings instead."""
        return self._inner_dict.get('type')  # type: ignore
    
    @type.setter
    def type(self, value: Union[Union[str, "AzkabanJobTypeClass"], str]) -> None:
        self._inner_dict['type'] = value
    
    
    @property
    def flowUrn(self) -> Union[None, str]:
        """DataFlow urn that this job is part of"""
        return self._inner_dict.get('flowUrn')  # type: ignore
    
    @flowUrn.setter
    def flowUrn(self, value: Union[None, str]) -> None:
        self._inner_dict['flowUrn'] = value
    
    
    @property
    def created(self) -> Union[None, "TimeStampClass"]:
        """A timestamp documenting when the asset was created in the source Data Platform (not on DataHub)"""
        return self._inner_dict.get('created')  # type: ignore
    
    @created.setter
    def created(self, value: Union[None, "TimeStampClass"]) -> None:
        self._inner_dict['created'] = value
    
    
    @property
    def lastModified(self) -> Union[None, "TimeStampClass"]:
        """A timestamp documenting when the asset was last modified in the source Data Platform (not on DataHub)"""
        return self._inner_dict.get('lastModified')  # type: ignore
    
    @lastModified.setter
    def lastModified(self, value: Union[None, "TimeStampClass"]) -> None:
        self._inner_dict['lastModified'] = value
    
    
    @property
    def status(self) -> Union[None, Union[str, "JobStatusClass"]]:
        """Status of the job - Deprecated for Data Process Instance model."""
        return self._inner_dict.get('status')  # type: ignore
    
    @status.setter
    def status(self, value: Union[None, Union[str, "JobStatusClass"]]) -> None:
        self._inner_dict['status'] = value
    
    
class DataJobInputOutputClass(_Aspect):
    """Information about the inputs and outputs of a Data processing job"""


    ASPECT_NAME = 'dataJobInputOutput'
    ASPECT_INFO = {}
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.datajob.DataJobInputOutput")

    def __init__(self,
        inputDatasets: List[str],
        outputDatasets: List[str],
        inputDatasetEdges: Union[None, List["EdgeClass"]]=None,
        outputDatasetEdges: Union[None, List["EdgeClass"]]=None,
        inputDatajobs: Union[None, List[str]]=None,
        inputDatajobEdges: Union[None, List["EdgeClass"]]=None,
        inputDatasetFields: Union[None, List[str]]=None,
        outputDatasetFields: Union[None, List[str]]=None,
        fineGrainedLineages: Union[None, List["FineGrainedLineageClass"]]=None,
    ):
        super().__init__()
        
        self.inputDatasets = inputDatasets
        self.inputDatasetEdges = inputDatasetEdges
        self.outputDatasets = outputDatasets
        self.outputDatasetEdges = outputDatasetEdges
        self.inputDatajobs = inputDatajobs
        self.inputDatajobEdges = inputDatajobEdges
        self.inputDatasetFields = inputDatasetFields
        self.outputDatasetFields = outputDatasetFields
        self.fineGrainedLineages = fineGrainedLineages
    
    def _restore_defaults(self) -> None:
        self.inputDatasets = list()
        self.inputDatasetEdges = self.RECORD_SCHEMA.fields_dict["inputDatasetEdges"].default
        self.outputDatasets = list()
        self.outputDatasetEdges = self.RECORD_SCHEMA.fields_dict["outputDatasetEdges"].default
        self.inputDatajobs = self.RECORD_SCHEMA.fields_dict["inputDatajobs"].default
        self.inputDatajobEdges = self.RECORD_SCHEMA.fields_dict["inputDatajobEdges"].default
        self.inputDatasetFields = self.RECORD_SCHEMA.fields_dict["inputDatasetFields"].default
        self.outputDatasetFields = self.RECORD_SCHEMA.fields_dict["outputDatasetFields"].default
        self.fineGrainedLineages = self.RECORD_SCHEMA.fields_dict["fineGrainedLineages"].default
    
    
    @property
    def inputDatasets(self) -> List[str]:
        """Input datasets consumed by the data job during processing
    Deprecated! Use inputDatasetEdges instead."""
        return self._inner_dict.get('inputDatasets')  # type: ignore
    
    @inputDatasets.setter
    def inputDatasets(self, value: List[str]) -> None:
        self._inner_dict['inputDatasets'] = value
    
    
    @property
    def inputDatasetEdges(self) -> Union[None, List["EdgeClass"]]:
        """Input datasets consumed by the data job during processing"""
        return self._inner_dict.get('inputDatasetEdges')  # type: ignore
    
    @inputDatasetEdges.setter
    def inputDatasetEdges(self, value: Union[None, List["EdgeClass"]]) -> None:
        self._inner_dict['inputDatasetEdges'] = value
    
    
    @property
    def outputDatasets(self) -> List[str]:
        """Output datasets produced by the data job during processing
    Deprecated! Use outputDatasetEdges instead."""
        return self._inner_dict.get('outputDatasets')  # type: ignore
    
    @outputDatasets.setter
    def outputDatasets(self, value: List[str]) -> None:
        self._inner_dict['outputDatasets'] = value
    
    
    @property
    def outputDatasetEdges(self) -> Union[None, List["EdgeClass"]]:
        """Output datasets produced by the data job during processing"""
        return self._inner_dict.get('outputDatasetEdges')  # type: ignore
    
    @outputDatasetEdges.setter
    def outputDatasetEdges(self, value: Union[None, List["EdgeClass"]]) -> None:
        self._inner_dict['outputDatasetEdges'] = value
    
    
    @property
    def inputDatajobs(self) -> Union[None, List[str]]:
        """Input datajobs that this data job depends on
    Deprecated! Use inputDatajobEdges instead."""
        return self._inner_dict.get('inputDatajobs')  # type: ignore
    
    @inputDatajobs.setter
    def inputDatajobs(self, value: Union[None, List[str]]) -> None:
        self._inner_dict['inputDatajobs'] = value
    
    
    @property
    def inputDatajobEdges(self) -> Union[None, List["EdgeClass"]]:
        """Input datajobs that this data job depends on"""
        return self._inner_dict.get('inputDatajobEdges')  # type: ignore
    
    @inputDatajobEdges.setter
    def inputDatajobEdges(self, value: Union[None, List["EdgeClass"]]) -> None:
        self._inner_dict['inputDatajobEdges'] = value
    
    
    @property
    def inputDatasetFields(self) -> Union[None, List[str]]:
        """Fields of the input datasets used by this job"""
        return self._inner_dict.get('inputDatasetFields')  # type: ignore
    
    @inputDatasetFields.setter
    def inputDatasetFields(self, value: Union[None, List[str]]) -> None:
        self._inner_dict['inputDatasetFields'] = value
    
    
    @property
    def outputDatasetFields(self) -> Union[None, List[str]]:
        """Fields of the output datasets this job writes to"""
        return self._inner_dict.get('outputDatasetFields')  # type: ignore
    
    @outputDatasetFields.setter
    def outputDatasetFields(self, value: Union[None, List[str]]) -> None:
        self._inner_dict['outputDatasetFields'] = value
    
    
    @property
    def fineGrainedLineages(self) -> Union[None, List["FineGrainedLineageClass"]]:
        """Fine-grained column-level lineages
    Not currently supported in the UI
    Use UpstreamLineage aspect for datasets to express Column Level Lineage for the UI"""
        return self._inner_dict.get('fineGrainedLineages')  # type: ignore
    
    @fineGrainedLineages.setter
    def fineGrainedLineages(self, value: Union[None, List["FineGrainedLineageClass"]]) -> None:
        self._inner_dict['fineGrainedLineages'] = value
    
    
class EditableDataFlowPropertiesClass(_Aspect):
    """Stores editable changes made to properties. This separates changes made from
    ingestion pipelines and edits in the UI to avoid accidental overwrites of user-provided data by ingestion pipelines"""


    ASPECT_NAME = 'editableDataFlowProperties'
    ASPECT_INFO = {}
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.datajob.EditableDataFlowProperties")

    def __init__(self,
        created: Optional["AuditStampClass"]=None,
        lastModified: Optional["AuditStampClass"]=None,
        deleted: Union[None, "AuditStampClass"]=None,
        description: Union[None, str]=None,
    ):
        super().__init__()
        
        if created is None:
            # default: {'actor': 'urn:li:corpuser:unknown', 'impersonator': None, 'time': 0, 'message': None}
            self.created = _json_converter.from_json_object(self.RECORD_SCHEMA.fields_dict["created"].default, writers_schema=self.RECORD_SCHEMA.fields_dict["created"].type)
        else:
            self.created = created
        if lastModified is None:
            # default: {'actor': 'urn:li:corpuser:unknown', 'impersonator': None, 'time': 0, 'message': None}
            self.lastModified = _json_converter.from_json_object(self.RECORD_SCHEMA.fields_dict["lastModified"].default, writers_schema=self.RECORD_SCHEMA.fields_dict["lastModified"].type)
        else:
            self.lastModified = lastModified
        self.deleted = deleted
        self.description = description
    
    def _restore_defaults(self) -> None:
        self.created = _json_converter.from_json_object(self.RECORD_SCHEMA.fields_dict["created"].default, writers_schema=self.RECORD_SCHEMA.fields_dict["created"].type)
        self.lastModified = _json_converter.from_json_object(self.RECORD_SCHEMA.fields_dict["lastModified"].default, writers_schema=self.RECORD_SCHEMA.fields_dict["lastModified"].type)
        self.deleted = self.RECORD_SCHEMA.fields_dict["deleted"].default
        self.description = self.RECORD_SCHEMA.fields_dict["description"].default
    
    
    @property
    def created(self) -> "AuditStampClass":
        """An AuditStamp corresponding to the creation of this resource/association/sub-resource. A value of 0 for time indicates missing data."""
        return self._inner_dict.get('created')  # type: ignore
    
    @created.setter
    def created(self, value: "AuditStampClass") -> None:
        self._inner_dict['created'] = value
    
    
    @property
    def lastModified(self) -> "AuditStampClass":
        """An AuditStamp corresponding to the last modification of this resource/association/sub-resource. If no modification has happened since creation, lastModified should be the same as created. A value of 0 for time indicates missing data."""
        return self._inner_dict.get('lastModified')  # type: ignore
    
    @lastModified.setter
    def lastModified(self, value: "AuditStampClass") -> None:
        self._inner_dict['lastModified'] = value
    
    
    @property
    def deleted(self) -> Union[None, "AuditStampClass"]:
        """An AuditStamp corresponding to the deletion of this resource/association/sub-resource. Logically, deleted MUST have a later timestamp than creation. It may or may not have the same time as lastModified depending upon the resource/association/sub-resource semantics."""
        return self._inner_dict.get('deleted')  # type: ignore
    
    @deleted.setter
    def deleted(self, value: Union[None, "AuditStampClass"]) -> None:
        self._inner_dict['deleted'] = value
    
    
    @property
    def description(self) -> Union[None, str]:
        """Edited documentation of the data flow"""
        return self._inner_dict.get('description')  # type: ignore
    
    @description.setter
    def description(self, value: Union[None, str]) -> None:
        self._inner_dict['description'] = value
    
    
class EditableDataJobPropertiesClass(_Aspect):
    """Stores editable changes made to properties. This separates changes made from
    ingestion pipelines and edits in the UI to avoid accidental overwrites of user-provided data by ingestion pipelines"""


    ASPECT_NAME = 'editableDataJobProperties'
    ASPECT_INFO = {}
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.datajob.EditableDataJobProperties")

    def __init__(self,
        created: Optional["AuditStampClass"]=None,
        lastModified: Optional["AuditStampClass"]=None,
        deleted: Union[None, "AuditStampClass"]=None,
        description: Union[None, str]=None,
    ):
        super().__init__()
        
        if created is None:
            # default: {'actor': 'urn:li:corpuser:unknown', 'impersonator': None, 'time': 0, 'message': None}
            self.created = _json_converter.from_json_object(self.RECORD_SCHEMA.fields_dict["created"].default, writers_schema=self.RECORD_SCHEMA.fields_dict["created"].type)
        else:
            self.created = created
        if lastModified is None:
            # default: {'actor': 'urn:li:corpuser:unknown', 'impersonator': None, 'time': 0, 'message': None}
            self.lastModified = _json_converter.from_json_object(self.RECORD_SCHEMA.fields_dict["lastModified"].default, writers_schema=self.RECORD_SCHEMA.fields_dict["lastModified"].type)
        else:
            self.lastModified = lastModified
        self.deleted = deleted
        self.description = description
    
    def _restore_defaults(self) -> None:
        self.created = _json_converter.from_json_object(self.RECORD_SCHEMA.fields_dict["created"].default, writers_schema=self.RECORD_SCHEMA.fields_dict["created"].type)
        self.lastModified = _json_converter.from_json_object(self.RECORD_SCHEMA.fields_dict["lastModified"].default, writers_schema=self.RECORD_SCHEMA.fields_dict["lastModified"].type)
        self.deleted = self.RECORD_SCHEMA.fields_dict["deleted"].default
        self.description = self.RECORD_SCHEMA.fields_dict["description"].default
    
    
    @property
    def created(self) -> "AuditStampClass":
        """An AuditStamp corresponding to the creation of this resource/association/sub-resource. A value of 0 for time indicates missing data."""
        return self._inner_dict.get('created')  # type: ignore
    
    @created.setter
    def created(self, value: "AuditStampClass") -> None:
        self._inner_dict['created'] = value
    
    
    @property
    def lastModified(self) -> "AuditStampClass":
        """An AuditStamp corresponding to the last modification of this resource/association/sub-resource. If no modification has happened since creation, lastModified should be the same as created. A value of 0 for time indicates missing data."""
        return self._inner_dict.get('lastModified')  # type: ignore
    
    @lastModified.setter
    def lastModified(self, value: "AuditStampClass") -> None:
        self._inner_dict['lastModified'] = value
    
    
    @property
    def deleted(self) -> Union[None, "AuditStampClass"]:
        """An AuditStamp corresponding to the deletion of this resource/association/sub-resource. Logically, deleted MUST have a later timestamp than creation. It may or may not have the same time as lastModified depending upon the resource/association/sub-resource semantics."""
        return self._inner_dict.get('deleted')  # type: ignore
    
    @deleted.setter
    def deleted(self, value: Union[None, "AuditStampClass"]) -> None:
        self._inner_dict['deleted'] = value
    
    
    @property
    def description(self) -> Union[None, str]:
        """Edited documentation of the data job """
        return self._inner_dict.get('description')  # type: ignore
    
    @description.setter
    def description(self, value: Union[None, str]) -> None:
        self._inner_dict['description'] = value
    
    
class JobStatusClass(object):
    """Job statuses"""
    
    STARTING = "STARTING"
    """Jobs being initialized."""
    
    IN_PROGRESS = "IN_PROGRESS"
    """Jobs currently running."""
    
    STOPPING = "STOPPING"
    """Jobs being stopped."""
    
    STOPPED = "STOPPED"
    """Jobs that have stopped."""
    
    COMPLETED = "COMPLETED"
    """Jobs with successful completion."""
    
    FAILED = "FAILED"
    """Jobs that have failed."""
    
    UNKNOWN = "UNKNOWN"
    """Jobs with unknown status (either unmappable or unavailable)"""
    
    SKIPPED = "SKIPPED"
    """Jobs that have been skipped."""
    
    
    
class VersionInfoClass(_Aspect):
    """Information about a Data processing job"""


    ASPECT_NAME = 'versionInfo'
    ASPECT_INFO = {}
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.datajob.VersionInfo")

    def __init__(self,
        version: str,
        versionType: str,
        customProperties: Optional[Dict[str, str]]=None,
        externalUrl: Union[None, str]=None,
    ):
        super().__init__()
        
        if customProperties is None:
            # default: {}
            self.customProperties = dict()
        else:
            self.customProperties = customProperties
        self.externalUrl = externalUrl
        self.version = version
        self.versionType = versionType
    
    def _restore_defaults(self) -> None:
        self.customProperties = dict()
        self.externalUrl = self.RECORD_SCHEMA.fields_dict["externalUrl"].default
        self.version = str()
        self.versionType = str()
    
    
    @property
    def customProperties(self) -> Dict[str, str]:
        """Custom property bag."""
        return self._inner_dict.get('customProperties')  # type: ignore
    
    @customProperties.setter
    def customProperties(self, value: Dict[str, str]) -> None:
        self._inner_dict['customProperties'] = value
    
    
    @property
    def externalUrl(self) -> Union[None, str]:
        """URL where the reference exist"""
        return self._inner_dict.get('externalUrl')  # type: ignore
    
    @externalUrl.setter
    def externalUrl(self, value: Union[None, str]) -> None:
        self._inner_dict['externalUrl'] = value
    
    
    @property
    def version(self) -> str:
        """The version which can indentify a job version like a commit hash or md5 hash"""
        return self._inner_dict.get('version')  # type: ignore
    
    @version.setter
    def version(self, value: str) -> None:
        self._inner_dict['version'] = value
    
    
    @property
    def versionType(self) -> str:
        """The type of the version like git hash or md5 hash"""
        return self._inner_dict.get('versionType')  # type: ignore
    
    @versionType.setter
    def versionType(self, value: str) -> None:
        self._inner_dict['versionType'] = value
    
    
class AzkabanJobTypeClass(object):
    """The various types of support azkaban jobs"""
    
    COMMAND = "COMMAND"
    """The command job type is one of the basic built-in types. It runs multiple UNIX commands using java processbuilder.
    Upon execution, Azkaban spawns off a process to run the command."""
    
    HADOOP_JAVA = "HADOOP_JAVA"
    """Runs a java program with ability to access Hadoop cluster.
    https://azkaban.readthedocs.io/en/latest/jobTypes.html#java-job-type"""
    
    HADOOP_SHELL = "HADOOP_SHELL"
    """In large part, this is the same Command type. The difference is its ability to talk to a Hadoop cluster
    securely, via Hadoop tokens."""
    
    HIVE = "HIVE"
    """Hive type is for running Hive jobs."""
    
    PIG = "PIG"
    """Pig type is for running Pig jobs."""
    
    SQL = "SQL"
    """SQL is for running Presto, mysql queries etc"""
    
    GLUE = "GLUE"
    """Glue type is for running AWS Glue job transforms."""
    
    
    
class DatahubIngestionCheckpointClass(_Aspect):
    """Checkpoint of a datahub ingestion run for a given job."""


    ASPECT_NAME = 'datahubIngestionCheckpoint'
    ASPECT_TYPE = 'timeseries'
    ASPECT_INFO = {}
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.datajob.datahub.DatahubIngestionCheckpoint")

    def __init__(self,
        timestampMillis: int,
        pipelineName: str,
        platformInstanceId: str,
        config: str,
        state: "IngestionCheckpointStateClass",
        runId: str,
        eventGranularity: Union[None, "TimeWindowSizeClass"]=None,
        partitionSpec: Optional[Union["PartitionSpecClass", None]]=None,
        messageId: Union[None, str]=None,
    ):
        super().__init__()
        
        self.timestampMillis = timestampMillis
        self.eventGranularity = eventGranularity
        if partitionSpec is None:
            # default: {'partition': 'FULL_TABLE_SNAPSHOT', 'type': 'FULL_TABLE', 'timePartition': None}
            self.partitionSpec = _json_converter.from_json_object(self.RECORD_SCHEMA.fields_dict["partitionSpec"].default, writers_schema=self.RECORD_SCHEMA.fields_dict["partitionSpec"].type)
        else:
            self.partitionSpec = partitionSpec
        self.messageId = messageId
        self.pipelineName = pipelineName
        self.platformInstanceId = platformInstanceId
        self.config = config
        self.state = state
        self.runId = runId
    
    def _restore_defaults(self) -> None:
        self.timestampMillis = int()
        self.eventGranularity = self.RECORD_SCHEMA.fields_dict["eventGranularity"].default
        self.partitionSpec = _json_converter.from_json_object(self.RECORD_SCHEMA.fields_dict["partitionSpec"].default, writers_schema=self.RECORD_SCHEMA.fields_dict["partitionSpec"].type)
        self.messageId = self.RECORD_SCHEMA.fields_dict["messageId"].default
        self.pipelineName = str()
        self.platformInstanceId = str()
        self.config = str()
        self.state = IngestionCheckpointStateClass._construct_with_defaults()
        self.runId = str()
    
    
    @property
    def timestampMillis(self) -> int:
        """The event timestamp field as epoch at UTC in milli seconds."""
        return self._inner_dict.get('timestampMillis')  # type: ignore
    
    @timestampMillis.setter
    def timestampMillis(self, value: int) -> None:
        self._inner_dict['timestampMillis'] = value
    
    
    @property
    def eventGranularity(self) -> Union[None, "TimeWindowSizeClass"]:
        """Granularity of the event if applicable"""
        return self._inner_dict.get('eventGranularity')  # type: ignore
    
    @eventGranularity.setter
    def eventGranularity(self, value: Union[None, "TimeWindowSizeClass"]) -> None:
        self._inner_dict['eventGranularity'] = value
    
    
    @property
    def partitionSpec(self) -> Union["PartitionSpecClass", None]:
        """The optional partition specification."""
        return self._inner_dict.get('partitionSpec')  # type: ignore
    
    @partitionSpec.setter
    def partitionSpec(self, value: Union["PartitionSpecClass", None]) -> None:
        self._inner_dict['partitionSpec'] = value
    
    
    @property
    def messageId(self) -> Union[None, str]:
        """The optional messageId, if provided serves as a custom user-defined unique identifier for an aspect value."""
        return self._inner_dict.get('messageId')  # type: ignore
    
    @messageId.setter
    def messageId(self, value: Union[None, str]) -> None:
        self._inner_dict['messageId'] = value
    
    
    @property
    def pipelineName(self) -> str:
        """The name of the pipeline that ran ingestion, a stable unique user provided identifier.
     e.g. my_snowflake1-to-datahub."""
        return self._inner_dict.get('pipelineName')  # type: ignore
    
    @pipelineName.setter
    def pipelineName(self, value: str) -> None:
        self._inner_dict['pipelineName'] = value
    
    
    @property
    def platformInstanceId(self) -> str:
        """The id of the instance against which the ingestion pipeline ran.
    e.g.: Bigquery project ids, MySQL hostnames etc."""
        return self._inner_dict.get('platformInstanceId')  # type: ignore
    
    @platformInstanceId.setter
    def platformInstanceId(self, value: str) -> None:
        self._inner_dict['platformInstanceId'] = value
    
    
    @property
    def config(self) -> str:
        """Json-encoded string representation of the non-secret members of the config ."""
        return self._inner_dict.get('config')  # type: ignore
    
    @config.setter
    def config(self, value: str) -> None:
        self._inner_dict['config'] = value
    
    
    @property
    def state(self) -> "IngestionCheckpointStateClass":
        """Opaque blob of the state representation."""
        return self._inner_dict.get('state')  # type: ignore
    
    @state.setter
    def state(self, value: "IngestionCheckpointStateClass") -> None:
        self._inner_dict['state'] = value
    
    
    @property
    def runId(self) -> str:
        """The run identifier of this job."""
        return self._inner_dict.get('runId')  # type: ignore
    
    @runId.setter
    def runId(self, value: str) -> None:
        self._inner_dict['runId'] = value
    
    
class DatahubIngestionRunSummaryClass(_Aspect):
    """Summary of a datahub ingestion run for a given platform."""


    ASPECT_NAME = 'datahubIngestionRunSummary'
    ASPECT_TYPE = 'timeseries'
    ASPECT_INFO = {}
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.datajob.datahub.DatahubIngestionRunSummary")

    def __init__(self,
        timestampMillis: int,
        pipelineName: str,
        platformInstanceId: str,
        runId: str,
        runStatus: Union[str, "JobStatusClass"],
        eventGranularity: Union[None, "TimeWindowSizeClass"]=None,
        partitionSpec: Optional[Union["PartitionSpecClass", None]]=None,
        messageId: Union[None, str]=None,
        numWorkUnitsCommitted: Union[None, int]=None,
        numWorkUnitsCreated: Union[None, int]=None,
        numEvents: Union[None, int]=None,
        numEntities: Union[None, int]=None,
        numAspects: Union[None, int]=None,
        numSourceAPICalls: Union[None, int]=None,
        totalLatencySourceAPICalls: Union[None, int]=None,
        numSinkAPICalls: Union[None, int]=None,
        totalLatencySinkAPICalls: Union[None, int]=None,
        numWarnings: Union[None, int]=None,
        numErrors: Union[None, int]=None,
        numEntitiesSkipped: Union[None, int]=None,
        config: Union[None, str]=None,
        custom_summary: Union[None, str]=None,
        softwareVersion: Union[None, str]=None,
        systemHostName: Union[None, str]=None,
        operatingSystemName: Union[None, str]=None,
        numProcessors: Union[None, int]=None,
        totalMemory: Union[None, int]=None,
        availableMemory: Union[None, int]=None,
    ):
        super().__init__()
        
        self.timestampMillis = timestampMillis
        self.eventGranularity = eventGranularity
        if partitionSpec is None:
            # default: {'partition': 'FULL_TABLE_SNAPSHOT', 'type': 'FULL_TABLE', 'timePartition': None}
            self.partitionSpec = _json_converter.from_json_object(self.RECORD_SCHEMA.fields_dict["partitionSpec"].default, writers_schema=self.RECORD_SCHEMA.fields_dict["partitionSpec"].type)
        else:
            self.partitionSpec = partitionSpec
        self.messageId = messageId
        self.pipelineName = pipelineName
        self.platformInstanceId = platformInstanceId
        self.runId = runId
        self.runStatus = runStatus
        self.numWorkUnitsCommitted = numWorkUnitsCommitted
        self.numWorkUnitsCreated = numWorkUnitsCreated
        self.numEvents = numEvents
        self.numEntities = numEntities
        self.numAspects = numAspects
        self.numSourceAPICalls = numSourceAPICalls
        self.totalLatencySourceAPICalls = totalLatencySourceAPICalls
        self.numSinkAPICalls = numSinkAPICalls
        self.totalLatencySinkAPICalls = totalLatencySinkAPICalls
        self.numWarnings = numWarnings
        self.numErrors = numErrors
        self.numEntitiesSkipped = numEntitiesSkipped
        self.config = config
        self.custom_summary = custom_summary
        self.softwareVersion = softwareVersion
        self.systemHostName = systemHostName
        self.operatingSystemName = operatingSystemName
        self.numProcessors = numProcessors
        self.totalMemory = totalMemory
        self.availableMemory = availableMemory
    
    def _restore_defaults(self) -> None:
        self.timestampMillis = int()
        self.eventGranularity = self.RECORD_SCHEMA.fields_dict["eventGranularity"].default
        self.partitionSpec = _json_converter.from_json_object(self.RECORD_SCHEMA.fields_dict["partitionSpec"].default, writers_schema=self.RECORD_SCHEMA.fields_dict["partitionSpec"].type)
        self.messageId = self.RECORD_SCHEMA.fields_dict["messageId"].default
        self.pipelineName = str()
        self.platformInstanceId = str()
        self.runId = str()
        self.runStatus = JobStatusClass.STARTING
        self.numWorkUnitsCommitted = self.RECORD_SCHEMA.fields_dict["numWorkUnitsCommitted"].default
        self.numWorkUnitsCreated = self.RECORD_SCHEMA.fields_dict["numWorkUnitsCreated"].default
        self.numEvents = self.RECORD_SCHEMA.fields_dict["numEvents"].default
        self.numEntities = self.RECORD_SCHEMA.fields_dict["numEntities"].default
        self.numAspects = self.RECORD_SCHEMA.fields_dict["numAspects"].default
        self.numSourceAPICalls = self.RECORD_SCHEMA.fields_dict["numSourceAPICalls"].default
        self.totalLatencySourceAPICalls = self.RECORD_SCHEMA.fields_dict["totalLatencySourceAPICalls"].default
        self.numSinkAPICalls = self.RECORD_SCHEMA.fields_dict["numSinkAPICalls"].default
        self.totalLatencySinkAPICalls = self.RECORD_SCHEMA.fields_dict["totalLatencySinkAPICalls"].default
        self.numWarnings = self.RECORD_SCHEMA.fields_dict["numWarnings"].default
        self.numErrors = self.RECORD_SCHEMA.fields_dict["numErrors"].default
        self.numEntitiesSkipped = self.RECORD_SCHEMA.fields_dict["numEntitiesSkipped"].default
        self.config = self.RECORD_SCHEMA.fields_dict["config"].default
        self.custom_summary = self.RECORD_SCHEMA.fields_dict["custom_summary"].default
        self.softwareVersion = self.RECORD_SCHEMA.fields_dict["softwareVersion"].default
        self.systemHostName = self.RECORD_SCHEMA.fields_dict["systemHostName"].default
        self.operatingSystemName = self.RECORD_SCHEMA.fields_dict["operatingSystemName"].default
        self.numProcessors = self.RECORD_SCHEMA.fields_dict["numProcessors"].default
        self.totalMemory = self.RECORD_SCHEMA.fields_dict["totalMemory"].default
        self.availableMemory = self.RECORD_SCHEMA.fields_dict["availableMemory"].default
    
    
    @property
    def timestampMillis(self) -> int:
        """The event timestamp field as epoch at UTC in milli seconds."""
        return self._inner_dict.get('timestampMillis')  # type: ignore
    
    @timestampMillis.setter
    def timestampMillis(self, value: int) -> None:
        self._inner_dict['timestampMillis'] = value
    
    
    @property
    def eventGranularity(self) -> Union[None, "TimeWindowSizeClass"]:
        """Granularity of the event if applicable"""
        return self._inner_dict.get('eventGranularity')  # type: ignore
    
    @eventGranularity.setter
    def eventGranularity(self, value: Union[None, "TimeWindowSizeClass"]) -> None:
        self._inner_dict['eventGranularity'] = value
    
    
    @property
    def partitionSpec(self) -> Union["PartitionSpecClass", None]:
        """The optional partition specification."""
        return self._inner_dict.get('partitionSpec')  # type: ignore
    
    @partitionSpec.setter
    def partitionSpec(self, value: Union["PartitionSpecClass", None]) -> None:
        self._inner_dict['partitionSpec'] = value
    
    
    @property
    def messageId(self) -> Union[None, str]:
        """The optional messageId, if provided serves as a custom user-defined unique identifier for an aspect value."""
        return self._inner_dict.get('messageId')  # type: ignore
    
    @messageId.setter
    def messageId(self, value: Union[None, str]) -> None:
        self._inner_dict['messageId'] = value
    
    
    @property
    def pipelineName(self) -> str:
        """The name of the pipeline that ran ingestion, a stable unique user provided identifier.
     e.g. my_snowflake1-to-datahub."""
        return self._inner_dict.get('pipelineName')  # type: ignore
    
    @pipelineName.setter
    def pipelineName(self, value: str) -> None:
        self._inner_dict['pipelineName'] = value
    
    
    @property
    def platformInstanceId(self) -> str:
        """The id of the instance against which the ingestion pipeline ran.
    e.g.: Bigquery project ids, MySQL hostnames etc."""
        return self._inner_dict.get('platformInstanceId')  # type: ignore
    
    @platformInstanceId.setter
    def platformInstanceId(self, value: str) -> None:
        self._inner_dict['platformInstanceId'] = value
    
    
    @property
    def runId(self) -> str:
        """The runId for this pipeline instance."""
        return self._inner_dict.get('runId')  # type: ignore
    
    @runId.setter
    def runId(self, value: str) -> None:
        self._inner_dict['runId'] = value
    
    
    @property
    def runStatus(self) -> Union[str, "JobStatusClass"]:
        """Run Status - Succeeded/Skipped/Failed etc."""
        return self._inner_dict.get('runStatus')  # type: ignore
    
    @runStatus.setter
    def runStatus(self, value: Union[str, "JobStatusClass"]) -> None:
        self._inner_dict['runStatus'] = value
    
    
    @property
    def numWorkUnitsCommitted(self) -> Union[None, int]:
        """The number of workunits written to sink."""
        return self._inner_dict.get('numWorkUnitsCommitted')  # type: ignore
    
    @numWorkUnitsCommitted.setter
    def numWorkUnitsCommitted(self, value: Union[None, int]) -> None:
        self._inner_dict['numWorkUnitsCommitted'] = value
    
    
    @property
    def numWorkUnitsCreated(self) -> Union[None, int]:
        """The number of workunits that are produced."""
        return self._inner_dict.get('numWorkUnitsCreated')  # type: ignore
    
    @numWorkUnitsCreated.setter
    def numWorkUnitsCreated(self, value: Union[None, int]) -> None:
        self._inner_dict['numWorkUnitsCreated'] = value
    
    
    @property
    def numEvents(self) -> Union[None, int]:
        """The number of events produced (MCE + MCP)."""
        return self._inner_dict.get('numEvents')  # type: ignore
    
    @numEvents.setter
    def numEvents(self, value: Union[None, int]) -> None:
        self._inner_dict['numEvents'] = value
    
    
    @property
    def numEntities(self) -> Union[None, int]:
        """The total number of entities produced (unique entity urns)."""
        return self._inner_dict.get('numEntities')  # type: ignore
    
    @numEntities.setter
    def numEntities(self, value: Union[None, int]) -> None:
        self._inner_dict['numEntities'] = value
    
    
    @property
    def numAspects(self) -> Union[None, int]:
        """The total number of aspects produced across all entities."""
        return self._inner_dict.get('numAspects')  # type: ignore
    
    @numAspects.setter
    def numAspects(self, value: Union[None, int]) -> None:
        self._inner_dict['numAspects'] = value
    
    
    @property
    def numSourceAPICalls(self) -> Union[None, int]:
        """Total number of source API calls."""
        return self._inner_dict.get('numSourceAPICalls')  # type: ignore
    
    @numSourceAPICalls.setter
    def numSourceAPICalls(self, value: Union[None, int]) -> None:
        self._inner_dict['numSourceAPICalls'] = value
    
    
    @property
    def totalLatencySourceAPICalls(self) -> Union[None, int]:
        """Total latency across all source API calls."""
        return self._inner_dict.get('totalLatencySourceAPICalls')  # type: ignore
    
    @totalLatencySourceAPICalls.setter
    def totalLatencySourceAPICalls(self, value: Union[None, int]) -> None:
        self._inner_dict['totalLatencySourceAPICalls'] = value
    
    
    @property
    def numSinkAPICalls(self) -> Union[None, int]:
        """Total number of sink API calls."""
        return self._inner_dict.get('numSinkAPICalls')  # type: ignore
    
    @numSinkAPICalls.setter
    def numSinkAPICalls(self, value: Union[None, int]) -> None:
        self._inner_dict['numSinkAPICalls'] = value
    
    
    @property
    def totalLatencySinkAPICalls(self) -> Union[None, int]:
        """Total latency across all sink API calls."""
        return self._inner_dict.get('totalLatencySinkAPICalls')  # type: ignore
    
    @totalLatencySinkAPICalls.setter
    def totalLatencySinkAPICalls(self, value: Union[None, int]) -> None:
        self._inner_dict['totalLatencySinkAPICalls'] = value
    
    
    @property
    def numWarnings(self) -> Union[None, int]:
        """Number of warnings generated."""
        return self._inner_dict.get('numWarnings')  # type: ignore
    
    @numWarnings.setter
    def numWarnings(self, value: Union[None, int]) -> None:
        self._inner_dict['numWarnings'] = value
    
    
    @property
    def numErrors(self) -> Union[None, int]:
        """Number of errors generated."""
        return self._inner_dict.get('numErrors')  # type: ignore
    
    @numErrors.setter
    def numErrors(self, value: Union[None, int]) -> None:
        self._inner_dict['numErrors'] = value
    
    
    @property
    def numEntitiesSkipped(self) -> Union[None, int]:
        """Number of entities skipped."""
        return self._inner_dict.get('numEntitiesSkipped')  # type: ignore
    
    @numEntitiesSkipped.setter
    def numEntitiesSkipped(self, value: Union[None, int]) -> None:
        self._inner_dict['numEntitiesSkipped'] = value
    
    
    @property
    def config(self) -> Union[None, str]:
        """The non-sensitive key-value pairs of the yaml config used as json string."""
        return self._inner_dict.get('config')  # type: ignore
    
    @config.setter
    def config(self, value: Union[None, str]) -> None:
        self._inner_dict['config'] = value
    
    
    @property
    def custom_summary(self) -> Union[None, str]:
        """Custom value."""
        return self._inner_dict.get('custom_summary')  # type: ignore
    
    @custom_summary.setter
    def custom_summary(self, value: Union[None, str]) -> None:
        self._inner_dict['custom_summary'] = value
    
    
    @property
    def softwareVersion(self) -> Union[None, str]:
        """The software version of this ingestion."""
        return self._inner_dict.get('softwareVersion')  # type: ignore
    
    @softwareVersion.setter
    def softwareVersion(self, value: Union[None, str]) -> None:
        self._inner_dict['softwareVersion'] = value
    
    
    @property
    def systemHostName(self) -> Union[None, str]:
        """The hostname the ingestion pipeline ran on."""
        return self._inner_dict.get('systemHostName')  # type: ignore
    
    @systemHostName.setter
    def systemHostName(self, value: Union[None, str]) -> None:
        self._inner_dict['systemHostName'] = value
    
    
    @property
    def operatingSystemName(self) -> Union[None, str]:
        """The os the ingestion pipeline ran on."""
        return self._inner_dict.get('operatingSystemName')  # type: ignore
    
    @operatingSystemName.setter
    def operatingSystemName(self, value: Union[None, str]) -> None:
        self._inner_dict['operatingSystemName'] = value
    
    
    @property
    def numProcessors(self) -> Union[None, int]:
        """The number of processors on the host the ingestion pipeline ran on."""
        return self._inner_dict.get('numProcessors')  # type: ignore
    
    @numProcessors.setter
    def numProcessors(self, value: Union[None, int]) -> None:
        self._inner_dict['numProcessors'] = value
    
    
    @property
    def totalMemory(self) -> Union[None, int]:
        """The total amount of memory on the host the ingestion pipeline ran on."""
        return self._inner_dict.get('totalMemory')  # type: ignore
    
    @totalMemory.setter
    def totalMemory(self, value: Union[None, int]) -> None:
        self._inner_dict['totalMemory'] = value
    
    
    @property
    def availableMemory(self) -> Union[None, int]:
        """The available memory on the host the ingestion pipeline ran on."""
        return self._inner_dict.get('availableMemory')  # type: ignore
    
    @availableMemory.setter
    def availableMemory(self, value: Union[None, int]) -> None:
        self._inner_dict['availableMemory'] = value
    
    
class IngestionCheckpointStateClass(DictWrapper):
    """The checkpoint state object of a datahub ingestion run for a given job."""
    
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.datajob.datahub.IngestionCheckpointState")
    def __init__(self,
        formatVersion: str,
        serde: str,
        payload: Union[None, bytes]=None,
    ):
        super().__init__()
        
        self.formatVersion = formatVersion
        self.serde = serde
        self.payload = payload
    
    def _restore_defaults(self) -> None:
        self.formatVersion = str()
        self.serde = str()
        self.payload = self.RECORD_SCHEMA.fields_dict["payload"].default
    
    
    @property
    def formatVersion(self) -> str:
        """The version of the state format."""
        return self._inner_dict.get('formatVersion')  # type: ignore
    
    @formatVersion.setter
    def formatVersion(self, value: str) -> None:
        self._inner_dict['formatVersion'] = value
    
    
    @property
    def serde(self) -> str:
        """The serialization/deserialization protocol."""
        return self._inner_dict.get('serde')  # type: ignore
    
    @serde.setter
    def serde(self, value: str) -> None:
        self._inner_dict['serde'] = value
    
    
    @property
    def payload(self) -> Union[None, bytes]:
        """Opaque blob of the state representation."""
        return self._inner_dict.get('payload')  # type: ignore
    
    @payload.setter
    def payload(self, value: Union[None, bytes]) -> None:
        self._inner_dict['payload'] = value
    
    
class DataPlatformInfoClass(_Aspect):
    """Information about a data platform"""


    ASPECT_NAME = 'dataPlatformInfo'
    ASPECT_INFO = {}
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.dataplatform.DataPlatformInfo")

    def __init__(self,
        name: str,
        type: Union[str, "PlatformTypeClass"],
        datasetNameDelimiter: str,
        displayName: Union[None, str]=None,
        logoUrl: Union[None, str]=None,
    ):
        super().__init__()
        
        self.name = name
        self.displayName = displayName
        self.type = type
        self.datasetNameDelimiter = datasetNameDelimiter
        self.logoUrl = logoUrl
    
    def _restore_defaults(self) -> None:
        self.name = str()
        self.displayName = self.RECORD_SCHEMA.fields_dict["displayName"].default
        self.type = PlatformTypeClass.FILE_SYSTEM
        self.datasetNameDelimiter = str()
        self.logoUrl = self.RECORD_SCHEMA.fields_dict["logoUrl"].default
    
    
    @property
    def name(self) -> str:
        """Name of the data platform"""
        return self._inner_dict.get('name')  # type: ignore
    
    @name.setter
    def name(self, value: str) -> None:
        self._inner_dict['name'] = value
    
    
    @property
    def displayName(self) -> Union[None, str]:
        """The name that will be used for displaying a platform type."""
        return self._inner_dict.get('displayName')  # type: ignore
    
    @displayName.setter
    def displayName(self, value: Union[None, str]) -> None:
        self._inner_dict['displayName'] = value
    
    
    @property
    def type(self) -> Union[str, "PlatformTypeClass"]:
        """Platform type this data platform describes"""
        return self._inner_dict.get('type')  # type: ignore
    
    @type.setter
    def type(self, value: Union[str, "PlatformTypeClass"]) -> None:
        self._inner_dict['type'] = value
    
    
    @property
    def datasetNameDelimiter(self) -> str:
        """The delimiter in the dataset names on the data platform, e.g. '/' for HDFS and '.' for Oracle"""
        return self._inner_dict.get('datasetNameDelimiter')  # type: ignore
    
    @datasetNameDelimiter.setter
    def datasetNameDelimiter(self, value: str) -> None:
        self._inner_dict['datasetNameDelimiter'] = value
    
    
    @property
    def logoUrl(self) -> Union[None, str]:
        """The URL for a logo associated with the platform"""
        return self._inner_dict.get('logoUrl')  # type: ignore
    
    @logoUrl.setter
    def logoUrl(self, value: Union[None, str]) -> None:
        self._inner_dict['logoUrl'] = value
    
    
class PlatformTypeClass(object):
    """Platform types available at LinkedIn"""
    
    FILE_SYSTEM = "FILE_SYSTEM"
    """Value for a file system, e.g. hdfs"""
    
    KEY_VALUE_STORE = "KEY_VALUE_STORE"
    """Value for a key value store, e.g. espresso, voldemort"""
    
    MESSAGE_BROKER = "MESSAGE_BROKER"
    """Value for a message broker, e.g. kafka"""
    
    OBJECT_STORE = "OBJECT_STORE"
    """Value for an object store, e.g. ambry"""
    
    OLAP_DATASTORE = "OLAP_DATASTORE"
    """Value for an OLAP datastore, e.g. pinot"""
    
    OTHERS = "OTHERS"
    """Value for other platforms, e.g salesforce, dovetail"""
    
    QUERY_ENGINE = "QUERY_ENGINE"
    """Value for a query engine, e.g. presto"""
    
    RELATIONAL_DB = "RELATIONAL_DB"
    """Value for a relational database, e.g. oracle, mysql"""
    
    SEARCH_ENGINE = "SEARCH_ENGINE"
    """Value for a search engine, e.g seas"""
    
    
    
class DataPlatformInstancePropertiesClass(_Aspect):
    """Properties associated with a Data Platform Instance"""


    ASPECT_NAME = 'dataPlatformInstanceProperties'
    ASPECT_INFO = {}
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.dataplatforminstance.DataPlatformInstanceProperties")

    def __init__(self,
        customProperties: Optional[Dict[str, str]]=None,
        externalUrl: Union[None, str]=None,
        name: Union[None, str]=None,
        description: Union[None, str]=None,
    ):
        super().__init__()
        
        if customProperties is None:
            # default: {}
            self.customProperties = dict()
        else:
            self.customProperties = customProperties
        self.externalUrl = externalUrl
        self.name = name
        self.description = description
    
    def _restore_defaults(self) -> None:
        self.customProperties = dict()
        self.externalUrl = self.RECORD_SCHEMA.fields_dict["externalUrl"].default
        self.name = self.RECORD_SCHEMA.fields_dict["name"].default
        self.description = self.RECORD_SCHEMA.fields_dict["description"].default
    
    
    @property
    def customProperties(self) -> Dict[str, str]:
        """Custom property bag."""
        return self._inner_dict.get('customProperties')  # type: ignore
    
    @customProperties.setter
    def customProperties(self, value: Dict[str, str]) -> None:
        self._inner_dict['customProperties'] = value
    
    
    @property
    def externalUrl(self) -> Union[None, str]:
        """URL where the reference exist"""
        return self._inner_dict.get('externalUrl')  # type: ignore
    
    @externalUrl.setter
    def externalUrl(self, value: Union[None, str]) -> None:
        self._inner_dict['externalUrl'] = value
    
    
    @property
    def name(self) -> Union[None, str]:
        """Display name of the Data Platform Instance"""
        return self._inner_dict.get('name')  # type: ignore
    
    @name.setter
    def name(self, value: Union[None, str]) -> None:
        self._inner_dict['name'] = value
    
    
    @property
    def description(self) -> Union[None, str]:
        """Documentation of the Data Platform Instance"""
        return self._inner_dict.get('description')  # type: ignore
    
    @description.setter
    def description(self, value: Union[None, str]) -> None:
        self._inner_dict['description'] = value
    
    
class DataProcessInfoClass(_Aspect):
    """The inputs and outputs of this data process"""


    ASPECT_NAME = 'dataProcessInfo'
    ASPECT_INFO = {}
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.dataprocess.DataProcessInfo")

    def __init__(self,
        inputs: Union[None, List[str]]=None,
        outputs: Union[None, List[str]]=None,
    ):
        super().__init__()
        
        self.inputs = inputs
        self.outputs = outputs
    
    def _restore_defaults(self) -> None:
        self.inputs = self.RECORD_SCHEMA.fields_dict["inputs"].default
        self.outputs = self.RECORD_SCHEMA.fields_dict["outputs"].default
    
    
    @property
    def inputs(self) -> Union[None, List[str]]:
        """the inputs of the data process"""
        return self._inner_dict.get('inputs')  # type: ignore
    
    @inputs.setter
    def inputs(self, value: Union[None, List[str]]) -> None:
        self._inner_dict['inputs'] = value
    
    
    @property
    def outputs(self) -> Union[None, List[str]]:
        """the outputs of the data process"""
        return self._inner_dict.get('outputs')  # type: ignore
    
    @outputs.setter
    def outputs(self, value: Union[None, List[str]]) -> None:
        self._inner_dict['outputs'] = value
    
    
class DataProcessInstanceInputClass(_Aspect):
    """Information about the inputs datasets of a Data process"""


    ASPECT_NAME = 'dataProcessInstanceInput'
    ASPECT_INFO = {}
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.dataprocess.DataProcessInstanceInput")

    def __init__(self,
        inputs: List[str],
    ):
        super().__init__()
        
        self.inputs = inputs
    
    def _restore_defaults(self) -> None:
        self.inputs = list()
    
    
    @property
    def inputs(self) -> List[str]:
        """Input datasets to be consumed"""
        return self._inner_dict.get('inputs')  # type: ignore
    
    @inputs.setter
    def inputs(self, value: List[str]) -> None:
        self._inner_dict['inputs'] = value
    
    
class DataProcessInstanceOutputClass(_Aspect):
    """Information about the outputs of a Data process"""


    ASPECT_NAME = 'dataProcessInstanceOutput'
    ASPECT_INFO = {}
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.dataprocess.DataProcessInstanceOutput")

    def __init__(self,
        outputs: List[str],
    ):
        super().__init__()
        
        self.outputs = outputs
    
    def _restore_defaults(self) -> None:
        self.outputs = list()
    
    
    @property
    def outputs(self) -> List[str]:
        """Output datasets to be produced"""
        return self._inner_dict.get('outputs')  # type: ignore
    
    @outputs.setter
    def outputs(self, value: List[str]) -> None:
        self._inner_dict['outputs'] = value
    
    
class DataProcessInstancePropertiesClass(_Aspect):
    """The inputs and outputs of this data process"""


    ASPECT_NAME = 'dataProcessInstanceProperties'
    ASPECT_INFO = {}
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.dataprocess.DataProcessInstanceProperties")

    def __init__(self,
        name: str,
        created: "AuditStampClass",
        customProperties: Optional[Dict[str, str]]=None,
        externalUrl: Union[None, str]=None,
        type: Union[None, Union[str, "DataProcessTypeClass"]]=None,
    ):
        super().__init__()
        
        if customProperties is None:
            # default: {}
            self.customProperties = dict()
        else:
            self.customProperties = customProperties
        self.externalUrl = externalUrl
        self.name = name
        self.type = type
        self.created = created
    
    def _restore_defaults(self) -> None:
        self.customProperties = dict()
        self.externalUrl = self.RECORD_SCHEMA.fields_dict["externalUrl"].default
        self.name = str()
        self.type = self.RECORD_SCHEMA.fields_dict["type"].default
        self.created = AuditStampClass._construct_with_defaults()
    
    
    @property
    def customProperties(self) -> Dict[str, str]:
        """Custom property bag."""
        return self._inner_dict.get('customProperties')  # type: ignore
    
    @customProperties.setter
    def customProperties(self, value: Dict[str, str]) -> None:
        self._inner_dict['customProperties'] = value
    
    
    @property
    def externalUrl(self) -> Union[None, str]:
        """URL where the reference exist"""
        return self._inner_dict.get('externalUrl')  # type: ignore
    
    @externalUrl.setter
    def externalUrl(self, value: Union[None, str]) -> None:
        self._inner_dict['externalUrl'] = value
    
    
    @property
    def name(self) -> str:
        """Process name"""
        return self._inner_dict.get('name')  # type: ignore
    
    @name.setter
    def name(self, value: str) -> None:
        self._inner_dict['name'] = value
    
    
    @property
    def type(self) -> Union[None, Union[str, "DataProcessTypeClass"]]:
        """Process type"""
        return self._inner_dict.get('type')  # type: ignore
    
    @type.setter
    def type(self, value: Union[None, Union[str, "DataProcessTypeClass"]]) -> None:
        self._inner_dict['type'] = value
    
    
    @property
    def created(self) -> "AuditStampClass":
        """Audit stamp containing who reported the lineage and when"""
        return self._inner_dict.get('created')  # type: ignore
    
    @created.setter
    def created(self, value: "AuditStampClass") -> None:
        self._inner_dict['created'] = value
    
    
class DataProcessInstanceRelationshipsClass(_Aspect):
    """Information about Data process relationships"""


    ASPECT_NAME = 'dataProcessInstanceRelationships'
    ASPECT_INFO = {}
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.dataprocess.DataProcessInstanceRelationships")

    def __init__(self,
        upstreamInstances: List[str],
        parentTemplate: Union[None, str]=None,
        parentInstance: Union[None, str]=None,
    ):
        super().__init__()
        
        self.parentTemplate = parentTemplate
        self.parentInstance = parentInstance
        self.upstreamInstances = upstreamInstances
    
    def _restore_defaults(self) -> None:
        self.parentTemplate = self.RECORD_SCHEMA.fields_dict["parentTemplate"].default
        self.parentInstance = self.RECORD_SCHEMA.fields_dict["parentInstance"].default
        self.upstreamInstances = list()
    
    
    @property
    def parentTemplate(self) -> Union[None, str]:
        """The parent entity whose run instance it is"""
        return self._inner_dict.get('parentTemplate')  # type: ignore
    
    @parentTemplate.setter
    def parentTemplate(self, value: Union[None, str]) -> None:
        self._inner_dict['parentTemplate'] = value
    
    
    @property
    def parentInstance(self) -> Union[None, str]:
        """The parent DataProcessInstance where it belongs to.
    If it is a Airflow Task then it should belong to an Airflow Dag run as well
    which will be another DataProcessInstance"""
        return self._inner_dict.get('parentInstance')  # type: ignore
    
    @parentInstance.setter
    def parentInstance(self, value: Union[None, str]) -> None:
        self._inner_dict['parentInstance'] = value
    
    
    @property
    def upstreamInstances(self) -> List[str]:
        """Input DataProcessInstance which triggered this dataprocess instance"""
        return self._inner_dict.get('upstreamInstances')  # type: ignore
    
    @upstreamInstances.setter
    def upstreamInstances(self, value: List[str]) -> None:
        self._inner_dict['upstreamInstances'] = value
    
    
class DataProcessInstanceRunEventClass(_Aspect):
    """An event representing the current status of data process run.
    DataProcessRunEvent should be used for reporting the status of a dataProcess' run."""


    ASPECT_NAME = 'dataProcessInstanceRunEvent'
    ASPECT_TYPE = 'timeseries'
    ASPECT_INFO = {}
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.dataprocess.DataProcessInstanceRunEvent")

    def __init__(self,
        timestampMillis: int,
        status: Union[str, "DataProcessRunStatusClass"],
        eventGranularity: Union[None, "TimeWindowSizeClass"]=None,
        partitionSpec: Optional[Union["PartitionSpecClass", None]]=None,
        messageId: Union[None, str]=None,
        externalUrl: Union[None, str]=None,
        attempt: Union[None, int]=None,
        result: Union[None, "DataProcessInstanceRunResultClass"]=None,
    ):
        super().__init__()
        
        self.timestampMillis = timestampMillis
        self.eventGranularity = eventGranularity
        if partitionSpec is None:
            # default: {'partition': 'FULL_TABLE_SNAPSHOT', 'type': 'FULL_TABLE', 'timePartition': None}
            self.partitionSpec = _json_converter.from_json_object(self.RECORD_SCHEMA.fields_dict["partitionSpec"].default, writers_schema=self.RECORD_SCHEMA.fields_dict["partitionSpec"].type)
        else:
            self.partitionSpec = partitionSpec
        self.messageId = messageId
        self.externalUrl = externalUrl
        self.status = status
        self.attempt = attempt
        self.result = result
    
    def _restore_defaults(self) -> None:
        self.timestampMillis = int()
        self.eventGranularity = self.RECORD_SCHEMA.fields_dict["eventGranularity"].default
        self.partitionSpec = _json_converter.from_json_object(self.RECORD_SCHEMA.fields_dict["partitionSpec"].default, writers_schema=self.RECORD_SCHEMA.fields_dict["partitionSpec"].type)
        self.messageId = self.RECORD_SCHEMA.fields_dict["messageId"].default
        self.externalUrl = self.RECORD_SCHEMA.fields_dict["externalUrl"].default
        self.status = DataProcessRunStatusClass.STARTED
        self.attempt = self.RECORD_SCHEMA.fields_dict["attempt"].default
        self.result = self.RECORD_SCHEMA.fields_dict["result"].default
    
    
    @property
    def timestampMillis(self) -> int:
        """The event timestamp field as epoch at UTC in milli seconds."""
        return self._inner_dict.get('timestampMillis')  # type: ignore
    
    @timestampMillis.setter
    def timestampMillis(self, value: int) -> None:
        self._inner_dict['timestampMillis'] = value
    
    
    @property
    def eventGranularity(self) -> Union[None, "TimeWindowSizeClass"]:
        """Granularity of the event if applicable"""
        return self._inner_dict.get('eventGranularity')  # type: ignore
    
    @eventGranularity.setter
    def eventGranularity(self, value: Union[None, "TimeWindowSizeClass"]) -> None:
        self._inner_dict['eventGranularity'] = value
    
    
    @property
    def partitionSpec(self) -> Union["PartitionSpecClass", None]:
        """The optional partition specification."""
        return self._inner_dict.get('partitionSpec')  # type: ignore
    
    @partitionSpec.setter
    def partitionSpec(self, value: Union["PartitionSpecClass", None]) -> None:
        self._inner_dict['partitionSpec'] = value
    
    
    @property
    def messageId(self) -> Union[None, str]:
        """The optional messageId, if provided serves as a custom user-defined unique identifier for an aspect value."""
        return self._inner_dict.get('messageId')  # type: ignore
    
    @messageId.setter
    def messageId(self, value: Union[None, str]) -> None:
        self._inner_dict['messageId'] = value
    
    
    @property
    def externalUrl(self) -> Union[None, str]:
        """URL where the reference exist"""
        return self._inner_dict.get('externalUrl')  # type: ignore
    
    @externalUrl.setter
    def externalUrl(self, value: Union[None, str]) -> None:
        self._inner_dict['externalUrl'] = value
    
    
    @property
    def status(self) -> Union[str, "DataProcessRunStatusClass"]:
        # No docs available.
        return self._inner_dict.get('status')  # type: ignore
    
    @status.setter
    def status(self, value: Union[str, "DataProcessRunStatusClass"]) -> None:
        self._inner_dict['status'] = value
    
    
    @property
    def attempt(self) -> Union[None, int]:
        """Return the try number that this Instance Run is in"""
        return self._inner_dict.get('attempt')  # type: ignore
    
    @attempt.setter
    def attempt(self, value: Union[None, int]) -> None:
        self._inner_dict['attempt'] = value
    
    
    @property
    def result(self) -> Union[None, "DataProcessInstanceRunResultClass"]:
        """The final result of the Data Processing run."""
        return self._inner_dict.get('result')  # type: ignore
    
    @result.setter
    def result(self, value: Union[None, "DataProcessInstanceRunResultClass"]) -> None:
        self._inner_dict['result'] = value
    
    
class DataProcessInstanceRunResultClass(DictWrapper):
    # No docs available.
    
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.dataprocess.DataProcessInstanceRunResult")
    def __init__(self,
        type: Union[str, "RunResultTypeClass"],
        nativeResultType: str,
    ):
        super().__init__()
        
        self.type = type
        self.nativeResultType = nativeResultType
    
    def _restore_defaults(self) -> None:
        self.type = RunResultTypeClass.SUCCESS
        self.nativeResultType = str()
    
    
    @property
    def type(self) -> Union[str, "RunResultTypeClass"]:
        """ The final result, e.g. SUCCESS, FAILURE, SKIPPED, or UP_FOR_RETRY."""
        return self._inner_dict.get('type')  # type: ignore
    
    @type.setter
    def type(self, value: Union[str, "RunResultTypeClass"]) -> None:
        self._inner_dict['type'] = value
    
    
    @property
    def nativeResultType(self) -> str:
        """It identifies the system where the native result comes from like Airflow, Azkaban, etc.."""
        return self._inner_dict.get('nativeResultType')  # type: ignore
    
    @nativeResultType.setter
    def nativeResultType(self, value: str) -> None:
        self._inner_dict['nativeResultType'] = value
    
    
class DataProcessRunStatusClass(object):
    # No docs available.
    
    STARTED = "STARTED"
    """The status where the Data processing run is in."""
    
    COMPLETE = "COMPLETE"
    
    
    
class DataProcessTypeClass(object):
    # No docs available.
    
    BATCH_SCHEDULED = "BATCH_SCHEDULED"
    BATCH_AD_HOC = "BATCH_AD_HOC"
    STREAMING = "STREAMING"
    
    
class RunResultTypeClass(object):
    # No docs available.
    
    SUCCESS = "SUCCESS"
    """ The Run Succeeded"""
    
    FAILURE = "FAILURE"
    """ The Run Failed"""
    
    SKIPPED = "SKIPPED"
    """ The Run Skipped"""
    
    UP_FOR_RETRY = "UP_FOR_RETRY"
    """ The Run Failed and will Retry"""
    
    
    
class DataProductAssociationClass(DictWrapper):
    """Represents an association of assets to a Data Product."""
    
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.dataproduct.DataProductAssociation")
    def __init__(self,
        destinationUrn: str,
        sourceUrn: Union[None, str]=None,
        created: Union[None, "AuditStampClass"]=None,
        lastModified: Union[None, "AuditStampClass"]=None,
        properties: Union[None, Dict[str, str]]=None,
    ):
        super().__init__()
        
        self.sourceUrn = sourceUrn
        self.destinationUrn = destinationUrn
        self.created = created
        self.lastModified = lastModified
        self.properties = properties
    
    def _restore_defaults(self) -> None:
        self.sourceUrn = self.RECORD_SCHEMA.fields_dict["sourceUrn"].default
        self.destinationUrn = str()
        self.created = self.RECORD_SCHEMA.fields_dict["created"].default
        self.lastModified = self.RECORD_SCHEMA.fields_dict["lastModified"].default
        self.properties = self.RECORD_SCHEMA.fields_dict["properties"].default
    
    
    @property
    def sourceUrn(self) -> Union[None, str]:
        """Urn of the source of this relationship edge.
    If not specified, assumed to be the entity that this aspect belongs to."""
        return self._inner_dict.get('sourceUrn')  # type: ignore
    
    @sourceUrn.setter
    def sourceUrn(self, value: Union[None, str]) -> None:
        self._inner_dict['sourceUrn'] = value
    
    
    @property
    def destinationUrn(self) -> str:
        """Urn of the destination of this relationship edge."""
        return self._inner_dict.get('destinationUrn')  # type: ignore
    
    @destinationUrn.setter
    def destinationUrn(self, value: str) -> None:
        self._inner_dict['destinationUrn'] = value
    
    
    @property
    def created(self) -> Union[None, "AuditStampClass"]:
        """Audit stamp containing who created this relationship edge and when"""
        return self._inner_dict.get('created')  # type: ignore
    
    @created.setter
    def created(self, value: Union[None, "AuditStampClass"]) -> None:
        self._inner_dict['created'] = value
    
    
    @property
    def lastModified(self) -> Union[None, "AuditStampClass"]:
        """Audit stamp containing who last modified this relationship edge and when"""
        return self._inner_dict.get('lastModified')  # type: ignore
    
    @lastModified.setter
    def lastModified(self, value: Union[None, "AuditStampClass"]) -> None:
        self._inner_dict['lastModified'] = value
    
    
    @property
    def properties(self) -> Union[None, Dict[str, str]]:
        """A generic properties bag that allows us to store specific information on this graph edge."""
        return self._inner_dict.get('properties')  # type: ignore
    
    @properties.setter
    def properties(self, value: Union[None, Dict[str, str]]) -> None:
        self._inner_dict['properties'] = value
    
    
class DataProductKeyClass(_Aspect):
    """Key for a Query"""


    ASPECT_NAME = 'dataProductKey'
    ASPECT_INFO = {'keyForEntity': 'dataProduct', 'entityCategory': 'core', 'entityAspects': ['ownership', 'glossaryTerms', 'globalTags', 'domains', 'dataProductProperties', 'institutionalMemory', 'status', 'structuredProperties', 'forms']}
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.dataproduct.DataProductKey")

    def __init__(self,
        id: str,
    ):
        super().__init__()
        
        self.id = id
    
    def _restore_defaults(self) -> None:
        self.id = str()
    
    
    @property
    def id(self) -> str:
        """A unique id for the Data Product."""
        return self._inner_dict.get('id')  # type: ignore
    
    @id.setter
    def id(self, value: str) -> None:
        self._inner_dict['id'] = value
    
    
class DataProductPropertiesClass(_Aspect):
    """The main properties of a Data Product"""


    ASPECT_NAME = 'dataProductProperties'
    ASPECT_INFO = {}
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.dataproduct.DataProductProperties")

    def __init__(self,
        customProperties: Optional[Dict[str, str]]=None,
        externalUrl: Union[None, str]=None,
        name: Union[None, str]=None,
        description: Union[None, str]=None,
        assets: Union[None, List["DataProductAssociationClass"]]=None,
    ):
        super().__init__()
        
        if customProperties is None:
            # default: {}
            self.customProperties = dict()
        else:
            self.customProperties = customProperties
        self.externalUrl = externalUrl
        self.name = name
        self.description = description
        self.assets = assets
    
    def _restore_defaults(self) -> None:
        self.customProperties = dict()
        self.externalUrl = self.RECORD_SCHEMA.fields_dict["externalUrl"].default
        self.name = self.RECORD_SCHEMA.fields_dict["name"].default
        self.description = self.RECORD_SCHEMA.fields_dict["description"].default
        self.assets = self.RECORD_SCHEMA.fields_dict["assets"].default
    
    
    @property
    def customProperties(self) -> Dict[str, str]:
        """Custom property bag."""
        return self._inner_dict.get('customProperties')  # type: ignore
    
    @customProperties.setter
    def customProperties(self, value: Dict[str, str]) -> None:
        self._inner_dict['customProperties'] = value
    
    
    @property
    def externalUrl(self) -> Union[None, str]:
        """URL where the reference exist"""
        return self._inner_dict.get('externalUrl')  # type: ignore
    
    @externalUrl.setter
    def externalUrl(self, value: Union[None, str]) -> None:
        self._inner_dict['externalUrl'] = value
    
    
    @property
    def name(self) -> Union[None, str]:
        """Display name of the Data Product"""
        return self._inner_dict.get('name')  # type: ignore
    
    @name.setter
    def name(self, value: Union[None, str]) -> None:
        self._inner_dict['name'] = value
    
    
    @property
    def description(self) -> Union[None, str]:
        """Documentation of the dataset"""
        return self._inner_dict.get('description')  # type: ignore
    
    @description.setter
    def description(self, value: Union[None, str]) -> None:
        self._inner_dict['description'] = value
    
    
    @property
    def assets(self) -> Union[None, List["DataProductAssociationClass"]]:
        """A list of assets that are part of this Data Product"""
        return self._inner_dict.get('assets')  # type: ignore
    
    @assets.setter
    def assets(self, value: Union[None, List["DataProductAssociationClass"]]) -> None:
        self._inner_dict['assets'] = value
    
    
class DatasetDeprecationClass(_Aspect):
    """Dataset deprecation status
    Deprecated! This aspect is deprecated in favor of the more-general-purpose 'Deprecation' aspect."""


    ASPECT_NAME = 'datasetDeprecation'
    ASPECT_INFO = {}
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.dataset.DatasetDeprecation")

    def __init__(self,
        deprecated: bool,
        note: str,
        decommissionTime: Union[None, int]=None,
        actor: Union[None, str]=None,
    ):
        super().__init__()
        
        self.deprecated = deprecated
        self.decommissionTime = decommissionTime
        self.note = note
        self.actor = actor
    
    def _restore_defaults(self) -> None:
        self.deprecated = bool()
        self.decommissionTime = self.RECORD_SCHEMA.fields_dict["decommissionTime"].default
        self.note = str()
        self.actor = self.RECORD_SCHEMA.fields_dict["actor"].default
    
    
    @property
    def deprecated(self) -> bool:
        """Whether the dataset is deprecated by owner."""
        return self._inner_dict.get('deprecated')  # type: ignore
    
    @deprecated.setter
    def deprecated(self, value: bool) -> None:
        self._inner_dict['deprecated'] = value
    
    
    @property
    def decommissionTime(self) -> Union[None, int]:
        """The time user plan to decommission this dataset."""
        return self._inner_dict.get('decommissionTime')  # type: ignore
    
    @decommissionTime.setter
    def decommissionTime(self, value: Union[None, int]) -> None:
        self._inner_dict['decommissionTime'] = value
    
    
    @property
    def note(self) -> str:
        """Additional information about the dataset deprecation plan, such as the wiki, doc, RB."""
        return self._inner_dict.get('note')  # type: ignore
    
    @note.setter
    def note(self, value: str) -> None:
        self._inner_dict['note'] = value
    
    
    @property
    def actor(self) -> Union[None, str]:
        """The corpuser URN which will be credited for modifying this deprecation content."""
        return self._inner_dict.get('actor')  # type: ignore
    
    @actor.setter
    def actor(self, value: Union[None, str]) -> None:
        self._inner_dict['actor'] = value
    
    
class DatasetFieldMappingClass(DictWrapper):
    """Representation of mapping between fields in source dataset to the field in destination dataset"""
    
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.dataset.DatasetFieldMapping")
    def __init__(self,
        created: "AuditStampClass",
        transformation: Union[Union[str, "TransformationTypeClass"], "UDFTransformerClass"],
        sourceFields: List[str],
        destinationField: str,
    ):
        super().__init__()
        
        self.created = created
        self.transformation = transformation
        self.sourceFields = sourceFields
        self.destinationField = destinationField
    
    def _restore_defaults(self) -> None:
        self.created = AuditStampClass._construct_with_defaults()
        self.transformation = TransformationTypeClass.BLACKBOX
        self.sourceFields = list()
        self.destinationField = str()
    
    
    @property
    def created(self) -> "AuditStampClass":
        """Audit stamp containing who reported the field mapping and when"""
        return self._inner_dict.get('created')  # type: ignore
    
    @created.setter
    def created(self, value: "AuditStampClass") -> None:
        self._inner_dict['created'] = value
    
    
    @property
    def transformation(self) -> Union[Union[str, "TransformationTypeClass"], "UDFTransformerClass"]:
        """Transfomration function between the fields involved"""
        return self._inner_dict.get('transformation')  # type: ignore
    
    @transformation.setter
    def transformation(self, value: Union[Union[str, "TransformationTypeClass"], "UDFTransformerClass"]) -> None:
        self._inner_dict['transformation'] = value
    
    
    @property
    def sourceFields(self) -> List[str]:
        """Source fields from which the fine grained lineage is derived"""
        return self._inner_dict.get('sourceFields')  # type: ignore
    
    @sourceFields.setter
    def sourceFields(self, value: List[str]) -> None:
        self._inner_dict['sourceFields'] = value
    
    
    @property
    def destinationField(self) -> str:
        """Destination field which is derived from source fields"""
        return self._inner_dict.get('destinationField')  # type: ignore
    
    @destinationField.setter
    def destinationField(self, value: str) -> None:
        self._inner_dict['destinationField'] = value
    
    
class DatasetFieldProfileClass(DictWrapper):
    """Stats corresponding to fields in a dataset"""
    
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.dataset.DatasetFieldProfile")
    def __init__(self,
        fieldPath: str,
        uniqueCount: Union[None, int]=None,
        uniqueProportion: Union[None, float]=None,
        nullCount: Union[None, int]=None,
        nullProportion: Union[None, float]=None,
        min: Union[None, str]=None,
        max: Union[None, str]=None,
        mean: Union[None, str]=None,
        median: Union[None, str]=None,
        stdev: Union[None, str]=None,
        quantiles: Union[None, List["QuantileClass"]]=None,
        distinctValueFrequencies: Union[None, List["ValueFrequencyClass"]]=None,
        histogram: Union[None, "HistogramClass"]=None,
        sampleValues: Union[None, List[str]]=None,
    ):
        super().__init__()
        
        self.fieldPath = fieldPath
        self.uniqueCount = uniqueCount
        self.uniqueProportion = uniqueProportion
        self.nullCount = nullCount
        self.nullProportion = nullProportion
        self.min = min
        self.max = max
        self.mean = mean
        self.median = median
        self.stdev = stdev
        self.quantiles = quantiles
        self.distinctValueFrequencies = distinctValueFrequencies
        self.histogram = histogram
        self.sampleValues = sampleValues
    
    def _restore_defaults(self) -> None:
        self.fieldPath = str()
        self.uniqueCount = self.RECORD_SCHEMA.fields_dict["uniqueCount"].default
        self.uniqueProportion = self.RECORD_SCHEMA.fields_dict["uniqueProportion"].default
        self.nullCount = self.RECORD_SCHEMA.fields_dict["nullCount"].default
        self.nullProportion = self.RECORD_SCHEMA.fields_dict["nullProportion"].default
        self.min = self.RECORD_SCHEMA.fields_dict["min"].default
        self.max = self.RECORD_SCHEMA.fields_dict["max"].default
        self.mean = self.RECORD_SCHEMA.fields_dict["mean"].default
        self.median = self.RECORD_SCHEMA.fields_dict["median"].default
        self.stdev = self.RECORD_SCHEMA.fields_dict["stdev"].default
        self.quantiles = self.RECORD_SCHEMA.fields_dict["quantiles"].default
        self.distinctValueFrequencies = self.RECORD_SCHEMA.fields_dict["distinctValueFrequencies"].default
        self.histogram = self.RECORD_SCHEMA.fields_dict["histogram"].default
        self.sampleValues = self.RECORD_SCHEMA.fields_dict["sampleValues"].default
    
    
    @property
    def fieldPath(self) -> str:
        # No docs available.
        return self._inner_dict.get('fieldPath')  # type: ignore
    
    @fieldPath.setter
    def fieldPath(self, value: str) -> None:
        self._inner_dict['fieldPath'] = value
    
    
    @property
    def uniqueCount(self) -> Union[None, int]:
        # No docs available.
        return self._inner_dict.get('uniqueCount')  # type: ignore
    
    @uniqueCount.setter
    def uniqueCount(self, value: Union[None, int]) -> None:
        self._inner_dict['uniqueCount'] = value
    
    
    @property
    def uniqueProportion(self) -> Union[None, float]:
        # No docs available.
        return self._inner_dict.get('uniqueProportion')  # type: ignore
    
    @uniqueProportion.setter
    def uniqueProportion(self, value: Union[None, float]) -> None:
        self._inner_dict['uniqueProportion'] = value
    
    
    @property
    def nullCount(self) -> Union[None, int]:
        # No docs available.
        return self._inner_dict.get('nullCount')  # type: ignore
    
    @nullCount.setter
    def nullCount(self, value: Union[None, int]) -> None:
        self._inner_dict['nullCount'] = value
    
    
    @property
    def nullProportion(self) -> Union[None, float]:
        # No docs available.
        return self._inner_dict.get('nullProportion')  # type: ignore
    
    @nullProportion.setter
    def nullProportion(self, value: Union[None, float]) -> None:
        self._inner_dict['nullProportion'] = value
    
    
    @property
    def min(self) -> Union[None, str]:
        # No docs available.
        return self._inner_dict.get('min')  # type: ignore
    
    @min.setter
    def min(self, value: Union[None, str]) -> None:
        self._inner_dict['min'] = value
    
    
    @property
    def max(self) -> Union[None, str]:
        # No docs available.
        return self._inner_dict.get('max')  # type: ignore
    
    @max.setter
    def max(self, value: Union[None, str]) -> None:
        self._inner_dict['max'] = value
    
    
    @property
    def mean(self) -> Union[None, str]:
        # No docs available.
        return self._inner_dict.get('mean')  # type: ignore
    
    @mean.setter
    def mean(self, value: Union[None, str]) -> None:
        self._inner_dict['mean'] = value
    
    
    @property
    def median(self) -> Union[None, str]:
        # No docs available.
        return self._inner_dict.get('median')  # type: ignore
    
    @median.setter
    def median(self, value: Union[None, str]) -> None:
        self._inner_dict['median'] = value
    
    
    @property
    def stdev(self) -> Union[None, str]:
        # No docs available.
        return self._inner_dict.get('stdev')  # type: ignore
    
    @stdev.setter
    def stdev(self, value: Union[None, str]) -> None:
        self._inner_dict['stdev'] = value
    
    
    @property
    def quantiles(self) -> Union[None, List["QuantileClass"]]:
        # No docs available.
        return self._inner_dict.get('quantiles')  # type: ignore
    
    @quantiles.setter
    def quantiles(self, value: Union[None, List["QuantileClass"]]) -> None:
        self._inner_dict['quantiles'] = value
    
    
    @property
    def distinctValueFrequencies(self) -> Union[None, List["ValueFrequencyClass"]]:
        # No docs available.
        return self._inner_dict.get('distinctValueFrequencies')  # type: ignore
    
    @distinctValueFrequencies.setter
    def distinctValueFrequencies(self, value: Union[None, List["ValueFrequencyClass"]]) -> None:
        self._inner_dict['distinctValueFrequencies'] = value
    
    
    @property
    def histogram(self) -> Union[None, "HistogramClass"]:
        # No docs available.
        return self._inner_dict.get('histogram')  # type: ignore
    
    @histogram.setter
    def histogram(self, value: Union[None, "HistogramClass"]) -> None:
        self._inner_dict['histogram'] = value
    
    
    @property
    def sampleValues(self) -> Union[None, List[str]]:
        # No docs available.
        return self._inner_dict.get('sampleValues')  # type: ignore
    
    @sampleValues.setter
    def sampleValues(self, value: Union[None, List[str]]) -> None:
        self._inner_dict['sampleValues'] = value
    
    
class DatasetFieldUsageCountsClass(DictWrapper):
    """Records field-level usage counts for a given dataset"""
    
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.dataset.DatasetFieldUsageCounts")
    def __init__(self,
        fieldPath: str,
        count: int,
    ):
        super().__init__()
        
        self.fieldPath = fieldPath
        self.count = count
    
    def _restore_defaults(self) -> None:
        self.fieldPath = str()
        self.count = int()
    
    
    @property
    def fieldPath(self) -> str:
        """The name of the field."""
        return self._inner_dict.get('fieldPath')  # type: ignore
    
    @fieldPath.setter
    def fieldPath(self, value: str) -> None:
        self._inner_dict['fieldPath'] = value
    
    
    @property
    def count(self) -> int:
        """Number of times the field has been used."""
        return self._inner_dict.get('count')  # type: ignore
    
    @count.setter
    def count(self, value: int) -> None:
        self._inner_dict['count'] = value
    
    
class DatasetFilterClass(DictWrapper):
    """A definition of filters that should be used when
    querying an external Dataset or Table.
    
    Note that this models should NOT be used for working with
    search / filter on DataHub Platform itself."""
    
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.dataset.DatasetFilter")
    def __init__(self,
        type: Union[str, "DatasetFilterTypeClass"],
        sql: Union[None, str]=None,
    ):
        super().__init__()
        
        self.type = type
        self.sql = sql
    
    def _restore_defaults(self) -> None:
        self.type = DatasetFilterTypeClass.SQL
        self.sql = self.RECORD_SCHEMA.fields_dict["sql"].default
    
    
    @property
    def type(self) -> Union[str, "DatasetFilterTypeClass"]:
        """How the partition will be represented in this model.
    
    In the future, we'll likely add support for more structured
    predicates."""
        return self._inner_dict.get('type')  # type: ignore
    
    @type.setter
    def type(self, value: Union[str, "DatasetFilterTypeClass"]) -> None:
        self._inner_dict['type'] = value
    
    
    @property
    def sql(self) -> Union[None, str]:
        """The raw where clause string which will be used for monitoring.
    Required if the type is SQL."""
        return self._inner_dict.get('sql')  # type: ignore
    
    @sql.setter
    def sql(self, value: Union[None, str]) -> None:
        self._inner_dict['sql'] = value
    
    
class DatasetFilterTypeClass(object):
    # No docs available.
    
    SQL = "SQL"
    """The partition is represented as a an opaque, raw SQL
    clause."""
    
    
    
class DatasetLineageTypeClass(object):
    """The various types of supported dataset lineage"""
    
    COPY = "COPY"
    """Direct copy without modification"""
    
    TRANSFORMED = "TRANSFORMED"
    """Transformed data with modification (format or content change)"""
    
    VIEW = "VIEW"
    """Represents a view defined on the sources e.g. Hive view defined on underlying hive tables or a Hive table pointing to a HDFS dataset or DALI view defined on multiple sources"""
    
    
    
class DatasetProfileClass(_Aspect):
    """Stats corresponding to datasets"""


    ASPECT_NAME = 'datasetProfile'
    ASPECT_TYPE = 'timeseries'
    ASPECT_INFO = {}
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.dataset.DatasetProfile")

    def __init__(self,
        timestampMillis: int,
        eventGranularity: Union[None, "TimeWindowSizeClass"]=None,
        partitionSpec: Optional[Union["PartitionSpecClass", None]]=None,
        messageId: Union[None, str]=None,
        rowCount: Union[None, int]=None,
        columnCount: Union[None, int]=None,
        fieldProfiles: Union[None, List["DatasetFieldProfileClass"]]=None,
        sizeInBytes: Union[None, int]=None,
    ):
        super().__init__()
        
        self.timestampMillis = timestampMillis
        self.eventGranularity = eventGranularity
        if partitionSpec is None:
            # default: {'partition': 'FULL_TABLE_SNAPSHOT', 'type': 'FULL_TABLE', 'timePartition': None}
            self.partitionSpec = _json_converter.from_json_object(self.RECORD_SCHEMA.fields_dict["partitionSpec"].default, writers_schema=self.RECORD_SCHEMA.fields_dict["partitionSpec"].type)
        else:
            self.partitionSpec = partitionSpec
        self.messageId = messageId
        self.rowCount = rowCount
        self.columnCount = columnCount
        self.fieldProfiles = fieldProfiles
        self.sizeInBytes = sizeInBytes
    
    def _restore_defaults(self) -> None:
        self.timestampMillis = int()
        self.eventGranularity = self.RECORD_SCHEMA.fields_dict["eventGranularity"].default
        self.partitionSpec = _json_converter.from_json_object(self.RECORD_SCHEMA.fields_dict["partitionSpec"].default, writers_schema=self.RECORD_SCHEMA.fields_dict["partitionSpec"].type)
        self.messageId = self.RECORD_SCHEMA.fields_dict["messageId"].default
        self.rowCount = self.RECORD_SCHEMA.fields_dict["rowCount"].default
        self.columnCount = self.RECORD_SCHEMA.fields_dict["columnCount"].default
        self.fieldProfiles = self.RECORD_SCHEMA.fields_dict["fieldProfiles"].default
        self.sizeInBytes = self.RECORD_SCHEMA.fields_dict["sizeInBytes"].default
    
    
    @property
    def timestampMillis(self) -> int:
        """The event timestamp field as epoch at UTC in milli seconds."""
        return self._inner_dict.get('timestampMillis')  # type: ignore
    
    @timestampMillis.setter
    def timestampMillis(self, value: int) -> None:
        self._inner_dict['timestampMillis'] = value
    
    
    @property
    def eventGranularity(self) -> Union[None, "TimeWindowSizeClass"]:
        """Granularity of the event if applicable"""
        return self._inner_dict.get('eventGranularity')  # type: ignore
    
    @eventGranularity.setter
    def eventGranularity(self, value: Union[None, "TimeWindowSizeClass"]) -> None:
        self._inner_dict['eventGranularity'] = value
    
    
    @property
    def partitionSpec(self) -> Union["PartitionSpecClass", None]:
        """The optional partition specification."""
        return self._inner_dict.get('partitionSpec')  # type: ignore
    
    @partitionSpec.setter
    def partitionSpec(self, value: Union["PartitionSpecClass", None]) -> None:
        self._inner_dict['partitionSpec'] = value
    
    
    @property
    def messageId(self) -> Union[None, str]:
        """The optional messageId, if provided serves as a custom user-defined unique identifier for an aspect value."""
        return self._inner_dict.get('messageId')  # type: ignore
    
    @messageId.setter
    def messageId(self, value: Union[None, str]) -> None:
        self._inner_dict['messageId'] = value
    
    
    @property
    def rowCount(self) -> Union[None, int]:
        """The total number of rows"""
        return self._inner_dict.get('rowCount')  # type: ignore
    
    @rowCount.setter
    def rowCount(self, value: Union[None, int]) -> None:
        self._inner_dict['rowCount'] = value
    
    
    @property
    def columnCount(self) -> Union[None, int]:
        """The total number of columns (or schema fields)"""
        return self._inner_dict.get('columnCount')  # type: ignore
    
    @columnCount.setter
    def columnCount(self, value: Union[None, int]) -> None:
        self._inner_dict['columnCount'] = value
    
    
    @property
    def fieldProfiles(self) -> Union[None, List["DatasetFieldProfileClass"]]:
        """Profiles for each column (or schema field)"""
        return self._inner_dict.get('fieldProfiles')  # type: ignore
    
    @fieldProfiles.setter
    def fieldProfiles(self, value: Union[None, List["DatasetFieldProfileClass"]]) -> None:
        self._inner_dict['fieldProfiles'] = value
    
    
    @property
    def sizeInBytes(self) -> Union[None, int]:
        """Storage size in bytes"""
        return self._inner_dict.get('sizeInBytes')  # type: ignore
    
    @sizeInBytes.setter
    def sizeInBytes(self, value: Union[None, int]) -> None:
        self._inner_dict['sizeInBytes'] = value
    
    
class DatasetPropertiesClass(_Aspect):
    """Properties associated with a Dataset"""


    ASPECT_NAME = 'datasetProperties'
    ASPECT_INFO = {}
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.dataset.DatasetProperties")

    def __init__(self,
        customProperties: Optional[Dict[str, str]]=None,
        externalUrl: Union[None, str]=None,
        name: Union[None, str]=None,
        qualifiedName: Union[None, str]=None,
        description: Union[None, str]=None,
        uri: Union[None, str]=None,
        created: Union[None, "TimeStampClass"]=None,
        lastModified: Union[None, "TimeStampClass"]=None,
        tags: Optional[List[str]]=None,
    ):
        super().__init__()
        
        if customProperties is None:
            # default: {}
            self.customProperties = dict()
        else:
            self.customProperties = customProperties
        self.externalUrl = externalUrl
        self.name = name
        self.qualifiedName = qualifiedName
        self.description = description
        self.uri = uri
        self.created = created
        self.lastModified = lastModified
        if tags is None:
            # default: []
            self.tags = list()
        else:
            self.tags = tags
    
    def _restore_defaults(self) -> None:
        self.customProperties = dict()
        self.externalUrl = self.RECORD_SCHEMA.fields_dict["externalUrl"].default
        self.name = self.RECORD_SCHEMA.fields_dict["name"].default
        self.qualifiedName = self.RECORD_SCHEMA.fields_dict["qualifiedName"].default
        self.description = self.RECORD_SCHEMA.fields_dict["description"].default
        self.uri = self.RECORD_SCHEMA.fields_dict["uri"].default
        self.created = self.RECORD_SCHEMA.fields_dict["created"].default
        self.lastModified = self.RECORD_SCHEMA.fields_dict["lastModified"].default
        self.tags = list()
    
    
    @property
    def customProperties(self) -> Dict[str, str]:
        """Custom property bag."""
        return self._inner_dict.get('customProperties')  # type: ignore
    
    @customProperties.setter
    def customProperties(self, value: Dict[str, str]) -> None:
        self._inner_dict['customProperties'] = value
    
    
    @property
    def externalUrl(self) -> Union[None, str]:
        """URL where the reference exist"""
        return self._inner_dict.get('externalUrl')  # type: ignore
    
    @externalUrl.setter
    def externalUrl(self, value: Union[None, str]) -> None:
        self._inner_dict['externalUrl'] = value
    
    
    @property
    def name(self) -> Union[None, str]:
        """Display name of the Dataset"""
        return self._inner_dict.get('name')  # type: ignore
    
    @name.setter
    def name(self, value: Union[None, str]) -> None:
        self._inner_dict['name'] = value
    
    
    @property
    def qualifiedName(self) -> Union[None, str]:
        """Fully-qualified name of the Dataset"""
        return self._inner_dict.get('qualifiedName')  # type: ignore
    
    @qualifiedName.setter
    def qualifiedName(self, value: Union[None, str]) -> None:
        self._inner_dict['qualifiedName'] = value
    
    
    @property
    def description(self) -> Union[None, str]:
        """Documentation of the dataset"""
        return self._inner_dict.get('description')  # type: ignore
    
    @description.setter
    def description(self, value: Union[None, str]) -> None:
        self._inner_dict['description'] = value
    
    
    @property
    def uri(self) -> Union[None, str]:
        """The abstracted URI such as hdfs:///data/tracking/PageViewEvent, file:///dir/file_name. Uri should not include any environment specific properties. Some datasets might not have a standardized uri, which makes this field optional (i.e. kafka topic)."""
        return self._inner_dict.get('uri')  # type: ignore
    
    @uri.setter
    def uri(self, value: Union[None, str]) -> None:
        self._inner_dict['uri'] = value
    
    
    @property
    def created(self) -> Union[None, "TimeStampClass"]:
        """A timestamp documenting when the asset was created in the source Data Platform (not on DataHub)"""
        return self._inner_dict.get('created')  # type: ignore
    
    @created.setter
    def created(self, value: Union[None, "TimeStampClass"]) -> None:
        self._inner_dict['created'] = value
    
    
    @property
    def lastModified(self) -> Union[None, "TimeStampClass"]:
        """A timestamp documenting when the asset was last modified in the source Data Platform (not on DataHub)"""
        return self._inner_dict.get('lastModified')  # type: ignore
    
    @lastModified.setter
    def lastModified(self, value: Union[None, "TimeStampClass"]) -> None:
        self._inner_dict['lastModified'] = value
    
    
    @property
    def tags(self) -> List[str]:
        """[Legacy] Unstructured tags for the dataset. Structured tags can be applied via the `GlobalTags` aspect.
    This is now deprecated."""
        return self._inner_dict.get('tags')  # type: ignore
    
    @tags.setter
    def tags(self, value: List[str]) -> None:
        self._inner_dict['tags'] = value
    
    
class DatasetUpstreamLineageClass(_Aspect):
    """Fine Grained upstream lineage for fields in a dataset"""


    ASPECT_NAME = 'datasetUpstreamLineage'
    ASPECT_INFO = {}
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.dataset.DatasetUpstreamLineage")

    def __init__(self,
        fieldMappings: List["DatasetFieldMappingClass"],
    ):
        super().__init__()
        
        self.fieldMappings = fieldMappings
    
    def _restore_defaults(self) -> None:
        self.fieldMappings = list()
    
    
    @property
    def fieldMappings(self) -> List["DatasetFieldMappingClass"]:
        """Upstream to downstream field level lineage mappings"""
        return self._inner_dict.get('fieldMappings')  # type: ignore
    
    @fieldMappings.setter
    def fieldMappings(self, value: List["DatasetFieldMappingClass"]) -> None:
        self._inner_dict['fieldMappings'] = value
    
    
class DatasetUsageStatisticsClass(_Aspect):
    """Stats corresponding to dataset's usage."""


    ASPECT_NAME = 'datasetUsageStatistics'
    ASPECT_TYPE = 'timeseries'
    ASPECT_INFO = {}
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.dataset.DatasetUsageStatistics")

    def __init__(self,
        timestampMillis: int,
        eventGranularity: Union[None, "TimeWindowSizeClass"]=None,
        partitionSpec: Optional[Union["PartitionSpecClass", None]]=None,
        messageId: Union[None, str]=None,
        uniqueUserCount: Union[None, int]=None,
        totalSqlQueries: Union[None, int]=None,
        topSqlQueries: Union[None, List[str]]=None,
        userCounts: Union[None, List["DatasetUserUsageCountsClass"]]=None,
        fieldCounts: Union[None, List["DatasetFieldUsageCountsClass"]]=None,
    ):
        super().__init__()
        
        self.timestampMillis = timestampMillis
        self.eventGranularity = eventGranularity
        if partitionSpec is None:
            # default: {'partition': 'FULL_TABLE_SNAPSHOT', 'type': 'FULL_TABLE', 'timePartition': None}
            self.partitionSpec = _json_converter.from_json_object(self.RECORD_SCHEMA.fields_dict["partitionSpec"].default, writers_schema=self.RECORD_SCHEMA.fields_dict["partitionSpec"].type)
        else:
            self.partitionSpec = partitionSpec
        self.messageId = messageId
        self.uniqueUserCount = uniqueUserCount
        self.totalSqlQueries = totalSqlQueries
        self.topSqlQueries = topSqlQueries
        self.userCounts = userCounts
        self.fieldCounts = fieldCounts
    
    def _restore_defaults(self) -> None:
        self.timestampMillis = int()
        self.eventGranularity = self.RECORD_SCHEMA.fields_dict["eventGranularity"].default
        self.partitionSpec = _json_converter.from_json_object(self.RECORD_SCHEMA.fields_dict["partitionSpec"].default, writers_schema=self.RECORD_SCHEMA.fields_dict["partitionSpec"].type)
        self.messageId = self.RECORD_SCHEMA.fields_dict["messageId"].default
        self.uniqueUserCount = self.RECORD_SCHEMA.fields_dict["uniqueUserCount"].default
        self.totalSqlQueries = self.RECORD_SCHEMA.fields_dict["totalSqlQueries"].default
        self.topSqlQueries = self.RECORD_SCHEMA.fields_dict["topSqlQueries"].default
        self.userCounts = self.RECORD_SCHEMA.fields_dict["userCounts"].default
        self.fieldCounts = self.RECORD_SCHEMA.fields_dict["fieldCounts"].default
    
    
    @property
    def timestampMillis(self) -> int:
        """The event timestamp field as epoch at UTC in milli seconds."""
        return self._inner_dict.get('timestampMillis')  # type: ignore
    
    @timestampMillis.setter
    def timestampMillis(self, value: int) -> None:
        self._inner_dict['timestampMillis'] = value
    
    
    @property
    def eventGranularity(self) -> Union[None, "TimeWindowSizeClass"]:
        """Granularity of the event if applicable"""
        return self._inner_dict.get('eventGranularity')  # type: ignore
    
    @eventGranularity.setter
    def eventGranularity(self, value: Union[None, "TimeWindowSizeClass"]) -> None:
        self._inner_dict['eventGranularity'] = value
    
    
    @property
    def partitionSpec(self) -> Union["PartitionSpecClass", None]:
        """The optional partition specification."""
        return self._inner_dict.get('partitionSpec')  # type: ignore
    
    @partitionSpec.setter
    def partitionSpec(self, value: Union["PartitionSpecClass", None]) -> None:
        self._inner_dict['partitionSpec'] = value
    
    
    @property
    def messageId(self) -> Union[None, str]:
        """The optional messageId, if provided serves as a custom user-defined unique identifier for an aspect value."""
        return self._inner_dict.get('messageId')  # type: ignore
    
    @messageId.setter
    def messageId(self, value: Union[None, str]) -> None:
        self._inner_dict['messageId'] = value
    
    
    @property
    def uniqueUserCount(self) -> Union[None, int]:
        """Unique user count"""
        return self._inner_dict.get('uniqueUserCount')  # type: ignore
    
    @uniqueUserCount.setter
    def uniqueUserCount(self, value: Union[None, int]) -> None:
        self._inner_dict['uniqueUserCount'] = value
    
    
    @property
    def totalSqlQueries(self) -> Union[None, int]:
        """Total SQL query count"""
        return self._inner_dict.get('totalSqlQueries')  # type: ignore
    
    @totalSqlQueries.setter
    def totalSqlQueries(self, value: Union[None, int]) -> None:
        self._inner_dict['totalSqlQueries'] = value
    
    
    @property
    def topSqlQueries(self) -> Union[None, List[str]]:
        """Frequent SQL queries; mostly makes sense for datasets in SQL databases"""
        return self._inner_dict.get('topSqlQueries')  # type: ignore
    
    @topSqlQueries.setter
    def topSqlQueries(self, value: Union[None, List[str]]) -> None:
        self._inner_dict['topSqlQueries'] = value
    
    
    @property
    def userCounts(self) -> Union[None, List["DatasetUserUsageCountsClass"]]:
        """Users within this bucket, with frequency counts"""
        return self._inner_dict.get('userCounts')  # type: ignore
    
    @userCounts.setter
    def userCounts(self, value: Union[None, List["DatasetUserUsageCountsClass"]]) -> None:
        self._inner_dict['userCounts'] = value
    
    
    @property
    def fieldCounts(self) -> Union[None, List["DatasetFieldUsageCountsClass"]]:
        """Field-level usage stats"""
        return self._inner_dict.get('fieldCounts')  # type: ignore
    
    @fieldCounts.setter
    def fieldCounts(self, value: Union[None, List["DatasetFieldUsageCountsClass"]]) -> None:
        self._inner_dict['fieldCounts'] = value
    
    
class DatasetUserUsageCountsClass(DictWrapper):
    """Records a single user's usage counts for a given resource"""
    
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.dataset.DatasetUserUsageCounts")
    def __init__(self,
        user: str,
        count: int,
        userEmail: Union[None, str]=None,
    ):
        super().__init__()
        
        self.user = user
        self.count = count
        self.userEmail = userEmail
    
    def _restore_defaults(self) -> None:
        self.user = str()
        self.count = int()
        self.userEmail = self.RECORD_SCHEMA.fields_dict["userEmail"].default
    
    
    @property
    def user(self) -> str:
        """The unique id of the user."""
        return self._inner_dict.get('user')  # type: ignore
    
    @user.setter
    def user(self, value: str) -> None:
        self._inner_dict['user'] = value
    
    
    @property
    def count(self) -> int:
        """Number of times the dataset has been used by the user."""
        return self._inner_dict.get('count')  # type: ignore
    
    @count.setter
    def count(self, value: int) -> None:
        self._inner_dict['count'] = value
    
    
    @property
    def userEmail(self) -> Union[None, str]:
        """If user_email is set, we attempt to resolve the user's urn upon ingest"""
        return self._inner_dict.get('userEmail')  # type: ignore
    
    @userEmail.setter
    def userEmail(self, value: Union[None, str]) -> None:
        self._inner_dict['userEmail'] = value
    
    
class EditableDatasetPropertiesClass(_Aspect):
    """EditableDatasetProperties stores editable changes made to dataset properties. This separates changes made from
    ingestion pipelines and edits in the UI to avoid accidental overwrites of user-provided data by ingestion pipelines"""


    ASPECT_NAME = 'editableDatasetProperties'
    ASPECT_INFO = {}
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.dataset.EditableDatasetProperties")

    def __init__(self,
        created: Optional["AuditStampClass"]=None,
        lastModified: Optional["AuditStampClass"]=None,
        deleted: Union[None, "AuditStampClass"]=None,
        description: Union[None, str]=None,
    ):
        super().__init__()
        
        if created is None:
            # default: {'actor': 'urn:li:corpuser:unknown', 'impersonator': None, 'time': 0, 'message': None}
            self.created = _json_converter.from_json_object(self.RECORD_SCHEMA.fields_dict["created"].default, writers_schema=self.RECORD_SCHEMA.fields_dict["created"].type)
        else:
            self.created = created
        if lastModified is None:
            # default: {'actor': 'urn:li:corpuser:unknown', 'impersonator': None, 'time': 0, 'message': None}
            self.lastModified = _json_converter.from_json_object(self.RECORD_SCHEMA.fields_dict["lastModified"].default, writers_schema=self.RECORD_SCHEMA.fields_dict["lastModified"].type)
        else:
            self.lastModified = lastModified
        self.deleted = deleted
        self.description = description
    
    def _restore_defaults(self) -> None:
        self.created = _json_converter.from_json_object(self.RECORD_SCHEMA.fields_dict["created"].default, writers_schema=self.RECORD_SCHEMA.fields_dict["created"].type)
        self.lastModified = _json_converter.from_json_object(self.RECORD_SCHEMA.fields_dict["lastModified"].default, writers_schema=self.RECORD_SCHEMA.fields_dict["lastModified"].type)
        self.deleted = self.RECORD_SCHEMA.fields_dict["deleted"].default
        self.description = self.RECORD_SCHEMA.fields_dict["description"].default
    
    
    @property
    def created(self) -> "AuditStampClass":
        """An AuditStamp corresponding to the creation of this resource/association/sub-resource. A value of 0 for time indicates missing data."""
        return self._inner_dict.get('created')  # type: ignore
    
    @created.setter
    def created(self, value: "AuditStampClass") -> None:
        self._inner_dict['created'] = value
    
    
    @property
    def lastModified(self) -> "AuditStampClass":
        """An AuditStamp corresponding to the last modification of this resource/association/sub-resource. If no modification has happened since creation, lastModified should be the same as created. A value of 0 for time indicates missing data."""
        return self._inner_dict.get('lastModified')  # type: ignore
    
    @lastModified.setter
    def lastModified(self, value: "AuditStampClass") -> None:
        self._inner_dict['lastModified'] = value
    
    
    @property
    def deleted(self) -> Union[None, "AuditStampClass"]:
        """An AuditStamp corresponding to the deletion of this resource/association/sub-resource. Logically, deleted MUST have a later timestamp than creation. It may or may not have the same time as lastModified depending upon the resource/association/sub-resource semantics."""
        return self._inner_dict.get('deleted')  # type: ignore
    
    @deleted.setter
    def deleted(self, value: Union[None, "AuditStampClass"]) -> None:
        self._inner_dict['deleted'] = value
    
    
    @property
    def description(self) -> Union[None, str]:
        """Documentation of the dataset"""
        return self._inner_dict.get('description')  # type: ignore
    
    @description.setter
    def description(self, value: Union[None, str]) -> None:
        self._inner_dict['description'] = value
    
    
class FineGrainedLineageClass(DictWrapper):
    """A fine-grained lineage from upstream fields/datasets to downstream field(s)"""
    
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.dataset.FineGrainedLineage")
    def __init__(self,
        upstreamType: Union[str, "FineGrainedLineageUpstreamTypeClass"],
        downstreamType: Union[str, "FineGrainedLineageDownstreamTypeClass"],
        upstreams: Union[None, List[str]]=None,
        downstreams: Union[None, List[str]]=None,
        transformOperation: Union[None, str]=None,
        confidenceScore: Optional[float]=None,
        query: Union[None, str]=None,
    ):
        super().__init__()
        
        self.upstreamType = upstreamType
        self.upstreams = upstreams
        self.downstreamType = downstreamType
        self.downstreams = downstreams
        self.transformOperation = transformOperation
        if confidenceScore is None:
            # default: 1.0
            self.confidenceScore = self.RECORD_SCHEMA.fields_dict["confidenceScore"].default
        else:
            self.confidenceScore = confidenceScore
        self.query = query
    
    def _restore_defaults(self) -> None:
        self.upstreamType = FineGrainedLineageUpstreamTypeClass.FIELD_SET
        self.upstreams = self.RECORD_SCHEMA.fields_dict["upstreams"].default
        self.downstreamType = FineGrainedLineageDownstreamTypeClass.FIELD
        self.downstreams = self.RECORD_SCHEMA.fields_dict["downstreams"].default
        self.transformOperation = self.RECORD_SCHEMA.fields_dict["transformOperation"].default
        self.confidenceScore = self.RECORD_SCHEMA.fields_dict["confidenceScore"].default
        self.query = self.RECORD_SCHEMA.fields_dict["query"].default
    
    
    @property
    def upstreamType(self) -> Union[str, "FineGrainedLineageUpstreamTypeClass"]:
        """The type of upstream entity"""
        return self._inner_dict.get('upstreamType')  # type: ignore
    
    @upstreamType.setter
    def upstreamType(self, value: Union[str, "FineGrainedLineageUpstreamTypeClass"]) -> None:
        self._inner_dict['upstreamType'] = value
    
    
    @property
    def upstreams(self) -> Union[None, List[str]]:
        """Upstream entities in the lineage"""
        return self._inner_dict.get('upstreams')  # type: ignore
    
    @upstreams.setter
    def upstreams(self, value: Union[None, List[str]]) -> None:
        self._inner_dict['upstreams'] = value
    
    
    @property
    def downstreamType(self) -> Union[str, "FineGrainedLineageDownstreamTypeClass"]:
        """The type of downstream field(s)"""
        return self._inner_dict.get('downstreamType')  # type: ignore
    
    @downstreamType.setter
    def downstreamType(self, value: Union[str, "FineGrainedLineageDownstreamTypeClass"]) -> None:
        self._inner_dict['downstreamType'] = value
    
    
    @property
    def downstreams(self) -> Union[None, List[str]]:
        """Downstream fields in the lineage"""
        return self._inner_dict.get('downstreams')  # type: ignore
    
    @downstreams.setter
    def downstreams(self, value: Union[None, List[str]]) -> None:
        self._inner_dict['downstreams'] = value
    
    
    @property
    def transformOperation(self) -> Union[None, str]:
        """The transform operation applied to the upstream entities to produce the downstream field(s)"""
        return self._inner_dict.get('transformOperation')  # type: ignore
    
    @transformOperation.setter
    def transformOperation(self, value: Union[None, str]) -> None:
        self._inner_dict['transformOperation'] = value
    
    
    @property
    def confidenceScore(self) -> float:
        """The confidence in this lineage between 0 (low confidence) and 1 (high confidence)"""
        return self._inner_dict.get('confidenceScore')  # type: ignore
    
    @confidenceScore.setter
    def confidenceScore(self, value: float) -> None:
        self._inner_dict['confidenceScore'] = value
    
    
    @property
    def query(self) -> Union[None, str]:
        """The query that was used to generate this lineage. 
    Present only if the lineage was generated from a detected query."""
        return self._inner_dict.get('query')  # type: ignore
    
    @query.setter
    def query(self, value: Union[None, str]) -> None:
        self._inner_dict['query'] = value
    
    
class FineGrainedLineageDownstreamTypeClass(object):
    """The type of downstream field(s) in a fine-grained lineage"""
    
    FIELD = "FIELD"
    """ Indicates that the lineage is for a single, specific, downstream field"""
    
    FIELD_SET = "FIELD_SET"
    """ Indicates that the lineage is for a set of downstream fields"""
    
    
    
class FineGrainedLineageUpstreamTypeClass(object):
    """The type of upstream entity in a fine-grained lineage"""
    
    FIELD_SET = "FIELD_SET"
    """ Indicates that this lineage is originating from upstream field(s)"""
    
    DATASET = "DATASET"
    """ Indicates that this lineage is originating from upstream dataset(s)"""
    
    NONE = "NONE"
    """ Indicates that there is no upstream lineage i.e. the downstream field is not a derived field"""
    
    
    
class HistogramClass(DictWrapper):
    # No docs available.
    
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.dataset.Histogram")
    def __init__(self,
        boundaries: List[str],
        heights: List[float],
    ):
        super().__init__()
        
        self.boundaries = boundaries
        self.heights = heights
    
    def _restore_defaults(self) -> None:
        self.boundaries = list()
        self.heights = list()
    
    
    @property
    def boundaries(self) -> List[str]:
        # No docs available.
        return self._inner_dict.get('boundaries')  # type: ignore
    
    @boundaries.setter
    def boundaries(self, value: List[str]) -> None:
        self._inner_dict['boundaries'] = value
    
    
    @property
    def heights(self) -> List[float]:
        # No docs available.
        return self._inner_dict.get('heights')  # type: ignore
    
    @heights.setter
    def heights(self, value: List[float]) -> None:
        self._inner_dict['heights'] = value
    
    
class QuantileClass(DictWrapper):
    # No docs available.
    
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.dataset.Quantile")
    def __init__(self,
        quantile: str,
        value: str,
    ):
        super().__init__()
        
        self.quantile = quantile
        self.value = value
    
    def _restore_defaults(self) -> None:
        self.quantile = str()
        self.value = str()
    
    
    @property
    def quantile(self) -> str:
        # No docs available.
        return self._inner_dict.get('quantile')  # type: ignore
    
    @quantile.setter
    def quantile(self, value: str) -> None:
        self._inner_dict['quantile'] = value
    
    
    @property
    def value(self) -> str:
        # No docs available.
        return self._inner_dict.get('value')  # type: ignore
    
    @value.setter
    def value(self, value: str) -> None:
        self._inner_dict['value'] = value
    
    
class UpstreamClass(DictWrapper):
    """Upstream lineage information about a dataset including the source reporting the lineage"""
    
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.dataset.Upstream")
    def __init__(self,
        dataset: str,
        type: Union[str, "DatasetLineageTypeClass"],
        auditStamp: Optional["AuditStampClass"]=None,
        created: Union[None, "AuditStampClass"]=None,
        properties: Union[None, Dict[str, str]]=None,
        query: Union[None, str]=None,
    ):
        super().__init__()
        
        if auditStamp is None:
            # default: {'actor': 'urn:li:corpuser:unknown', 'impersonator': None, 'time': 0, 'message': None}
            self.auditStamp = _json_converter.from_json_object(self.RECORD_SCHEMA.fields_dict["auditStamp"].default, writers_schema=self.RECORD_SCHEMA.fields_dict["auditStamp"].type)
        else:
            self.auditStamp = auditStamp
        self.created = created
        self.dataset = dataset
        self.type = type
        self.properties = properties
        self.query = query
    
    def _restore_defaults(self) -> None:
        self.auditStamp = _json_converter.from_json_object(self.RECORD_SCHEMA.fields_dict["auditStamp"].default, writers_schema=self.RECORD_SCHEMA.fields_dict["auditStamp"].type)
        self.created = self.RECORD_SCHEMA.fields_dict["created"].default
        self.dataset = str()
        self.type = DatasetLineageTypeClass.COPY
        self.properties = self.RECORD_SCHEMA.fields_dict["properties"].default
        self.query = self.RECORD_SCHEMA.fields_dict["query"].default
    
    
    @property
    def auditStamp(self) -> "AuditStampClass":
        """Audit stamp containing who reported the lineage and when."""
        return self._inner_dict.get('auditStamp')  # type: ignore
    
    @auditStamp.setter
    def auditStamp(self, value: "AuditStampClass") -> None:
        self._inner_dict['auditStamp'] = value
    
    
    @property
    def created(self) -> Union[None, "AuditStampClass"]:
        """Audit stamp containing who created the lineage and when."""
        return self._inner_dict.get('created')  # type: ignore
    
    @created.setter
    def created(self, value: Union[None, "AuditStampClass"]) -> None:
        self._inner_dict['created'] = value
    
    
    @property
    def dataset(self) -> str:
        """The upstream dataset the lineage points to"""
        return self._inner_dict.get('dataset')  # type: ignore
    
    @dataset.setter
    def dataset(self, value: str) -> None:
        self._inner_dict['dataset'] = value
    
    
    @property
    def type(self) -> Union[str, "DatasetLineageTypeClass"]:
        """The type of the lineage"""
        return self._inner_dict.get('type')  # type: ignore
    
    @type.setter
    def type(self, value: Union[str, "DatasetLineageTypeClass"]) -> None:
        self._inner_dict['type'] = value
    
    
    @property
    def properties(self) -> Union[None, Dict[str, str]]:
        """A generic properties bag that allows us to store specific information on this graph edge."""
        return self._inner_dict.get('properties')  # type: ignore
    
    @properties.setter
    def properties(self, value: Union[None, Dict[str, str]]) -> None:
        self._inner_dict['properties'] = value
    
    
    @property
    def query(self) -> Union[None, str]:
        """If the lineage is generated by a query, a reference to the query"""
        return self._inner_dict.get('query')  # type: ignore
    
    @query.setter
    def query(self, value: Union[None, str]) -> None:
        self._inner_dict['query'] = value
    
    
class UpstreamLineageClass(_Aspect):
    """Upstream lineage of a dataset"""


    ASPECT_NAME = 'upstreamLineage'
    ASPECT_INFO = {}
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.dataset.UpstreamLineage")

    def __init__(self,
        upstreams: List["UpstreamClass"],
        fineGrainedLineages: Union[None, List["FineGrainedLineageClass"]]=None,
    ):
        super().__init__()
        
        self.upstreams = upstreams
        self.fineGrainedLineages = fineGrainedLineages
    
    def _restore_defaults(self) -> None:
        self.upstreams = list()
        self.fineGrainedLineages = self.RECORD_SCHEMA.fields_dict["fineGrainedLineages"].default
    
    
    @property
    def upstreams(self) -> List["UpstreamClass"]:
        """List of upstream dataset lineage information"""
        return self._inner_dict.get('upstreams')  # type: ignore
    
    @upstreams.setter
    def upstreams(self, value: List["UpstreamClass"]) -> None:
        self._inner_dict['upstreams'] = value
    
    
    @property
    def fineGrainedLineages(self) -> Union[None, List["FineGrainedLineageClass"]]:
        """ List of fine-grained lineage information, including field-level lineage"""
        return self._inner_dict.get('fineGrainedLineages')  # type: ignore
    
    @fineGrainedLineages.setter
    def fineGrainedLineages(self, value: Union[None, List["FineGrainedLineageClass"]]) -> None:
        self._inner_dict['fineGrainedLineages'] = value
    
    
class ValueFrequencyClass(DictWrapper):
    # No docs available.
    
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.dataset.ValueFrequency")
    def __init__(self,
        value: str,
        frequency: int,
    ):
        super().__init__()
        
        self.value = value
        self.frequency = frequency
    
    def _restore_defaults(self) -> None:
        self.value = str()
        self.frequency = int()
    
    
    @property
    def value(self) -> str:
        # No docs available.
        return self._inner_dict.get('value')  # type: ignore
    
    @value.setter
    def value(self, value: str) -> None:
        self._inner_dict['value'] = value
    
    
    @property
    def frequency(self) -> int:
        # No docs available.
        return self._inner_dict.get('frequency')  # type: ignore
    
    @frequency.setter
    def frequency(self, value: int) -> None:
        self._inner_dict['frequency'] = value
    
    
class ViewPropertiesClass(_Aspect):
    """Details about a View. 
    e.g. Gets activated when subTypes is view"""


    ASPECT_NAME = 'viewProperties'
    ASPECT_INFO = {}
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.dataset.ViewProperties")

    def __init__(self,
        materialized: bool,
        viewLogic: str,
        viewLanguage: str,
        formattedViewLogic: Union[None, str]=None,
    ):
        super().__init__()
        
        self.materialized = materialized
        self.viewLogic = viewLogic
        self.formattedViewLogic = formattedViewLogic
        self.viewLanguage = viewLanguage
    
    def _restore_defaults(self) -> None:
        self.materialized = bool()
        self.viewLogic = str()
        self.formattedViewLogic = self.RECORD_SCHEMA.fields_dict["formattedViewLogic"].default
        self.viewLanguage = str()
    
    
    @property
    def materialized(self) -> bool:
        """Whether the view is materialized"""
        return self._inner_dict.get('materialized')  # type: ignore
    
    @materialized.setter
    def materialized(self, value: bool) -> None:
        self._inner_dict['materialized'] = value
    
    
    @property
    def viewLogic(self) -> str:
        """The view logic"""
        return self._inner_dict.get('viewLogic')  # type: ignore
    
    @viewLogic.setter
    def viewLogic(self, value: str) -> None:
        self._inner_dict['viewLogic'] = value
    
    
    @property
    def formattedViewLogic(self) -> Union[None, str]:
        """The formatted view logic. This is particularly used for SQL sources, where the SQL
    logic is formatted for better readability, and with dbt, where this contains the
    compiled SQL logic."""
        return self._inner_dict.get('formattedViewLogic')  # type: ignore
    
    @formattedViewLogic.setter
    def formattedViewLogic(self, value: Union[None, str]) -> None:
        self._inner_dict['formattedViewLogic'] = value
    
    
    @property
    def viewLanguage(self) -> str:
        """The view logic language / dialect"""
        return self._inner_dict.get('viewLanguage')  # type: ignore
    
    @viewLanguage.setter
    def viewLanguage(self, value: str) -> None:
        self._inner_dict['viewLanguage'] = value
    
    
class DataTypeInfoClass(_Aspect):
    # No docs available.


    ASPECT_NAME = 'dataTypeInfo'
    ASPECT_INFO = {}
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.datatype.DataTypeInfo")

    def __init__(self,
        qualifiedName: str,
        displayName: Union[None, str]=None,
        description: Union[None, str]=None,
    ):
        super().__init__()
        
        self.qualifiedName = qualifiedName
        self.displayName = displayName
        self.description = description
    
    def _restore_defaults(self) -> None:
        self.qualifiedName = str()
        self.displayName = self.RECORD_SCHEMA.fields_dict["displayName"].default
        self.description = self.RECORD_SCHEMA.fields_dict["description"].default
    
    
    @property
    def qualifiedName(self) -> str:
        """The qualified name for the data type. Usually a unique namespace + name, e.g. datahub.string"""
        return self._inner_dict.get('qualifiedName')  # type: ignore
    
    @qualifiedName.setter
    def qualifiedName(self, value: str) -> None:
        self._inner_dict['qualifiedName'] = value
    
    
    @property
    def displayName(self) -> Union[None, str]:
        """An optional display name for the data type."""
        return self._inner_dict.get('displayName')  # type: ignore
    
    @displayName.setter
    def displayName(self, value: Union[None, str]) -> None:
        self._inner_dict['displayName'] = value
    
    
    @property
    def description(self) -> Union[None, str]:
        """An optional description for the data type."""
        return self._inner_dict.get('description')  # type: ignore
    
    @description.setter
    def description(self, value: Union[None, str]) -> None:
        self._inner_dict['description'] = value
    
    
class DataTypeKeyClass(_Aspect):
    # No docs available.


    ASPECT_NAME = 'dataTypeKey'
    ASPECT_INFO = {'keyForEntity': 'dataType', 'entityCategory': 'core', 'entityAspects': ['dataTypeInfo', 'institutionalMemory', 'status'], 'entityDoc': 'A type of data element stored within DataHub.'}
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.datatype.DataTypeKey")

    def __init__(self,
        id: str,
    ):
        super().__init__()
        
        self.id = id
    
    def _restore_defaults(self) -> None:
        self.id = str()
    
    
    @property
    def id(self) -> str:
        """A unique id for a data type. Usually this will be a unique namespace + data type name."""
        return self._inner_dict.get('id')  # type: ignore
    
    @id.setter
    def id(self, value: str) -> None:
        self._inner_dict['id'] = value
    
    
class DomainPropertiesClass(_Aspect):
    """Information about a Domain"""


    ASPECT_NAME = 'domainProperties'
    ASPECT_INFO = {}
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.domain.DomainProperties")

    def __init__(self,
        name: str,
        description: Union[None, str]=None,
        created: Union[None, "AuditStampClass"]=None,
        parentDomain: Union[None, str]=None,
    ):
        super().__init__()
        
        self.name = name
        self.description = description
        self.created = created
        self.parentDomain = parentDomain
    
    def _restore_defaults(self) -> None:
        self.name = str()
        self.description = self.RECORD_SCHEMA.fields_dict["description"].default
        self.created = self.RECORD_SCHEMA.fields_dict["created"].default
        self.parentDomain = self.RECORD_SCHEMA.fields_dict["parentDomain"].default
    
    
    @property
    def name(self) -> str:
        """Display name of the Domain"""
        return self._inner_dict.get('name')  # type: ignore
    
    @name.setter
    def name(self, value: str) -> None:
        self._inner_dict['name'] = value
    
    
    @property
    def description(self) -> Union[None, str]:
        """Description of the Domain"""
        return self._inner_dict.get('description')  # type: ignore
    
    @description.setter
    def description(self, value: Union[None, str]) -> None:
        self._inner_dict['description'] = value
    
    
    @property
    def created(self) -> Union[None, "AuditStampClass"]:
        """Created Audit stamp"""
        return self._inner_dict.get('created')  # type: ignore
    
    @created.setter
    def created(self, value: Union[None, "AuditStampClass"]) -> None:
        self._inner_dict['created'] = value
    
    
    @property
    def parentDomain(self) -> Union[None, str]:
        """Optional: Parent of the domain"""
        return self._inner_dict.get('parentDomain')  # type: ignore
    
    @parentDomain.setter
    def parentDomain(self, value: Union[None, str]) -> None:
        self._inner_dict['parentDomain'] = value
    
    
class DomainsClass(_Aspect):
    """Links from an Asset to its Domains"""


    ASPECT_NAME = 'domains'
    ASPECT_INFO = {}
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.domain.Domains")

    def __init__(self,
        domains: List[str],
    ):
        super().__init__()
        
        self.domains = domains
    
    def _restore_defaults(self) -> None:
        self.domains = list()
    
    
    @property
    def domains(self) -> List[str]:
        """The Domains attached to an Asset"""
        return self._inner_dict.get('domains')  # type: ignore
    
    @domains.setter
    def domains(self, value: List[str]) -> None:
        self._inner_dict['domains'] = value
    
    
class EntityTypeInfoClass(_Aspect):
    # No docs available.


    ASPECT_NAME = 'entityTypeInfo'
    ASPECT_INFO = {}
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.entitytype.EntityTypeInfo")

    def __init__(self,
        qualifiedName: str,
        displayName: Union[None, str]=None,
        description: Union[None, str]=None,
    ):
        super().__init__()
        
        self.qualifiedName = qualifiedName
        self.displayName = displayName
        self.description = description
    
    def _restore_defaults(self) -> None:
        self.qualifiedName = str()
        self.displayName = self.RECORD_SCHEMA.fields_dict["displayName"].default
        self.description = self.RECORD_SCHEMA.fields_dict["description"].default
    
    
    @property
    def qualifiedName(self) -> str:
        """The fully qualified name for the entity type, which usually consists of a namespace
    plus an identifier or name, e.g. datahub.dataset"""
        return self._inner_dict.get('qualifiedName')  # type: ignore
    
    @qualifiedName.setter
    def qualifiedName(self, value: str) -> None:
        self._inner_dict['qualifiedName'] = value
    
    
    @property
    def displayName(self) -> Union[None, str]:
        """The display name for the Entity Type."""
        return self._inner_dict.get('displayName')  # type: ignore
    
    @displayName.setter
    def displayName(self, value: Union[None, str]) -> None:
        self._inner_dict['displayName'] = value
    
    
    @property
    def description(self) -> Union[None, str]:
        """A description for the Entity Type: what is it for?"""
        return self._inner_dict.get('description')  # type: ignore
    
    @description.setter
    def description(self, value: Union[None, str]) -> None:
        self._inner_dict['description'] = value
    
    
class EntityTypeKeyClass(_Aspect):
    # No docs available.


    ASPECT_NAME = 'entityTypeKey'
    ASPECT_INFO = {'keyForEntity': 'entityType', 'entityCategory': 'core', 'entityAspects': ['entityTypeInfo', 'institutionalMemory', 'status'], 'entityDoc': 'A type of entity in the DataHub Metadata Model.'}
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.entitytype.EntityTypeKey")

    def __init__(self,
        id: str,
    ):
        super().__init__()
        
        self.id = id
    
    def _restore_defaults(self) -> None:
        self.id = str()
    
    
    @property
    def id(self) -> str:
        """A unique id for an entity type. Usually this will be a unique namespace + entity name."""
        return self._inner_dict.get('id')  # type: ignore
    
    @id.setter
    def id(self, value: str) -> None:
        self._inner_dict['id'] = value
    
    
class ChangeTypeClass(object):
    """Descriptor for a change action"""
    
    UPSERT = "UPSERT"
    """insert if not exists. otherwise update"""
    
    CREATE = "CREATE"
    """NOT SUPPORTED YET
    insert if not exists. otherwise fail"""
    
    UPDATE = "UPDATE"
    """NOT SUPPORTED YET
    update if exists. otherwise fail"""
    
    DELETE = "DELETE"
    """NOT SUPPORTED YET
    delete action"""
    
    PATCH = "PATCH"
    """NOT SUPPORTED YET
    patch the changes instead of full replace"""
    
    RESTATE = "RESTATE"
    """Restate an aspect, eg. in a index refresh."""
    
    
    
class ExecutionRequestInputClass(_Aspect):
    """An request to execution some remote logic or action.
    TODO: Determine who is responsible for emitting execution request success or failure. Executor?"""


    ASPECT_NAME = 'dataHubExecutionRequestInput'
    ASPECT_INFO = {}
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.execution.ExecutionRequestInput")

    def __init__(self,
        task: str,
        args: Dict[str, str],
        executorId: str,
        source: "ExecutionRequestSourceClass",
        requestedAt: int,
    ):
        super().__init__()
        
        self.task = task
        self.args = args
        self.executorId = executorId
        self.source = source
        self.requestedAt = requestedAt
    
    def _restore_defaults(self) -> None:
        self.task = str()
        self.args = dict()
        self.executorId = str()
        self.source = ExecutionRequestSourceClass._construct_with_defaults()
        self.requestedAt = int()
    
    
    @property
    def task(self) -> str:
        """The name of the task to execute, for example RUN_INGEST"""
        return self._inner_dict.get('task')  # type: ignore
    
    @task.setter
    def task(self, value: str) -> None:
        self._inner_dict['task'] = value
    
    
    @property
    def args(self) -> Dict[str, str]:
        """Arguments provided to the task"""
        return self._inner_dict.get('args')  # type: ignore
    
    @args.setter
    def args(self, value: Dict[str, str]) -> None:
        self._inner_dict['args'] = value
    
    
    @property
    def executorId(self) -> str:
        """Advanced: specify a specific executor to route the request to. If none is provided, a "default" executor is used."""
        return self._inner_dict.get('executorId')  # type: ignore
    
    @executorId.setter
    def executorId(self, value: str) -> None:
        self._inner_dict['executorId'] = value
    
    
    @property
    def source(self) -> "ExecutionRequestSourceClass":
        """Source which created the execution request"""
        return self._inner_dict.get('source')  # type: ignore
    
    @source.setter
    def source(self, value: "ExecutionRequestSourceClass") -> None:
        self._inner_dict['source'] = value
    
    
    @property
    def requestedAt(self) -> int:
        """Time at which the execution request input was created"""
        return self._inner_dict.get('requestedAt')  # type: ignore
    
    @requestedAt.setter
    def requestedAt(self, value: int) -> None:
        self._inner_dict['requestedAt'] = value
    
    
class ExecutionRequestResultClass(_Aspect):
    """The result of an execution request"""


    ASPECT_NAME = 'dataHubExecutionRequestResult'
    ASPECT_INFO = {}
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.execution.ExecutionRequestResult")

    def __init__(self,
        status: str,
        report: Union[None, str]=None,
        structuredReport: Union[None, "StructuredExecutionReportClass"]=None,
        startTimeMs: Union[None, int]=None,
        durationMs: Union[None, int]=None,
    ):
        super().__init__()
        
        self.status = status
        self.report = report
        self.structuredReport = structuredReport
        self.startTimeMs = startTimeMs
        self.durationMs = durationMs
    
    def _restore_defaults(self) -> None:
        self.status = str()
        self.report = self.RECORD_SCHEMA.fields_dict["report"].default
        self.structuredReport = self.RECORD_SCHEMA.fields_dict["structuredReport"].default
        self.startTimeMs = self.RECORD_SCHEMA.fields_dict["startTimeMs"].default
        self.durationMs = self.RECORD_SCHEMA.fields_dict["durationMs"].default
    
    
    @property
    def status(self) -> str:
        """The status of the execution request"""
        return self._inner_dict.get('status')  # type: ignore
    
    @status.setter
    def status(self, value: str) -> None:
        self._inner_dict['status'] = value
    
    
    @property
    def report(self) -> Union[None, str]:
        """The pretty-printed execution report."""
        return self._inner_dict.get('report')  # type: ignore
    
    @report.setter
    def report(self, value: Union[None, str]) -> None:
        self._inner_dict['report'] = value
    
    
    @property
    def structuredReport(self) -> Union[None, "StructuredExecutionReportClass"]:
        """A structured report if available."""
        return self._inner_dict.get('structuredReport')  # type: ignore
    
    @structuredReport.setter
    def structuredReport(self, value: Union[None, "StructuredExecutionReportClass"]) -> None:
        self._inner_dict['structuredReport'] = value
    
    
    @property
    def startTimeMs(self) -> Union[None, int]:
        """Time at which the request was created"""
        return self._inner_dict.get('startTimeMs')  # type: ignore
    
    @startTimeMs.setter
    def startTimeMs(self, value: Union[None, int]) -> None:
        self._inner_dict['startTimeMs'] = value
    
    
    @property
    def durationMs(self) -> Union[None, int]:
        """Duration in milliseconds"""
        return self._inner_dict.get('durationMs')  # type: ignore
    
    @durationMs.setter
    def durationMs(self, value: Union[None, int]) -> None:
        self._inner_dict['durationMs'] = value
    
    
class ExecutionRequestSignalClass(_Aspect):
    """An signal sent to a running execution request"""


    ASPECT_NAME = 'dataHubExecutionRequestSignal'
    ASPECT_INFO = {}
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.execution.ExecutionRequestSignal")

    def __init__(self,
        signal: str,
        createdAt: "AuditStampClass",
        executorId: Union[None, str]=None,
    ):
        super().__init__()
        
        self.signal = signal
        self.executorId = executorId
        self.createdAt = createdAt
    
    def _restore_defaults(self) -> None:
        self.signal = str()
        self.executorId = self.RECORD_SCHEMA.fields_dict["executorId"].default
        self.createdAt = AuditStampClass._construct_with_defaults()
    
    
    @property
    def signal(self) -> str:
        """The signal to issue, e.g. KILL"""
        return self._inner_dict.get('signal')  # type: ignore
    
    @signal.setter
    def signal(self, value: str) -> None:
        self._inner_dict['signal'] = value
    
    
    @property
    def executorId(self) -> Union[None, str]:
        """Advanced: specify a specific executor to route the request to. If none is provided, a "default" executor is used."""
        return self._inner_dict.get('executorId')  # type: ignore
    
    @executorId.setter
    def executorId(self, value: Union[None, str]) -> None:
        self._inner_dict['executorId'] = value
    
    
    @property
    def createdAt(self) -> "AuditStampClass":
        """Audit Stamp"""
        return self._inner_dict.get('createdAt')  # type: ignore
    
    @createdAt.setter
    def createdAt(self, value: "AuditStampClass") -> None:
        self._inner_dict['createdAt'] = value
    
    
class ExecutionRequestSourceClass(DictWrapper):
    # No docs available.
    
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.execution.ExecutionRequestSource")
    def __init__(self,
        type: str,
        ingestionSource: Union[None, str]=None,
    ):
        super().__init__()
        
        self.type = type
        self.ingestionSource = ingestionSource
    
    def _restore_defaults(self) -> None:
        self.type = str()
        self.ingestionSource = self.RECORD_SCHEMA.fields_dict["ingestionSource"].default
    
    
    @property
    def type(self) -> str:
        """The type of the execution request source, e.g. INGESTION_SOURCE"""
        return self._inner_dict.get('type')  # type: ignore
    
    @type.setter
    def type(self, value: str) -> None:
        self._inner_dict['type'] = value
    
    
    @property
    def ingestionSource(self) -> Union[None, str]:
        """The urn of the ingestion source associated with the ingestion request. Present if type is INGESTION_SOURCE"""
        return self._inner_dict.get('ingestionSource')  # type: ignore
    
    @ingestionSource.setter
    def ingestionSource(self, value: Union[None, str]) -> None:
        self._inner_dict['ingestionSource'] = value
    
    
class StructuredExecutionReportClass(DictWrapper):
    """A flexible carrier for structured results of an execution request.
    The goal is to allow for free flow of structured responses from execution tasks to the orchestrator or observer.
    The full spectrum of different execution report types is not intended to be modeled by this object."""
    
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.execution.StructuredExecutionReport")
    def __init__(self,
        type: str,
        serializedValue: str,
        contentType: str,
    ):
        super().__init__()
        
        self.type = type
        self.serializedValue = serializedValue
        self.contentType = contentType
    
    def _restore_defaults(self) -> None:
        self.type = str()
        self.serializedValue = str()
        self.contentType = str()
    
    
    @property
    def type(self) -> str:
        """The type of the structured report. (e.g. INGESTION_REPORT, TEST_CONNECTION_REPORT, etc.)"""
        return self._inner_dict.get('type')  # type: ignore
    
    @type.setter
    def type(self, value: str) -> None:
        self._inner_dict['type'] = value
    
    
    @property
    def serializedValue(self) -> str:
        """The serialized value of the structured report"""
        return self._inner_dict.get('serializedValue')  # type: ignore
    
    @serializedValue.setter
    def serializedValue(self, value: str) -> None:
        self._inner_dict['serializedValue'] = value
    
    
    @property
    def contentType(self) -> str:
        """The content-type of the serialized value (e.g. application/json, application/json;gzip etc.)"""
        return self._inner_dict.get('contentType')  # type: ignore
    
    @contentType.setter
    def contentType(self, value: str) -> None:
        self._inner_dict['contentType'] = value
    
    
class DynamicFormAssignmentClass(_Aspect):
    """Information about how a form is assigned to entities dynamically. Provide a filter to
    match a set of entities instead of explicitly applying a form to specific entities."""


    ASPECT_NAME = 'dynamicFormAssignment'
    ASPECT_INFO = {}
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.form.DynamicFormAssignment")

    def __init__(self,
        filter: "FilterClass",
    ):
        super().__init__()
        
        self.filter = filter
    
    def _restore_defaults(self) -> None:
        self.filter = FilterClass._construct_with_defaults()
    
    
    @property
    def filter(self) -> "FilterClass":
        """The filter applied when assigning this form to entities. Entities that match this filter
    will have this form applied to them. Right now this filter only supports filtering by
    platform, entity type, container, and domain through the UI."""
        return self._inner_dict.get('filter')  # type: ignore
    
    @filter.setter
    def filter(self, value: "FilterClass") -> None:
        self._inner_dict['filter'] = value
    
    
class FormActorAssignmentClass(DictWrapper):
    # No docs available.
    
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.form.FormActorAssignment")
    def __init__(self,
        owners: Optional[bool]=None,
        groups: Union[None, List[str]]=None,
        users: Union[None, List[str]]=None,
    ):
        super().__init__()
        
        if owners is None:
            # default: True
            self.owners = self.RECORD_SCHEMA.fields_dict["owners"].default
        else:
            self.owners = owners
        self.groups = groups
        self.users = users
    
    def _restore_defaults(self) -> None:
        self.owners = self.RECORD_SCHEMA.fields_dict["owners"].default
        self.groups = self.RECORD_SCHEMA.fields_dict["groups"].default
        self.users = self.RECORD_SCHEMA.fields_dict["users"].default
    
    
    @property
    def owners(self) -> bool:
        """Whether the form should be assigned to the owners of assets that it is applied to.
    This is the default."""
        return self._inner_dict.get('owners')  # type: ignore
    
    @owners.setter
    def owners(self, value: bool) -> None:
        self._inner_dict['owners'] = value
    
    
    @property
    def groups(self) -> Union[None, List[str]]:
        """Optional: Specific set of groups that are targeted by this form assignment."""
        return self._inner_dict.get('groups')  # type: ignore
    
    @groups.setter
    def groups(self, value: Union[None, List[str]]) -> None:
        self._inner_dict['groups'] = value
    
    
    @property
    def users(self) -> Union[None, List[str]]:
        """Optional: Specific set of users that are targeted by this form assignment."""
        return self._inner_dict.get('users')  # type: ignore
    
    @users.setter
    def users(self, value: Union[None, List[str]]) -> None:
        self._inner_dict['users'] = value
    
    
class FormInfoClass(_Aspect):
    """Information about a form to help with filling out metadata on entities."""


    ASPECT_NAME = 'formInfo'
    ASPECT_INFO = {}
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.form.FormInfo")

    def __init__(self,
        name: str,
        description: Union[None, str]=None,
        type: Optional[Union[str, "FormTypeClass"]]=None,
        prompts: Optional[List["FormPromptClass"]]=None,
        actors: Optional["FormActorAssignmentClass"]=None,
    ):
        super().__init__()
        
        self.name = name
        self.description = description
        if type is None:
            # default: 'COMPLETION'
            self.type = self.RECORD_SCHEMA.fields_dict["type"].default
        else:
            self.type = type
        if prompts is None:
            # default: []
            self.prompts = list()
        else:
            self.prompts = prompts
        if actors is None:
            # default: {'groups': None, 'owners': True, 'users': None}
            self.actors = _json_converter.from_json_object(self.RECORD_SCHEMA.fields_dict["actors"].default, writers_schema=self.RECORD_SCHEMA.fields_dict["actors"].type)
        else:
            self.actors = actors
    
    def _restore_defaults(self) -> None:
        self.name = str()
        self.description = self.RECORD_SCHEMA.fields_dict["description"].default
        self.type = self.RECORD_SCHEMA.fields_dict["type"].default
        self.prompts = list()
        self.actors = _json_converter.from_json_object(self.RECORD_SCHEMA.fields_dict["actors"].default, writers_schema=self.RECORD_SCHEMA.fields_dict["actors"].type)
    
    
    @property
    def name(self) -> str:
        """Display name of the form"""
        return self._inner_dict.get('name')  # type: ignore
    
    @name.setter
    def name(self, value: str) -> None:
        self._inner_dict['name'] = value
    
    
    @property
    def description(self) -> Union[None, str]:
        """Description of the form"""
        return self._inner_dict.get('description')  # type: ignore
    
    @description.setter
    def description(self, value: Union[None, str]) -> None:
        self._inner_dict['description'] = value
    
    
    @property
    def type(self) -> Union[str, "FormTypeClass"]:
        """The type of this form"""
        return self._inner_dict.get('type')  # type: ignore
    
    @type.setter
    def type(self, value: Union[str, "FormTypeClass"]) -> None:
        self._inner_dict['type'] = value
    
    
    @property
    def prompts(self) -> List["FormPromptClass"]:
        """List of prompts to present to the user to encourage filling out metadata"""
        return self._inner_dict.get('prompts')  # type: ignore
    
    @prompts.setter
    def prompts(self, value: List["FormPromptClass"]) -> None:
        self._inner_dict['prompts'] = value
    
    
    @property
    def actors(self) -> "FormActorAssignmentClass":
        """Who the form is assigned to, e.g. who should see the form when visiting the entity page or governance center"""
        return self._inner_dict.get('actors')  # type: ignore
    
    @actors.setter
    def actors(self, value: "FormActorAssignmentClass") -> None:
        self._inner_dict['actors'] = value
    
    
class FormPromptClass(DictWrapper):
    """A prompt to present to the user to encourage filling out metadata"""
    
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.form.FormPrompt")
    def __init__(self,
        id: str,
        title: str,
        type: Union[str, "FormPromptTypeClass"],
        description: Union[None, str]=None,
        structuredPropertyParams: Union[None, "StructuredPropertyParamsClass"]=None,
        required: Optional[bool]=None,
    ):
        super().__init__()
        
        self.id = id
        self.title = title
        self.description = description
        self.type = type
        self.structuredPropertyParams = structuredPropertyParams
        if required is None:
            # default: False
            self.required = self.RECORD_SCHEMA.fields_dict["required"].default
        else:
            self.required = required
    
    def _restore_defaults(self) -> None:
        self.id = str()
        self.title = str()
        self.description = self.RECORD_SCHEMA.fields_dict["description"].default
        self.type = FormPromptTypeClass.STRUCTURED_PROPERTY
        self.structuredPropertyParams = self.RECORD_SCHEMA.fields_dict["structuredPropertyParams"].default
        self.required = self.RECORD_SCHEMA.fields_dict["required"].default
    
    
    @property
    def id(self) -> str:
        """The unique id for this prompt. This must be GLOBALLY unique."""
        return self._inner_dict.get('id')  # type: ignore
    
    @id.setter
    def id(self, value: str) -> None:
        self._inner_dict['id'] = value
    
    
    @property
    def title(self) -> str:
        """The title of this prompt"""
        return self._inner_dict.get('title')  # type: ignore
    
    @title.setter
    def title(self, value: str) -> None:
        self._inner_dict['title'] = value
    
    
    @property
    def description(self) -> Union[None, str]:
        """The description of this prompt"""
        return self._inner_dict.get('description')  # type: ignore
    
    @description.setter
    def description(self, value: Union[None, str]) -> None:
        self._inner_dict['description'] = value
    
    
    @property
    def type(self) -> Union[str, "FormPromptTypeClass"]:
        """The type of prompt"""
        return self._inner_dict.get('type')  # type: ignore
    
    @type.setter
    def type(self, value: Union[str, "FormPromptTypeClass"]) -> None:
        self._inner_dict['type'] = value
    
    
    @property
    def structuredPropertyParams(self) -> Union[None, "StructuredPropertyParamsClass"]:
        """An optional set of information specific to structured properties prompts.
    This should be filled out if the prompt is type STRUCTURED_PROPERTY or FIELDS_STRUCTURED_PROPERTY."""
        return self._inner_dict.get('structuredPropertyParams')  # type: ignore
    
    @structuredPropertyParams.setter
    def structuredPropertyParams(self, value: Union[None, "StructuredPropertyParamsClass"]) -> None:
        self._inner_dict['structuredPropertyParams'] = value
    
    
    @property
    def required(self) -> bool:
        """Whether the prompt is required to be completed, in order for the form to be marked as complete."""
        return self._inner_dict.get('required')  # type: ignore
    
    @required.setter
    def required(self, value: bool) -> None:
        self._inner_dict['required'] = value
    
    
class FormPromptTypeClass(object):
    # No docs available.
    
    STRUCTURED_PROPERTY = "STRUCTURED_PROPERTY"
    """This prompt is meant to apply a structured property to an entity"""
    
    FIELDS_STRUCTURED_PROPERTY = "FIELDS_STRUCTURED_PROPERTY"
    """This prompt is meant to apply a structured property to a schema fields entity"""
    
    
    
class FormTypeClass(object):
    # No docs available.
    
    COMPLETION = "COMPLETION"
    """A form simply used for collecting metadata fields for an entity."""
    
    VERIFICATION = "VERIFICATION"
    """This form is used for "verifying" that entities comply with a policy via presence of a specific set of metadata fields."""
    
    
    
class StructuredPropertyParamsClass(DictWrapper):
    # No docs available.
    
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.form.StructuredPropertyParams")
    def __init__(self,
        urn: str,
    ):
        super().__init__()
        
        self.urn = urn
    
    def _restore_defaults(self) -> None:
        self.urn = str()
    
    
    @property
    def urn(self) -> str:
        """The structured property that is required on this entity"""
        return self._inner_dict.get('urn')  # type: ignore
    
    @urn.setter
    def urn(self, value: str) -> None:
        self._inner_dict['urn'] = value
    
    
class GlossaryNodeInfoClass(_Aspect):
    """Properties associated with a GlossaryNode"""


    ASPECT_NAME = 'glossaryNodeInfo'
    ASPECT_INFO = {}
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.glossary.GlossaryNodeInfo")

    def __init__(self,
        definition: str,
        customProperties: Optional[Dict[str, str]]=None,
        parentNode: Union[None, str]=None,
        name: Union[None, str]=None,
        id: Union[None, str]=None,
    ):
        super().__init__()
        
        if customProperties is None:
            # default: {}
            self.customProperties = dict()
        else:
            self.customProperties = customProperties
        self.definition = definition
        self.parentNode = parentNode
        self.name = name
        self.id = id
    
    def _restore_defaults(self) -> None:
        self.customProperties = dict()
        self.definition = str()
        self.parentNode = self.RECORD_SCHEMA.fields_dict["parentNode"].default
        self.name = self.RECORD_SCHEMA.fields_dict["name"].default
        self.id = self.RECORD_SCHEMA.fields_dict["id"].default
    
    
    @property
    def customProperties(self) -> Dict[str, str]:
        """Custom property bag."""
        return self._inner_dict.get('customProperties')  # type: ignore
    
    @customProperties.setter
    def customProperties(self, value: Dict[str, str]) -> None:
        self._inner_dict['customProperties'] = value
    
    
    @property
    def definition(self) -> str:
        """Definition of business node"""
        return self._inner_dict.get('definition')  # type: ignore
    
    @definition.setter
    def definition(self, value: str) -> None:
        self._inner_dict['definition'] = value
    
    
    @property
    def parentNode(self) -> Union[None, str]:
        """Parent node of the glossary term"""
        return self._inner_dict.get('parentNode')  # type: ignore
    
    @parentNode.setter
    def parentNode(self, value: Union[None, str]) -> None:
        self._inner_dict['parentNode'] = value
    
    
    @property
    def name(self) -> Union[None, str]:
        """Display name of the node"""
        return self._inner_dict.get('name')  # type: ignore
    
    @name.setter
    def name(self, value: Union[None, str]) -> None:
        self._inner_dict['name'] = value
    
    
    @property
    def id(self) -> Union[None, str]:
        """Optional id for the GlossaryNode"""
        return self._inner_dict.get('id')  # type: ignore
    
    @id.setter
    def id(self, value: Union[None, str]) -> None:
        self._inner_dict['id'] = value
    
    
class GlossaryRelatedTermsClass(_Aspect):
    """Has A / Is A lineage information about a glossary Term reporting the lineage"""


    ASPECT_NAME = 'glossaryRelatedTerms'
    ASPECT_INFO = {}
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.glossary.GlossaryRelatedTerms")

    def __init__(self,
        isRelatedTerms: Union[None, List[str]]=None,
        hasRelatedTerms: Union[None, List[str]]=None,
        values: Union[None, List[str]]=None,
        relatedTerms: Union[None, List[str]]=None,
    ):
        super().__init__()
        
        self.isRelatedTerms = isRelatedTerms
        self.hasRelatedTerms = hasRelatedTerms
        self.values = values
        self.relatedTerms = relatedTerms
    
    def _restore_defaults(self) -> None:
        self.isRelatedTerms = self.RECORD_SCHEMA.fields_dict["isRelatedTerms"].default
        self.hasRelatedTerms = self.RECORD_SCHEMA.fields_dict["hasRelatedTerms"].default
        self.values = self.RECORD_SCHEMA.fields_dict["values"].default
        self.relatedTerms = self.RECORD_SCHEMA.fields_dict["relatedTerms"].default
    
    
    @property
    def isRelatedTerms(self) -> Union[None, List[str]]:
        """The relationship Is A with glossary term"""
        return self._inner_dict.get('isRelatedTerms')  # type: ignore
    
    @isRelatedTerms.setter
    def isRelatedTerms(self, value: Union[None, List[str]]) -> None:
        self._inner_dict['isRelatedTerms'] = value
    
    
    @property
    def hasRelatedTerms(self) -> Union[None, List[str]]:
        """The relationship Has A with glossary term"""
        return self._inner_dict.get('hasRelatedTerms')  # type: ignore
    
    @hasRelatedTerms.setter
    def hasRelatedTerms(self, value: Union[None, List[str]]) -> None:
        self._inner_dict['hasRelatedTerms'] = value
    
    
    @property
    def values(self) -> Union[None, List[str]]:
        """The relationship Has Value with glossary term.
    These are fixed value a term has. For example a ColorEnum where RED, GREEN and YELLOW are fixed values."""
        return self._inner_dict.get('values')  # type: ignore
    
    @values.setter
    def values(self, value: Union[None, List[str]]) -> None:
        self._inner_dict['values'] = value
    
    
    @property
    def relatedTerms(self) -> Union[None, List[str]]:
        """The relationship isRelatedTo with glossary term"""
        return self._inner_dict.get('relatedTerms')  # type: ignore
    
    @relatedTerms.setter
    def relatedTerms(self, value: Union[None, List[str]]) -> None:
        self._inner_dict['relatedTerms'] = value
    
    
class GlossaryTermInfoClass(_Aspect):
    """Properties associated with a GlossaryTerm"""


    ASPECT_NAME = 'glossaryTermInfo'
    ASPECT_INFO = {}
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.glossary.GlossaryTermInfo")

    def __init__(self,
        definition: str,
        termSource: str,
        customProperties: Optional[Dict[str, str]]=None,
        id: Union[None, str]=None,
        name: Union[None, str]=None,
        parentNode: Union[None, str]=None,
        sourceRef: Union[None, str]=None,
        sourceUrl: Union[None, str]=None,
        rawSchema: Union[None, str]=None,
    ):
        super().__init__()
        
        if customProperties is None:
            # default: {}
            self.customProperties = dict()
        else:
            self.customProperties = customProperties
        self.id = id
        self.name = name
        self.definition = definition
        self.parentNode = parentNode
        self.termSource = termSource
        self.sourceRef = sourceRef
        self.sourceUrl = sourceUrl
        self.rawSchema = rawSchema
    
    def _restore_defaults(self) -> None:
        self.customProperties = dict()
        self.id = self.RECORD_SCHEMA.fields_dict["id"].default
        self.name = self.RECORD_SCHEMA.fields_dict["name"].default
        self.definition = str()
        self.parentNode = self.RECORD_SCHEMA.fields_dict["parentNode"].default
        self.termSource = str()
        self.sourceRef = self.RECORD_SCHEMA.fields_dict["sourceRef"].default
        self.sourceUrl = self.RECORD_SCHEMA.fields_dict["sourceUrl"].default
        self.rawSchema = self.RECORD_SCHEMA.fields_dict["rawSchema"].default
    
    
    @property
    def customProperties(self) -> Dict[str, str]:
        """Custom property bag."""
        return self._inner_dict.get('customProperties')  # type: ignore
    
    @customProperties.setter
    def customProperties(self, value: Dict[str, str]) -> None:
        self._inner_dict['customProperties'] = value
    
    
    @property
    def id(self) -> Union[None, str]:
        """Optional id for the term"""
        return self._inner_dict.get('id')  # type: ignore
    
    @id.setter
    def id(self, value: Union[None, str]) -> None:
        self._inner_dict['id'] = value
    
    
    @property
    def name(self) -> Union[None, str]:
        """Display name of the term"""
        return self._inner_dict.get('name')  # type: ignore
    
    @name.setter
    def name(self, value: Union[None, str]) -> None:
        self._inner_dict['name'] = value
    
    
    @property
    def definition(self) -> str:
        """Definition of business term."""
        return self._inner_dict.get('definition')  # type: ignore
    
    @definition.setter
    def definition(self, value: str) -> None:
        self._inner_dict['definition'] = value
    
    
    @property
    def parentNode(self) -> Union[None, str]:
        """Parent node of the glossary term"""
        return self._inner_dict.get('parentNode')  # type: ignore
    
    @parentNode.setter
    def parentNode(self, value: Union[None, str]) -> None:
        self._inner_dict['parentNode'] = value
    
    
    @property
    def termSource(self) -> str:
        """Source of the Business Term (INTERNAL or EXTERNAL) with default value as INTERNAL"""
        return self._inner_dict.get('termSource')  # type: ignore
    
    @termSource.setter
    def termSource(self, value: str) -> None:
        self._inner_dict['termSource'] = value
    
    
    @property
    def sourceRef(self) -> Union[None, str]:
        """External Reference to the business-term"""
        return self._inner_dict.get('sourceRef')  # type: ignore
    
    @sourceRef.setter
    def sourceRef(self, value: Union[None, str]) -> None:
        self._inner_dict['sourceRef'] = value
    
    
    @property
    def sourceUrl(self) -> Union[None, str]:
        """The abstracted URL such as https://spec.edmcouncil.org/fibo/ontology/FBC/FinancialInstruments/FinancialInstruments/CashInstrument."""
        return self._inner_dict.get('sourceUrl')  # type: ignore
    
    @sourceUrl.setter
    def sourceUrl(self, value: Union[None, str]) -> None:
        self._inner_dict['sourceUrl'] = value
    
    
    @property
    def rawSchema(self) -> Union[None, str]:
        """Schema definition of the glossary term"""
        return self._inner_dict.get('rawSchema')  # type: ignore
    
    @rawSchema.setter
    def rawSchema(self, value: Union[None, str]) -> None:
        self._inner_dict['rawSchema'] = value
    
    
class CorpGroupEditableInfoClass(_Aspect):
    """Group information that can be edited from UI"""


    ASPECT_NAME = 'corpGroupEditableInfo'
    ASPECT_INFO = {}
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.identity.CorpGroupEditableInfo")

    def __init__(self,
        description: Union[None, str]=None,
        pictureLink: Optional[str]=None,
        slack: Union[None, str]=None,
        email: Union[None, str]=None,
    ):
        super().__init__()
        
        self.description = description
        if pictureLink is None:
            # default: 'https://raw.githubusercontent.com/datahub-project/datahub/master/datahub-web-react/src/images/default_avatar.png'
            self.pictureLink = self.RECORD_SCHEMA.fields_dict["pictureLink"].default
        else:
            self.pictureLink = pictureLink
        self.slack = slack
        self.email = email
    
    def _restore_defaults(self) -> None:
        self.description = self.RECORD_SCHEMA.fields_dict["description"].default
        self.pictureLink = self.RECORD_SCHEMA.fields_dict["pictureLink"].default
        self.slack = self.RECORD_SCHEMA.fields_dict["slack"].default
        self.email = self.RECORD_SCHEMA.fields_dict["email"].default
    
    
    @property
    def description(self) -> Union[None, str]:
        """A description of the group"""
        return self._inner_dict.get('description')  # type: ignore
    
    @description.setter
    def description(self, value: Union[None, str]) -> None:
        self._inner_dict['description'] = value
    
    
    @property
    def pictureLink(self) -> str:
        """A URL which points to a picture which user wants to set as the photo for the group"""
        return self._inner_dict.get('pictureLink')  # type: ignore
    
    @pictureLink.setter
    def pictureLink(self, value: str) -> None:
        self._inner_dict['pictureLink'] = value
    
    
    @property
    def slack(self) -> Union[None, str]:
        """Slack channel for the group"""
        return self._inner_dict.get('slack')  # type: ignore
    
    @slack.setter
    def slack(self, value: Union[None, str]) -> None:
        self._inner_dict['slack'] = value
    
    
    @property
    def email(self) -> Union[None, str]:
        """Email address to contact the group"""
        return self._inner_dict.get('email')  # type: ignore
    
    @email.setter
    def email(self, value: Union[None, str]) -> None:
        self._inner_dict['email'] = value
    
    
class CorpGroupInfoClass(_Aspect):
    """Information about a Corp Group ingested from a third party source"""


    ASPECT_NAME = 'corpGroupInfo'
    ASPECT_INFO = {'EntityUrns': ['com.linkedin.pegasus2avro.common.CorpGroupUrn']}
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.identity.CorpGroupInfo")

    def __init__(self,
        admins: List[str],
        members: List[str],
        groups: List[str],
        displayName: Union[None, str]=None,
        email: Union[None, str]=None,
        description: Union[None, str]=None,
        slack: Union[None, str]=None,
        created: Union[None, "AuditStampClass"]=None,
    ):
        super().__init__()
        
        self.displayName = displayName
        self.email = email
        self.admins = admins
        self.members = members
        self.groups = groups
        self.description = description
        self.slack = slack
        self.created = created
    
    def _restore_defaults(self) -> None:
        self.displayName = self.RECORD_SCHEMA.fields_dict["displayName"].default
        self.email = self.RECORD_SCHEMA.fields_dict["email"].default
        self.admins = list()
        self.members = list()
        self.groups = list()
        self.description = self.RECORD_SCHEMA.fields_dict["description"].default
        self.slack = self.RECORD_SCHEMA.fields_dict["slack"].default
        self.created = self.RECORD_SCHEMA.fields_dict["created"].default
    
    
    @property
    def displayName(self) -> Union[None, str]:
        """The name of the group."""
        return self._inner_dict.get('displayName')  # type: ignore
    
    @displayName.setter
    def displayName(self, value: Union[None, str]) -> None:
        self._inner_dict['displayName'] = value
    
    
    @property
    def email(self) -> Union[None, str]:
        """email of this group"""
        return self._inner_dict.get('email')  # type: ignore
    
    @email.setter
    def email(self, value: Union[None, str]) -> None:
        self._inner_dict['email'] = value
    
    
    @property
    def admins(self) -> List[str]:
        """owners of this group
    Deprecated! Replaced by Ownership aspect."""
        return self._inner_dict.get('admins')  # type: ignore
    
    @admins.setter
    def admins(self, value: List[str]) -> None:
        self._inner_dict['admins'] = value
    
    
    @property
    def members(self) -> List[str]:
        """List of ldap urn in this group.
    Deprecated! Replaced by GroupMembership aspect."""
        return self._inner_dict.get('members')  # type: ignore
    
    @members.setter
    def members(self, value: List[str]) -> None:
        self._inner_dict['members'] = value
    
    
    @property
    def groups(self) -> List[str]:
        """List of groups in this group.
    Deprecated! This field is unused."""
        return self._inner_dict.get('groups')  # type: ignore
    
    @groups.setter
    def groups(self, value: List[str]) -> None:
        self._inner_dict['groups'] = value
    
    
    @property
    def description(self) -> Union[None, str]:
        """A description of the group."""
        return self._inner_dict.get('description')  # type: ignore
    
    @description.setter
    def description(self, value: Union[None, str]) -> None:
        self._inner_dict['description'] = value
    
    
    @property
    def slack(self) -> Union[None, str]:
        """Slack channel for the group"""
        return self._inner_dict.get('slack')  # type: ignore
    
    @slack.setter
    def slack(self, value: Union[None, str]) -> None:
        self._inner_dict['slack'] = value
    
    
    @property
    def created(self) -> Union[None, "AuditStampClass"]:
        """Created Audit stamp"""
        return self._inner_dict.get('created')  # type: ignore
    
    @created.setter
    def created(self, value: Union[None, "AuditStampClass"]) -> None:
        self._inner_dict['created'] = value
    
    
class CorpUserAppearanceSettingsClass(DictWrapper):
    """Settings for a user around the appearance of their DataHub UI"""
    
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.identity.CorpUserAppearanceSettings")
    def __init__(self,
        showSimplifiedHomepage: Union[None, bool]=None,
    ):
        super().__init__()
        
        self.showSimplifiedHomepage = showSimplifiedHomepage
    
    def _restore_defaults(self) -> None:
        self.showSimplifiedHomepage = self.RECORD_SCHEMA.fields_dict["showSimplifiedHomepage"].default
    
    
    @property
    def showSimplifiedHomepage(self) -> Union[None, bool]:
        """Flag whether the user should see a homepage with only datasets, charts and dashboards. Intended for users
    who have less operational use cases for the datahub tool."""
        return self._inner_dict.get('showSimplifiedHomepage')  # type: ignore
    
    @showSimplifiedHomepage.setter
    def showSimplifiedHomepage(self, value: Union[None, bool]) -> None:
        self._inner_dict['showSimplifiedHomepage'] = value
    
    
class CorpUserCredentialsClass(_Aspect):
    """Corp user credentials"""


    ASPECT_NAME = 'corpUserCredentials'
    ASPECT_INFO = {'EntityUrns': ['com.linkedin.pegasus2avro.common.CorpuserUrn']}
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.identity.CorpUserCredentials")

    def __init__(self,
        salt: str,
        hashedPassword: str,
        passwordResetToken: Union[None, str]=None,
        passwordResetTokenExpirationTimeMillis: Union[None, int]=None,
    ):
        super().__init__()
        
        self.salt = salt
        self.hashedPassword = hashedPassword
        self.passwordResetToken = passwordResetToken
        self.passwordResetTokenExpirationTimeMillis = passwordResetTokenExpirationTimeMillis
    
    def _restore_defaults(self) -> None:
        self.salt = str()
        self.hashedPassword = str()
        self.passwordResetToken = self.RECORD_SCHEMA.fields_dict["passwordResetToken"].default
        self.passwordResetTokenExpirationTimeMillis = self.RECORD_SCHEMA.fields_dict["passwordResetTokenExpirationTimeMillis"].default
    
    
    @property
    def salt(self) -> str:
        """Salt used to hash password"""
        return self._inner_dict.get('salt')  # type: ignore
    
    @salt.setter
    def salt(self, value: str) -> None:
        self._inner_dict['salt'] = value
    
    
    @property
    def hashedPassword(self) -> str:
        """Hashed password generated by concatenating salt and password, then hashing"""
        return self._inner_dict.get('hashedPassword')  # type: ignore
    
    @hashedPassword.setter
    def hashedPassword(self, value: str) -> None:
        self._inner_dict['hashedPassword'] = value
    
    
    @property
    def passwordResetToken(self) -> Union[None, str]:
        """Optional token needed to reset a user's password. Can only be set by the admin."""
        return self._inner_dict.get('passwordResetToken')  # type: ignore
    
    @passwordResetToken.setter
    def passwordResetToken(self, value: Union[None, str]) -> None:
        self._inner_dict['passwordResetToken'] = value
    
    
    @property
    def passwordResetTokenExpirationTimeMillis(self) -> Union[None, int]:
        """When the password reset token expires."""
        return self._inner_dict.get('passwordResetTokenExpirationTimeMillis')  # type: ignore
    
    @passwordResetTokenExpirationTimeMillis.setter
    def passwordResetTokenExpirationTimeMillis(self, value: Union[None, int]) -> None:
        self._inner_dict['passwordResetTokenExpirationTimeMillis'] = value
    
    
class CorpUserEditableInfoClass(_Aspect):
    """Linkedin corp user information that can be edited from UI"""


    ASPECT_NAME = 'corpUserEditableInfo'
    ASPECT_INFO = {'EntityUrns': ['com.linkedin.pegasus2avro.common.CorpuserUrn']}
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.identity.CorpUserEditableInfo")

    def __init__(self,
        aboutMe: Union[None, str]=None,
        teams: Optional[List[str]]=None,
        skills: Optional[List[str]]=None,
        pictureLink: Optional[str]=None,
        displayName: Union[None, str]=None,
        title: Union[None, str]=None,
        slack: Union[None, str]=None,
        phone: Union[None, str]=None,
        email: Union[None, str]=None,
    ):
        super().__init__()
        
        self.aboutMe = aboutMe
        if teams is None:
            # default: []
            self.teams = list()
        else:
            self.teams = teams
        if skills is None:
            # default: []
            self.skills = list()
        else:
            self.skills = skills
        if pictureLink is None:
            # default: 'https://raw.githubusercontent.com/datahub-project/datahub/master/datahub-web-react/src/images/default_avatar.png'
            self.pictureLink = self.RECORD_SCHEMA.fields_dict["pictureLink"].default
        else:
            self.pictureLink = pictureLink
        self.displayName = displayName
        self.title = title
        self.slack = slack
        self.phone = phone
        self.email = email
    
    def _restore_defaults(self) -> None:
        self.aboutMe = self.RECORD_SCHEMA.fields_dict["aboutMe"].default
        self.teams = list()
        self.skills = list()
        self.pictureLink = self.RECORD_SCHEMA.fields_dict["pictureLink"].default
        self.displayName = self.RECORD_SCHEMA.fields_dict["displayName"].default
        self.title = self.RECORD_SCHEMA.fields_dict["title"].default
        self.slack = self.RECORD_SCHEMA.fields_dict["slack"].default
        self.phone = self.RECORD_SCHEMA.fields_dict["phone"].default
        self.email = self.RECORD_SCHEMA.fields_dict["email"].default
    
    
    @property
    def aboutMe(self) -> Union[None, str]:
        """About me section of the user"""
        return self._inner_dict.get('aboutMe')  # type: ignore
    
    @aboutMe.setter
    def aboutMe(self, value: Union[None, str]) -> None:
        self._inner_dict['aboutMe'] = value
    
    
    @property
    def teams(self) -> List[str]:
        """Teams that the user belongs to e.g. Metadata"""
        return self._inner_dict.get('teams')  # type: ignore
    
    @teams.setter
    def teams(self, value: List[str]) -> None:
        self._inner_dict['teams'] = value
    
    
    @property
    def skills(self) -> List[str]:
        """Skills that the user possesses e.g. Machine Learning"""
        return self._inner_dict.get('skills')  # type: ignore
    
    @skills.setter
    def skills(self, value: List[str]) -> None:
        self._inner_dict['skills'] = value
    
    
    @property
    def pictureLink(self) -> str:
        """A URL which points to a picture which user wants to set as a profile photo"""
        return self._inner_dict.get('pictureLink')  # type: ignore
    
    @pictureLink.setter
    def pictureLink(self, value: str) -> None:
        self._inner_dict['pictureLink'] = value
    
    
    @property
    def displayName(self) -> Union[None, str]:
        """DataHub-native display name"""
        return self._inner_dict.get('displayName')  # type: ignore
    
    @displayName.setter
    def displayName(self, value: Union[None, str]) -> None:
        self._inner_dict['displayName'] = value
    
    
    @property
    def title(self) -> Union[None, str]:
        """DataHub-native Title, e.g. 'Software Engineer'"""
        return self._inner_dict.get('title')  # type: ignore
    
    @title.setter
    def title(self, value: Union[None, str]) -> None:
        self._inner_dict['title'] = value
    
    
    @property
    def slack(self) -> Union[None, str]:
        """Slack handle for the user"""
        return self._inner_dict.get('slack')  # type: ignore
    
    @slack.setter
    def slack(self, value: Union[None, str]) -> None:
        self._inner_dict['slack'] = value
    
    
    @property
    def phone(self) -> Union[None, str]:
        """Phone number to contact the user"""
        return self._inner_dict.get('phone')  # type: ignore
    
    @phone.setter
    def phone(self, value: Union[None, str]) -> None:
        self._inner_dict['phone'] = value
    
    
    @property
    def email(self) -> Union[None, str]:
        """Email address to contact the user"""
        return self._inner_dict.get('email')  # type: ignore
    
    @email.setter
    def email(self, value: Union[None, str]) -> None:
        self._inner_dict['email'] = value
    
    
class CorpUserInfoClass(_Aspect):
    """Linkedin corp user information"""


    ASPECT_NAME = 'corpUserInfo'
    ASPECT_INFO = {'EntityUrns': ['com.linkedin.pegasus2avro.common.CorpuserUrn']}
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.identity.CorpUserInfo")

    def __init__(self,
        active: bool,
        customProperties: Optional[Dict[str, str]]=None,
        displayName: Union[None, str]=None,
        email: Union[None, str]=None,
        title: Union[None, str]=None,
        managerUrn: Union[None, str]=None,
        departmentId: Union[None, int]=None,
        departmentName: Union[None, str]=None,
        firstName: Union[None, str]=None,
        lastName: Union[None, str]=None,
        fullName: Union[None, str]=None,
        countryCode: Union[None, str]=None,
    ):
        super().__init__()
        
        if customProperties is None:
            # default: {}
            self.customProperties = dict()
        else:
            self.customProperties = customProperties
        self.active = active
        self.displayName = displayName
        self.email = email
        self.title = title
        self.managerUrn = managerUrn
        self.departmentId = departmentId
        self.departmentName = departmentName
        self.firstName = firstName
        self.lastName = lastName
        self.fullName = fullName
        self.countryCode = countryCode
    
    def _restore_defaults(self) -> None:
        self.customProperties = dict()
        self.active = bool()
        self.displayName = self.RECORD_SCHEMA.fields_dict["displayName"].default
        self.email = self.RECORD_SCHEMA.fields_dict["email"].default
        self.title = self.RECORD_SCHEMA.fields_dict["title"].default
        self.managerUrn = self.RECORD_SCHEMA.fields_dict["managerUrn"].default
        self.departmentId = self.RECORD_SCHEMA.fields_dict["departmentId"].default
        self.departmentName = self.RECORD_SCHEMA.fields_dict["departmentName"].default
        self.firstName = self.RECORD_SCHEMA.fields_dict["firstName"].default
        self.lastName = self.RECORD_SCHEMA.fields_dict["lastName"].default
        self.fullName = self.RECORD_SCHEMA.fields_dict["fullName"].default
        self.countryCode = self.RECORD_SCHEMA.fields_dict["countryCode"].default
    
    
    @property
    def customProperties(self) -> Dict[str, str]:
        """Custom property bag."""
        return self._inner_dict.get('customProperties')  # type: ignore
    
    @customProperties.setter
    def customProperties(self, value: Dict[str, str]) -> None:
        self._inner_dict['customProperties'] = value
    
    
    @property
    def active(self) -> bool:
        """Deprecated! Use CorpUserStatus instead. Whether the corpUser is active, ref: https://iwww.corp.linkedin.com/wiki/cf/display/GTSD/Accessing+Active+Directory+via+LDAP+tools"""
        return self._inner_dict.get('active')  # type: ignore
    
    @active.setter
    def active(self, value: bool) -> None:
        self._inner_dict['active'] = value
    
    
    @property
    def displayName(self) -> Union[None, str]:
        """displayName of this user ,  e.g.  Hang Zhang(DataHQ)"""
        return self._inner_dict.get('displayName')  # type: ignore
    
    @displayName.setter
    def displayName(self, value: Union[None, str]) -> None:
        self._inner_dict['displayName'] = value
    
    
    @property
    def email(self) -> Union[None, str]:
        """email address of this user"""
        return self._inner_dict.get('email')  # type: ignore
    
    @email.setter
    def email(self, value: Union[None, str]) -> None:
        self._inner_dict['email'] = value
    
    
    @property
    def title(self) -> Union[None, str]:
        """title of this user"""
        return self._inner_dict.get('title')  # type: ignore
    
    @title.setter
    def title(self, value: Union[None, str]) -> None:
        self._inner_dict['title'] = value
    
    
    @property
    def managerUrn(self) -> Union[None, str]:
        """direct manager of this user"""
        return self._inner_dict.get('managerUrn')  # type: ignore
    
    @managerUrn.setter
    def managerUrn(self, value: Union[None, str]) -> None:
        self._inner_dict['managerUrn'] = value
    
    
    @property
    def departmentId(self) -> Union[None, int]:
        """department id this user belong to"""
        return self._inner_dict.get('departmentId')  # type: ignore
    
    @departmentId.setter
    def departmentId(self, value: Union[None, int]) -> None:
        self._inner_dict['departmentId'] = value
    
    
    @property
    def departmentName(self) -> Union[None, str]:
        """department name this user belong to"""
        return self._inner_dict.get('departmentName')  # type: ignore
    
    @departmentName.setter
    def departmentName(self, value: Union[None, str]) -> None:
        self._inner_dict['departmentName'] = value
    
    
    @property
    def firstName(self) -> Union[None, str]:
        """first name of this user"""
        return self._inner_dict.get('firstName')  # type: ignore
    
    @firstName.setter
    def firstName(self, value: Union[None, str]) -> None:
        self._inner_dict['firstName'] = value
    
    
    @property
    def lastName(self) -> Union[None, str]:
        """last name of this user"""
        return self._inner_dict.get('lastName')  # type: ignore
    
    @lastName.setter
    def lastName(self, value: Union[None, str]) -> None:
        self._inner_dict['lastName'] = value
    
    
    @property
    def fullName(self) -> Union[None, str]:
        """Common name of this user, format is firstName + lastName (split by a whitespace)"""
        return self._inner_dict.get('fullName')  # type: ignore
    
    @fullName.setter
    def fullName(self, value: Union[None, str]) -> None:
        self._inner_dict['fullName'] = value
    
    
    @property
    def countryCode(self) -> Union[None, str]:
        """two uppercase letters country code. e.g.  US"""
        return self._inner_dict.get('countryCode')  # type: ignore
    
    @countryCode.setter
    def countryCode(self, value: Union[None, str]) -> None:
        self._inner_dict['countryCode'] = value
    
    
class CorpUserSettingsClass(_Aspect):
    """Settings that a user can customize through the datahub ui"""


    ASPECT_NAME = 'corpUserSettings'
    ASPECT_INFO = {}
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.identity.CorpUserSettings")

    def __init__(self,
        appearance: "CorpUserAppearanceSettingsClass",
        views: Union[None, "CorpUserViewsSettingsClass"]=None,
    ):
        super().__init__()
        
        self.appearance = appearance
        self.views = views
    
    def _restore_defaults(self) -> None:
        self.appearance = CorpUserAppearanceSettingsClass._construct_with_defaults()
        self.views = self.RECORD_SCHEMA.fields_dict["views"].default
    
    
    @property
    def appearance(self) -> "CorpUserAppearanceSettingsClass":
        """Settings for a user around the appearance of their DataHub U"""
        return self._inner_dict.get('appearance')  # type: ignore
    
    @appearance.setter
    def appearance(self, value: "CorpUserAppearanceSettingsClass") -> None:
        self._inner_dict['appearance'] = value
    
    
    @property
    def views(self) -> Union[None, "CorpUserViewsSettingsClass"]:
        """User preferences for the Views feature."""
        return self._inner_dict.get('views')  # type: ignore
    
    @views.setter
    def views(self, value: Union[None, "CorpUserViewsSettingsClass"]) -> None:
        self._inner_dict['views'] = value
    
    
class CorpUserStatusClass(_Aspect):
    """The status of the user, e.g. provisioned, active, suspended, etc."""


    ASPECT_NAME = 'corpUserStatus'
    ASPECT_INFO = {}
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.identity.CorpUserStatus")

    def __init__(self,
        status: str,
        lastModified: "AuditStampClass",
    ):
        super().__init__()
        
        self.status = status
        self.lastModified = lastModified
    
    def _restore_defaults(self) -> None:
        self.status = str()
        self.lastModified = AuditStampClass._construct_with_defaults()
    
    
    @property
    def status(self) -> str:
        """Status of the user, e.g. PROVISIONED / ACTIVE / SUSPENDED"""
        return self._inner_dict.get('status')  # type: ignore
    
    @status.setter
    def status(self, value: str) -> None:
        self._inner_dict['status'] = value
    
    
    @property
    def lastModified(self) -> "AuditStampClass":
        """Audit stamp containing who last modified the status and when."""
        return self._inner_dict.get('lastModified')  # type: ignore
    
    @lastModified.setter
    def lastModified(self, value: "AuditStampClass") -> None:
        self._inner_dict['lastModified'] = value
    
    
class CorpUserViewsSettingsClass(DictWrapper):
    """Settings related to the 'Views' feature."""
    
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.identity.CorpUserViewsSettings")
    def __init__(self,
        defaultView: Union[None, str]=None,
    ):
        super().__init__()
        
        self.defaultView = defaultView
    
    def _restore_defaults(self) -> None:
        self.defaultView = self.RECORD_SCHEMA.fields_dict["defaultView"].default
    
    
    @property
    def defaultView(self) -> Union[None, str]:
        """The default View which is selected for the user.
    If none is chosen, then this value will be left blank."""
        return self._inner_dict.get('defaultView')  # type: ignore
    
    @defaultView.setter
    def defaultView(self, value: Union[None, str]) -> None:
        self._inner_dict['defaultView'] = value
    
    
class GroupMembershipClass(_Aspect):
    """Carries information about the CorpGroups a user is in."""


    ASPECT_NAME = 'groupMembership'
    ASPECT_INFO = {}
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.identity.GroupMembership")

    def __init__(self,
        groups: List[str],
    ):
        super().__init__()
        
        self.groups = groups
    
    def _restore_defaults(self) -> None:
        self.groups = list()
    
    
    @property
    def groups(self) -> List[str]:
        # No docs available.
        return self._inner_dict.get('groups')  # type: ignore
    
    @groups.setter
    def groups(self, value: List[str]) -> None:
        self._inner_dict['groups'] = value
    
    
class InviteTokenClass(_Aspect):
    """Aspect used to store invite tokens."""


    ASPECT_NAME = 'inviteToken'
    ASPECT_INFO = {}
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.identity.InviteToken")

    def __init__(self,
        token: str,
        role: Union[None, str]=None,
    ):
        super().__init__()
        
        self.token = token
        self.role = role
    
    def _restore_defaults(self) -> None:
        self.token = str()
        self.role = self.RECORD_SCHEMA.fields_dict["role"].default
    
    
    @property
    def token(self) -> str:
        """The encrypted invite token."""
        return self._inner_dict.get('token')  # type: ignore
    
    @token.setter
    def token(self, value: str) -> None:
        self._inner_dict['token'] = value
    
    
    @property
    def role(self) -> Union[None, str]:
        """The role that this invite token may be associated with"""
        return self._inner_dict.get('role')  # type: ignore
    
    @role.setter
    def role(self, value: Union[None, str]) -> None:
        self._inner_dict['role'] = value
    
    
class NativeGroupMembershipClass(_Aspect):
    """Carries information about the native CorpGroups a user is in."""


    ASPECT_NAME = 'nativeGroupMembership'
    ASPECT_INFO = {}
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.identity.NativeGroupMembership")

    def __init__(self,
        nativeGroups: List[str],
    ):
        super().__init__()
        
        self.nativeGroups = nativeGroups
    
    def _restore_defaults(self) -> None:
        self.nativeGroups = list()
    
    
    @property
    def nativeGroups(self) -> List[str]:
        # No docs available.
        return self._inner_dict.get('nativeGroups')  # type: ignore
    
    @nativeGroups.setter
    def nativeGroups(self, value: List[str]) -> None:
        self._inner_dict['nativeGroups'] = value
    
    
class RoleMembershipClass(_Aspect):
    """Carries information about which roles a user or group is assigned to."""


    ASPECT_NAME = 'roleMembership'
    ASPECT_INFO = {}
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.identity.RoleMembership")

    def __init__(self,
        roles: List[str],
    ):
        super().__init__()
        
        self.roles = roles
    
    def _restore_defaults(self) -> None:
        self.roles = list()
    
    
    @property
    def roles(self) -> List[str]:
        # No docs available.
        return self._inner_dict.get('roles')  # type: ignore
    
    @roles.setter
    def roles(self, value: List[str]) -> None:
        self._inner_dict['roles'] = value
    
    
class IncidentInfoClass(_Aspect):
    """Information about an incident raised on an asset."""


    ASPECT_NAME = 'incidentInfo'
    ASPECT_INFO = {}
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.incident.IncidentInfo")

    def __init__(self,
        type: Union[str, "IncidentTypeClass"],
        entities: List[str],
        status: "IncidentStatusClass",
        created: "AuditStampClass",
        customType: Union[None, str]=None,
        title: Union[None, str]=None,
        description: Union[None, str]=None,
        priority: Optional[Union[int, None]]=None,
        source: Union[None, "IncidentSourceClass"]=None,
    ):
        super().__init__()
        
        self.type = type
        self.customType = customType
        self.title = title
        self.description = description
        self.entities = entities
        if priority is None:
            # default: 0
            self.priority = self.RECORD_SCHEMA.fields_dict["priority"].default
        else:
            self.priority = priority
        self.status = status
        self.source = source
        self.created = created
    
    def _restore_defaults(self) -> None:
        self.type = IncidentTypeClass.OPERATIONAL
        self.customType = self.RECORD_SCHEMA.fields_dict["customType"].default
        self.title = self.RECORD_SCHEMA.fields_dict["title"].default
        self.description = self.RECORD_SCHEMA.fields_dict["description"].default
        self.entities = list()
        self.priority = self.RECORD_SCHEMA.fields_dict["priority"].default
        self.status = IncidentStatusClass._construct_with_defaults()
        self.source = self.RECORD_SCHEMA.fields_dict["source"].default
        self.created = AuditStampClass._construct_with_defaults()
    
    
    @property
    def type(self) -> Union[str, "IncidentTypeClass"]:
        """The type of incident"""
        return self._inner_dict.get('type')  # type: ignore
    
    @type.setter
    def type(self, value: Union[str, "IncidentTypeClass"]) -> None:
        self._inner_dict['type'] = value
    
    
    @property
    def customType(self) -> Union[None, str]:
        """An optional custom incident type. Present only if type is 'CUSTOM'."""
        return self._inner_dict.get('customType')  # type: ignore
    
    @customType.setter
    def customType(self, value: Union[None, str]) -> None:
        self._inner_dict['customType'] = value
    
    
    @property
    def title(self) -> Union[None, str]:
        """Optional title associated with the incident"""
        return self._inner_dict.get('title')  # type: ignore
    
    @title.setter
    def title(self, value: Union[None, str]) -> None:
        self._inner_dict['title'] = value
    
    
    @property
    def description(self) -> Union[None, str]:
        """Optional description associated with the incident"""
        return self._inner_dict.get('description')  # type: ignore
    
    @description.setter
    def description(self, value: Union[None, str]) -> None:
        self._inner_dict['description'] = value
    
    
    @property
    def entities(self) -> List[str]:
        """A reference to the entity associated with the incident."""
        return self._inner_dict.get('entities')  # type: ignore
    
    @entities.setter
    def entities(self, value: List[str]) -> None:
        self._inner_dict['entities'] = value
    
    
    @property
    def priority(self) -> Union[int, None]:
        """A numeric severity or priority for the incident. On the UI we will translate this into something easy to understand."""
        return self._inner_dict.get('priority')  # type: ignore
    
    @priority.setter
    def priority(self, value: Union[int, None]) -> None:
        self._inner_dict['priority'] = value
    
    
    @property
    def status(self) -> "IncidentStatusClass":
        """The current status of an incident, i.e. active or inactive."""
        return self._inner_dict.get('status')  # type: ignore
    
    @status.setter
    def status(self, value: "IncidentStatusClass") -> None:
        self._inner_dict['status'] = value
    
    
    @property
    def source(self) -> Union[None, "IncidentSourceClass"]:
        """The source of an incident, i.e. how it was generated."""
        return self._inner_dict.get('source')  # type: ignore
    
    @source.setter
    def source(self, value: Union[None, "IncidentSourceClass"]) -> None:
        self._inner_dict['source'] = value
    
    
    @property
    def created(self) -> "AuditStampClass":
        """The time at which the request was initially created"""
        return self._inner_dict.get('created')  # type: ignore
    
    @created.setter
    def created(self, value: "AuditStampClass") -> None:
        self._inner_dict['created'] = value
    
    
class IncidentSourceClass(_Aspect):
    """Information about the source of an incident raised on an asset."""


    ASPECT_NAME = 'incidentSource'
    ASPECT_INFO = {}
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.incident.IncidentSource")

    def __init__(self,
        type: Union[str, "IncidentSourceTypeClass"],
        sourceUrn: Union[None, str]=None,
    ):
        super().__init__()
        
        self.type = type
        self.sourceUrn = sourceUrn
    
    def _restore_defaults(self) -> None:
        self.type = IncidentSourceTypeClass.MANUAL
        self.sourceUrn = self.RECORD_SCHEMA.fields_dict["sourceUrn"].default
    
    
    @property
    def type(self) -> Union[str, "IncidentSourceTypeClass"]:
        """Message associated with the incident"""
        return self._inner_dict.get('type')  # type: ignore
    
    @type.setter
    def type(self, value: Union[str, "IncidentSourceTypeClass"]) -> None:
        self._inner_dict['type'] = value
    
    
    @property
    def sourceUrn(self) -> Union[None, str]:
        """Reference to an URN related to the source of an incident."""
        return self._inner_dict.get('sourceUrn')  # type: ignore
    
    @sourceUrn.setter
    def sourceUrn(self, value: Union[None, str]) -> None:
        self._inner_dict['sourceUrn'] = value
    
    
class IncidentSourceTypeClass(object):
    # No docs available.
    
    MANUAL = "MANUAL"
    """Manually created incident, via UI or API."""
    
    
    
class IncidentStateClass(object):
    # No docs available.
    
    ACTIVE = "ACTIVE"
    """The incident is ongoing, or active."""
    
    RESOLVED = "RESOLVED"
    """The incident is resolved."""
    
    
    
class IncidentStatusClass(DictWrapper):
    """Information about an incident raised on an asset"""
    
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.incident.IncidentStatus")
    def __init__(self,
        state: Union[str, "IncidentStateClass"],
        lastUpdated: "AuditStampClass",
        message: Union[None, str]=None,
    ):
        super().__init__()
        
        self.state = state
        self.message = message
        self.lastUpdated = lastUpdated
    
    def _restore_defaults(self) -> None:
        self.state = IncidentStateClass.ACTIVE
        self.message = self.RECORD_SCHEMA.fields_dict["message"].default
        self.lastUpdated = AuditStampClass._construct_with_defaults()
    
    
    @property
    def state(self) -> Union[str, "IncidentStateClass"]:
        """The state of the incident"""
        return self._inner_dict.get('state')  # type: ignore
    
    @state.setter
    def state(self, value: Union[str, "IncidentStateClass"]) -> None:
        self._inner_dict['state'] = value
    
    
    @property
    def message(self) -> Union[None, str]:
        """Optional message associated with the incident"""
        return self._inner_dict.get('message')  # type: ignore
    
    @message.setter
    def message(self, value: Union[None, str]) -> None:
        self._inner_dict['message'] = value
    
    
    @property
    def lastUpdated(self) -> "AuditStampClass":
        """The time at which the request was initially created"""
        return self._inner_dict.get('lastUpdated')  # type: ignore
    
    @lastUpdated.setter
    def lastUpdated(self, value: "AuditStampClass") -> None:
        self._inner_dict['lastUpdated'] = value
    
    
class IncidentTypeClass(object):
    """A type of asset incident"""
    
    OPERATIONAL = "OPERATIONAL"
    """A misc. operational incident, e.g. failure to materialize a dataset."""
    
    CUSTOM = "CUSTOM"
    """A custom type of incident"""
    
    
    
class DataHubIngestionSourceConfigClass(DictWrapper):
    # No docs available.
    
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.ingestion.DataHubIngestionSourceConfig")
    def __init__(self,
        recipe: str,
        version: Union[None, str]=None,
        executorId: Union[None, str]=None,
        debugMode: Union[None, bool]=None,
        extraArgs: Union[None, Dict[str, str]]=None,
    ):
        super().__init__()
        
        self.recipe = recipe
        self.version = version
        self.executorId = executorId
        self.debugMode = debugMode
        self.extraArgs = extraArgs
    
    def _restore_defaults(self) -> None:
        self.recipe = str()
        self.version = self.RECORD_SCHEMA.fields_dict["version"].default
        self.executorId = self.RECORD_SCHEMA.fields_dict["executorId"].default
        self.debugMode = self.RECORD_SCHEMA.fields_dict["debugMode"].default
        self.extraArgs = self.RECORD_SCHEMA.fields_dict["extraArgs"].default
    
    
    @property
    def recipe(self) -> str:
        """The JSON recipe to use for ingestion"""
        return self._inner_dict.get('recipe')  # type: ignore
    
    @recipe.setter
    def recipe(self, value: str) -> None:
        self._inner_dict['recipe'] = value
    
    
    @property
    def version(self) -> Union[None, str]:
        """The PyPI version of the datahub CLI to use when executing a recipe"""
        return self._inner_dict.get('version')  # type: ignore
    
    @version.setter
    def version(self, value: Union[None, str]) -> None:
        self._inner_dict['version'] = value
    
    
    @property
    def executorId(self) -> Union[None, str]:
        """The id of the executor to use to execute the ingestion run"""
        return self._inner_dict.get('executorId')  # type: ignore
    
    @executorId.setter
    def executorId(self, value: Union[None, str]) -> None:
        self._inner_dict['executorId'] = value
    
    
    @property
    def debugMode(self) -> Union[None, bool]:
        """Whether or not to run this ingestion source in debug mode"""
        return self._inner_dict.get('debugMode')  # type: ignore
    
    @debugMode.setter
    def debugMode(self, value: Union[None, bool]) -> None:
        self._inner_dict['debugMode'] = value
    
    
    @property
    def extraArgs(self) -> Union[None, Dict[str, str]]:
        """Extra arguments for the ingestion run."""
        return self._inner_dict.get('extraArgs')  # type: ignore
    
    @extraArgs.setter
    def extraArgs(self, value: Union[None, Dict[str, str]]) -> None:
        self._inner_dict['extraArgs'] = value
    
    
class DataHubIngestionSourceInfoClass(_Aspect):
    """Info about a DataHub ingestion source"""


    ASPECT_NAME = 'dataHubIngestionSourceInfo'
    ASPECT_INFO = {}
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.ingestion.DataHubIngestionSourceInfo")

    def __init__(self,
        name: str,
        type: str,
        config: "DataHubIngestionSourceConfigClass",
        platform: Union[None, str]=None,
        schedule: Union[None, "DataHubIngestionSourceScheduleClass"]=None,
    ):
        super().__init__()
        
        self.name = name
        self.type = type
        self.platform = platform
        self.schedule = schedule
        self.config = config
    
    def _restore_defaults(self) -> None:
        self.name = str()
        self.type = str()
        self.platform = self.RECORD_SCHEMA.fields_dict["platform"].default
        self.schedule = self.RECORD_SCHEMA.fields_dict["schedule"].default
        self.config = DataHubIngestionSourceConfigClass._construct_with_defaults()
    
    
    @property
    def name(self) -> str:
        """The display name of the ingestion source"""
        return self._inner_dict.get('name')  # type: ignore
    
    @name.setter
    def name(self, value: str) -> None:
        self._inner_dict['name'] = value
    
    
    @property
    def type(self) -> str:
        """The type of the source itself, e.g. mysql, bigquery, bigquery-usage. Should match the recipe."""
        return self._inner_dict.get('type')  # type: ignore
    
    @type.setter
    def type(self, value: str) -> None:
        self._inner_dict['type'] = value
    
    
    @property
    def platform(self) -> Union[None, str]:
        """Data Platform URN associated with the source"""
        return self._inner_dict.get('platform')  # type: ignore
    
    @platform.setter
    def platform(self, value: Union[None, str]) -> None:
        self._inner_dict['platform'] = value
    
    
    @property
    def schedule(self) -> Union[None, "DataHubIngestionSourceScheduleClass"]:
        """The schedule on which the ingestion source is executed"""
        return self._inner_dict.get('schedule')  # type: ignore
    
    @schedule.setter
    def schedule(self, value: Union[None, "DataHubIngestionSourceScheduleClass"]) -> None:
        self._inner_dict['schedule'] = value
    
    
    @property
    def config(self) -> "DataHubIngestionSourceConfigClass":
        """Parameters associated with the Ingestion Source"""
        return self._inner_dict.get('config')  # type: ignore
    
    @config.setter
    def config(self, value: "DataHubIngestionSourceConfigClass") -> None:
        self._inner_dict['config'] = value
    
    
class DataHubIngestionSourceScheduleClass(DictWrapper):
    """The schedule associated with an ingestion source."""
    
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.ingestion.DataHubIngestionSourceSchedule")
    def __init__(self,
        interval: str,
        timezone: str,
    ):
        super().__init__()
        
        self.interval = interval
        self.timezone = timezone
    
    def _restore_defaults(self) -> None:
        self.interval = str()
        self.timezone = str()
    
    
    @property
    def interval(self) -> str:
        """A cron-formatted execution interval, as a cron string, e.g. * * * * *"""
        return self._inner_dict.get('interval')  # type: ignore
    
    @interval.setter
    def interval(self, value: str) -> None:
        self._inner_dict['interval'] = value
    
    
    @property
    def timezone(self) -> str:
        """Timezone in which the cron interval applies, e.g. America/Los Angeles"""
        return self._inner_dict.get('timezone')  # type: ignore
    
    @timezone.setter
    def timezone(self, value: str) -> None:
        self._inner_dict['timezone'] = value
    
    
class AssertionKeyClass(_Aspect):
    """Key for a Assertion"""


    ASPECT_NAME = 'assertionKey'
    ASPECT_INFO = {'keyForEntity': 'assertion', 'entityCategory': 'core', 'entityAspects': ['assertionInfo', 'dataPlatformInstance', 'assertionRunEvent', 'assertionActions', 'status'], 'entityDoc': 'Assertion represents a data quality rule applied on one or more dataset.'}
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.metadata.key.AssertionKey")

    def __init__(self,
        assertionId: str,
    ):
        super().__init__()
        
        self.assertionId = assertionId
    
    def _restore_defaults(self) -> None:
        self.assertionId = str()
    
    
    @property
    def assertionId(self) -> str:
        """Unique id for the assertion."""
        return self._inner_dict.get('assertionId')  # type: ignore
    
    @assertionId.setter
    def assertionId(self, value: str) -> None:
        self._inner_dict['assertionId'] = value
    
    
class ChartKeyClass(_Aspect):
    """Key for a Chart"""


    ASPECT_NAME = 'chartKey'
    ASPECT_INFO = {'keyForEntity': 'chart', 'entityCategory': 'core', 'entityAspects': ['chartInfo', 'editableChartProperties', 'chartQuery', 'inputFields', 'chartUsageStatistics', 'embed', 'browsePaths', 'domains', 'container', 'deprecation', 'ownership', 'status', 'institutionalMemory', 'dataPlatformInstance', 'globalTags', 'glossaryTerms', 'browsePathsV2', 'subTypes', 'structuredProperties', 'incidentsSummary', 'forms']}
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.metadata.key.ChartKey")

    def __init__(self,
        dashboardTool: str,
        chartId: str,
    ):
        super().__init__()
        
        self.dashboardTool = dashboardTool
        self.chartId = chartId
    
    def _restore_defaults(self) -> None:
        self.dashboardTool = str()
        self.chartId = str()
    
    
    @property
    def dashboardTool(self) -> str:
        """The name of the dashboard tool such as looker, redash etc."""
        return self._inner_dict.get('dashboardTool')  # type: ignore
    
    @dashboardTool.setter
    def dashboardTool(self, value: str) -> None:
        self._inner_dict['dashboardTool'] = value
    
    
    @property
    def chartId(self) -> str:
        """Unique id for the chart. This id should be globally unique for a dashboarding tool even when there are multiple deployments of it. As an example, chart URL could be used here for Looker such as 'looker.linkedin.com/looks/1234'"""
        return self._inner_dict.get('chartId')  # type: ignore
    
    @chartId.setter
    def chartId(self, value: str) -> None:
        self._inner_dict['chartId'] = value
    
    
class ContainerKeyClass(_Aspect):
    """Key for an Asset Container"""


    ASPECT_NAME = 'containerKey'
    ASPECT_INFO = {'keyForEntity': 'container', 'entityCategory': 'core', 'entityAspects': ['containerProperties', 'editableContainerProperties', 'dataPlatformInstance', 'subTypes', 'ownership', 'container', 'globalTags', 'glossaryTerms', 'institutionalMemory', 'browsePaths', 'status', 'domains', 'browsePathsV2', 'structuredProperties', 'forms'], 'entityDoc': 'A container of related data assets.'}
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.metadata.key.ContainerKey")

    def __init__(self,
        guid: Union[None, str]=None,
    ):
        super().__init__()
        
        self.guid = guid
    
    def _restore_defaults(self) -> None:
        self.guid = self.RECORD_SCHEMA.fields_dict["guid"].default
    
    
    @property
    def guid(self) -> Union[None, str]:
        """Unique guid for container"""
        return self._inner_dict.get('guid')  # type: ignore
    
    @guid.setter
    def guid(self, value: Union[None, str]) -> None:
        self._inner_dict['guid'] = value
    
    
class CorpGroupKeyClass(_Aspect):
    """Key for a CorpGroup"""


    ASPECT_NAME = 'corpGroupKey'
    ASPECT_INFO = {'keyForEntity': 'corpGroup', 'entityCategory': '_unset_', 'entityAspects': ['corpGroupInfo', 'corpGroupEditableInfo', 'globalTags', 'ownership', 'status', 'origin', 'roleMembership', 'structuredProperties', 'forms'], 'entityDoc': 'CorpGroup represents an identity of a group of users in the enterprise.'}
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.metadata.key.CorpGroupKey")

    def __init__(self,
        name: str,
    ):
        super().__init__()
        
        self.name = name
    
    def _restore_defaults(self) -> None:
        self.name = str()
    
    
    @property
    def name(self) -> str:
        """The URL-encoded name of the AD/LDAP group. Serves as a globally unique identifier within DataHub."""
        return self._inner_dict.get('name')  # type: ignore
    
    @name.setter
    def name(self, value: str) -> None:
        self._inner_dict['name'] = value
    
    
class CorpUserKeyClass(_Aspect):
    """Key for a CorpUser"""


    ASPECT_NAME = 'corpUserKey'
    ASPECT_INFO = {'keyForEntity': 'corpuser', 'entityCategory': '_unset_', 'entityAspects': ['corpUserInfo', 'corpUserEditableInfo', 'corpUserStatus', 'groupMembership', 'globalTags', 'status', 'corpUserCredentials', 'nativeGroupMembership', 'corpUserSettings', 'origin', 'roleMembership', 'structuredProperties', 'forms'], 'entityDoc': 'CorpUser represents an identity of a person (or an account) in the enterprise.'}
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.metadata.key.CorpUserKey")

    def __init__(self,
        username: str,
    ):
        super().__init__()
        
        self.username = username
    
    def _restore_defaults(self) -> None:
        self.username = str()
    
    
    @property
    def username(self) -> str:
        """The name of the AD/LDAP user."""
        return self._inner_dict.get('username')  # type: ignore
    
    @username.setter
    def username(self, value: str) -> None:
        self._inner_dict['username'] = value
    
    
class DashboardKeyClass(_Aspect):
    """Key for a Dashboard"""


    ASPECT_NAME = 'dashboardKey'
    ASPECT_INFO = {'keyForEntity': 'dashboard', 'entityCategory': '_unset_', 'entityAspects': ['domains', 'container', 'deprecation', 'dashboardUsageStatistics', 'inputFields', 'subTypes', 'embed', 'dashboardInfo', 'editableDashboardProperties', 'ownership', 'status', 'globalTags', 'browsePaths', 'glossaryTerms', 'institutionalMemory', 'dataPlatformInstance', 'browsePathsV2', 'structuredProperties', 'incidentsSummary', 'forms']}
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.metadata.key.DashboardKey")

    def __init__(self,
        dashboardTool: str,
        dashboardId: str,
    ):
        super().__init__()
        
        self.dashboardTool = dashboardTool
        self.dashboardId = dashboardId
    
    def _restore_defaults(self) -> None:
        self.dashboardTool = str()
        self.dashboardId = str()
    
    
    @property
    def dashboardTool(self) -> str:
        """The name of the dashboard tool such as looker, redash etc."""
        return self._inner_dict.get('dashboardTool')  # type: ignore
    
    @dashboardTool.setter
    def dashboardTool(self, value: str) -> None:
        self._inner_dict['dashboardTool'] = value
    
    
    @property
    def dashboardId(self) -> str:
        """Unique id for the dashboard. This id should be globally unique for a dashboarding tool even when there are multiple deployments of it. As an example, dashboard URL could be used here for Looker such as 'looker.linkedin.com/dashboards/1234'"""
        return self._inner_dict.get('dashboardId')  # type: ignore
    
    @dashboardId.setter
    def dashboardId(self, value: str) -> None:
        self._inner_dict['dashboardId'] = value
    
    
class DataContractKeyClass(_Aspect):
    """Key for a Data Contract"""


    ASPECT_NAME = 'dataContractKey'
    ASPECT_INFO = {'keyForEntity': 'dataContract', 'entityCategory': 'core', 'entityAspects': ['dataContractProperties', 'dataContractStatus', 'status']}
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.metadata.key.DataContractKey")

    def __init__(self,
        id: str,
    ):
        super().__init__()
        
        self.id = id
    
    def _restore_defaults(self) -> None:
        self.id = str()
    
    
    @property
    def id(self) -> str:
        """Unique id for the contract"""
        return self._inner_dict.get('id')  # type: ignore
    
    @id.setter
    def id(self, value: str) -> None:
        self._inner_dict['id'] = value
    
    
class DataFlowKeyClass(_Aspect):
    """Key for a Data Flow"""


    ASPECT_NAME = 'dataFlowKey'
    ASPECT_INFO = {'keyForEntity': 'dataFlow', 'entityCategory': 'core', 'entityAspects': ['domains', 'deprecation', 'versionInfo', 'dataFlowInfo', 'editableDataFlowProperties', 'ownership', 'status', 'globalTags', 'browsePaths', 'glossaryTerms', 'institutionalMemory', 'dataPlatformInstance', 'browsePathsV2', 'structuredProperties', 'incidentsSummary', 'forms', 'subTypes']}
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.metadata.key.DataFlowKey")

    def __init__(self,
        orchestrator: str,
        flowId: str,
        cluster: str,
    ):
        super().__init__()
        
        self.orchestrator = orchestrator
        self.flowId = flowId
        self.cluster = cluster
    
    def _restore_defaults(self) -> None:
        self.orchestrator = str()
        self.flowId = str()
        self.cluster = str()
    
    
    @property
    def orchestrator(self) -> str:
        """Workflow manager like azkaban, airflow which orchestrates the flow"""
        return self._inner_dict.get('orchestrator')  # type: ignore
    
    @orchestrator.setter
    def orchestrator(self, value: str) -> None:
        self._inner_dict['orchestrator'] = value
    
    
    @property
    def flowId(self) -> str:
        """Unique Identifier of the data flow"""
        return self._inner_dict.get('flowId')  # type: ignore
    
    @flowId.setter
    def flowId(self, value: str) -> None:
        self._inner_dict['flowId'] = value
    
    
    @property
    def cluster(self) -> str:
        """Cluster where the flow is executed"""
        return self._inner_dict.get('cluster')  # type: ignore
    
    @cluster.setter
    def cluster(self, value: str) -> None:
        self._inner_dict['cluster'] = value
    
    
class DataHubAccessTokenKeyClass(_Aspect):
    """Key for a DataHub Access Token"""


    ASPECT_NAME = 'dataHubAccessTokenKey'
    ASPECT_INFO = {'keyForEntity': 'dataHubAccessToken', 'entityCategory': 'internal', 'entityAspects': ['dataHubAccessTokenInfo']}
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.metadata.key.DataHubAccessTokenKey")

    def __init__(self,
        id: str,
    ):
        super().__init__()
        
        self.id = id
    
    def _restore_defaults(self) -> None:
        self.id = str()
    
    
    @property
    def id(self) -> str:
        """Access token's SHA-256 hashed JWT signature"""
        return self._inner_dict.get('id')  # type: ignore
    
    @id.setter
    def id(self, value: str) -> None:
        self._inner_dict['id'] = value
    
    
class DataHubIngestionSourceKeyClass(_Aspect):
    """Key for a DataHub ingestion source"""


    ASPECT_NAME = 'dataHubIngestionSourceKey'
    ASPECT_INFO = {'keyForEntity': 'dataHubIngestionSource', 'entityCategory': 'internal', 'entityAspects': ['dataHubIngestionSourceInfo']}
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.metadata.key.DataHubIngestionSourceKey")

    def __init__(self,
        id: str,
    ):
        super().__init__()
        
        self.id = id
    
    def _restore_defaults(self) -> None:
        self.id = str()
    
    
    @property
    def id(self) -> str:
        """A unique id for the Ingestion Source, either generated or provided"""
        return self._inner_dict.get('id')  # type: ignore
    
    @id.setter
    def id(self, value: str) -> None:
        self._inner_dict['id'] = value
    
    
class DataHubPolicyKeyClass(_Aspect):
    """Key for a DataHub Policy"""


    ASPECT_NAME = 'dataHubPolicyKey'
    ASPECT_INFO = {'keyForEntity': 'dataHubPolicy', 'entityCategory': 'internal', 'entityAspects': ['dataHubPolicyInfo'], 'entityDoc': 'DataHub Policies represent access policies granted to users or groups on metadata operations like edit, view etc.'}
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.metadata.key.DataHubPolicyKey")

    def __init__(self,
        id: str,
    ):
        super().__init__()
        
        self.id = id
    
    def _restore_defaults(self) -> None:
        self.id = str()
    
    
    @property
    def id(self) -> str:
        """A unique id for the DataHub access policy record. Generated on the server side at policy creation time."""
        return self._inner_dict.get('id')  # type: ignore
    
    @id.setter
    def id(self, value: str) -> None:
        self._inner_dict['id'] = value
    
    
class DataHubRetentionKeyClass(_Aspect):
    """Key for a DataHub Retention"""


    ASPECT_NAME = 'dataHubRetentionKey'
    ASPECT_INFO = {'keyForEntity': 'dataHubRetention', 'entityCategory': 'internal', 'entityAspects': ['dataHubRetentionConfig']}
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.metadata.key.DataHubRetentionKey")

    def __init__(self,
        entityName: str,
        aspectName: str,
    ):
        super().__init__()
        
        self.entityName = entityName
        self.aspectName = aspectName
    
    def _restore_defaults(self) -> None:
        self.entityName = str()
        self.aspectName = str()
    
    
    @property
    def entityName(self) -> str:
        """Entity name to apply retention to. * (or empty) for applying defaults."""
        return self._inner_dict.get('entityName')  # type: ignore
    
    @entityName.setter
    def entityName(self, value: str) -> None:
        self._inner_dict['entityName'] = value
    
    
    @property
    def aspectName(self) -> str:
        """Aspect name to apply retention to. * (or empty) for applying defaults."""
        return self._inner_dict.get('aspectName')  # type: ignore
    
    @aspectName.setter
    def aspectName(self, value: str) -> None:
        self._inner_dict['aspectName'] = value
    
    
class DataHubRoleKeyClass(_Aspect):
    """Key for a DataHub Role"""


    ASPECT_NAME = 'dataHubRoleKey'
    ASPECT_INFO = {'keyForEntity': 'dataHubRole', 'entityCategory': 'core', 'entityAspects': ['dataHubRoleInfo']}
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.metadata.key.DataHubRoleKey")

    def __init__(self,
        id: str,
    ):
        super().__init__()
        
        self.id = id
    
    def _restore_defaults(self) -> None:
        self.id = str()
    
    
    @property
    def id(self) -> str:
        """A unique id for the DataHub role record. Generated on the server side at role creation time."""
        return self._inner_dict.get('id')  # type: ignore
    
    @id.setter
    def id(self, value: str) -> None:
        self._inner_dict['id'] = value
    
    
class DataHubSecretKeyClass(_Aspect):
    """Key for a DataHub Secret"""


    ASPECT_NAME = 'dataHubSecretKey'
    ASPECT_INFO = {'keyForEntity': 'dataHubSecret', 'entityCategory': 'internal', 'entityAspects': ['dataHubSecretValue']}
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.metadata.key.DataHubSecretKey")

    def __init__(self,
        id: str,
    ):
        super().__init__()
        
        self.id = id
    
    def _restore_defaults(self) -> None:
        self.id = str()
    
    
    @property
    def id(self) -> str:
        """A unique id for the Secret"""
        return self._inner_dict.get('id')  # type: ignore
    
    @id.setter
    def id(self, value: str) -> None:
        self._inner_dict['id'] = value
    
    
class DataHubStepStateKeyClass(_Aspect):
    """Key for a DataHub Step State"""


    ASPECT_NAME = 'dataHubStepStateKey'
    ASPECT_INFO = {'keyForEntity': 'dataHubStepState', 'entityCategory': 'internal', 'entityAspects': ['dataHubStepStateProperties']}
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.metadata.key.DataHubStepStateKey")

    def __init__(self,
        id: str,
    ):
        super().__init__()
        
        self.id = id
    
    def _restore_defaults(self) -> None:
        self.id = str()
    
    
    @property
    def id(self) -> str:
        """A unique id for the state"""
        return self._inner_dict.get('id')  # type: ignore
    
    @id.setter
    def id(self, value: str) -> None:
        self._inner_dict['id'] = value
    
    
class DataHubUpgradeKeyClass(_Aspect):
    """Key for a DataHubUpgrade"""


    ASPECT_NAME = 'dataHubUpgradeKey'
    ASPECT_INFO = {'keyForEntity': 'dataHubUpgrade', 'entityCategory': 'internal', 'entityAspects': ['dataHubUpgradeRequest', 'dataHubUpgradeResult']}
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.metadata.key.DataHubUpgradeKey")

    def __init__(self,
        id: str,
    ):
        super().__init__()
        
        self.id = id
    
    def _restore_defaults(self) -> None:
        self.id = str()
    
    
    @property
    def id(self) -> str:
        # No docs available.
        return self._inner_dict.get('id')  # type: ignore
    
    @id.setter
    def id(self, value: str) -> None:
        self._inner_dict['id'] = value
    
    
class DataHubViewKeyClass(_Aspect):
    """Key for a DataHub View"""


    ASPECT_NAME = 'dataHubViewKey'
    ASPECT_INFO = {'keyForEntity': 'dataHubView', 'entityCategory': 'core', 'entityAspects': ['dataHubViewInfo']}
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.metadata.key.DataHubViewKey")

    def __init__(self,
        id: str,
    ):
        super().__init__()
        
        self.id = id
    
    def _restore_defaults(self) -> None:
        self.id = str()
    
    
    @property
    def id(self) -> str:
        """A unique id for the View"""
        return self._inner_dict.get('id')  # type: ignore
    
    @id.setter
    def id(self, value: str) -> None:
        self._inner_dict['id'] = value
    
    
class DataJobKeyClass(_Aspect):
    """Key for a Data Job"""


    ASPECT_NAME = 'dataJobKey'
    ASPECT_INFO = {'keyForEntity': 'dataJob', 'entityCategory': '_unset_', 'entityAspects': ['datahubIngestionRunSummary', 'datahubIngestionCheckpoint', 'domains', 'deprecation', 'versionInfo', 'dataJobInfo', 'dataJobInputOutput', 'editableDataJobProperties', 'ownership', 'status', 'globalTags', 'browsePaths', 'glossaryTerms', 'institutionalMemory', 'dataPlatformInstance', 'browsePathsV2', 'structuredProperties', 'forms', 'subTypes', 'incidentsSummary']}
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.metadata.key.DataJobKey")

    def __init__(self,
        flow: str,
        jobId: str,
    ):
        super().__init__()
        
        self.flow = flow
        self.jobId = jobId
    
    def _restore_defaults(self) -> None:
        self.flow = str()
        self.jobId = str()
    
    
    @property
    def flow(self) -> str:
        """Standardized data processing flow urn representing the flow for the job"""
        return self._inner_dict.get('flow')  # type: ignore
    
    @flow.setter
    def flow(self, value: str) -> None:
        self._inner_dict['flow'] = value
    
    
    @property
    def jobId(self) -> str:
        """Unique Identifier of the data job"""
        return self._inner_dict.get('jobId')  # type: ignore
    
    @jobId.setter
    def jobId(self, value: str) -> None:
        self._inner_dict['jobId'] = value
    
    
class DataPlatformInstanceKeyClass(_Aspect):
    """Key for a Dataset"""


    ASPECT_NAME = 'dataPlatformInstanceKey'
    ASPECT_INFO = {'keyForEntity': 'dataPlatformInstance', 'entityCategory': 'internal', 'entityAspects': ['dataPlatformInstanceProperties', 'ownership', 'globalTags', 'institutionalMemory', 'deprecation', 'status']}
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.metadata.key.DataPlatformInstanceKey")

    def __init__(self,
        platform: str,
        instance: str,
    ):
        super().__init__()
        
        self.platform = platform
        self.instance = instance
    
    def _restore_defaults(self) -> None:
        self.platform = str()
        self.instance = str()
    
    
    @property
    def platform(self) -> str:
        """Data platform urn associated with the instance"""
        return self._inner_dict.get('platform')  # type: ignore
    
    @platform.setter
    def platform(self, value: str) -> None:
        self._inner_dict['platform'] = value
    
    
    @property
    def instance(self) -> str:
        """Unique instance id"""
        return self._inner_dict.get('instance')  # type: ignore
    
    @instance.setter
    def instance(self, value: str) -> None:
        self._inner_dict['instance'] = value
    
    
class DataPlatformKeyClass(_Aspect):
    """Key for a Data Platform"""


    ASPECT_NAME = 'dataPlatformKey'
    ASPECT_INFO = {'keyForEntity': 'dataPlatform', 'entityCategory': 'core', 'entityAspects': ['dataPlatformInfo']}
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.metadata.key.DataPlatformKey")

    def __init__(self,
        platformName: str,
    ):
        super().__init__()
        
        self.platformName = platformName
    
    def _restore_defaults(self) -> None:
        self.platformName = str()
    
    
    @property
    def platformName(self) -> str:
        """Data platform name i.e. hdfs, oracle, espresso"""
        return self._inner_dict.get('platformName')  # type: ignore
    
    @platformName.setter
    def platformName(self, value: str) -> None:
        self._inner_dict['platformName'] = value
    
    
class DataProcessInstanceKeyClass(_Aspect):
    """Key for an Asset DataProcessInstance"""


    ASPECT_NAME = 'dataProcessInstanceKey'
    ASPECT_INFO = {'keyForEntity': 'dataProcessInstance', 'entityCategory': '_unset_', 'entityAspects': ['dataProcessInstanceInput', 'dataProcessInstanceOutput', 'dataProcessInstanceProperties', 'dataProcessInstanceRelationships', 'dataProcessInstanceRunEvent'], 'entityDoc': 'DataProcessInstance represents an instance of a datajob/jobflow run'}
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.metadata.key.DataProcessInstanceKey")

    def __init__(self,
        id: str,
    ):
        super().__init__()
        
        self.id = id
    
    def _restore_defaults(self) -> None:
        self.id = str()
    
    
    @property
    def id(self) -> str:
        """A unique id for the DataProcessInstance . Should be separate from the name used for displaying a DataProcessInstance."""
        return self._inner_dict.get('id')  # type: ignore
    
    @id.setter
    def id(self, value: str) -> None:
        self._inner_dict['id'] = value
    
    
class DataProcessKeyClass(_Aspect):
    """Key for a Data Process"""


    ASPECT_NAME = 'dataProcessKey'
    ASPECT_INFO = {'keyForEntity': 'dataProcess', 'entityCategory': '_unset_', 'entityAspects': ['dataProcessInfo', 'ownership', 'status']}
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.metadata.key.DataProcessKey")

    def __init__(self,
        name: str,
        orchestrator: str,
        origin: Union[str, "FabricTypeClass"],
    ):
        super().__init__()
        
        self.name = name
        self.orchestrator = orchestrator
        self.origin = origin
    
    def _restore_defaults(self) -> None:
        self.name = str()
        self.orchestrator = str()
        self.origin = FabricTypeClass.DEV
    
    
    @property
    def name(self) -> str:
        """Process name i.e. an ETL job name"""
        return self._inner_dict.get('name')  # type: ignore
    
    @name.setter
    def name(self, value: str) -> None:
        self._inner_dict['name'] = value
    
    
    @property
    def orchestrator(self) -> str:
        """Standardized Orchestrator where data process is defined.
    TODO: Migrate towards something that can be validated like DataPlatform urn"""
        return self._inner_dict.get('orchestrator')  # type: ignore
    
    @orchestrator.setter
    def orchestrator(self, value: str) -> None:
        self._inner_dict['orchestrator'] = value
    
    
    @property
    def origin(self) -> Union[str, "FabricTypeClass"]:
        """Fabric type where dataset belongs to or where it was generated."""
        return self._inner_dict.get('origin')  # type: ignore
    
    @origin.setter
    def origin(self, value: Union[str, "FabricTypeClass"]) -> None:
        self._inner_dict['origin'] = value
    
    
class DatasetKeyClass(_Aspect):
    """Key for a Dataset"""


    ASPECT_NAME = 'datasetKey'
    ASPECT_INFO = {'keyForEntity': 'dataset', 'entityCategory': 'core', 'entityAspects': ['viewProperties', 'subTypes', 'datasetProfile', 'datasetUsageStatistics', 'operation', 'domains', 'schemaMetadata', 'status', 'container', 'deprecation', 'testResults', 'siblings', 'embed', 'incidentsSummary', 'datasetProperties', 'editableDatasetProperties', 'datasetDeprecation', 'datasetUpstreamLineage', 'upstreamLineage', 'institutionalMemory', 'ownership', 'editableSchemaMetadata', 'globalTags', 'glossaryTerms', 'browsePaths', 'dataPlatformInstance', 'browsePathsV2', 'access', 'structuredProperties', 'forms'], 'entityDoc': 'Datasets represent logical or physical data assets stored or represented in various data platforms. Tables, Views, Streams are all instances of datasets.'}
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.metadata.key.DatasetKey")

    def __init__(self,
        platform: str,
        name: str,
        origin: Union[str, "FabricTypeClass"],
    ):
        super().__init__()
        
        self.platform = platform
        self.name = name
        self.origin = origin
    
    def _restore_defaults(self) -> None:
        self.platform = str()
        self.name = str()
        self.origin = FabricTypeClass.DEV
    
    
    @property
    def platform(self) -> str:
        """Data platform urn associated with the dataset"""
        return self._inner_dict.get('platform')  # type: ignore
    
    @platform.setter
    def platform(self, value: str) -> None:
        self._inner_dict['platform'] = value
    
    
    @property
    def name(self) -> str:
        """Unique guid for dataset"""
        return self._inner_dict.get('name')  # type: ignore
    
    @name.setter
    def name(self, value: str) -> None:
        self._inner_dict['name'] = value
    
    
    @property
    def origin(self) -> Union[str, "FabricTypeClass"]:
        """Fabric type where dataset belongs to or where it was generated."""
        return self._inner_dict.get('origin')  # type: ignore
    
    @origin.setter
    def origin(self, value: Union[str, "FabricTypeClass"]) -> None:
        self._inner_dict['origin'] = value
    
    
class DomainKeyClass(_Aspect):
    """Key for an Asset Domain"""


    ASPECT_NAME = 'domainKey'
    ASPECT_INFO = {'keyForEntity': 'domain', 'entityCategory': 'core', 'entityAspects': ['domainProperties', 'institutionalMemory', 'ownership', 'structuredProperties', 'forms'], 'entityDoc': 'A data domain within an organization.'}
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.metadata.key.DomainKey")

    def __init__(self,
        id: str,
    ):
        super().__init__()
        
        self.id = id
    
    def _restore_defaults(self) -> None:
        self.id = str()
    
    
    @property
    def id(self) -> str:
        """A unique id for the domain. Should be separate from the name used for displaying a Domain."""
        return self._inner_dict.get('id')  # type: ignore
    
    @id.setter
    def id(self, value: str) -> None:
        self._inner_dict['id'] = value
    
    
class ExecutionRequestKeyClass(_Aspect):
    """Key for an DataHub Execution Request"""


    ASPECT_NAME = 'dataHubExecutionRequestKey'
    ASPECT_INFO = {'keyForEntity': 'dataHubExecutionRequest', 'entityCategory': 'internal', 'entityAspects': ['dataHubExecutionRequestInput', 'dataHubExecutionRequestSignal', 'dataHubExecutionRequestResult']}
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.metadata.key.ExecutionRequestKey")

    def __init__(self,
        id: str,
    ):
        super().__init__()
        
        self.id = id
    
    def _restore_defaults(self) -> None:
        self.id = str()
    
    
    @property
    def id(self) -> str:
        """A unique id for the DataHub execution request."""
        return self._inner_dict.get('id')  # type: ignore
    
    @id.setter
    def id(self, value: str) -> None:
        self._inner_dict['id'] = value
    
    
class FormKeyClass(_Aspect):
    """Key for a Form"""


    ASPECT_NAME = 'formKey'
    ASPECT_INFO = {'keyForEntity': 'form', 'entityCategory': 'core', 'entityAspects': ['formInfo', 'dynamicFormAssignment', 'ownership']}
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.metadata.key.FormKey")

    def __init__(self,
        id: str,
    ):
        super().__init__()
        
        self.id = id
    
    def _restore_defaults(self) -> None:
        self.id = str()
    
    
    @property
    def id(self) -> str:
        """Unique id for the form."""
        return self._inner_dict.get('id')  # type: ignore
    
    @id.setter
    def id(self, value: str) -> None:
        self._inner_dict['id'] = value
    
    
class GlobalSettingsKeyClass(_Aspect):
    """Key for a Global Settings"""


    ASPECT_NAME = 'globalSettingsKey'
    ASPECT_INFO = {'keyForEntity': 'globalSettings', 'entityCategory': 'internal', 'entityAspects': ['globalSettingsInfo'], 'entityDoc': 'Global settings for an the platform'}
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.metadata.key.GlobalSettingsKey")

    def __init__(self,
        id: str,
    ):
        super().__init__()
        
        self.id = id
    
    def _restore_defaults(self) -> None:
        self.id = str()
    
    
    @property
    def id(self) -> str:
        """Id for the settings. There should be only 1 global settings urn: urn:li:globalSettings:0"""
        return self._inner_dict.get('id')  # type: ignore
    
    @id.setter
    def id(self, value: str) -> None:
        self._inner_dict['id'] = value
    
    
class GlossaryNodeKeyClass(_Aspect):
    """Key for a GlossaryNode"""


    ASPECT_NAME = 'glossaryNodeKey'
    ASPECT_INFO = {'keyForEntity': 'glossaryNode', 'entityCategory': 'core', 'entityAspects': ['glossaryNodeInfo', 'institutionalMemory', 'ownership', 'status', 'structuredProperties', 'forms']}
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.metadata.key.GlossaryNodeKey")

    def __init__(self,
        name: str,
    ):
        super().__init__()
        
        self.name = name
    
    def _restore_defaults(self) -> None:
        self.name = str()
    
    
    @property
    def name(self) -> str:
        # No docs available.
        return self._inner_dict.get('name')  # type: ignore
    
    @name.setter
    def name(self, value: str) -> None:
        self._inner_dict['name'] = value
    
    
class GlossaryTermKeyClass(_Aspect):
    """Key for a GlossaryTerm"""


    ASPECT_NAME = 'glossaryTermKey'
    ASPECT_INFO = {'keyForEntity': 'glossaryTerm', 'entityCategory': 'core', 'entityAspects': ['glossaryTermInfo', 'glossaryRelatedTerms', 'institutionalMemory', 'schemaMetadata', 'ownership', 'deprecation', 'domains', 'status', 'browsePaths', 'structuredProperties', 'forms']}
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.metadata.key.GlossaryTermKey")

    def __init__(self,
        name: str,
    ):
        super().__init__()
        
        self.name = name
    
    def _restore_defaults(self) -> None:
        self.name = str()
    
    
    @property
    def name(self) -> str:
        """The term name, which serves as a unique id"""
        return self._inner_dict.get('name')  # type: ignore
    
    @name.setter
    def name(self, value: str) -> None:
        self._inner_dict['name'] = value
    
    
class IncidentKeyClass(_Aspect):
    """Key for an asset Incident"""


    ASPECT_NAME = 'incidentKey'
    ASPECT_INFO = {'keyForEntity': 'incident', 'entityCategory': 'core', 'entityAspects': ['incidentInfo'], 'entityDoc': 'An incident for an asset.'}
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.metadata.key.IncidentKey")

    def __init__(self,
        id: str,
    ):
        super().__init__()
        
        self.id = id
    
    def _restore_defaults(self) -> None:
        self.id = str()
    
    
    @property
    def id(self) -> str:
        """A unique id for the incident. Generated on the server side at incident creation time."""
        return self._inner_dict.get('id')  # type: ignore
    
    @id.setter
    def id(self, value: str) -> None:
        self._inner_dict['id'] = value
    
    
class InviteTokenKeyClass(_Aspect):
    """Key for an InviteToken."""


    ASPECT_NAME = 'inviteTokenKey'
    ASPECT_INFO = {'keyForEntity': 'inviteToken', 'entityCategory': 'internal', 'entityAspects': ['inviteToken']}
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.metadata.key.InviteTokenKey")

    def __init__(self,
        id: str,
    ):
        super().__init__()
        
        self.id = id
    
    def _restore_defaults(self) -> None:
        self.id = str()
    
    
    @property
    def id(self) -> str:
        """A unique id for the invite token."""
        return self._inner_dict.get('id')  # type: ignore
    
    @id.setter
    def id(self, value: str) -> None:
        self._inner_dict['id'] = value
    
    
class MLFeatureKeyClass(_Aspect):
    """Key for an MLFeature"""


    ASPECT_NAME = 'mlFeatureKey'
    ASPECT_INFO = {'keyForEntity': 'mlFeature', 'entityCategory': 'core', 'entityAspects': ['glossaryTerms', 'editableMlFeatureProperties', 'domains', 'mlFeatureProperties', 'ownership', 'institutionalMemory', 'status', 'deprecation', 'browsePaths', 'globalTags', 'dataPlatformInstance', 'browsePathsV2', 'structuredProperties', 'forms']}
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.metadata.key.MLFeatureKey")

    def __init__(self,
        featureNamespace: str,
        name: str,
    ):
        super().__init__()
        
        self.featureNamespace = featureNamespace
        self.name = name
    
    def _restore_defaults(self) -> None:
        self.featureNamespace = str()
        self.name = str()
    
    
    @property
    def featureNamespace(self) -> str:
        """Namespace for the feature"""
        return self._inner_dict.get('featureNamespace')  # type: ignore
    
    @featureNamespace.setter
    def featureNamespace(self, value: str) -> None:
        self._inner_dict['featureNamespace'] = value
    
    
    @property
    def name(self) -> str:
        """Name of the feature"""
        return self._inner_dict.get('name')  # type: ignore
    
    @name.setter
    def name(self, value: str) -> None:
        self._inner_dict['name'] = value
    
    
class MLFeatureTableKeyClass(_Aspect):
    """Key for an MLFeatureTable"""


    ASPECT_NAME = 'mlFeatureTableKey'
    ASPECT_INFO = {'keyForEntity': 'mlFeatureTable', 'entityCategory': 'core', 'entityAspects': ['glossaryTerms', 'editableMlFeatureTableProperties', 'domains', 'mlFeatureTableProperties', 'ownership', 'institutionalMemory', 'status', 'deprecation', 'browsePaths', 'globalTags', 'dataPlatformInstance', 'browsePathsV2', 'structuredProperties', 'forms']}
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.metadata.key.MLFeatureTableKey")

    def __init__(self,
        platform: str,
        name: str,
    ):
        super().__init__()
        
        self.platform = platform
        self.name = name
    
    def _restore_defaults(self) -> None:
        self.platform = str()
        self.name = str()
    
    
    @property
    def platform(self) -> str:
        """Data platform urn associated with the feature table"""
        return self._inner_dict.get('platform')  # type: ignore
    
    @platform.setter
    def platform(self, value: str) -> None:
        self._inner_dict['platform'] = value
    
    
    @property
    def name(self) -> str:
        """Name of the feature table"""
        return self._inner_dict.get('name')  # type: ignore
    
    @name.setter
    def name(self, value: str) -> None:
        self._inner_dict['name'] = value
    
    
class MLModelDeploymentKeyClass(_Aspect):
    """Key for an ML model deployment"""


    ASPECT_NAME = 'mlModelDeploymentKey'
    ASPECT_INFO = {'keyForEntity': 'mlModelDeployment', 'entityCategory': 'core', 'entityAspects': ['mlModelDeploymentProperties', 'ownership', 'status', 'deprecation', 'globalTags', 'dataPlatformInstance']}
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.metadata.key.MLModelDeploymentKey")

    def __init__(self,
        platform: str,
        name: str,
        origin: Union[str, "FabricTypeClass"],
    ):
        super().__init__()
        
        self.platform = platform
        self.name = name
        self.origin = origin
    
    def _restore_defaults(self) -> None:
        self.platform = str()
        self.name = str()
        self.origin = FabricTypeClass.DEV
    
    
    @property
    def platform(self) -> str:
        """Standardized platform urn for the model Deployment"""
        return self._inner_dict.get('platform')  # type: ignore
    
    @platform.setter
    def platform(self, value: str) -> None:
        self._inner_dict['platform'] = value
    
    
    @property
    def name(self) -> str:
        """Name of the MLModelDeployment"""
        return self._inner_dict.get('name')  # type: ignore
    
    @name.setter
    def name(self, value: str) -> None:
        self._inner_dict['name'] = value
    
    
    @property
    def origin(self) -> Union[str, "FabricTypeClass"]:
        """Fabric type where model Deployment belongs to or where it was generated"""
        return self._inner_dict.get('origin')  # type: ignore
    
    @origin.setter
    def origin(self, value: Union[str, "FabricTypeClass"]) -> None:
        self._inner_dict['origin'] = value
    
    
class MLModelGroupKeyClass(_Aspect):
    """Key for an ML model group"""


    ASPECT_NAME = 'mlModelGroupKey'
    ASPECT_INFO = {'keyForEntity': 'mlModelGroup', 'entityCategory': 'core', 'entityAspects': ['glossaryTerms', 'editableMlModelGroupProperties', 'domains', 'mlModelGroupProperties', 'ownership', 'status', 'deprecation', 'browsePaths', 'globalTags', 'dataPlatformInstance', 'browsePathsV2', 'structuredProperties', 'forms']}
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.metadata.key.MLModelGroupKey")

    def __init__(self,
        platform: str,
        name: str,
        origin: Union[str, "FabricTypeClass"],
    ):
        super().__init__()
        
        self.platform = platform
        self.name = name
        self.origin = origin
    
    def _restore_defaults(self) -> None:
        self.platform = str()
        self.name = str()
        self.origin = FabricTypeClass.DEV
    
    
    @property
    def platform(self) -> str:
        """Standardized platform urn for the model group"""
        return self._inner_dict.get('platform')  # type: ignore
    
    @platform.setter
    def platform(self, value: str) -> None:
        self._inner_dict['platform'] = value
    
    
    @property
    def name(self) -> str:
        """Name of the MLModelGroup"""
        return self._inner_dict.get('name')  # type: ignore
    
    @name.setter
    def name(self, value: str) -> None:
        self._inner_dict['name'] = value
    
    
    @property
    def origin(self) -> Union[str, "FabricTypeClass"]:
        """Fabric type where model group belongs to or where it was generated"""
        return self._inner_dict.get('origin')  # type: ignore
    
    @origin.setter
    def origin(self, value: Union[str, "FabricTypeClass"]) -> None:
        self._inner_dict['origin'] = value
    
    
class MLModelKeyClass(_Aspect):
    """Key for an ML model"""


    ASPECT_NAME = 'mlModelKey'
    ASPECT_INFO = {'keyForEntity': 'mlModel', 'entityCategory': 'core', 'entityAspects': ['glossaryTerms', 'editableMlModelProperties', 'domains', 'ownership', 'mlModelProperties', 'intendedUse', 'mlModelFactorPrompts', 'mlModelMetrics', 'mlModelEvaluationData', 'mlModelTrainingData', 'mlModelQuantitativeAnalyses', 'mlModelEthicalConsiderations', 'mlModelCaveatsAndRecommendations', 'institutionalMemory', 'sourceCode', 'status', 'cost', 'deprecation', 'browsePaths', 'globalTags', 'dataPlatformInstance', 'browsePathsV2', 'structuredProperties', 'forms']}
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.metadata.key.MLModelKey")

    def __init__(self,
        platform: str,
        name: str,
        origin: Union[str, "FabricTypeClass"],
    ):
        super().__init__()
        
        self.platform = platform
        self.name = name
        self.origin = origin
    
    def _restore_defaults(self) -> None:
        self.platform = str()
        self.name = str()
        self.origin = FabricTypeClass.DEV
    
    
    @property
    def platform(self) -> str:
        """Standardized platform urn for the model"""
        return self._inner_dict.get('platform')  # type: ignore
    
    @platform.setter
    def platform(self, value: str) -> None:
        self._inner_dict['platform'] = value
    
    
    @property
    def name(self) -> str:
        """Name of the MLModel"""
        return self._inner_dict.get('name')  # type: ignore
    
    @name.setter
    def name(self, value: str) -> None:
        self._inner_dict['name'] = value
    
    
    @property
    def origin(self) -> Union[str, "FabricTypeClass"]:
        """Fabric type where model belongs to or where it was generated"""
        return self._inner_dict.get('origin')  # type: ignore
    
    @origin.setter
    def origin(self, value: Union[str, "FabricTypeClass"]) -> None:
        self._inner_dict['origin'] = value
    
    
class MLPrimaryKeyKeyClass(_Aspect):
    """Key for an MLPrimaryKey"""


    ASPECT_NAME = 'mlPrimaryKeyKey'
    ASPECT_INFO = {'keyForEntity': 'mlPrimaryKey', 'entityCategory': 'core', 'entityAspects': ['glossaryTerms', 'editableMlPrimaryKeyProperties', 'domains', 'mlPrimaryKeyProperties', 'ownership', 'institutionalMemory', 'status', 'deprecation', 'globalTags', 'dataPlatformInstance', 'structuredProperties', 'forms']}
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.metadata.key.MLPrimaryKeyKey")

    def __init__(self,
        featureNamespace: str,
        name: str,
    ):
        super().__init__()
        
        self.featureNamespace = featureNamespace
        self.name = name
    
    def _restore_defaults(self) -> None:
        self.featureNamespace = str()
        self.name = str()
    
    
    @property
    def featureNamespace(self) -> str:
        """Namespace for the primary key"""
        return self._inner_dict.get('featureNamespace')  # type: ignore
    
    @featureNamespace.setter
    def featureNamespace(self, value: str) -> None:
        self._inner_dict['featureNamespace'] = value
    
    
    @property
    def name(self) -> str:
        """Name of the primary key"""
        return self._inner_dict.get('name')  # type: ignore
    
    @name.setter
    def name(self, value: str) -> None:
        self._inner_dict['name'] = value
    
    
class NotebookKeyClass(_Aspect):
    """Key for a Notebook"""


    ASPECT_NAME = 'notebookKey'
    ASPECT_INFO = {'keyForEntity': 'notebook', 'entityCategory': '_unset_', 'entityAspects': ['notebookInfo', 'notebookContent', 'editableNotebookProperties', 'ownership', 'status', 'globalTags', 'glossaryTerms', 'browsePaths', 'institutionalMemory', 'domains', 'subTypes', 'dataPlatformInstance', 'browsePathsV2'], 'entityDoc': 'Notebook represents a combination of query, text, chart and etc. This is in BETA version'}
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.metadata.key.NotebookKey")

    def __init__(self,
        notebookTool: str,
        notebookId: str,
    ):
        super().__init__()
        
        self.notebookTool = notebookTool
        self.notebookId = notebookId
    
    def _restore_defaults(self) -> None:
        self.notebookTool = str()
        self.notebookId = str()
    
    
    @property
    def notebookTool(self) -> str:
        """The name of the Notebook tool such as QueryBook, etc."""
        return self._inner_dict.get('notebookTool')  # type: ignore
    
    @notebookTool.setter
    def notebookTool(self, value: str) -> None:
        self._inner_dict['notebookTool'] = value
    
    
    @property
    def notebookId(self) -> str:
        """Unique id for the Notebook. This id should be globally unique for a Notebook tool even when there are multiple deployments of it. As an example, Notebook URL could be used here for QueryBook such as 'querybook.com/notebook/773'"""
        return self._inner_dict.get('notebookId')  # type: ignore
    
    @notebookId.setter
    def notebookId(self, value: str) -> None:
        self._inner_dict['notebookId'] = value
    
    
class OwnershipTypeKeyClass(_Aspect):
    """Key for a Ownership Type"""


    ASPECT_NAME = 'ownershipTypeKey'
    ASPECT_INFO = {'keyForEntity': 'ownershipType', 'entityCategory': 'core', 'entityAspects': ['ownershipTypeInfo', 'status'], 'entityDoc': 'Ownership Type represents a user-created ownership category for a person or group who is responsible for an asset.'}
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.metadata.key.OwnershipTypeKey")

    def __init__(self,
        id: str,
    ):
        super().__init__()
        
        self.id = id
    
    def _restore_defaults(self) -> None:
        self.id = str()
    
    
    @property
    def id(self) -> str:
        """Unique ID for the data ownership type name i.e. Business Owner, Data Steward, Technical Owner, etc..
    Should be separate from the name used for displaying an Ownership Type."""
        return self._inner_dict.get('id')  # type: ignore
    
    @id.setter
    def id(self, value: str) -> None:
        self._inner_dict['id'] = value
    
    
class PostKeyClass(_Aspect):
    """Key for a Post."""


    ASPECT_NAME = 'postKey'
    ASPECT_INFO = {'keyForEntity': 'post', 'entityCategory': 'core', 'entityAspects': ['postInfo']}
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.metadata.key.PostKey")

    def __init__(self,
        id: str,
    ):
        super().__init__()
        
        self.id = id
    
    def _restore_defaults(self) -> None:
        self.id = str()
    
    
    @property
    def id(self) -> str:
        """A unique id for the DataHub Post record. Generated on the server side at Post creation time."""
        return self._inner_dict.get('id')  # type: ignore
    
    @id.setter
    def id(self, value: str) -> None:
        self._inner_dict['id'] = value
    
    
class QueryKeyClass(_Aspect):
    """Key for a Query"""


    ASPECT_NAME = 'queryKey'
    ASPECT_INFO = {'keyForEntity': 'query', 'entityCategory': 'core', 'entityAspects': ['queryProperties', 'querySubjects', 'status', 'dataPlatformInstance', 'subTypes']}
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.metadata.key.QueryKey")

    def __init__(self,
        id: str,
    ):
        super().__init__()
        
        self.id = id
    
    def _restore_defaults(self) -> None:
        self.id = str()
    
    
    @property
    def id(self) -> str:
        """A unique id for the Query."""
        return self._inner_dict.get('id')  # type: ignore
    
    @id.setter
    def id(self, value: str) -> None:
        self._inner_dict['id'] = value
    
    
class RoleKeyClass(_Aspect):
    """Key for a External AccessManagement"""


    ASPECT_NAME = 'roleKey'
    ASPECT_INFO = {'keyForEntity': 'role', 'entityCategory': 'core', 'entityAspects': ['roleProperties', 'actors']}
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.metadata.key.RoleKey")

    def __init__(self,
        id: str,
    ):
        super().__init__()
        
        self.id = id
    
    def _restore_defaults(self) -> None:
        self.id = str()
    
    
    @property
    def id(self) -> str:
        """A unique id for the access management IAM."""
        return self._inner_dict.get('id')  # type: ignore
    
    @id.setter
    def id(self, value: str) -> None:
        self._inner_dict['id'] = value
    
    
class SchemaFieldKeyClass(_Aspect):
    """Key for a SchemaField"""


    ASPECT_NAME = 'schemaFieldKey'
    ASPECT_INFO = {'keyForEntity': 'schemaField', 'entityCategory': 'core', 'entityAspects': ['structuredProperties', 'forms']}
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.metadata.key.SchemaFieldKey")

    def __init__(self,
        parent: str,
        fieldPath: str,
    ):
        super().__init__()
        
        self.parent = parent
        self.fieldPath = fieldPath
    
    def _restore_defaults(self) -> None:
        self.parent = str()
        self.fieldPath = str()
    
    
    @property
    def parent(self) -> str:
        """Parent associated with the schema field"""
        return self._inner_dict.get('parent')  # type: ignore
    
    @parent.setter
    def parent(self, value: str) -> None:
        self._inner_dict['parent'] = value
    
    
    @property
    def fieldPath(self) -> str:
        """fieldPath identifying the schema field"""
        return self._inner_dict.get('fieldPath')  # type: ignore
    
    @fieldPath.setter
    def fieldPath(self, value: str) -> None:
        self._inner_dict['fieldPath'] = value
    
    
class TagKeyClass(_Aspect):
    """Key for a Tag"""


    ASPECT_NAME = 'tagKey'
    ASPECT_INFO = {'keyForEntity': 'tag', 'entityCategory': 'core', 'entityAspects': ['tagProperties', 'ownership', 'deprecation', 'status']}
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.metadata.key.TagKey")

    def __init__(self,
        name: str,
    ):
        super().__init__()
        
        self.name = name
    
    def _restore_defaults(self) -> None:
        self.name = str()
    
    
    @property
    def name(self) -> str:
        """The tag name, which serves as a unique id"""
        return self._inner_dict.get('name')  # type: ignore
    
    @name.setter
    def name(self, value: str) -> None:
        self._inner_dict['name'] = value
    
    
class TelemetryKeyClass(_Aspect):
    """Key for the telemetry client ID, only one should ever exist"""


    ASPECT_NAME = 'telemetryKey'
    ASPECT_INFO = {'keyForEntity': 'telemetry', 'entityCategory': 'internal', 'entityAspects': ['telemetryClientId']}
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.metadata.key.TelemetryKey")

    def __init__(self,
        name: str,
    ):
        super().__init__()
        
        self.name = name
    
    def _restore_defaults(self) -> None:
        self.name = str()
    
    
    @property
    def name(self) -> str:
        """The telemetry entity name, which serves as a unique id"""
        return self._inner_dict.get('name')  # type: ignore
    
    @name.setter
    def name(self, value: str) -> None:
        self._inner_dict['name'] = value
    
    
class TestKeyClass(_Aspect):
    """Key for a Test"""


    ASPECT_NAME = 'testKey'
    ASPECT_INFO = {'keyForEntity': 'test', 'entityCategory': 'core', 'entityAspects': ['testInfo'], 'entityDoc': 'A DataHub test'}
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.metadata.key.TestKey")

    def __init__(self,
        id: str,
    ):
        super().__init__()
        
        self.id = id
    
    def _restore_defaults(self) -> None:
        self.id = str()
    
    
    @property
    def id(self) -> str:
        """Unique id for the test"""
        return self._inner_dict.get('id')  # type: ignore
    
    @id.setter
    def id(self, value: str) -> None:
        self._inner_dict['id'] = value
    
    
class ConditionClass(object):
    """The matching condition in a filter criterion"""
    
    CONTAIN = "CONTAIN"
    """Represent the relation: String field contains value, e.g. name contains Profile"""
    
    END_WITH = "END_WITH"
    """Represent the relation: String field ends with value, e.g. name ends with Event"""
    
    EQUAL = "EQUAL"
    """Represent the relation: field = value, e.g. platform = hdfs"""
    
    IS_NULL = "IS_NULL"
    """Represent the relation: field is null, e.g. platform is null"""
    
    EXISTS = "EXISTS"
    """Represents the relation: field exists and is non-empty, e.g. owners is not null and != [] (empty)"""
    
    GREATER_THAN = "GREATER_THAN"
    """Represent the relation greater than, e.g. ownerCount > 5"""
    
    GREATER_THAN_OR_EQUAL_TO = "GREATER_THAN_OR_EQUAL_TO"
    """Represent the relation greater than or equal to, e.g. ownerCount >= 5"""
    
    IN = "IN"
    """Represent the relation: String field is one of the array values to, e.g. name in ["Profile", "Event"]"""
    
    LESS_THAN = "LESS_THAN"
    """Represent the relation less than, e.g. ownerCount < 3"""
    
    LESS_THAN_OR_EQUAL_TO = "LESS_THAN_OR_EQUAL_TO"
    """Represent the relation less than or equal to, e.g. ownerCount <= 3"""
    
    START_WITH = "START_WITH"
    """Represent the relation: String field starts with value, e.g. name starts with PageView"""
    
    
    
class ConjunctiveCriterionClass(DictWrapper):
    """A list of criterion and'd together."""
    
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.metadata.query.filter.ConjunctiveCriterion")
    def __init__(self,
        and_: List["CriterionClass"],
    ):
        super().__init__()
        
        self.and_ = and_
    
    def _restore_defaults(self) -> None:
        self.and_ = list()
    
    
    @property
    def and_(self) -> List["CriterionClass"]:
        """A list of and criteria the filter applies to the query"""
        return self._inner_dict.get('and')  # type: ignore
    
    @and_.setter
    def and_(self, value: List["CriterionClass"]) -> None:
        self._inner_dict['and'] = value
    
    
class CriterionClass(DictWrapper):
    """A criterion for matching a field with given value"""
    
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.metadata.query.filter.Criterion")
    def __init__(self,
        field: str,
        value: str,
        values: Optional[List[str]]=None,
        condition: Optional[Union[str, "ConditionClass"]]=None,
        negated: Optional[bool]=None,
    ):
        super().__init__()
        
        self.field = field
        self.value = value
        if values is None:
            # default: []
            self.values = list()
        else:
            self.values = values
        if condition is None:
            # default: 'EQUAL'
            self.condition = self.RECORD_SCHEMA.fields_dict["condition"].default
        else:
            self.condition = condition
        if negated is None:
            # default: False
            self.negated = self.RECORD_SCHEMA.fields_dict["negated"].default
        else:
            self.negated = negated
    
    def _restore_defaults(self) -> None:
        self.field = str()
        self.value = str()
        self.values = list()
        self.condition = self.RECORD_SCHEMA.fields_dict["condition"].default
        self.negated = self.RECORD_SCHEMA.fields_dict["negated"].default
    
    
    @property
    def field(self) -> str:
        """The name of the field that the criterion refers to"""
        return self._inner_dict.get('field')  # type: ignore
    
    @field.setter
    def field(self, value: str) -> None:
        self._inner_dict['field'] = value
    
    
    @property
    def value(self) -> str:
        """The value of the intended field"""
        return self._inner_dict.get('value')  # type: ignore
    
    @value.setter
    def value(self, value: str) -> None:
        self._inner_dict['value'] = value
    
    
    @property
    def values(self) -> List[str]:
        """Values. one of which the intended field should match
    Note, if values is set, the above "value" field will be ignored"""
        return self._inner_dict.get('values')  # type: ignore
    
    @values.setter
    def values(self, value: List[str]) -> None:
        self._inner_dict['values'] = value
    
    
    @property
    def condition(self) -> Union[str, "ConditionClass"]:
        """The condition for the criterion, e.g. EQUAL, START_WITH"""
        return self._inner_dict.get('condition')  # type: ignore
    
    @condition.setter
    def condition(self, value: Union[str, "ConditionClass"]) -> None:
        self._inner_dict['condition'] = value
    
    
    @property
    def negated(self) -> bool:
        """Whether the condition should be negated"""
        return self._inner_dict.get('negated')  # type: ignore
    
    @negated.setter
    def negated(self, value: bool) -> None:
        self._inner_dict['negated'] = value
    
    
class FilterClass(DictWrapper):
    """The filter for finding a record or a collection of records"""
    
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.metadata.query.filter.Filter")
    def __init__(self,
        or_: Union[None, List["ConjunctiveCriterionClass"]]=None,
        criteria: Union[None, List["CriterionClass"]]=None,
    ):
        super().__init__()
        
        self.or_ = or_
        self.criteria = criteria
    
    def _restore_defaults(self) -> None:
        self.or_ = self.RECORD_SCHEMA.fields_dict["or"].default
        self.criteria = self.RECORD_SCHEMA.fields_dict["criteria"].default
    
    
    @property
    def or_(self) -> Union[None, List["ConjunctiveCriterionClass"]]:
        """A list of disjunctive criterion for the filter. (or operation to combine filters)"""
        return self._inner_dict.get('or')  # type: ignore
    
    @or_.setter
    def or_(self, value: Union[None, List["ConjunctiveCriterionClass"]]) -> None:
        self._inner_dict['or'] = value
    
    
    @property
    def criteria(self) -> Union[None, List["CriterionClass"]]:
        """Deprecated! A list of conjunctive criterion for the filter. If "or" field is provided, then this field is ignored."""
        return self._inner_dict.get('criteria')  # type: ignore
    
    @criteria.setter
    def criteria(self, value: Union[None, List["CriterionClass"]]) -> None:
        self._inner_dict['criteria'] = value
    
    
class ChartSnapshotClass(DictWrapper):
    """A metadata snapshot for a specific Chart entity."""
    
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.metadata.snapshot.ChartSnapshot")
    def __init__(self,
        urn: str,
        aspects: List[Union["ChartKeyClass", "ChartInfoClass", "ChartQueryClass", "EditableChartPropertiesClass", "OwnershipClass", "StatusClass", "GlobalTagsClass", "BrowsePathsClass", "GlossaryTermsClass", "InstitutionalMemoryClass", "DataPlatformInstanceClass", "BrowsePathsV2Class"]],
    ):
        super().__init__()
        
        self.urn = urn
        self.aspects = aspects
    
    def _restore_defaults(self) -> None:
        self.urn = str()
        self.aspects = list()
    
    
    @property
    def urn(self) -> str:
        """URN for the entity the metadata snapshot is associated with."""
        return self._inner_dict.get('urn')  # type: ignore
    
    @urn.setter
    def urn(self, value: str) -> None:
        self._inner_dict['urn'] = value
    
    
    @property
    def aspects(self) -> List[Union["ChartKeyClass", "ChartInfoClass", "ChartQueryClass", "EditableChartPropertiesClass", "OwnershipClass", "StatusClass", "GlobalTagsClass", "BrowsePathsClass", "GlossaryTermsClass", "InstitutionalMemoryClass", "DataPlatformInstanceClass", "BrowsePathsV2Class"]]:
        """The list of metadata aspects associated with the chart. Depending on the use case, this can either be all, or a selection, of supported aspects."""
        return self._inner_dict.get('aspects')  # type: ignore
    
    @aspects.setter
    def aspects(self, value: List[Union["ChartKeyClass", "ChartInfoClass", "ChartQueryClass", "EditableChartPropertiesClass", "OwnershipClass", "StatusClass", "GlobalTagsClass", "BrowsePathsClass", "GlossaryTermsClass", "InstitutionalMemoryClass", "DataPlatformInstanceClass", "BrowsePathsV2Class"]]) -> None:
        self._inner_dict['aspects'] = value
    
    
class CorpGroupSnapshotClass(DictWrapper):
    """A metadata snapshot for a specific CorpGroup entity."""
    
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.metadata.snapshot.CorpGroupSnapshot")
    def __init__(self,
        urn: str,
        aspects: List[Union["CorpGroupKeyClass", "CorpGroupInfoClass", "GlobalTagsClass", "StatusClass"]],
    ):
        super().__init__()
        
        self.urn = urn
        self.aspects = aspects
    
    def _restore_defaults(self) -> None:
        self.urn = str()
        self.aspects = list()
    
    
    @property
    def urn(self) -> str:
        """URN for the entity the metadata snapshot is associated with."""
        return self._inner_dict.get('urn')  # type: ignore
    
    @urn.setter
    def urn(self, value: str) -> None:
        self._inner_dict['urn'] = value
    
    
    @property
    def aspects(self) -> List[Union["CorpGroupKeyClass", "CorpGroupInfoClass", "GlobalTagsClass", "StatusClass"]]:
        """The list of metadata aspects associated with the LdapUser. Depending on the use case, this can either be all, or a selection, of supported aspects."""
        return self._inner_dict.get('aspects')  # type: ignore
    
    @aspects.setter
    def aspects(self, value: List[Union["CorpGroupKeyClass", "CorpGroupInfoClass", "GlobalTagsClass", "StatusClass"]]) -> None:
        self._inner_dict['aspects'] = value
    
    
class CorpUserSnapshotClass(DictWrapper):
    """A metadata snapshot for a specific CorpUser entity."""
    
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.metadata.snapshot.CorpUserSnapshot")
    def __init__(self,
        urn: str,
        aspects: List[Union["CorpUserKeyClass", "CorpUserInfoClass", "CorpUserEditableInfoClass", "CorpUserStatusClass", "GroupMembershipClass", "GlobalTagsClass", "StatusClass"]],
    ):
        super().__init__()
        
        self.urn = urn
        self.aspects = aspects
    
    def _restore_defaults(self) -> None:
        self.urn = str()
        self.aspects = list()
    
    
    @property
    def urn(self) -> str:
        """URN for the entity the metadata snapshot is associated with."""
        return self._inner_dict.get('urn')  # type: ignore
    
    @urn.setter
    def urn(self, value: str) -> None:
        self._inner_dict['urn'] = value
    
    
    @property
    def aspects(self) -> List[Union["CorpUserKeyClass", "CorpUserInfoClass", "CorpUserEditableInfoClass", "CorpUserStatusClass", "GroupMembershipClass", "GlobalTagsClass", "StatusClass"]]:
        """The list of metadata aspects associated with the CorpUser. Depending on the use case, this can either be all, or a selection, of supported aspects."""
        return self._inner_dict.get('aspects')  # type: ignore
    
    @aspects.setter
    def aspects(self, value: List[Union["CorpUserKeyClass", "CorpUserInfoClass", "CorpUserEditableInfoClass", "CorpUserStatusClass", "GroupMembershipClass", "GlobalTagsClass", "StatusClass"]]) -> None:
        self._inner_dict['aspects'] = value
    
    
class DashboardSnapshotClass(DictWrapper):
    """A metadata snapshot for a specific Dashboard entity."""
    
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.metadata.snapshot.DashboardSnapshot")
    def __init__(self,
        urn: str,
        aspects: List[Union["DashboardKeyClass", "DashboardInfoClass", "EditableDashboardPropertiesClass", "OwnershipClass", "StatusClass", "GlobalTagsClass", "BrowsePathsClass", "GlossaryTermsClass", "InstitutionalMemoryClass", "DataPlatformInstanceClass", "BrowsePathsV2Class"]],
    ):
        super().__init__()
        
        self.urn = urn
        self.aspects = aspects
    
    def _restore_defaults(self) -> None:
        self.urn = str()
        self.aspects = list()
    
    
    @property
    def urn(self) -> str:
        """URN for the entity the metadata snapshot is associated with."""
        return self._inner_dict.get('urn')  # type: ignore
    
    @urn.setter
    def urn(self, value: str) -> None:
        self._inner_dict['urn'] = value
    
    
    @property
    def aspects(self) -> List[Union["DashboardKeyClass", "DashboardInfoClass", "EditableDashboardPropertiesClass", "OwnershipClass", "StatusClass", "GlobalTagsClass", "BrowsePathsClass", "GlossaryTermsClass", "InstitutionalMemoryClass", "DataPlatformInstanceClass", "BrowsePathsV2Class"]]:
        """The list of metadata aspects associated with the dashboard. Depending on the use case, this can either be all, or a selection, of supported aspects."""
        return self._inner_dict.get('aspects')  # type: ignore
    
    @aspects.setter
    def aspects(self, value: List[Union["DashboardKeyClass", "DashboardInfoClass", "EditableDashboardPropertiesClass", "OwnershipClass", "StatusClass", "GlobalTagsClass", "BrowsePathsClass", "GlossaryTermsClass", "InstitutionalMemoryClass", "DataPlatformInstanceClass", "BrowsePathsV2Class"]]) -> None:
        self._inner_dict['aspects'] = value
    
    
class DataFlowSnapshotClass(DictWrapper):
    """A metadata snapshot for a specific DataFlow entity."""
    
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.metadata.snapshot.DataFlowSnapshot")
    def __init__(self,
        urn: str,
        aspects: List[Union["DataFlowKeyClass", "DataFlowInfoClass", "EditableDataFlowPropertiesClass", "OwnershipClass", "StatusClass", "GlobalTagsClass", "BrowsePathsClass", "GlossaryTermsClass", "InstitutionalMemoryClass", "DataPlatformInstanceClass", "BrowsePathsV2Class"]],
    ):
        super().__init__()
        
        self.urn = urn
        self.aspects = aspects
    
    def _restore_defaults(self) -> None:
        self.urn = str()
        self.aspects = list()
    
    
    @property
    def urn(self) -> str:
        """URN for the entity the metadata snapshot is associated with."""
        return self._inner_dict.get('urn')  # type: ignore
    
    @urn.setter
    def urn(self, value: str) -> None:
        self._inner_dict['urn'] = value
    
    
    @property
    def aspects(self) -> List[Union["DataFlowKeyClass", "DataFlowInfoClass", "EditableDataFlowPropertiesClass", "OwnershipClass", "StatusClass", "GlobalTagsClass", "BrowsePathsClass", "GlossaryTermsClass", "InstitutionalMemoryClass", "DataPlatformInstanceClass", "BrowsePathsV2Class"]]:
        """The list of metadata aspects associated with the data flow. Depending on the use case, this can either be all, or a selection, of supported aspects."""
        return self._inner_dict.get('aspects')  # type: ignore
    
    @aspects.setter
    def aspects(self, value: List[Union["DataFlowKeyClass", "DataFlowInfoClass", "EditableDataFlowPropertiesClass", "OwnershipClass", "StatusClass", "GlobalTagsClass", "BrowsePathsClass", "GlossaryTermsClass", "InstitutionalMemoryClass", "DataPlatformInstanceClass", "BrowsePathsV2Class"]]) -> None:
        self._inner_dict['aspects'] = value
    
    
class DataHubPolicySnapshotClass(DictWrapper):
    """A metadata snapshot for DataHub Access Policy data."""
    
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.metadata.snapshot.DataHubPolicySnapshot")
    def __init__(self,
        urn: str,
        aspects: List[Union["DataHubPolicyKeyClass", "DataHubPolicyInfoClass"]],
    ):
        super().__init__()
        
        self.urn = urn
        self.aspects = aspects
    
    def _restore_defaults(self) -> None:
        self.urn = str()
        self.aspects = list()
    
    
    @property
    def urn(self) -> str:
        """URN for the entity the metadata snapshot is associated with."""
        return self._inner_dict.get('urn')  # type: ignore
    
    @urn.setter
    def urn(self, value: str) -> None:
        self._inner_dict['urn'] = value
    
    
    @property
    def aspects(self) -> List[Union["DataHubPolicyKeyClass", "DataHubPolicyInfoClass"]]:
        """The list of metadata aspects associated with the DataHub access policy."""
        return self._inner_dict.get('aspects')  # type: ignore
    
    @aspects.setter
    def aspects(self, value: List[Union["DataHubPolicyKeyClass", "DataHubPolicyInfoClass"]]) -> None:
        self._inner_dict['aspects'] = value
    
    
class DataHubRetentionSnapshotClass(DictWrapper):
    """A metadata snapshot for DataHub Access Policy data."""
    
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.metadata.snapshot.DataHubRetentionSnapshot")
    def __init__(self,
        urn: str,
        aspects: List[Union["DataHubRetentionKeyClass", "DataHubRetentionConfigClass"]],
    ):
        super().__init__()
        
        self.urn = urn
        self.aspects = aspects
    
    def _restore_defaults(self) -> None:
        self.urn = str()
        self.aspects = list()
    
    
    @property
    def urn(self) -> str:
        """URN for the entity the metadata snapshot is associated with."""
        return self._inner_dict.get('urn')  # type: ignore
    
    @urn.setter
    def urn(self, value: str) -> None:
        self._inner_dict['urn'] = value
    
    
    @property
    def aspects(self) -> List[Union["DataHubRetentionKeyClass", "DataHubRetentionConfigClass"]]:
        """The list of metadata aspects associated with the DataHub access policy."""
        return self._inner_dict.get('aspects')  # type: ignore
    
    @aspects.setter
    def aspects(self, value: List[Union["DataHubRetentionKeyClass", "DataHubRetentionConfigClass"]]) -> None:
        self._inner_dict['aspects'] = value
    
    
class DataJobSnapshotClass(DictWrapper):
    """A metadata snapshot for a specific DataJob entity."""
    
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.metadata.snapshot.DataJobSnapshot")
    def __init__(self,
        urn: str,
        aspects: List[Union["DataJobKeyClass", "DataJobInfoClass", "DataJobInputOutputClass", "EditableDataJobPropertiesClass", "OwnershipClass", "StatusClass", "GlobalTagsClass", "BrowsePathsClass", "GlossaryTermsClass", "InstitutionalMemoryClass", "DataPlatformInstanceClass", "BrowsePathsV2Class"]],
    ):
        super().__init__()
        
        self.urn = urn
        self.aspects = aspects
    
    def _restore_defaults(self) -> None:
        self.urn = str()
        self.aspects = list()
    
    
    @property
    def urn(self) -> str:
        """URN for the entity the metadata snapshot is associated with."""
        return self._inner_dict.get('urn')  # type: ignore
    
    @urn.setter
    def urn(self, value: str) -> None:
        self._inner_dict['urn'] = value
    
    
    @property
    def aspects(self) -> List[Union["DataJobKeyClass", "DataJobInfoClass", "DataJobInputOutputClass", "EditableDataJobPropertiesClass", "OwnershipClass", "StatusClass", "GlobalTagsClass", "BrowsePathsClass", "GlossaryTermsClass", "InstitutionalMemoryClass", "DataPlatformInstanceClass", "BrowsePathsV2Class"]]:
        """The list of metadata aspects associated with the data job. Depending on the use case, this can either be all, or a selection, of supported aspects."""
        return self._inner_dict.get('aspects')  # type: ignore
    
    @aspects.setter
    def aspects(self, value: List[Union["DataJobKeyClass", "DataJobInfoClass", "DataJobInputOutputClass", "EditableDataJobPropertiesClass", "OwnershipClass", "StatusClass", "GlobalTagsClass", "BrowsePathsClass", "GlossaryTermsClass", "InstitutionalMemoryClass", "DataPlatformInstanceClass", "BrowsePathsV2Class"]]) -> None:
        self._inner_dict['aspects'] = value
    
    
class DataPlatformSnapshotClass(DictWrapper):
    """A metadata snapshot for a specific dataplatform entity."""
    
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.metadata.snapshot.DataPlatformSnapshot")
    def __init__(self,
        urn: str,
        aspects: List[Union["DataPlatformKeyClass", "DataPlatformInfoClass"]],
    ):
        super().__init__()
        
        self.urn = urn
        self.aspects = aspects
    
    def _restore_defaults(self) -> None:
        self.urn = str()
        self.aspects = list()
    
    
    @property
    def urn(self) -> str:
        """URN for the entity the metadata snapshot is associated with."""
        return self._inner_dict.get('urn')  # type: ignore
    
    @urn.setter
    def urn(self, value: str) -> None:
        self._inner_dict['urn'] = value
    
    
    @property
    def aspects(self) -> List[Union["DataPlatformKeyClass", "DataPlatformInfoClass"]]:
        """The list of metadata aspects associated with the data platform. Depending on the use case, this can either be all, or a selection, of supported aspects."""
        return self._inner_dict.get('aspects')  # type: ignore
    
    @aspects.setter
    def aspects(self, value: List[Union["DataPlatformKeyClass", "DataPlatformInfoClass"]]) -> None:
        self._inner_dict['aspects'] = value
    
    
class DataProcessSnapshotClass(DictWrapper):
    """A metadata snapshot for a specific Data process entity."""
    
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.metadata.snapshot.DataProcessSnapshot")
    def __init__(self,
        urn: str,
        aspects: List[Union["DataProcessKeyClass", "OwnershipClass", "DataProcessInfoClass", "StatusClass"]],
    ):
        super().__init__()
        
        self.urn = urn
        self.aspects = aspects
    
    def _restore_defaults(self) -> None:
        self.urn = str()
        self.aspects = list()
    
    
    @property
    def urn(self) -> str:
        """URN for the entity the metadata snapshot is associated with."""
        return self._inner_dict.get('urn')  # type: ignore
    
    @urn.setter
    def urn(self, value: str) -> None:
        self._inner_dict['urn'] = value
    
    
    @property
    def aspects(self) -> List[Union["DataProcessKeyClass", "OwnershipClass", "DataProcessInfoClass", "StatusClass"]]:
        """The list of metadata aspects associated with the data process. Depending on the use case, this can either be all, or a selection, of supported aspects."""
        return self._inner_dict.get('aspects')  # type: ignore
    
    @aspects.setter
    def aspects(self, value: List[Union["DataProcessKeyClass", "OwnershipClass", "DataProcessInfoClass", "StatusClass"]]) -> None:
        self._inner_dict['aspects'] = value
    
    
class DatasetSnapshotClass(DictWrapper):
    """A metadata snapshot for a specific dataset entity."""
    
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.metadata.snapshot.DatasetSnapshot")
    def __init__(self,
        urn: str,
        aspects: List[Union["DatasetKeyClass", "DatasetPropertiesClass", "EditableDatasetPropertiesClass", "DatasetDeprecationClass", "DatasetUpstreamLineageClass", "UpstreamLineageClass", "InstitutionalMemoryClass", "OwnershipClass", "StatusClass", "SchemaMetadataClass", "EditableSchemaMetadataClass", "GlobalTagsClass", "GlossaryTermsClass", "BrowsePathsClass", "DataPlatformInstanceClass", "ViewPropertiesClass", "BrowsePathsV2Class"]],
    ):
        super().__init__()
        
        self.urn = urn
        self.aspects = aspects
    
    def _restore_defaults(self) -> None:
        self.urn = str()
        self.aspects = list()
    
    
    @property
    def urn(self) -> str:
        """URN for the entity the metadata snapshot is associated with."""
        return self._inner_dict.get('urn')  # type: ignore
    
    @urn.setter
    def urn(self, value: str) -> None:
        self._inner_dict['urn'] = value
    
    
    @property
    def aspects(self) -> List[Union["DatasetKeyClass", "DatasetPropertiesClass", "EditableDatasetPropertiesClass", "DatasetDeprecationClass", "DatasetUpstreamLineageClass", "UpstreamLineageClass", "InstitutionalMemoryClass", "OwnershipClass", "StatusClass", "SchemaMetadataClass", "EditableSchemaMetadataClass", "GlobalTagsClass", "GlossaryTermsClass", "BrowsePathsClass", "DataPlatformInstanceClass", "ViewPropertiesClass", "BrowsePathsV2Class"]]:
        """The list of metadata aspects associated with the dataset. Depending on the use case, this can either be all, or a selection, of supported aspects."""
        return self._inner_dict.get('aspects')  # type: ignore
    
    @aspects.setter
    def aspects(self, value: List[Union["DatasetKeyClass", "DatasetPropertiesClass", "EditableDatasetPropertiesClass", "DatasetDeprecationClass", "DatasetUpstreamLineageClass", "UpstreamLineageClass", "InstitutionalMemoryClass", "OwnershipClass", "StatusClass", "SchemaMetadataClass", "EditableSchemaMetadataClass", "GlobalTagsClass", "GlossaryTermsClass", "BrowsePathsClass", "DataPlatformInstanceClass", "ViewPropertiesClass", "BrowsePathsV2Class"]]) -> None:
        self._inner_dict['aspects'] = value
    
    
class GlossaryNodeSnapshotClass(DictWrapper):
    """A metadata snapshot for a specific GlossaryNode entity."""
    
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.metadata.snapshot.GlossaryNodeSnapshot")
    def __init__(self,
        urn: str,
        aspects: List[Union["GlossaryNodeKeyClass", "GlossaryNodeInfoClass", "OwnershipClass", "StatusClass"]],
    ):
        super().__init__()
        
        self.urn = urn
        self.aspects = aspects
    
    def _restore_defaults(self) -> None:
        self.urn = str()
        self.aspects = list()
    
    
    @property
    def urn(self) -> str:
        """URN for the entity the metadata snapshot is associated with."""
        return self._inner_dict.get('urn')  # type: ignore
    
    @urn.setter
    def urn(self, value: str) -> None:
        self._inner_dict['urn'] = value
    
    
    @property
    def aspects(self) -> List[Union["GlossaryNodeKeyClass", "GlossaryNodeInfoClass", "OwnershipClass", "StatusClass"]]:
        """The list of metadata aspects associated with the GlossaryNode. Depending on the use case, this can either be all, or a selection, of supported aspects."""
        return self._inner_dict.get('aspects')  # type: ignore
    
    @aspects.setter
    def aspects(self, value: List[Union["GlossaryNodeKeyClass", "GlossaryNodeInfoClass", "OwnershipClass", "StatusClass"]]) -> None:
        self._inner_dict['aspects'] = value
    
    
class GlossaryTermSnapshotClass(DictWrapper):
    """A metadata snapshot for a specific GlossaryTerm entity."""
    
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.metadata.snapshot.GlossaryTermSnapshot")
    def __init__(self,
        urn: str,
        aspects: List[Union["GlossaryTermKeyClass", "GlossaryTermInfoClass", "OwnershipClass", "StatusClass", "BrowsePathsClass", "GlossaryRelatedTermsClass"]],
    ):
        super().__init__()
        
        self.urn = urn
        self.aspects = aspects
    
    def _restore_defaults(self) -> None:
        self.urn = str()
        self.aspects = list()
    
    
    @property
    def urn(self) -> str:
        """URN for the entity the metadata snapshot is associated with."""
        return self._inner_dict.get('urn')  # type: ignore
    
    @urn.setter
    def urn(self, value: str) -> None:
        self._inner_dict['urn'] = value
    
    
    @property
    def aspects(self) -> List[Union["GlossaryTermKeyClass", "GlossaryTermInfoClass", "OwnershipClass", "StatusClass", "BrowsePathsClass", "GlossaryRelatedTermsClass"]]:
        """The list of metadata aspects associated with the GlossaryTerm. Depending on the use case, this can either be all, or a selection, of supported aspects."""
        return self._inner_dict.get('aspects')  # type: ignore
    
    @aspects.setter
    def aspects(self, value: List[Union["GlossaryTermKeyClass", "GlossaryTermInfoClass", "OwnershipClass", "StatusClass", "BrowsePathsClass", "GlossaryRelatedTermsClass"]]) -> None:
        self._inner_dict['aspects'] = value
    
    
class MLFeatureSnapshotClass(DictWrapper):
    # No docs available.
    
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.metadata.snapshot.MLFeatureSnapshot")
    def __init__(self,
        urn: str,
        aspects: List[Union["MLFeatureKeyClass", "MLFeaturePropertiesClass", "OwnershipClass", "InstitutionalMemoryClass", "StatusClass", "DeprecationClass", "BrowsePathsClass", "GlobalTagsClass", "DataPlatformInstanceClass", "BrowsePathsV2Class"]],
    ):
        super().__init__()
        
        self.urn = urn
        self.aspects = aspects
    
    def _restore_defaults(self) -> None:
        self.urn = str()
        self.aspects = list()
    
    
    @property
    def urn(self) -> str:
        """URN for the entity the metadata snapshot is associated with."""
        return self._inner_dict.get('urn')  # type: ignore
    
    @urn.setter
    def urn(self, value: str) -> None:
        self._inner_dict['urn'] = value
    
    
    @property
    def aspects(self) -> List[Union["MLFeatureKeyClass", "MLFeaturePropertiesClass", "OwnershipClass", "InstitutionalMemoryClass", "StatusClass", "DeprecationClass", "BrowsePathsClass", "GlobalTagsClass", "DataPlatformInstanceClass", "BrowsePathsV2Class"]]:
        """The list of metadata aspects associated with the MLFeature. Depending on the use case, this can either be all, or a selection, of supported aspects."""
        return self._inner_dict.get('aspects')  # type: ignore
    
    @aspects.setter
    def aspects(self, value: List[Union["MLFeatureKeyClass", "MLFeaturePropertiesClass", "OwnershipClass", "InstitutionalMemoryClass", "StatusClass", "DeprecationClass", "BrowsePathsClass", "GlobalTagsClass", "DataPlatformInstanceClass", "BrowsePathsV2Class"]]) -> None:
        self._inner_dict['aspects'] = value
    
    
class MLFeatureTableSnapshotClass(DictWrapper):
    # No docs available.
    
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.metadata.snapshot.MLFeatureTableSnapshot")
    def __init__(self,
        urn: str,
        aspects: List[Union["MLFeatureTableKeyClass", "MLFeatureTablePropertiesClass", "OwnershipClass", "InstitutionalMemoryClass", "StatusClass", "DeprecationClass", "BrowsePathsClass", "GlobalTagsClass", "DataPlatformInstanceClass", "BrowsePathsV2Class"]],
    ):
        super().__init__()
        
        self.urn = urn
        self.aspects = aspects
    
    def _restore_defaults(self) -> None:
        self.urn = str()
        self.aspects = list()
    
    
    @property
    def urn(self) -> str:
        """URN for the entity the metadata snapshot is associated with."""
        return self._inner_dict.get('urn')  # type: ignore
    
    @urn.setter
    def urn(self, value: str) -> None:
        self._inner_dict['urn'] = value
    
    
    @property
    def aspects(self) -> List[Union["MLFeatureTableKeyClass", "MLFeatureTablePropertiesClass", "OwnershipClass", "InstitutionalMemoryClass", "StatusClass", "DeprecationClass", "BrowsePathsClass", "GlobalTagsClass", "DataPlatformInstanceClass", "BrowsePathsV2Class"]]:
        """The list of metadata aspects associated with the MLFeatureTable. Depending on the use case, this can either be all, or a selection, of supported aspects."""
        return self._inner_dict.get('aspects')  # type: ignore
    
    @aspects.setter
    def aspects(self, value: List[Union["MLFeatureTableKeyClass", "MLFeatureTablePropertiesClass", "OwnershipClass", "InstitutionalMemoryClass", "StatusClass", "DeprecationClass", "BrowsePathsClass", "GlobalTagsClass", "DataPlatformInstanceClass", "BrowsePathsV2Class"]]) -> None:
        self._inner_dict['aspects'] = value
    
    
class MLModelDeploymentSnapshotClass(DictWrapper):
    # No docs available.
    
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.metadata.snapshot.MLModelDeploymentSnapshot")
    def __init__(self,
        urn: str,
        aspects: List[Union["MLModelDeploymentKeyClass", "MLModelDeploymentPropertiesClass", "OwnershipClass", "StatusClass", "DeprecationClass", "GlobalTagsClass", "DataPlatformInstanceClass"]],
    ):
        super().__init__()
        
        self.urn = urn
        self.aspects = aspects
    
    def _restore_defaults(self) -> None:
        self.urn = str()
        self.aspects = list()
    
    
    @property
    def urn(self) -> str:
        """URN for the entity the metadata snapshot is associated with."""
        return self._inner_dict.get('urn')  # type: ignore
    
    @urn.setter
    def urn(self, value: str) -> None:
        self._inner_dict['urn'] = value
    
    
    @property
    def aspects(self) -> List[Union["MLModelDeploymentKeyClass", "MLModelDeploymentPropertiesClass", "OwnershipClass", "StatusClass", "DeprecationClass", "GlobalTagsClass", "DataPlatformInstanceClass"]]:
        """The list of metadata aspects associated with the MLModelDeployment. Depending on the use case, this can either be all, or a selection, of supported aspects."""
        return self._inner_dict.get('aspects')  # type: ignore
    
    @aspects.setter
    def aspects(self, value: List[Union["MLModelDeploymentKeyClass", "MLModelDeploymentPropertiesClass", "OwnershipClass", "StatusClass", "DeprecationClass", "GlobalTagsClass", "DataPlatformInstanceClass"]]) -> None:
        self._inner_dict['aspects'] = value
    
    
class MLModelGroupSnapshotClass(DictWrapper):
    # No docs available.
    
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.metadata.snapshot.MLModelGroupSnapshot")
    def __init__(self,
        urn: str,
        aspects: List[Union["MLModelGroupKeyClass", "MLModelGroupPropertiesClass", "OwnershipClass", "StatusClass", "DeprecationClass", "BrowsePathsClass", "GlobalTagsClass", "DataPlatformInstanceClass", "BrowsePathsV2Class"]],
    ):
        super().__init__()
        
        self.urn = urn
        self.aspects = aspects
    
    def _restore_defaults(self) -> None:
        self.urn = str()
        self.aspects = list()
    
    
    @property
    def urn(self) -> str:
        """URN for the entity the metadata snapshot is associated with."""
        return self._inner_dict.get('urn')  # type: ignore
    
    @urn.setter
    def urn(self, value: str) -> None:
        self._inner_dict['urn'] = value
    
    
    @property
    def aspects(self) -> List[Union["MLModelGroupKeyClass", "MLModelGroupPropertiesClass", "OwnershipClass", "StatusClass", "DeprecationClass", "BrowsePathsClass", "GlobalTagsClass", "DataPlatformInstanceClass", "BrowsePathsV2Class"]]:
        """The list of metadata aspects associated with the MLModelGroup. Depending on the use case, this can either be all, or a selection, of supported aspects."""
        return self._inner_dict.get('aspects')  # type: ignore
    
    @aspects.setter
    def aspects(self, value: List[Union["MLModelGroupKeyClass", "MLModelGroupPropertiesClass", "OwnershipClass", "StatusClass", "DeprecationClass", "BrowsePathsClass", "GlobalTagsClass", "DataPlatformInstanceClass", "BrowsePathsV2Class"]]) -> None:
        self._inner_dict['aspects'] = value
    
    
class MLModelSnapshotClass(DictWrapper):
    """MLModel Snapshot entity details."""
    
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.metadata.snapshot.MLModelSnapshot")
    def __init__(self,
        urn: str,
        aspects: List[Union["MLModelKeyClass", "OwnershipClass", "MLModelPropertiesClass", "IntendedUseClass", "MLModelFactorPromptsClass", "MetricsClass", "EvaluationDataClass", "TrainingDataClass", "QuantitativeAnalysesClass", "EthicalConsiderationsClass", "CaveatsAndRecommendationsClass", "InstitutionalMemoryClass", "SourceCodeClass", "StatusClass", "CostClass", "DeprecationClass", "BrowsePathsClass", "GlobalTagsClass", "DataPlatformInstanceClass", "BrowsePathsV2Class"]],
    ):
        super().__init__()
        
        self.urn = urn
        self.aspects = aspects
    
    def _restore_defaults(self) -> None:
        self.urn = str()
        self.aspects = list()
    
    
    @property
    def urn(self) -> str:
        """URN for the entity the metadata snapshot is associated with."""
        return self._inner_dict.get('urn')  # type: ignore
    
    @urn.setter
    def urn(self, value: str) -> None:
        self._inner_dict['urn'] = value
    
    
    @property
    def aspects(self) -> List[Union["MLModelKeyClass", "OwnershipClass", "MLModelPropertiesClass", "IntendedUseClass", "MLModelFactorPromptsClass", "MetricsClass", "EvaluationDataClass", "TrainingDataClass", "QuantitativeAnalysesClass", "EthicalConsiderationsClass", "CaveatsAndRecommendationsClass", "InstitutionalMemoryClass", "SourceCodeClass", "StatusClass", "CostClass", "DeprecationClass", "BrowsePathsClass", "GlobalTagsClass", "DataPlatformInstanceClass", "BrowsePathsV2Class"]]:
        """The list of metadata aspects associated with the MLModel. Depending on the use case, this can either be all, or a selection, of supported aspects."""
        return self._inner_dict.get('aspects')  # type: ignore
    
    @aspects.setter
    def aspects(self, value: List[Union["MLModelKeyClass", "OwnershipClass", "MLModelPropertiesClass", "IntendedUseClass", "MLModelFactorPromptsClass", "MetricsClass", "EvaluationDataClass", "TrainingDataClass", "QuantitativeAnalysesClass", "EthicalConsiderationsClass", "CaveatsAndRecommendationsClass", "InstitutionalMemoryClass", "SourceCodeClass", "StatusClass", "CostClass", "DeprecationClass", "BrowsePathsClass", "GlobalTagsClass", "DataPlatformInstanceClass", "BrowsePathsV2Class"]]) -> None:
        self._inner_dict['aspects'] = value
    
    
class MLPrimaryKeySnapshotClass(DictWrapper):
    # No docs available.
    
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.metadata.snapshot.MLPrimaryKeySnapshot")
    def __init__(self,
        urn: str,
        aspects: List[Union["MLPrimaryKeyKeyClass", "MLPrimaryKeyPropertiesClass", "OwnershipClass", "InstitutionalMemoryClass", "StatusClass", "DeprecationClass", "GlobalTagsClass", "DataPlatformInstanceClass"]],
    ):
        super().__init__()
        
        self.urn = urn
        self.aspects = aspects
    
    def _restore_defaults(self) -> None:
        self.urn = str()
        self.aspects = list()
    
    
    @property
    def urn(self) -> str:
        """URN for the entity the metadata snapshot is associated with."""
        return self._inner_dict.get('urn')  # type: ignore
    
    @urn.setter
    def urn(self, value: str) -> None:
        self._inner_dict['urn'] = value
    
    
    @property
    def aspects(self) -> List[Union["MLPrimaryKeyKeyClass", "MLPrimaryKeyPropertiesClass", "OwnershipClass", "InstitutionalMemoryClass", "StatusClass", "DeprecationClass", "GlobalTagsClass", "DataPlatformInstanceClass"]]:
        """The list of metadata aspects associated with the MLPrimaryKey. Depending on the use case, this can either be all, or a selection, of supported aspects."""
        return self._inner_dict.get('aspects')  # type: ignore
    
    @aspects.setter
    def aspects(self, value: List[Union["MLPrimaryKeyKeyClass", "MLPrimaryKeyPropertiesClass", "OwnershipClass", "InstitutionalMemoryClass", "StatusClass", "DeprecationClass", "GlobalTagsClass", "DataPlatformInstanceClass"]]) -> None:
        self._inner_dict['aspects'] = value
    
    
class SchemaFieldSnapshotClass(DictWrapper):
    """A metadata snapshot for a specific schema field entity."""
    
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.metadata.snapshot.SchemaFieldSnapshot")
    def __init__(self,
        urn: str,
        aspects: List["SchemaFieldKeyClass"],
    ):
        super().__init__()
        
        self.urn = urn
        self.aspects = aspects
    
    def _restore_defaults(self) -> None:
        self.urn = str()
        self.aspects = list()
    
    
    @property
    def urn(self) -> str:
        """URN for the entity the metadata snapshot is associated with."""
        return self._inner_dict.get('urn')  # type: ignore
    
    @urn.setter
    def urn(self, value: str) -> None:
        self._inner_dict['urn'] = value
    
    
    @property
    def aspects(self) -> List["SchemaFieldKeyClass"]:
        """The list of metadata aspects associated with the dataset. Depending on the use case, this can either be all, or a selection, of supported aspects."""
        return self._inner_dict.get('aspects')  # type: ignore
    
    @aspects.setter
    def aspects(self, value: List["SchemaFieldKeyClass"]) -> None:
        self._inner_dict['aspects'] = value
    
    
class TagSnapshotClass(DictWrapper):
    """A metadata snapshot for a specific dataset entity."""
    
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.metadata.snapshot.TagSnapshot")
    def __init__(self,
        urn: str,
        aspects: List[Union["TagKeyClass", "OwnershipClass", "TagPropertiesClass", "StatusClass"]],
    ):
        super().__init__()
        
        self.urn = urn
        self.aspects = aspects
    
    def _restore_defaults(self) -> None:
        self.urn = str()
        self.aspects = list()
    
    
    @property
    def urn(self) -> str:
        """URN for the entity the metadata snapshot is associated with."""
        return self._inner_dict.get('urn')  # type: ignore
    
    @urn.setter
    def urn(self, value: str) -> None:
        self._inner_dict['urn'] = value
    
    
    @property
    def aspects(self) -> List[Union["TagKeyClass", "OwnershipClass", "TagPropertiesClass", "StatusClass"]]:
        """The list of metadata aspects associated with the dataset. Depending on the use case, this can either be all, or a selection, of supported aspects."""
        return self._inner_dict.get('aspects')  # type: ignore
    
    @aspects.setter
    def aspects(self, value: List[Union["TagKeyClass", "OwnershipClass", "TagPropertiesClass", "StatusClass"]]) -> None:
        self._inner_dict['aspects'] = value
    
    
class BaseDataClass(DictWrapper):
    """BaseData record"""
    
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.ml.metadata.BaseData")
    def __init__(self,
        dataset: str,
        motivation: Union[None, str]=None,
        preProcessing: Union[None, List[str]]=None,
    ):
        super().__init__()
        
        self.dataset = dataset
        self.motivation = motivation
        self.preProcessing = preProcessing
    
    def _restore_defaults(self) -> None:
        self.dataset = str()
        self.motivation = self.RECORD_SCHEMA.fields_dict["motivation"].default
        self.preProcessing = self.RECORD_SCHEMA.fields_dict["preProcessing"].default
    
    
    @property
    def dataset(self) -> str:
        """What dataset were used in the MLModel?"""
        return self._inner_dict.get('dataset')  # type: ignore
    
    @dataset.setter
    def dataset(self, value: str) -> None:
        self._inner_dict['dataset'] = value
    
    
    @property
    def motivation(self) -> Union[None, str]:
        """Why was this dataset chosen?"""
        return self._inner_dict.get('motivation')  # type: ignore
    
    @motivation.setter
    def motivation(self, value: Union[None, str]) -> None:
        self._inner_dict['motivation'] = value
    
    
    @property
    def preProcessing(self) -> Union[None, List[str]]:
        """How was the data preprocessed (e.g., tokenization of sentences, cropping of images, any filtering such as dropping images without faces)?"""
        return self._inner_dict.get('preProcessing')  # type: ignore
    
    @preProcessing.setter
    def preProcessing(self, value: Union[None, List[str]]) -> None:
        self._inner_dict['preProcessing'] = value
    
    
class CaveatDetailsClass(DictWrapper):
    """This section should list additional concerns that were not covered in the previous sections. For example, did the results suggest any further testing? Were there any relevant groups that were not represented in the evaluation dataset? Are there additional recommendations for model use?"""
    
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.ml.metadata.CaveatDetails")
    def __init__(self,
        needsFurtherTesting: Union[None, bool]=None,
        caveatDescription: Union[None, str]=None,
        groupsNotRepresented: Union[None, List[str]]=None,
    ):
        super().__init__()
        
        self.needsFurtherTesting = needsFurtherTesting
        self.caveatDescription = caveatDescription
        self.groupsNotRepresented = groupsNotRepresented
    
    def _restore_defaults(self) -> None:
        self.needsFurtherTesting = self.RECORD_SCHEMA.fields_dict["needsFurtherTesting"].default
        self.caveatDescription = self.RECORD_SCHEMA.fields_dict["caveatDescription"].default
        self.groupsNotRepresented = self.RECORD_SCHEMA.fields_dict["groupsNotRepresented"].default
    
    
    @property
    def needsFurtherTesting(self) -> Union[None, bool]:
        """Did the results suggest any further testing?"""
        return self._inner_dict.get('needsFurtherTesting')  # type: ignore
    
    @needsFurtherTesting.setter
    def needsFurtherTesting(self, value: Union[None, bool]) -> None:
        self._inner_dict['needsFurtherTesting'] = value
    
    
    @property
    def caveatDescription(self) -> Union[None, str]:
        """Caveat Description
    For ex: Given gender classes are binary (male/not male), which we include as male/female. Further work needed to evaluate across a spectrum of genders."""
        return self._inner_dict.get('caveatDescription')  # type: ignore
    
    @caveatDescription.setter
    def caveatDescription(self, value: Union[None, str]) -> None:
        self._inner_dict['caveatDescription'] = value
    
    
    @property
    def groupsNotRepresented(self) -> Union[None, List[str]]:
        """Relevant groups that were not represented in the evaluation dataset?"""
        return self._inner_dict.get('groupsNotRepresented')  # type: ignore
    
    @groupsNotRepresented.setter
    def groupsNotRepresented(self, value: Union[None, List[str]]) -> None:
        self._inner_dict['groupsNotRepresented'] = value
    
    
class CaveatsAndRecommendationsClass(_Aspect):
    """This section should list additional concerns that were not covered in the previous sections. For example, did the results suggest any further testing? Were there any relevant groups that were not represented in the evaluation dataset? Are there additional recommendations for model use?"""


    ASPECT_NAME = 'mlModelCaveatsAndRecommendations'
    ASPECT_INFO = {}
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.ml.metadata.CaveatsAndRecommendations")

    def __init__(self,
        caveats: Union[None, "CaveatDetailsClass"]=None,
        recommendations: Union[None, str]=None,
        idealDatasetCharacteristics: Union[None, List[str]]=None,
    ):
        super().__init__()
        
        self.caveats = caveats
        self.recommendations = recommendations
        self.idealDatasetCharacteristics = idealDatasetCharacteristics
    
    def _restore_defaults(self) -> None:
        self.caveats = self.RECORD_SCHEMA.fields_dict["caveats"].default
        self.recommendations = self.RECORD_SCHEMA.fields_dict["recommendations"].default
        self.idealDatasetCharacteristics = self.RECORD_SCHEMA.fields_dict["idealDatasetCharacteristics"].default
    
    
    @property
    def caveats(self) -> Union[None, "CaveatDetailsClass"]:
        """This section should list additional concerns that were not covered in the previous sections. For example, did the results suggest any further testing? Were there any relevant groups that were not represented in the evaluation dataset?"""
        return self._inner_dict.get('caveats')  # type: ignore
    
    @caveats.setter
    def caveats(self, value: Union[None, "CaveatDetailsClass"]) -> None:
        self._inner_dict['caveats'] = value
    
    
    @property
    def recommendations(self) -> Union[None, str]:
        """Recommendations on where this MLModel should be used."""
        return self._inner_dict.get('recommendations')  # type: ignore
    
    @recommendations.setter
    def recommendations(self, value: Union[None, str]) -> None:
        self._inner_dict['recommendations'] = value
    
    
    @property
    def idealDatasetCharacteristics(self) -> Union[None, List[str]]:
        """Ideal characteristics of an evaluation dataset for this MLModel"""
        return self._inner_dict.get('idealDatasetCharacteristics')  # type: ignore
    
    @idealDatasetCharacteristics.setter
    def idealDatasetCharacteristics(self, value: Union[None, List[str]]) -> None:
        self._inner_dict['idealDatasetCharacteristics'] = value
    
    
class DeploymentStatusClass(object):
    """Model endpoint statuses"""
    
    OUT_OF_SERVICE = "OUT_OF_SERVICE"
    """Deployments out of service."""
    
    CREATING = "CREATING"
    """Deployments being created."""
    
    UPDATING = "UPDATING"
    """Deployments being updated."""
    
    ROLLING_BACK = "ROLLING_BACK"
    """Deployments being reverted to a previous version."""
    
    IN_SERVICE = "IN_SERVICE"
    """Deployments that are active."""
    
    DELETING = "DELETING"
    """Deployments being deleted."""
    
    FAILED = "FAILED"
    """Deployments with an error state."""
    
    UNKNOWN = "UNKNOWN"
    """Deployments with unknown/unmappable state."""
    
    
    
class EditableMLFeaturePropertiesClass(_Aspect):
    """Properties associated with a MLFeature editable from the UI"""


    ASPECT_NAME = 'editableMlFeatureProperties'
    ASPECT_INFO = {}
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.ml.metadata.EditableMLFeatureProperties")

    def __init__(self,
        description: Union[None, str]=None,
    ):
        super().__init__()
        
        self.description = description
    
    def _restore_defaults(self) -> None:
        self.description = self.RECORD_SCHEMA.fields_dict["description"].default
    
    
    @property
    def description(self) -> Union[None, str]:
        """Documentation of the MLFeature"""
        return self._inner_dict.get('description')  # type: ignore
    
    @description.setter
    def description(self, value: Union[None, str]) -> None:
        self._inner_dict['description'] = value
    
    
class EditableMLFeatureTablePropertiesClass(_Aspect):
    """Properties associated with a MLFeatureTable editable from the ui"""


    ASPECT_NAME = 'editableMlFeatureTableProperties'
    ASPECT_INFO = {}
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.ml.metadata.EditableMLFeatureTableProperties")

    def __init__(self,
        description: Union[None, str]=None,
    ):
        super().__init__()
        
        self.description = description
    
    def _restore_defaults(self) -> None:
        self.description = self.RECORD_SCHEMA.fields_dict["description"].default
    
    
    @property
    def description(self) -> Union[None, str]:
        """Documentation of the MLFeatureTable"""
        return self._inner_dict.get('description')  # type: ignore
    
    @description.setter
    def description(self, value: Union[None, str]) -> None:
        self._inner_dict['description'] = value
    
    
class EditableMLModelGroupPropertiesClass(_Aspect):
    """Properties associated with an ML Model Group editable from the UI"""


    ASPECT_NAME = 'editableMlModelGroupProperties'
    ASPECT_INFO = {}
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.ml.metadata.EditableMLModelGroupProperties")

    def __init__(self,
        description: Union[None, str]=None,
    ):
        super().__init__()
        
        self.description = description
    
    def _restore_defaults(self) -> None:
        self.description = self.RECORD_SCHEMA.fields_dict["description"].default
    
    
    @property
    def description(self) -> Union[None, str]:
        """Documentation of the ml model group"""
        return self._inner_dict.get('description')  # type: ignore
    
    @description.setter
    def description(self, value: Union[None, str]) -> None:
        self._inner_dict['description'] = value
    
    
class EditableMLModelPropertiesClass(_Aspect):
    """Properties associated with a ML Model editable from the UI"""


    ASPECT_NAME = 'editableMlModelProperties'
    ASPECT_INFO = {}
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.ml.metadata.EditableMLModelProperties")

    def __init__(self,
        description: Union[None, str]=None,
    ):
        super().__init__()
        
        self.description = description
    
    def _restore_defaults(self) -> None:
        self.description = self.RECORD_SCHEMA.fields_dict["description"].default
    
    
    @property
    def description(self) -> Union[None, str]:
        """Documentation of the ml model"""
        return self._inner_dict.get('description')  # type: ignore
    
    @description.setter
    def description(self, value: Union[None, str]) -> None:
        self._inner_dict['description'] = value
    
    
class EditableMLPrimaryKeyPropertiesClass(_Aspect):
    """Properties associated with a MLPrimaryKey editable from the UI"""


    ASPECT_NAME = 'editableMlPrimaryKeyProperties'
    ASPECT_INFO = {}
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.ml.metadata.EditableMLPrimaryKeyProperties")

    def __init__(self,
        description: Union[None, str]=None,
    ):
        super().__init__()
        
        self.description = description
    
    def _restore_defaults(self) -> None:
        self.description = self.RECORD_SCHEMA.fields_dict["description"].default
    
    
    @property
    def description(self) -> Union[None, str]:
        """Documentation of the MLPrimaryKey"""
        return self._inner_dict.get('description')  # type: ignore
    
    @description.setter
    def description(self, value: Union[None, str]) -> None:
        self._inner_dict['description'] = value
    
    
class EthicalConsiderationsClass(_Aspect):
    """This section is intended to demonstrate the ethical considerations that went into MLModel development, surfacing ethical challenges and solutions to stakeholders."""


    ASPECT_NAME = 'mlModelEthicalConsiderations'
    ASPECT_INFO = {}
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.ml.metadata.EthicalConsiderations")

    def __init__(self,
        data: Union[None, List[str]]=None,
        humanLife: Union[None, List[str]]=None,
        mitigations: Union[None, List[str]]=None,
        risksAndHarms: Union[None, List[str]]=None,
        useCases: Union[None, List[str]]=None,
    ):
        super().__init__()
        
        self.data = data
        self.humanLife = humanLife
        self.mitigations = mitigations
        self.risksAndHarms = risksAndHarms
        self.useCases = useCases
    
    def _restore_defaults(self) -> None:
        self.data = self.RECORD_SCHEMA.fields_dict["data"].default
        self.humanLife = self.RECORD_SCHEMA.fields_dict["humanLife"].default
        self.mitigations = self.RECORD_SCHEMA.fields_dict["mitigations"].default
        self.risksAndHarms = self.RECORD_SCHEMA.fields_dict["risksAndHarms"].default
        self.useCases = self.RECORD_SCHEMA.fields_dict["useCases"].default
    
    
    @property
    def data(self) -> Union[None, List[str]]:
        """Does the MLModel use any sensitive data (e.g., protected classes)?"""
        return self._inner_dict.get('data')  # type: ignore
    
    @data.setter
    def data(self, value: Union[None, List[str]]) -> None:
        self._inner_dict['data'] = value
    
    
    @property
    def humanLife(self) -> Union[None, List[str]]:
        """ Is the MLModel intended to inform decisions about matters central to human life or flourishing - e.g., health or safety? Or could it be used in such a way?"""
        return self._inner_dict.get('humanLife')  # type: ignore
    
    @humanLife.setter
    def humanLife(self, value: Union[None, List[str]]) -> None:
        self._inner_dict['humanLife'] = value
    
    
    @property
    def mitigations(self) -> Union[None, List[str]]:
        """What risk mitigation strategies were used during MLModel development?"""
        return self._inner_dict.get('mitigations')  # type: ignore
    
    @mitigations.setter
    def mitigations(self, value: Union[None, List[str]]) -> None:
        self._inner_dict['mitigations'] = value
    
    
    @property
    def risksAndHarms(self) -> Union[None, List[str]]:
        """What risks may be present in MLModel usage? Try to identify the potential recipients, likelihood, and magnitude of harms. If these cannot be determined, note that they were considered but remain unknown."""
        return self._inner_dict.get('risksAndHarms')  # type: ignore
    
    @risksAndHarms.setter
    def risksAndHarms(self, value: Union[None, List[str]]) -> None:
        self._inner_dict['risksAndHarms'] = value
    
    
    @property
    def useCases(self) -> Union[None, List[str]]:
        """Are there any known MLModel use cases that are especially fraught? This may connect directly to the intended use section"""
        return self._inner_dict.get('useCases')  # type: ignore
    
    @useCases.setter
    def useCases(self, value: Union[None, List[str]]) -> None:
        self._inner_dict['useCases'] = value
    
    
class EvaluationDataClass(_Aspect):
    """All referenced datasets would ideally point to any set of documents that provide visibility into the source and composition of the dataset."""


    ASPECT_NAME = 'mlModelEvaluationData'
    ASPECT_INFO = {}
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.ml.metadata.EvaluationData")

    def __init__(self,
        evaluationData: List["BaseDataClass"],
    ):
        super().__init__()
        
        self.evaluationData = evaluationData
    
    def _restore_defaults(self) -> None:
        self.evaluationData = list()
    
    
    @property
    def evaluationData(self) -> List["BaseDataClass"]:
        """Details on the dataset(s) used for the quantitative analyses in the MLModel"""
        return self._inner_dict.get('evaluationData')  # type: ignore
    
    @evaluationData.setter
    def evaluationData(self, value: List["BaseDataClass"]) -> None:
        self._inner_dict['evaluationData'] = value
    
    
class IntendedUseClass(_Aspect):
    """Intended Use for the ML Model"""


    ASPECT_NAME = 'intendedUse'
    ASPECT_INFO = {}
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.ml.metadata.IntendedUse")

    def __init__(self,
        primaryUses: Union[None, List[str]]=None,
        primaryUsers: Union[None, List[Union[str, "IntendedUserTypeClass"]]]=None,
        outOfScopeUses: Union[None, List[str]]=None,
    ):
        super().__init__()
        
        self.primaryUses = primaryUses
        self.primaryUsers = primaryUsers
        self.outOfScopeUses = outOfScopeUses
    
    def _restore_defaults(self) -> None:
        self.primaryUses = self.RECORD_SCHEMA.fields_dict["primaryUses"].default
        self.primaryUsers = self.RECORD_SCHEMA.fields_dict["primaryUsers"].default
        self.outOfScopeUses = self.RECORD_SCHEMA.fields_dict["outOfScopeUses"].default
    
    
    @property
    def primaryUses(self) -> Union[None, List[str]]:
        """Primary Use cases for the MLModel."""
        return self._inner_dict.get('primaryUses')  # type: ignore
    
    @primaryUses.setter
    def primaryUses(self, value: Union[None, List[str]]) -> None:
        self._inner_dict['primaryUses'] = value
    
    
    @property
    def primaryUsers(self) -> Union[None, List[Union[str, "IntendedUserTypeClass"]]]:
        """Primary Intended Users - For example, was the MLModel developed for entertainment purposes, for hobbyists, or enterprise solutions?"""
        return self._inner_dict.get('primaryUsers')  # type: ignore
    
    @primaryUsers.setter
    def primaryUsers(self, value: Union[None, List[Union[str, "IntendedUserTypeClass"]]]) -> None:
        self._inner_dict['primaryUsers'] = value
    
    
    @property
    def outOfScopeUses(self) -> Union[None, List[str]]:
        """Highlight technology that the MLModel might easily be confused with, or related contexts that users could try to apply the MLModel to."""
        return self._inner_dict.get('outOfScopeUses')  # type: ignore
    
    @outOfScopeUses.setter
    def outOfScopeUses(self, value: Union[None, List[str]]) -> None:
        self._inner_dict['outOfScopeUses'] = value
    
    
class IntendedUserTypeClass(object):
    # No docs available.
    
    ENTERPRISE = "ENTERPRISE"
    HOBBY = "HOBBY"
    ENTERTAINMENT = "ENTERTAINMENT"
    
    
class MLFeaturePropertiesClass(_Aspect):
    """Properties associated with a MLFeature"""


    ASPECT_NAME = 'mlFeatureProperties'
    ASPECT_INFO = {}
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.ml.metadata.MLFeatureProperties")

    def __init__(self,
        description: Union[None, str]=None,
        dataType: Union[None, Union[str, "MLFeatureDataTypeClass"]]=None,
        version: Union[None, "VersionTagClass"]=None,
        sources: Union[None, List[str]]=None,
    ):
        super().__init__()
        
        self.description = description
        self.dataType = dataType
        self.version = version
        self.sources = sources
    
    def _restore_defaults(self) -> None:
        self.description = self.RECORD_SCHEMA.fields_dict["description"].default
        self.dataType = self.RECORD_SCHEMA.fields_dict["dataType"].default
        self.version = self.RECORD_SCHEMA.fields_dict["version"].default
        self.sources = self.RECORD_SCHEMA.fields_dict["sources"].default
    
    
    @property
    def description(self) -> Union[None, str]:
        """Documentation of the MLFeature"""
        return self._inner_dict.get('description')  # type: ignore
    
    @description.setter
    def description(self, value: Union[None, str]) -> None:
        self._inner_dict['description'] = value
    
    
    @property
    def dataType(self) -> Union[None, Union[str, "MLFeatureDataTypeClass"]]:
        """Data Type of the MLFeature"""
        return self._inner_dict.get('dataType')  # type: ignore
    
    @dataType.setter
    def dataType(self, value: Union[None, Union[str, "MLFeatureDataTypeClass"]]) -> None:
        self._inner_dict['dataType'] = value
    
    
    @property
    def version(self) -> Union[None, "VersionTagClass"]:
        """Version of the MLFeature"""
        return self._inner_dict.get('version')  # type: ignore
    
    @version.setter
    def version(self, value: Union[None, "VersionTagClass"]) -> None:
        self._inner_dict['version'] = value
    
    
    @property
    def sources(self) -> Union[None, List[str]]:
        """Source of the MLFeature"""
        return self._inner_dict.get('sources')  # type: ignore
    
    @sources.setter
    def sources(self, value: Union[None, List[str]]) -> None:
        self._inner_dict['sources'] = value
    
    
class MLFeatureTablePropertiesClass(_Aspect):
    """Properties associated with a MLFeatureTable"""


    ASPECT_NAME = 'mlFeatureTableProperties'
    ASPECT_INFO = {}
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.ml.metadata.MLFeatureTableProperties")

    def __init__(self,
        customProperties: Optional[Dict[str, str]]=None,
        description: Union[None, str]=None,
        mlFeatures: Union[None, List[str]]=None,
        mlPrimaryKeys: Union[None, List[str]]=None,
    ):
        super().__init__()
        
        if customProperties is None:
            # default: {}
            self.customProperties = dict()
        else:
            self.customProperties = customProperties
        self.description = description
        self.mlFeatures = mlFeatures
        self.mlPrimaryKeys = mlPrimaryKeys
    
    def _restore_defaults(self) -> None:
        self.customProperties = dict()
        self.description = self.RECORD_SCHEMA.fields_dict["description"].default
        self.mlFeatures = self.RECORD_SCHEMA.fields_dict["mlFeatures"].default
        self.mlPrimaryKeys = self.RECORD_SCHEMA.fields_dict["mlPrimaryKeys"].default
    
    
    @property
    def customProperties(self) -> Dict[str, str]:
        """Custom property bag."""
        return self._inner_dict.get('customProperties')  # type: ignore
    
    @customProperties.setter
    def customProperties(self, value: Dict[str, str]) -> None:
        self._inner_dict['customProperties'] = value
    
    
    @property
    def description(self) -> Union[None, str]:
        """Documentation of the MLFeatureTable"""
        return self._inner_dict.get('description')  # type: ignore
    
    @description.setter
    def description(self, value: Union[None, str]) -> None:
        self._inner_dict['description'] = value
    
    
    @property
    def mlFeatures(self) -> Union[None, List[str]]:
        """List of features contained in the feature table"""
        return self._inner_dict.get('mlFeatures')  # type: ignore
    
    @mlFeatures.setter
    def mlFeatures(self, value: Union[None, List[str]]) -> None:
        self._inner_dict['mlFeatures'] = value
    
    
    @property
    def mlPrimaryKeys(self) -> Union[None, List[str]]:
        """List of primary keys in the feature table (if multiple, assumed to act as a composite key)"""
        return self._inner_dict.get('mlPrimaryKeys')  # type: ignore
    
    @mlPrimaryKeys.setter
    def mlPrimaryKeys(self, value: Union[None, List[str]]) -> None:
        self._inner_dict['mlPrimaryKeys'] = value
    
    
class MLHyperParamClass(_Aspect):
    """Properties associated with an ML Hyper Param"""


    ASPECT_NAME = 'mlHyperParam'
    ASPECT_INFO = {}
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.ml.metadata.MLHyperParam")

    def __init__(self,
        name: str,
        description: Union[None, str]=None,
        value: Union[None, str]=None,
        createdAt: Union[None, int]=None,
    ):
        super().__init__()
        
        self.name = name
        self.description = description
        self.value = value
        self.createdAt = createdAt
    
    def _restore_defaults(self) -> None:
        self.name = str()
        self.description = self.RECORD_SCHEMA.fields_dict["description"].default
        self.value = self.RECORD_SCHEMA.fields_dict["value"].default
        self.createdAt = self.RECORD_SCHEMA.fields_dict["createdAt"].default
    
    
    @property
    def name(self) -> str:
        """Name of the MLHyperParam"""
        return self._inner_dict.get('name')  # type: ignore
    
    @name.setter
    def name(self, value: str) -> None:
        self._inner_dict['name'] = value
    
    
    @property
    def description(self) -> Union[None, str]:
        """Documentation of the MLHyperParam"""
        return self._inner_dict.get('description')  # type: ignore
    
    @description.setter
    def description(self, value: Union[None, str]) -> None:
        self._inner_dict['description'] = value
    
    
    @property
    def value(self) -> Union[None, str]:
        """The value of the MLHyperParam"""
        return self._inner_dict.get('value')  # type: ignore
    
    @value.setter
    def value(self, value: Union[None, str]) -> None:
        self._inner_dict['value'] = value
    
    
    @property
    def createdAt(self) -> Union[None, int]:
        """Date when the MLHyperParam was developed"""
        return self._inner_dict.get('createdAt')  # type: ignore
    
    @createdAt.setter
    def createdAt(self, value: Union[None, int]) -> None:
        self._inner_dict['createdAt'] = value
    
    
class MLMetricClass(_Aspect):
    """Properties associated with an ML Metric"""


    ASPECT_NAME = 'mlMetric'
    ASPECT_INFO = {}
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.ml.metadata.MLMetric")

    def __init__(self,
        name: str,
        description: Union[None, str]=None,
        value: Union[None, str]=None,
        createdAt: Union[None, int]=None,
    ):
        super().__init__()
        
        self.name = name
        self.description = description
        self.value = value
        self.createdAt = createdAt
    
    def _restore_defaults(self) -> None:
        self.name = str()
        self.description = self.RECORD_SCHEMA.fields_dict["description"].default
        self.value = self.RECORD_SCHEMA.fields_dict["value"].default
        self.createdAt = self.RECORD_SCHEMA.fields_dict["createdAt"].default
    
    
    @property
    def name(self) -> str:
        """Name of the mlMetric"""
        return self._inner_dict.get('name')  # type: ignore
    
    @name.setter
    def name(self, value: str) -> None:
        self._inner_dict['name'] = value
    
    
    @property
    def description(self) -> Union[None, str]:
        """Documentation of the mlMetric"""
        return self._inner_dict.get('description')  # type: ignore
    
    @description.setter
    def description(self, value: Union[None, str]) -> None:
        self._inner_dict['description'] = value
    
    
    @property
    def value(self) -> Union[None, str]:
        """The value of the mlMetric"""
        return self._inner_dict.get('value')  # type: ignore
    
    @value.setter
    def value(self, value: Union[None, str]) -> None:
        self._inner_dict['value'] = value
    
    
    @property
    def createdAt(self) -> Union[None, int]:
        """Date when the mlMetric was developed"""
        return self._inner_dict.get('createdAt')  # type: ignore
    
    @createdAt.setter
    def createdAt(self, value: Union[None, int]) -> None:
        self._inner_dict['createdAt'] = value
    
    
class MLModelDeploymentPropertiesClass(_Aspect):
    """Properties associated with an ML Model Deployment"""


    ASPECT_NAME = 'mlModelDeploymentProperties'
    ASPECT_INFO = {}
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.ml.metadata.MLModelDeploymentProperties")

    def __init__(self,
        customProperties: Optional[Dict[str, str]]=None,
        externalUrl: Union[None, str]=None,
        description: Union[None, str]=None,
        createdAt: Union[None, int]=None,
        version: Union[None, "VersionTagClass"]=None,
        status: Union[None, Union[str, "DeploymentStatusClass"]]=None,
    ):
        super().__init__()
        
        if customProperties is None:
            # default: {}
            self.customProperties = dict()
        else:
            self.customProperties = customProperties
        self.externalUrl = externalUrl
        self.description = description
        self.createdAt = createdAt
        self.version = version
        self.status = status
    
    def _restore_defaults(self) -> None:
        self.customProperties = dict()
        self.externalUrl = self.RECORD_SCHEMA.fields_dict["externalUrl"].default
        self.description = self.RECORD_SCHEMA.fields_dict["description"].default
        self.createdAt = self.RECORD_SCHEMA.fields_dict["createdAt"].default
        self.version = self.RECORD_SCHEMA.fields_dict["version"].default
        self.status = self.RECORD_SCHEMA.fields_dict["status"].default
    
    
    @property
    def customProperties(self) -> Dict[str, str]:
        """Custom property bag."""
        return self._inner_dict.get('customProperties')  # type: ignore
    
    @customProperties.setter
    def customProperties(self, value: Dict[str, str]) -> None:
        self._inner_dict['customProperties'] = value
    
    
    @property
    def externalUrl(self) -> Union[None, str]:
        """URL where the reference exist"""
        return self._inner_dict.get('externalUrl')  # type: ignore
    
    @externalUrl.setter
    def externalUrl(self, value: Union[None, str]) -> None:
        self._inner_dict['externalUrl'] = value
    
    
    @property
    def description(self) -> Union[None, str]:
        """Documentation of the MLModelDeployment"""
        return self._inner_dict.get('description')  # type: ignore
    
    @description.setter
    def description(self, value: Union[None, str]) -> None:
        self._inner_dict['description'] = value
    
    
    @property
    def createdAt(self) -> Union[None, int]:
        """Date when the MLModelDeployment was developed"""
        return self._inner_dict.get('createdAt')  # type: ignore
    
    @createdAt.setter
    def createdAt(self, value: Union[None, int]) -> None:
        self._inner_dict['createdAt'] = value
    
    
    @property
    def version(self) -> Union[None, "VersionTagClass"]:
        """Version of the MLModelDeployment"""
        return self._inner_dict.get('version')  # type: ignore
    
    @version.setter
    def version(self, value: Union[None, "VersionTagClass"]) -> None:
        self._inner_dict['version'] = value
    
    
    @property
    def status(self) -> Union[None, Union[str, "DeploymentStatusClass"]]:
        """Status of the deployment"""
        return self._inner_dict.get('status')  # type: ignore
    
    @status.setter
    def status(self, value: Union[None, Union[str, "DeploymentStatusClass"]]) -> None:
        self._inner_dict['status'] = value
    
    
class MLModelFactorPromptsClass(_Aspect):
    """Prompts which affect the performance of the MLModel"""


    ASPECT_NAME = 'mlModelFactorPrompts'
    ASPECT_INFO = {}
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.ml.metadata.MLModelFactorPrompts")

    def __init__(self,
        relevantFactors: Union[None, List["MLModelFactorsClass"]]=None,
        evaluationFactors: Union[None, List["MLModelFactorsClass"]]=None,
    ):
        super().__init__()
        
        self.relevantFactors = relevantFactors
        self.evaluationFactors = evaluationFactors
    
    def _restore_defaults(self) -> None:
        self.relevantFactors = self.RECORD_SCHEMA.fields_dict["relevantFactors"].default
        self.evaluationFactors = self.RECORD_SCHEMA.fields_dict["evaluationFactors"].default
    
    
    @property
    def relevantFactors(self) -> Union[None, List["MLModelFactorsClass"]]:
        """What are foreseeable salient factors for which MLModel performance may vary, and how were these determined?"""
        return self._inner_dict.get('relevantFactors')  # type: ignore
    
    @relevantFactors.setter
    def relevantFactors(self, value: Union[None, List["MLModelFactorsClass"]]) -> None:
        self._inner_dict['relevantFactors'] = value
    
    
    @property
    def evaluationFactors(self) -> Union[None, List["MLModelFactorsClass"]]:
        """Which factors are being reported, and why were these chosen?"""
        return self._inner_dict.get('evaluationFactors')  # type: ignore
    
    @evaluationFactors.setter
    def evaluationFactors(self, value: Union[None, List["MLModelFactorsClass"]]) -> None:
        self._inner_dict['evaluationFactors'] = value
    
    
class MLModelFactorsClass(DictWrapper):
    """Factors affecting the performance of the MLModel."""
    
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.ml.metadata.MLModelFactors")
    def __init__(self,
        groups: Union[None, List[str]]=None,
        instrumentation: Union[None, List[str]]=None,
        environment: Union[None, List[str]]=None,
    ):
        super().__init__()
        
        self.groups = groups
        self.instrumentation = instrumentation
        self.environment = environment
    
    def _restore_defaults(self) -> None:
        self.groups = self.RECORD_SCHEMA.fields_dict["groups"].default
        self.instrumentation = self.RECORD_SCHEMA.fields_dict["instrumentation"].default
        self.environment = self.RECORD_SCHEMA.fields_dict["environment"].default
    
    
    @property
    def groups(self) -> Union[None, List[str]]:
        """Groups refers to distinct categories with similar characteristics that are present in the evaluation data instances.
    For human-centric machine learning MLModels, groups are people who share one or multiple characteristics."""
        return self._inner_dict.get('groups')  # type: ignore
    
    @groups.setter
    def groups(self, value: Union[None, List[str]]) -> None:
        self._inner_dict['groups'] = value
    
    
    @property
    def instrumentation(self) -> Union[None, List[str]]:
        """The performance of a MLModel can vary depending on what instruments were used to capture the input to the MLModel.
    For example, a face detection model may perform differently depending on the camera's hardware and software,
    including lens, image stabilization, high dynamic range techniques, and background blurring for portrait mode."""
        return self._inner_dict.get('instrumentation')  # type: ignore
    
    @instrumentation.setter
    def instrumentation(self, value: Union[None, List[str]]) -> None:
        self._inner_dict['instrumentation'] = value
    
    
    @property
    def environment(self) -> Union[None, List[str]]:
        """A further factor affecting MLModel performance is the environment in which it is deployed."""
        return self._inner_dict.get('environment')  # type: ignore
    
    @environment.setter
    def environment(self, value: Union[None, List[str]]) -> None:
        self._inner_dict['environment'] = value
    
    
class MLModelGroupPropertiesClass(_Aspect):
    """Properties associated with an ML Model Group"""


    ASPECT_NAME = 'mlModelGroupProperties'
    ASPECT_INFO = {}
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.ml.metadata.MLModelGroupProperties")

    def __init__(self,
        customProperties: Optional[Dict[str, str]]=None,
        description: Union[None, str]=None,
        createdAt: Union[None, int]=None,
        version: Union[None, "VersionTagClass"]=None,
    ):
        super().__init__()
        
        if customProperties is None:
            # default: {}
            self.customProperties = dict()
        else:
            self.customProperties = customProperties
        self.description = description
        self.createdAt = createdAt
        self.version = version
    
    def _restore_defaults(self) -> None:
        self.customProperties = dict()
        self.description = self.RECORD_SCHEMA.fields_dict["description"].default
        self.createdAt = self.RECORD_SCHEMA.fields_dict["createdAt"].default
        self.version = self.RECORD_SCHEMA.fields_dict["version"].default
    
    
    @property
    def customProperties(self) -> Dict[str, str]:
        """Custom property bag."""
        return self._inner_dict.get('customProperties')  # type: ignore
    
    @customProperties.setter
    def customProperties(self, value: Dict[str, str]) -> None:
        self._inner_dict['customProperties'] = value
    
    
    @property
    def description(self) -> Union[None, str]:
        """Documentation of the MLModelGroup"""
        return self._inner_dict.get('description')  # type: ignore
    
    @description.setter
    def description(self, value: Union[None, str]) -> None:
        self._inner_dict['description'] = value
    
    
    @property
    def createdAt(self) -> Union[None, int]:
        """Date when the MLModelGroup was developed"""
        return self._inner_dict.get('createdAt')  # type: ignore
    
    @createdAt.setter
    def createdAt(self, value: Union[None, int]) -> None:
        self._inner_dict['createdAt'] = value
    
    
    @property
    def version(self) -> Union[None, "VersionTagClass"]:
        """Version of the MLModelGroup"""
        return self._inner_dict.get('version')  # type: ignore
    
    @version.setter
    def version(self, value: Union[None, "VersionTagClass"]) -> None:
        self._inner_dict['version'] = value
    
    
class MLModelPropertiesClass(_Aspect):
    """Properties associated with a ML Model"""


    ASPECT_NAME = 'mlModelProperties'
    ASPECT_INFO = {}
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.ml.metadata.MLModelProperties")

    def __init__(self,
        customProperties: Optional[Dict[str, str]]=None,
        externalUrl: Union[None, str]=None,
        description: Union[None, str]=None,
        date: Union[None, int]=None,
        version: Union[None, "VersionTagClass"]=None,
        type: Union[None, str]=None,
        hyperParameters: Union[None, Dict[str, Union[str, int, float, float, bool]]]=None,
        hyperParams: Union[None, List["MLHyperParamClass"]]=None,
        trainingMetrics: Union[None, List["MLMetricClass"]]=None,
        onlineMetrics: Union[None, List["MLMetricClass"]]=None,
        mlFeatures: Union[None, List[str]]=None,
        tags: Optional[List[str]]=None,
        deployments: Union[None, List[str]]=None,
        trainingJobs: Union[None, List[str]]=None,
        downstreamJobs: Union[None, List[str]]=None,
        groups: Union[None, List[str]]=None,
    ):
        super().__init__()
        
        if customProperties is None:
            # default: {}
            self.customProperties = dict()
        else:
            self.customProperties = customProperties
        self.externalUrl = externalUrl
        self.description = description
        self.date = date
        self.version = version
        self.type = type
        self.hyperParameters = hyperParameters
        self.hyperParams = hyperParams
        self.trainingMetrics = trainingMetrics
        self.onlineMetrics = onlineMetrics
        self.mlFeatures = mlFeatures
        if tags is None:
            # default: []
            self.tags = list()
        else:
            self.tags = tags
        self.deployments = deployments
        self.trainingJobs = trainingJobs
        self.downstreamJobs = downstreamJobs
        self.groups = groups
    
    def _restore_defaults(self) -> None:
        self.customProperties = dict()
        self.externalUrl = self.RECORD_SCHEMA.fields_dict["externalUrl"].default
        self.description = self.RECORD_SCHEMA.fields_dict["description"].default
        self.date = self.RECORD_SCHEMA.fields_dict["date"].default
        self.version = self.RECORD_SCHEMA.fields_dict["version"].default
        self.type = self.RECORD_SCHEMA.fields_dict["type"].default
        self.hyperParameters = self.RECORD_SCHEMA.fields_dict["hyperParameters"].default
        self.hyperParams = self.RECORD_SCHEMA.fields_dict["hyperParams"].default
        self.trainingMetrics = self.RECORD_SCHEMA.fields_dict["trainingMetrics"].default
        self.onlineMetrics = self.RECORD_SCHEMA.fields_dict["onlineMetrics"].default
        self.mlFeatures = self.RECORD_SCHEMA.fields_dict["mlFeatures"].default
        self.tags = list()
        self.deployments = self.RECORD_SCHEMA.fields_dict["deployments"].default
        self.trainingJobs = self.RECORD_SCHEMA.fields_dict["trainingJobs"].default
        self.downstreamJobs = self.RECORD_SCHEMA.fields_dict["downstreamJobs"].default
        self.groups = self.RECORD_SCHEMA.fields_dict["groups"].default
    
    
    @property
    def customProperties(self) -> Dict[str, str]:
        """Custom property bag."""
        return self._inner_dict.get('customProperties')  # type: ignore
    
    @customProperties.setter
    def customProperties(self, value: Dict[str, str]) -> None:
        self._inner_dict['customProperties'] = value
    
    
    @property
    def externalUrl(self) -> Union[None, str]:
        """URL where the reference exist"""
        return self._inner_dict.get('externalUrl')  # type: ignore
    
    @externalUrl.setter
    def externalUrl(self, value: Union[None, str]) -> None:
        self._inner_dict['externalUrl'] = value
    
    
    @property
    def description(self) -> Union[None, str]:
        """Documentation of the MLModel"""
        return self._inner_dict.get('description')  # type: ignore
    
    @description.setter
    def description(self, value: Union[None, str]) -> None:
        self._inner_dict['description'] = value
    
    
    @property
    def date(self) -> Union[None, int]:
        """Date when the MLModel was developed"""
        return self._inner_dict.get('date')  # type: ignore
    
    @date.setter
    def date(self, value: Union[None, int]) -> None:
        self._inner_dict['date'] = value
    
    
    @property
    def version(self) -> Union[None, "VersionTagClass"]:
        """Version of the MLModel"""
        return self._inner_dict.get('version')  # type: ignore
    
    @version.setter
    def version(self, value: Union[None, "VersionTagClass"]) -> None:
        self._inner_dict['version'] = value
    
    
    @property
    def type(self) -> Union[None, str]:
        """Type of Algorithm or MLModel such as whether it is a Naive Bayes classifier, Convolutional Neural Network, etc"""
        return self._inner_dict.get('type')  # type: ignore
    
    @type.setter
    def type(self, value: Union[None, str]) -> None:
        self._inner_dict['type'] = value
    
    
    @property
    def hyperParameters(self) -> Union[None, Dict[str, Union[str, int, float, float, bool]]]:
        """Hyper Parameters of the MLModel
    
    NOTE: these are deprecated in favor of hyperParams"""
        return self._inner_dict.get('hyperParameters')  # type: ignore
    
    @hyperParameters.setter
    def hyperParameters(self, value: Union[None, Dict[str, Union[str, int, float, float, bool]]]) -> None:
        self._inner_dict['hyperParameters'] = value
    
    
    @property
    def hyperParams(self) -> Union[None, List["MLHyperParamClass"]]:
        """Hyperparameters of the MLModel"""
        return self._inner_dict.get('hyperParams')  # type: ignore
    
    @hyperParams.setter
    def hyperParams(self, value: Union[None, List["MLHyperParamClass"]]) -> None:
        self._inner_dict['hyperParams'] = value
    
    
    @property
    def trainingMetrics(self) -> Union[None, List["MLMetricClass"]]:
        """Metrics of the MLModel used in training"""
        return self._inner_dict.get('trainingMetrics')  # type: ignore
    
    @trainingMetrics.setter
    def trainingMetrics(self, value: Union[None, List["MLMetricClass"]]) -> None:
        self._inner_dict['trainingMetrics'] = value
    
    
    @property
    def onlineMetrics(self) -> Union[None, List["MLMetricClass"]]:
        """Metrics of the MLModel used in production"""
        return self._inner_dict.get('onlineMetrics')  # type: ignore
    
    @onlineMetrics.setter
    def onlineMetrics(self, value: Union[None, List["MLMetricClass"]]) -> None:
        self._inner_dict['onlineMetrics'] = value
    
    
    @property
    def mlFeatures(self) -> Union[None, List[str]]:
        """List of features used for MLModel training"""
        return self._inner_dict.get('mlFeatures')  # type: ignore
    
    @mlFeatures.setter
    def mlFeatures(self, value: Union[None, List[str]]) -> None:
        self._inner_dict['mlFeatures'] = value
    
    
    @property
    def tags(self) -> List[str]:
        """Tags for the MLModel"""
        return self._inner_dict.get('tags')  # type: ignore
    
    @tags.setter
    def tags(self, value: List[str]) -> None:
        self._inner_dict['tags'] = value
    
    
    @property
    def deployments(self) -> Union[None, List[str]]:
        """Deployments for the MLModel"""
        return self._inner_dict.get('deployments')  # type: ignore
    
    @deployments.setter
    def deployments(self, value: Union[None, List[str]]) -> None:
        self._inner_dict['deployments'] = value
    
    
    @property
    def trainingJobs(self) -> Union[None, List[str]]:
        """List of jobs (if any) used to train the model"""
        return self._inner_dict.get('trainingJobs')  # type: ignore
    
    @trainingJobs.setter
    def trainingJobs(self, value: Union[None, List[str]]) -> None:
        self._inner_dict['trainingJobs'] = value
    
    
    @property
    def downstreamJobs(self) -> Union[None, List[str]]:
        """List of jobs (if any) that use the model"""
        return self._inner_dict.get('downstreamJobs')  # type: ignore
    
    @downstreamJobs.setter
    def downstreamJobs(self, value: Union[None, List[str]]) -> None:
        self._inner_dict['downstreamJobs'] = value
    
    
    @property
    def groups(self) -> Union[None, List[str]]:
        """Groups the model belongs to"""
        return self._inner_dict.get('groups')  # type: ignore
    
    @groups.setter
    def groups(self, value: Union[None, List[str]]) -> None:
        self._inner_dict['groups'] = value
    
    
class MLPrimaryKeyPropertiesClass(_Aspect):
    """Properties associated with a MLPrimaryKey"""


    ASPECT_NAME = 'mlPrimaryKeyProperties'
    ASPECT_INFO = {}
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.ml.metadata.MLPrimaryKeyProperties")

    def __init__(self,
        sources: List[str],
        description: Union[None, str]=None,
        dataType: Union[None, Union[str, "MLFeatureDataTypeClass"]]=None,
        version: Union[None, "VersionTagClass"]=None,
    ):
        super().__init__()
        
        self.description = description
        self.dataType = dataType
        self.version = version
        self.sources = sources
    
    def _restore_defaults(self) -> None:
        self.description = self.RECORD_SCHEMA.fields_dict["description"].default
        self.dataType = self.RECORD_SCHEMA.fields_dict["dataType"].default
        self.version = self.RECORD_SCHEMA.fields_dict["version"].default
        self.sources = list()
    
    
    @property
    def description(self) -> Union[None, str]:
        """Documentation of the MLPrimaryKey"""
        return self._inner_dict.get('description')  # type: ignore
    
    @description.setter
    def description(self, value: Union[None, str]) -> None:
        self._inner_dict['description'] = value
    
    
    @property
    def dataType(self) -> Union[None, Union[str, "MLFeatureDataTypeClass"]]:
        """Data Type of the MLPrimaryKey"""
        return self._inner_dict.get('dataType')  # type: ignore
    
    @dataType.setter
    def dataType(self, value: Union[None, Union[str, "MLFeatureDataTypeClass"]]) -> None:
        self._inner_dict['dataType'] = value
    
    
    @property
    def version(self) -> Union[None, "VersionTagClass"]:
        """Version of the MLPrimaryKey"""
        return self._inner_dict.get('version')  # type: ignore
    
    @version.setter
    def version(self, value: Union[None, "VersionTagClass"]) -> None:
        self._inner_dict['version'] = value
    
    
    @property
    def sources(self) -> List[str]:
        """Source of the MLPrimaryKey"""
        return self._inner_dict.get('sources')  # type: ignore
    
    @sources.setter
    def sources(self, value: List[str]) -> None:
        self._inner_dict['sources'] = value
    
    
class MetricsClass(_Aspect):
    """Metrics to be featured for the MLModel."""


    ASPECT_NAME = 'mlModelMetrics'
    ASPECT_INFO = {}
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.ml.metadata.Metrics")

    def __init__(self,
        performanceMeasures: Union[None, List[str]]=None,
        decisionThreshold: Union[None, List[str]]=None,
    ):
        super().__init__()
        
        self.performanceMeasures = performanceMeasures
        self.decisionThreshold = decisionThreshold
    
    def _restore_defaults(self) -> None:
        self.performanceMeasures = self.RECORD_SCHEMA.fields_dict["performanceMeasures"].default
        self.decisionThreshold = self.RECORD_SCHEMA.fields_dict["decisionThreshold"].default
    
    
    @property
    def performanceMeasures(self) -> Union[None, List[str]]:
        """Measures of MLModel performance"""
        return self._inner_dict.get('performanceMeasures')  # type: ignore
    
    @performanceMeasures.setter
    def performanceMeasures(self, value: Union[None, List[str]]) -> None:
        self._inner_dict['performanceMeasures'] = value
    
    
    @property
    def decisionThreshold(self) -> Union[None, List[str]]:
        """Decision Thresholds used (if any)?"""
        return self._inner_dict.get('decisionThreshold')  # type: ignore
    
    @decisionThreshold.setter
    def decisionThreshold(self, value: Union[None, List[str]]) -> None:
        self._inner_dict['decisionThreshold'] = value
    
    
class QuantitativeAnalysesClass(_Aspect):
    """Quantitative analyses should be disaggregated, that is, broken down by the chosen factors. Quantitative analyses should provide the results of evaluating the MLModel according to the chosen metrics, providing confidence interval values when possible."""


    ASPECT_NAME = 'mlModelQuantitativeAnalyses'
    ASPECT_INFO = {}
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.ml.metadata.QuantitativeAnalyses")

    def __init__(self,
        unitaryResults: Union[None, str]=None,
        intersectionalResults: Union[None, str]=None,
    ):
        super().__init__()
        
        self.unitaryResults = unitaryResults
        self.intersectionalResults = intersectionalResults
    
    def _restore_defaults(self) -> None:
        self.unitaryResults = self.RECORD_SCHEMA.fields_dict["unitaryResults"].default
        self.intersectionalResults = self.RECORD_SCHEMA.fields_dict["intersectionalResults"].default
    
    
    @property
    def unitaryResults(self) -> Union[None, str]:
        """Link to a dashboard with results showing how the MLModel performed with respect to each factor"""
        return self._inner_dict.get('unitaryResults')  # type: ignore
    
    @unitaryResults.setter
    def unitaryResults(self, value: Union[None, str]) -> None:
        self._inner_dict['unitaryResults'] = value
    
    
    @property
    def intersectionalResults(self) -> Union[None, str]:
        """Link to a dashboard with results showing how the MLModel performed with respect to the intersection of evaluated factors?"""
        return self._inner_dict.get('intersectionalResults')  # type: ignore
    
    @intersectionalResults.setter
    def intersectionalResults(self, value: Union[None, str]) -> None:
        self._inner_dict['intersectionalResults'] = value
    
    
class SourceCodeClass(_Aspect):
    """Source Code"""


    ASPECT_NAME = 'sourceCode'
    ASPECT_INFO = {}
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.ml.metadata.SourceCode")

    def __init__(self,
        sourceCode: List["SourceCodeUrlClass"],
    ):
        super().__init__()
        
        self.sourceCode = sourceCode
    
    def _restore_defaults(self) -> None:
        self.sourceCode = list()
    
    
    @property
    def sourceCode(self) -> List["SourceCodeUrlClass"]:
        """Source Code along with types"""
        return self._inner_dict.get('sourceCode')  # type: ignore
    
    @sourceCode.setter
    def sourceCode(self, value: List["SourceCodeUrlClass"]) -> None:
        self._inner_dict['sourceCode'] = value
    
    
class SourceCodeUrlClass(DictWrapper):
    """Source Code Url Entity"""
    
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.ml.metadata.SourceCodeUrl")
    def __init__(self,
        type: Union[str, "SourceCodeUrlTypeClass"],
        sourceCodeUrl: str,
    ):
        super().__init__()
        
        self.type = type
        self.sourceCodeUrl = sourceCodeUrl
    
    def _restore_defaults(self) -> None:
        self.type = SourceCodeUrlTypeClass.ML_MODEL_SOURCE_CODE
        self.sourceCodeUrl = str()
    
    
    @property
    def type(self) -> Union[str, "SourceCodeUrlTypeClass"]:
        """Source Code Url Types"""
        return self._inner_dict.get('type')  # type: ignore
    
    @type.setter
    def type(self, value: Union[str, "SourceCodeUrlTypeClass"]) -> None:
        self._inner_dict['type'] = value
    
    
    @property
    def sourceCodeUrl(self) -> str:
        """Source Code Url"""
        return self._inner_dict.get('sourceCodeUrl')  # type: ignore
    
    @sourceCodeUrl.setter
    def sourceCodeUrl(self, value: str) -> None:
        self._inner_dict['sourceCodeUrl'] = value
    
    
class SourceCodeUrlTypeClass(object):
    # No docs available.
    
    ML_MODEL_SOURCE_CODE = "ML_MODEL_SOURCE_CODE"
    TRAINING_PIPELINE_SOURCE_CODE = "TRAINING_PIPELINE_SOURCE_CODE"
    EVALUATION_PIPELINE_SOURCE_CODE = "EVALUATION_PIPELINE_SOURCE_CODE"
    
    
class TrainingDataClass(_Aspect):
    """Ideally, the MLModel card would contain as much information about the training data as the evaluation data. However, there might be cases where it is not feasible to provide this level of detailed information about the training data. For example, the data may be proprietary, or require a non-disclosure agreement. In these cases, we advocate for basic details about the distributions over groups in the data, as well as any other details that could inform stakeholders on the kinds of biases the model may have encoded."""


    ASPECT_NAME = 'mlModelTrainingData'
    ASPECT_INFO = {}
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.ml.metadata.TrainingData")

    def __init__(self,
        trainingData: List["BaseDataClass"],
    ):
        super().__init__()
        
        self.trainingData = trainingData
    
    def _restore_defaults(self) -> None:
        self.trainingData = list()
    
    
    @property
    def trainingData(self) -> List["BaseDataClass"]:
        """Details on the dataset(s) used for training the MLModel"""
        return self._inner_dict.get('trainingData')  # type: ignore
    
    @trainingData.setter
    def trainingData(self, value: List["BaseDataClass"]) -> None:
        self._inner_dict['trainingData'] = value
    
    
class GenericAspectClass(DictWrapper):
    """Generic record structure for serializing an Aspect"""
    
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.mxe.GenericAspect")
    def __init__(self,
        value: bytes,
        contentType: str,
    ):
        super().__init__()
        
        self.value = value
        self.contentType = contentType
    
    def _restore_defaults(self) -> None:
        self.value = bytes()
        self.contentType = str()
    
    
    @property
    def value(self) -> bytes:
        """The value of the aspect, serialized as bytes."""
        return self._inner_dict.get('value')  # type: ignore
    
    @value.setter
    def value(self, value: bytes) -> None:
        self._inner_dict['value'] = value
    
    
    @property
    def contentType(self) -> str:
        """The content type, which represents the fashion in which the aspect was serialized.
    The only type currently supported is application/json."""
        return self._inner_dict.get('contentType')  # type: ignore
    
    @contentType.setter
    def contentType(self, value: str) -> None:
        self._inner_dict['contentType'] = value
    
    
class GenericPayloadClass(DictWrapper):
    """Generic payload record structure for serializing a Platform Event."""
    
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.mxe.GenericPayload")
    def __init__(self,
        value: bytes,
        contentType: str,
    ):
        super().__init__()
        
        self.value = value
        self.contentType = contentType
    
    def _restore_defaults(self) -> None:
        self.value = bytes()
        self.contentType = str()
    
    
    @property
    def value(self) -> bytes:
        """The value of the event, serialized as bytes."""
        return self._inner_dict.get('value')  # type: ignore
    
    @value.setter
    def value(self, value: bytes) -> None:
        self._inner_dict['value'] = value
    
    
    @property
    def contentType(self) -> str:
        """The content type, which represents the fashion in which the event was serialized.
    The only type currently supported is application/json."""
        return self._inner_dict.get('contentType')  # type: ignore
    
    @contentType.setter
    def contentType(self, value: str) -> None:
        self._inner_dict['contentType'] = value
    
    
class MetadataChangeEventClass(DictWrapper):
    """Kafka event for proposing a metadata change for an entity. A corresponding MetadataAuditEvent is emitted when the change is accepted and committed, otherwise a FailedMetadataChangeEvent will be emitted instead."""
    
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.mxe.MetadataChangeEvent")
    def __init__(self,
        proposedSnapshot: Union["ChartSnapshotClass", "CorpGroupSnapshotClass", "CorpUserSnapshotClass", "DashboardSnapshotClass", "DataFlowSnapshotClass", "DataJobSnapshotClass", "DatasetSnapshotClass", "DataProcessSnapshotClass", "DataPlatformSnapshotClass", "MLModelSnapshotClass", "MLPrimaryKeySnapshotClass", "MLFeatureSnapshotClass", "MLFeatureTableSnapshotClass", "MLModelDeploymentSnapshotClass", "MLModelGroupSnapshotClass", "TagSnapshotClass", "GlossaryTermSnapshotClass", "GlossaryNodeSnapshotClass", "DataHubPolicySnapshotClass", "SchemaFieldSnapshotClass", "DataHubRetentionSnapshotClass"],
        auditHeader: Union[None, "KafkaAuditHeaderClass"]=None,
        proposedDelta: None=None,
        systemMetadata: Union[None, "SystemMetadataClass"]=None,
    ):
        super().__init__()
        
        self.auditHeader = auditHeader
        self.proposedSnapshot = proposedSnapshot
        self.proposedDelta = proposedDelta
        self.systemMetadata = systemMetadata
    
    def _restore_defaults(self) -> None:
        self.auditHeader = self.RECORD_SCHEMA.fields_dict["auditHeader"].default
        self.proposedSnapshot = ChartSnapshotClass._construct_with_defaults()
        self.proposedDelta = self.RECORD_SCHEMA.fields_dict["proposedDelta"].default
        self.systemMetadata = self.RECORD_SCHEMA.fields_dict["systemMetadata"].default
    
    
    @property
    def auditHeader(self) -> Union[None, "KafkaAuditHeaderClass"]:
        """Kafka audit header. See go/kafkaauditheader for more info."""
        return self._inner_dict.get('auditHeader')  # type: ignore
    
    @auditHeader.setter
    def auditHeader(self, value: Union[None, "KafkaAuditHeaderClass"]) -> None:
        self._inner_dict['auditHeader'] = value
    
    
    @property
    def proposedSnapshot(self) -> Union["ChartSnapshotClass", "CorpGroupSnapshotClass", "CorpUserSnapshotClass", "DashboardSnapshotClass", "DataFlowSnapshotClass", "DataJobSnapshotClass", "DatasetSnapshotClass", "DataProcessSnapshotClass", "DataPlatformSnapshotClass", "MLModelSnapshotClass", "MLPrimaryKeySnapshotClass", "MLFeatureSnapshotClass", "MLFeatureTableSnapshotClass", "MLModelDeploymentSnapshotClass", "MLModelGroupSnapshotClass", "TagSnapshotClass", "GlossaryTermSnapshotClass", "GlossaryNodeSnapshotClass", "DataHubPolicySnapshotClass", "SchemaFieldSnapshotClass", "DataHubRetentionSnapshotClass"]:
        """Snapshot of the proposed metadata change. Include only the aspects affected by the change in the snapshot."""
        return self._inner_dict.get('proposedSnapshot')  # type: ignore
    
    @proposedSnapshot.setter
    def proposedSnapshot(self, value: Union["ChartSnapshotClass", "CorpGroupSnapshotClass", "CorpUserSnapshotClass", "DashboardSnapshotClass", "DataFlowSnapshotClass", "DataJobSnapshotClass", "DatasetSnapshotClass", "DataProcessSnapshotClass", "DataPlatformSnapshotClass", "MLModelSnapshotClass", "MLPrimaryKeySnapshotClass", "MLFeatureSnapshotClass", "MLFeatureTableSnapshotClass", "MLModelDeploymentSnapshotClass", "MLModelGroupSnapshotClass", "TagSnapshotClass", "GlossaryTermSnapshotClass", "GlossaryNodeSnapshotClass", "DataHubPolicySnapshotClass", "SchemaFieldSnapshotClass", "DataHubRetentionSnapshotClass"]) -> None:
        self._inner_dict['proposedSnapshot'] = value
    
    
    @property
    def proposedDelta(self) -> None:
        """Delta of the proposed metadata partial update."""
        return self._inner_dict.get('proposedDelta')  # type: ignore
    
    @proposedDelta.setter
    def proposedDelta(self, value: None) -> None:
        self._inner_dict['proposedDelta'] = value
    
    
    @property
    def systemMetadata(self) -> Union[None, "SystemMetadataClass"]:
        """Metadata around how the snapshot was ingested"""
        return self._inner_dict.get('systemMetadata')  # type: ignore
    
    @systemMetadata.setter
    def systemMetadata(self, value: Union[None, "SystemMetadataClass"]) -> None:
        self._inner_dict['systemMetadata'] = value
    
    
class MetadataChangeLogClass(DictWrapper):
    """Kafka event for capturing update made to an entity's metadata."""
    
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.mxe.MetadataChangeLog")
    def __init__(self,
        entityType: str,
        changeType: Union[str, "ChangeTypeClass"],
        auditHeader: Union[None, "KafkaAuditHeaderClass"]=None,
        entityUrn: Union[None, str]=None,
        entityKeyAspect: Union[None, "GenericAspectClass"]=None,
        aspectName: Union[None, str]=None,
        aspect: Union[None, "GenericAspectClass"]=None,
        systemMetadata: Union[None, "SystemMetadataClass"]=None,
        previousAspectValue: Union[None, "GenericAspectClass"]=None,
        previousSystemMetadata: Union[None, "SystemMetadataClass"]=None,
        created: Union[None, "AuditStampClass"]=None,
    ):
        super().__init__()
        
        self.auditHeader = auditHeader
        self.entityType = entityType
        self.entityUrn = entityUrn
        self.entityKeyAspect = entityKeyAspect
        self.changeType = changeType
        self.aspectName = aspectName
        self.aspect = aspect
        self.systemMetadata = systemMetadata
        self.previousAspectValue = previousAspectValue
        self.previousSystemMetadata = previousSystemMetadata
        self.created = created
    
    def _restore_defaults(self) -> None:
        self.auditHeader = self.RECORD_SCHEMA.fields_dict["auditHeader"].default
        self.entityType = str()
        self.entityUrn = self.RECORD_SCHEMA.fields_dict["entityUrn"].default
        self.entityKeyAspect = self.RECORD_SCHEMA.fields_dict["entityKeyAspect"].default
        self.changeType = ChangeTypeClass.UPSERT
        self.aspectName = self.RECORD_SCHEMA.fields_dict["aspectName"].default
        self.aspect = self.RECORD_SCHEMA.fields_dict["aspect"].default
        self.systemMetadata = self.RECORD_SCHEMA.fields_dict["systemMetadata"].default
        self.previousAspectValue = self.RECORD_SCHEMA.fields_dict["previousAspectValue"].default
        self.previousSystemMetadata = self.RECORD_SCHEMA.fields_dict["previousSystemMetadata"].default
        self.created = self.RECORD_SCHEMA.fields_dict["created"].default
    
    
    @property
    def auditHeader(self) -> Union[None, "KafkaAuditHeaderClass"]:
        """Kafka audit header. Currently remains unused in the open source."""
        return self._inner_dict.get('auditHeader')  # type: ignore
    
    @auditHeader.setter
    def auditHeader(self, value: Union[None, "KafkaAuditHeaderClass"]) -> None:
        self._inner_dict['auditHeader'] = value
    
    
    @property
    def entityType(self) -> str:
        """Type of the entity being written to"""
        return self._inner_dict.get('entityType')  # type: ignore
    
    @entityType.setter
    def entityType(self, value: str) -> None:
        self._inner_dict['entityType'] = value
    
    
    @property
    def entityUrn(self) -> Union[None, str]:
        """Urn of the entity being written"""
        return self._inner_dict.get('entityUrn')  # type: ignore
    
    @entityUrn.setter
    def entityUrn(self, value: Union[None, str]) -> None:
        self._inner_dict['entityUrn'] = value
    
    
    @property
    def entityKeyAspect(self) -> Union[None, "GenericAspectClass"]:
        """Key aspect of the entity being written"""
        return self._inner_dict.get('entityKeyAspect')  # type: ignore
    
    @entityKeyAspect.setter
    def entityKeyAspect(self, value: Union[None, "GenericAspectClass"]) -> None:
        self._inner_dict['entityKeyAspect'] = value
    
    
    @property
    def changeType(self) -> Union[str, "ChangeTypeClass"]:
        """Type of change being proposed"""
        return self._inner_dict.get('changeType')  # type: ignore
    
    @changeType.setter
    def changeType(self, value: Union[str, "ChangeTypeClass"]) -> None:
        self._inner_dict['changeType'] = value
    
    
    @property
    def aspectName(self) -> Union[None, str]:
        """Aspect of the entity being written to
    Not filling this out implies that the writer wants to affect the entire entity
    Note: This is only valid for CREATE, UPSERT, and DELETE operations."""
        return self._inner_dict.get('aspectName')  # type: ignore
    
    @aspectName.setter
    def aspectName(self, value: Union[None, str]) -> None:
        self._inner_dict['aspectName'] = value
    
    
    @property
    def aspect(self) -> Union[None, "GenericAspectClass"]:
        """The value of the new aspect."""
        return self._inner_dict.get('aspect')  # type: ignore
    
    @aspect.setter
    def aspect(self, value: Union[None, "GenericAspectClass"]) -> None:
        self._inner_dict['aspect'] = value
    
    
    @property
    def systemMetadata(self) -> Union[None, "SystemMetadataClass"]:
        """A string->string map of custom properties that one might want to attach to an event"""
        return self._inner_dict.get('systemMetadata')  # type: ignore
    
    @systemMetadata.setter
    def systemMetadata(self, value: Union[None, "SystemMetadataClass"]) -> None:
        self._inner_dict['systemMetadata'] = value
    
    
    @property
    def previousAspectValue(self) -> Union[None, "GenericAspectClass"]:
        """The previous value of the aspect that has changed."""
        return self._inner_dict.get('previousAspectValue')  # type: ignore
    
    @previousAspectValue.setter
    def previousAspectValue(self, value: Union[None, "GenericAspectClass"]) -> None:
        self._inner_dict['previousAspectValue'] = value
    
    
    @property
    def previousSystemMetadata(self) -> Union[None, "SystemMetadataClass"]:
        """The previous value of the system metadata field that has changed."""
        return self._inner_dict.get('previousSystemMetadata')  # type: ignore
    
    @previousSystemMetadata.setter
    def previousSystemMetadata(self, value: Union[None, "SystemMetadataClass"]) -> None:
        self._inner_dict['previousSystemMetadata'] = value
    
    
    @property
    def created(self) -> Union[None, "AuditStampClass"]:
        """An audit stamp detailing who and when the aspect was changed by. Required for all intents and purposes."""
        return self._inner_dict.get('created')  # type: ignore
    
    @created.setter
    def created(self, value: Union[None, "AuditStampClass"]) -> None:
        self._inner_dict['created'] = value
    
    
class MetadataChangeProposalClass(DictWrapper):
    """Kafka event for proposing a metadata change for an entity. A corresponding MetadataChangeLog is emitted when the change is accepted and committed, otherwise a FailedMetadataChangeProposal will be emitted instead."""
    
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.mxe.MetadataChangeProposal")
    def __init__(self,
        entityType: str,
        changeType: Union[str, "ChangeTypeClass"],
        auditHeader: Union[None, "KafkaAuditHeaderClass"]=None,
        entityUrn: Union[None, str]=None,
        entityKeyAspect: Union[None, "GenericAspectClass"]=None,
        aspectName: Union[None, str]=None,
        aspect: Union[None, "GenericAspectClass"]=None,
        systemMetadata: Union[None, "SystemMetadataClass"]=None,
    ):
        super().__init__()
        
        self.auditHeader = auditHeader
        self.entityType = entityType
        self.entityUrn = entityUrn
        self.entityKeyAspect = entityKeyAspect
        self.changeType = changeType
        self.aspectName = aspectName
        self.aspect = aspect
        self.systemMetadata = systemMetadata
    
    def _restore_defaults(self) -> None:
        self.auditHeader = self.RECORD_SCHEMA.fields_dict["auditHeader"].default
        self.entityType = str()
        self.entityUrn = self.RECORD_SCHEMA.fields_dict["entityUrn"].default
        self.entityKeyAspect = self.RECORD_SCHEMA.fields_dict["entityKeyAspect"].default
        self.changeType = ChangeTypeClass.UPSERT
        self.aspectName = self.RECORD_SCHEMA.fields_dict["aspectName"].default
        self.aspect = self.RECORD_SCHEMA.fields_dict["aspect"].default
        self.systemMetadata = self.RECORD_SCHEMA.fields_dict["systemMetadata"].default
    
    
    @property
    def auditHeader(self) -> Union[None, "KafkaAuditHeaderClass"]:
        """Kafka audit header. Currently remains unused in the open source."""
        return self._inner_dict.get('auditHeader')  # type: ignore
    
    @auditHeader.setter
    def auditHeader(self, value: Union[None, "KafkaAuditHeaderClass"]) -> None:
        self._inner_dict['auditHeader'] = value
    
    
    @property
    def entityType(self) -> str:
        """Type of the entity being written to"""
        return self._inner_dict.get('entityType')  # type: ignore
    
    @entityType.setter
    def entityType(self, value: str) -> None:
        self._inner_dict['entityType'] = value
    
    
    @property
    def entityUrn(self) -> Union[None, str]:
        """Urn of the entity being written"""
        return self._inner_dict.get('entityUrn')  # type: ignore
    
    @entityUrn.setter
    def entityUrn(self, value: Union[None, str]) -> None:
        self._inner_dict['entityUrn'] = value
    
    
    @property
    def entityKeyAspect(self) -> Union[None, "GenericAspectClass"]:
        """Key aspect of the entity being written"""
        return self._inner_dict.get('entityKeyAspect')  # type: ignore
    
    @entityKeyAspect.setter
    def entityKeyAspect(self, value: Union[None, "GenericAspectClass"]) -> None:
        self._inner_dict['entityKeyAspect'] = value
    
    
    @property
    def changeType(self) -> Union[str, "ChangeTypeClass"]:
        """Type of change being proposed"""
        return self._inner_dict.get('changeType')  # type: ignore
    
    @changeType.setter
    def changeType(self, value: Union[str, "ChangeTypeClass"]) -> None:
        self._inner_dict['changeType'] = value
    
    
    @property
    def aspectName(self) -> Union[None, str]:
        """Aspect of the entity being written to
    Not filling this out implies that the writer wants to affect the entire entity
    Note: This is only valid for CREATE, UPSERT, and DELETE operations."""
        return self._inner_dict.get('aspectName')  # type: ignore
    
    @aspectName.setter
    def aspectName(self, value: Union[None, str]) -> None:
        self._inner_dict['aspectName'] = value
    
    
    @property
    def aspect(self) -> Union[None, "GenericAspectClass"]:
        """The value of the new aspect."""
        return self._inner_dict.get('aspect')  # type: ignore
    
    @aspect.setter
    def aspect(self, value: Union[None, "GenericAspectClass"]) -> None:
        self._inner_dict['aspect'] = value
    
    
    @property
    def systemMetadata(self) -> Union[None, "SystemMetadataClass"]:
        """A string->string map of custom properties that one might want to attach to an event"""
        return self._inner_dict.get('systemMetadata')  # type: ignore
    
    @systemMetadata.setter
    def systemMetadata(self, value: Union[None, "SystemMetadataClass"]) -> None:
        self._inner_dict['systemMetadata'] = value
    
    
class PlatformEventClass(DictWrapper):
    """A DataHub Platform Event."""
    
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.mxe.PlatformEvent")
    def __init__(self,
        header: "PlatformEventHeaderClass",
        name: str,
        payload: "GenericPayloadClass",
    ):
        super().__init__()
        
        self.header = header
        self.name = name
        self.payload = payload
    
    def _restore_defaults(self) -> None:
        self.header = PlatformEventHeaderClass._construct_with_defaults()
        self.name = str()
        self.payload = GenericPayloadClass._construct_with_defaults()
    
    
    @property
    def header(self) -> "PlatformEventHeaderClass":
        """Header information stored with the event."""
        return self._inner_dict.get('header')  # type: ignore
    
    @header.setter
    def header(self, value: "PlatformEventHeaderClass") -> None:
        self._inner_dict['header'] = value
    
    
    @property
    def name(self) -> str:
        """The name of the event, e.g. the type of event. For example, 'notificationRequestEvent', 'entityChangeEvent'"""
        return self._inner_dict.get('name')  # type: ignore
    
    @name.setter
    def name(self, value: str) -> None:
        self._inner_dict['name'] = value
    
    
    @property
    def payload(self) -> "GenericPayloadClass":
        """The event payload."""
        return self._inner_dict.get('payload')  # type: ignore
    
    @payload.setter
    def payload(self, value: "GenericPayloadClass") -> None:
        self._inner_dict['payload'] = value
    
    
class PlatformEventHeaderClass(DictWrapper):
    """A header included with each DataHub platform event."""
    
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.mxe.PlatformEventHeader")
    def __init__(self,
        timestampMillis: int,
    ):
        super().__init__()
        
        self.timestampMillis = timestampMillis
    
    def _restore_defaults(self) -> None:
        self.timestampMillis = int()
    
    
    @property
    def timestampMillis(self) -> int:
        """The event timestamp field as epoch at UTC in milli seconds."""
        return self._inner_dict.get('timestampMillis')  # type: ignore
    
    @timestampMillis.setter
    def timestampMillis(self, value: int) -> None:
        self._inner_dict['timestampMillis'] = value
    
    
class SystemMetadataClass(DictWrapper):
    """Metadata associated with each metadata change that is processed by the system"""
    
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.mxe.SystemMetadata")
    def __init__(self,
        lastObserved: Optional[Union[int, None]]=None,
        runId: Optional[Union[str, None]]=None,
        lastRunId: Optional[Union[str, None]]=None,
        pipelineName: Union[None, str]=None,
        registryName: Union[None, str]=None,
        registryVersion: Union[None, str]=None,
        properties: Union[None, Dict[str, str]]=None,
    ):
        super().__init__()
        
        if lastObserved is None:
            # default: 0
            self.lastObserved = self.RECORD_SCHEMA.fields_dict["lastObserved"].default
        else:
            self.lastObserved = lastObserved
        if runId is None:
            # default: 'no-run-id-provided'
            self.runId = self.RECORD_SCHEMA.fields_dict["runId"].default
        else:
            self.runId = runId
        if lastRunId is None:
            # default: 'no-run-id-provided'
            self.lastRunId = self.RECORD_SCHEMA.fields_dict["lastRunId"].default
        else:
            self.lastRunId = lastRunId
        self.pipelineName = pipelineName
        self.registryName = registryName
        self.registryVersion = registryVersion
        self.properties = properties
    
    def _restore_defaults(self) -> None:
        self.lastObserved = self.RECORD_SCHEMA.fields_dict["lastObserved"].default
        self.runId = self.RECORD_SCHEMA.fields_dict["runId"].default
        self.lastRunId = self.RECORD_SCHEMA.fields_dict["lastRunId"].default
        self.pipelineName = self.RECORD_SCHEMA.fields_dict["pipelineName"].default
        self.registryName = self.RECORD_SCHEMA.fields_dict["registryName"].default
        self.registryVersion = self.RECORD_SCHEMA.fields_dict["registryVersion"].default
        self.properties = self.RECORD_SCHEMA.fields_dict["properties"].default
    
    
    @property
    def lastObserved(self) -> Union[int, None]:
        """The timestamp the metadata was observed at"""
        return self._inner_dict.get('lastObserved')  # type: ignore
    
    @lastObserved.setter
    def lastObserved(self, value: Union[int, None]) -> None:
        self._inner_dict['lastObserved'] = value
    
    
    @property
    def runId(self) -> Union[str, None]:
        """The original run id that produced the metadata. Populated in case of batch-ingestion."""
        return self._inner_dict.get('runId')  # type: ignore
    
    @runId.setter
    def runId(self, value: Union[str, None]) -> None:
        self._inner_dict['runId'] = value
    
    
    @property
    def lastRunId(self) -> Union[str, None]:
        """The last run id that produced the metadata. Populated in case of batch-ingestion."""
        return self._inner_dict.get('lastRunId')  # type: ignore
    
    @lastRunId.setter
    def lastRunId(self, value: Union[str, None]) -> None:
        self._inner_dict['lastRunId'] = value
    
    
    @property
    def pipelineName(self) -> Union[None, str]:
        """The ingestion pipeline id that produced the metadata. Populated in case of batch ingestion."""
        return self._inner_dict.get('pipelineName')  # type: ignore
    
    @pipelineName.setter
    def pipelineName(self, value: Union[None, str]) -> None:
        self._inner_dict['pipelineName'] = value
    
    
    @property
    def registryName(self) -> Union[None, str]:
        """The model registry name that was used to process this event"""
        return self._inner_dict.get('registryName')  # type: ignore
    
    @registryName.setter
    def registryName(self, value: Union[None, str]) -> None:
        self._inner_dict['registryName'] = value
    
    
    @property
    def registryVersion(self) -> Union[None, str]:
        """The model registry version that was used to process this event"""
        return self._inner_dict.get('registryVersion')  # type: ignore
    
    @registryVersion.setter
    def registryVersion(self, value: Union[None, str]) -> None:
        self._inner_dict['registryVersion'] = value
    
    
    @property
    def properties(self) -> Union[None, Dict[str, str]]:
        """Additional properties"""
        return self._inner_dict.get('properties')  # type: ignore
    
    @properties.setter
    def properties(self, value: Union[None, Dict[str, str]]) -> None:
        self._inner_dict['properties'] = value
    
    
class ChartCellClass(DictWrapper):
    """Chart cell in a notebook, which will present content in chart format"""
    
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.notebook.ChartCell")
    def __init__(self,
        cellId: str,
        changeAuditStamps: "ChangeAuditStampsClass",
        cellTitle: Union[None, str]=None,
    ):
        super().__init__()
        
        self.cellTitle = cellTitle
        self.cellId = cellId
        self.changeAuditStamps = changeAuditStamps
    
    def _restore_defaults(self) -> None:
        self.cellTitle = self.RECORD_SCHEMA.fields_dict["cellTitle"].default
        self.cellId = str()
        self.changeAuditStamps = ChangeAuditStampsClass._construct_with_defaults()
    
    
    @property
    def cellTitle(self) -> Union[None, str]:
        """Title of the cell"""
        return self._inner_dict.get('cellTitle')  # type: ignore
    
    @cellTitle.setter
    def cellTitle(self, value: Union[None, str]) -> None:
        self._inner_dict['cellTitle'] = value
    
    
    @property
    def cellId(self) -> str:
        """Unique id for the cell. This id should be globally unique for a Notebook tool even when there are multiple deployments of it. As an example, Notebook URL could be used here for QueryBook such as 'querybook.com/notebook/773/?cellId=1234'"""
        return self._inner_dict.get('cellId')  # type: ignore
    
    @cellId.setter
    def cellId(self, value: str) -> None:
        self._inner_dict['cellId'] = value
    
    
    @property
    def changeAuditStamps(self) -> "ChangeAuditStampsClass":
        """Captures information about who created/last modified/deleted this Notebook cell and when"""
        return self._inner_dict.get('changeAuditStamps')  # type: ignore
    
    @changeAuditStamps.setter
    def changeAuditStamps(self, value: "ChangeAuditStampsClass") -> None:
        self._inner_dict['changeAuditStamps'] = value
    
    
class EditableNotebookPropertiesClass(_Aspect):
    """Stores editable changes made to properties. This separates changes made from
    ingestion pipelines and edits in the UI to avoid accidental overwrites of user-provided data by ingestion pipelines
    Note: This is IN BETA version"""


    ASPECT_NAME = 'editableNotebookProperties'
    ASPECT_INFO = {}
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.notebook.EditableNotebookProperties")

    def __init__(self,
        created: Optional["AuditStampClass"]=None,
        lastModified: Optional["AuditStampClass"]=None,
        deleted: Union[None, "AuditStampClass"]=None,
        description: Union[None, str]=None,
    ):
        super().__init__()
        
        if created is None:
            # default: {'actor': 'urn:li:corpuser:unknown', 'impersonator': None, 'time': 0, 'message': None}
            self.created = _json_converter.from_json_object(self.RECORD_SCHEMA.fields_dict["created"].default, writers_schema=self.RECORD_SCHEMA.fields_dict["created"].type)
        else:
            self.created = created
        if lastModified is None:
            # default: {'actor': 'urn:li:corpuser:unknown', 'impersonator': None, 'time': 0, 'message': None}
            self.lastModified = _json_converter.from_json_object(self.RECORD_SCHEMA.fields_dict["lastModified"].default, writers_schema=self.RECORD_SCHEMA.fields_dict["lastModified"].type)
        else:
            self.lastModified = lastModified
        self.deleted = deleted
        self.description = description
    
    def _restore_defaults(self) -> None:
        self.created = _json_converter.from_json_object(self.RECORD_SCHEMA.fields_dict["created"].default, writers_schema=self.RECORD_SCHEMA.fields_dict["created"].type)
        self.lastModified = _json_converter.from_json_object(self.RECORD_SCHEMA.fields_dict["lastModified"].default, writers_schema=self.RECORD_SCHEMA.fields_dict["lastModified"].type)
        self.deleted = self.RECORD_SCHEMA.fields_dict["deleted"].default
        self.description = self.RECORD_SCHEMA.fields_dict["description"].default
    
    
    @property
    def created(self) -> "AuditStampClass":
        """An AuditStamp corresponding to the creation of this resource/association/sub-resource. A value of 0 for time indicates missing data."""
        return self._inner_dict.get('created')  # type: ignore
    
    @created.setter
    def created(self, value: "AuditStampClass") -> None:
        self._inner_dict['created'] = value
    
    
    @property
    def lastModified(self) -> "AuditStampClass":
        """An AuditStamp corresponding to the last modification of this resource/association/sub-resource. If no modification has happened since creation, lastModified should be the same as created. A value of 0 for time indicates missing data."""
        return self._inner_dict.get('lastModified')  # type: ignore
    
    @lastModified.setter
    def lastModified(self, value: "AuditStampClass") -> None:
        self._inner_dict['lastModified'] = value
    
    
    @property
    def deleted(self) -> Union[None, "AuditStampClass"]:
        """An AuditStamp corresponding to the deletion of this resource/association/sub-resource. Logically, deleted MUST have a later timestamp than creation. It may or may not have the same time as lastModified depending upon the resource/association/sub-resource semantics."""
        return self._inner_dict.get('deleted')  # type: ignore
    
    @deleted.setter
    def deleted(self, value: Union[None, "AuditStampClass"]) -> None:
        self._inner_dict['deleted'] = value
    
    
    @property
    def description(self) -> Union[None, str]:
        """Edited documentation of the Notebook"""
        return self._inner_dict.get('description')  # type: ignore
    
    @description.setter
    def description(self, value: Union[None, str]) -> None:
        self._inner_dict['description'] = value
    
    
class NotebookCellClass(DictWrapper):
    """A record of all supported cells for a Notebook. Only one type of cell will be non-null."""
    
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.notebook.NotebookCell")
    def __init__(self,
        type: Union[str, "NotebookCellTypeClass"],
        textCell: Union[None, "TextCellClass"]=None,
        queryCell: Union[None, "QueryCellClass"]=None,
        chartCell: Union[None, "ChartCellClass"]=None,
    ):
        super().__init__()
        
        self.textCell = textCell
        self.queryCell = queryCell
        self.chartCell = chartCell
        self.type = type
    
    def _restore_defaults(self) -> None:
        self.textCell = self.RECORD_SCHEMA.fields_dict["textCell"].default
        self.queryCell = self.RECORD_SCHEMA.fields_dict["queryCell"].default
        self.chartCell = self.RECORD_SCHEMA.fields_dict["chartCell"].default
        self.type = NotebookCellTypeClass.TEXT_CELL
    
    
    @property
    def textCell(self) -> Union[None, "TextCellClass"]:
        """The text cell content. The will be non-null only when all other cell field is null."""
        return self._inner_dict.get('textCell')  # type: ignore
    
    @textCell.setter
    def textCell(self, value: Union[None, "TextCellClass"]) -> None:
        self._inner_dict['textCell'] = value
    
    
    @property
    def queryCell(self) -> Union[None, "QueryCellClass"]:
        """The query cell content. The will be non-null only when all other cell field is null."""
        return self._inner_dict.get('queryCell')  # type: ignore
    
    @queryCell.setter
    def queryCell(self, value: Union[None, "QueryCellClass"]) -> None:
        self._inner_dict['queryCell'] = value
    
    
    @property
    def chartCell(self) -> Union[None, "ChartCellClass"]:
        """The chart cell content. The will be non-null only when all other cell field is null."""
        return self._inner_dict.get('chartCell')  # type: ignore
    
    @chartCell.setter
    def chartCell(self, value: Union[None, "ChartCellClass"]) -> None:
        self._inner_dict['chartCell'] = value
    
    
    @property
    def type(self) -> Union[str, "NotebookCellTypeClass"]:
        """The type of this Notebook cell"""
        return self._inner_dict.get('type')  # type: ignore
    
    @type.setter
    def type(self, value: Union[str, "NotebookCellTypeClass"]) -> None:
        self._inner_dict['type'] = value
    
    
class NotebookCellTypeClass(object):
    """Type of Notebook Cell"""
    
    TEXT_CELL = "TEXT_CELL"
    """TEXT Notebook cell type. The cell context is text only."""
    
    QUERY_CELL = "QUERY_CELL"
    """QUERY Notebook cell type. The cell context is query only."""
    
    CHART_CELL = "CHART_CELL"
    """CHART Notebook cell type. The cell content is chart only."""
    
    
    
class NotebookContentClass(_Aspect):
    """Content in a Notebook
    Note: This is IN BETA version"""


    ASPECT_NAME = 'notebookContent'
    ASPECT_INFO = {}
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.notebook.NotebookContent")

    def __init__(self,
        cells: Optional[List["NotebookCellClass"]]=None,
    ):
        super().__init__()
        
        if cells is None:
            # default: []
            self.cells = list()
        else:
            self.cells = cells
    
    def _restore_defaults(self) -> None:
        self.cells = list()
    
    
    @property
    def cells(self) -> List["NotebookCellClass"]:
        """The content of a Notebook which is composed by a list of NotebookCell"""
        return self._inner_dict.get('cells')  # type: ignore
    
    @cells.setter
    def cells(self, value: List["NotebookCellClass"]) -> None:
        self._inner_dict['cells'] = value
    
    
class NotebookInfoClass(_Aspect):
    """Information about a Notebook
    Note: This is IN BETA version"""


    ASPECT_NAME = 'notebookInfo'
    ASPECT_INFO = {}
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.notebook.NotebookInfo")

    def __init__(self,
        title: str,
        changeAuditStamps: "ChangeAuditStampsClass",
        customProperties: Optional[Dict[str, str]]=None,
        externalUrl: Union[None, str]=None,
        description: Union[None, str]=None,
    ):
        super().__init__()
        
        if customProperties is None:
            # default: {}
            self.customProperties = dict()
        else:
            self.customProperties = customProperties
        self.externalUrl = externalUrl
        self.title = title
        self.description = description
        self.changeAuditStamps = changeAuditStamps
    
    def _restore_defaults(self) -> None:
        self.customProperties = dict()
        self.externalUrl = self.RECORD_SCHEMA.fields_dict["externalUrl"].default
        self.title = str()
        self.description = self.RECORD_SCHEMA.fields_dict["description"].default
        self.changeAuditStamps = ChangeAuditStampsClass._construct_with_defaults()
    
    
    @property
    def customProperties(self) -> Dict[str, str]:
        """Custom property bag."""
        return self._inner_dict.get('customProperties')  # type: ignore
    
    @customProperties.setter
    def customProperties(self, value: Dict[str, str]) -> None:
        self._inner_dict['customProperties'] = value
    
    
    @property
    def externalUrl(self) -> Union[None, str]:
        """URL where the reference exist"""
        return self._inner_dict.get('externalUrl')  # type: ignore
    
    @externalUrl.setter
    def externalUrl(self, value: Union[None, str]) -> None:
        self._inner_dict['externalUrl'] = value
    
    
    @property
    def title(self) -> str:
        """Title of the Notebook"""
        return self._inner_dict.get('title')  # type: ignore
    
    @title.setter
    def title(self, value: str) -> None:
        self._inner_dict['title'] = value
    
    
    @property
    def description(self) -> Union[None, str]:
        """Detailed description about the Notebook"""
        return self._inner_dict.get('description')  # type: ignore
    
    @description.setter
    def description(self, value: Union[None, str]) -> None:
        self._inner_dict['description'] = value
    
    
    @property
    def changeAuditStamps(self) -> "ChangeAuditStampsClass":
        """Captures information about who created/last modified/deleted this Notebook and when"""
        return self._inner_dict.get('changeAuditStamps')  # type: ignore
    
    @changeAuditStamps.setter
    def changeAuditStamps(self, value: "ChangeAuditStampsClass") -> None:
        self._inner_dict['changeAuditStamps'] = value
    
    
class QueryCellClass(DictWrapper):
    """Query cell in a Notebook, which will present content in query format"""
    
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.notebook.QueryCell")
    def __init__(self,
        cellId: str,
        changeAuditStamps: "ChangeAuditStampsClass",
        rawQuery: str,
        cellTitle: Union[None, str]=None,
        lastExecuted: Union[None, "AuditStampClass"]=None,
    ):
        super().__init__()
        
        self.cellTitle = cellTitle
        self.cellId = cellId
        self.changeAuditStamps = changeAuditStamps
        self.rawQuery = rawQuery
        self.lastExecuted = lastExecuted
    
    def _restore_defaults(self) -> None:
        self.cellTitle = self.RECORD_SCHEMA.fields_dict["cellTitle"].default
        self.cellId = str()
        self.changeAuditStamps = ChangeAuditStampsClass._construct_with_defaults()
        self.rawQuery = str()
        self.lastExecuted = self.RECORD_SCHEMA.fields_dict["lastExecuted"].default
    
    
    @property
    def cellTitle(self) -> Union[None, str]:
        """Title of the cell"""
        return self._inner_dict.get('cellTitle')  # type: ignore
    
    @cellTitle.setter
    def cellTitle(self, value: Union[None, str]) -> None:
        self._inner_dict['cellTitle'] = value
    
    
    @property
    def cellId(self) -> str:
        """Unique id for the cell. This id should be globally unique for a Notebook tool even when there are multiple deployments of it. As an example, Notebook URL could be used here for QueryBook such as 'querybook.com/notebook/773/?cellId=1234'"""
        return self._inner_dict.get('cellId')  # type: ignore
    
    @cellId.setter
    def cellId(self, value: str) -> None:
        self._inner_dict['cellId'] = value
    
    
    @property
    def changeAuditStamps(self) -> "ChangeAuditStampsClass":
        """Captures information about who created/last modified/deleted this Notebook cell and when"""
        return self._inner_dict.get('changeAuditStamps')  # type: ignore
    
    @changeAuditStamps.setter
    def changeAuditStamps(self, value: "ChangeAuditStampsClass") -> None:
        self._inner_dict['changeAuditStamps'] = value
    
    
    @property
    def rawQuery(self) -> str:
        """Raw query to explain some specific logic in a Notebook"""
        return self._inner_dict.get('rawQuery')  # type: ignore
    
    @rawQuery.setter
    def rawQuery(self, value: str) -> None:
        self._inner_dict['rawQuery'] = value
    
    
    @property
    def lastExecuted(self) -> Union[None, "AuditStampClass"]:
        """Captures information about who last executed this query cell and when"""
        return self._inner_dict.get('lastExecuted')  # type: ignore
    
    @lastExecuted.setter
    def lastExecuted(self, value: Union[None, "AuditStampClass"]) -> None:
        self._inner_dict['lastExecuted'] = value
    
    
class TextCellClass(DictWrapper):
    """Text cell in a Notebook, which will present content in text format"""
    
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.notebook.TextCell")
    def __init__(self,
        cellId: str,
        changeAuditStamps: "ChangeAuditStampsClass",
        text: str,
        cellTitle: Union[None, str]=None,
    ):
        super().__init__()
        
        self.cellTitle = cellTitle
        self.cellId = cellId
        self.changeAuditStamps = changeAuditStamps
        self.text = text
    
    def _restore_defaults(self) -> None:
        self.cellTitle = self.RECORD_SCHEMA.fields_dict["cellTitle"].default
        self.cellId = str()
        self.changeAuditStamps = ChangeAuditStampsClass._construct_with_defaults()
        self.text = str()
    
    
    @property
    def cellTitle(self) -> Union[None, str]:
        """Title of the cell"""
        return self._inner_dict.get('cellTitle')  # type: ignore
    
    @cellTitle.setter
    def cellTitle(self, value: Union[None, str]) -> None:
        self._inner_dict['cellTitle'] = value
    
    
    @property
    def cellId(self) -> str:
        """Unique id for the cell. This id should be globally unique for a Notebook tool even when there are multiple deployments of it. As an example, Notebook URL could be used here for QueryBook such as 'querybook.com/notebook/773/?cellId=1234'"""
        return self._inner_dict.get('cellId')  # type: ignore
    
    @cellId.setter
    def cellId(self, value: str) -> None:
        self._inner_dict['cellId'] = value
    
    
    @property
    def changeAuditStamps(self) -> "ChangeAuditStampsClass":
        """Captures information about who created/last modified/deleted this Notebook cell and when"""
        return self._inner_dict.get('changeAuditStamps')  # type: ignore
    
    @changeAuditStamps.setter
    def changeAuditStamps(self, value: "ChangeAuditStampsClass") -> None:
        self._inner_dict['changeAuditStamps'] = value
    
    
    @property
    def text(self) -> str:
        """The actual text in a TextCell in a Notebook"""
        return self._inner_dict.get('text')  # type: ignore
    
    @text.setter
    def text(self, value: str) -> None:
        self._inner_dict['text'] = value
    
    
class OwnershipTypeInfoClass(_Aspect):
    """Information about an ownership type"""


    ASPECT_NAME = 'ownershipTypeInfo'
    ASPECT_INFO = {}
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.ownership.OwnershipTypeInfo")

    def __init__(self,
        name: str,
        created: "AuditStampClass",
        lastModified: "AuditStampClass",
        description: Union[None, str]=None,
    ):
        super().__init__()
        
        self.name = name
        self.description = description
        self.created = created
        self.lastModified = lastModified
    
    def _restore_defaults(self) -> None:
        self.name = str()
        self.description = self.RECORD_SCHEMA.fields_dict["description"].default
        self.created = AuditStampClass._construct_with_defaults()
        self.lastModified = AuditStampClass._construct_with_defaults()
    
    
    @property
    def name(self) -> str:
        """Display name of the Ownership Type"""
        return self._inner_dict.get('name')  # type: ignore
    
    @name.setter
    def name(self, value: str) -> None:
        self._inner_dict['name'] = value
    
    
    @property
    def description(self) -> Union[None, str]:
        """Description of the Ownership Type"""
        return self._inner_dict.get('description')  # type: ignore
    
    @description.setter
    def description(self, value: Union[None, str]) -> None:
        self._inner_dict['description'] = value
    
    
    @property
    def created(self) -> "AuditStampClass":
        """Audit stamp capturing the time and actor who created the Ownership Type."""
        return self._inner_dict.get('created')  # type: ignore
    
    @created.setter
    def created(self, value: "AuditStampClass") -> None:
        self._inner_dict['created'] = value
    
    
    @property
    def lastModified(self) -> "AuditStampClass":
        """Audit stamp capturing the time and actor who last modified the Ownership Type."""
        return self._inner_dict.get('lastModified')  # type: ignore
    
    @lastModified.setter
    def lastModified(self, value: "AuditStampClass") -> None:
        self._inner_dict['lastModified'] = value
    
    
class EntityChangeEventClass(DictWrapper):
    """Shared fields for all entity change events."""
    
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.platform.event.v1.EntityChangeEvent")
    def __init__(self,
        entityType: str,
        entityUrn: str,
        category: str,
        operation: str,
        auditStamp: "AuditStampClass",
        version: int,
        modifier: Union[None, str]=None,
        parameters: Union[None, "ParametersClass"]=None,
    ):
        super().__init__()
        
        self.entityType = entityType
        self.entityUrn = entityUrn
        self.category = category
        self.operation = operation
        self.modifier = modifier
        self.parameters = parameters
        self.auditStamp = auditStamp
        self.version = version
    
    def _restore_defaults(self) -> None:
        self.entityType = str()
        self.entityUrn = str()
        self.category = str()
        self.operation = str()
        self.modifier = self.RECORD_SCHEMA.fields_dict["modifier"].default
        self.parameters = self.RECORD_SCHEMA.fields_dict["parameters"].default
        self.auditStamp = AuditStampClass._construct_with_defaults()
        self.version = int()
    
    
    @property
    def entityType(self) -> str:
        """The type of the entity affected. Corresponds to the entity registry, e.g. 'dataset', 'chart', 'dashboard', etc."""
        return self._inner_dict.get('entityType')  # type: ignore
    
    @entityType.setter
    def entityType(self, value: str) -> None:
        self._inner_dict['entityType'] = value
    
    
    @property
    def entityUrn(self) -> str:
        """The urn of the entity which was affected."""
        return self._inner_dict.get('entityUrn')  # type: ignore
    
    @entityUrn.setter
    def entityUrn(self, value: str) -> None:
        self._inner_dict['entityUrn'] = value
    
    
    @property
    def category(self) -> str:
        """The category type (TAG, GLOSSARY_TERM, OWNERSHIP, TECHNICAL_SCHEMA, etc). This is used to determine what the rest of the schema will look like."""
        return self._inner_dict.get('category')  # type: ignore
    
    @category.setter
    def category(self, value: str) -> None:
        self._inner_dict['category'] = value
    
    
    @property
    def operation(self) -> str:
        """The operation type. This is used to determine what the rest of the schema will look like."""
        return self._inner_dict.get('operation')  # type: ignore
    
    @operation.setter
    def operation(self, value: str) -> None:
        self._inner_dict['operation'] = value
    
    
    @property
    def modifier(self) -> Union[None, str]:
        """The urn of the entity which was affected."""
        return self._inner_dict.get('modifier')  # type: ignore
    
    @modifier.setter
    def modifier(self, value: Union[None, str]) -> None:
        self._inner_dict['modifier'] = value
    
    
    @property
    def parameters(self) -> Union[None, "ParametersClass"]:
        """Arbitrary key-value parameters corresponding to the event."""
        return self._inner_dict.get('parameters')  # type: ignore
    
    @parameters.setter
    def parameters(self, value: Union[None, "ParametersClass"]) -> None:
        self._inner_dict['parameters'] = value
    
    
    @property
    def auditStamp(self) -> "AuditStampClass":
        """Audit stamp of the operation"""
        return self._inner_dict.get('auditStamp')  # type: ignore
    
    @auditStamp.setter
    def auditStamp(self, value: "AuditStampClass") -> None:
        self._inner_dict['auditStamp'] = value
    
    
    @property
    def version(self) -> int:
        """The version of the event type, incremented in integers."""
        return self._inner_dict.get('version')  # type: ignore
    
    @version.setter
    def version(self, value: int) -> None:
        self._inner_dict['version'] = value
    
    
class ParametersClass(DictWrapper):
    """Arbitrary key-value parameters for an Entity Change Event. (any record)."""
    
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.platform.event.v1.Parameters")
    def __init__(self,
    ):
        super().__init__()
        
    
    def _restore_defaults(self) -> None:
        pass
    
    
class DataHubActorFilterClass(DictWrapper):
    """Information used to filter DataHub actors."""
    
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.policy.DataHubActorFilter")
    def __init__(self,
        users: Union[None, List[str]]=None,
        groups: Union[None, List[str]]=None,
        resourceOwners: Optional[bool]=None,
        resourceOwnersTypes: Union[None, List[str]]=None,
        allUsers: Optional[bool]=None,
        allGroups: Optional[bool]=None,
        roles: Union[None, List[str]]=None,
    ):
        super().__init__()
        
        self.users = users
        self.groups = groups
        if resourceOwners is None:
            # default: False
            self.resourceOwners = self.RECORD_SCHEMA.fields_dict["resourceOwners"].default
        else:
            self.resourceOwners = resourceOwners
        self.resourceOwnersTypes = resourceOwnersTypes
        if allUsers is None:
            # default: False
            self.allUsers = self.RECORD_SCHEMA.fields_dict["allUsers"].default
        else:
            self.allUsers = allUsers
        if allGroups is None:
            # default: False
            self.allGroups = self.RECORD_SCHEMA.fields_dict["allGroups"].default
        else:
            self.allGroups = allGroups
        self.roles = roles
    
    def _restore_defaults(self) -> None:
        self.users = self.RECORD_SCHEMA.fields_dict["users"].default
        self.groups = self.RECORD_SCHEMA.fields_dict["groups"].default
        self.resourceOwners = self.RECORD_SCHEMA.fields_dict["resourceOwners"].default
        self.resourceOwnersTypes = self.RECORD_SCHEMA.fields_dict["resourceOwnersTypes"].default
        self.allUsers = self.RECORD_SCHEMA.fields_dict["allUsers"].default
        self.allGroups = self.RECORD_SCHEMA.fields_dict["allGroups"].default
        self.roles = self.RECORD_SCHEMA.fields_dict["roles"].default
    
    
    @property
    def users(self) -> Union[None, List[str]]:
        """A specific set of users to apply the policy to (disjunctive)"""
        return self._inner_dict.get('users')  # type: ignore
    
    @users.setter
    def users(self, value: Union[None, List[str]]) -> None:
        self._inner_dict['users'] = value
    
    
    @property
    def groups(self) -> Union[None, List[str]]:
        """A specific set of groups to apply the policy to (disjunctive)"""
        return self._inner_dict.get('groups')  # type: ignore
    
    @groups.setter
    def groups(self, value: Union[None, List[str]]) -> None:
        self._inner_dict['groups'] = value
    
    
    @property
    def resourceOwners(self) -> bool:
        """Whether the filter should return true for owners of a particular resource.
    Only applies to policies of type 'Metadata', which have a resource associated with them."""
        return self._inner_dict.get('resourceOwners')  # type: ignore
    
    @resourceOwners.setter
    def resourceOwners(self, value: bool) -> None:
        self._inner_dict['resourceOwners'] = value
    
    
    @property
    def resourceOwnersTypes(self) -> Union[None, List[str]]:
        """Define type of ownership for the policy"""
        return self._inner_dict.get('resourceOwnersTypes')  # type: ignore
    
    @resourceOwnersTypes.setter
    def resourceOwnersTypes(self, value: Union[None, List[str]]) -> None:
        self._inner_dict['resourceOwnersTypes'] = value
    
    
    @property
    def allUsers(self) -> bool:
        """Whether the filter should apply to all users."""
        return self._inner_dict.get('allUsers')  # type: ignore
    
    @allUsers.setter
    def allUsers(self, value: bool) -> None:
        self._inner_dict['allUsers'] = value
    
    
    @property
    def allGroups(self) -> bool:
        """Whether the filter should apply to all groups."""
        return self._inner_dict.get('allGroups')  # type: ignore
    
    @allGroups.setter
    def allGroups(self, value: bool) -> None:
        self._inner_dict['allGroups'] = value
    
    
    @property
    def roles(self) -> Union[None, List[str]]:
        """A specific set of roles to apply the policy to (disjunctive)."""
        return self._inner_dict.get('roles')  # type: ignore
    
    @roles.setter
    def roles(self, value: Union[None, List[str]]) -> None:
        self._inner_dict['roles'] = value
    
    
class DataHubPolicyInfoClass(_Aspect):
    """Information about a DataHub (UI) access policy."""


    ASPECT_NAME = 'dataHubPolicyInfo'
    ASPECT_INFO = {}
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.policy.DataHubPolicyInfo")

    def __init__(self,
        displayName: str,
        description: str,
        type: str,
        state: str,
        privileges: List[str],
        actors: "DataHubActorFilterClass",
        resources: Union[None, "DataHubResourceFilterClass"]=None,
        editable: Optional[bool]=None,
        lastUpdatedTimestamp: Union[None, int]=None,
    ):
        super().__init__()
        
        self.displayName = displayName
        self.description = description
        self.type = type
        self.state = state
        self.resources = resources
        self.privileges = privileges
        self.actors = actors
        if editable is None:
            # default: True
            self.editable = self.RECORD_SCHEMA.fields_dict["editable"].default
        else:
            self.editable = editable
        self.lastUpdatedTimestamp = lastUpdatedTimestamp
    
    def _restore_defaults(self) -> None:
        self.displayName = str()
        self.description = str()
        self.type = str()
        self.state = str()
        self.resources = self.RECORD_SCHEMA.fields_dict["resources"].default
        self.privileges = list()
        self.actors = DataHubActorFilterClass._construct_with_defaults()
        self.editable = self.RECORD_SCHEMA.fields_dict["editable"].default
        self.lastUpdatedTimestamp = self.RECORD_SCHEMA.fields_dict["lastUpdatedTimestamp"].default
    
    
    @property
    def displayName(self) -> str:
        """Display name of the Policy"""
        return self._inner_dict.get('displayName')  # type: ignore
    
    @displayName.setter
    def displayName(self, value: str) -> None:
        self._inner_dict['displayName'] = value
    
    
    @property
    def description(self) -> str:
        """Description of the Policy"""
        return self._inner_dict.get('description')  # type: ignore
    
    @description.setter
    def description(self, value: str) -> None:
        self._inner_dict['description'] = value
    
    
    @property
    def type(self) -> str:
        """The type of policy"""
        return self._inner_dict.get('type')  # type: ignore
    
    @type.setter
    def type(self, value: str) -> None:
        self._inner_dict['type'] = value
    
    
    @property
    def state(self) -> str:
        """The state of policy, ACTIVE or INACTIVE"""
        return self._inner_dict.get('state')  # type: ignore
    
    @state.setter
    def state(self, value: str) -> None:
        self._inner_dict['state'] = value
    
    
    @property
    def resources(self) -> Union[None, "DataHubResourceFilterClass"]:
        """The resource that the policy applies to. Not required for some 'Platform' privileges."""
        return self._inner_dict.get('resources')  # type: ignore
    
    @resources.setter
    def resources(self, value: Union[None, "DataHubResourceFilterClass"]) -> None:
        self._inner_dict['resources'] = value
    
    
    @property
    def privileges(self) -> List[str]:
        """The privileges that the policy grants."""
        return self._inner_dict.get('privileges')  # type: ignore
    
    @privileges.setter
    def privileges(self, value: List[str]) -> None:
        self._inner_dict['privileges'] = value
    
    
    @property
    def actors(self) -> "DataHubActorFilterClass":
        """The actors that the policy applies to."""
        return self._inner_dict.get('actors')  # type: ignore
    
    @actors.setter
    def actors(self, value: "DataHubActorFilterClass") -> None:
        self._inner_dict['actors'] = value
    
    
    @property
    def editable(self) -> bool:
        """Whether the policy should be editable via the UI"""
        return self._inner_dict.get('editable')  # type: ignore
    
    @editable.setter
    def editable(self, value: bool) -> None:
        self._inner_dict['editable'] = value
    
    
    @property
    def lastUpdatedTimestamp(self) -> Union[None, int]:
        """Timestamp when the policy was last updated"""
        return self._inner_dict.get('lastUpdatedTimestamp')  # type: ignore
    
    @lastUpdatedTimestamp.setter
    def lastUpdatedTimestamp(self, value: Union[None, int]) -> None:
        self._inner_dict['lastUpdatedTimestamp'] = value
    
    
class DataHubResourceFilterClass(DictWrapper):
    """Information used to filter DataHub resource."""
    
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.policy.DataHubResourceFilter")
    def __init__(self,
        type: Union[None, str]=None,
        resources: Union[None, List[str]]=None,
        allResources: Optional[bool]=None,
        filter: Union[None, "PolicyMatchFilterClass"]=None,
    ):
        super().__init__()
        
        self.type = type
        self.resources = resources
        if allResources is None:
            # default: False
            self.allResources = self.RECORD_SCHEMA.fields_dict["allResources"].default
        else:
            self.allResources = allResources
        self.filter = filter
    
    def _restore_defaults(self) -> None:
        self.type = self.RECORD_SCHEMA.fields_dict["type"].default
        self.resources = self.RECORD_SCHEMA.fields_dict["resources"].default
        self.allResources = self.RECORD_SCHEMA.fields_dict["allResources"].default
        self.filter = self.RECORD_SCHEMA.fields_dict["filter"].default
    
    
    @property
    def type(self) -> Union[None, str]:
        """The type of resource that the policy applies to. This will most often be a data asset entity name, for
    example 'dataset'. It is not strictly required because in the future we will want to support filtering a resource
    by domain, as well."""
        return self._inner_dict.get('type')  # type: ignore
    
    @type.setter
    def type(self, value: Union[None, str]) -> None:
        self._inner_dict['type'] = value
    
    
    @property
    def resources(self) -> Union[None, List[str]]:
        """A specific set of resources to apply the policy to, e.g. asset urns"""
        return self._inner_dict.get('resources')  # type: ignore
    
    @resources.setter
    def resources(self, value: Union[None, List[str]]) -> None:
        self._inner_dict['resources'] = value
    
    
    @property
    def allResources(self) -> bool:
        """Whether the policy should be applied to all assets matching the filter."""
        return self._inner_dict.get('allResources')  # type: ignore
    
    @allResources.setter
    def allResources(self, value: bool) -> None:
        self._inner_dict['allResources'] = value
    
    
    @property
    def filter(self) -> Union[None, "PolicyMatchFilterClass"]:
        """Filter to apply privileges to"""
        return self._inner_dict.get('filter')  # type: ignore
    
    @filter.setter
    def filter(self, value: Union[None, "PolicyMatchFilterClass"]) -> None:
        self._inner_dict['filter'] = value
    
    
class DataHubRoleInfoClass(_Aspect):
    """Information about a DataHub Role."""


    ASPECT_NAME = 'dataHubRoleInfo'
    ASPECT_INFO = {}
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.policy.DataHubRoleInfo")

    def __init__(self,
        name: str,
        description: str,
        editable: Optional[bool]=None,
    ):
        super().__init__()
        
        self.name = name
        self.description = description
        if editable is None:
            # default: False
            self.editable = self.RECORD_SCHEMA.fields_dict["editable"].default
        else:
            self.editable = editable
    
    def _restore_defaults(self) -> None:
        self.name = str()
        self.description = str()
        self.editable = self.RECORD_SCHEMA.fields_dict["editable"].default
    
    
    @property
    def name(self) -> str:
        """Name of the Role"""
        return self._inner_dict.get('name')  # type: ignore
    
    @name.setter
    def name(self, value: str) -> None:
        self._inner_dict['name'] = value
    
    
    @property
    def description(self) -> str:
        """Description of the Role"""
        return self._inner_dict.get('description')  # type: ignore
    
    @description.setter
    def description(self, value: str) -> None:
        self._inner_dict['description'] = value
    
    
    @property
    def editable(self) -> bool:
        """Whether the role should be editable via the UI"""
        return self._inner_dict.get('editable')  # type: ignore
    
    @editable.setter
    def editable(self, value: bool) -> None:
        self._inner_dict['editable'] = value
    
    
class PolicyMatchConditionClass(object):
    """The matching condition in a filter criterion"""
    
    EQUALS = "EQUALS"
    """Whether the field matches the value"""
    
    
    
class PolicyMatchCriterionClass(DictWrapper):
    """A criterion for matching a field with given value"""
    
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.policy.PolicyMatchCriterion")
    def __init__(self,
        field: str,
        values: List[str],
        condition: Optional[Union[str, "PolicyMatchConditionClass"]]=None,
    ):
        super().__init__()
        
        self.field = field
        self.values = values
        if condition is None:
            # default: 'EQUALS'
            self.condition = self.RECORD_SCHEMA.fields_dict["condition"].default
        else:
            self.condition = condition
    
    def _restore_defaults(self) -> None:
        self.field = str()
        self.values = list()
        self.condition = self.RECORD_SCHEMA.fields_dict["condition"].default
    
    
    @property
    def field(self) -> str:
        """The name of the field that the criterion refers to"""
        return self._inner_dict.get('field')  # type: ignore
    
    @field.setter
    def field(self, value: str) -> None:
        self._inner_dict['field'] = value
    
    
    @property
    def values(self) -> List[str]:
        """Values. Matches criterion if any one of the values matches condition (OR-relationship)"""
        return self._inner_dict.get('values')  # type: ignore
    
    @values.setter
    def values(self, value: List[str]) -> None:
        self._inner_dict['values'] = value
    
    
    @property
    def condition(self) -> Union[str, "PolicyMatchConditionClass"]:
        """The condition for the criterion"""
        return self._inner_dict.get('condition')  # type: ignore
    
    @condition.setter
    def condition(self, value: Union[str, "PolicyMatchConditionClass"]) -> None:
        self._inner_dict['condition'] = value
    
    
class PolicyMatchFilterClass(DictWrapper):
    """The filter for specifying the resource or actor to apply privileges to"""
    
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.policy.PolicyMatchFilter")
    def __init__(self,
        criteria: List["PolicyMatchCriterionClass"],
    ):
        super().__init__()
        
        self.criteria = criteria
    
    def _restore_defaults(self) -> None:
        self.criteria = list()
    
    
    @property
    def criteria(self) -> List["PolicyMatchCriterionClass"]:
        """A list of criteria to apply conjunctively (so all criteria must pass)"""
        return self._inner_dict.get('criteria')  # type: ignore
    
    @criteria.setter
    def criteria(self, value: List["PolicyMatchCriterionClass"]) -> None:
        self._inner_dict['criteria'] = value
    
    
class PostContentClass(DictWrapper):
    """Content stored inside a Post."""
    
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.post.PostContent")
    def __init__(self,
        title: str,
        type: Union[str, "PostContentTypeClass"],
        description: Union[None, str]=None,
        link: Union[None, str]=None,
        media: Union[None, "MediaClass"]=None,
    ):
        super().__init__()
        
        self.title = title
        self.type = type
        self.description = description
        self.link = link
        self.media = media
    
    def _restore_defaults(self) -> None:
        self.title = str()
        self.type = PostContentTypeClass.TEXT
        self.description = self.RECORD_SCHEMA.fields_dict["description"].default
        self.link = self.RECORD_SCHEMA.fields_dict["link"].default
        self.media = self.RECORD_SCHEMA.fields_dict["media"].default
    
    
    @property
    def title(self) -> str:
        """Title of the post."""
        return self._inner_dict.get('title')  # type: ignore
    
    @title.setter
    def title(self, value: str) -> None:
        self._inner_dict['title'] = value
    
    
    @property
    def type(self) -> Union[str, "PostContentTypeClass"]:
        """Type of content held in the post."""
        return self._inner_dict.get('type')  # type: ignore
    
    @type.setter
    def type(self, value: Union[str, "PostContentTypeClass"]) -> None:
        self._inner_dict['type'] = value
    
    
    @property
    def description(self) -> Union[None, str]:
        """Optional description of the post."""
        return self._inner_dict.get('description')  # type: ignore
    
    @description.setter
    def description(self, value: Union[None, str]) -> None:
        self._inner_dict['description'] = value
    
    
    @property
    def link(self) -> Union[None, str]:
        """Optional link that the post is associated with."""
        return self._inner_dict.get('link')  # type: ignore
    
    @link.setter
    def link(self, value: Union[None, str]) -> None:
        self._inner_dict['link'] = value
    
    
    @property
    def media(self) -> Union[None, "MediaClass"]:
        """Optional media that the post is storing"""
        return self._inner_dict.get('media')  # type: ignore
    
    @media.setter
    def media(self, value: Union[None, "MediaClass"]) -> None:
        self._inner_dict['media'] = value
    
    
class PostContentTypeClass(object):
    """Enum defining the type of content held in a Post."""
    
    TEXT = "TEXT"
    """Text content"""
    
    LINK = "LINK"
    """Link content"""
    
    
    
class PostInfoClass(_Aspect):
    """Information about a DataHub Post."""


    ASPECT_NAME = 'postInfo'
    ASPECT_INFO = {}
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.post.PostInfo")

    def __init__(self,
        type: Union[str, "PostTypeClass"],
        content: "PostContentClass",
        created: int,
        lastModified: int,
    ):
        super().__init__()
        
        self.type = type
        self.content = content
        self.created = created
        self.lastModified = lastModified
    
    def _restore_defaults(self) -> None:
        self.type = PostTypeClass.HOME_PAGE_ANNOUNCEMENT
        self.content = PostContentClass._construct_with_defaults()
        self.created = int()
        self.lastModified = int()
    
    
    @property
    def type(self) -> Union[str, "PostTypeClass"]:
        """Type of the Post."""
        return self._inner_dict.get('type')  # type: ignore
    
    @type.setter
    def type(self, value: Union[str, "PostTypeClass"]) -> None:
        self._inner_dict['type'] = value
    
    
    @property
    def content(self) -> "PostContentClass":
        """Content stored in the post."""
        return self._inner_dict.get('content')  # type: ignore
    
    @content.setter
    def content(self, value: "PostContentClass") -> None:
        self._inner_dict['content'] = value
    
    
    @property
    def created(self) -> int:
        """The time at which the post was initially created"""
        return self._inner_dict.get('created')  # type: ignore
    
    @created.setter
    def created(self, value: int) -> None:
        self._inner_dict['created'] = value
    
    
    @property
    def lastModified(self) -> int:
        """The time at which the post was last modified"""
        return self._inner_dict.get('lastModified')  # type: ignore
    
    @lastModified.setter
    def lastModified(self, value: int) -> None:
        self._inner_dict['lastModified'] = value
    
    
class PostTypeClass(object):
    """Enum defining types of Posts."""
    
    HOME_PAGE_ANNOUNCEMENT = "HOME_PAGE_ANNOUNCEMENT"
    """The Post is an Home Page announcement."""
    
    
    
class QueryLanguageClass(object):
    # No docs available.
    
    SQL = "SQL"
    """A SQL Query"""
    
    
    
class QueryPropertiesClass(_Aspect):
    """Information about a Query against one or more data assets (e.g. Tables or Views)."""


    ASPECT_NAME = 'queryProperties'
    ASPECT_INFO = {}
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.query.QueryProperties")

    def __init__(self,
        statement: "QueryStatementClass",
        source: Union[str, "QuerySourceClass"],
        created: "AuditStampClass",
        lastModified: "AuditStampClass",
        name: Union[None, str]=None,
        description: Union[None, str]=None,
        origin: Union[None, str]=None,
    ):
        super().__init__()
        
        self.statement = statement
        self.source = source
        self.name = name
        self.description = description
        self.created = created
        self.lastModified = lastModified
        self.origin = origin
    
    def _restore_defaults(self) -> None:
        self.statement = QueryStatementClass._construct_with_defaults()
        self.source = QuerySourceClass.MANUAL
        self.name = self.RECORD_SCHEMA.fields_dict["name"].default
        self.description = self.RECORD_SCHEMA.fields_dict["description"].default
        self.created = AuditStampClass._construct_with_defaults()
        self.lastModified = AuditStampClass._construct_with_defaults()
        self.origin = self.RECORD_SCHEMA.fields_dict["origin"].default
    
    
    @property
    def statement(self) -> "QueryStatementClass":
        """The Query Statement."""
        return self._inner_dict.get('statement')  # type: ignore
    
    @statement.setter
    def statement(self, value: "QueryStatementClass") -> None:
        self._inner_dict['statement'] = value
    
    
    @property
    def source(self) -> Union[str, "QuerySourceClass"]:
        """The source of the Query"""
        return self._inner_dict.get('source')  # type: ignore
    
    @source.setter
    def source(self, value: Union[str, "QuerySourceClass"]) -> None:
        self._inner_dict['source'] = value
    
    
    @property
    def name(self) -> Union[None, str]:
        """Optional display name to identify the query."""
        return self._inner_dict.get('name')  # type: ignore
    
    @name.setter
    def name(self, value: Union[None, str]) -> None:
        self._inner_dict['name'] = value
    
    
    @property
    def description(self) -> Union[None, str]:
        """The Query description."""
        return self._inner_dict.get('description')  # type: ignore
    
    @description.setter
    def description(self, value: Union[None, str]) -> None:
        self._inner_dict['description'] = value
    
    
    @property
    def created(self) -> "AuditStampClass":
        """Audit stamp capturing the time and actor who created the Query."""
        return self._inner_dict.get('created')  # type: ignore
    
    @created.setter
    def created(self, value: "AuditStampClass") -> None:
        self._inner_dict['created'] = value
    
    
    @property
    def lastModified(self) -> "AuditStampClass":
        """Audit stamp capturing the time and actor who last modified the Query."""
        return self._inner_dict.get('lastModified')  # type: ignore
    
    @lastModified.setter
    def lastModified(self, value: "AuditStampClass") -> None:
        self._inner_dict['lastModified'] = value
    
    
    @property
    def origin(self) -> Union[None, str]:
        """The origin of the Query.
    This is the source of the Query (e.g. a View, Stored Procedure, dbt Model, etc.) that the Query was created from."""
        return self._inner_dict.get('origin')  # type: ignore
    
    @origin.setter
    def origin(self, value: Union[None, str]) -> None:
        self._inner_dict['origin'] = value
    
    
class QuerySourceClass(object):
    # No docs available.
    
    MANUAL = "MANUAL"
    """The query was entered manually by a user (via the UI)."""
    
    SYSTEM = "SYSTEM"
    """The query was discovered by a crawler."""
    
    
    
class QueryStatementClass(DictWrapper):
    """A query statement against one or more data assets."""
    
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.query.QueryStatement")
    def __init__(self,
        value: str,
        language: Optional[Union[str, "QueryLanguageClass"]]=None,
    ):
        super().__init__()
        
        self.value = value
        if language is None:
            # default: 'SQL'
            self.language = self.RECORD_SCHEMA.fields_dict["language"].default
        else:
            self.language = language
    
    def _restore_defaults(self) -> None:
        self.value = str()
        self.language = self.RECORD_SCHEMA.fields_dict["language"].default
    
    
    @property
    def value(self) -> str:
        """The query text"""
        return self._inner_dict.get('value')  # type: ignore
    
    @value.setter
    def value(self, value: str) -> None:
        self._inner_dict['value'] = value
    
    
    @property
    def language(self) -> Union[str, "QueryLanguageClass"]:
        """The language of the Query, e.g. SQL."""
        return self._inner_dict.get('language')  # type: ignore
    
    @language.setter
    def language(self, value: Union[str, "QueryLanguageClass"]) -> None:
        self._inner_dict['language'] = value
    
    
class QuerySubjectClass(DictWrapper):
    """A single subject of a particular query.
    In the future, we may evolve this model to include richer details
    about the Query Subject in relation to the query."""
    
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.query.QuerySubject")
    def __init__(self,
        entity: str,
    ):
        super().__init__()
        
        self.entity = entity
    
    def _restore_defaults(self) -> None:
        self.entity = str()
    
    
    @property
    def entity(self) -> str:
        """An entity which is the subject of a query."""
        return self._inner_dict.get('entity')  # type: ignore
    
    @entity.setter
    def entity(self, value: str) -> None:
        self._inner_dict['entity'] = value
    
    
class QuerySubjectsClass(_Aspect):
    """Information about the subjects of a particular Query, i.e. the assets
    being queried."""


    ASPECT_NAME = 'querySubjects'
    ASPECT_INFO = {}
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.query.QuerySubjects")

    def __init__(self,
        subjects: List["QuerySubjectClass"],
    ):
        super().__init__()
        
        self.subjects = subjects
    
    def _restore_defaults(self) -> None:
        self.subjects = list()
    
    
    @property
    def subjects(self) -> List["QuerySubjectClass"]:
        """One or more subjects of the query.
    
    In single-asset queries (e.g. table select), this will contain the Table reference
    and optionally schema field references.
    
    In multi-asset queries (e.g. table joins), this may contain multiple Table references
    and optionally schema field references."""
        return self._inner_dict.get('subjects')  # type: ignore
    
    @subjects.setter
    def subjects(self, value: List["QuerySubjectClass"]) -> None:
        self._inner_dict['subjects'] = value
    
    
class DataHubRetentionConfigClass(_Aspect):
    # No docs available.


    ASPECT_NAME = 'dataHubRetentionConfig'
    ASPECT_INFO = {}
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.retention.DataHubRetentionConfig")

    def __init__(self,
        retention: "RetentionClass",
    ):
        super().__init__()
        
        self.retention = retention
    
    def _restore_defaults(self) -> None:
        self.retention = RetentionClass._construct_with_defaults()
    
    
    @property
    def retention(self) -> "RetentionClass":
        # No docs available.
        return self._inner_dict.get('retention')  # type: ignore
    
    @retention.setter
    def retention(self, value: "RetentionClass") -> None:
        self._inner_dict['retention'] = value
    
    
class RetentionClass(DictWrapper):
    """Base class that encapsulates different retention policies.
    Only one of the fields should be set"""
    
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.retention.Retention")
    def __init__(self,
        version: Union[None, "VersionBasedRetentionClass"]=None,
        time: Union[None, "TimeBasedRetentionClass"]=None,
    ):
        super().__init__()
        
        self.version = version
        self.time = time
    
    def _restore_defaults(self) -> None:
        self.version = self.RECORD_SCHEMA.fields_dict["version"].default
        self.time = self.RECORD_SCHEMA.fields_dict["time"].default
    
    
    @property
    def version(self) -> Union[None, "VersionBasedRetentionClass"]:
        # No docs available.
        return self._inner_dict.get('version')  # type: ignore
    
    @version.setter
    def version(self, value: Union[None, "VersionBasedRetentionClass"]) -> None:
        self._inner_dict['version'] = value
    
    
    @property
    def time(self) -> Union[None, "TimeBasedRetentionClass"]:
        # No docs available.
        return self._inner_dict.get('time')  # type: ignore
    
    @time.setter
    def time(self, value: Union[None, "TimeBasedRetentionClass"]) -> None:
        self._inner_dict['time'] = value
    
    
class TimeBasedRetentionClass(DictWrapper):
    """Keep records that are less than X seconds old"""
    
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.retention.TimeBasedRetention")
    def __init__(self,
        maxAgeInSeconds: int,
    ):
        super().__init__()
        
        self.maxAgeInSeconds = maxAgeInSeconds
    
    def _restore_defaults(self) -> None:
        self.maxAgeInSeconds = int()
    
    
    @property
    def maxAgeInSeconds(self) -> int:
        # No docs available.
        return self._inner_dict.get('maxAgeInSeconds')  # type: ignore
    
    @maxAgeInSeconds.setter
    def maxAgeInSeconds(self, value: int) -> None:
        self._inner_dict['maxAgeInSeconds'] = value
    
    
class VersionBasedRetentionClass(DictWrapper):
    """Keep max N latest records"""
    
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.retention.VersionBasedRetention")
    def __init__(self,
        maxVersions: int,
    ):
        super().__init__()
        
        self.maxVersions = maxVersions
    
    def _restore_defaults(self) -> None:
        self.maxVersions = int()
    
    
    @property
    def maxVersions(self) -> int:
        # No docs available.
        return self._inner_dict.get('maxVersions')  # type: ignore
    
    @maxVersions.setter
    def maxVersions(self, value: int) -> None:
        self._inner_dict['maxVersions'] = value
    
    
class ActorsClass(_Aspect):
    """Provisioned users of a role"""


    ASPECT_NAME = 'actors'
    ASPECT_INFO = {}
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.role.Actors")

    def __init__(self,
        users: Union[None, List["RoleUserClass"]]=None,
    ):
        super().__init__()
        
        self.users = users
    
    def _restore_defaults(self) -> None:
        self.users = self.RECORD_SCHEMA.fields_dict["users"].default
    
    
    @property
    def users(self) -> Union[None, List["RoleUserClass"]]:
        """List of provisioned users of a role"""
        return self._inner_dict.get('users')  # type: ignore
    
    @users.setter
    def users(self, value: Union[None, List["RoleUserClass"]]) -> None:
        self._inner_dict['users'] = value
    
    
class RolePropertiesClass(_Aspect):
    """Information about a ExternalRoleProperties"""


    ASPECT_NAME = 'roleProperties'
    ASPECT_INFO = {}
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.role.RoleProperties")

    def __init__(self,
        name: str,
        type: str,
        description: Union[None, str]=None,
        requestUrl: Union[None, str]=None,
        created: Union[None, "AuditStampClass"]=None,
    ):
        super().__init__()
        
        self.name = name
        self.description = description
        self.type = type
        self.requestUrl = requestUrl
        self.created = created
    
    def _restore_defaults(self) -> None:
        self.name = str()
        self.description = self.RECORD_SCHEMA.fields_dict["description"].default
        self.type = str()
        self.requestUrl = self.RECORD_SCHEMA.fields_dict["requestUrl"].default
        self.created = self.RECORD_SCHEMA.fields_dict["created"].default
    
    
    @property
    def name(self) -> str:
        """Display name of the IAM Role in the external system"""
        return self._inner_dict.get('name')  # type: ignore
    
    @name.setter
    def name(self, value: str) -> None:
        self._inner_dict['name'] = value
    
    
    @property
    def description(self) -> Union[None, str]:
        """Description of the IAM Role"""
        return self._inner_dict.get('description')  # type: ignore
    
    @description.setter
    def description(self, value: Union[None, str]) -> None:
        self._inner_dict['description'] = value
    
    
    @property
    def type(self) -> str:
        """Can be READ, ADMIN, WRITE"""
        return self._inner_dict.get('type')  # type: ignore
    
    @type.setter
    def type(self, value: str) -> None:
        self._inner_dict['type'] = value
    
    
    @property
    def requestUrl(self) -> Union[None, str]:
        """Link to access external access management"""
        return self._inner_dict.get('requestUrl')  # type: ignore
    
    @requestUrl.setter
    def requestUrl(self, value: Union[None, str]) -> None:
        self._inner_dict['requestUrl'] = value
    
    
    @property
    def created(self) -> Union[None, "AuditStampClass"]:
        """Created Audit stamp"""
        return self._inner_dict.get('created')  # type: ignore
    
    @created.setter
    def created(self, value: Union[None, "AuditStampClass"]) -> None:
        self._inner_dict['created'] = value
    
    
class RoleUserClass(DictWrapper):
    """Provisioned users of a role"""
    
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.role.RoleUser")
    def __init__(self,
        user: str,
    ):
        super().__init__()
        
        self.user = user
    
    def _restore_defaults(self) -> None:
        self.user = str()
    
    
    @property
    def user(self) -> str:
        """Link provisioned corp user for a role"""
        return self._inner_dict.get('user')  # type: ignore
    
    @user.setter
    def user(self, value: str) -> None:
        self._inner_dict['user'] = value
    
    
class ArrayTypeClass(DictWrapper):
    """Array field type."""
    
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.schema.ArrayType")
    def __init__(self,
        nestedType: Union[None, List[str]]=None,
    ):
        super().__init__()
        
        self.nestedType = nestedType
    
    def _restore_defaults(self) -> None:
        self.nestedType = self.RECORD_SCHEMA.fields_dict["nestedType"].default
    
    
    @property
    def nestedType(self) -> Union[None, List[str]]:
        """List of types this array holds."""
        return self._inner_dict.get('nestedType')  # type: ignore
    
    @nestedType.setter
    def nestedType(self, value: Union[None, List[str]]) -> None:
        self._inner_dict['nestedType'] = value
    
    
class BinaryJsonSchemaClass(DictWrapper):
    """Schema text of binary JSON schema."""
    
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.schema.BinaryJsonSchema")
    def __init__(self,
        schema: str,
    ):
        super().__init__()
        
        self.schema = schema
    
    def _restore_defaults(self) -> None:
        self.schema = str()
    
    
    @property
    def schema(self) -> str:
        """The native schema text for binary JSON file format."""
        return self._inner_dict.get('schema')  # type: ignore
    
    @schema.setter
    def schema(self, value: str) -> None:
        self._inner_dict['schema'] = value
    
    
class BooleanTypeClass(DictWrapper):
    """Boolean field type."""
    
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.schema.BooleanType")
    def __init__(self,
    ):
        super().__init__()
        
    
    def _restore_defaults(self) -> None:
        pass
    
    
class BytesTypeClass(DictWrapper):
    """Bytes field type."""
    
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.schema.BytesType")
    def __init__(self,
    ):
        super().__init__()
        
    
    def _restore_defaults(self) -> None:
        pass
    
    
class DatasetFieldForeignKeyClass(DictWrapper):
    """For non-urn based foregin keys."""
    
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.schema.DatasetFieldForeignKey")
    def __init__(self,
        parentDataset: str,
        currentFieldPaths: List[str],
        parentField: str,
    ):
        super().__init__()
        
        self.parentDataset = parentDataset
        self.currentFieldPaths = currentFieldPaths
        self.parentField = parentField
    
    def _restore_defaults(self) -> None:
        self.parentDataset = str()
        self.currentFieldPaths = list()
        self.parentField = str()
    
    
    @property
    def parentDataset(self) -> str:
        """dataset that stores the resource."""
        return self._inner_dict.get('parentDataset')  # type: ignore
    
    @parentDataset.setter
    def parentDataset(self, value: str) -> None:
        self._inner_dict['parentDataset'] = value
    
    
    @property
    def currentFieldPaths(self) -> List[str]:
        """List of fields in hosting(current) SchemaMetadata that conform a foreign key. List can contain a single entry or multiple entries if several entries in hosting schema conform a foreign key in a single parent dataset."""
        return self._inner_dict.get('currentFieldPaths')  # type: ignore
    
    @currentFieldPaths.setter
    def currentFieldPaths(self, value: List[str]) -> None:
        self._inner_dict['currentFieldPaths'] = value
    
    
    @property
    def parentField(self) -> str:
        """SchemaField@fieldPath that uniquely identify field in parent dataset that this field references."""
        return self._inner_dict.get('parentField')  # type: ignore
    
    @parentField.setter
    def parentField(self, value: str) -> None:
        self._inner_dict['parentField'] = value
    
    
class DateTypeClass(DictWrapper):
    """Date field type."""
    
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.schema.DateType")
    def __init__(self,
    ):
        super().__init__()
        
    
    def _restore_defaults(self) -> None:
        pass
    
    
class EditableSchemaFieldInfoClass(DictWrapper):
    """SchemaField to describe metadata related to dataset schema."""
    
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.schema.EditableSchemaFieldInfo")
    def __init__(self,
        fieldPath: str,
        description: Union[None, str]=None,
        globalTags: Union[None, "GlobalTagsClass"]=None,
        glossaryTerms: Union[None, "GlossaryTermsClass"]=None,
    ):
        super().__init__()
        
        self.fieldPath = fieldPath
        self.description = description
        self.globalTags = globalTags
        self.glossaryTerms = glossaryTerms
    
    def _restore_defaults(self) -> None:
        self.fieldPath = str()
        self.description = self.RECORD_SCHEMA.fields_dict["description"].default
        self.globalTags = self.RECORD_SCHEMA.fields_dict["globalTags"].default
        self.glossaryTerms = self.RECORD_SCHEMA.fields_dict["glossaryTerms"].default
    
    
    @property
    def fieldPath(self) -> str:
        """FieldPath uniquely identifying the SchemaField this metadata is associated with"""
        return self._inner_dict.get('fieldPath')  # type: ignore
    
    @fieldPath.setter
    def fieldPath(self, value: str) -> None:
        self._inner_dict['fieldPath'] = value
    
    
    @property
    def description(self) -> Union[None, str]:
        """Description"""
        return self._inner_dict.get('description')  # type: ignore
    
    @description.setter
    def description(self, value: Union[None, str]) -> None:
        self._inner_dict['description'] = value
    
    
    @property
    def globalTags(self) -> Union[None, "GlobalTagsClass"]:
        """Tags associated with the field"""
        return self._inner_dict.get('globalTags')  # type: ignore
    
    @globalTags.setter
    def globalTags(self, value: Union[None, "GlobalTagsClass"]) -> None:
        self._inner_dict['globalTags'] = value
    
    
    @property
    def glossaryTerms(self) -> Union[None, "GlossaryTermsClass"]:
        """Glossary terms associated with the field"""
        return self._inner_dict.get('glossaryTerms')  # type: ignore
    
    @glossaryTerms.setter
    def glossaryTerms(self, value: Union[None, "GlossaryTermsClass"]) -> None:
        self._inner_dict['glossaryTerms'] = value
    
    
class EditableSchemaMetadataClass(_Aspect):
    """EditableSchemaMetadata stores editable changes made to schema metadata. This separates changes made from
    ingestion pipelines and edits in the UI to avoid accidental overwrites of user-provided data by ingestion pipelines."""


    ASPECT_NAME = 'editableSchemaMetadata'
    ASPECT_INFO = {}
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.schema.EditableSchemaMetadata")

    def __init__(self,
        editableSchemaFieldInfo: List["EditableSchemaFieldInfoClass"],
        created: Optional["AuditStampClass"]=None,
        lastModified: Optional["AuditStampClass"]=None,
        deleted: Union[None, "AuditStampClass"]=None,
    ):
        super().__init__()
        
        if created is None:
            # default: {'actor': 'urn:li:corpuser:unknown', 'impersonator': None, 'time': 0, 'message': None}
            self.created = _json_converter.from_json_object(self.RECORD_SCHEMA.fields_dict["created"].default, writers_schema=self.RECORD_SCHEMA.fields_dict["created"].type)
        else:
            self.created = created
        if lastModified is None:
            # default: {'actor': 'urn:li:corpuser:unknown', 'impersonator': None, 'time': 0, 'message': None}
            self.lastModified = _json_converter.from_json_object(self.RECORD_SCHEMA.fields_dict["lastModified"].default, writers_schema=self.RECORD_SCHEMA.fields_dict["lastModified"].type)
        else:
            self.lastModified = lastModified
        self.deleted = deleted
        self.editableSchemaFieldInfo = editableSchemaFieldInfo
    
    def _restore_defaults(self) -> None:
        self.created = _json_converter.from_json_object(self.RECORD_SCHEMA.fields_dict["created"].default, writers_schema=self.RECORD_SCHEMA.fields_dict["created"].type)
        self.lastModified = _json_converter.from_json_object(self.RECORD_SCHEMA.fields_dict["lastModified"].default, writers_schema=self.RECORD_SCHEMA.fields_dict["lastModified"].type)
        self.deleted = self.RECORD_SCHEMA.fields_dict["deleted"].default
        self.editableSchemaFieldInfo = list()
    
    
    @property
    def created(self) -> "AuditStampClass":
        """An AuditStamp corresponding to the creation of this resource/association/sub-resource. A value of 0 for time indicates missing data."""
        return self._inner_dict.get('created')  # type: ignore
    
    @created.setter
    def created(self, value: "AuditStampClass") -> None:
        self._inner_dict['created'] = value
    
    
    @property
    def lastModified(self) -> "AuditStampClass":
        """An AuditStamp corresponding to the last modification of this resource/association/sub-resource. If no modification has happened since creation, lastModified should be the same as created. A value of 0 for time indicates missing data."""
        return self._inner_dict.get('lastModified')  # type: ignore
    
    @lastModified.setter
    def lastModified(self, value: "AuditStampClass") -> None:
        self._inner_dict['lastModified'] = value
    
    
    @property
    def deleted(self) -> Union[None, "AuditStampClass"]:
        """An AuditStamp corresponding to the deletion of this resource/association/sub-resource. Logically, deleted MUST have a later timestamp than creation. It may or may not have the same time as lastModified depending upon the resource/association/sub-resource semantics."""
        return self._inner_dict.get('deleted')  # type: ignore
    
    @deleted.setter
    def deleted(self, value: Union[None, "AuditStampClass"]) -> None:
        self._inner_dict['deleted'] = value
    
    
    @property
    def editableSchemaFieldInfo(self) -> List["EditableSchemaFieldInfoClass"]:
        """Client provided a list of fields from document schema."""
        return self._inner_dict.get('editableSchemaFieldInfo')  # type: ignore
    
    @editableSchemaFieldInfo.setter
    def editableSchemaFieldInfo(self, value: List["EditableSchemaFieldInfoClass"]) -> None:
        self._inner_dict['editableSchemaFieldInfo'] = value
    
    
class EnumTypeClass(DictWrapper):
    """Enum field type."""
    
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.schema.EnumType")
    def __init__(self,
    ):
        super().__init__()
        
    
    def _restore_defaults(self) -> None:
        pass
    
    
class EspressoSchemaClass(DictWrapper):
    """Schema text of an espresso table schema."""
    
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.schema.EspressoSchema")
    def __init__(self,
        documentSchema: str,
        tableSchema: str,
    ):
        super().__init__()
        
        self.documentSchema = documentSchema
        self.tableSchema = tableSchema
    
    def _restore_defaults(self) -> None:
        self.documentSchema = str()
        self.tableSchema = str()
    
    
    @property
    def documentSchema(self) -> str:
        """The native espresso document schema."""
        return self._inner_dict.get('documentSchema')  # type: ignore
    
    @documentSchema.setter
    def documentSchema(self, value: str) -> None:
        self._inner_dict['documentSchema'] = value
    
    
    @property
    def tableSchema(self) -> str:
        """The espresso table schema definition."""
        return self._inner_dict.get('tableSchema')  # type: ignore
    
    @tableSchema.setter
    def tableSchema(self, value: str) -> None:
        self._inner_dict['tableSchema'] = value
    
    
class FixedTypeClass(DictWrapper):
    """Fixed field type."""
    
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.schema.FixedType")
    def __init__(self,
    ):
        super().__init__()
        
    
    def _restore_defaults(self) -> None:
        pass
    
    
class ForeignKeyConstraintClass(DictWrapper):
    """Description of a foreign key constraint in a schema."""
    
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.schema.ForeignKeyConstraint")
    def __init__(self,
        name: str,
        foreignFields: List[str],
        sourceFields: List[str],
        foreignDataset: str,
    ):
        super().__init__()
        
        self.name = name
        self.foreignFields = foreignFields
        self.sourceFields = sourceFields
        self.foreignDataset = foreignDataset
    
    def _restore_defaults(self) -> None:
        self.name = str()
        self.foreignFields = list()
        self.sourceFields = list()
        self.foreignDataset = str()
    
    
    @property
    def name(self) -> str:
        """Name of the constraint, likely provided from the source"""
        return self._inner_dict.get('name')  # type: ignore
    
    @name.setter
    def name(self, value: str) -> None:
        self._inner_dict['name'] = value
    
    
    @property
    def foreignFields(self) -> List[str]:
        """Fields the constraint maps to on the foreign dataset"""
        return self._inner_dict.get('foreignFields')  # type: ignore
    
    @foreignFields.setter
    def foreignFields(self, value: List[str]) -> None:
        self._inner_dict['foreignFields'] = value
    
    
    @property
    def sourceFields(self) -> List[str]:
        """Fields the constraint maps to on the source dataset"""
        return self._inner_dict.get('sourceFields')  # type: ignore
    
    @sourceFields.setter
    def sourceFields(self, value: List[str]) -> None:
        self._inner_dict['sourceFields'] = value
    
    
    @property
    def foreignDataset(self) -> str:
        """Reference to the foreign dataset for ease of lookup"""
        return self._inner_dict.get('foreignDataset')  # type: ignore
    
    @foreignDataset.setter
    def foreignDataset(self, value: str) -> None:
        self._inner_dict['foreignDataset'] = value
    
    
class ForeignKeySpecClass(DictWrapper):
    """Description of a foreign key in a schema."""
    
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.schema.ForeignKeySpec")
    def __init__(self,
        foreignKey: Union["DatasetFieldForeignKeyClass", "UrnForeignKeyClass"],
    ):
        super().__init__()
        
        self.foreignKey = foreignKey
    
    def _restore_defaults(self) -> None:
        self.foreignKey = DatasetFieldForeignKeyClass._construct_with_defaults()
    
    
    @property
    def foreignKey(self) -> Union["DatasetFieldForeignKeyClass", "UrnForeignKeyClass"]:
        """Foreign key definition in metadata schema."""
        return self._inner_dict.get('foreignKey')  # type: ignore
    
    @foreignKey.setter
    def foreignKey(self, value: Union["DatasetFieldForeignKeyClass", "UrnForeignKeyClass"]) -> None:
        self._inner_dict['foreignKey'] = value
    
    
class KafkaSchemaClass(DictWrapper):
    """Schema holder for kafka schema."""
    
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.schema.KafkaSchema")
    def __init__(self,
        documentSchema: str,
        documentSchemaType: Union[None, str]=None,
        keySchema: Union[None, str]=None,
        keySchemaType: Union[None, str]=None,
    ):
        super().__init__()
        
        self.documentSchema = documentSchema
        self.documentSchemaType = documentSchemaType
        self.keySchema = keySchema
        self.keySchemaType = keySchemaType
    
    def _restore_defaults(self) -> None:
        self.documentSchema = str()
        self.documentSchemaType = self.RECORD_SCHEMA.fields_dict["documentSchemaType"].default
        self.keySchema = self.RECORD_SCHEMA.fields_dict["keySchema"].default
        self.keySchemaType = self.RECORD_SCHEMA.fields_dict["keySchemaType"].default
    
    
    @property
    def documentSchema(self) -> str:
        """The native kafka document schema. This is a human readable avro document schema."""
        return self._inner_dict.get('documentSchema')  # type: ignore
    
    @documentSchema.setter
    def documentSchema(self, value: str) -> None:
        self._inner_dict['documentSchema'] = value
    
    
    @property
    def documentSchemaType(self) -> Union[None, str]:
        """The native kafka document schema type. This can be AVRO/PROTOBUF/JSON."""
        return self._inner_dict.get('documentSchemaType')  # type: ignore
    
    @documentSchemaType.setter
    def documentSchemaType(self, value: Union[None, str]) -> None:
        self._inner_dict['documentSchemaType'] = value
    
    
    @property
    def keySchema(self) -> Union[None, str]:
        """The native kafka key schema as retrieved from Schema Registry"""
        return self._inner_dict.get('keySchema')  # type: ignore
    
    @keySchema.setter
    def keySchema(self, value: Union[None, str]) -> None:
        self._inner_dict['keySchema'] = value
    
    
    @property
    def keySchemaType(self) -> Union[None, str]:
        """The native kafka key schema type. This can be AVRO/PROTOBUF/JSON."""
        return self._inner_dict.get('keySchemaType')  # type: ignore
    
    @keySchemaType.setter
    def keySchemaType(self, value: Union[None, str]) -> None:
        self._inner_dict['keySchemaType'] = value
    
    
class KeyValueSchemaClass(DictWrapper):
    """Schema text of a key-value store schema."""
    
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.schema.KeyValueSchema")
    def __init__(self,
        keySchema: str,
        valueSchema: str,
    ):
        super().__init__()
        
        self.keySchema = keySchema
        self.valueSchema = valueSchema
    
    def _restore_defaults(self) -> None:
        self.keySchema = str()
        self.valueSchema = str()
    
    
    @property
    def keySchema(self) -> str:
        """The raw schema for the key in the key-value store."""
        return self._inner_dict.get('keySchema')  # type: ignore
    
    @keySchema.setter
    def keySchema(self, value: str) -> None:
        self._inner_dict['keySchema'] = value
    
    
    @property
    def valueSchema(self) -> str:
        """The raw schema for the value in the key-value store."""
        return self._inner_dict.get('valueSchema')  # type: ignore
    
    @valueSchema.setter
    def valueSchema(self, value: str) -> None:
        self._inner_dict['valueSchema'] = value
    
    
class MapTypeClass(DictWrapper):
    """Map field type."""
    
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.schema.MapType")
    def __init__(self,
        keyType: Union[None, str]=None,
        valueType: Union[None, str]=None,
    ):
        super().__init__()
        
        self.keyType = keyType
        self.valueType = valueType
    
    def _restore_defaults(self) -> None:
        self.keyType = self.RECORD_SCHEMA.fields_dict["keyType"].default
        self.valueType = self.RECORD_SCHEMA.fields_dict["valueType"].default
    
    
    @property
    def keyType(self) -> Union[None, str]:
        """Key type in a map"""
        return self._inner_dict.get('keyType')  # type: ignore
    
    @keyType.setter
    def keyType(self, value: Union[None, str]) -> None:
        self._inner_dict['keyType'] = value
    
    
    @property
    def valueType(self) -> Union[None, str]:
        """Type of the value in a map"""
        return self._inner_dict.get('valueType')  # type: ignore
    
    @valueType.setter
    def valueType(self, value: Union[None, str]) -> None:
        self._inner_dict['valueType'] = value
    
    
class MySqlDDLClass(DictWrapper):
    """Schema holder for MySql data definition language that describes an MySql table."""
    
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.schema.MySqlDDL")
    def __init__(self,
        tableSchema: str,
    ):
        super().__init__()
        
        self.tableSchema = tableSchema
    
    def _restore_defaults(self) -> None:
        self.tableSchema = str()
    
    
    @property
    def tableSchema(self) -> str:
        """The native schema in the dataset's platform. This is a human readable (json blob) table schema."""
        return self._inner_dict.get('tableSchema')  # type: ignore
    
    @tableSchema.setter
    def tableSchema(self, value: str) -> None:
        self._inner_dict['tableSchema'] = value
    
    
class NullTypeClass(DictWrapper):
    """Null field type."""
    
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.schema.NullType")
    def __init__(self,
    ):
        super().__init__()
        
    
    def _restore_defaults(self) -> None:
        pass
    
    
class NumberTypeClass(DictWrapper):
    """Number data type: long, integer, short, etc.."""
    
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.schema.NumberType")
    def __init__(self,
    ):
        super().__init__()
        
    
    def _restore_defaults(self) -> None:
        pass
    
    
class OracleDDLClass(DictWrapper):
    """Schema holder for oracle data definition language that describes an oracle table."""
    
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.schema.OracleDDL")
    def __init__(self,
        tableSchema: str,
    ):
        super().__init__()
        
        self.tableSchema = tableSchema
    
    def _restore_defaults(self) -> None:
        self.tableSchema = str()
    
    
    @property
    def tableSchema(self) -> str:
        """The native schema in the dataset's platform. This is a human readable (json blob) table schema."""
        return self._inner_dict.get('tableSchema')  # type: ignore
    
    @tableSchema.setter
    def tableSchema(self, value: str) -> None:
        self._inner_dict['tableSchema'] = value
    
    
class OrcSchemaClass(DictWrapper):
    """Schema text of an ORC schema."""
    
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.schema.OrcSchema")
    def __init__(self,
        schema: str,
    ):
        super().__init__()
        
        self.schema = schema
    
    def _restore_defaults(self) -> None:
        self.schema = str()
    
    
    @property
    def schema(self) -> str:
        """The native schema for ORC file format."""
        return self._inner_dict.get('schema')  # type: ignore
    
    @schema.setter
    def schema(self, value: str) -> None:
        self._inner_dict['schema'] = value
    
    
class OtherSchemaClass(DictWrapper):
    """Schema holder for undefined schema types."""
    
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.schema.OtherSchema")
    def __init__(self,
        rawSchema: str,
    ):
        super().__init__()
        
        self.rawSchema = rawSchema
    
    def _restore_defaults(self) -> None:
        self.rawSchema = str()
    
    
    @property
    def rawSchema(self) -> str:
        """The native schema in the dataset's platform."""
        return self._inner_dict.get('rawSchema')  # type: ignore
    
    @rawSchema.setter
    def rawSchema(self, value: str) -> None:
        self._inner_dict['rawSchema'] = value
    
    
class PrestoDDLClass(DictWrapper):
    """Schema holder for presto data definition language that describes a presto view."""
    
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.schema.PrestoDDL")
    def __init__(self,
        rawSchema: str,
    ):
        super().__init__()
        
        self.rawSchema = rawSchema
    
    def _restore_defaults(self) -> None:
        self.rawSchema = str()
    
    
    @property
    def rawSchema(self) -> str:
        """The raw schema in the dataset's platform. This includes the DDL and the columns extracted from DDL."""
        return self._inner_dict.get('rawSchema')  # type: ignore
    
    @rawSchema.setter
    def rawSchema(self, value: str) -> None:
        self._inner_dict['rawSchema'] = value
    
    
class RecordTypeClass(DictWrapper):
    """Record field type."""
    
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.schema.RecordType")
    def __init__(self,
    ):
        super().__init__()
        
    
    def _restore_defaults(self) -> None:
        pass
    
    
class SchemaFieldClass(DictWrapper):
    """SchemaField to describe metadata related to dataset schema."""
    
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.schema.SchemaField")
    def __init__(self,
        fieldPath: str,
        type: "SchemaFieldDataTypeClass",
        nativeDataType: str,
        jsonPath: Union[None, str]=None,
        nullable: Optional[bool]=None,
        description: Union[None, str]=None,
        label: Union[None, str]=None,
        created: Union[None, "AuditStampClass"]=None,
        lastModified: Union[None, "AuditStampClass"]=None,
        recursive: Optional[bool]=None,
        globalTags: Union[None, "GlobalTagsClass"]=None,
        glossaryTerms: Union[None, "GlossaryTermsClass"]=None,
        isPartOfKey: Optional[bool]=None,
        isPartitioningKey: Union[None, bool]=None,
        jsonProps: Union[None, str]=None,
    ):
        super().__init__()
        
        self.fieldPath = fieldPath
        self.jsonPath = jsonPath
        if nullable is None:
            # default: False
            self.nullable = self.RECORD_SCHEMA.fields_dict["nullable"].default
        else:
            self.nullable = nullable
        self.description = description
        self.label = label
        self.created = created
        self.lastModified = lastModified
        self.type = type
        self.nativeDataType = nativeDataType
        if recursive is None:
            # default: False
            self.recursive = self.RECORD_SCHEMA.fields_dict["recursive"].default
        else:
            self.recursive = recursive
        self.globalTags = globalTags
        self.glossaryTerms = glossaryTerms
        if isPartOfKey is None:
            # default: False
            self.isPartOfKey = self.RECORD_SCHEMA.fields_dict["isPartOfKey"].default
        else:
            self.isPartOfKey = isPartOfKey
        self.isPartitioningKey = isPartitioningKey
        self.jsonProps = jsonProps
    
    def _restore_defaults(self) -> None:
        self.fieldPath = str()
        self.jsonPath = self.RECORD_SCHEMA.fields_dict["jsonPath"].default
        self.nullable = self.RECORD_SCHEMA.fields_dict["nullable"].default
        self.description = self.RECORD_SCHEMA.fields_dict["description"].default
        self.label = self.RECORD_SCHEMA.fields_dict["label"].default
        self.created = self.RECORD_SCHEMA.fields_dict["created"].default
        self.lastModified = self.RECORD_SCHEMA.fields_dict["lastModified"].default
        self.type = SchemaFieldDataTypeClass._construct_with_defaults()
        self.nativeDataType = str()
        self.recursive = self.RECORD_SCHEMA.fields_dict["recursive"].default
        self.globalTags = self.RECORD_SCHEMA.fields_dict["globalTags"].default
        self.glossaryTerms = self.RECORD_SCHEMA.fields_dict["glossaryTerms"].default
        self.isPartOfKey = self.RECORD_SCHEMA.fields_dict["isPartOfKey"].default
        self.isPartitioningKey = self.RECORD_SCHEMA.fields_dict["isPartitioningKey"].default
        self.jsonProps = self.RECORD_SCHEMA.fields_dict["jsonProps"].default
    
    
    @property
    def fieldPath(self) -> str:
        """Flattened name of the field. Field is computed from jsonPath field."""
        return self._inner_dict.get('fieldPath')  # type: ignore
    
    @fieldPath.setter
    def fieldPath(self, value: str) -> None:
        self._inner_dict['fieldPath'] = value
    
    
    @property
    def jsonPath(self) -> Union[None, str]:
        """Flattened name of a field in JSON Path notation."""
        return self._inner_dict.get('jsonPath')  # type: ignore
    
    @jsonPath.setter
    def jsonPath(self, value: Union[None, str]) -> None:
        self._inner_dict['jsonPath'] = value
    
    
    @property
    def nullable(self) -> bool:
        """Indicates if this field is optional or nullable"""
        return self._inner_dict.get('nullable')  # type: ignore
    
    @nullable.setter
    def nullable(self, value: bool) -> None:
        self._inner_dict['nullable'] = value
    
    
    @property
    def description(self) -> Union[None, str]:
        """Description"""
        return self._inner_dict.get('description')  # type: ignore
    
    @description.setter
    def description(self, value: Union[None, str]) -> None:
        self._inner_dict['description'] = value
    
    
    @property
    def label(self) -> Union[None, str]:
        """Label of the field. Provides a more human-readable name for the field than field path. Some sources will
    provide this metadata but not all sources have the concept of a label. If just one string is associated with
    a field in a source, that is most likely a description."""
        return self._inner_dict.get('label')  # type: ignore
    
    @label.setter
    def label(self, value: Union[None, str]) -> None:
        self._inner_dict['label'] = value
    
    
    @property
    def created(self) -> Union[None, "AuditStampClass"]:
        """An AuditStamp corresponding to the creation of this schema field."""
        return self._inner_dict.get('created')  # type: ignore
    
    @created.setter
    def created(self, value: Union[None, "AuditStampClass"]) -> None:
        self._inner_dict['created'] = value
    
    
    @property
    def lastModified(self) -> Union[None, "AuditStampClass"]:
        """An AuditStamp corresponding to the last modification of this schema field."""
        return self._inner_dict.get('lastModified')  # type: ignore
    
    @lastModified.setter
    def lastModified(self, value: Union[None, "AuditStampClass"]) -> None:
        self._inner_dict['lastModified'] = value
    
    
    @property
    def type(self) -> "SchemaFieldDataTypeClass":
        """Platform independent field type of the field."""
        return self._inner_dict.get('type')  # type: ignore
    
    @type.setter
    def type(self, value: "SchemaFieldDataTypeClass") -> None:
        self._inner_dict['type'] = value
    
    
    @property
    def nativeDataType(self) -> str:
        """The native type of the field in the dataset's platform as declared by platform schema."""
        return self._inner_dict.get('nativeDataType')  # type: ignore
    
    @nativeDataType.setter
    def nativeDataType(self, value: str) -> None:
        self._inner_dict['nativeDataType'] = value
    
    
    @property
    def recursive(self) -> bool:
        """There are use cases when a field in type B references type A. A field in A references field of type B. In such cases, we will mark the first field as recursive."""
        return self._inner_dict.get('recursive')  # type: ignore
    
    @recursive.setter
    def recursive(self, value: bool) -> None:
        self._inner_dict['recursive'] = value
    
    
    @property
    def globalTags(self) -> Union[None, "GlobalTagsClass"]:
        """Tags associated with the field"""
        return self._inner_dict.get('globalTags')  # type: ignore
    
    @globalTags.setter
    def globalTags(self, value: Union[None, "GlobalTagsClass"]) -> None:
        self._inner_dict['globalTags'] = value
    
    
    @property
    def glossaryTerms(self) -> Union[None, "GlossaryTermsClass"]:
        """Glossary terms associated with the field"""
        return self._inner_dict.get('glossaryTerms')  # type: ignore
    
    @glossaryTerms.setter
    def glossaryTerms(self, value: Union[None, "GlossaryTermsClass"]) -> None:
        self._inner_dict['glossaryTerms'] = value
    
    
    @property
    def isPartOfKey(self) -> bool:
        """For schema fields that are part of complex keys, set this field to true
    We do this to easily distinguish between value and key fields"""
        return self._inner_dict.get('isPartOfKey')  # type: ignore
    
    @isPartOfKey.setter
    def isPartOfKey(self, value: bool) -> None:
        self._inner_dict['isPartOfKey'] = value
    
    
    @property
    def isPartitioningKey(self) -> Union[None, bool]:
        """For Datasets which are partitioned, this determines the partitioning key."""
        return self._inner_dict.get('isPartitioningKey')  # type: ignore
    
    @isPartitioningKey.setter
    def isPartitioningKey(self, value: Union[None, bool]) -> None:
        self._inner_dict['isPartitioningKey'] = value
    
    
    @property
    def jsonProps(self) -> Union[None, str]:
        """For schema fields that have other properties that are not modeled explicitly,
    use this field to serialize those properties into a JSON string"""
        return self._inner_dict.get('jsonProps')  # type: ignore
    
    @jsonProps.setter
    def jsonProps(self, value: Union[None, str]) -> None:
        self._inner_dict['jsonProps'] = value
    
    
class SchemaFieldDataTypeClass(DictWrapper):
    """Schema field data types"""
    
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.schema.SchemaFieldDataType")
    def __init__(self,
        type: Union["BooleanTypeClass", "FixedTypeClass", "StringTypeClass", "BytesTypeClass", "NumberTypeClass", "DateTypeClass", "TimeTypeClass", "EnumTypeClass", "NullTypeClass", "MapTypeClass", "ArrayTypeClass", "UnionTypeClass", "RecordTypeClass"],
    ):
        super().__init__()
        
        self.type = type
    
    def _restore_defaults(self) -> None:
        self.type = BooleanTypeClass._construct_with_defaults()
    
    
    @property
    def type(self) -> Union["BooleanTypeClass", "FixedTypeClass", "StringTypeClass", "BytesTypeClass", "NumberTypeClass", "DateTypeClass", "TimeTypeClass", "EnumTypeClass", "NullTypeClass", "MapTypeClass", "ArrayTypeClass", "UnionTypeClass", "RecordTypeClass"]:
        """Data platform specific types"""
        return self._inner_dict.get('type')  # type: ignore
    
    @type.setter
    def type(self, value: Union["BooleanTypeClass", "FixedTypeClass", "StringTypeClass", "BytesTypeClass", "NumberTypeClass", "DateTypeClass", "TimeTypeClass", "EnumTypeClass", "NullTypeClass", "MapTypeClass", "ArrayTypeClass", "UnionTypeClass", "RecordTypeClass"]) -> None:
        self._inner_dict['type'] = value
    
    
class SchemaFieldSpecClass(DictWrapper):
    """Lightweight spec used for referencing a particular schema field."""
    
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.schema.SchemaFieldSpec")
    def __init__(self,
        path: str,
        type: str,
        nativeType: str,
    ):
        super().__init__()
        
        self.path = path
        self.type = type
        self.nativeType = nativeType
    
    def _restore_defaults(self) -> None:
        self.path = str()
        self.type = str()
        self.nativeType = str()
    
    
    @property
    def path(self) -> str:
        """The field path"""
        return self._inner_dict.get('path')  # type: ignore
    
    @path.setter
    def path(self, value: str) -> None:
        self._inner_dict['path'] = value
    
    
    @property
    def type(self) -> str:
        """The DataHub standard schema field type."""
        return self._inner_dict.get('type')  # type: ignore
    
    @type.setter
    def type(self, value: str) -> None:
        self._inner_dict['type'] = value
    
    
    @property
    def nativeType(self) -> str:
        """The native field type"""
        return self._inner_dict.get('nativeType')  # type: ignore
    
    @nativeType.setter
    def nativeType(self, value: str) -> None:
        self._inner_dict['nativeType'] = value
    
    
class SchemaMetadataClass(_Aspect):
    """SchemaMetadata to describe metadata related to store schema"""


    ASPECT_NAME = 'schemaMetadata'
    ASPECT_INFO = {}
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.schema.SchemaMetadata")

    def __init__(self,
        schemaName: str,
        platform: str,
        version: int,
        hash: str,
        platformSchema: Union["EspressoSchemaClass", "OracleDDLClass", "MySqlDDLClass", "PrestoDDLClass", "KafkaSchemaClass", "BinaryJsonSchemaClass", "OrcSchemaClass", "SchemalessClass", "KeyValueSchemaClass", "OtherSchemaClass"],
        fields: List["SchemaFieldClass"],
        created: Optional["AuditStampClass"]=None,
        lastModified: Optional["AuditStampClass"]=None,
        deleted: Union[None, "AuditStampClass"]=None,
        dataset: Union[None, str]=None,
        cluster: Union[None, str]=None,
        primaryKeys: Union[None, List[str]]=None,
        foreignKeysSpecs: Union[None, Dict[str, "ForeignKeySpecClass"]]=None,
        foreignKeys: Union[None, List["ForeignKeyConstraintClass"]]=None,
    ):
        super().__init__()
        
        self.schemaName = schemaName
        self.platform = platform
        self.version = version
        if created is None:
            # default: {'actor': 'urn:li:corpuser:unknown', 'impersonator': None, 'time': 0, 'message': None}
            self.created = _json_converter.from_json_object(self.RECORD_SCHEMA.fields_dict["created"].default, writers_schema=self.RECORD_SCHEMA.fields_dict["created"].type)
        else:
            self.created = created
        if lastModified is None:
            # default: {'actor': 'urn:li:corpuser:unknown', 'impersonator': None, 'time': 0, 'message': None}
            self.lastModified = _json_converter.from_json_object(self.RECORD_SCHEMA.fields_dict["lastModified"].default, writers_schema=self.RECORD_SCHEMA.fields_dict["lastModified"].type)
        else:
            self.lastModified = lastModified
        self.deleted = deleted
        self.dataset = dataset
        self.cluster = cluster
        self.hash = hash
        self.platformSchema = platformSchema
        self.fields = fields
        self.primaryKeys = primaryKeys
        self.foreignKeysSpecs = foreignKeysSpecs
        self.foreignKeys = foreignKeys
    
    def _restore_defaults(self) -> None:
        self.schemaName = str()
        self.platform = str()
        self.version = int()
        self.created = _json_converter.from_json_object(self.RECORD_SCHEMA.fields_dict["created"].default, writers_schema=self.RECORD_SCHEMA.fields_dict["created"].type)
        self.lastModified = _json_converter.from_json_object(self.RECORD_SCHEMA.fields_dict["lastModified"].default, writers_schema=self.RECORD_SCHEMA.fields_dict["lastModified"].type)
        self.deleted = self.RECORD_SCHEMA.fields_dict["deleted"].default
        self.dataset = self.RECORD_SCHEMA.fields_dict["dataset"].default
        self.cluster = self.RECORD_SCHEMA.fields_dict["cluster"].default
        self.hash = str()
        self.platformSchema = EspressoSchemaClass._construct_with_defaults()
        self.fields = list()
        self.primaryKeys = self.RECORD_SCHEMA.fields_dict["primaryKeys"].default
        self.foreignKeysSpecs = self.RECORD_SCHEMA.fields_dict["foreignKeysSpecs"].default
        self.foreignKeys = self.RECORD_SCHEMA.fields_dict["foreignKeys"].default
    
    
    @property
    def schemaName(self) -> str:
        """Schema name e.g. PageViewEvent, identity.Profile, ams.account_management_tracking"""
        return self._inner_dict.get('schemaName')  # type: ignore
    
    @schemaName.setter
    def schemaName(self, value: str) -> None:
        self._inner_dict['schemaName'] = value
    
    
    @property
    def platform(self) -> str:
        """Standardized platform urn where schema is defined. The data platform Urn (urn:li:platform:{platform_name})"""
        return self._inner_dict.get('platform')  # type: ignore
    
    @platform.setter
    def platform(self, value: str) -> None:
        self._inner_dict['platform'] = value
    
    
    @property
    def version(self) -> int:
        """Every change to SchemaMetadata in the resource results in a new version. Version is server assigned. This version is differ from platform native schema version."""
        return self._inner_dict.get('version')  # type: ignore
    
    @version.setter
    def version(self, value: int) -> None:
        self._inner_dict['version'] = value
    
    
    @property
    def created(self) -> "AuditStampClass":
        """An AuditStamp corresponding to the creation of this resource/association/sub-resource. A value of 0 for time indicates missing data."""
        return self._inner_dict.get('created')  # type: ignore
    
    @created.setter
    def created(self, value: "AuditStampClass") -> None:
        self._inner_dict['created'] = value
    
    
    @property
    def lastModified(self) -> "AuditStampClass":
        """An AuditStamp corresponding to the last modification of this resource/association/sub-resource. If no modification has happened since creation, lastModified should be the same as created. A value of 0 for time indicates missing data."""
        return self._inner_dict.get('lastModified')  # type: ignore
    
    @lastModified.setter
    def lastModified(self, value: "AuditStampClass") -> None:
        self._inner_dict['lastModified'] = value
    
    
    @property
    def deleted(self) -> Union[None, "AuditStampClass"]:
        """An AuditStamp corresponding to the deletion of this resource/association/sub-resource. Logically, deleted MUST have a later timestamp than creation. It may or may not have the same time as lastModified depending upon the resource/association/sub-resource semantics."""
        return self._inner_dict.get('deleted')  # type: ignore
    
    @deleted.setter
    def deleted(self, value: Union[None, "AuditStampClass"]) -> None:
        self._inner_dict['deleted'] = value
    
    
    @property
    def dataset(self) -> Union[None, str]:
        """Dataset this schema metadata is associated with."""
        return self._inner_dict.get('dataset')  # type: ignore
    
    @dataset.setter
    def dataset(self, value: Union[None, str]) -> None:
        self._inner_dict['dataset'] = value
    
    
    @property
    def cluster(self) -> Union[None, str]:
        """The cluster this schema metadata resides from"""
        return self._inner_dict.get('cluster')  # type: ignore
    
    @cluster.setter
    def cluster(self, value: Union[None, str]) -> None:
        self._inner_dict['cluster'] = value
    
    
    @property
    def hash(self) -> str:
        """the SHA1 hash of the schema content"""
        return self._inner_dict.get('hash')  # type: ignore
    
    @hash.setter
    def hash(self, value: str) -> None:
        self._inner_dict['hash'] = value
    
    
    @property
    def platformSchema(self) -> Union["EspressoSchemaClass", "OracleDDLClass", "MySqlDDLClass", "PrestoDDLClass", "KafkaSchemaClass", "BinaryJsonSchemaClass", "OrcSchemaClass", "SchemalessClass", "KeyValueSchemaClass", "OtherSchemaClass"]:
        """The native schema in the dataset's platform."""
        return self._inner_dict.get('platformSchema')  # type: ignore
    
    @platformSchema.setter
    def platformSchema(self, value: Union["EspressoSchemaClass", "OracleDDLClass", "MySqlDDLClass", "PrestoDDLClass", "KafkaSchemaClass", "BinaryJsonSchemaClass", "OrcSchemaClass", "SchemalessClass", "KeyValueSchemaClass", "OtherSchemaClass"]) -> None:
        self._inner_dict['platformSchema'] = value
    
    
    @property
    def fields(self) -> List["SchemaFieldClass"]:
        """Client provided a list of fields from document schema."""
        return self._inner_dict.get('fields')  # type: ignore
    
    @fields.setter
    def fields(self, value: List["SchemaFieldClass"]) -> None:
        self._inner_dict['fields'] = value
    
    
    @property
    def primaryKeys(self) -> Union[None, List[str]]:
        """Client provided list of fields that define primary keys to access record. Field order defines hierarchical espresso keys. Empty lists indicates absence of primary key access patter. Value is a SchemaField@fieldPath."""
        return self._inner_dict.get('primaryKeys')  # type: ignore
    
    @primaryKeys.setter
    def primaryKeys(self, value: Union[None, List[str]]) -> None:
        self._inner_dict['primaryKeys'] = value
    
    
    @property
    def foreignKeysSpecs(self) -> Union[None, Dict[str, "ForeignKeySpecClass"]]:
        """Map captures all the references schema makes to external datasets. Map key is ForeignKeySpecName typeref."""
        return self._inner_dict.get('foreignKeysSpecs')  # type: ignore
    
    @foreignKeysSpecs.setter
    def foreignKeysSpecs(self, value: Union[None, Dict[str, "ForeignKeySpecClass"]]) -> None:
        self._inner_dict['foreignKeysSpecs'] = value
    
    
    @property
    def foreignKeys(self) -> Union[None, List["ForeignKeyConstraintClass"]]:
        """List of foreign key constraints for the schema"""
        return self._inner_dict.get('foreignKeys')  # type: ignore
    
    @foreignKeys.setter
    def foreignKeys(self, value: Union[None, List["ForeignKeyConstraintClass"]]) -> None:
        self._inner_dict['foreignKeys'] = value
    
    
class SchemalessClass(DictWrapper):
    """The dataset has no specific schema associated with it"""
    
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.schema.Schemaless")
    def __init__(self,
    ):
        super().__init__()
        
    
    def _restore_defaults(self) -> None:
        pass
    
    
class StringTypeClass(DictWrapper):
    """String field type."""
    
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.schema.StringType")
    def __init__(self,
    ):
        super().__init__()
        
    
    def _restore_defaults(self) -> None:
        pass
    
    
class TimeTypeClass(DictWrapper):
    """Time field type. This should also be used for datetimes."""
    
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.schema.TimeType")
    def __init__(self,
    ):
        super().__init__()
        
    
    def _restore_defaults(self) -> None:
        pass
    
    
class UnionTypeClass(DictWrapper):
    """Union field type."""
    
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.schema.UnionType")
    def __init__(self,
        nestedTypes: Union[None, List[str]]=None,
    ):
        super().__init__()
        
        self.nestedTypes = nestedTypes
    
    def _restore_defaults(self) -> None:
        self.nestedTypes = self.RECORD_SCHEMA.fields_dict["nestedTypes"].default
    
    
    @property
    def nestedTypes(self) -> Union[None, List[str]]:
        """List of types in union type."""
        return self._inner_dict.get('nestedTypes')  # type: ignore
    
    @nestedTypes.setter
    def nestedTypes(self, value: Union[None, List[str]]) -> None:
        self._inner_dict['nestedTypes'] = value
    
    
class UrnForeignKeyClass(DictWrapper):
    """If SchemaMetadata fields make any external references and references are of type com.linkedin.pegasus2avro.common.Urn or any children, this models can be used to mark it."""
    
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.schema.UrnForeignKey")
    def __init__(self,
        currentFieldPath: str,
    ):
        super().__init__()
        
        self.currentFieldPath = currentFieldPath
    
    def _restore_defaults(self) -> None:
        self.currentFieldPath = str()
    
    
    @property
    def currentFieldPath(self) -> str:
        """Field in hosting(current) SchemaMetadata."""
        return self._inner_dict.get('currentFieldPath')  # type: ignore
    
    @currentFieldPath.setter
    def currentFieldPath(self, value: str) -> None:
        self._inner_dict['currentFieldPath'] = value
    
    
class DataHubSecretValueClass(_Aspect):
    """The value of a DataHub Secret"""


    ASPECT_NAME = 'dataHubSecretValue'
    ASPECT_INFO = {}
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.secret.DataHubSecretValue")

    def __init__(self,
        name: str,
        value: str,
        description: Union[None, str]=None,
        created: Union[None, "AuditStampClass"]=None,
    ):
        super().__init__()
        
        self.name = name
        self.value = value
        self.description = description
        self.created = created
    
    def _restore_defaults(self) -> None:
        self.name = str()
        self.value = str()
        self.description = self.RECORD_SCHEMA.fields_dict["description"].default
        self.created = self.RECORD_SCHEMA.fields_dict["created"].default
    
    
    @property
    def name(self) -> str:
        """The display name for the secret"""
        return self._inner_dict.get('name')  # type: ignore
    
    @name.setter
    def name(self, value: str) -> None:
        self._inner_dict['name'] = value
    
    
    @property
    def value(self) -> str:
        """The AES-encrypted value of the DataHub secret."""
        return self._inner_dict.get('value')  # type: ignore
    
    @value.setter
    def value(self, value: str) -> None:
        self._inner_dict['value'] = value
    
    
    @property
    def description(self) -> Union[None, str]:
        """Description of the secret"""
        return self._inner_dict.get('description')  # type: ignore
    
    @description.setter
    def description(self, value: Union[None, str]) -> None:
        self._inner_dict['description'] = value
    
    
    @property
    def created(self) -> Union[None, "AuditStampClass"]:
        """Created Audit stamp"""
        return self._inner_dict.get('created')  # type: ignore
    
    @created.setter
    def created(self, value: Union[None, "AuditStampClass"]) -> None:
        self._inner_dict['created'] = value
    
    
class GlobalSettingsInfoClass(_Aspect):
    """DataHub Global platform settings. Careful - these should not be modified by the outside world!"""


    ASPECT_NAME = 'globalSettingsInfo'
    ASPECT_INFO = {}
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.settings.global.GlobalSettingsInfo")

    def __init__(self,
        sso: Union[None, "SsoSettingsClass"]=None,
        views: Union[None, "GlobalViewsSettingsClass"]=None,
    ):
        super().__init__()
        
        self.sso = sso
        self.views = views
    
    def _restore_defaults(self) -> None:
        self.sso = self.RECORD_SCHEMA.fields_dict["sso"].default
        self.views = self.RECORD_SCHEMA.fields_dict["views"].default
    
    
    @property
    def sso(self) -> Union[None, "SsoSettingsClass"]:
        """SSO integrations between DataHub and identity providers"""
        return self._inner_dict.get('sso')  # type: ignore
    
    @sso.setter
    def sso(self, value: Union[None, "SsoSettingsClass"]) -> None:
        self._inner_dict['sso'] = value
    
    
    @property
    def views(self) -> Union[None, "GlobalViewsSettingsClass"]:
        """Settings related to the Views Feature"""
        return self._inner_dict.get('views')  # type: ignore
    
    @views.setter
    def views(self, value: Union[None, "GlobalViewsSettingsClass"]) -> None:
        self._inner_dict['views'] = value
    
    
class GlobalViewsSettingsClass(DictWrapper):
    """Settings for DataHub Views feature."""
    
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.settings.global.GlobalViewsSettings")
    def __init__(self,
        defaultView: Union[None, str]=None,
    ):
        super().__init__()
        
        self.defaultView = defaultView
    
    def _restore_defaults(self) -> None:
        self.defaultView = self.RECORD_SCHEMA.fields_dict["defaultView"].default
    
    
    @property
    def defaultView(self) -> Union[None, str]:
        """The default View for the instance, or organization."""
        return self._inner_dict.get('defaultView')  # type: ignore
    
    @defaultView.setter
    def defaultView(self, value: Union[None, str]) -> None:
        self._inner_dict['defaultView'] = value
    
    
class OidcSettingsClass(DictWrapper):
    """Settings for OIDC SSO integration."""
    
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.settings.global.OidcSettings")
    def __init__(self,
        enabled: bool,
        clientId: str,
        clientSecret: str,
        discoveryUri: str,
        userNameClaim: Union[None, str]=None,
        userNameClaimRegex: Union[None, str]=None,
        scope: Union[None, str]=None,
        clientAuthenticationMethod: Union[None, str]=None,
        jitProvisioningEnabled: Union[None, bool]=None,
        preProvisioningRequired: Union[None, bool]=None,
        extractGroupsEnabled: Union[None, bool]=None,
        groupsClaim: Union[None, str]=None,
        responseType: Union[None, str]=None,
        responseMode: Union[None, str]=None,
        useNonce: Union[None, bool]=None,
        readTimeout: Union[None, int]=None,
        extractJwtAccessTokenClaims: Union[None, bool]=None,
        preferredJwsAlgorithm: Union[None, str]=None,
        preferredJwsAlgorithm2: Union[None, str]=None,
    ):
        super().__init__()
        
        self.enabled = enabled
        self.clientId = clientId
        self.clientSecret = clientSecret
        self.discoveryUri = discoveryUri
        self.userNameClaim = userNameClaim
        self.userNameClaimRegex = userNameClaimRegex
        self.scope = scope
        self.clientAuthenticationMethod = clientAuthenticationMethod
        self.jitProvisioningEnabled = jitProvisioningEnabled
        self.preProvisioningRequired = preProvisioningRequired
        self.extractGroupsEnabled = extractGroupsEnabled
        self.groupsClaim = groupsClaim
        self.responseType = responseType
        self.responseMode = responseMode
        self.useNonce = useNonce
        self.readTimeout = readTimeout
        self.extractJwtAccessTokenClaims = extractJwtAccessTokenClaims
        self.preferredJwsAlgorithm = preferredJwsAlgorithm
        self.preferredJwsAlgorithm2 = preferredJwsAlgorithm2
    
    def _restore_defaults(self) -> None:
        self.enabled = bool()
        self.clientId = str()
        self.clientSecret = str()
        self.discoveryUri = str()
        self.userNameClaim = self.RECORD_SCHEMA.fields_dict["userNameClaim"].default
        self.userNameClaimRegex = self.RECORD_SCHEMA.fields_dict["userNameClaimRegex"].default
        self.scope = self.RECORD_SCHEMA.fields_dict["scope"].default
        self.clientAuthenticationMethod = self.RECORD_SCHEMA.fields_dict["clientAuthenticationMethod"].default
        self.jitProvisioningEnabled = self.RECORD_SCHEMA.fields_dict["jitProvisioningEnabled"].default
        self.preProvisioningRequired = self.RECORD_SCHEMA.fields_dict["preProvisioningRequired"].default
        self.extractGroupsEnabled = self.RECORD_SCHEMA.fields_dict["extractGroupsEnabled"].default
        self.groupsClaim = self.RECORD_SCHEMA.fields_dict["groupsClaim"].default
        self.responseType = self.RECORD_SCHEMA.fields_dict["responseType"].default
        self.responseMode = self.RECORD_SCHEMA.fields_dict["responseMode"].default
        self.useNonce = self.RECORD_SCHEMA.fields_dict["useNonce"].default
        self.readTimeout = self.RECORD_SCHEMA.fields_dict["readTimeout"].default
        self.extractJwtAccessTokenClaims = self.RECORD_SCHEMA.fields_dict["extractJwtAccessTokenClaims"].default
        self.preferredJwsAlgorithm = self.RECORD_SCHEMA.fields_dict["preferredJwsAlgorithm"].default
        self.preferredJwsAlgorithm2 = self.RECORD_SCHEMA.fields_dict["preferredJwsAlgorithm2"].default
    
    
    @property
    def enabled(self) -> bool:
        """Whether OIDC SSO is enabled."""
        return self._inner_dict.get('enabled')  # type: ignore
    
    @enabled.setter
    def enabled(self, value: bool) -> None:
        self._inner_dict['enabled'] = value
    
    
    @property
    def clientId(self) -> str:
        """Unique client id issued by the identity provider."""
        return self._inner_dict.get('clientId')  # type: ignore
    
    @clientId.setter
    def clientId(self, value: str) -> None:
        self._inner_dict['clientId'] = value
    
    
    @property
    def clientSecret(self) -> str:
        """Unique client secret issued by the identity provider."""
        return self._inner_dict.get('clientSecret')  # type: ignore
    
    @clientSecret.setter
    def clientSecret(self, value: str) -> None:
        self._inner_dict['clientSecret'] = value
    
    
    @property
    def discoveryUri(self) -> str:
        """The IdP OIDC discovery url."""
        return self._inner_dict.get('discoveryUri')  # type: ignore
    
    @discoveryUri.setter
    def discoveryUri(self, value: str) -> None:
        self._inner_dict['discoveryUri'] = value
    
    
    @property
    def userNameClaim(self) -> Union[None, str]:
        """ADVANCED. The attribute / claim used to derive the DataHub username. Defaults to "preferred_username"."""
        return self._inner_dict.get('userNameClaim')  # type: ignore
    
    @userNameClaim.setter
    def userNameClaim(self, value: Union[None, str]) -> None:
        self._inner_dict['userNameClaim'] = value
    
    
    @property
    def userNameClaimRegex(self) -> Union[None, str]:
        """ADVANCED. TThe regex used to parse the DataHub username from the user name claim. Defaults to (.*) (all)."""
        return self._inner_dict.get('userNameClaimRegex')  # type: ignore
    
    @userNameClaimRegex.setter
    def userNameClaimRegex(self, value: Union[None, str]) -> None:
        self._inner_dict['userNameClaimRegex'] = value
    
    
    @property
    def scope(self) -> Union[None, str]:
        """ADVANCED. String representing the requested scope from the IdP. Defaults to "oidc email profile"."""
        return self._inner_dict.get('scope')  # type: ignore
    
    @scope.setter
    def scope(self, value: Union[None, str]) -> None:
        self._inner_dict['scope'] = value
    
    
    @property
    def clientAuthenticationMethod(self) -> Union[None, str]:
        """ADVANCED. Which authentication method to use to pass credentials (clientId and clientSecret) to the token endpoint: Defaults to "client_secret_basic"."""
        return self._inner_dict.get('clientAuthenticationMethod')  # type: ignore
    
    @clientAuthenticationMethod.setter
    def clientAuthenticationMethod(self, value: Union[None, str]) -> None:
        self._inner_dict['clientAuthenticationMethod'] = value
    
    
    @property
    def jitProvisioningEnabled(self) -> Union[None, bool]:
        """ADVANCED. Whether DataHub users should be provisioned on login if they do not exist. Defaults to true."""
        return self._inner_dict.get('jitProvisioningEnabled')  # type: ignore
    
    @jitProvisioningEnabled.setter
    def jitProvisioningEnabled(self, value: Union[None, bool]) -> None:
        self._inner_dict['jitProvisioningEnabled'] = value
    
    
    @property
    def preProvisioningRequired(self) -> Union[None, bool]:
        """ADVANCED. Whether the user should already exist in DataHub on login, failing login if they are not. Defaults to false."""
        return self._inner_dict.get('preProvisioningRequired')  # type: ignore
    
    @preProvisioningRequired.setter
    def preProvisioningRequired(self, value: Union[None, bool]) -> None:
        self._inner_dict['preProvisioningRequired'] = value
    
    
    @property
    def extractGroupsEnabled(self) -> Union[None, bool]:
        """ADVANCED. Whether groups should be extracted from a claim in the OIDC profile. Only applies if JIT provisioning is enabled. Groups will be created if they do not exist. Defaults to true."""
        return self._inner_dict.get('extractGroupsEnabled')  # type: ignore
    
    @extractGroupsEnabled.setter
    def extractGroupsEnabled(self, value: Union[None, bool]) -> None:
        self._inner_dict['extractGroupsEnabled'] = value
    
    
    @property
    def groupsClaim(self) -> Union[None, str]:
        """ADVANCED. The OIDC claim to extract groups information from. Defaults to 'groups'."""
        return self._inner_dict.get('groupsClaim')  # type: ignore
    
    @groupsClaim.setter
    def groupsClaim(self, value: Union[None, str]) -> None:
        self._inner_dict['groupsClaim'] = value
    
    
    @property
    def responseType(self) -> Union[None, str]:
        """ADVANCED. Response type."""
        return self._inner_dict.get('responseType')  # type: ignore
    
    @responseType.setter
    def responseType(self, value: Union[None, str]) -> None:
        self._inner_dict['responseType'] = value
    
    
    @property
    def responseMode(self) -> Union[None, str]:
        """ADVANCED. Response mode."""
        return self._inner_dict.get('responseMode')  # type: ignore
    
    @responseMode.setter
    def responseMode(self, value: Union[None, str]) -> None:
        self._inner_dict['responseMode'] = value
    
    
    @property
    def useNonce(self) -> Union[None, bool]:
        """ADVANCED. Use Nonce."""
        return self._inner_dict.get('useNonce')  # type: ignore
    
    @useNonce.setter
    def useNonce(self, value: Union[None, bool]) -> None:
        self._inner_dict['useNonce'] = value
    
    
    @property
    def readTimeout(self) -> Union[None, int]:
        """ADVANCED. Read timeout."""
        return self._inner_dict.get('readTimeout')  # type: ignore
    
    @readTimeout.setter
    def readTimeout(self, value: Union[None, int]) -> None:
        self._inner_dict['readTimeout'] = value
    
    
    @property
    def extractJwtAccessTokenClaims(self) -> Union[None, bool]:
        """ADVANCED. Whether to extract claims from JWT access token.  Defaults to false."""
        return self._inner_dict.get('extractJwtAccessTokenClaims')  # type: ignore
    
    @extractJwtAccessTokenClaims.setter
    def extractJwtAccessTokenClaims(self, value: Union[None, bool]) -> None:
        self._inner_dict['extractJwtAccessTokenClaims'] = value
    
    
    @property
    def preferredJwsAlgorithm(self) -> Union[None, str]:
        """ ADVANCED. Which jws algorithm to use. Unused."""
        return self._inner_dict.get('preferredJwsAlgorithm')  # type: ignore
    
    @preferredJwsAlgorithm.setter
    def preferredJwsAlgorithm(self, value: Union[None, str]) -> None:
        self._inner_dict['preferredJwsAlgorithm'] = value
    
    
    @property
    def preferredJwsAlgorithm2(self) -> Union[None, str]:
        """ ADVANCED. Which jws algorithm to use."""
        return self._inner_dict.get('preferredJwsAlgorithm2')  # type: ignore
    
    @preferredJwsAlgorithm2.setter
    def preferredJwsAlgorithm2(self, value: Union[None, str]) -> None:
        self._inner_dict['preferredJwsAlgorithm2'] = value
    
    
class SsoSettingsClass(DictWrapper):
    """SSO Integrations, supported on the UI."""
    
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.settings.global.SsoSettings")
    def __init__(self,
        baseUrl: str,
        oidcSettings: Union[None, "OidcSettingsClass"]=None,
    ):
        super().__init__()
        
        self.baseUrl = baseUrl
        self.oidcSettings = oidcSettings
    
    def _restore_defaults(self) -> None:
        self.baseUrl = str()
        self.oidcSettings = self.RECORD_SCHEMA.fields_dict["oidcSettings"].default
    
    
    @property
    def baseUrl(self) -> str:
        """Auth base URL."""
        return self._inner_dict.get('baseUrl')  # type: ignore
    
    @baseUrl.setter
    def baseUrl(self, value: str) -> None:
        self._inner_dict['baseUrl'] = value
    
    
    @property
    def oidcSettings(self) -> Union[None, "OidcSettingsClass"]:
        """Optional OIDC SSO settings."""
        return self._inner_dict.get('oidcSettings')  # type: ignore
    
    @oidcSettings.setter
    def oidcSettings(self, value: Union[None, "OidcSettingsClass"]) -> None:
        self._inner_dict['oidcSettings'] = value
    
    
class DataHubStepStatePropertiesClass(_Aspect):
    """The properties associated with a DataHub step state"""


    ASPECT_NAME = 'dataHubStepStateProperties'
    ASPECT_INFO = {}
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.step.DataHubStepStateProperties")

    def __init__(self,
        lastModified: "AuditStampClass",
        properties: Optional[Dict[str, str]]=None,
    ):
        super().__init__()
        
        if properties is None:
            # default: {}
            self.properties = dict()
        else:
            self.properties = properties
        self.lastModified = lastModified
    
    def _restore_defaults(self) -> None:
        self.properties = dict()
        self.lastModified = AuditStampClass._construct_with_defaults()
    
    
    @property
    def properties(self) -> Dict[str, str]:
        """Description of the secret"""
        return self._inner_dict.get('properties')  # type: ignore
    
    @properties.setter
    def properties(self, value: Dict[str, str]) -> None:
        self._inner_dict['properties'] = value
    
    
    @property
    def lastModified(self) -> "AuditStampClass":
        """Audit stamp describing the last person to update it."""
        return self._inner_dict.get('lastModified')  # type: ignore
    
    @lastModified.setter
    def lastModified(self, value: "AuditStampClass") -> None:
        self._inner_dict['lastModified'] = value
    
    
class PropertyCardinalityClass(object):
    # No docs available.
    
    SINGLE = "SINGLE"
    MULTIPLE = "MULTIPLE"
    
    
class PropertyValueClass(DictWrapper):
    # No docs available.
    
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.structured.PropertyValue")
    def __init__(self,
        value: Union[str, float],
        description: Union[None, str]=None,
    ):
        super().__init__()
        
        self.value = value
        self.description = description
    
    def _restore_defaults(self) -> None:
        self.value = str()
        self.description = self.RECORD_SCHEMA.fields_dict["description"].default
    
    
    @property
    def value(self) -> Union[str, float]:
        # No docs available.
        return self._inner_dict.get('value')  # type: ignore
    
    @value.setter
    def value(self, value: Union[str, float]) -> None:
        self._inner_dict['value'] = value
    
    
    @property
    def description(self) -> Union[None, str]:
        """Optional description of the property value"""
        return self._inner_dict.get('description')  # type: ignore
    
    @description.setter
    def description(self, value: Union[None, str]) -> None:
        self._inner_dict['description'] = value
    
    
class StructuredPropertiesClass(_Aspect):
    """Properties about an entity governed by StructuredPropertyDefinition"""


    ASPECT_NAME = 'structuredProperties'
    ASPECT_INFO = {}
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.structured.StructuredProperties")

    def __init__(self,
        properties: List["StructuredPropertyValueAssignmentClass"],
    ):
        super().__init__()
        
        self.properties = properties
    
    def _restore_defaults(self) -> None:
        self.properties = list()
    
    
    @property
    def properties(self) -> List["StructuredPropertyValueAssignmentClass"]:
        """Custom property bag."""
        return self._inner_dict.get('properties')  # type: ignore
    
    @properties.setter
    def properties(self, value: List["StructuredPropertyValueAssignmentClass"]) -> None:
        self._inner_dict['properties'] = value
    
    
class StructuredPropertyDefinitionClass(_Aspect):
    # No docs available.


    ASPECT_NAME = 'propertyDefinition'
    ASPECT_INFO = {}
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.structured.StructuredPropertyDefinition")

    def __init__(self,
        qualifiedName: str,
        valueType: str,
        entityTypes: List[str],
        displayName: Union[None, str]=None,
        typeQualifier: Union[None, Dict[str, List[str]]]=None,
        allowedValues: Union[None, List["PropertyValueClass"]]=None,
        cardinality: Optional[Union[Union[str, "PropertyCardinalityClass"], None]]=None,
        description: Union[None, str]=None,
        searchConfiguration: Union[None, "DataHubSearchConfigClass"]=None,
    ):
        super().__init__()
        
        self.qualifiedName = qualifiedName
        self.displayName = displayName
        self.valueType = valueType
        self.typeQualifier = typeQualifier
        self.allowedValues = allowedValues
        if cardinality is None:
            # default: 'SINGLE'
            self.cardinality = self.RECORD_SCHEMA.fields_dict["cardinality"].default
        else:
            self.cardinality = cardinality
        self.entityTypes = entityTypes
        self.description = description
        self.searchConfiguration = searchConfiguration
    
    def _restore_defaults(self) -> None:
        self.qualifiedName = str()
        self.displayName = self.RECORD_SCHEMA.fields_dict["displayName"].default
        self.valueType = str()
        self.typeQualifier = self.RECORD_SCHEMA.fields_dict["typeQualifier"].default
        self.allowedValues = self.RECORD_SCHEMA.fields_dict["allowedValues"].default
        self.cardinality = self.RECORD_SCHEMA.fields_dict["cardinality"].default
        self.entityTypes = list()
        self.description = self.RECORD_SCHEMA.fields_dict["description"].default
        self.searchConfiguration = self.RECORD_SCHEMA.fields_dict["searchConfiguration"].default
    
    
    @property
    def qualifiedName(self) -> str:
        """The fully qualified name of the property. e.g. io.acryl.datahub.myProperty"""
        return self._inner_dict.get('qualifiedName')  # type: ignore
    
    @qualifiedName.setter
    def qualifiedName(self, value: str) -> None:
        self._inner_dict['qualifiedName'] = value
    
    
    @property
    def displayName(self) -> Union[None, str]:
        """The display name of the property. This is the name that will be shown in the UI and can be used to look up the property id."""
        return self._inner_dict.get('displayName')  # type: ignore
    
    @displayName.setter
    def displayName(self, value: Union[None, str]) -> None:
        self._inner_dict['displayName'] = value
    
    
    @property
    def valueType(self) -> str:
        """The value type of the property. Must be a dataType.
    e.g. To indicate that the property is of type DATE, use urn:li:dataType:datahub.date"""
        return self._inner_dict.get('valueType')  # type: ignore
    
    @valueType.setter
    def valueType(self, value: str) -> None:
        self._inner_dict['valueType'] = value
    
    
    @property
    def typeQualifier(self) -> Union[None, Dict[str, List[str]]]:
        """A map that allows for type specialization of the valueType.
    e.g. a valueType of urn:li:dataType:datahub.urn
    can be specialized to be a USER or GROUP URN by adding a typeQualifier like 
    { "allowedTypes": ["urn:li:entityType:datahub.corpuser", "urn:li:entityType:datahub.corpGroup"] }"""
        return self._inner_dict.get('typeQualifier')  # type: ignore
    
    @typeQualifier.setter
    def typeQualifier(self, value: Union[None, Dict[str, List[str]]]) -> None:
        self._inner_dict['typeQualifier'] = value
    
    
    @property
    def allowedValues(self) -> Union[None, List["PropertyValueClass"]]:
        """A list of allowed values that the property is allowed to take. 
    If this is not specified, then the property can take any value of given type."""
        return self._inner_dict.get('allowedValues')  # type: ignore
    
    @allowedValues.setter
    def allowedValues(self, value: Union[None, List["PropertyValueClass"]]) -> None:
        self._inner_dict['allowedValues'] = value
    
    
    @property
    def cardinality(self) -> Union[Union[str, "PropertyCardinalityClass"], None]:
        """The cardinality of the property. If not specified, then the property is assumed to be single valued.."""
        return self._inner_dict.get('cardinality')  # type: ignore
    
    @cardinality.setter
    def cardinality(self, value: Union[Union[str, "PropertyCardinalityClass"], None]) -> None:
        self._inner_dict['cardinality'] = value
    
    
    @property
    def entityTypes(self) -> List[str]:
        # No docs available.
        return self._inner_dict.get('entityTypes')  # type: ignore
    
    @entityTypes.setter
    def entityTypes(self, value: List[str]) -> None:
        self._inner_dict['entityTypes'] = value
    
    
    @property
    def description(self) -> Union[None, str]:
        """The description of the property. This is the description that will be shown in the UI."""
        return self._inner_dict.get('description')  # type: ignore
    
    @description.setter
    def description(self, value: Union[None, str]) -> None:
        self._inner_dict['description'] = value
    
    
    @property
    def searchConfiguration(self) -> Union[None, "DataHubSearchConfigClass"]:
        """Search configuration for this property. If not specified, then the property is indexed using the default mapping.
    from the logical type."""
        return self._inner_dict.get('searchConfiguration')  # type: ignore
    
    @searchConfiguration.setter
    def searchConfiguration(self, value: Union[None, "DataHubSearchConfigClass"]) -> None:
        self._inner_dict['searchConfiguration'] = value
    
    
class StructuredPropertyKeyClass(_Aspect):
    # No docs available.


    ASPECT_NAME = 'structuredPropertyKey'
    ASPECT_INFO = {'keyForEntity': 'structuredProperty', 'entityCategory': 'core', 'entityAspects': ['propertyDefinition', 'institutionalMemory', 'status'], 'entityDoc': 'Structured Property represents a property meant for extending the core model of a logical entity'}
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.structured.StructuredPropertyKey")

    def __init__(self,
        id: str,
    ):
        super().__init__()
        
        self.id = id
    
    def _restore_defaults(self) -> None:
        self.id = str()
    
    
    @property
    def id(self) -> str:
        """The id for a structured proeprty."""
        return self._inner_dict.get('id')  # type: ignore
    
    @id.setter
    def id(self, value: str) -> None:
        self._inner_dict['id'] = value
    
    
class StructuredPropertyValueAssignmentClass(DictWrapper):
    # No docs available.
    
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.structured.StructuredPropertyValueAssignment")
    def __init__(self,
        propertyUrn: str,
        values: List[Union[str, float]],
        created: Union[None, "AuditStampClass"]=None,
        lastModified: Union[None, "AuditStampClass"]=None,
    ):
        super().__init__()
        
        self.propertyUrn = propertyUrn
        self.values = values
        self.created = created
        self.lastModified = lastModified
    
    def _restore_defaults(self) -> None:
        self.propertyUrn = str()
        self.values = list()
        self.created = self.RECORD_SCHEMA.fields_dict["created"].default
        self.lastModified = self.RECORD_SCHEMA.fields_dict["lastModified"].default
    
    
    @property
    def propertyUrn(self) -> str:
        """The property that is being assigned a value."""
        return self._inner_dict.get('propertyUrn')  # type: ignore
    
    @propertyUrn.setter
    def propertyUrn(self, value: str) -> None:
        self._inner_dict['propertyUrn'] = value
    
    
    @property
    def values(self) -> List[Union[str, float]]:
        """The value assigned to the property."""
        return self._inner_dict.get('values')  # type: ignore
    
    @values.setter
    def values(self, value: List[Union[str, float]]) -> None:
        self._inner_dict['values'] = value
    
    
    @property
    def created(self) -> Union[None, "AuditStampClass"]:
        """Audit stamp containing who created this relationship edge and when"""
        return self._inner_dict.get('created')  # type: ignore
    
    @created.setter
    def created(self, value: Union[None, "AuditStampClass"]) -> None:
        self._inner_dict['created'] = value
    
    
    @property
    def lastModified(self) -> Union[None, "AuditStampClass"]:
        """Audit stamp containing who last modified this relationship edge and when"""
        return self._inner_dict.get('lastModified')  # type: ignore
    
    @lastModified.setter
    def lastModified(self, value: Union[None, "AuditStampClass"]) -> None:
        self._inner_dict['lastModified'] = value
    
    
class TagPropertiesClass(_Aspect):
    """Properties associated with a Tag"""


    ASPECT_NAME = 'tagProperties'
    ASPECT_INFO = {}
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.tag.TagProperties")

    def __init__(self,
        name: str,
        description: Union[None, str]=None,
        colorHex: Union[None, str]=None,
    ):
        super().__init__()
        
        self.name = name
        self.description = description
        self.colorHex = colorHex
    
    def _restore_defaults(self) -> None:
        self.name = str()
        self.description = self.RECORD_SCHEMA.fields_dict["description"].default
        self.colorHex = self.RECORD_SCHEMA.fields_dict["colorHex"].default
    
    
    @property
    def name(self) -> str:
        """Display name of the tag"""
        return self._inner_dict.get('name')  # type: ignore
    
    @name.setter
    def name(self, value: str) -> None:
        self._inner_dict['name'] = value
    
    
    @property
    def description(self) -> Union[None, str]:
        """Documentation of the tag"""
        return self._inner_dict.get('description')  # type: ignore
    
    @description.setter
    def description(self, value: Union[None, str]) -> None:
        self._inner_dict['description'] = value
    
    
    @property
    def colorHex(self) -> Union[None, str]:
        """The color associated with the Tag in Hex. For example #FFFFFF."""
        return self._inner_dict.get('colorHex')  # type: ignore
    
    @colorHex.setter
    def colorHex(self, value: Union[None, str]) -> None:
        self._inner_dict['colorHex'] = value
    
    
class TelemetryClientIdClass(_Aspect):
    """A simple wrapper around a String to persist the client ID for telemetry in DataHub's backend DB"""


    ASPECT_NAME = 'telemetryClientId'
    ASPECT_INFO = {}
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.telemetry.TelemetryClientId")

    def __init__(self,
        clientId: str,
    ):
        super().__init__()
        
        self.clientId = clientId
    
    def _restore_defaults(self) -> None:
        self.clientId = str()
    
    
    @property
    def clientId(self) -> str:
        """A string representing the telemetry client ID"""
        return self._inner_dict.get('clientId')  # type: ignore
    
    @clientId.setter
    def clientId(self, value: str) -> None:
        self._inner_dict['clientId'] = value
    
    
class TestDefinitionClass(DictWrapper):
    # No docs available.
    
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.test.TestDefinition")
    def __init__(self,
        type: Union[str, "TestDefinitionTypeClass"],
        json: Union[None, str]=None,
    ):
        super().__init__()
        
        self.type = type
        self.json = json
    
    def _restore_defaults(self) -> None:
        self.type = TestDefinitionTypeClass.JSON
        self.json = self.RECORD_SCHEMA.fields_dict["json"].default
    
    
    @property
    def type(self) -> Union[str, "TestDefinitionTypeClass"]:
        """The Test Definition Type"""
        return self._inner_dict.get('type')  # type: ignore
    
    @type.setter
    def type(self, value: Union[str, "TestDefinitionTypeClass"]) -> None:
        self._inner_dict['type'] = value
    
    
    @property
    def json(self) -> Union[None, str]:
        """JSON format configuration for the test"""
        return self._inner_dict.get('json')  # type: ignore
    
    @json.setter
    def json(self, value: Union[None, str]) -> None:
        self._inner_dict['json'] = value
    
    
class TestDefinitionTypeClass(object):
    # No docs available.
    
    JSON = "JSON"
    """JSON / YAML test def"""
    
    
    
class TestInfoClass(_Aspect):
    """Information about a DataHub Test"""


    ASPECT_NAME = 'testInfo'
    ASPECT_INFO = {}
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.test.TestInfo")

    def __init__(self,
        name: str,
        category: str,
        definition: "TestDefinitionClass",
        description: Union[None, str]=None,
    ):
        super().__init__()
        
        self.name = name
        self.category = category
        self.description = description
        self.definition = definition
    
    def _restore_defaults(self) -> None:
        self.name = str()
        self.category = str()
        self.description = self.RECORD_SCHEMA.fields_dict["description"].default
        self.definition = TestDefinitionClass._construct_with_defaults()
    
    
    @property
    def name(self) -> str:
        """The name of the test"""
        return self._inner_dict.get('name')  # type: ignore
    
    @name.setter
    def name(self, value: str) -> None:
        self._inner_dict['name'] = value
    
    
    @property
    def category(self) -> str:
        """Category of the test"""
        return self._inner_dict.get('category')  # type: ignore
    
    @category.setter
    def category(self, value: str) -> None:
        self._inner_dict['category'] = value
    
    
    @property
    def description(self) -> Union[None, str]:
        """Description of the test"""
        return self._inner_dict.get('description')  # type: ignore
    
    @description.setter
    def description(self, value: Union[None, str]) -> None:
        self._inner_dict['description'] = value
    
    
    @property
    def definition(self) -> "TestDefinitionClass":
        """Configuration for the Test"""
        return self._inner_dict.get('definition')  # type: ignore
    
    @definition.setter
    def definition(self, value: "TestDefinitionClass") -> None:
        self._inner_dict['definition'] = value
    
    
class TestResultClass(DictWrapper):
    """Information about a Test Result"""
    
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.test.TestResult")
    def __init__(self,
        test: str,
        type: Union[str, "TestResultTypeClass"],
    ):
        super().__init__()
        
        self.test = test
        self.type = type
    
    def _restore_defaults(self) -> None:
        self.test = str()
        self.type = TestResultTypeClass.SUCCESS
    
    
    @property
    def test(self) -> str:
        """The urn of the test"""
        return self._inner_dict.get('test')  # type: ignore
    
    @test.setter
    def test(self, value: str) -> None:
        self._inner_dict['test'] = value
    
    
    @property
    def type(self) -> Union[str, "TestResultTypeClass"]:
        """The type of the result"""
        return self._inner_dict.get('type')  # type: ignore
    
    @type.setter
    def type(self, value: Union[str, "TestResultTypeClass"]) -> None:
        self._inner_dict['type'] = value
    
    
class TestResultTypeClass(object):
    # No docs available.
    
    SUCCESS = "SUCCESS"
    """ The Test Succeeded"""
    
    FAILURE = "FAILURE"
    """ The Test Failed"""
    
    
    
class TestResultsClass(_Aspect):
    """Information about a Test Result"""


    ASPECT_NAME = 'testResults'
    ASPECT_INFO = {}
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.test.TestResults")

    def __init__(self,
        failing: List["TestResultClass"],
        passing: List["TestResultClass"],
    ):
        super().__init__()
        
        self.failing = failing
        self.passing = passing
    
    def _restore_defaults(self) -> None:
        self.failing = list()
        self.passing = list()
    
    
    @property
    def failing(self) -> List["TestResultClass"]:
        """Results that are failing"""
        return self._inner_dict.get('failing')  # type: ignore
    
    @failing.setter
    def failing(self, value: List["TestResultClass"]) -> None:
        self._inner_dict['failing'] = value
    
    
    @property
    def passing(self) -> List["TestResultClass"]:
        """Results that are passing"""
        return self._inner_dict.get('passing')  # type: ignore
    
    @passing.setter
    def passing(self, value: List["TestResultClass"]) -> None:
        self._inner_dict['passing'] = value
    
    
class CalendarIntervalClass(object):
    # No docs available.
    
    SECOND = "SECOND"
    MINUTE = "MINUTE"
    HOUR = "HOUR"
    DAY = "DAY"
    WEEK = "WEEK"
    MONTH = "MONTH"
    QUARTER = "QUARTER"
    YEAR = "YEAR"
    
    
class PartitionSpecClass(DictWrapper):
    """Defines how the data is partitioned"""
    
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.timeseries.PartitionSpec")
    def __init__(self,
        partition: str,
        type: Optional[Union[str, "PartitionTypeClass"]]=None,
        timePartition: Union[None, "TimeWindowClass"]=None,
    ):
        super().__init__()
        
        if type is None:
            # default: 'PARTITION'
            self.type = self.RECORD_SCHEMA.fields_dict["type"].default
        else:
            self.type = type
        self.partition = partition
        self.timePartition = timePartition
    
    def _restore_defaults(self) -> None:
        self.type = self.RECORD_SCHEMA.fields_dict["type"].default
        self.partition = str()
        self.timePartition = self.RECORD_SCHEMA.fields_dict["timePartition"].default
    
    
    @property
    def type(self) -> Union[str, "PartitionTypeClass"]:
        # No docs available.
        return self._inner_dict.get('type')  # type: ignore
    
    @type.setter
    def type(self, value: Union[str, "PartitionTypeClass"]) -> None:
        self._inner_dict['type'] = value
    
    
    @property
    def partition(self) -> str:
        """String representation of the partition"""
        return self._inner_dict.get('partition')  # type: ignore
    
    @partition.setter
    def partition(self, value: str) -> None:
        self._inner_dict['partition'] = value
    
    
    @property
    def timePartition(self) -> Union[None, "TimeWindowClass"]:
        """Time window of the partition if applicable"""
        return self._inner_dict.get('timePartition')  # type: ignore
    
    @timePartition.setter
    def timePartition(self, value: Union[None, "TimeWindowClass"]) -> None:
        self._inner_dict['timePartition'] = value
    
    
class PartitionTypeClass(object):
    # No docs available.
    
    FULL_TABLE = "FULL_TABLE"
    QUERY = "QUERY"
    PARTITION = "PARTITION"
    
    
class TimeWindowClass(DictWrapper):
    # No docs available.
    
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.timeseries.TimeWindow")
    def __init__(self,
        startTimeMillis: int,
        length: "TimeWindowSizeClass",
    ):
        super().__init__()
        
        self.startTimeMillis = startTimeMillis
        self.length = length
    
    def _restore_defaults(self) -> None:
        self.startTimeMillis = int()
        self.length = TimeWindowSizeClass._construct_with_defaults()
    
    
    @property
    def startTimeMillis(self) -> int:
        """Start time as epoch at UTC."""
        return self._inner_dict.get('startTimeMillis')  # type: ignore
    
    @startTimeMillis.setter
    def startTimeMillis(self, value: int) -> None:
        self._inner_dict['startTimeMillis'] = value
    
    
    @property
    def length(self) -> "TimeWindowSizeClass":
        """The length of the window."""
        return self._inner_dict.get('length')  # type: ignore
    
    @length.setter
    def length(self, value: "TimeWindowSizeClass") -> None:
        self._inner_dict['length'] = value
    
    
class TimeWindowSizeClass(DictWrapper):
    """Defines the size of a time window."""
    
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.timeseries.TimeWindowSize")
    def __init__(self,
        unit: Union[str, "CalendarIntervalClass"],
        multiple: Optional[int]=None,
    ):
        super().__init__()
        
        self.unit = unit
        if multiple is None:
            # default: 1
            self.multiple = self.RECORD_SCHEMA.fields_dict["multiple"].default
        else:
            self.multiple = multiple
    
    def _restore_defaults(self) -> None:
        self.unit = CalendarIntervalClass.SECOND
        self.multiple = self.RECORD_SCHEMA.fields_dict["multiple"].default
    
    
    @property
    def unit(self) -> Union[str, "CalendarIntervalClass"]:
        """Interval unit such as minute/hour/day etc."""
        return self._inner_dict.get('unit')  # type: ignore
    
    @unit.setter
    def unit(self, value: Union[str, "CalendarIntervalClass"]) -> None:
        self._inner_dict['unit'] = value
    
    
    @property
    def multiple(self) -> int:
        """How many units. Defaults to 1."""
        return self._inner_dict.get('multiple')  # type: ignore
    
    @multiple.setter
    def multiple(self, value: int) -> None:
        self._inner_dict['multiple'] = value
    
    
class DataHubUpgradeRequestClass(_Aspect):
    """Information collected when kicking off a DataHubUpgrade"""


    ASPECT_NAME = 'dataHubUpgradeRequest'
    ASPECT_INFO = {}
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.upgrade.DataHubUpgradeRequest")

    def __init__(self,
        timestampMs: int,
        version: str,
    ):
        super().__init__()
        
        self.timestampMs = timestampMs
        self.version = version
    
    def _restore_defaults(self) -> None:
        self.timestampMs = int()
        self.version = str()
    
    
    @property
    def timestampMs(self) -> int:
        """Timestamp when we started this DataHubUpgrade"""
        return self._inner_dict.get('timestampMs')  # type: ignore
    
    @timestampMs.setter
    def timestampMs(self, value: int) -> None:
        self._inner_dict['timestampMs'] = value
    
    
    @property
    def version(self) -> str:
        """Version of this upgrade"""
        return self._inner_dict.get('version')  # type: ignore
    
    @version.setter
    def version(self, value: str) -> None:
        self._inner_dict['version'] = value
    
    
class DataHubUpgradeResultClass(_Aspect):
    """Information collected when a DataHubUpgrade successfully finishes"""


    ASPECT_NAME = 'dataHubUpgradeResult'
    ASPECT_INFO = {}
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.upgrade.DataHubUpgradeResult")

    def __init__(self,
        timestampMs: int,
        result: Union[None, Dict[str, str]]=None,
    ):
        super().__init__()
        
        self.timestampMs = timestampMs
        self.result = result
    
    def _restore_defaults(self) -> None:
        self.timestampMs = int()
        self.result = self.RECORD_SCHEMA.fields_dict["result"].default
    
    
    @property
    def timestampMs(self) -> int:
        """Timestamp when we started this DataHubUpgrade"""
        return self._inner_dict.get('timestampMs')  # type: ignore
    
    @timestampMs.setter
    def timestampMs(self, value: int) -> None:
        self._inner_dict['timestampMs'] = value
    
    
    @property
    def result(self) -> Union[None, Dict[str, str]]:
        """Result map to place helpful information about this upgrade job"""
        return self._inner_dict.get('result')  # type: ignore
    
    @result.setter
    def result(self, value: Union[None, Dict[str, str]]) -> None:
        self._inner_dict['result'] = value
    
    
class FieldUsageCountsClass(DictWrapper):
    """ Records field-level usage counts for a given resource """
    
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.usage.FieldUsageCounts")
    def __init__(self,
        fieldName: str,
        count: int,
    ):
        super().__init__()
        
        self.fieldName = fieldName
        self.count = count
    
    def _restore_defaults(self) -> None:
        self.fieldName = str()
        self.count = int()
    
    
    @property
    def fieldName(self) -> str:
        # No docs available.
        return self._inner_dict.get('fieldName')  # type: ignore
    
    @fieldName.setter
    def fieldName(self, value: str) -> None:
        self._inner_dict['fieldName'] = value
    
    
    @property
    def count(self) -> int:
        # No docs available.
        return self._inner_dict.get('count')  # type: ignore
    
    @count.setter
    def count(self, value: int) -> None:
        self._inner_dict['count'] = value
    
    
class UsageAggregationClass(DictWrapper):
    """Usage data for a given resource, rolled up into a bucket."""
    
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.usage.UsageAggregation")
    def __init__(self,
        bucket: int,
        duration: Union[str, "WindowDurationClass"],
        resource: str,
        metrics: "UsageAggregationMetricsClass",
    ):
        super().__init__()
        
        self.bucket = bucket
        self.duration = duration
        self.resource = resource
        self.metrics = metrics
    
    def _restore_defaults(self) -> None:
        self.bucket = int()
        self.duration = WindowDurationClass.YEAR
        self.resource = str()
        self.metrics = UsageAggregationMetricsClass._construct_with_defaults()
    
    
    @property
    def bucket(self) -> int:
        """ Bucket start time in milliseconds """
        return self._inner_dict.get('bucket')  # type: ignore
    
    @bucket.setter
    def bucket(self, value: int) -> None:
        self._inner_dict['bucket'] = value
    
    
    @property
    def duration(self) -> Union[str, "WindowDurationClass"]:
        """ Bucket duration """
        return self._inner_dict.get('duration')  # type: ignore
    
    @duration.setter
    def duration(self, value: Union[str, "WindowDurationClass"]) -> None:
        self._inner_dict['duration'] = value
    
    
    @property
    def resource(self) -> str:
        """ Resource associated with these usage stats """
        return self._inner_dict.get('resource')  # type: ignore
    
    @resource.setter
    def resource(self, value: str) -> None:
        self._inner_dict['resource'] = value
    
    
    @property
    def metrics(self) -> "UsageAggregationMetricsClass":
        """ Metrics associated with this bucket """
        return self._inner_dict.get('metrics')  # type: ignore
    
    @metrics.setter
    def metrics(self, value: "UsageAggregationMetricsClass") -> None:
        self._inner_dict['metrics'] = value
    
    
class UsageAggregationMetricsClass(DictWrapper):
    """Metrics for usage data for a given resource and bucket. Not all fields
    make sense for all buckets, so every field is optional."""
    
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.usage.UsageAggregationMetrics")
    def __init__(self,
        uniqueUserCount: Union[None, int]=None,
        users: Union[None, List["UserUsageCountsClass"]]=None,
        totalSqlQueries: Union[None, int]=None,
        topSqlQueries: Union[None, List[str]]=None,
        fields: Union[None, List["FieldUsageCountsClass"]]=None,
    ):
        super().__init__()
        
        self.uniqueUserCount = uniqueUserCount
        self.users = users
        self.totalSqlQueries = totalSqlQueries
        self.topSqlQueries = topSqlQueries
        self.fields = fields
    
    def _restore_defaults(self) -> None:
        self.uniqueUserCount = self.RECORD_SCHEMA.fields_dict["uniqueUserCount"].default
        self.users = self.RECORD_SCHEMA.fields_dict["users"].default
        self.totalSqlQueries = self.RECORD_SCHEMA.fields_dict["totalSqlQueries"].default
        self.topSqlQueries = self.RECORD_SCHEMA.fields_dict["topSqlQueries"].default
        self.fields = self.RECORD_SCHEMA.fields_dict["fields"].default
    
    
    @property
    def uniqueUserCount(self) -> Union[None, int]:
        """ Unique user count """
        return self._inner_dict.get('uniqueUserCount')  # type: ignore
    
    @uniqueUserCount.setter
    def uniqueUserCount(self, value: Union[None, int]) -> None:
        self._inner_dict['uniqueUserCount'] = value
    
    
    @property
    def users(self) -> Union[None, List["UserUsageCountsClass"]]:
        """ Users within this bucket, with frequency counts """
        return self._inner_dict.get('users')  # type: ignore
    
    @users.setter
    def users(self, value: Union[None, List["UserUsageCountsClass"]]) -> None:
        self._inner_dict['users'] = value
    
    
    @property
    def totalSqlQueries(self) -> Union[None, int]:
        """ Total SQL query count """
        return self._inner_dict.get('totalSqlQueries')  # type: ignore
    
    @totalSqlQueries.setter
    def totalSqlQueries(self, value: Union[None, int]) -> None:
        self._inner_dict['totalSqlQueries'] = value
    
    
    @property
    def topSqlQueries(self) -> Union[None, List[str]]:
        """ Frequent SQL queries; mostly makes sense for datasets in SQL databases """
        return self._inner_dict.get('topSqlQueries')  # type: ignore
    
    @topSqlQueries.setter
    def topSqlQueries(self, value: Union[None, List[str]]) -> None:
        self._inner_dict['topSqlQueries'] = value
    
    
    @property
    def fields(self) -> Union[None, List["FieldUsageCountsClass"]]:
        """ Field-level usage stats """
        return self._inner_dict.get('fields')  # type: ignore
    
    @fields.setter
    def fields(self, value: Union[None, List["FieldUsageCountsClass"]]) -> None:
        self._inner_dict['fields'] = value
    
    
class UserUsageCountsClass(DictWrapper):
    """ Records a single user's usage counts for a given resource """
    
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.usage.UserUsageCounts")
    def __init__(self,
        count: int,
        user: Union[None, str]=None,
        userEmail: Union[None, str]=None,
    ):
        super().__init__()
        
        self.user = user
        self.count = count
        self.userEmail = userEmail
    
    def _restore_defaults(self) -> None:
        self.user = self.RECORD_SCHEMA.fields_dict["user"].default
        self.count = int()
        self.userEmail = self.RECORD_SCHEMA.fields_dict["userEmail"].default
    
    
    @property
    def user(self) -> Union[None, str]:
        # No docs available.
        return self._inner_dict.get('user')  # type: ignore
    
    @user.setter
    def user(self, value: Union[None, str]) -> None:
        self._inner_dict['user'] = value
    
    
    @property
    def count(self) -> int:
        # No docs available.
        return self._inner_dict.get('count')  # type: ignore
    
    @count.setter
    def count(self, value: int) -> None:
        self._inner_dict['count'] = value
    
    
    @property
    def userEmail(self) -> Union[None, str]:
        """ If user_email is set, we attempt to resolve the user's urn upon ingest """
        return self._inner_dict.get('userEmail')  # type: ignore
    
    @userEmail.setter
    def userEmail(self, value: Union[None, str]) -> None:
        self._inner_dict['userEmail'] = value
    
    
class DataHubViewDefinitionClass(DictWrapper):
    """A View definition."""
    
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.view.DataHubViewDefinition")
    def __init__(self,
        entityTypes: List[str],
        filter: "FilterClass",
    ):
        super().__init__()
        
        self.entityTypes = entityTypes
        self.filter = filter
    
    def _restore_defaults(self) -> None:
        self.entityTypes = list()
        self.filter = FilterClass._construct_with_defaults()
    
    
    @property
    def entityTypes(self) -> List[str]:
        """The Entity Types in the scope of the View."""
        return self._inner_dict.get('entityTypes')  # type: ignore
    
    @entityTypes.setter
    def entityTypes(self, value: List[str]) -> None:
        self._inner_dict['entityTypes'] = value
    
    
    @property
    def filter(self) -> "FilterClass":
        """The filter criteria, which represents the view itself"""
        return self._inner_dict.get('filter')  # type: ignore
    
    @filter.setter
    def filter(self, value: "FilterClass") -> None:
        self._inner_dict['filter'] = value
    
    
class DataHubViewInfoClass(_Aspect):
    """Information about a DataHub View. -- TODO: Understand whether an entity type filter is required."""


    ASPECT_NAME = 'dataHubViewInfo'
    ASPECT_INFO = {}
    RECORD_SCHEMA = get_schema_type("com.linkedin.pegasus2avro.view.DataHubViewInfo")

    def __init__(self,
        name: str,
        type: Union[str, "DataHubViewTypeClass"],
        definition: "DataHubViewDefinitionClass",
        created: "AuditStampClass",
        lastModified: "AuditStampClass",
        description: Union[None, str]=None,
    ):
        super().__init__()
        
        self.name = name
        self.description = description
        self.type = type
        self.definition = definition
        self.created = created
        self.lastModified = lastModified
    
    def _restore_defaults(self) -> None:
        self.name = str()
        self.description = self.RECORD_SCHEMA.fields_dict["description"].default
        self.type = DataHubViewTypeClass.PERSONAL
        self.definition = DataHubViewDefinitionClass._construct_with_defaults()
        self.created = AuditStampClass._construct_with_defaults()
        self.lastModified = AuditStampClass._construct_with_defaults()
    
    
    @property
    def name(self) -> str:
        """The name of the View"""
        return self._inner_dict.get('name')  # type: ignore
    
    @name.setter
    def name(self, value: str) -> None:
        self._inner_dict['name'] = value
    
    
    @property
    def description(self) -> Union[None, str]:
        """Description of the view"""
        return self._inner_dict.get('description')  # type: ignore
    
    @description.setter
    def description(self, value: Union[None, str]) -> None:
        self._inner_dict['description'] = value
    
    
    @property
    def type(self) -> Union[str, "DataHubViewTypeClass"]:
        """The type of View"""
        return self._inner_dict.get('type')  # type: ignore
    
    @type.setter
    def type(self, value: Union[str, "DataHubViewTypeClass"]) -> None:
        self._inner_dict['type'] = value
    
    
    @property
    def definition(self) -> "DataHubViewDefinitionClass":
        """The view itself"""
        return self._inner_dict.get('definition')  # type: ignore
    
    @definition.setter
    def definition(self, value: "DataHubViewDefinitionClass") -> None:
        self._inner_dict['definition'] = value
    
    
    @property
    def created(self) -> "AuditStampClass":
        """Audit stamp capturing the time and actor who created the View."""
        return self._inner_dict.get('created')  # type: ignore
    
    @created.setter
    def created(self, value: "AuditStampClass") -> None:
        self._inner_dict['created'] = value
    
    
    @property
    def lastModified(self) -> "AuditStampClass":
        """Audit stamp capturing the time and actor who last modified the View."""
        return self._inner_dict.get('lastModified')  # type: ignore
    
    @lastModified.setter
    def lastModified(self, value: "AuditStampClass") -> None:
        self._inner_dict['lastModified'] = value
    
    
class DataHubViewTypeClass(object):
    # No docs available.
    
    PERSONAL = "PERSONAL"
    """A view private for a specific person."""
    
    GLOBAL = "GLOBAL"
    """A global view, which all users can see and use."""
    
    
    
__SCHEMA_TYPES = {
    'com.linkedin.events.KafkaAuditHeader': KafkaAuditHeaderClass,
    'com.linkedin.pegasus2avro.access.token.DataHubAccessTokenInfo': DataHubAccessTokenInfoClass,
    'com.linkedin.pegasus2avro.assertion.AssertionAction': AssertionActionClass,
    'com.linkedin.pegasus2avro.assertion.AssertionActionType': AssertionActionTypeClass,
    'com.linkedin.pegasus2avro.assertion.AssertionActions': AssertionActionsClass,
    'com.linkedin.pegasus2avro.assertion.AssertionInfo': AssertionInfoClass,
    'com.linkedin.pegasus2avro.assertion.AssertionResult': AssertionResultClass,
    'com.linkedin.pegasus2avro.assertion.AssertionResultError': AssertionResultErrorClass,
    'com.linkedin.pegasus2avro.assertion.AssertionResultErrorType': AssertionResultErrorTypeClass,
    'com.linkedin.pegasus2avro.assertion.AssertionResultType': AssertionResultTypeClass,
    'com.linkedin.pegasus2avro.assertion.AssertionRunEvent': AssertionRunEventClass,
    'com.linkedin.pegasus2avro.assertion.AssertionRunStatus': AssertionRunStatusClass,
    'com.linkedin.pegasus2avro.assertion.AssertionSource': AssertionSourceClass,
    'com.linkedin.pegasus2avro.assertion.AssertionSourceType': AssertionSourceTypeClass,
    'com.linkedin.pegasus2avro.assertion.AssertionStdAggregation': AssertionStdAggregationClass,
    'com.linkedin.pegasus2avro.assertion.AssertionStdOperator': AssertionStdOperatorClass,
    'com.linkedin.pegasus2avro.assertion.AssertionStdParameter': AssertionStdParameterClass,
    'com.linkedin.pegasus2avro.assertion.AssertionStdParameterType': AssertionStdParameterTypeClass,
    'com.linkedin.pegasus2avro.assertion.AssertionStdParameters': AssertionStdParametersClass,
    'com.linkedin.pegasus2avro.assertion.AssertionType': AssertionTypeClass,
    'com.linkedin.pegasus2avro.assertion.AssertionValueChangeType': AssertionValueChangeTypeClass,
    'com.linkedin.pegasus2avro.assertion.BatchSpec': BatchSpecClass,
    'com.linkedin.pegasus2avro.assertion.DatasetAssertionInfo': DatasetAssertionInfoClass,
    'com.linkedin.pegasus2avro.assertion.DatasetAssertionScope': DatasetAssertionScopeClass,
    'com.linkedin.pegasus2avro.assertion.FixedIntervalSchedule': FixedIntervalScheduleClass,
    'com.linkedin.pegasus2avro.assertion.FreshnessAssertionInfo': FreshnessAssertionInfoClass,
    'com.linkedin.pegasus2avro.assertion.FreshnessAssertionSchedule': FreshnessAssertionScheduleClass,
    'com.linkedin.pegasus2avro.assertion.FreshnessAssertionScheduleType': FreshnessAssertionScheduleTypeClass,
    'com.linkedin.pegasus2avro.assertion.FreshnessAssertionType': FreshnessAssertionTypeClass,
    'com.linkedin.pegasus2avro.assertion.FreshnessCronSchedule': FreshnessCronScheduleClass,
    'com.linkedin.pegasus2avro.assertion.IncrementingSegmentFieldTransformer': IncrementingSegmentFieldTransformerClass,
    'com.linkedin.pegasus2avro.assertion.IncrementingSegmentFieldTransformerType': IncrementingSegmentFieldTransformerTypeClass,
    'com.linkedin.pegasus2avro.assertion.IncrementingSegmentRowCountChange': IncrementingSegmentRowCountChangeClass,
    'com.linkedin.pegasus2avro.assertion.IncrementingSegmentRowCountTotal': IncrementingSegmentRowCountTotalClass,
    'com.linkedin.pegasus2avro.assertion.IncrementingSegmentSpec': IncrementingSegmentSpecClass,
    'com.linkedin.pegasus2avro.assertion.RowCountChange': RowCountChangeClass,
    'com.linkedin.pegasus2avro.assertion.RowCountTotal': RowCountTotalClass,
    'com.linkedin.pegasus2avro.assertion.SchemaAssertionInfo': SchemaAssertionInfoClass,
    'com.linkedin.pegasus2avro.assertion.SqlAssertionInfo': SqlAssertionInfoClass,
    'com.linkedin.pegasus2avro.assertion.SqlAssertionType': SqlAssertionTypeClass,
    'com.linkedin.pegasus2avro.assertion.VolumeAssertionInfo': VolumeAssertionInfoClass,
    'com.linkedin.pegasus2avro.assertion.VolumeAssertionType': VolumeAssertionTypeClass,
    'com.linkedin.pegasus2avro.chart.ChartInfo': ChartInfoClass,
    'com.linkedin.pegasus2avro.chart.ChartQuery': ChartQueryClass,
    'com.linkedin.pegasus2avro.chart.ChartQueryType': ChartQueryTypeClass,
    'com.linkedin.pegasus2avro.chart.ChartType': ChartTypeClass,
    'com.linkedin.pegasus2avro.chart.ChartUsageStatistics': ChartUsageStatisticsClass,
    'com.linkedin.pegasus2avro.chart.ChartUserUsageCounts': ChartUserUsageCountsClass,
    'com.linkedin.pegasus2avro.chart.EditableChartProperties': EditableChartPropertiesClass,
    'com.linkedin.pegasus2avro.common.Access': AccessClass,
    'com.linkedin.pegasus2avro.common.AccessLevel': AccessLevelClass,
    'com.linkedin.pegasus2avro.common.AuditStamp': AuditStampClass,
    'com.linkedin.pegasus2avro.common.BrowsePathEntry': BrowsePathEntryClass,
    'com.linkedin.pegasus2avro.common.BrowsePaths': BrowsePathsClass,
    'com.linkedin.pegasus2avro.common.BrowsePathsV2': BrowsePathsV2Class,
    'com.linkedin.pegasus2avro.common.ChangeAuditStamps': ChangeAuditStampsClass,
    'com.linkedin.pegasus2avro.common.Cost': CostClass,
    'com.linkedin.pegasus2avro.common.CostCost': CostCostClass,
    'com.linkedin.pegasus2avro.common.CostCostDiscriminator': CostCostDiscriminatorClass,
    'com.linkedin.pegasus2avro.common.CostType': CostTypeClass,
    'com.linkedin.pegasus2avro.common.DataPlatformInstance': DataPlatformInstanceClass,
    'com.linkedin.pegasus2avro.common.Deprecation': DeprecationClass,
    'com.linkedin.pegasus2avro.common.Edge': EdgeClass,
    'com.linkedin.pegasus2avro.common.Embed': EmbedClass,
    'com.linkedin.pegasus2avro.common.FabricType': FabricTypeClass,
    'com.linkedin.pegasus2avro.common.FieldFormPromptAssociation': FieldFormPromptAssociationClass,
    'com.linkedin.pegasus2avro.common.FormAssociation': FormAssociationClass,
    'com.linkedin.pegasus2avro.common.FormPromptAssociation': FormPromptAssociationClass,
    'com.linkedin.pegasus2avro.common.FormPromptFieldAssociations': FormPromptFieldAssociationsClass,
    'com.linkedin.pegasus2avro.common.FormVerificationAssociation': FormVerificationAssociationClass,
    'com.linkedin.pegasus2avro.common.Forms': FormsClass,
    'com.linkedin.pegasus2avro.common.GlobalTags': GlobalTagsClass,
    'com.linkedin.pegasus2avro.common.GlossaryTermAssociation': GlossaryTermAssociationClass,
    'com.linkedin.pegasus2avro.common.GlossaryTerms': GlossaryTermsClass,
    'com.linkedin.pegasus2avro.common.IncidentSummaryDetails': IncidentSummaryDetailsClass,
    'com.linkedin.pegasus2avro.common.IncidentsSummary': IncidentsSummaryClass,
    'com.linkedin.pegasus2avro.common.InputField': InputFieldClass,
    'com.linkedin.pegasus2avro.common.InputFields': InputFieldsClass,
    'com.linkedin.pegasus2avro.common.InstitutionalMemory': InstitutionalMemoryClass,
    'com.linkedin.pegasus2avro.common.InstitutionalMemoryMetadata': InstitutionalMemoryMetadataClass,
    'com.linkedin.pegasus2avro.common.MLFeatureDataType': MLFeatureDataTypeClass,
    'com.linkedin.pegasus2avro.common.Media': MediaClass,
    'com.linkedin.pegasus2avro.common.MediaType': MediaTypeClass,
    'com.linkedin.pegasus2avro.common.Operation': OperationClass,
    'com.linkedin.pegasus2avro.common.OperationSourceType': OperationSourceTypeClass,
    'com.linkedin.pegasus2avro.common.OperationType': OperationTypeClass,
    'com.linkedin.pegasus2avro.common.Origin': OriginClass,
    'com.linkedin.pegasus2avro.common.OriginType': OriginTypeClass,
    'com.linkedin.pegasus2avro.common.Owner': OwnerClass,
    'com.linkedin.pegasus2avro.common.Ownership': OwnershipClass,
    'com.linkedin.pegasus2avro.common.OwnershipSource': OwnershipSourceClass,
    'com.linkedin.pegasus2avro.common.OwnershipSourceType': OwnershipSourceTypeClass,
    'com.linkedin.pegasus2avro.common.OwnershipType': OwnershipTypeClass,
    'com.linkedin.pegasus2avro.common.RoleAssociation': RoleAssociationClass,
    'com.linkedin.pegasus2avro.common.Siblings': SiblingsClass,
    'com.linkedin.pegasus2avro.common.Status': StatusClass,
    'com.linkedin.pegasus2avro.common.SubTypes': SubTypesClass,
    'com.linkedin.pegasus2avro.common.TagAssociation': TagAssociationClass,
    'com.linkedin.pegasus2avro.common.TimeStamp': TimeStampClass,
    'com.linkedin.pegasus2avro.common.VersionTag': VersionTagClass,
    'com.linkedin.pegasus2avro.common.WindowDuration': WindowDurationClass,
    'com.linkedin.pegasus2avro.common.fieldtransformer.TransformationType': TransformationTypeClass,
    'com.linkedin.pegasus2avro.common.fieldtransformer.UDFTransformer': UDFTransformerClass,
    'com.linkedin.pegasus2avro.container.Container': ContainerClass,
    'com.linkedin.pegasus2avro.container.ContainerProperties': ContainerPropertiesClass,
    'com.linkedin.pegasus2avro.container.EditableContainerProperties': EditableContainerPropertiesClass,
    'com.linkedin.pegasus2avro.dashboard.DashboardInfo': DashboardInfoClass,
    'com.linkedin.pegasus2avro.dashboard.DashboardUsageStatistics': DashboardUsageStatisticsClass,
    'com.linkedin.pegasus2avro.dashboard.DashboardUserUsageCounts': DashboardUserUsageCountsClass,
    'com.linkedin.pegasus2avro.dashboard.EditableDashboardProperties': EditableDashboardPropertiesClass,
    'com.linkedin.pegasus2avro.datacontract.DataContractProperties': DataContractPropertiesClass,
    'com.linkedin.pegasus2avro.datacontract.DataContractState': DataContractStateClass,
    'com.linkedin.pegasus2avro.datacontract.DataContractStatus': DataContractStatusClass,
    'com.linkedin.pegasus2avro.datacontract.DataQualityContract': DataQualityContractClass,
    'com.linkedin.pegasus2avro.datacontract.FreshnessContract': FreshnessContractClass,
    'com.linkedin.pegasus2avro.datacontract.SchemaContract': SchemaContractClass,
    'com.linkedin.pegasus2avro.datahub.DataHubSearchConfig': DataHubSearchConfigClass,
    'com.linkedin.pegasus2avro.datahub.SearchFieldType': SearchFieldTypeClass,
    'com.linkedin.pegasus2avro.datajob.DataFlowInfo': DataFlowInfoClass,
    'com.linkedin.pegasus2avro.datajob.DataJobInfo': DataJobInfoClass,
    'com.linkedin.pegasus2avro.datajob.DataJobInputOutput': DataJobInputOutputClass,
    'com.linkedin.pegasus2avro.datajob.EditableDataFlowProperties': EditableDataFlowPropertiesClass,
    'com.linkedin.pegasus2avro.datajob.EditableDataJobProperties': EditableDataJobPropertiesClass,
    'com.linkedin.pegasus2avro.datajob.JobStatus': JobStatusClass,
    'com.linkedin.pegasus2avro.datajob.VersionInfo': VersionInfoClass,
    'com.linkedin.pegasus2avro.datajob.azkaban.AzkabanJobType': AzkabanJobTypeClass,
    'com.linkedin.pegasus2avro.datajob.datahub.DatahubIngestionCheckpoint': DatahubIngestionCheckpointClass,
    'com.linkedin.pegasus2avro.datajob.datahub.DatahubIngestionRunSummary': DatahubIngestionRunSummaryClass,
    'com.linkedin.pegasus2avro.datajob.datahub.IngestionCheckpointState': IngestionCheckpointStateClass,
    'com.linkedin.pegasus2avro.dataplatform.DataPlatformInfo': DataPlatformInfoClass,
    'com.linkedin.pegasus2avro.dataplatform.PlatformType': PlatformTypeClass,
    'com.linkedin.pegasus2avro.dataplatforminstance.DataPlatformInstanceProperties': DataPlatformInstancePropertiesClass,
    'com.linkedin.pegasus2avro.dataprocess.DataProcessInfo': DataProcessInfoClass,
    'com.linkedin.pegasus2avro.dataprocess.DataProcessInstanceInput': DataProcessInstanceInputClass,
    'com.linkedin.pegasus2avro.dataprocess.DataProcessInstanceOutput': DataProcessInstanceOutputClass,
    'com.linkedin.pegasus2avro.dataprocess.DataProcessInstanceProperties': DataProcessInstancePropertiesClass,
    'com.linkedin.pegasus2avro.dataprocess.DataProcessInstanceRelationships': DataProcessInstanceRelationshipsClass,
    'com.linkedin.pegasus2avro.dataprocess.DataProcessInstanceRunEvent': DataProcessInstanceRunEventClass,
    'com.linkedin.pegasus2avro.dataprocess.DataProcessInstanceRunResult': DataProcessInstanceRunResultClass,
    'com.linkedin.pegasus2avro.dataprocess.DataProcessRunStatus': DataProcessRunStatusClass,
    'com.linkedin.pegasus2avro.dataprocess.DataProcessType': DataProcessTypeClass,
    'com.linkedin.pegasus2avro.dataprocess.RunResultType': RunResultTypeClass,
    'com.linkedin.pegasus2avro.dataproduct.DataProductAssociation': DataProductAssociationClass,
    'com.linkedin.pegasus2avro.dataproduct.DataProductKey': DataProductKeyClass,
    'com.linkedin.pegasus2avro.dataproduct.DataProductProperties': DataProductPropertiesClass,
    'com.linkedin.pegasus2avro.dataset.DatasetDeprecation': DatasetDeprecationClass,
    'com.linkedin.pegasus2avro.dataset.DatasetFieldMapping': DatasetFieldMappingClass,
    'com.linkedin.pegasus2avro.dataset.DatasetFieldProfile': DatasetFieldProfileClass,
    'com.linkedin.pegasus2avro.dataset.DatasetFieldUsageCounts': DatasetFieldUsageCountsClass,
    'com.linkedin.pegasus2avro.dataset.DatasetFilter': DatasetFilterClass,
    'com.linkedin.pegasus2avro.dataset.DatasetFilterType': DatasetFilterTypeClass,
    'com.linkedin.pegasus2avro.dataset.DatasetLineageType': DatasetLineageTypeClass,
    'com.linkedin.pegasus2avro.dataset.DatasetProfile': DatasetProfileClass,
    'com.linkedin.pegasus2avro.dataset.DatasetProperties': DatasetPropertiesClass,
    'com.linkedin.pegasus2avro.dataset.DatasetUpstreamLineage': DatasetUpstreamLineageClass,
    'com.linkedin.pegasus2avro.dataset.DatasetUsageStatistics': DatasetUsageStatisticsClass,
    'com.linkedin.pegasus2avro.dataset.DatasetUserUsageCounts': DatasetUserUsageCountsClass,
    'com.linkedin.pegasus2avro.dataset.EditableDatasetProperties': EditableDatasetPropertiesClass,
    'com.linkedin.pegasus2avro.dataset.FineGrainedLineage': FineGrainedLineageClass,
    'com.linkedin.pegasus2avro.dataset.FineGrainedLineageDownstreamType': FineGrainedLineageDownstreamTypeClass,
    'com.linkedin.pegasus2avro.dataset.FineGrainedLineageUpstreamType': FineGrainedLineageUpstreamTypeClass,
    'com.linkedin.pegasus2avro.dataset.Histogram': HistogramClass,
    'com.linkedin.pegasus2avro.dataset.Quantile': QuantileClass,
    'com.linkedin.pegasus2avro.dataset.Upstream': UpstreamClass,
    'com.linkedin.pegasus2avro.dataset.UpstreamLineage': UpstreamLineageClass,
    'com.linkedin.pegasus2avro.dataset.ValueFrequency': ValueFrequencyClass,
    'com.linkedin.pegasus2avro.dataset.ViewProperties': ViewPropertiesClass,
    'com.linkedin.pegasus2avro.datatype.DataTypeInfo': DataTypeInfoClass,
    'com.linkedin.pegasus2avro.datatype.DataTypeKey': DataTypeKeyClass,
    'com.linkedin.pegasus2avro.domain.DomainProperties': DomainPropertiesClass,
    'com.linkedin.pegasus2avro.domain.Domains': DomainsClass,
    'com.linkedin.pegasus2avro.entitytype.EntityTypeInfo': EntityTypeInfoClass,
    'com.linkedin.pegasus2avro.entitytype.EntityTypeKey': EntityTypeKeyClass,
    'com.linkedin.pegasus2avro.events.metadata.ChangeType': ChangeTypeClass,
    'com.linkedin.pegasus2avro.execution.ExecutionRequestInput': ExecutionRequestInputClass,
    'com.linkedin.pegasus2avro.execution.ExecutionRequestResult': ExecutionRequestResultClass,
    'com.linkedin.pegasus2avro.execution.ExecutionRequestSignal': ExecutionRequestSignalClass,
    'com.linkedin.pegasus2avro.execution.ExecutionRequestSource': ExecutionRequestSourceClass,
    'com.linkedin.pegasus2avro.execution.StructuredExecutionReport': StructuredExecutionReportClass,
    'com.linkedin.pegasus2avro.form.DynamicFormAssignment': DynamicFormAssignmentClass,
    'com.linkedin.pegasus2avro.form.FormActorAssignment': FormActorAssignmentClass,
    'com.linkedin.pegasus2avro.form.FormInfo': FormInfoClass,
    'com.linkedin.pegasus2avro.form.FormPrompt': FormPromptClass,
    'com.linkedin.pegasus2avro.form.FormPromptType': FormPromptTypeClass,
    'com.linkedin.pegasus2avro.form.FormType': FormTypeClass,
    'com.linkedin.pegasus2avro.form.StructuredPropertyParams': StructuredPropertyParamsClass,
    'com.linkedin.pegasus2avro.glossary.GlossaryNodeInfo': GlossaryNodeInfoClass,
    'com.linkedin.pegasus2avro.glossary.GlossaryRelatedTerms': GlossaryRelatedTermsClass,
    'com.linkedin.pegasus2avro.glossary.GlossaryTermInfo': GlossaryTermInfoClass,
    'com.linkedin.pegasus2avro.identity.CorpGroupEditableInfo': CorpGroupEditableInfoClass,
    'com.linkedin.pegasus2avro.identity.CorpGroupInfo': CorpGroupInfoClass,
    'com.linkedin.pegasus2avro.identity.CorpUserAppearanceSettings': CorpUserAppearanceSettingsClass,
    'com.linkedin.pegasus2avro.identity.CorpUserCredentials': CorpUserCredentialsClass,
    'com.linkedin.pegasus2avro.identity.CorpUserEditableInfo': CorpUserEditableInfoClass,
    'com.linkedin.pegasus2avro.identity.CorpUserInfo': CorpUserInfoClass,
    'com.linkedin.pegasus2avro.identity.CorpUserSettings': CorpUserSettingsClass,
    'com.linkedin.pegasus2avro.identity.CorpUserStatus': CorpUserStatusClass,
    'com.linkedin.pegasus2avro.identity.CorpUserViewsSettings': CorpUserViewsSettingsClass,
    'com.linkedin.pegasus2avro.identity.GroupMembership': GroupMembershipClass,
    'com.linkedin.pegasus2avro.identity.InviteToken': InviteTokenClass,
    'com.linkedin.pegasus2avro.identity.NativeGroupMembership': NativeGroupMembershipClass,
    'com.linkedin.pegasus2avro.identity.RoleMembership': RoleMembershipClass,
    'com.linkedin.pegasus2avro.incident.IncidentInfo': IncidentInfoClass,
    'com.linkedin.pegasus2avro.incident.IncidentSource': IncidentSourceClass,
    'com.linkedin.pegasus2avro.incident.IncidentSourceType': IncidentSourceTypeClass,
    'com.linkedin.pegasus2avro.incident.IncidentState': IncidentStateClass,
    'com.linkedin.pegasus2avro.incident.IncidentStatus': IncidentStatusClass,
    'com.linkedin.pegasus2avro.incident.IncidentType': IncidentTypeClass,
    'com.linkedin.pegasus2avro.ingestion.DataHubIngestionSourceConfig': DataHubIngestionSourceConfigClass,
    'com.linkedin.pegasus2avro.ingestion.DataHubIngestionSourceInfo': DataHubIngestionSourceInfoClass,
    'com.linkedin.pegasus2avro.ingestion.DataHubIngestionSourceSchedule': DataHubIngestionSourceScheduleClass,
    'com.linkedin.pegasus2avro.metadata.key.AssertionKey': AssertionKeyClass,
    'com.linkedin.pegasus2avro.metadata.key.ChartKey': ChartKeyClass,
    'com.linkedin.pegasus2avro.metadata.key.ContainerKey': ContainerKeyClass,
    'com.linkedin.pegasus2avro.metadata.key.CorpGroupKey': CorpGroupKeyClass,
    'com.linkedin.pegasus2avro.metadata.key.CorpUserKey': CorpUserKeyClass,
    'com.linkedin.pegasus2avro.metadata.key.DashboardKey': DashboardKeyClass,
    'com.linkedin.pegasus2avro.metadata.key.DataContractKey': DataContractKeyClass,
    'com.linkedin.pegasus2avro.metadata.key.DataFlowKey': DataFlowKeyClass,
    'com.linkedin.pegasus2avro.metadata.key.DataHubAccessTokenKey': DataHubAccessTokenKeyClass,
    'com.linkedin.pegasus2avro.metadata.key.DataHubIngestionSourceKey': DataHubIngestionSourceKeyClass,
    'com.linkedin.pegasus2avro.metadata.key.DataHubPolicyKey': DataHubPolicyKeyClass,
    'com.linkedin.pegasus2avro.metadata.key.DataHubRetentionKey': DataHubRetentionKeyClass,
    'com.linkedin.pegasus2avro.metadata.key.DataHubRoleKey': DataHubRoleKeyClass,
    'com.linkedin.pegasus2avro.metadata.key.DataHubSecretKey': DataHubSecretKeyClass,
    'com.linkedin.pegasus2avro.metadata.key.DataHubStepStateKey': DataHubStepStateKeyClass,
    'com.linkedin.pegasus2avro.metadata.key.DataHubUpgradeKey': DataHubUpgradeKeyClass,
    'com.linkedin.pegasus2avro.metadata.key.DataHubViewKey': DataHubViewKeyClass,
    'com.linkedin.pegasus2avro.metadata.key.DataJobKey': DataJobKeyClass,
    'com.linkedin.pegasus2avro.metadata.key.DataPlatformInstanceKey': DataPlatformInstanceKeyClass,
    'com.linkedin.pegasus2avro.metadata.key.DataPlatformKey': DataPlatformKeyClass,
    'com.linkedin.pegasus2avro.metadata.key.DataProcessInstanceKey': DataProcessInstanceKeyClass,
    'com.linkedin.pegasus2avro.metadata.key.DataProcessKey': DataProcessKeyClass,
    'com.linkedin.pegasus2avro.metadata.key.DatasetKey': DatasetKeyClass,
    'com.linkedin.pegasus2avro.metadata.key.DomainKey': DomainKeyClass,
    'com.linkedin.pegasus2avro.metadata.key.ExecutionRequestKey': ExecutionRequestKeyClass,
    'com.linkedin.pegasus2avro.metadata.key.FormKey': FormKeyClass,
    'com.linkedin.pegasus2avro.metadata.key.GlobalSettingsKey': GlobalSettingsKeyClass,
    'com.linkedin.pegasus2avro.metadata.key.GlossaryNodeKey': GlossaryNodeKeyClass,
    'com.linkedin.pegasus2avro.metadata.key.GlossaryTermKey': GlossaryTermKeyClass,
    'com.linkedin.pegasus2avro.metadata.key.IncidentKey': IncidentKeyClass,
    'com.linkedin.pegasus2avro.metadata.key.InviteTokenKey': InviteTokenKeyClass,
    'com.linkedin.pegasus2avro.metadata.key.MLFeatureKey': MLFeatureKeyClass,
    'com.linkedin.pegasus2avro.metadata.key.MLFeatureTableKey': MLFeatureTableKeyClass,
    'com.linkedin.pegasus2avro.metadata.key.MLModelDeploymentKey': MLModelDeploymentKeyClass,
    'com.linkedin.pegasus2avro.metadata.key.MLModelGroupKey': MLModelGroupKeyClass,
    'com.linkedin.pegasus2avro.metadata.key.MLModelKey': MLModelKeyClass,
    'com.linkedin.pegasus2avro.metadata.key.MLPrimaryKeyKey': MLPrimaryKeyKeyClass,
    'com.linkedin.pegasus2avro.metadata.key.NotebookKey': NotebookKeyClass,
    'com.linkedin.pegasus2avro.metadata.key.OwnershipTypeKey': OwnershipTypeKeyClass,
    'com.linkedin.pegasus2avro.metadata.key.PostKey': PostKeyClass,
    'com.linkedin.pegasus2avro.metadata.key.QueryKey': QueryKeyClass,
    'com.linkedin.pegasus2avro.metadata.key.RoleKey': RoleKeyClass,
    'com.linkedin.pegasus2avro.metadata.key.SchemaFieldKey': SchemaFieldKeyClass,
    'com.linkedin.pegasus2avro.metadata.key.TagKey': TagKeyClass,
    'com.linkedin.pegasus2avro.metadata.key.TelemetryKey': TelemetryKeyClass,
    'com.linkedin.pegasus2avro.metadata.key.TestKey': TestKeyClass,
    'com.linkedin.pegasus2avro.metadata.query.filter.Condition': ConditionClass,
    'com.linkedin.pegasus2avro.metadata.query.filter.ConjunctiveCriterion': ConjunctiveCriterionClass,
    'com.linkedin.pegasus2avro.metadata.query.filter.Criterion': CriterionClass,
    'com.linkedin.pegasus2avro.metadata.query.filter.Filter': FilterClass,
    'com.linkedin.pegasus2avro.metadata.snapshot.ChartSnapshot': ChartSnapshotClass,
    'com.linkedin.pegasus2avro.metadata.snapshot.CorpGroupSnapshot': CorpGroupSnapshotClass,
    'com.linkedin.pegasus2avro.metadata.snapshot.CorpUserSnapshot': CorpUserSnapshotClass,
    'com.linkedin.pegasus2avro.metadata.snapshot.DashboardSnapshot': DashboardSnapshotClass,
    'com.linkedin.pegasus2avro.metadata.snapshot.DataFlowSnapshot': DataFlowSnapshotClass,
    'com.linkedin.pegasus2avro.metadata.snapshot.DataHubPolicySnapshot': DataHubPolicySnapshotClass,
    'com.linkedin.pegasus2avro.metadata.snapshot.DataHubRetentionSnapshot': DataHubRetentionSnapshotClass,
    'com.linkedin.pegasus2avro.metadata.snapshot.DataJobSnapshot': DataJobSnapshotClass,
    'com.linkedin.pegasus2avro.metadata.snapshot.DataPlatformSnapshot': DataPlatformSnapshotClass,
    'com.linkedin.pegasus2avro.metadata.snapshot.DataProcessSnapshot': DataProcessSnapshotClass,
    'com.linkedin.pegasus2avro.metadata.snapshot.DatasetSnapshot': DatasetSnapshotClass,
    'com.linkedin.pegasus2avro.metadata.snapshot.GlossaryNodeSnapshot': GlossaryNodeSnapshotClass,
    'com.linkedin.pegasus2avro.metadata.snapshot.GlossaryTermSnapshot': GlossaryTermSnapshotClass,
    'com.linkedin.pegasus2avro.metadata.snapshot.MLFeatureSnapshot': MLFeatureSnapshotClass,
    'com.linkedin.pegasus2avro.metadata.snapshot.MLFeatureTableSnapshot': MLFeatureTableSnapshotClass,
    'com.linkedin.pegasus2avro.metadata.snapshot.MLModelDeploymentSnapshot': MLModelDeploymentSnapshotClass,
    'com.linkedin.pegasus2avro.metadata.snapshot.MLModelGroupSnapshot': MLModelGroupSnapshotClass,
    'com.linkedin.pegasus2avro.metadata.snapshot.MLModelSnapshot': MLModelSnapshotClass,
    'com.linkedin.pegasus2avro.metadata.snapshot.MLPrimaryKeySnapshot': MLPrimaryKeySnapshotClass,
    'com.linkedin.pegasus2avro.metadata.snapshot.SchemaFieldSnapshot': SchemaFieldSnapshotClass,
    'com.linkedin.pegasus2avro.metadata.snapshot.TagSnapshot': TagSnapshotClass,
    'com.linkedin.pegasus2avro.ml.metadata.BaseData': BaseDataClass,
    'com.linkedin.pegasus2avro.ml.metadata.CaveatDetails': CaveatDetailsClass,
    'com.linkedin.pegasus2avro.ml.metadata.CaveatsAndRecommendations': CaveatsAndRecommendationsClass,
    'com.linkedin.pegasus2avro.ml.metadata.DeploymentStatus': DeploymentStatusClass,
    'com.linkedin.pegasus2avro.ml.metadata.EditableMLFeatureProperties': EditableMLFeaturePropertiesClass,
    'com.linkedin.pegasus2avro.ml.metadata.EditableMLFeatureTableProperties': EditableMLFeatureTablePropertiesClass,
    'com.linkedin.pegasus2avro.ml.metadata.EditableMLModelGroupProperties': EditableMLModelGroupPropertiesClass,
    'com.linkedin.pegasus2avro.ml.metadata.EditableMLModelProperties': EditableMLModelPropertiesClass,
    'com.linkedin.pegasus2avro.ml.metadata.EditableMLPrimaryKeyProperties': EditableMLPrimaryKeyPropertiesClass,
    'com.linkedin.pegasus2avro.ml.metadata.EthicalConsiderations': EthicalConsiderationsClass,
    'com.linkedin.pegasus2avro.ml.metadata.EvaluationData': EvaluationDataClass,
    'com.linkedin.pegasus2avro.ml.metadata.IntendedUse': IntendedUseClass,
    'com.linkedin.pegasus2avro.ml.metadata.IntendedUserType': IntendedUserTypeClass,
    'com.linkedin.pegasus2avro.ml.metadata.MLFeatureProperties': MLFeaturePropertiesClass,
    'com.linkedin.pegasus2avro.ml.metadata.MLFeatureTableProperties': MLFeatureTablePropertiesClass,
    'com.linkedin.pegasus2avro.ml.metadata.MLHyperParam': MLHyperParamClass,
    'com.linkedin.pegasus2avro.ml.metadata.MLMetric': MLMetricClass,
    'com.linkedin.pegasus2avro.ml.metadata.MLModelDeploymentProperties': MLModelDeploymentPropertiesClass,
    'com.linkedin.pegasus2avro.ml.metadata.MLModelFactorPrompts': MLModelFactorPromptsClass,
    'com.linkedin.pegasus2avro.ml.metadata.MLModelFactors': MLModelFactorsClass,
    'com.linkedin.pegasus2avro.ml.metadata.MLModelGroupProperties': MLModelGroupPropertiesClass,
    'com.linkedin.pegasus2avro.ml.metadata.MLModelProperties': MLModelPropertiesClass,
    'com.linkedin.pegasus2avro.ml.metadata.MLPrimaryKeyProperties': MLPrimaryKeyPropertiesClass,
    'com.linkedin.pegasus2avro.ml.metadata.Metrics': MetricsClass,
    'com.linkedin.pegasus2avro.ml.metadata.QuantitativeAnalyses': QuantitativeAnalysesClass,
    'com.linkedin.pegasus2avro.ml.metadata.SourceCode': SourceCodeClass,
    'com.linkedin.pegasus2avro.ml.metadata.SourceCodeUrl': SourceCodeUrlClass,
    'com.linkedin.pegasus2avro.ml.metadata.SourceCodeUrlType': SourceCodeUrlTypeClass,
    'com.linkedin.pegasus2avro.ml.metadata.TrainingData': TrainingDataClass,
    'com.linkedin.pegasus2avro.mxe.GenericAspect': GenericAspectClass,
    'com.linkedin.pegasus2avro.mxe.GenericPayload': GenericPayloadClass,
    'com.linkedin.pegasus2avro.mxe.MetadataChangeEvent': MetadataChangeEventClass,
    'com.linkedin.pegasus2avro.mxe.MetadataChangeLog': MetadataChangeLogClass,
    'com.linkedin.pegasus2avro.mxe.MetadataChangeProposal': MetadataChangeProposalClass,
    'com.linkedin.pegasus2avro.mxe.PlatformEvent': PlatformEventClass,
    'com.linkedin.pegasus2avro.mxe.PlatformEventHeader': PlatformEventHeaderClass,
    'com.linkedin.pegasus2avro.mxe.SystemMetadata': SystemMetadataClass,
    'com.linkedin.pegasus2avro.notebook.ChartCell': ChartCellClass,
    'com.linkedin.pegasus2avro.notebook.EditableNotebookProperties': EditableNotebookPropertiesClass,
    'com.linkedin.pegasus2avro.notebook.NotebookCell': NotebookCellClass,
    'com.linkedin.pegasus2avro.notebook.NotebookCellType': NotebookCellTypeClass,
    'com.linkedin.pegasus2avro.notebook.NotebookContent': NotebookContentClass,
    'com.linkedin.pegasus2avro.notebook.NotebookInfo': NotebookInfoClass,
    'com.linkedin.pegasus2avro.notebook.QueryCell': QueryCellClass,
    'com.linkedin.pegasus2avro.notebook.TextCell': TextCellClass,
    'com.linkedin.pegasus2avro.ownership.OwnershipTypeInfo': OwnershipTypeInfoClass,
    'com.linkedin.pegasus2avro.platform.event.v1.EntityChangeEvent': EntityChangeEventClass,
    'com.linkedin.pegasus2avro.platform.event.v1.Parameters': ParametersClass,
    'com.linkedin.pegasus2avro.policy.DataHubActorFilter': DataHubActorFilterClass,
    'com.linkedin.pegasus2avro.policy.DataHubPolicyInfo': DataHubPolicyInfoClass,
    'com.linkedin.pegasus2avro.policy.DataHubResourceFilter': DataHubResourceFilterClass,
    'com.linkedin.pegasus2avro.policy.DataHubRoleInfo': DataHubRoleInfoClass,
    'com.linkedin.pegasus2avro.policy.PolicyMatchCondition': PolicyMatchConditionClass,
    'com.linkedin.pegasus2avro.policy.PolicyMatchCriterion': PolicyMatchCriterionClass,
    'com.linkedin.pegasus2avro.policy.PolicyMatchFilter': PolicyMatchFilterClass,
    'com.linkedin.pegasus2avro.post.PostContent': PostContentClass,
    'com.linkedin.pegasus2avro.post.PostContentType': PostContentTypeClass,
    'com.linkedin.pegasus2avro.post.PostInfo': PostInfoClass,
    'com.linkedin.pegasus2avro.post.PostType': PostTypeClass,
    'com.linkedin.pegasus2avro.query.QueryLanguage': QueryLanguageClass,
    'com.linkedin.pegasus2avro.query.QueryProperties': QueryPropertiesClass,
    'com.linkedin.pegasus2avro.query.QuerySource': QuerySourceClass,
    'com.linkedin.pegasus2avro.query.QueryStatement': QueryStatementClass,
    'com.linkedin.pegasus2avro.query.QuerySubject': QuerySubjectClass,
    'com.linkedin.pegasus2avro.query.QuerySubjects': QuerySubjectsClass,
    'com.linkedin.pegasus2avro.retention.DataHubRetentionConfig': DataHubRetentionConfigClass,
    'com.linkedin.pegasus2avro.retention.Retention': RetentionClass,
    'com.linkedin.pegasus2avro.retention.TimeBasedRetention': TimeBasedRetentionClass,
    'com.linkedin.pegasus2avro.retention.VersionBasedRetention': VersionBasedRetentionClass,
    'com.linkedin.pegasus2avro.role.Actors': ActorsClass,
    'com.linkedin.pegasus2avro.role.RoleProperties': RolePropertiesClass,
    'com.linkedin.pegasus2avro.role.RoleUser': RoleUserClass,
    'com.linkedin.pegasus2avro.schema.ArrayType': ArrayTypeClass,
    'com.linkedin.pegasus2avro.schema.BinaryJsonSchema': BinaryJsonSchemaClass,
    'com.linkedin.pegasus2avro.schema.BooleanType': BooleanTypeClass,
    'com.linkedin.pegasus2avro.schema.BytesType': BytesTypeClass,
    'com.linkedin.pegasus2avro.schema.DatasetFieldForeignKey': DatasetFieldForeignKeyClass,
    'com.linkedin.pegasus2avro.schema.DateType': DateTypeClass,
    'com.linkedin.pegasus2avro.schema.EditableSchemaFieldInfo': EditableSchemaFieldInfoClass,
    'com.linkedin.pegasus2avro.schema.EditableSchemaMetadata': EditableSchemaMetadataClass,
    'com.linkedin.pegasus2avro.schema.EnumType': EnumTypeClass,
    'com.linkedin.pegasus2avro.schema.EspressoSchema': EspressoSchemaClass,
    'com.linkedin.pegasus2avro.schema.FixedType': FixedTypeClass,
    'com.linkedin.pegasus2avro.schema.ForeignKeyConstraint': ForeignKeyConstraintClass,
    'com.linkedin.pegasus2avro.schema.ForeignKeySpec': ForeignKeySpecClass,
    'com.linkedin.pegasus2avro.schema.KafkaSchema': KafkaSchemaClass,
    'com.linkedin.pegasus2avro.schema.KeyValueSchema': KeyValueSchemaClass,
    'com.linkedin.pegasus2avro.schema.MapType': MapTypeClass,
    'com.linkedin.pegasus2avro.schema.MySqlDDL': MySqlDDLClass,
    'com.linkedin.pegasus2avro.schema.NullType': NullTypeClass,
    'com.linkedin.pegasus2avro.schema.NumberType': NumberTypeClass,
    'com.linkedin.pegasus2avro.schema.OracleDDL': OracleDDLClass,
    'com.linkedin.pegasus2avro.schema.OrcSchema': OrcSchemaClass,
    'com.linkedin.pegasus2avro.schema.OtherSchema': OtherSchemaClass,
    'com.linkedin.pegasus2avro.schema.PrestoDDL': PrestoDDLClass,
    'com.linkedin.pegasus2avro.schema.RecordType': RecordTypeClass,
    'com.linkedin.pegasus2avro.schema.SchemaField': SchemaFieldClass,
    'com.linkedin.pegasus2avro.schema.SchemaFieldDataType': SchemaFieldDataTypeClass,
    'com.linkedin.pegasus2avro.schema.SchemaFieldSpec': SchemaFieldSpecClass,
    'com.linkedin.pegasus2avro.schema.SchemaMetadata': SchemaMetadataClass,
    'com.linkedin.pegasus2avro.schema.Schemaless': SchemalessClass,
    'com.linkedin.pegasus2avro.schema.StringType': StringTypeClass,
    'com.linkedin.pegasus2avro.schema.TimeType': TimeTypeClass,
    'com.linkedin.pegasus2avro.schema.UnionType': UnionTypeClass,
    'com.linkedin.pegasus2avro.schema.UrnForeignKey': UrnForeignKeyClass,
    'com.linkedin.pegasus2avro.secret.DataHubSecretValue': DataHubSecretValueClass,
    'com.linkedin.pegasus2avro.settings.global.GlobalSettingsInfo': GlobalSettingsInfoClass,
    'com.linkedin.pegasus2avro.settings.global.GlobalViewsSettings': GlobalViewsSettingsClass,
    'com.linkedin.pegasus2avro.settings.global.OidcSettings': OidcSettingsClass,
    'com.linkedin.pegasus2avro.settings.global.SsoSettings': SsoSettingsClass,
    'com.linkedin.pegasus2avro.step.DataHubStepStateProperties': DataHubStepStatePropertiesClass,
    'com.linkedin.pegasus2avro.structured.PropertyCardinality': PropertyCardinalityClass,
    'com.linkedin.pegasus2avro.structured.PropertyValue': PropertyValueClass,
    'com.linkedin.pegasus2avro.structured.StructuredProperties': StructuredPropertiesClass,
    'com.linkedin.pegasus2avro.structured.StructuredPropertyDefinition': StructuredPropertyDefinitionClass,
    'com.linkedin.pegasus2avro.structured.StructuredPropertyKey': StructuredPropertyKeyClass,
    'com.linkedin.pegasus2avro.structured.StructuredPropertyValueAssignment': StructuredPropertyValueAssignmentClass,
    'com.linkedin.pegasus2avro.tag.TagProperties': TagPropertiesClass,
    'com.linkedin.pegasus2avro.telemetry.TelemetryClientId': TelemetryClientIdClass,
    'com.linkedin.pegasus2avro.test.TestDefinition': TestDefinitionClass,
    'com.linkedin.pegasus2avro.test.TestDefinitionType': TestDefinitionTypeClass,
    'com.linkedin.pegasus2avro.test.TestInfo': TestInfoClass,
    'com.linkedin.pegasus2avro.test.TestResult': TestResultClass,
    'com.linkedin.pegasus2avro.test.TestResultType': TestResultTypeClass,
    'com.linkedin.pegasus2avro.test.TestResults': TestResultsClass,
    'com.linkedin.pegasus2avro.timeseries.CalendarInterval': CalendarIntervalClass,
    'com.linkedin.pegasus2avro.timeseries.PartitionSpec': PartitionSpecClass,
    'com.linkedin.pegasus2avro.timeseries.PartitionType': PartitionTypeClass,
    'com.linkedin.pegasus2avro.timeseries.TimeWindow': TimeWindowClass,
    'com.linkedin.pegasus2avro.timeseries.TimeWindowSize': TimeWindowSizeClass,
    'com.linkedin.pegasus2avro.upgrade.DataHubUpgradeRequest': DataHubUpgradeRequestClass,
    'com.linkedin.pegasus2avro.upgrade.DataHubUpgradeResult': DataHubUpgradeResultClass,
    'com.linkedin.pegasus2avro.usage.FieldUsageCounts': FieldUsageCountsClass,
    'com.linkedin.pegasus2avro.usage.UsageAggregation': UsageAggregationClass,
    'com.linkedin.pegasus2avro.usage.UsageAggregationMetrics': UsageAggregationMetricsClass,
    'com.linkedin.pegasus2avro.usage.UserUsageCounts': UserUsageCountsClass,
    'com.linkedin.pegasus2avro.view.DataHubViewDefinition': DataHubViewDefinitionClass,
    'com.linkedin.pegasus2avro.view.DataHubViewInfo': DataHubViewInfoClass,
    'com.linkedin.pegasus2avro.view.DataHubViewType': DataHubViewTypeClass,
    'KafkaAuditHeader': KafkaAuditHeaderClass,
    'DataHubAccessTokenInfo': DataHubAccessTokenInfoClass,
    'AssertionAction': AssertionActionClass,
    'AssertionActionType': AssertionActionTypeClass,
    'AssertionActions': AssertionActionsClass,
    'AssertionInfo': AssertionInfoClass,
    'AssertionResult': AssertionResultClass,
    'AssertionResultError': AssertionResultErrorClass,
    'AssertionResultErrorType': AssertionResultErrorTypeClass,
    'AssertionResultType': AssertionResultTypeClass,
    'AssertionRunEvent': AssertionRunEventClass,
    'AssertionRunStatus': AssertionRunStatusClass,
    'AssertionSource': AssertionSourceClass,
    'AssertionSourceType': AssertionSourceTypeClass,
    'AssertionStdAggregation': AssertionStdAggregationClass,
    'AssertionStdOperator': AssertionStdOperatorClass,
    'AssertionStdParameter': AssertionStdParameterClass,
    'AssertionStdParameterType': AssertionStdParameterTypeClass,
    'AssertionStdParameters': AssertionStdParametersClass,
    'AssertionType': AssertionTypeClass,
    'AssertionValueChangeType': AssertionValueChangeTypeClass,
    'BatchSpec': BatchSpecClass,
    'DatasetAssertionInfo': DatasetAssertionInfoClass,
    'DatasetAssertionScope': DatasetAssertionScopeClass,
    'FixedIntervalSchedule': FixedIntervalScheduleClass,
    'FreshnessAssertionInfo': FreshnessAssertionInfoClass,
    'FreshnessAssertionSchedule': FreshnessAssertionScheduleClass,
    'FreshnessAssertionScheduleType': FreshnessAssertionScheduleTypeClass,
    'FreshnessAssertionType': FreshnessAssertionTypeClass,
    'FreshnessCronSchedule': FreshnessCronScheduleClass,
    'IncrementingSegmentFieldTransformer': IncrementingSegmentFieldTransformerClass,
    'IncrementingSegmentFieldTransformerType': IncrementingSegmentFieldTransformerTypeClass,
    'IncrementingSegmentRowCountChange': IncrementingSegmentRowCountChangeClass,
    'IncrementingSegmentRowCountTotal': IncrementingSegmentRowCountTotalClass,
    'IncrementingSegmentSpec': IncrementingSegmentSpecClass,
    'RowCountChange': RowCountChangeClass,
    'RowCountTotal': RowCountTotalClass,
    'SchemaAssertionInfo': SchemaAssertionInfoClass,
    'SqlAssertionInfo': SqlAssertionInfoClass,
    'SqlAssertionType': SqlAssertionTypeClass,
    'VolumeAssertionInfo': VolumeAssertionInfoClass,
    'VolumeAssertionType': VolumeAssertionTypeClass,
    'ChartInfo': ChartInfoClass,
    'ChartQuery': ChartQueryClass,
    'ChartQueryType': ChartQueryTypeClass,
    'ChartType': ChartTypeClass,
    'ChartUsageStatistics': ChartUsageStatisticsClass,
    'ChartUserUsageCounts': ChartUserUsageCountsClass,
    'EditableChartProperties': EditableChartPropertiesClass,
    'Access': AccessClass,
    'AccessLevel': AccessLevelClass,
    'AuditStamp': AuditStampClass,
    'BrowsePathEntry': BrowsePathEntryClass,
    'BrowsePaths': BrowsePathsClass,
    'BrowsePathsV2': BrowsePathsV2Class,
    'ChangeAuditStamps': ChangeAuditStampsClass,
    'Cost': CostClass,
    'CostCost': CostCostClass,
    'CostCostDiscriminator': CostCostDiscriminatorClass,
    'CostType': CostTypeClass,
    'DataPlatformInstance': DataPlatformInstanceClass,
    'Deprecation': DeprecationClass,
    'Edge': EdgeClass,
    'Embed': EmbedClass,
    'FabricType': FabricTypeClass,
    'FieldFormPromptAssociation': FieldFormPromptAssociationClass,
    'FormAssociation': FormAssociationClass,
    'FormPromptAssociation': FormPromptAssociationClass,
    'FormPromptFieldAssociations': FormPromptFieldAssociationsClass,
    'FormVerificationAssociation': FormVerificationAssociationClass,
    'Forms': FormsClass,
    'GlobalTags': GlobalTagsClass,
    'GlossaryTermAssociation': GlossaryTermAssociationClass,
    'GlossaryTerms': GlossaryTermsClass,
    'IncidentSummaryDetails': IncidentSummaryDetailsClass,
    'IncidentsSummary': IncidentsSummaryClass,
    'InputField': InputFieldClass,
    'InputFields': InputFieldsClass,
    'InstitutionalMemory': InstitutionalMemoryClass,
    'InstitutionalMemoryMetadata': InstitutionalMemoryMetadataClass,
    'MLFeatureDataType': MLFeatureDataTypeClass,
    'Media': MediaClass,
    'MediaType': MediaTypeClass,
    'Operation': OperationClass,
    'OperationSourceType': OperationSourceTypeClass,
    'OperationType': OperationTypeClass,
    'Origin': OriginClass,
    'OriginType': OriginTypeClass,
    'Owner': OwnerClass,
    'Ownership': OwnershipClass,
    'OwnershipSource': OwnershipSourceClass,
    'OwnershipSourceType': OwnershipSourceTypeClass,
    'OwnershipType': OwnershipTypeClass,
    'RoleAssociation': RoleAssociationClass,
    'Siblings': SiblingsClass,
    'Status': StatusClass,
    'SubTypes': SubTypesClass,
    'TagAssociation': TagAssociationClass,
    'TimeStamp': TimeStampClass,
    'VersionTag': VersionTagClass,
    'WindowDuration': WindowDurationClass,
    'TransformationType': TransformationTypeClass,
    'UDFTransformer': UDFTransformerClass,
    'Container': ContainerClass,
    'ContainerProperties': ContainerPropertiesClass,
    'EditableContainerProperties': EditableContainerPropertiesClass,
    'DashboardInfo': DashboardInfoClass,
    'DashboardUsageStatistics': DashboardUsageStatisticsClass,
    'DashboardUserUsageCounts': DashboardUserUsageCountsClass,
    'EditableDashboardProperties': EditableDashboardPropertiesClass,
    'DataContractProperties': DataContractPropertiesClass,
    'DataContractState': DataContractStateClass,
    'DataContractStatus': DataContractStatusClass,
    'DataQualityContract': DataQualityContractClass,
    'FreshnessContract': FreshnessContractClass,
    'SchemaContract': SchemaContractClass,
    'DataHubSearchConfig': DataHubSearchConfigClass,
    'SearchFieldType': SearchFieldTypeClass,
    'DataFlowInfo': DataFlowInfoClass,
    'DataJobInfo': DataJobInfoClass,
    'DataJobInputOutput': DataJobInputOutputClass,
    'EditableDataFlowProperties': EditableDataFlowPropertiesClass,
    'EditableDataJobProperties': EditableDataJobPropertiesClass,
    'JobStatus': JobStatusClass,
    'VersionInfo': VersionInfoClass,
    'AzkabanJobType': AzkabanJobTypeClass,
    'DatahubIngestionCheckpoint': DatahubIngestionCheckpointClass,
    'DatahubIngestionRunSummary': DatahubIngestionRunSummaryClass,
    'IngestionCheckpointState': IngestionCheckpointStateClass,
    'DataPlatformInfo': DataPlatformInfoClass,
    'PlatformType': PlatformTypeClass,
    'DataPlatformInstanceProperties': DataPlatformInstancePropertiesClass,
    'DataProcessInfo': DataProcessInfoClass,
    'DataProcessInstanceInput': DataProcessInstanceInputClass,
    'DataProcessInstanceOutput': DataProcessInstanceOutputClass,
    'DataProcessInstanceProperties': DataProcessInstancePropertiesClass,
    'DataProcessInstanceRelationships': DataProcessInstanceRelationshipsClass,
    'DataProcessInstanceRunEvent': DataProcessInstanceRunEventClass,
    'DataProcessInstanceRunResult': DataProcessInstanceRunResultClass,
    'DataProcessRunStatus': DataProcessRunStatusClass,
    'DataProcessType': DataProcessTypeClass,
    'RunResultType': RunResultTypeClass,
    'DataProductAssociation': DataProductAssociationClass,
    'DataProductKey': DataProductKeyClass,
    'DataProductProperties': DataProductPropertiesClass,
    'DatasetDeprecation': DatasetDeprecationClass,
    'DatasetFieldMapping': DatasetFieldMappingClass,
    'DatasetFieldProfile': DatasetFieldProfileClass,
    'DatasetFieldUsageCounts': DatasetFieldUsageCountsClass,
    'DatasetFilter': DatasetFilterClass,
    'DatasetFilterType': DatasetFilterTypeClass,
    'DatasetLineageType': DatasetLineageTypeClass,
    'DatasetProfile': DatasetProfileClass,
    'DatasetProperties': DatasetPropertiesClass,
    'DatasetUpstreamLineage': DatasetUpstreamLineageClass,
    'DatasetUsageStatistics': DatasetUsageStatisticsClass,
    'DatasetUserUsageCounts': DatasetUserUsageCountsClass,
    'EditableDatasetProperties': EditableDatasetPropertiesClass,
    'FineGrainedLineage': FineGrainedLineageClass,
    'FineGrainedLineageDownstreamType': FineGrainedLineageDownstreamTypeClass,
    'FineGrainedLineageUpstreamType': FineGrainedLineageUpstreamTypeClass,
    'Histogram': HistogramClass,
    'Quantile': QuantileClass,
    'Upstream': UpstreamClass,
    'UpstreamLineage': UpstreamLineageClass,
    'ValueFrequency': ValueFrequencyClass,
    'ViewProperties': ViewPropertiesClass,
    'DataTypeInfo': DataTypeInfoClass,
    'DataTypeKey': DataTypeKeyClass,
    'DomainProperties': DomainPropertiesClass,
    'Domains': DomainsClass,
    'EntityTypeInfo': EntityTypeInfoClass,
    'EntityTypeKey': EntityTypeKeyClass,
    'ChangeType': ChangeTypeClass,
    'ExecutionRequestInput': ExecutionRequestInputClass,
    'ExecutionRequestResult': ExecutionRequestResultClass,
    'ExecutionRequestSignal': ExecutionRequestSignalClass,
    'ExecutionRequestSource': ExecutionRequestSourceClass,
    'StructuredExecutionReport': StructuredExecutionReportClass,
    'DynamicFormAssignment': DynamicFormAssignmentClass,
    'FormActorAssignment': FormActorAssignmentClass,
    'FormInfo': FormInfoClass,
    'FormPrompt': FormPromptClass,
    'FormPromptType': FormPromptTypeClass,
    'FormType': FormTypeClass,
    'StructuredPropertyParams': StructuredPropertyParamsClass,
    'GlossaryNodeInfo': GlossaryNodeInfoClass,
    'GlossaryRelatedTerms': GlossaryRelatedTermsClass,
    'GlossaryTermInfo': GlossaryTermInfoClass,
    'CorpGroupEditableInfo': CorpGroupEditableInfoClass,
    'CorpGroupInfo': CorpGroupInfoClass,
    'CorpUserAppearanceSettings': CorpUserAppearanceSettingsClass,
    'CorpUserCredentials': CorpUserCredentialsClass,
    'CorpUserEditableInfo': CorpUserEditableInfoClass,
    'CorpUserInfo': CorpUserInfoClass,
    'CorpUserSettings': CorpUserSettingsClass,
    'CorpUserStatus': CorpUserStatusClass,
    'CorpUserViewsSettings': CorpUserViewsSettingsClass,
    'GroupMembership': GroupMembershipClass,
    'InviteToken': InviteTokenClass,
    'NativeGroupMembership': NativeGroupMembershipClass,
    'RoleMembership': RoleMembershipClass,
    'IncidentInfo': IncidentInfoClass,
    'IncidentSource': IncidentSourceClass,
    'IncidentSourceType': IncidentSourceTypeClass,
    'IncidentState': IncidentStateClass,
    'IncidentStatus': IncidentStatusClass,
    'IncidentType': IncidentTypeClass,
    'DataHubIngestionSourceConfig': DataHubIngestionSourceConfigClass,
    'DataHubIngestionSourceInfo': DataHubIngestionSourceInfoClass,
    'DataHubIngestionSourceSchedule': DataHubIngestionSourceScheduleClass,
    'AssertionKey': AssertionKeyClass,
    'ChartKey': ChartKeyClass,
    'ContainerKey': ContainerKeyClass,
    'CorpGroupKey': CorpGroupKeyClass,
    'CorpUserKey': CorpUserKeyClass,
    'DashboardKey': DashboardKeyClass,
    'DataContractKey': DataContractKeyClass,
    'DataFlowKey': DataFlowKeyClass,
    'DataHubAccessTokenKey': DataHubAccessTokenKeyClass,
    'DataHubIngestionSourceKey': DataHubIngestionSourceKeyClass,
    'DataHubPolicyKey': DataHubPolicyKeyClass,
    'DataHubRetentionKey': DataHubRetentionKeyClass,
    'DataHubRoleKey': DataHubRoleKeyClass,
    'DataHubSecretKey': DataHubSecretKeyClass,
    'DataHubStepStateKey': DataHubStepStateKeyClass,
    'DataHubUpgradeKey': DataHubUpgradeKeyClass,
    'DataHubViewKey': DataHubViewKeyClass,
    'DataJobKey': DataJobKeyClass,
    'DataPlatformInstanceKey': DataPlatformInstanceKeyClass,
    'DataPlatformKey': DataPlatformKeyClass,
    'DataProcessInstanceKey': DataProcessInstanceKeyClass,
    'DataProcessKey': DataProcessKeyClass,
    'DatasetKey': DatasetKeyClass,
    'DomainKey': DomainKeyClass,
    'ExecutionRequestKey': ExecutionRequestKeyClass,
    'FormKey': FormKeyClass,
    'GlobalSettingsKey': GlobalSettingsKeyClass,
    'GlossaryNodeKey': GlossaryNodeKeyClass,
    'GlossaryTermKey': GlossaryTermKeyClass,
    'IncidentKey': IncidentKeyClass,
    'InviteTokenKey': InviteTokenKeyClass,
    'MLFeatureKey': MLFeatureKeyClass,
    'MLFeatureTableKey': MLFeatureTableKeyClass,
    'MLModelDeploymentKey': MLModelDeploymentKeyClass,
    'MLModelGroupKey': MLModelGroupKeyClass,
    'MLModelKey': MLModelKeyClass,
    'MLPrimaryKeyKey': MLPrimaryKeyKeyClass,
    'NotebookKey': NotebookKeyClass,
    'OwnershipTypeKey': OwnershipTypeKeyClass,
    'PostKey': PostKeyClass,
    'QueryKey': QueryKeyClass,
    'RoleKey': RoleKeyClass,
    'SchemaFieldKey': SchemaFieldKeyClass,
    'TagKey': TagKeyClass,
    'TelemetryKey': TelemetryKeyClass,
    'TestKey': TestKeyClass,
    'Condition': ConditionClass,
    'ConjunctiveCriterion': ConjunctiveCriterionClass,
    'Criterion': CriterionClass,
    'Filter': FilterClass,
    'ChartSnapshot': ChartSnapshotClass,
    'CorpGroupSnapshot': CorpGroupSnapshotClass,
    'CorpUserSnapshot': CorpUserSnapshotClass,
    'DashboardSnapshot': DashboardSnapshotClass,
    'DataFlowSnapshot': DataFlowSnapshotClass,
    'DataHubPolicySnapshot': DataHubPolicySnapshotClass,
    'DataHubRetentionSnapshot': DataHubRetentionSnapshotClass,
    'DataJobSnapshot': DataJobSnapshotClass,
    'DataPlatformSnapshot': DataPlatformSnapshotClass,
    'DataProcessSnapshot': DataProcessSnapshotClass,
    'DatasetSnapshot': DatasetSnapshotClass,
    'GlossaryNodeSnapshot': GlossaryNodeSnapshotClass,
    'GlossaryTermSnapshot': GlossaryTermSnapshotClass,
    'MLFeatureSnapshot': MLFeatureSnapshotClass,
    'MLFeatureTableSnapshot': MLFeatureTableSnapshotClass,
    'MLModelDeploymentSnapshot': MLModelDeploymentSnapshotClass,
    'MLModelGroupSnapshot': MLModelGroupSnapshotClass,
    'MLModelSnapshot': MLModelSnapshotClass,
    'MLPrimaryKeySnapshot': MLPrimaryKeySnapshotClass,
    'SchemaFieldSnapshot': SchemaFieldSnapshotClass,
    'TagSnapshot': TagSnapshotClass,
    'BaseData': BaseDataClass,
    'CaveatDetails': CaveatDetailsClass,
    'CaveatsAndRecommendations': CaveatsAndRecommendationsClass,
    'DeploymentStatus': DeploymentStatusClass,
    'EditableMLFeatureProperties': EditableMLFeaturePropertiesClass,
    'EditableMLFeatureTableProperties': EditableMLFeatureTablePropertiesClass,
    'EditableMLModelGroupProperties': EditableMLModelGroupPropertiesClass,
    'EditableMLModelProperties': EditableMLModelPropertiesClass,
    'EditableMLPrimaryKeyProperties': EditableMLPrimaryKeyPropertiesClass,
    'EthicalConsiderations': EthicalConsiderationsClass,
    'EvaluationData': EvaluationDataClass,
    'IntendedUse': IntendedUseClass,
    'IntendedUserType': IntendedUserTypeClass,
    'MLFeatureProperties': MLFeaturePropertiesClass,
    'MLFeatureTableProperties': MLFeatureTablePropertiesClass,
    'MLHyperParam': MLHyperParamClass,
    'MLMetric': MLMetricClass,
    'MLModelDeploymentProperties': MLModelDeploymentPropertiesClass,
    'MLModelFactorPrompts': MLModelFactorPromptsClass,
    'MLModelFactors': MLModelFactorsClass,
    'MLModelGroupProperties': MLModelGroupPropertiesClass,
    'MLModelProperties': MLModelPropertiesClass,
    'MLPrimaryKeyProperties': MLPrimaryKeyPropertiesClass,
    'Metrics': MetricsClass,
    'QuantitativeAnalyses': QuantitativeAnalysesClass,
    'SourceCode': SourceCodeClass,
    'SourceCodeUrl': SourceCodeUrlClass,
    'SourceCodeUrlType': SourceCodeUrlTypeClass,
    'TrainingData': TrainingDataClass,
    'GenericAspect': GenericAspectClass,
    'GenericPayload': GenericPayloadClass,
    'MetadataChangeEvent': MetadataChangeEventClass,
    'MetadataChangeLog': MetadataChangeLogClass,
    'MetadataChangeProposal': MetadataChangeProposalClass,
    'PlatformEvent': PlatformEventClass,
    'PlatformEventHeader': PlatformEventHeaderClass,
    'SystemMetadata': SystemMetadataClass,
    'ChartCell': ChartCellClass,
    'EditableNotebookProperties': EditableNotebookPropertiesClass,
    'NotebookCell': NotebookCellClass,
    'NotebookCellType': NotebookCellTypeClass,
    'NotebookContent': NotebookContentClass,
    'NotebookInfo': NotebookInfoClass,
    'QueryCell': QueryCellClass,
    'TextCell': TextCellClass,
    'OwnershipTypeInfo': OwnershipTypeInfoClass,
    'EntityChangeEvent': EntityChangeEventClass,
    'Parameters': ParametersClass,
    'DataHubActorFilter': DataHubActorFilterClass,
    'DataHubPolicyInfo': DataHubPolicyInfoClass,
    'DataHubResourceFilter': DataHubResourceFilterClass,
    'DataHubRoleInfo': DataHubRoleInfoClass,
    'PolicyMatchCondition': PolicyMatchConditionClass,
    'PolicyMatchCriterion': PolicyMatchCriterionClass,
    'PolicyMatchFilter': PolicyMatchFilterClass,
    'PostContent': PostContentClass,
    'PostContentType': PostContentTypeClass,
    'PostInfo': PostInfoClass,
    'PostType': PostTypeClass,
    'QueryLanguage': QueryLanguageClass,
    'QueryProperties': QueryPropertiesClass,
    'QuerySource': QuerySourceClass,
    'QueryStatement': QueryStatementClass,
    'QuerySubject': QuerySubjectClass,
    'QuerySubjects': QuerySubjectsClass,
    'DataHubRetentionConfig': DataHubRetentionConfigClass,
    'Retention': RetentionClass,
    'TimeBasedRetention': TimeBasedRetentionClass,
    'VersionBasedRetention': VersionBasedRetentionClass,
    'Actors': ActorsClass,
    'RoleProperties': RolePropertiesClass,
    'RoleUser': RoleUserClass,
    'ArrayType': ArrayTypeClass,
    'BinaryJsonSchema': BinaryJsonSchemaClass,
    'BooleanType': BooleanTypeClass,
    'BytesType': BytesTypeClass,
    'DatasetFieldForeignKey': DatasetFieldForeignKeyClass,
    'DateType': DateTypeClass,
    'EditableSchemaFieldInfo': EditableSchemaFieldInfoClass,
    'EditableSchemaMetadata': EditableSchemaMetadataClass,
    'EnumType': EnumTypeClass,
    'EspressoSchema': EspressoSchemaClass,
    'FixedType': FixedTypeClass,
    'ForeignKeyConstraint': ForeignKeyConstraintClass,
    'ForeignKeySpec': ForeignKeySpecClass,
    'KafkaSchema': KafkaSchemaClass,
    'KeyValueSchema': KeyValueSchemaClass,
    'MapType': MapTypeClass,
    'MySqlDDL': MySqlDDLClass,
    'NullType': NullTypeClass,
    'NumberType': NumberTypeClass,
    'OracleDDL': OracleDDLClass,
    'OrcSchema': OrcSchemaClass,
    'OtherSchema': OtherSchemaClass,
    'PrestoDDL': PrestoDDLClass,
    'RecordType': RecordTypeClass,
    'SchemaField': SchemaFieldClass,
    'SchemaFieldDataType': SchemaFieldDataTypeClass,
    'SchemaFieldSpec': SchemaFieldSpecClass,
    'SchemaMetadata': SchemaMetadataClass,
    'Schemaless': SchemalessClass,
    'StringType': StringTypeClass,
    'TimeType': TimeTypeClass,
    'UnionType': UnionTypeClass,
    'UrnForeignKey': UrnForeignKeyClass,
    'DataHubSecretValue': DataHubSecretValueClass,
    'GlobalSettingsInfo': GlobalSettingsInfoClass,
    'GlobalViewsSettings': GlobalViewsSettingsClass,
    'OidcSettings': OidcSettingsClass,
    'SsoSettings': SsoSettingsClass,
    'DataHubStepStateProperties': DataHubStepStatePropertiesClass,
    'PropertyCardinality': PropertyCardinalityClass,
    'PropertyValue': PropertyValueClass,
    'StructuredProperties': StructuredPropertiesClass,
    'StructuredPropertyDefinition': StructuredPropertyDefinitionClass,
    'StructuredPropertyKey': StructuredPropertyKeyClass,
    'StructuredPropertyValueAssignment': StructuredPropertyValueAssignmentClass,
    'TagProperties': TagPropertiesClass,
    'TelemetryClientId': TelemetryClientIdClass,
    'TestDefinition': TestDefinitionClass,
    'TestDefinitionType': TestDefinitionTypeClass,
    'TestInfo': TestInfoClass,
    'TestResult': TestResultClass,
    'TestResultType': TestResultTypeClass,
    'TestResults': TestResultsClass,
    'CalendarInterval': CalendarIntervalClass,
    'PartitionSpec': PartitionSpecClass,
    'PartitionType': PartitionTypeClass,
    'TimeWindow': TimeWindowClass,
    'TimeWindowSize': TimeWindowSizeClass,
    'DataHubUpgradeRequest': DataHubUpgradeRequestClass,
    'DataHubUpgradeResult': DataHubUpgradeResultClass,
    'FieldUsageCounts': FieldUsageCountsClass,
    'UsageAggregation': UsageAggregationClass,
    'UsageAggregationMetrics': UsageAggregationMetricsClass,
    'UserUsageCounts': UserUsageCountsClass,
    'DataHubViewDefinition': DataHubViewDefinitionClass,
    'DataHubViewInfo': DataHubViewInfoClass,
    'DataHubViewType': DataHubViewTypeClass,
}

_json_converter = avrojson.AvroJsonConverter(use_logical_types=False, schema_types=__SCHEMA_TYPES)
avrojson.set_global_json_converter(_json_converter)


    

ASPECT_CLASSES: List[Type[_Aspect]] = [
    DataHubUpgradeResultClass,
    DataHubUpgradeRequestClass,
    TelemetryClientIdClass,
    DataHubRoleInfoClass,
    DataHubPolicyInfoClass,
    QuerySubjectsClass,
    QueryPropertiesClass,
    DataHubViewInfoClass,
    DynamicFormAssignmentClass,
    FormInfoClass,
    DataHubStepStatePropertiesClass,
    EditableContainerPropertiesClass,
    ContainerPropertiesClass,
    ContainerClass,
    DataTypeInfoClass,
    DataTypeKeyClass,
    TagPropertiesClass,
    DataJobInfoClass,
    EditableDataJobPropertiesClass,
    VersionInfoClass,
    DataJobInputOutputClass,
    EditableDataFlowPropertiesClass,
    DataFlowInfoClass,
    DatahubIngestionCheckpointClass,
    DatahubIngestionRunSummaryClass,
    ExecutionRequestKeyClass,
    PostKeyClass,
    DataHubRetentionKeyClass,
    TelemetryKeyClass,
    IncidentKeyClass,
    AssertionKeyClass,
    NotebookKeyClass,
    ContainerKeyClass,
    DataHubUpgradeKeyClass,
    MLModelDeploymentKeyClass,
    MLModelGroupKeyClass,
    DataHubStepStateKeyClass,
    DataHubSecretKeyClass,
    FormKeyClass,
    GlossaryTermKeyClass,
    DomainKeyClass,
    GlobalSettingsKeyClass,
    DatasetKeyClass,
    SchemaFieldKeyClass,
    DataHubPolicyKeyClass,
    MLFeatureTableKeyClass,
    TagKeyClass,
    MLPrimaryKeyKeyClass,
    DataProcessInstanceKeyClass,
    CorpGroupKeyClass,
    MLModelKeyClass,
    DashboardKeyClass,
    RoleKeyClass,
    InviteTokenKeyClass,
    DataHubViewKeyClass,
    OwnershipTypeKeyClass,
    DataJobKeyClass,
    DataPlatformInstanceKeyClass,
    DataHubRoleKeyClass,
    DataPlatformKeyClass,
    DataHubAccessTokenKeyClass,
    MLFeatureKeyClass,
    DataHubIngestionSourceKeyClass,
    TestKeyClass,
    CorpUserKeyClass,
    DataFlowKeyClass,
    GlossaryNodeKeyClass,
    DataContractKeyClass,
    ChartKeyClass,
    QueryKeyClass,
    DataProcessKeyClass,
    GlobalSettingsInfoClass,
    EmbedClass,
    SubTypesClass,
    AccessClass,
    OwnershipClass,
    BrowsePathsClass,
    IncidentsSummaryClass,
    CostClass,
    OriginClass,
    InstitutionalMemoryClass,
    SiblingsClass,
    OperationClass,
    FormsClass,
    StatusClass,
    InputFieldsClass,
    GlossaryTermsClass,
    DeprecationClass,
    BrowsePathsV2Class,
    GlobalTagsClass,
    DataPlatformInstanceClass,
    EntityTypeKeyClass,
    EntityTypeInfoClass,
    OwnershipTypeInfoClass,
    DataPlatformInfoClass,
    MLModelFactorPromptsClass,
    EditableMLModelPropertiesClass,
    EditableMLPrimaryKeyPropertiesClass,
    IntendedUseClass,
    MLModelPropertiesClass,
    MLFeatureTablePropertiesClass,
    MLModelGroupPropertiesClass,
    CaveatsAndRecommendationsClass,
    MLHyperParamClass,
    SourceCodeClass,
    TrainingDataClass,
    MetricsClass,
    EditableMLFeaturePropertiesClass,
    MLMetricClass,
    MLModelDeploymentPropertiesClass,
    EthicalConsiderationsClass,
    MLFeaturePropertiesClass,
    EvaluationDataClass,
    MLPrimaryKeyPropertiesClass,
    EditableMLModelGroupPropertiesClass,
    EditableMLFeatureTablePropertiesClass,
    QuantitativeAnalysesClass,
    DataHubRetentionConfigClass,
    DataProcessInstanceOutputClass,
    DataProcessInstanceRunEventClass,
    DataProcessInfoClass,
    DataProcessInstanceRelationshipsClass,
    DataProcessInstancePropertiesClass,
    DataProcessInstanceInputClass,
    EditableChartPropertiesClass,
    ChartUsageStatisticsClass,
    ChartQueryClass,
    ChartInfoClass,
    DataHubSecretValueClass,
    StructuredPropertiesClass,
    StructuredPropertyKeyClass,
    StructuredPropertyDefinitionClass,
    EditableDatasetPropertiesClass,
    ViewPropertiesClass,
    DatasetUsageStatisticsClass,
    UpstreamLineageClass,
    DatasetUpstreamLineageClass,
    DatasetProfileClass,
    DatasetDeprecationClass,
    DatasetPropertiesClass,
    DashboardInfoClass,
    EditableDashboardPropertiesClass,
    DashboardUsageStatisticsClass,
    DataHubAccessTokenInfoClass,
    IncidentSourceClass,
    IncidentInfoClass,
    NotebookContentClass,
    EditableNotebookPropertiesClass,
    NotebookInfoClass,
    PostInfoClass,
    DataHubIngestionSourceInfoClass,
    GlossaryNodeInfoClass,
    GlossaryTermInfoClass,
    GlossaryRelatedTermsClass,
    DataPlatformInstancePropertiesClass,
    ExecutionRequestSignalClass,
    ExecutionRequestResultClass,
    ExecutionRequestInputClass,
    DataProductPropertiesClass,
    DataProductKeyClass,
    DomainsClass,
    DomainPropertiesClass,
    EditableSchemaMetadataClass,
    SchemaMetadataClass,
    DataContractStatusClass,
    DataContractPropertiesClass,
    AssertionInfoClass,
    AssertionActionsClass,
    AssertionRunEventClass,
    CorpUserEditableInfoClass,
    CorpUserCredentialsClass,
    RoleMembershipClass,
    NativeGroupMembershipClass,
    CorpUserInfoClass,
    InviteTokenClass,
    CorpUserStatusClass,
    CorpGroupInfoClass,
    CorpUserSettingsClass,
    GroupMembershipClass,
    CorpGroupEditableInfoClass,
    TestResultsClass,
    TestInfoClass,
    ActorsClass,
    RolePropertiesClass
]

ASPECT_NAME_MAP: Dict[str, Type[_Aspect]] = {
    aspect.get_aspect_name(): aspect
    for aspect in ASPECT_CLASSES
}

from typing_extensions import TypedDict

class AspectBag(TypedDict, total=False):
    dataHubUpgradeResult: DataHubUpgradeResultClass
    dataHubUpgradeRequest: DataHubUpgradeRequestClass
    telemetryClientId: TelemetryClientIdClass
    dataHubRoleInfo: DataHubRoleInfoClass
    dataHubPolicyInfo: DataHubPolicyInfoClass
    querySubjects: QuerySubjectsClass
    queryProperties: QueryPropertiesClass
    dataHubViewInfo: DataHubViewInfoClass
    dynamicFormAssignment: DynamicFormAssignmentClass
    formInfo: FormInfoClass
    dataHubStepStateProperties: DataHubStepStatePropertiesClass
    editableContainerProperties: EditableContainerPropertiesClass
    containerProperties: ContainerPropertiesClass
    container: ContainerClass
    dataTypeInfo: DataTypeInfoClass
    dataTypeKey: DataTypeKeyClass
    tagProperties: TagPropertiesClass
    dataJobInfo: DataJobInfoClass
    editableDataJobProperties: EditableDataJobPropertiesClass
    versionInfo: VersionInfoClass
    dataJobInputOutput: DataJobInputOutputClass
    editableDataFlowProperties: EditableDataFlowPropertiesClass
    dataFlowInfo: DataFlowInfoClass
    datahubIngestionCheckpoint: DatahubIngestionCheckpointClass
    datahubIngestionRunSummary: DatahubIngestionRunSummaryClass
    dataHubExecutionRequestKey: ExecutionRequestKeyClass
    postKey: PostKeyClass
    dataHubRetentionKey: DataHubRetentionKeyClass
    telemetryKey: TelemetryKeyClass
    incidentKey: IncidentKeyClass
    assertionKey: AssertionKeyClass
    notebookKey: NotebookKeyClass
    containerKey: ContainerKeyClass
    dataHubUpgradeKey: DataHubUpgradeKeyClass
    mlModelDeploymentKey: MLModelDeploymentKeyClass
    mlModelGroupKey: MLModelGroupKeyClass
    dataHubStepStateKey: DataHubStepStateKeyClass
    dataHubSecretKey: DataHubSecretKeyClass
    formKey: FormKeyClass
    glossaryTermKey: GlossaryTermKeyClass
    domainKey: DomainKeyClass
    globalSettingsKey: GlobalSettingsKeyClass
    datasetKey: DatasetKeyClass
    schemaFieldKey: SchemaFieldKeyClass
    dataHubPolicyKey: DataHubPolicyKeyClass
    mlFeatureTableKey: MLFeatureTableKeyClass
    tagKey: TagKeyClass
    mlPrimaryKeyKey: MLPrimaryKeyKeyClass
    dataProcessInstanceKey: DataProcessInstanceKeyClass
    corpGroupKey: CorpGroupKeyClass
    mlModelKey: MLModelKeyClass
    dashboardKey: DashboardKeyClass
    roleKey: RoleKeyClass
    inviteTokenKey: InviteTokenKeyClass
    dataHubViewKey: DataHubViewKeyClass
    ownershipTypeKey: OwnershipTypeKeyClass
    dataJobKey: DataJobKeyClass
    dataPlatformInstanceKey: DataPlatformInstanceKeyClass
    dataHubRoleKey: DataHubRoleKeyClass
    dataPlatformKey: DataPlatformKeyClass
    dataHubAccessTokenKey: DataHubAccessTokenKeyClass
    mlFeatureKey: MLFeatureKeyClass
    dataHubIngestionSourceKey: DataHubIngestionSourceKeyClass
    testKey: TestKeyClass
    corpUserKey: CorpUserKeyClass
    dataFlowKey: DataFlowKeyClass
    glossaryNodeKey: GlossaryNodeKeyClass
    dataContractKey: DataContractKeyClass
    chartKey: ChartKeyClass
    queryKey: QueryKeyClass
    dataProcessKey: DataProcessKeyClass
    globalSettingsInfo: GlobalSettingsInfoClass
    embed: EmbedClass
    subTypes: SubTypesClass
    access: AccessClass
    ownership: OwnershipClass
    browsePaths: BrowsePathsClass
    incidentsSummary: IncidentsSummaryClass
    cost: CostClass
    origin: OriginClass
    institutionalMemory: InstitutionalMemoryClass
    siblings: SiblingsClass
    operation: OperationClass
    forms: FormsClass
    status: StatusClass
    inputFields: InputFieldsClass
    glossaryTerms: GlossaryTermsClass
    deprecation: DeprecationClass
    browsePathsV2: BrowsePathsV2Class
    globalTags: GlobalTagsClass
    dataPlatformInstance: DataPlatformInstanceClass
    entityTypeKey: EntityTypeKeyClass
    entityTypeInfo: EntityTypeInfoClass
    ownershipTypeInfo: OwnershipTypeInfoClass
    dataPlatformInfo: DataPlatformInfoClass
    mlModelFactorPrompts: MLModelFactorPromptsClass
    editableMlModelProperties: EditableMLModelPropertiesClass
    editableMlPrimaryKeyProperties: EditableMLPrimaryKeyPropertiesClass
    intendedUse: IntendedUseClass
    mlModelProperties: MLModelPropertiesClass
    mlFeatureTableProperties: MLFeatureTablePropertiesClass
    mlModelGroupProperties: MLModelGroupPropertiesClass
    mlModelCaveatsAndRecommendations: CaveatsAndRecommendationsClass
    mlHyperParam: MLHyperParamClass
    sourceCode: SourceCodeClass
    mlModelTrainingData: TrainingDataClass
    mlModelMetrics: MetricsClass
    editableMlFeatureProperties: EditableMLFeaturePropertiesClass
    mlMetric: MLMetricClass
    mlModelDeploymentProperties: MLModelDeploymentPropertiesClass
    mlModelEthicalConsiderations: EthicalConsiderationsClass
    mlFeatureProperties: MLFeaturePropertiesClass
    mlModelEvaluationData: EvaluationDataClass
    mlPrimaryKeyProperties: MLPrimaryKeyPropertiesClass
    editableMlModelGroupProperties: EditableMLModelGroupPropertiesClass
    editableMlFeatureTableProperties: EditableMLFeatureTablePropertiesClass
    mlModelQuantitativeAnalyses: QuantitativeAnalysesClass
    dataHubRetentionConfig: DataHubRetentionConfigClass
    dataProcessInstanceOutput: DataProcessInstanceOutputClass
    dataProcessInstanceRunEvent: DataProcessInstanceRunEventClass
    dataProcessInfo: DataProcessInfoClass
    dataProcessInstanceRelationships: DataProcessInstanceRelationshipsClass
    dataProcessInstanceProperties: DataProcessInstancePropertiesClass
    dataProcessInstanceInput: DataProcessInstanceInputClass
    editableChartProperties: EditableChartPropertiesClass
    chartUsageStatistics: ChartUsageStatisticsClass
    chartQuery: ChartQueryClass
    chartInfo: ChartInfoClass
    dataHubSecretValue: DataHubSecretValueClass
    structuredProperties: StructuredPropertiesClass
    structuredPropertyKey: StructuredPropertyKeyClass
    propertyDefinition: StructuredPropertyDefinitionClass
    editableDatasetProperties: EditableDatasetPropertiesClass
    viewProperties: ViewPropertiesClass
    datasetUsageStatistics: DatasetUsageStatisticsClass
    upstreamLineage: UpstreamLineageClass
    datasetUpstreamLineage: DatasetUpstreamLineageClass
    datasetProfile: DatasetProfileClass
    datasetDeprecation: DatasetDeprecationClass
    datasetProperties: DatasetPropertiesClass
    dashboardInfo: DashboardInfoClass
    editableDashboardProperties: EditableDashboardPropertiesClass
    dashboardUsageStatistics: DashboardUsageStatisticsClass
    dataHubAccessTokenInfo: DataHubAccessTokenInfoClass
    incidentSource: IncidentSourceClass
    incidentInfo: IncidentInfoClass
    notebookContent: NotebookContentClass
    editableNotebookProperties: EditableNotebookPropertiesClass
    notebookInfo: NotebookInfoClass
    postInfo: PostInfoClass
    dataHubIngestionSourceInfo: DataHubIngestionSourceInfoClass
    glossaryNodeInfo: GlossaryNodeInfoClass
    glossaryTermInfo: GlossaryTermInfoClass
    glossaryRelatedTerms: GlossaryRelatedTermsClass
    dataPlatformInstanceProperties: DataPlatformInstancePropertiesClass
    dataHubExecutionRequestSignal: ExecutionRequestSignalClass
    dataHubExecutionRequestResult: ExecutionRequestResultClass
    dataHubExecutionRequestInput: ExecutionRequestInputClass
    dataProductProperties: DataProductPropertiesClass
    dataProductKey: DataProductKeyClass
    domains: DomainsClass
    domainProperties: DomainPropertiesClass
    editableSchemaMetadata: EditableSchemaMetadataClass
    schemaMetadata: SchemaMetadataClass
    dataContractStatus: DataContractStatusClass
    dataContractProperties: DataContractPropertiesClass
    assertionInfo: AssertionInfoClass
    assertionActions: AssertionActionsClass
    assertionRunEvent: AssertionRunEventClass
    corpUserEditableInfo: CorpUserEditableInfoClass
    corpUserCredentials: CorpUserCredentialsClass
    roleMembership: RoleMembershipClass
    nativeGroupMembership: NativeGroupMembershipClass
    corpUserInfo: CorpUserInfoClass
    inviteToken: InviteTokenClass
    corpUserStatus: CorpUserStatusClass
    corpGroupInfo: CorpGroupInfoClass
    corpUserSettings: CorpUserSettingsClass
    groupMembership: GroupMembershipClass
    corpGroupEditableInfo: CorpGroupEditableInfoClass
    testResults: TestResultsClass
    testInfo: TestInfoClass
    actors: ActorsClass
    roleProperties: RolePropertiesClass


KEY_ASPECTS: Dict[str, Type[_Aspect]] = {
    'dataType': DataTypeKeyClass,
    'dataHubExecutionRequest': ExecutionRequestKeyClass,
    'post': PostKeyClass,
    'dataHubRetention': DataHubRetentionKeyClass,
    'telemetry': TelemetryKeyClass,
    'incident': IncidentKeyClass,
    'assertion': AssertionKeyClass,
    'notebook': NotebookKeyClass,
    'container': ContainerKeyClass,
    'dataHubUpgrade': DataHubUpgradeKeyClass,
    'mlModelDeployment': MLModelDeploymentKeyClass,
    'mlModelGroup': MLModelGroupKeyClass,
    'dataHubStepState': DataHubStepStateKeyClass,
    'dataHubSecret': DataHubSecretKeyClass,
    'form': FormKeyClass,
    'glossaryTerm': GlossaryTermKeyClass,
    'domain': DomainKeyClass,
    'globalSettings': GlobalSettingsKeyClass,
    'dataset': DatasetKeyClass,
    'schemaField': SchemaFieldKeyClass,
    'dataHubPolicy': DataHubPolicyKeyClass,
    'mlFeatureTable': MLFeatureTableKeyClass,
    'tag': TagKeyClass,
    'mlPrimaryKey': MLPrimaryKeyKeyClass,
    'dataProcessInstance': DataProcessInstanceKeyClass,
    'corpGroup': CorpGroupKeyClass,
    'mlModel': MLModelKeyClass,
    'dashboard': DashboardKeyClass,
    'role': RoleKeyClass,
    'inviteToken': InviteTokenKeyClass,
    'dataHubView': DataHubViewKeyClass,
    'ownershipType': OwnershipTypeKeyClass,
    'dataJob': DataJobKeyClass,
    'dataPlatformInstance': DataPlatformInstanceKeyClass,
    'dataHubRole': DataHubRoleKeyClass,
    'dataPlatform': DataPlatformKeyClass,
    'dataHubAccessToken': DataHubAccessTokenKeyClass,
    'mlFeature': MLFeatureKeyClass,
    'dataHubIngestionSource': DataHubIngestionSourceKeyClass,
    'test': TestKeyClass,
    'corpuser': CorpUserKeyClass,
    'dataFlow': DataFlowKeyClass,
    'glossaryNode': GlossaryNodeKeyClass,
    'dataContract': DataContractKeyClass,
    'chart': ChartKeyClass,
    'query': QueryKeyClass,
    'dataProcess': DataProcessKeyClass,
    'entityType': EntityTypeKeyClass,
    'structuredProperty': StructuredPropertyKeyClass,
    'dataProduct': DataProductKeyClass
}

# fmt: on
