# coding: utf-8

"""
    SRO Master API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 0.1.14
    Contact: info@nexium.me
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from sromaster.models.customer_email_out import CustomerEmailOut
from sromaster.models.customer_phone_out import CustomerPhoneOut
from sromaster.models.customer_status import CustomerStatus
from typing import Optional, Set
from typing_extensions import Self

class CustomerOut(BaseModel):
    """
    CustomerOut
    """ # noqa: E501
    id: StrictInt
    name: StrictStr
    inn: Optional[StrictStr]
    ogrn: Optional[StrictStr]
    address: Optional[StrictStr]
    status: CustomerStatus
    phones: Optional[List[CustomerPhoneOut]] = None
    emails: Optional[List[CustomerEmailOut]] = None
    __properties: ClassVar[List[str]] = ["id", "name", "inn", "ogrn", "address", "status", "phones", "emails"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CustomerOut from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in phones (list)
        _items = []
        if self.phones:
            for _item_phones in self.phones:
                if _item_phones:
                    _items.append(_item_phones.to_dict())
            _dict['phones'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in emails (list)
        _items = []
        if self.emails:
            for _item_emails in self.emails:
                if _item_emails:
                    _items.append(_item_emails.to_dict())
            _dict['emails'] = _items
        # set to None if inn (nullable) is None
        # and model_fields_set contains the field
        if self.inn is None and "inn" in self.model_fields_set:
            _dict['inn'] = None

        # set to None if ogrn (nullable) is None
        # and model_fields_set contains the field
        if self.ogrn is None and "ogrn" in self.model_fields_set:
            _dict['ogrn'] = None

        # set to None if address (nullable) is None
        # and model_fields_set contains the field
        if self.address is None and "address" in self.model_fields_set:
            _dict['address'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CustomerOut from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "name": obj.get("name"),
            "inn": obj.get("inn"),
            "ogrn": obj.get("ogrn"),
            "address": obj.get("address"),
            "status": obj.get("status"),
            "phones": [CustomerPhoneOut.from_dict(_item) for _item in obj["phones"]] if obj.get("phones") is not None else None,
            "emails": [CustomerEmailOut.from_dict(_item) for _item in obj["emails"]] if obj.get("emails") is not None else None
        })
        return _obj


