# coding: utf-8

"""
    SRO Master API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 0.1.14
    Contact: info@nexium.me
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from sromaster.models.accordance_status import AccordanceStatus
from sromaster.models.check_upsert_request import CheckUpsertRequest
from sromaster.models.insurance_upsert_request import InsuranceUpsertRequest
from sromaster.models.member_status import MemberStatus
from sromaster.models.organization_schema import OrganizationSchema
from sromaster.models.responsibility_level import ResponsibilityLevel
from sromaster.models.right_status import RightStatus
from sromaster.models.src_models_sro_registry import SrcModelsSroRegistry
from typing import Optional, Set
from typing_extensions import Self

class SROMemberUpsertRequest(BaseModel):
    """
    SROMemberUpsertRequest
    """ # noqa: E501
    registry: SrcModelsSroRegistry
    registry_id: StrictInt
    sro_registry_id: StrictInt
    organization: OrganizationSchema
    registration_number: Optional[StrictStr] = None
    member_status: Optional[MemberStatus] = None
    included_at: Optional[datetime] = None
    excluded_at: Optional[datetime] = None
    exclusion_reason: Optional[StrictStr] = None
    right_status: Optional[RightStatus] = None
    accordance_status: Optional[AccordanceStatus] = None
    is_simple: Optional[StrictBool] = None
    is_extremely_dangerous: Optional[StrictBool] = None
    is_nuclear: Optional[StrictBool] = None
    is_odo: Optional[StrictBool] = None
    compensation_fund_fee_vv: Optional[StrictInt] = None
    compensation_fund_fee_odo: Optional[StrictInt] = None
    responsibility_level_vv: Optional[ResponsibilityLevel] = None
    responsibility_level_odo: Optional[ResponsibilityLevel] = None
    registry_updated_at: Optional[datetime] = None
    insurances: Optional[List[InsuranceUpsertRequest]] = None
    checks: Optional[List[CheckUpsertRequest]] = None
    __properties: ClassVar[List[str]] = ["registry", "registry_id", "sro_registry_id", "organization", "registration_number", "member_status", "included_at", "excluded_at", "exclusion_reason", "right_status", "accordance_status", "is_simple", "is_extremely_dangerous", "is_nuclear", "is_odo", "compensation_fund_fee_vv", "compensation_fund_fee_odo", "responsibility_level_vv", "responsibility_level_odo", "registry_updated_at", "insurances", "checks"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of SROMemberUpsertRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of organization
        if self.organization:
            _dict['organization'] = self.organization.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in insurances (list)
        _items = []
        if self.insurances:
            for _item_insurances in self.insurances:
                if _item_insurances:
                    _items.append(_item_insurances.to_dict())
            _dict['insurances'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in checks (list)
        _items = []
        if self.checks:
            for _item_checks in self.checks:
                if _item_checks:
                    _items.append(_item_checks.to_dict())
            _dict['checks'] = _items
        # set to None if registration_number (nullable) is None
        # and model_fields_set contains the field
        if self.registration_number is None and "registration_number" in self.model_fields_set:
            _dict['registration_number'] = None

        # set to None if member_status (nullable) is None
        # and model_fields_set contains the field
        if self.member_status is None and "member_status" in self.model_fields_set:
            _dict['member_status'] = None

        # set to None if included_at (nullable) is None
        # and model_fields_set contains the field
        if self.included_at is None and "included_at" in self.model_fields_set:
            _dict['included_at'] = None

        # set to None if excluded_at (nullable) is None
        # and model_fields_set contains the field
        if self.excluded_at is None and "excluded_at" in self.model_fields_set:
            _dict['excluded_at'] = None

        # set to None if exclusion_reason (nullable) is None
        # and model_fields_set contains the field
        if self.exclusion_reason is None and "exclusion_reason" in self.model_fields_set:
            _dict['exclusion_reason'] = None

        # set to None if right_status (nullable) is None
        # and model_fields_set contains the field
        if self.right_status is None and "right_status" in self.model_fields_set:
            _dict['right_status'] = None

        # set to None if accordance_status (nullable) is None
        # and model_fields_set contains the field
        if self.accordance_status is None and "accordance_status" in self.model_fields_set:
            _dict['accordance_status'] = None

        # set to None if is_simple (nullable) is None
        # and model_fields_set contains the field
        if self.is_simple is None and "is_simple" in self.model_fields_set:
            _dict['is_simple'] = None

        # set to None if is_extremely_dangerous (nullable) is None
        # and model_fields_set contains the field
        if self.is_extremely_dangerous is None and "is_extremely_dangerous" in self.model_fields_set:
            _dict['is_extremely_dangerous'] = None

        # set to None if is_nuclear (nullable) is None
        # and model_fields_set contains the field
        if self.is_nuclear is None and "is_nuclear" in self.model_fields_set:
            _dict['is_nuclear'] = None

        # set to None if is_odo (nullable) is None
        # and model_fields_set contains the field
        if self.is_odo is None and "is_odo" in self.model_fields_set:
            _dict['is_odo'] = None

        # set to None if compensation_fund_fee_vv (nullable) is None
        # and model_fields_set contains the field
        if self.compensation_fund_fee_vv is None and "compensation_fund_fee_vv" in self.model_fields_set:
            _dict['compensation_fund_fee_vv'] = None

        # set to None if compensation_fund_fee_odo (nullable) is None
        # and model_fields_set contains the field
        if self.compensation_fund_fee_odo is None and "compensation_fund_fee_odo" in self.model_fields_set:
            _dict['compensation_fund_fee_odo'] = None

        # set to None if responsibility_level_vv (nullable) is None
        # and model_fields_set contains the field
        if self.responsibility_level_vv is None and "responsibility_level_vv" in self.model_fields_set:
            _dict['responsibility_level_vv'] = None

        # set to None if responsibility_level_odo (nullable) is None
        # and model_fields_set contains the field
        if self.responsibility_level_odo is None and "responsibility_level_odo" in self.model_fields_set:
            _dict['responsibility_level_odo'] = None

        # set to None if registry_updated_at (nullable) is None
        # and model_fields_set contains the field
        if self.registry_updated_at is None and "registry_updated_at" in self.model_fields_set:
            _dict['registry_updated_at'] = None

        # set to None if insurances (nullable) is None
        # and model_fields_set contains the field
        if self.insurances is None and "insurances" in self.model_fields_set:
            _dict['insurances'] = None

        # set to None if checks (nullable) is None
        # and model_fields_set contains the field
        if self.checks is None and "checks" in self.model_fields_set:
            _dict['checks'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of SROMemberUpsertRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "registry": obj.get("registry"),
            "registry_id": obj.get("registry_id"),
            "sro_registry_id": obj.get("sro_registry_id"),
            "organization": OrganizationSchema.from_dict(obj["organization"]) if obj.get("organization") is not None else None,
            "registration_number": obj.get("registration_number"),
            "member_status": obj.get("member_status"),
            "included_at": obj.get("included_at"),
            "excluded_at": obj.get("excluded_at"),
            "exclusion_reason": obj.get("exclusion_reason"),
            "right_status": obj.get("right_status"),
            "accordance_status": obj.get("accordance_status"),
            "is_simple": obj.get("is_simple"),
            "is_extremely_dangerous": obj.get("is_extremely_dangerous"),
            "is_nuclear": obj.get("is_nuclear"),
            "is_odo": obj.get("is_odo"),
            "compensation_fund_fee_vv": obj.get("compensation_fund_fee_vv"),
            "compensation_fund_fee_odo": obj.get("compensation_fund_fee_odo"),
            "responsibility_level_vv": obj.get("responsibility_level_vv"),
            "responsibility_level_odo": obj.get("responsibility_level_odo"),
            "registry_updated_at": obj.get("registry_updated_at"),
            "insurances": [InsuranceUpsertRequest.from_dict(_item) for _item in obj["insurances"]] if obj.get("insurances") is not None else None,
            "checks": [CheckUpsertRequest.from_dict(_item) for _item in obj["checks"]] if obj.get("checks") is not None else None
        })
        return _obj


