# Security Policy

## Supported Versions

We take security seriously and provide security updates for the following versions:

| Version | Supported          |
| ------- | ------------------ |
| 0.1.x   | :white_check_mark: |

All releases in the 0.1.x series receive security updates. We recommend always using the latest 0.1.x version to ensure you have the most recent security patches.

## Reporting a Vulnerability

We appreciate your help in keeping Rogue secure. If you discover a security vulnerability, please follow these guidelines:

### How to Report

**Please do NOT report security vulnerabilities through public GitHub issues.**

Instead, please report security vulnerabilities by:

1. **GitHub Security Advisories (Preferred)**: Use the [GitHub Security Advisory](https://github.com/qualifire-dev/rogue/security/advisories/new) feature to privately report the vulnerability.

2. **Direct Email**: If you prefer, you can email security details directly to the maintainers. Please include:
   - A clear description of the vulnerability
   - Steps to reproduce the issue
   - Potential impact of the vulnerability
   - Any suggested fixes or mitigations (if available)

## Contact

For security-related questions that are not vulnerabilities, you can:

- Open a discussion on GitHub
- Reference this security policy in your inquiry

---

Thank you for helping keep Rogue and its users secure! 🔒

