from enum import Enum
from typing import Literal
from .cloudwatch_aws_services_map import (
    CloudWatchServiceName,
    CloudWatchAWSServicesMap,
)

CloudWatchAPIOperationName = Literal[
    "accountprovisionedreadcapacityunits",
    "accountprovisionedwritecapacityunits",
    "cachesperregion",
    "channel",
    "createlogstream",
    "deletesession",
    "describeaccesspoints",
    "describeaccountattributes",
    "describeaccountlimits",
    "describeacls",
    "describeactivereceiptruleset",
    "describeaddresses",
    "describeaddressesattribute",
    "describealarms",
    "describeapplications",
    "describeapplicationversions",
    "describeautoscalinggroups",
    "describeautoscalinginstances",
    "describebackupvault",
    "describebluegreendeployments",
    "describebyoipcidrs",
    "describecacheparametergroups",
    "describecachesubnetgroups",
    "describecapacityreservationfleets",
    "describecapacityreservations",
    "describecarriergateways",
    "describeclientvpnendpoints",
    "describeclusters",
    "describeclustersecuritygroups",
    "describeclustersnapshots",
    "describeclustersubnetgroups",
    "describecoippools",
    "describecompliancebyconfigrule",
    "describecompliancebyresource",
    "describecomputeenvironments",
    "describeconfigruleevaluationstatus",
    "describeconfigrules",
    "describeconfigurationrecorders",
    "describeconfigurationrecorderstatus",
    "describecustomkeystores",
    "describedbclusterendpoints",
    "describedbclusterparametergroups",
    "describedbclusters",
    "describedbclustersnapshots",
    "describedbinstanceautomatedbackups",
    "describedbinstances",
    "describedbsecuritygroups",
    "describedbsnapshots",
    "describedbsubnetgroups",
    "describedestinations",
    "describedhcpoptions",
    "describedirectories",
    "describedocument",
    "describedocumentpermission",
    "describeegressonlyinternetgateways",
    "describeendpointaccess",
    "describeendpointauthorization",
    "describeenvironments",
    "describeeventbus",
    "describeeventsubscriptions",
    "describefleetattributes",
    "describefleets",
    "describeflowlogs",
    "describefpgaimages",
    "describegamesessionqueues",
    "describeglobalclusters",
    "describehostreservations",
    "describeimagebuilders",
    "describeimages",
    "describeinsightrules",
    "describeinstanceconnectendpoints",
    "describeinstanceinformation",
    "describeinstances",
    "describeinstancestatus",
    "describeinstancetypes",
    "describeinternetgateways",
    "describeipampools",
    "describeipamresourcediscoveries",
    "describeipamresourcediscoveryassociations",
    "describeipams",
    "describeipamscopes",
    "describejobdefinitions",
    "describejobqueues",
    "describekey",
    "describelaunchconfigurations",
    "describelaunchtemplateversions",
    "describelimits",
    "describelocalgatewayroutetables",
    "describeloggroups",
    "describelogstreams",
    "describemaintenancewindows",
    "describematchmakingconfigurations",
    "describemetricfilters",
    "describenatgateways",
    "describenetworkinsightsaccessscopeanalyses",
    "describenetworkinsightsaccessscopes",
    "describenetworkinsightsanalyses",
    "describenetworkinsightspaths",
    "describenetworkinterfaces",
    "describeoptiongroups",
    "describeorganizationsaccess",
    "describeparametergroups",
    "describeparameters",
    "describependingaggregationrequests",
    "describependingmaintenanceactions",
    "describeplacementgroups",
    "describepullthroughcacherules",
    "describeregions",
    "describeregistry",
    "describeremediationconfigurations",
    "describereplicationgroups",
    "describereplicationinstances",
    "describereplicationsubnetgroups",
    "describerepositories",
    "describereservedcachenodes",
    "describereserveddbinstances",
    "describereservedinstances",
    "describereservedinstancesmodifications",
    "describereservednodes",
    "describeresourcepolicies",
    "describescalabletargets",
    "describescalingpolicies",
    "describesecret",
    "describesecuritygrouprules",
    "describesecuritygroups",
    "describeserverlesscaches",
    "describesnapshots",
    "describesnapshotschedules",
    "describespotfleetrequests",
    "describespotinstancerequests",
    "describesslpolicies",
    "describestacks",
    "describestandardscontrols",
    "describesubnetgroups",
    "describesubnets",
    "describesubscriptionfilters",
    "describetags",
    "describetargetgroups",
    "describetrafficmirrortargets",
    "describetrails",
    "describetransitgatewayattachments",
    "describetransitgatewayconnectpeers",
    "describetransitgatewayconnects",
    "describetransitgatewayroutetableannouncements",
    "describetransitgatewayroutetables",
    "describetransitgateways",
    "describetransitgatewayvpcattachments",
    "describeusagelimits",
    "describeusers",
    "describeverifiedaccessgroups",
    "describeverifiedaccesstrustproviders",
    "describevpcblockpublicaccessexclusions",
    "describevpcblockpublicaccessoptions",
    "describevpcendpointconnectionnotifications",
    "describevpcendpoints",
    "describevpcendpointserviceconfigurations",
    "describevpcendpointservices",
    "describevpcs",
    "describevpnconnections",
    "describevpngateways",
    "describeworkspaces",
    "exportautoscalinggrouprecommendations",
    "exportebsvolumerecommendations",
    "exportec2instancerecommendations",
    "exportecsservicerecommendations",
    "exportlambdafunctionrecommendations",
    "exportlicenserecommendations",
    "exportrdsdatabaserecommendations",
    "getaccount",
    "getaccountsetting",
    "getaccountsettings",
    "getaccountsettings20160819",
    "getaccountstatus",
    "getadministratoraccount",
    "getallowedimagessettings",
    "getapis",
    "getapps",
    "getbackupvaultaccesspolicy",
    "getblockpublicaccessconfiguration",
    "getblueprints",
    "getbucketacl",
    "getbucketcors",
    "getbucketencryption",
    "getbucketintelligenttieringconfiguration",
    "getbucketlifecycle",
    "getbucketlocation",
    "getbucketlogging",
    "getbucketmetricsconfiguration",
    "getbucketnotification",
    "getbucketobjectlockconfiguration",
    "getbucketownershipcontrols",
    "getbucketreplication",
    "getbucketrequestpayment",
    "getbuckets",
    "getbucketversioning",
    "getbucketwebsite",
    "getcertificates",
    "getcompliancedetailsbyconfigrule",
    "getcontainerservices",
    "getdatabases",
    "getdatacatalog",
    "getdeploymentstrategy",
    "getdetector",
    "getdetectors",
    "getdiscoveredresourcecounts",
    "getdomainnames",
    "getebsencryptionbydefault",
    "getenabledstandards",
    "getencryptionconfig",
    "getenrollmentstatus",
    "getentitytypes",
    "getenvironmentstatus",
    "geteventtypes",
    "getexternalmodels",
    "getfindings",
    "getfunction20150331v2",
    "getfunctionurlconfig",
    "getimageblockpublicaccessstate",
    "getinsightselectors",
    "getinstancemetadatadefaults",
    "getinvitationscount",
    "getkeypolicy",
    "getlifecyclepolicies",
    "getmaciesession",
    "getmalwarescansettings",
    "getmanagedprefixlistentries",
    "getmasteraccount",
    "getmetricdata",
    "getmetricstatistics",
    "getoutcomes",
    "getparameter",
    "getpolicy20150331",
    "getrdsdatabaserecommendations",
    "getrecommendationsummaries",
    "getregistrypolicy",
    "getregistryscanningconfiguration",
    "getrelationaldatabases",
    "getresolverrule",
    "getresourcepolicy",
    "getresources",
    "getresourceshares",
    "getsecretvalue",
    "getservicequota",
    "getservicesetting",
    "getsnapshotblockpublicaccessstate",
    "getstackpolicy",
    "getstaticips",
    "gettemplate",
    "gettemplatesummary",
    "gettopicattributes",
    "gettrailstatus",
    "getvariables",
    "getvpclinks",
    "getworkgroup",
    "keysperaccount",
    "listaccesspoints",
    "listagents",
    "listalarmmodels",
    "listaliases",
    "listanalyzers",
    "listapidestinations",
    "listapplications",
    "listarchiverules",
    "listarchives",
    "listassetmodels",
    "listassociations",
    "listattributegroups",
    "listbackupplans",
    "listbots",
    "listbridges",
    "listbuckets",
    "listcacertificates",
    "listcallanalyticsjobs",
    "listcertificateauthorities",
    "listcertificates",
    "listchangesets",
    "listchannels",
    "listclusters",
    "listcoderepositories",
    "listcodesigningconfigs",
    "listcollaborations",
    "listcomponents",
    "listconfigs",
    "listconfigurationrecorders",
    "listconfigurationsets",
    "listconnectordefinitions",
    "listcontactlists",
    "listcontainerrecipes",
    "listcontainers",
    "listcustommetrics",
    "listdatacatalogs",
    "listdatasets",
    "listdatastores",
    "listdeploymentstrategies",
    "listdetectormodels",
    "listdetectors",
    "listdevicedefinitions",
    "listdimensions",
    "listdiscoveredresources",
    "listdistributionconfigurations",
    "listdocumentclassifiers",
    "listdocuments",
    "listdomains",
    "listdominantlanguagedetectionjobs",
    "listemailidentities",
    "listemailtemplates",
    "listenabledproductsforimport",
    "listendpointconfigs",
    "listendpoints",
    "listentitiesdetectionjobs",
    "listentityrecognizers",
    "listeventbuses",
    "listeventintegrations",
    "listeventsdetectionjobs",
    "listextensionassociations",
    "listfeaturegroups",
    "listfilters",
    "listfirewalldomainlists",
    "listfirewallpolicies",
    "listfirewalls",
    "listfleetmetrics",
    "listflows",
    "listflywheels",
    "listfunctiondefinitions",
    "listfunctions20150331",
    "listfunctionurlconfigs",
    "listfuotatasks",
    "listgameservergroups",
    "listgateways",
    "listgrants",
    "listgraphs",
    "listgraphsnapshots",
    "listgroups",
    "listimagerecipes",
    "listimages",
    "listinferenceexperiments",
    "listinfrastructureconfigurations",
    "listinputs",
    "listinstances",
    "listinvitations",
    "listkeyphrasesdetectionjobs",
    "listkeyrotations",
    "listkeys",
    "listlanguagemodels",
    "listlayers20181031",
    "listledgers",
    "listlocations",
    "listloggerdefinitions",
    "listloggingconfigurations",
    "listmaps",
    "listmedicalscribejobs",
    "listmedicaltranscriptionjobs",
    "listmedicalvocabularies",
    "listmembers",
    "listmetrics",
    "listmissionprofiles",
    "listmitigationactions",
    "listmulticastgroups",
    "listmultiregionaccesspoints",
    "listnotebookinstancelifecycleconfigs",
    "listnotificationhubs",
    "listnotificationrules",
    "listorganizations",
    "listparalleldata",
    "listphonenumbersv2",
    "listpiientitiesdetectionjobs",
    "listpipelines",
    "listplaybackconfigurations",
    "listplaybackkeypairs",
    "listpolicies",
    "listportals",
    "listpreparedstatements",
    "listpresets",
    "listprofiles",
    "listprojects",
    "listpublishingdestinations",
    "listreceiptfilters",
    "listreceiptrulesets",
    "listrecipes",
    "listrecordingconfigurations",
    "listrecoverypointsbybackupvault",
    "listreportgroups",
    "listrepositories",
    "listresolverendpoints",
    "listresolverquerylogconfigs",
    "listresourcedatasync",
    "listresourcedefinitions",
    "listresourcetags",
    "listrobotapplications",
    "listrolealiases",
    "listrules",
    "listrulesets",
    "listscheduledaudits",
    "listschedulegroups",
    "listschedules",
    "listschedulingpolicies",
    "listsecrets",
    "listsecurityconfigurations",
    "listsecurityprofiles",
    "listsentimentdetectionjobs",
    "listservers",
    "listserviceprofiles",
    "listservices",
    "listsignalingchannels",
    "listsimulationapplications",
    "listsites",
    "liststackresources",
    "liststacks",
    "liststacksets",
    "liststoragelensgroups",
    "liststreams",
    "listsubscriptions",
    "listsubscriptionsbytopic",
    "listtags",
    "listtagsforresource",
    "listtargetsbyrule",
    "listtasks",
    "listtemplates",
    "listterminologies",
    "listtexttranslationjobs",
    "listthings",
    "listthreatintelsets",
    "listtopicruledestinations",
    "listtopicsdetectionjobs",
    "listtrackers",
    "listtypes",
    "listuserpools",
    "listvaults",
    "listversionsbyfunction20150331",
    "listvirtualclusters",
    "listvocabularies",
    "listworkflows",
    "listworkgroups",
    "listworkspaces",
    "listworkteams",
    "memcachednodespercluster",
    "nodesperregion",
    "numberofmessagespublishedperaccount",
    "parametergroup",
    "putevaluations",
    "putlogevents",
    "selectresourceconfig",
    "snapshotsperdaypercache",
    "stackinstanceoperations",
    "subnetspersubnetgroup",
    "user",
    "usergroup",
    "userpoolread",
    "usersperusergroup",
]

CloudWatchAPIOperationValue = Literal[
    "AccountProvisionedReadCapacityUnits",
    "AccountProvisionedWriteCapacityUnits",
    "CachesPerRegion",
    "Channel",
    "CreateLogStream",
    "DeleteSession",
    "DescribeAccessPoints",
    "DescribeAccountAttributes",
    "DescribeAccountLimits",
    "DescribeActiveReceiptRuleSet",
    "DescribeACLs",
    "DescribeAddresses",
    "DescribeAddressesAttribute",
    "DescribeAlarms",
    "DescribeApplications",
    "DescribeApplicationVersions",
    "DescribeAutoScalingGroups",
    "DescribeAutoScalingInstances",
    "DescribeBackupVault",
    "DescribeBlueGreenDeployments",
    "DescribeByoipCidrs",
    "DescribeCacheParameterGroups",
    "DescribeCacheSubnetGroups",
    "DescribeCapacityReservations",
    "DescribeCapacityReservationFleets",
    "DescribeCarrierGateways",
    "DescribeClientVpnEndpoints",
    "DescribeClusters",
    "DescribeClusterSecurityGroups",
    "DescribeClusterSnapshots",
    "DescribeClusterSubnetGroups",
    "DescribeCoipPools",
    "DescribeComplianceByConfigRule",
    "DescribeComplianceByResource",
    "DescribeComputeEnvironments",
    "DescribeConfigurationRecorders",
    "DescribeConfigurationRecorderStatus",
    "DescribeConfigRules",
    "DescribeConfigRuleEvaluationStatus",
    "DescribeCustomKeyStores",
    "DescribeDBClusters",
    "DescribeDBClusterEndpoints",
    "DescribeDBClusterParameterGroups",
    "DescribeDBClusterSnapshots",
    "DescribeDBInstances",
    "DescribeDBInstanceAutomatedBackups",
    "DescribeDBSecurityGroups",
    "DescribeDBSnapshots",
    "DescribeDBSubnetGroups",
    "DescribeDestinations",
    "DescribeDhcpOptions",
    "DescribeDirectories",
    "DescribeDocument",
    "DescribeDocumentPermission",
    "DescribeEgressOnlyInternetGateways",
    "DescribeEndpointAccess",
    "DescribeEndpointAuthorization",
    "DescribeEnvironments",
    "DescribeEventBus",
    "DescribeEventSubscriptions",
    "DescribeFleets",
    "DescribeFleetAttributes",
    "DescribeFlowLogs",
    "DescribeFpgaImages",
    "DescribeGameSessionQueues",
    "DescribeGlobalClusters",
    "DescribeHostReservations",
    "DescribeImages",
    "DescribeImageBuilders",
    "DescribeInsightRules",
    "DescribeInstances",
    "DescribeInstanceConnectEndpoints",
    "DescribeInstanceInformation",
    "DescribeInstanceStatus",
    "DescribeInstanceTypes",
    "DescribeInternetGateways",
    "DescribeIpams",
    "DescribeIpamPools",
    "DescribeIpamResourceDiscoveries",
    "DescribeIpamResourceDiscoveryAssociations",
    "DescribeIpamScopes",
    "DescribeJobDefinitions",
    "DescribeJobQueues",
    "DescribeKey",
    "DescribeLaunchConfigurations",
    "DescribeLaunchTemplateVersions",
    "DescribeLimits",
    "DescribeLocalGatewayRouteTables",
    "DescribeLogGroups",
    "DescribeLogStreams",
    "DescribeMaintenanceWindows",
    "DescribeMatchmakingConfigurations",
    "DescribeMetricFilters",
    "DescribeNatGateways",
    "DescribeNetworkInsightsAccessScopes",
    "DescribeNetworkInsightsAccessScopeAnalyses",
    "DescribeNetworkInsightsAnalyses",
    "DescribeNetworkInsightsPaths",
    "DescribeNetworkInterfaces",
    "DescribeOptionGroups",
    "DescribeOrganizationsAccess",
    "DescribeParameters",
    "DescribeParameterGroups",
    "DescribePendingAggregationRequests",
    "DescribePendingMaintenanceActions",
    "DescribePlacementGroups",
    "DescribePullThroughCacheRules",
    "DescribeRegions",
    "DescribeRegistry",
    "DescribeRemediationConfigurations",
    "DescribeReplicationGroups",
    "DescribeReplicationInstances",
    "DescribeReplicationSubnetGroups",
    "DescribeRepositories",
    "DescribeReservedCacheNodes",
    "DescribeReservedDBInstances",
    "DescribeReservedInstances",
    "DescribeReservedInstancesModifications",
    "DescribeReservedNodes",
    "DescribeResourcePolicies",
    "DescribeScalableTargets",
    "DescribeScalingPolicies",
    "DescribeSecret",
    "DescribeSecurityGroups",
    "DescribeSecurityGroupRules",
    "DescribeServerlessCaches",
    "DescribeSnapshots",
    "DescribeSnapshotSchedules",
    "DescribeSpotFleetRequests",
    "DescribeSpotInstanceRequests",
    "DescribeSSLPolicies",
    "DescribeStacks",
    "DescribeStandardsControls",
    "DescribeSubnets",
    "DescribeSubnetGroups",
    "DescribeSubscriptionFilters",
    "DescribeTags",
    "DescribeTargetGroups",
    "DescribeTrafficMirrorTargets",
    "DescribeTrails",
    "DescribeTransitGateways",
    "DescribeTransitGatewayAttachments",
    "DescribeTransitGatewayConnects",
    "DescribeTransitGatewayConnectPeers",
    "DescribeTransitGatewayRouteTables",
    "DescribeTransitGatewayRouteTableAnnouncements",
    "DescribeTransitGatewayVpcAttachments",
    "DescribeUsageLimits",
    "DescribeUsers",
    "DescribeVerifiedAccessGroups",
    "DescribeVerifiedAccessTrustProviders",
    "DescribeVpcs",
    "DescribeVpcBlockPublicAccessExclusions",
    "DescribeVpcBlockPublicAccessOptions",
    "DescribeVpcEndpoints",
    "DescribeVpcEndpointConnectionNotifications",
    "DescribeVpcEndpointServices",
    "DescribeVpcEndpointServiceConfigurations",
    "DescribeVpnConnections",
    "DescribeVpnGateways",
    "DescribeWorkspaces",
    "ExportAutoScalingGroupRecommendations",
    "ExportEBSVolumeRecommendations",
    "ExportEC2InstanceRecommendations",
    "ExportECSServiceRecommendations",
    "ExportLambdaFunctionRecommendations",
    "ExportLicenseRecommendations",
    "ExportRDSDatabaseRecommendations",
    "GetAccount",
    "GetAccountSetting",
    "GetAccountSettings20160819",
    "GetAccountSettings",
    "GetAccountStatus",
    "GetAdministratorAccount",
    "GetAllowedImagesSettings",
    "GetApis",
    "GetApps",
    "GetBackupVaultAccessPolicy",
    "GetBlockPublicAccessConfiguration",
    "GetBlueprints",
    "GetBuckets",
    "GetBucketAcl",
    "GetBucketCors",
    "GetBucketEncryption",
    "GetBucketIntelligentTieringConfiguration",
    "GetBucketLifecycle",
    "GetBucketLocation",
    "GetBucketLogging",
    "GetBucketMetricsConfiguration",
    "GetBucketNotification",
    "GetBucketObjectLockConfiguration",
    "GetBucketOwnershipControls",
    "GetBucketReplication",
    "GetBucketRequestPayment",
    "GetBucketVersioning",
    "GetBucketWebsite",
    "GetCertificates",
    "GetComplianceDetailsByConfigRule",
    "GetContainerServices",
    "GetDatabases",
    "GetDataCatalog",
    "GetDeploymentStrategy",
    "GetDetector",
    "GetDetectors",
    "GetDiscoveredResourceCounts",
    "GetDomainNames",
    "GetEbsEncryptionByDefault",
    "GetEnabledStandards",
    "GetEncryptionConfig",
    "GetEnrollmentStatus",
    "GetEntityTypes",
    "GetEnvironmentStatus",
    "GetEventTypes",
    "GetExternalModels",
    "GetFindings",
    "GetFunction20150331v2",
    "GetFunctionUrlConfig",
    "GetImageBlockPublicAccessState",
    "GetInsightSelectors",
    "GetInstanceMetadataDefaults",
    "GetInvitationsCount",
    "GetKeyPolicy",
    "GetLifecyclePolicies",
    "GetMacieSession",
    "GetMalwareScanSettings",
    "GetManagedPrefixListEntries",
    "GetMasterAccount",
    "GetMetricData",
    "GetMetricStatistics",
    "GetOutcomes",
    "GetParameter",
    "GetPolicy20150331",
    "GetRDSDatabaseRecommendations",
    "GetRecommendationSummaries",
    "GetRegistryPolicy",
    "GetRegistryScanningConfiguration",
    "GetRelationalDatabases",
    "GetResolverRule",
    "GetResources",
    "GetResourcePolicy",
    "GetResourceShares",
    "GetSecretValue",
    "GetServiceQuota",
    "GetServiceSetting",
    "GetSnapshotBlockPublicAccessState",
    "GetStackPolicy",
    "GetStaticIps",
    "GetTemplate",
    "GetTemplateSummary",
    "GetTopicAttributes",
    "GetTrailStatus",
    "GetVariables",
    "GetVpcLinks",
    "GetWorkGroup",
    "KeysPerAccount",
    "ListAccessPoints",
    "ListAgents",
    "ListAlarmModels",
    "ListAliases",
    "ListAnalyzers",
    "ListApiDestinations",
    "ListApplications",
    "ListArchives",
    "ListArchiveRules",
    "ListAssetModels",
    "ListAssociations",
    "ListAttributeGroups",
    "ListBackupPlans",
    "ListBots",
    "ListBridges",
    "ListBuckets",
    "ListCallAnalyticsJobs",
    "ListCACertificates",
    "ListCertificates",
    "ListCertificateAuthorities",
    "ListChangeSets",
    "ListChannels",
    "ListClusters",
    "ListCodeRepositories",
    "ListCodeSigningConfigs",
    "ListCollaborations",
    "ListComponents",
    "ListConfigs",
    "ListConfigurationRecorders",
    "ListConfigurationSets",
    "ListConnectorDefinitions",
    "ListContactLists",
    "ListContainers",
    "ListContainerRecipes",
    "ListCustomMetrics",
    "ListDatasets",
    "ListDatastores",
    "ListDataCatalogs",
    "ListDataSets",
    "ListDeploymentStrategies",
    "ListDetectors",
    "ListDetectorModels",
    "ListDeviceDefinitions",
    "ListDimensions",
    "ListDiscoveredResources",
    "ListDistributionConfigurations",
    "ListDocuments",
    "ListDocumentClassifiers",
    "ListDomains",
    "ListDominantLanguageDetectionJobs",
    "ListEmailIdentities",
    "ListEmailTemplates",
    "ListEnabledProductsForImport",
    "ListEndpoints",
    "ListEndpointConfigs",
    "ListEntitiesDetectionJobs",
    "ListEntityRecognizers",
    "ListEventsDetectionJobs",
    "ListEventBuses",
    "ListEventIntegrations",
    "ListExtensionAssociations",
    "ListFeatureGroups",
    "ListFilters",
    "ListFirewalls",
    "ListFirewallDomainLists",
    "ListFirewallPolicies",
    "ListFleetMetrics",
    "ListFlows",
    "ListFlywheels",
    "ListFunctions20150331",
    "ListFunctionDefinitions",
    "ListFunctionUrlConfigs",
    "ListFuotaTasks",
    "ListGameServerGroups",
    "ListGateways",
    "ListGrants",
    "ListGraphs",
    "ListGraphSnapshots",
    "ListGroups",
    "ListImages",
    "ListImageRecipes",
    "ListInferenceExperiments",
    "ListInfrastructureConfigurations",
    "ListInputs",
    "ListInstances",
    "ListInvitations",
    "ListKeys",
    "ListKeyPhrasesDetectionJobs",
    "ListKeyRotations",
    "ListLanguageModels",
    "ListLayers20181031",
    "ListLedgers",
    "ListLocations",
    "ListLoggerDefinitions",
    "ListLoggingConfigurations",
    "ListMaps",
    "ListMedicalScribeJobs",
    "ListMedicalTranscriptionJobs",
    "ListMedicalVocabularies",
    "ListMembers",
    "ListMetrics",
    "ListMissionProfiles",
    "ListMitigationActions",
    "ListMulticastGroups",
    "ListMultiRegionAccessPoints",
    "ListNotebookInstanceLifecycleConfigs",
    "ListNotificationHubs",
    "ListNotificationRules",
    "ListOrganizations",
    "ListParallelData",
    "ListPhoneNumbersV2",
    "ListPiiEntitiesDetectionJobs",
    "ListPipelines",
    "ListPlaybackConfigurations",
    "ListPlaybackKeyPairs",
    "ListPolicies",
    "ListPortals",
    "ListPreparedStatements",
    "ListPresets",
    "ListProfiles",
    "ListProjects",
    "ListPublishingDestinations",
    "ListReceiptFilters",
    "ListReceiptRuleSets",
    "ListRecipes",
    "ListRecordingConfigurations",
    "ListRecoveryPointsByBackupVault",
    "ListReportGroups",
    "ListRepositories",
    "ListResolverEndpoints",
    "ListResolverQueryLogConfigs",
    "ListResourceDataSync",
    "ListResourceDefinitions",
    "ListResourceTags",
    "ListRobotApplications",
    "ListRoleAliases",
    "ListRules",
    "ListRulesets",
    "ListScheduledAudits",
    "ListSchedules",
    "ListScheduleGroups",
    "ListSchedulingPolicies",
    "ListSecrets",
    "ListSecurityConfigurations",
    "ListSecurityProfiles",
    "ListSentimentDetectionJobs",
    "ListServers",
    "ListServices",
    "ListServiceProfiles",
    "ListSignalingChannels",
    "ListSimulationApplications",
    "ListSites",
    "ListStacks",
    "ListStackResources",
    "ListStackSets",
    "ListStorageLensGroups",
    "ListStreams",
    "ListSubscriptions",
    "ListSubscriptionsByTopic",
    "ListTags",
    "ListTagsForResource",
    "ListTargetsByRule",
    "ListTasks",
    "ListTemplates",
    "ListTerminologies",
    "ListTextTranslationJobs",
    "ListThings",
    "ListThreatIntelSets",
    "ListTopicsDetectionJobs",
    "ListTopicRuleDestinations",
    "ListTrackers",
    "ListTypes",
    "ListUserPools",
    "ListVaults",
    "ListVersionsByFunction20150331",
    "ListVirtualClusters",
    "ListVocabularies",
    "ListWorkflows",
    "ListWorkspaces",
    "ListWorkteams",
    "ListWorkGroups",
    "MemcachedNodesPerCluster",
    "NodesPerRegion",
    "NumberOfMessagesPublishedPerAccount",
    "ParameterGroup",
    "PutEvaluations",
    "PutLogEvents",
    "SelectResourceConfig",
    "SnapshotsPerDayPerCache",
    "StackInstanceOperations",
    "SubnetsPerSubnetGroup",
    "User",
    "UsersPerUserGroup",
    "UserGroup",
    "UserPoolRead"
]

class CloudWatchAPIOperation(Enum):
    ACCOUNT_PROVISIONED_READ_CAPACITY_UNITS="AccountProvisionedReadCapacityUnits"
    ACCOUNT_PROVISIONED_WRITE_CAPACITY_UNITS="AccountProvisionedWriteCapacityUnits"
    CACHES_PER_REGION="CachesPerRegion"
    CHANNEL="Channel"
    CREATE_LOG_STREAM="CreateLogStream"
    DELETE_SESSION="DeleteSession"
    DESCRIBE_ACCESS_POINTS="DescribeAccessPoints"
    DESCRIBE_ACCOUNT_ATTRIBUTES="DescribeAccountAttributes"
    DESCRIBE_ACCOUNT_LIMITS="DescribeAccountLimits"
    DESCRIBE_ACTIVE_RECEIPT_RULE_SET="DescribeActiveReceiptRuleSet"
    DESCRIBE_AC_LS="DescribeACLs"
    DESCRIBE_ADDRESSES="DescribeAddresses"
    DESCRIBE_ADDRESSES_ATTRIBUTE="DescribeAddressesAttribute"
    DESCRIBE_ALARMS="DescribeAlarms"
    DESCRIBE_APPLICATIONS="DescribeApplications"
    DESCRIBE_APPLICATION_VERSIONS="DescribeApplicationVersions"
    DESCRIBE_AUTO_SCALING_GROUPS="DescribeAutoScalingGroups"
    DESCRIBE_AUTO_SCALING_INSTANCES="DescribeAutoScalingInstances"
    DESCRIBE_BACKUP_VAULT="DescribeBackupVault"
    DESCRIBE_BLUE_GREEN_DEPLOYMENTS="DescribeBlueGreenDeployments"
    DESCRIBE_BYOIP_CIDRS="DescribeByoipCidrs"
    DESCRIBE_CACHE_PARAMETER_GROUPS="DescribeCacheParameterGroups"
    DESCRIBE_CACHE_SUBNET_GROUPS="DescribeCacheSubnetGroups"
    DESCRIBE_CAPACITY_RESERVATIONS="DescribeCapacityReservations"
    DESCRIBE_CAPACITY_RESERVATION_FLEETS="DescribeCapacityReservationFleets"
    DESCRIBE_CARRIER_GATEWAYS="DescribeCarrierGateways"
    DESCRIBE_CLIENT_VPN_ENDPOINTS="DescribeClientVpnEndpoints"
    DESCRIBE_CLUSTERS="DescribeClusters"
    DESCRIBE_CLUSTER_SECURITY_GROUPS="DescribeClusterSecurityGroups"
    DESCRIBE_CLUSTER_SNAPSHOTS="DescribeClusterSnapshots"
    DESCRIBE_CLUSTER_SUBNET_GROUPS="DescribeClusterSubnetGroups"
    DESCRIBE_COIP_POOLS="DescribeCoipPools"
    DESCRIBE_COMPLIANCE_BY_CONFIG_RULE="DescribeComplianceByConfigRule"
    DESCRIBE_COMPLIANCE_BY_RESOURCE="DescribeComplianceByResource"
    DESCRIBE_COMPUTE_ENVIRONMENTS="DescribeComputeEnvironments"
    DESCRIBE_CONFIGURATION_RECORDERS="DescribeConfigurationRecorders"
    DESCRIBE_CONFIGURATION_RECORDER_STATUS="DescribeConfigurationRecorderStatus"
    DESCRIBE_CONFIG_RULES="DescribeConfigRules"
    DESCRIBE_CONFIG_RULE_EVALUATION_STATUS="DescribeConfigRuleEvaluationStatus"
    DESCRIBE_CUSTOM_KEY_STORES="DescribeCustomKeyStores"
    DESCRIBE_DB_CLUSTERS="DescribeDBClusters"
    DESCRIBE_DB_CLUSTER_ENDPOINTS="DescribeDBClusterEndpoints"
    DESCRIBE_DB_CLUSTER_PARAMETER_GROUPS="DescribeDBClusterParameterGroups"
    DESCRIBE_DB_CLUSTER_SNAPSHOTS="DescribeDBClusterSnapshots"
    DESCRIBE_DB_INSTANCES="DescribeDBInstances"
    DESCRIBE_DB_INSTANCE_AUTOMATED_BACKUPS="DescribeDBInstanceAutomatedBackups"
    DESCRIBE_DB_SECURITY_GROUPS="DescribeDBSecurityGroups"
    DESCRIBE_DB_SNAPSHOTS="DescribeDBSnapshots"
    DESCRIBE_DB_SUBNET_GROUPS="DescribeDBSubnetGroups"
    DESCRIBE_DESTINATIONS="DescribeDestinations"
    DESCRIBE_DHCP_OPTIONS="DescribeDhcpOptions"
    DESCRIBE_DIRECTORIES="DescribeDirectories"
    DESCRIBE_DOCUMENT="DescribeDocument"
    DESCRIBE_DOCUMENT_PERMISSION="DescribeDocumentPermission"
    DESCRIBE_EGRESS_ONLY_INTERNET_GATEWAYS="DescribeEgressOnlyInternetGateways"
    DESCRIBE_ENDPOINT_ACCESS="DescribeEndpointAccess"
    DESCRIBE_ENDPOINT_AUTHORIZATION="DescribeEndpointAuthorization"
    DESCRIBE_ENVIRONMENTS="DescribeEnvironments"
    DESCRIBE_EVENT_BUS="DescribeEventBus"
    DESCRIBE_EVENT_SUBSCRIPTIONS="DescribeEventSubscriptions"
    DESCRIBE_FLEETS="DescribeFleets"
    DESCRIBE_FLEET_ATTRIBUTES="DescribeFleetAttributes"
    DESCRIBE_FLOW_LOGS="DescribeFlowLogs"
    DESCRIBE_FPGA_IMAGES="DescribeFpgaImages"
    DESCRIBE_GAME_SESSION_QUEUES="DescribeGameSessionQueues"
    DESCRIBE_GLOBAL_CLUSTERS="DescribeGlobalClusters"
    DESCRIBE_HOST_RESERVATIONS="DescribeHostReservations"
    DESCRIBE_IMAGES="DescribeImages"
    DESCRIBE_IMAGE_BUILDERS="DescribeImageBuilders"
    DESCRIBE_INSIGHT_RULES="DescribeInsightRules"
    DESCRIBE_INSTANCES="DescribeInstances"
    DESCRIBE_INSTANCE_CONNECT_ENDPOINTS="DescribeInstanceConnectEndpoints"
    DESCRIBE_INSTANCE_INFORMATION="DescribeInstanceInformation"
    DESCRIBE_INSTANCE_STATUS="DescribeInstanceStatus"
    DESCRIBE_INSTANCE_TYPES="DescribeInstanceTypes"
    DESCRIBE_INTERNET_GATEWAYS="DescribeInternetGateways"
    DESCRIBE_IPAMS="DescribeIpams"
    DESCRIBE_IPAM_POOLS="DescribeIpamPools"
    DESCRIBE_IPAM_RESOURCE_DISCOVERIES="DescribeIpamResourceDiscoveries"
    DESCRIBE_IPAM_RESOURCE_DISCOVERY_ASSOCIATIONS="DescribeIpamResourceDiscoveryAssociations"
    DESCRIBE_IPAM_SCOPES="DescribeIpamScopes"
    DESCRIBE_JOB_DEFINITIONS="DescribeJobDefinitions"
    DESCRIBE_JOB_QUEUES="DescribeJobQueues"
    DESCRIBE_KEY="DescribeKey"
    DESCRIBE_LAUNCH_CONFIGURATIONS="DescribeLaunchConfigurations"
    DESCRIBE_LAUNCH_TEMPLATE_VERSIONS="DescribeLaunchTemplateVersions"
    DESCRIBE_LIMITS="DescribeLimits"
    DESCRIBE_LOCAL_GATEWAY_ROUTE_TABLES="DescribeLocalGatewayRouteTables"
    DESCRIBE_LOG_GROUPS="DescribeLogGroups"
    DESCRIBE_LOG_STREAMS="DescribeLogStreams"
    DESCRIBE_MAINTENANCE_WINDOWS="DescribeMaintenanceWindows"
    DESCRIBE_MATCHMAKING_CONFIGURATIONS="DescribeMatchmakingConfigurations"
    DESCRIBE_METRIC_FILTERS="DescribeMetricFilters"
    DESCRIBE_NAT_GATEWAYS="DescribeNatGateways"
    DESCRIBE_NETWORK_INSIGHTS_ACCESS_SCOPES="DescribeNetworkInsightsAccessScopes"
    DESCRIBE_NETWORK_INSIGHTS_ACCESS_SCOPE_ANALYSES="DescribeNetworkInsightsAccessScopeAnalyses"
    DESCRIBE_NETWORK_INSIGHTS_ANALYSES="DescribeNetworkInsightsAnalyses"
    DESCRIBE_NETWORK_INSIGHTS_PATHS="DescribeNetworkInsightsPaths"
    DESCRIBE_NETWORK_INTERFACES="DescribeNetworkInterfaces"
    DESCRIBE_OPTION_GROUPS="DescribeOptionGroups"
    DESCRIBE_ORGANIZATIONS_ACCESS="DescribeOrganizationsAccess"
    DESCRIBE_PARAMETERS="DescribeParameters"
    DESCRIBE_PARAMETER_GROUPS="DescribeParameterGroups"
    DESCRIBE_PENDING_AGGREGATION_REQUESTS="DescribePendingAggregationRequests"
    DESCRIBE_PENDING_MAINTENANCE_ACTIONS="DescribePendingMaintenanceActions"
    DESCRIBE_PLACEMENT_GROUPS="DescribePlacementGroups"
    DESCRIBE_PULL_THROUGH_CACHE_RULES="DescribePullThroughCacheRules"
    DESCRIBE_REGIONS="DescribeRegions"
    DESCRIBE_REGISTRY="DescribeRegistry"
    DESCRIBE_REMEDIATION_CONFIGURATIONS="DescribeRemediationConfigurations"
    DESCRIBE_REPLICATION_GROUPS="DescribeReplicationGroups"
    DESCRIBE_REPLICATION_INSTANCES="DescribeReplicationInstances"
    DESCRIBE_REPLICATION_SUBNET_GROUPS="DescribeReplicationSubnetGroups"
    DESCRIBE_REPOSITORIES="DescribeRepositories"
    DESCRIBE_RESERVED_CACHE_NODES="DescribeReservedCacheNodes"
    DESCRIBE_RESERVED_DB_INSTANCES="DescribeReservedDBInstances"
    DESCRIBE_RESERVED_INSTANCES="DescribeReservedInstances"
    DESCRIBE_RESERVED_INSTANCES_MODIFICATIONS="DescribeReservedInstancesModifications"
    DESCRIBE_RESERVED_NODES="DescribeReservedNodes"
    DESCRIBE_RESOURCE_POLICIES="DescribeResourcePolicies"
    DESCRIBE_SCALABLE_TARGETS="DescribeScalableTargets"
    DESCRIBE_SCALING_POLICIES="DescribeScalingPolicies"
    DESCRIBE_SECRET="DescribeSecret"
    DESCRIBE_SECURITY_GROUPS="DescribeSecurityGroups"
    DESCRIBE_SECURITY_GROUP_RULES="DescribeSecurityGroupRules"
    DESCRIBE_SERVERLESS_CACHES="DescribeServerlessCaches"
    DESCRIBE_SNAPSHOTS="DescribeSnapshots"
    DESCRIBE_SNAPSHOT_SCHEDULES="DescribeSnapshotSchedules"
    DESCRIBE_SPOT_FLEET_REQUESTS="DescribeSpotFleetRequests"
    DESCRIBE_SPOT_INSTANCE_REQUESTS="DescribeSpotInstanceRequests"
    DESCRIBE_SSL_POLICIES="DescribeSSLPolicies"
    DESCRIBE_STACKS="DescribeStacks"
    DESCRIBE_STANDARDS_CONTROLS="DescribeStandardsControls"
    DESCRIBE_SUBNETS="DescribeSubnets"
    DESCRIBE_SUBNET_GROUPS="DescribeSubnetGroups"
    DESCRIBE_SUBSCRIPTION_FILTERS="DescribeSubscriptionFilters"
    DESCRIBE_TAGS="DescribeTags"
    DESCRIBE_TARGET_GROUPS="DescribeTargetGroups"
    DESCRIBE_TRAFFIC_MIRROR_TARGETS="DescribeTrafficMirrorTargets"
    DESCRIBE_TRAILS="DescribeTrails"
    DESCRIBE_TRANSIT_GATEWAYS="DescribeTransitGateways"
    DESCRIBE_TRANSIT_GATEWAY_ATTACHMENTS="DescribeTransitGatewayAttachments"
    DESCRIBE_TRANSIT_GATEWAY_CONNECTS="DescribeTransitGatewayConnects"
    DESCRIBE_TRANSIT_GATEWAY_CONNECT_PEERS="DescribeTransitGatewayConnectPeers"
    DESCRIBE_TRANSIT_GATEWAY_ROUTE_TABLES="DescribeTransitGatewayRouteTables"
    DESCRIBE_TRANSIT_GATEWAY_ROUTE_TABLE_ANNOUNCEMENTS="DescribeTransitGatewayRouteTableAnnouncements"
    DESCRIBE_TRANSIT_GATEWAY_VPC_ATTACHMENTS="DescribeTransitGatewayVpcAttachments"
    DESCRIBE_USAGE_LIMITS="DescribeUsageLimits"
    DESCRIBE_USERS="DescribeUsers"
    DESCRIBE_VERIFIED_ACCESS_GROUPS="DescribeVerifiedAccessGroups"
    DESCRIBE_VERIFIED_ACCESS_TRUST_PROVIDERS="DescribeVerifiedAccessTrustProviders"
    DESCRIBE_VPCS="DescribeVpcs"
    DESCRIBE_VPC_BLOCK_PUBLIC_ACCESS_EXCLUSIONS="DescribeVpcBlockPublicAccessExclusions"
    DESCRIBE_VPC_BLOCK_PUBLIC_ACCESS_OPTIONS="DescribeVpcBlockPublicAccessOptions"
    DESCRIBE_VPC_ENDPOINTS="DescribeVpcEndpoints"
    DESCRIBE_VPC_ENDPOINT_CONNECTION_NOTIFICATIONS="DescribeVpcEndpointConnectionNotifications"
    DESCRIBE_VPC_ENDPOINT_SERVICES="DescribeVpcEndpointServices"
    DESCRIBE_VPC_ENDPOINT_SERVICE_CONFIGURATIONS="DescribeVpcEndpointServiceConfigurations"
    DESCRIBE_VPN_CONNECTIONS="DescribeVpnConnections"
    DESCRIBE_VPN_GATEWAYS="DescribeVpnGateways"
    DESCRIBE_WORKSPACES="DescribeWorkspaces"
    EXPORT_AUTO_SCALING_GROUP_RECOMMENDATIONS="ExportAutoScalingGroupRecommendations"
    EXPORT_EBS_VOLUME_RECOMMENDATIONS="ExportEBSVolumeRecommendations"
    EXPORT_EC2_INSTANCE_RECOMMENDATIONS="ExportEC2InstanceRecommendations"
    EXPORT_ECS_SERVICE_RECOMMENDATIONS="ExportECSServiceRecommendations"
    EXPORT_LAMBDA_FUNCTION_RECOMMENDATIONS="ExportLambdaFunctionRecommendations"
    EXPORT_LICENSE_RECOMMENDATIONS="ExportLicenseRecommendations"
    EXPORT_RDS_DATABASE_RECOMMENDATIONS="ExportRDSDatabaseRecommendations"
    GET_ACCOUNT="GetAccount"
    GET_ACCOUNT_SETTING="GetAccountSetting"
    GET_ACCOUNT_SETTINGS20160819="GetAccountSettings20160819"
    GET_ACCOUNT_SETTINGS="GetAccountSettings"
    GET_ACCOUNT_STATUS="GetAccountStatus"
    GET_ADMINISTRATOR_ACCOUNT="GetAdministratorAccount"
    GET_ALLOWED_IMAGES_SETTINGS="GetAllowedImagesSettings"
    GET_APIS="GetApis"
    GET_APPS="GetApps"
    GET_BACKUP_VAULT_ACCESS_POLICY="GetBackupVaultAccessPolicy"
    GET_BLOCK_PUBLIC_ACCESS_CONFIGURATION="GetBlockPublicAccessConfiguration"
    GET_BLUEPRINTS="GetBlueprints"
    GET_BUCKETS="GetBuckets"
    GET_BUCKET_ACL="GetBucketAcl"
    GET_BUCKET_CORS="GetBucketCors"
    GET_BUCKET_ENCRYPTION="GetBucketEncryption"
    GET_BUCKET_INTELLIGENT_TIERING_CONFIGURATION="GetBucketIntelligentTieringConfiguration"
    GET_BUCKET_LIFECYCLE="GetBucketLifecycle"
    GET_BUCKET_LOCATION="GetBucketLocation"
    GET_BUCKET_LOGGING="GetBucketLogging"
    GET_BUCKET_METRICS_CONFIGURATION="GetBucketMetricsConfiguration"
    GET_BUCKET_NOTIFICATION="GetBucketNotification"
    GET_BUCKET_OBJECT_LOCK_CONFIGURATION="GetBucketObjectLockConfiguration"
    GET_BUCKET_OWNERSHIP_CONTROLS="GetBucketOwnershipControls"
    GET_BUCKET_REPLICATION="GetBucketReplication"
    GET_BUCKET_REQUEST_PAYMENT="GetBucketRequestPayment"
    GET_BUCKET_VERSIONING="GetBucketVersioning"
    GET_BUCKET_WEBSITE="GetBucketWebsite"
    GET_CERTIFICATES="GetCertificates"
    GET_COMPLIANCE_DETAILS_BY_CONFIG_RULE="GetComplianceDetailsByConfigRule"
    GET_CONTAINER_SERVICES="GetContainerServices"
    GET_DATABASES="GetDatabases"
    GET_DATA_CATALOG="GetDataCatalog"
    GET_DEPLOYMENT_STRATEGY="GetDeploymentStrategy"
    GET_DETECTOR="GetDetector"
    GET_DETECTORS="GetDetectors"
    GET_DISCOVERED_RESOURCE_COUNTS="GetDiscoveredResourceCounts"
    GET_DOMAIN_NAMES="GetDomainNames"
    GET_EBS_ENCRYPTION_BY_DEFAULT="GetEbsEncryptionByDefault"
    GET_ENABLED_STANDARDS="GetEnabledStandards"
    GET_ENCRYPTION_CONFIG="GetEncryptionConfig"
    GET_ENROLLMENT_STATUS="GetEnrollmentStatus"
    GET_ENTITY_TYPES="GetEntityTypes"
    GET_ENVIRONMENT_STATUS="GetEnvironmentStatus"
    GET_EVENT_TYPES="GetEventTypes"
    GET_EXTERNAL_MODELS="GetExternalModels"
    GET_FINDINGS="GetFindings"
    GET_FUNCTION20150331V2="GetFunction20150331v2"
    GET_FUNCTION_URL_CONFIG="GetFunctionUrlConfig"
    GET_IMAGE_BLOCK_PUBLIC_ACCESS_STATE="GetImageBlockPublicAccessState"
    GET_INSIGHT_SELECTORS="GetInsightSelectors"
    GET_INSTANCE_METADATA_DEFAULTS="GetInstanceMetadataDefaults"
    GET_INVITATIONS_COUNT="GetInvitationsCount"
    GET_KEY_POLICY="GetKeyPolicy"
    GET_LIFECYCLE_POLICIES="GetLifecyclePolicies"
    GET_MACIE_SESSION="GetMacieSession"
    GET_MALWARE_SCAN_SETTINGS="GetMalwareScanSettings"
    GET_MANAGED_PREFIX_LIST_ENTRIES="GetManagedPrefixListEntries"
    GET_MASTER_ACCOUNT="GetMasterAccount"
    GET_METRIC_DATA="GetMetricData"
    GET_METRIC_STATISTICS="GetMetricStatistics"
    GET_OUTCOMES="GetOutcomes"
    GET_PARAMETER="GetParameter"
    GET_POLICY20150331="GetPolicy20150331"
    GET_RDS_DATABASE_RECOMMENDATIONS="GetRDSDatabaseRecommendations"
    GET_RECOMMENDATION_SUMMARIES="GetRecommendationSummaries"
    GET_REGISTRY_POLICY="GetRegistryPolicy"
    GET_REGISTRY_SCANNING_CONFIGURATION="GetRegistryScanningConfiguration"
    GET_RELATIONAL_DATABASES="GetRelationalDatabases"
    GET_RESOLVER_RULE="GetResolverRule"
    GET_RESOURCES="GetResources"
    GET_RESOURCE_POLICY="GetResourcePolicy"
    GET_RESOURCE_SHARES="GetResourceShares"
    GET_SECRET_VALUE="GetSecretValue"
    GET_SERVICE_QUOTA="GetServiceQuota"
    GET_SERVICE_SETTING="GetServiceSetting"
    GET_SNAPSHOT_BLOCK_PUBLIC_ACCESS_STATE="GetSnapshotBlockPublicAccessState"
    GET_STACK_POLICY="GetStackPolicy"
    GET_STATIC_IPS="GetStaticIps"
    GET_TEMPLATE="GetTemplate"
    GET_TEMPLATE_SUMMARY="GetTemplateSummary"
    GET_TOPIC_ATTRIBUTES="GetTopicAttributes"
    GET_TRAIL_STATUS="GetTrailStatus"
    GET_VARIABLES="GetVariables"
    GET_VPC_LINKS="GetVpcLinks"
    GET_WORK_GROUP="GetWorkGroup"
    KEYS_PER_ACCOUNT="KeysPerAccount"
    LIST_ACCESS_POINTS="ListAccessPoints"
    LIST_AGENTS="ListAgents"
    LIST_ALARM_MODELS="ListAlarmModels"
    LIST_ALIASES="ListAliases"
    LIST_ANALYZERS="ListAnalyzers"
    LIST_API_DESTINATIONS="ListApiDestinations"
    LIST_APPLICATIONS="ListApplications"
    LIST_ARCHIVES="ListArchives"
    LIST_ARCHIVE_RULES="ListArchiveRules"
    LIST_ASSET_MODELS="ListAssetModels"
    LIST_ASSOCIATIONS="ListAssociations"
    LIST_ATTRIBUTE_GROUPS="ListAttributeGroups"
    LIST_BACKUP_PLANS="ListBackupPlans"
    LIST_BOTS="ListBots"
    LIST_BRIDGES="ListBridges"
    LIST_BUCKETS="ListBuckets"
    LIST_CALL_ANALYTICS_JOBS="ListCallAnalyticsJobs"
    LIST_CA_CERTIFICATES="ListCACertificates"
    LIST_CERTIFICATES="ListCertificates"
    LIST_CERTIFICATE_AUTHORITIES="ListCertificateAuthorities"
    LIST_CHANGE_SETS="ListChangeSets"
    LIST_CHANNELS="ListChannels"
    LIST_CLUSTERS="ListClusters"
    LIST_CODE_REPOSITORIES="ListCodeRepositories"
    LIST_CODE_SIGNING_CONFIGS="ListCodeSigningConfigs"
    LIST_COLLABORATIONS="ListCollaborations"
    LIST_COMPONENTS="ListComponents"
    LIST_CONFIGS="ListConfigs"
    LIST_CONFIGURATION_RECORDERS="ListConfigurationRecorders"
    LIST_CONFIGURATION_SETS="ListConfigurationSets"
    LIST_CONNECTOR_DEFINITIONS="ListConnectorDefinitions"
    LIST_CONTACT_LISTS="ListContactLists"
    LIST_CONTAINERS="ListContainers"
    LIST_CONTAINER_RECIPES="ListContainerRecipes"
    LIST_CUSTOM_METRICS="ListCustomMetrics"
    LIST_DATASETS="ListDatasets"
    LIST_DATASTORES="ListDatastores"
    LIST_DATA_CATALOGS="ListDataCatalogs"
    LIST_DATA_SETS="ListDataSets"
    LIST_DEPLOYMENT_STRATEGIES="ListDeploymentStrategies"
    LIST_DETECTORS="ListDetectors"
    LIST_DETECTOR_MODELS="ListDetectorModels"
    LIST_DEVICE_DEFINITIONS="ListDeviceDefinitions"
    LIST_DIMENSIONS="ListDimensions"
    LIST_DISCOVERED_RESOURCES="ListDiscoveredResources"
    LIST_DISTRIBUTION_CONFIGURATIONS="ListDistributionConfigurations"
    LIST_DOCUMENTS="ListDocuments"
    LIST_DOCUMENT_CLASSIFIERS="ListDocumentClassifiers"
    LIST_DOMAINS="ListDomains"
    LIST_DOMINANT_LANGUAGE_DETECTION_JOBS="ListDominantLanguageDetectionJobs"
    LIST_EMAIL_IDENTITIES="ListEmailIdentities"
    LIST_EMAIL_TEMPLATES="ListEmailTemplates"
    LIST_ENABLED_PRODUCTS_FOR_IMPORT="ListEnabledProductsForImport"
    LIST_ENDPOINTS="ListEndpoints"
    LIST_ENDPOINT_CONFIGS="ListEndpointConfigs"
    LIST_ENTITIES_DETECTION_JOBS="ListEntitiesDetectionJobs"
    LIST_ENTITY_RECOGNIZERS="ListEntityRecognizers"
    LIST_EVENTS_DETECTION_JOBS="ListEventsDetectionJobs"
    LIST_EVENT_BUSES="ListEventBuses"
    LIST_EVENT_INTEGRATIONS="ListEventIntegrations"
    LIST_EXTENSION_ASSOCIATIONS="ListExtensionAssociations"
    LIST_FEATURE_GROUPS="ListFeatureGroups"
    LIST_FILTERS="ListFilters"
    LIST_FIREWALLS="ListFirewalls"
    LIST_FIREWALL_DOMAIN_LISTS="ListFirewallDomainLists"
    LIST_FIREWALL_POLICIES="ListFirewallPolicies"
    LIST_FLEET_METRICS="ListFleetMetrics"
    LIST_FLOWS="ListFlows"
    LIST_FLYWHEELS="ListFlywheels"
    LIST_FUNCTIONS20150331="ListFunctions20150331"
    LIST_FUNCTION_DEFINITIONS="ListFunctionDefinitions"
    LIST_FUNCTION_URL_CONFIGS="ListFunctionUrlConfigs"
    LIST_FUOTA_TASKS="ListFuotaTasks"
    LIST_GAME_SERVER_GROUPS="ListGameServerGroups"
    LIST_GATEWAYS="ListGateways"
    LIST_GRANTS="ListGrants"
    LIST_GRAPHS="ListGraphs"
    LIST_GRAPH_SNAPSHOTS="ListGraphSnapshots"
    LIST_GROUPS="ListGroups"
    LIST_IMAGES="ListImages"
    LIST_IMAGE_RECIPES="ListImageRecipes"
    LIST_INFERENCE_EXPERIMENTS="ListInferenceExperiments"
    LIST_INFRASTRUCTURE_CONFIGURATIONS="ListInfrastructureConfigurations"
    LIST_INPUTS="ListInputs"
    LIST_INSTANCES="ListInstances"
    LIST_INVITATIONS="ListInvitations"
    LIST_KEYS="ListKeys"
    LIST_KEY_PHRASES_DETECTION_JOBS="ListKeyPhrasesDetectionJobs"
    LIST_KEY_ROTATIONS="ListKeyRotations"
    LIST_LANGUAGE_MODELS="ListLanguageModels"
    LIST_LAYERS20181031="ListLayers20181031"
    LIST_LEDGERS="ListLedgers"
    LIST_LOCATIONS="ListLocations"
    LIST_LOGGER_DEFINITIONS="ListLoggerDefinitions"
    LIST_LOGGING_CONFIGURATIONS="ListLoggingConfigurations"
    LIST_MAPS="ListMaps"
    LIST_MEDICAL_SCRIBE_JOBS="ListMedicalScribeJobs"
    LIST_MEDICAL_TRANSCRIPTION_JOBS="ListMedicalTranscriptionJobs"
    LIST_MEDICAL_VOCABULARIES="ListMedicalVocabularies"
    LIST_MEMBERS="ListMembers"
    LIST_METRICS="ListMetrics"
    LIST_MISSION_PROFILES="ListMissionProfiles"
    LIST_MITIGATION_ACTIONS="ListMitigationActions"
    LIST_MULTICAST_GROUPS="ListMulticastGroups"
    LIST_MULTI_REGION_ACCESS_POINTS="ListMultiRegionAccessPoints"
    LIST_NOTEBOOK_INSTANCE_LIFECYCLE_CONFIGS="ListNotebookInstanceLifecycleConfigs"
    LIST_NOTIFICATION_HUBS="ListNotificationHubs"
    LIST_NOTIFICATION_RULES="ListNotificationRules"
    LIST_ORGANIZATIONS="ListOrganizations"
    LIST_PARALLEL_DATA="ListParallelData"
    LIST_PHONE_NUMBERS_V2="ListPhoneNumbersV2"
    LIST_PII_ENTITIES_DETECTION_JOBS="ListPiiEntitiesDetectionJobs"
    LIST_PIPELINES="ListPipelines"
    LIST_PLAYBACK_CONFIGURATIONS="ListPlaybackConfigurations"
    LIST_PLAYBACK_KEY_PAIRS="ListPlaybackKeyPairs"
    LIST_POLICIES="ListPolicies"
    LIST_PORTALS="ListPortals"
    LIST_PREPARED_STATEMENTS="ListPreparedStatements"
    LIST_PRESETS="ListPresets"
    LIST_PROFILES="ListProfiles"
    LIST_PROJECTS="ListProjects"
    LIST_PUBLISHING_DESTINATIONS="ListPublishingDestinations"
    LIST_RECEIPT_FILTERS="ListReceiptFilters"
    LIST_RECEIPT_RULE_SETS="ListReceiptRuleSets"
    LIST_RECIPES="ListRecipes"
    LIST_RECORDING_CONFIGURATIONS="ListRecordingConfigurations"
    LIST_RECOVERY_POINTS_BY_BACKUP_VAULT="ListRecoveryPointsByBackupVault"
    LIST_REPORT_GROUPS="ListReportGroups"
    LIST_REPOSITORIES="ListRepositories"
    LIST_RESOLVER_ENDPOINTS="ListResolverEndpoints"
    LIST_RESOLVER_QUERY_LOG_CONFIGS="ListResolverQueryLogConfigs"
    LIST_RESOURCE_DATA_SYNC="ListResourceDataSync"
    LIST_RESOURCE_DEFINITIONS="ListResourceDefinitions"
    LIST_RESOURCE_TAGS="ListResourceTags"
    LIST_ROBOT_APPLICATIONS="ListRobotApplications"
    LIST_ROLE_ALIASES="ListRoleAliases"
    LIST_RULES="ListRules"
    LIST_RULESETS="ListRulesets"
    LIST_SCHEDULED_AUDITS="ListScheduledAudits"
    LIST_SCHEDULES="ListSchedules"
    LIST_SCHEDULE_GROUPS="ListScheduleGroups"
    LIST_SCHEDULING_POLICIES="ListSchedulingPolicies"
    LIST_SECRETS="ListSecrets"
    LIST_SECURITY_CONFIGURATIONS="ListSecurityConfigurations"
    LIST_SECURITY_PROFILES="ListSecurityProfiles"
    LIST_SENTIMENT_DETECTION_JOBS="ListSentimentDetectionJobs"
    LIST_SERVERS="ListServers"
    LIST_SERVICES="ListServices"
    LIST_SERVICE_PROFILES="ListServiceProfiles"
    LIST_SIGNALING_CHANNELS="ListSignalingChannels"
    LIST_SIMULATION_APPLICATIONS="ListSimulationApplications"
    LIST_SITES="ListSites"
    LIST_STACKS="ListStacks"
    LIST_STACK_RESOURCES="ListStackResources"
    LIST_STACK_SETS="ListStackSets"
    LIST_STORAGE_LENS_GROUPS="ListStorageLensGroups"
    LIST_STREAMS="ListStreams"
    LIST_SUBSCRIPTIONS="ListSubscriptions"
    LIST_SUBSCRIPTIONS_BY_TOPIC="ListSubscriptionsByTopic"
    LIST_TAGS="ListTags"
    LIST_TAGS_FOR_RESOURCE="ListTagsForResource"
    LIST_TARGETS_BY_RULE="ListTargetsByRule"
    LIST_TASKS="ListTasks"
    LIST_TEMPLATES="ListTemplates"
    LIST_TERMINOLOGIES="ListTerminologies"
    LIST_TEXT_TRANSLATION_JOBS="ListTextTranslationJobs"
    LIST_THINGS="ListThings"
    LIST_THREAT_INTEL_SETS="ListThreatIntelSets"
    LIST_TOPICS_DETECTION_JOBS="ListTopicsDetectionJobs"
    LIST_TOPIC_RULE_DESTINATIONS="ListTopicRuleDestinations"
    LIST_TRACKERS="ListTrackers"
    LIST_TYPES="ListTypes"
    LIST_USER_POOLS="ListUserPools"
    LIST_VAULTS="ListVaults"
    LIST_VERSIONS_BY_FUNCTION20150331="ListVersionsByFunction20150331"
    LIST_VIRTUAL_CLUSTERS="ListVirtualClusters"
    LIST_VOCABULARIES="ListVocabularies"
    LIST_WORKFLOWS="ListWorkflows"
    LIST_WORKSPACES="ListWorkspaces"
    LIST_WORKTEAMS="ListWorkteams"
    LIST_WORK_GROUPS="ListWorkGroups"
    MEMCACHED_NODES_PER_CLUSTER="MemcachedNodesPerCluster"
    NODES_PER_REGION="NodesPerRegion"
    NUMBER_OF_MESSAGES_PUBLISHED_PER_ACCOUNT="NumberOfMessagesPublishedPerAccount"
    PARAMETER_GROUP="ParameterGroup"
    PUT_EVALUATIONS="PutEvaluations"
    PUT_LOG_EVENTS="PutLogEvents"
    SELECT_RESOURCE_CONFIG="SelectResourceConfig"
    SNAPSHOTS_PER_DAY_PER_CACHE="SnapshotsPerDayPerCache"
    STACK_INSTANCE_OPERATIONS="StackInstanceOperations"
    SUBNETS_PER_SUBNET_GROUP="SubnetsPerSubnetGroup"
    USER="User"
    USERS_PER_USER_GROUP="UsersPerUserGroup"
    USER_GROUP="UserGroup"
    USER_POOL_READ="UserPoolRead"



class CloudServiceAPIOpsMap:

    def __init__(self):

        self._api_ops_slug_map: dict[
            CloudWatchAPIOperationName,
            CloudWatchAPIOperation
        ] = {
            service.name.lower().replace(
                '_',
                '-'
            ): service for service in CloudWatchAPIOperation
        }

        self._api_ops_map: dict[
            CloudWatchAPIOperationName,
            CloudWatchAPIOperation
        ] = {
            service.name.lower().replace(
                '_',
                ''
            ): service for service in CloudWatchAPIOperation
        }

        self._api_ops_reverse_map: dict[
            CloudWatchAPIOperationValue,
            CloudWatchAPIOperationName,
        ] = {
            operation.value: name for name, operation in self._api_ops_map.items()
        }

        self._service_api_ops_map = {
            "DYNAMODB": [
                "accountprovisionedreadcapacityunits",
                "accountprovisionedwritecapacityunits"
            ],
            "ELASTICACHE": [
                "describecacheparametergroups",
                "nodesperregion",
                "describesnapshots",
                "describeserverlesscaches",
                "snapshotsperdaypercache",
                "cachesperregion",
                "describereplicationgroups",
                "parametergroup",
                "subnetspersubnetgroup",
                "describereservedcachenodes",
                "describeusers",
                "user",
                "usergroup",
                "usersperusergroup",
                "memcachednodespercluster",
                "describecachesubnetgroups"
            ],
            "CLOUDTRAIL": [
                "describetrails",
                "gettrailstatus",
                "getinsightselectors",
                "listchannels",
                "channel"
            ],
            "LOGS": [
                "describesubscriptionfilters",
                "describelogstreams",
                "describemetricfilters",
                "describeresourcepolicies",
                "createlogstream",
                "putlogevents",
                "describeloggroups",
                "describedestinations"
            ],
            "CLOUDSHELL": [
                "getenvironmentstatus",
                "deletesession"
            ],
            "EFS": [
                "describeaccesspoints"
            ],
            "EC2": [
                "describenetworkinsightsaccessscopes",
                "describetransitgatewayconnects",
                "describetransitgatewayroutetables",
                "describevpngateways",
                "getmanagedprefixlistentries",
                "describebyoipcidrs",
                "describeegressonlyinternetgateways",
                "describeaccountattributes",
                "describeflowlogs",
                "describeclientvpnendpoints",
                "describereservedinstancesmodifications",
                "describeipams",
                "describeipamresourcediscoveryassociations",
                "getsnapshotblockpublicaccessstate",
                "describefleets",
                "describetransitgateways",
                "describedhcpoptions",
                "describevpcendpointservices",
                "describeimages",
                "describecarriergateways",
                "describeinstanceconnectendpoints",
                "describespotinstancerequests",
                "describesnapshots",
                "describeverifiedaccesstrustproviders",
                "describevpcendpointconnectionnotifications",
                "describeinstancestatus",
                "describevpcendpointserviceconfigurations",
                "describevpcs",
                "describeipamscopes",
                "describeaddressesattribute",
                "describesecuritygroups",
                "describeipampools",
                "describetags",
                "describetrafficmirrortargets",
                "describetransitgatewayvpcattachments",
                "describescalabletargets",
                "describevpcblockpublicaccessexclusions",
                "describevpnconnections",
                "getinstancemetadatadefaults",
                "describeaddresses",
                "describeipamresourcediscoveries",
                "describehostreservations",
                "describevpcblockpublicaccessoptions",
                "getallowedimagessettings",
                "describeaccountlimits",
                "describesubnets",
                "describeverifiedaccessgroups",
                "describeautoscalinginstances",
                "describecapacityreservations",
                "describelaunchtemplateversions",
                "describereservedinstances",
                "describeautoscalinggroups",
                "describesecuritygrouprules",
                "describenetworkinsightsanalyses",
                "describespotfleetrequests",
                "describevpcendpoints",
                "describeregions",
                "getimageblockpublicaccessstate",
                "getebsencryptionbydefault",
                "describefpgaimages",
                "describenetworkinsightspaths",
                "describescalingpolicies",
                "describecoippools",
                "describetransitgatewayroutetableannouncements",
                "describecapacityreservationfleets",
                "describeinternetgateways",
                "describetransitgatewayconnectpeers",
                "describeinstancetypes",
                "describelaunchconfigurations",
                "describenetworkinterfaces",
                "describelocalgatewayroutetables",
                "describenatgateways",
                "describetransitgatewayattachments",
                "describeplacementgroups",
                "describeinstances",
                "describenetworkinsightsaccessscopeanalyses"
            ],
            "RDS": [
                "describedbsnapshots",
                "describereserveddbinstances",
                "describedbinstances",
                "describeoptiongroups",
                "describedbclusters",
                "describedbsecuritygroups",
                "describeaccountattributes",
                "describedbclusterparametergroups",
                "describedbclustersnapshots",
                "describedbclusterendpoints",
                "describedbinstanceautomatedbackups",
                "describebluegreendeployments",
                "describeeventsubscriptions",
                "describeglobalclusters",
                "describependingmaintenanceactions",
                "describedbsubnetgroups"
            ],
            "CLOUDFORMATION": [
                "gettemplatesummary",
                "listtypes",
                "getstackpolicy",
                "describeorganizationsaccess",
                "listchangesets",
                "liststacks",
                "liststackresources",
                "gettemplate",
                "describeaccountlimits",
                "stackinstanceoperations",
                "liststacksets",
                "describestacks"
            ],
            "MEMORYDB": [
                "describeacls",
                "describesnapshots",
                "describeusers",
                "describesubnetgroups",
                "describeclusters",
                "describeparametergroups"
            ],
            "SES": [
                "getaccount",
                "listreceiptfilters",
                "listemailtemplates",
                "listreceiptrulesets",
                "listemailidentities",
                "describeactivereceiptruleset",
                "listconfigurationsets",
                "listcontactlists"
            ],
            "CLOUDWATCH": [
                "getmetricdata",
                "getmetricstatistics",
                "describeinsightrules",
                "listapplications",
                "listtagsforresource",
                "listmetrics",
                "describealarms"
            ],
            "ELASTIC": [
                "describeenvironments",
                "describesslpolicies",
                "describetargetgroups",
                "describeapplications",
                "describeapplicationversions"
            ],
            "BACKUP": [
                "listtags",
                "listrecoverypointsbybackupvault",
                "listbackupplans",
                "describebackupvault",
                "getbackupvaultaccesspolicy"
            ],
            "CLOUDHSM": [
                "describeclusters"
            ],
            "REDSHIFT": [
                "describeclustersnapshots",
                "describeendpointaccess",
                "describesnapshotschedules",
                "describeendpointauthorization",
                "describeclustersecuritygroups",
                "describeclusters",
                "describeclustersubnetgroups",
                "describeeventsubscriptions",
                "describeusagelimits",
                "describereservednodes"
            ],
            "AWS": [
                "listdatastores",
                "describecompliancebyresource",
                "getcompliancedetailsbyconfigrule",
                "listdeploymentstrategies",
                "describeconfigurationrecorders",
                "getresourcepolicy",
                "getdiscoveredresourcecounts",
                "getdeploymentstrategy",
                "listdomains",
                "describeremediationconfigurations",
                "selectresourceconfig",
                "describeconfigruleevaluationstatus",
                "getdatabases",
                "describependingaggregationrequests",
                "listdiscoveredresources",
                "listrepositories",
                "putevaluations",
                "describeconfigrules",
                "listconfigurationrecorders",
                "describeconfigurationrecorderstatus",
                "describecompliancebyconfigrule",
                "listnotificationhubs",
                "listapplications",
                "listtagsforresource",
                "listextensionassociations"
            ],
            "BATCH": [
                "describecomputeenvironments",
                "describejobdefinitions",
                "listschedulingpolicies",
                "describejobqueues"
            ],
            "KMS": [
                "describekey",
                "listkeys",
                "listresourcetags",
                "keysperaccount",
                "describecustomkeystores",
                "listkeyrotations",
                "getkeypolicy",
                "listgrants",
                "listaliases"
            ],
            "DIRECTORY": [
                "describedirectories"
            ],
            "SSM": [
                "getparameter",
                "describeparameters",
                "listassociations",
                "describemaintenancewindows",
                "listdocuments",
                "describedocument",
                "describeinstanceinformation",
                "describedocumentpermission",
                "getservicesetting",
                "listresourcedatasync"
            ],
            "EVENTBRIDGE": [
                "describeeventbus",
                "listrules",
                "listtargetsbyrule",
                "listapidestinations",
                "listeventbuses",
                "listarchives",
                "listtagsforresource",
                "listendpoints"
            ],
            "DATABASE": [
                "describereplicationsubnetgroups",
                "describereplicationinstances",
                "describeeventsubscriptions"
            ],
            "GAMELIFT": [
                "describematchmakingconfigurations",
                "describegamesessionqueues",
                "describefleetattributes",
                "listgameservergroups",
                "listlocations",
                "listaliases"
            ],
            "APPSTREAM": [
                "describeimagebuilders",
                "describestacks",
                "describefleets"
            ],
            "KINESIS": [
                "listsignalingchannels",
                "liststreams",
                "listapplications",
                "describelimits"
            ],
            "ECR": [
                "describeregistry",
                "getregistryscanningconfiguration",
                "describepullthroughcacherules",
                "describerepositories",
                "getregistrypolicy",
                "getaccountsetting"
            ],
            "SECRETS": [
                "getsecretvalue",
                "listsecrets",
                "describesecret"
            ],
            "SECURITY": [
                "listmembers",
                "describestandardscontrols",
                "getenabledstandards",
                "getfindings",
                "getadministratoraccount",
                "listtagsforresource",
                "listinvitations",
                "listenabledproductsforimport"
            ],
            "WORKSPACES": [
                "describeworkspaces"
            ],
            "COMPUTEOPTIMIZER": [
                "exportlambdafunctionrecommendations",
                "exportec2instancerecommendations",
                "getrecommendationsummaries",
                "exportlicenserecommendations",
                "getenrollmentstatus",
                "exportecsservicerecommendations",
                "exportautoscalinggrouprecommendations",
                "exportrdsdatabaserecommendations",
                "getrdsdatabaserecommendations",
                "exportebsvolumerecommendations"
            ],
            "RESOURCE": [
                "getresources",
                "getresourceshares",
                "getaccountsettings",
                "listgroups"
            ],
            "LAMBDA": [
                "listversionsbyfunction20150331",
                "listlayers20181031",
                "getfunctionurlconfig",
                "getaccountsettings20160819",
                "listcodesigningconfigs",
                "listfunctions20150331",
                "getpolicy20150331",
                "listfunctionurlconfigs",
                "getfunction20150331v2"
            ],
            "AUDIT": [
                "getaccountstatus"
            ],
            "API": [
                "getdomainnames",
                "getvpclinks",
                "getapis"
            ],
            "PINPOINT": [
                "getapps",
                "listtemplates"
            ],
            "EMR": [
                "listsecurityconfigurations",
                "getblockpublicaccessconfiguration",
                "listclusters",
                "listvirtualclusters",
                "listapplications"
            ],
            "AMAZON": [
                "listvaults",
                "listsecurityconfigurations",
                "listdatasets",
                "getblockpublicaccessconfiguration",
                "listorganizations",
                "listclusters",
                "listbots"
            ],
            "LIGHTSAIL": [
                "getcertificates",
                "getstaticips",
                "getblueprints",
                "getbuckets",
                "getcontainerservices",
                "getrelationaldatabases"
            ],
            "S3": [
                "getbucketcors",
                "listmultiregionaccesspoints",
                "getbucketownershipcontrols",
                "getbucketlocation",
                "getbucketacl",
                "getbucketversioning",
                "getbucketobjectlockconfiguration",
                "getbucketlogging",
                "getbucketwebsite",
                "getbucketencryption",
                "getbucketreplication",
                "getbucketrequestpayment",
                "getbucketnotification",
                "getbucketlifecycle",
                "listaccesspoints",
                "liststoragelensgroups",
                "listbuckets",
                "getbucketintelligenttieringconfiguration",
                "getbucketmetricsconfiguration"
            ],
            "ATHENA": [
                "getdatacatalog",
                "listpreparedstatements",
                "getworkgroup",
                "listtagsforresource",
                "listworkgroups",
                "listdatacatalogs"
            ],
            "GUARDDUTY": [
                "listmembers",
                "listdetectors",
                "listpublishingdestinations",
                "getdetector",
                "getinvitationscount",
                "getmalwarescansettings",
                "getmasteraccount",
                "listfilters",
                "listthreatintelsets"
            ],
            "FRAUD": [
                "getdetectors",
                "getentitytypes",
                "getexternalmodels",
                "getvariables",
                "getoutcomes",
                "geteventtypes"
            ],
            "X_RAY": [
                "getencryptionconfig"
            ],
            "DATA": [
                "listdatasets",
                "getlifecyclepolicies"
            ],
            "MACIE": [
                "getmaciesession"
            ],
            "ROUTE": [
                "listresolverquerylogconfigs",
                "listfirewalldomainlists",
                "listresolverendpoints",
                "getresolverrule"
            ],
            "SERVICE": [
                "getservicequota",
                "listapplications",
                "listattributegroups"
            ],
            "SNS": [
                "gettopicattributes",
                "listsubscriptions",
                "numberofmessagespublishedperaccount",
                "listtagsforresource",
                "listsubscriptionsbytopic"
            ],
            "BEDROCK": [
                "listagents"
            ],
            "IOT": [
                "listinputs",
                "listrolealiases",
                "listcertificates",
                "listcustommetrics",
                "listalarmmodels",
                "listserviceprofiles",
                "listworkspaces",
                "listfleetmetrics",
                "listdetectormodels",
                "listthings",
                "listpolicies",
                "listassetmodels",
                "listcacertificates",
                "listdimensions",
                "listfuotatasks",
                "listmitigationactions",
                "listsecurityprofiles",
                "listtopicruledestinations",
                "listgateways",
                "listscheduledaudits",
                "listportals",
                "listmulticastgroups"
            ],
            "ACCESS": [
                "listanalyzers",
                "listarchiverules"
            ],
            "APPINTEGRATIONS": [
                "listapplications",
                "listeventintegrations"
            ],
            "MEDIACONNECT": [
                "listgateways",
                "listflows",
                "listbridges"
            ],
            "TRANSCRIBE": [
                "listcallanalyticsjobs",
                "listvocabularies",
                "listmedicaltranscriptionjobs",
                "listmedicalvocabularies",
                "listmedicalscribejobs",
                "listlanguagemodels"
            ],
            "PRIVATE": [
                "listcertificateauthorities"
            ],
            "CERTIFICATE": [
                "listcertificates"
            ],
            "TRANSFER": [
                "listservers",
                "listprofiles",
                "listcertificates",
                "listworkflows"
            ],
            "EKS": [
                "listclusters"
            ],
            "SAGEMAKER": [
                "listfeaturegroups",
                "listworkteams",
                "listpipelines",
                "listnotebookinstancelifecycleconfigs",
                "listcoderepositories",
                "listendpointconfigs",
                "listdomains",
                "listendpoints",
                "listimages",
                "listinferenceexperiments"
            ],
            "CLEAN": [
                "listcollaborations"
            ],
            "GREENGRASS": [
                "listfunctiondefinitions",
                "listcomponents",
                "listresourcedefinitions",
                "listdevicedefinitions",
                "listloggerdefinitions",
                "listgroups",
                "listconnectordefinitions"
            ],
            "IMAGE": [
                "listinfrastructureconfigurations",
                "listcomponents",
                "listimagerecipes",
                "listdistributionconfigurations",
                "listimages",
                "listcontainerrecipes"
            ],
            "GROUND": [
                "listmissionprofiles",
                "listconfigs"
            ],
            "MEDIASTORE": [
                "listcontainers"
            ],
            "DATABREW": [
                "listdatasets",
                "listrulesets",
                "listprojects",
                "listschedules",
                "listrecipes"
            ],
            "COMPREHEND": [
                "listeventsdetectionjobs",
                "listpiientitiesdetectionjobs",
                "listdominantlanguagedetectionjobs",
                "listentityrecognizers",
                "listsentimentdetectionjobs",
                "listdocumentclassifiers",
                "listflywheels",
                "listkeyphrasesdetectionjobs",
                "listtopicsdetectionjobs",
                "listentitiesdetectionjobs"
            ],
            "CUSTOMER": [
                "listdomains"
            ],
            "NETWORK": [
                "listfirewallpolicies",
                "listfirewalls"
            ],
            "APPFLOW": [
                "listflows"
            ],
            "NEPTUNEGRAPH": [
                "listgraphsnapshots",
                "listgraphs"
            ],
            "DETECTIVE": [
                "listgraphs"
            ],
            "CONNECT": [
                "listinstances",
                "listphonenumbersv2"
            ],
            "QLDB": [
                "listledgers"
            ],
            "IVSCHAT": [
                "listloggingconfigurations"
            ],
            "LOCATION": [
                "listtrackers",
                "listmaps"
            ],
            "CODESTAR": [
                "listnotificationrules"
            ],
            "TRANSLATE": [
                "listterminologies",
                "listparalleldata",
                "listtexttranslationjobs"
            ],
            "CODEPIPELINE": [
                "listpipelines"
            ],
            "MEDIATAILOR": [
                "listplaybackconfigurations"
            ],
            "IVS": [
                "listrecordingconfigurations",
                "listplaybackkeypairs"
            ],
            "MEDIACONVERT": [
                "listpresets"
            ],
            "LOOKOUT": [
                "listprojects"
            ],
            "CODEBUILD": [
                "listreportgroups",
                "listprojects"
            ],
            "CODECOMMIT": [
                "listrepositories"
            ],
            "ROBOMAKER": [
                "listsimulationapplications",
                "listrobotapplications"
            ],
            "SCHEDULER": [
                "listschedules",
                "listschedulegroups"
            ],
            "CLOUD": [
                "listservices"
            ],
            "OUTPOSTS": [
                "listsites"
            ],
            "ECS": [
                "listtagsforresource"
            ],
            "DATASYNC": [
                "listtasks"
            ],
            "COGNITO": [
                "userpoolread",
                "listuserpools"
            ],
            "GRAFANA": [
                "listworkspaces"
            ]
        }

        self._services = CloudWatchAWSServicesMap()

    def get(self, operation_name: CloudWatchAPIOperationName):
        return self._api_ops_map[operation_name]
    
    def get_by_slug(self, operation_slug: str):
        return self._api_ops_slug_map[operation_slug]
    
    def get_api_operation_slug(self, operation: CloudWatchAPIOperationValue):
        return self._api_ops_reverse_map[operation]
    
    def get_service_operations(self, service_name: CloudWatchServiceName) -> list[CloudWatchAPIOperationName]:
        service = self._services.get(service_name)
        return self._service_api_ops_map.get(service.name, [])
